/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin;

import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.DefaultCairoConfiguration;
import com.questdb.cairo.Engine;
import com.questdb.cairo.TableModel;
import com.questdb.cairo.sql.CairoEngine;
import com.questdb.griffin.AbstractGriffinTest;
import com.questdb.griffin.SqlCompiler;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.SqlExecutionContext;
import com.questdb.griffin.model.ExecutionModel;
import com.questdb.griffin.model.QueryModel;
import com.questdb.std.Chars;
import com.questdb.std.Files;
import com.questdb.std.FilesFacade;
import com.questdb.std.FilesFacadeImpl;
import com.questdb.std.Sinkable;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.Path;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class SqlParserTest
extends AbstractGriffinTest {
    @Test
    public void testAliasWithSpace() throws Exception {
        this.assertQuery("select-choose x from (x 'b a' where x > 1)", "x 'b a' where x > 1", this.modelOf("x").col("x", 3));
    }

    @Test
    public void testAliasWithSpaceX() {
        SqlParserTest.assertSyntaxError("from x 'a b' where x > 1", 7, "unexpected", new TableModel[0]);
    }

    @Test
    public void testAmbiguousColumn() {
        SqlParserTest.assertSyntaxError("orders join customers on customerId = customerId", 25, "Ambiguous", this.modelOf("orders").col("customerId", 3), this.modelOf("customers").col("customerId", 3));
    }

    @Test
    public void testAnalyticOrderDirection() throws Exception {
        this.assertQuery("select-analytic a, b, f(c) my over (partition by b order by ts desc, x, y) from (xyz)", "select a,b, f(c) my over (partition by b order by ts desc, x asc, y) from xyz", this.modelOf("xyz").col("a", 3).col("b", 3).col("c", 3).col("x", 3).col("y", 3).col("z", 3));
    }

    @Test
    public void testAnalyticPartitionByMultiple() throws Exception {
        this.assertQuery("select-analytic a, b, f(c) my over (partition by b, a order by ts), d(c) d over () from (xyz)", "select a,b, f(c) my over (partition by b, a order by ts), d(c) over() from xyz", this.modelOf("xyz").col("c", 3).col("b", 3).col("a", 3));
    }

    @Test
    public void testAsOfJoin() throws SqlException {
        this.assertQuery("select-choose t.timestamp timestamp, t.tag tag, q.timestamp timestamp1 from (trades t timestamp (timestamp) asof join quotes q timestamp (timestamp) post-join-where tag = null)", "trades t asof join quotes q where tag = null", this.modelOf("trades").timestamp().col("tag", 8), this.modelOf("quotes").timestamp());
    }

    @Test
    public void testAsOfJoinColumnAliasNull() throws SqlException {
        this.assertQuery("select-choose customerId, kk, count from ((select-group-by customerId, kk, count() count from (select-choose c.customerId customerId, o.customerId kk from (customers c asof join orders o on o.customerId = c.customerId post-join-where o.customerId = null))) _xQdbA1 limit 10)", "(select c.customerId, o.customerId kk, count() from customers c asof join orders o on c.customerId = o.customerId)  where kk = null limit 10", this.modelOf("customers").col("customerId", 3), this.modelOf("orders").col("customerId", 3));
    }

    @Test
    public void testAsOfJoinOrder() throws Exception {
        this.assertQuery("select-choose c.customerId customerId, e.employeeId employeeId, o.customerId customerId1 from (customers c asof join employees e on e.employeeId = c.customerId join orders o on o.customerId = c.customerId)", "customers c asof join employees e on c.customerId = e.employeeId join orders o on c.customerId = o.customerId", this.modelOf("customers").col("customerId", 8), this.modelOf("employees").col("employeeId", 7), this.modelOf("orders").col("customerId", 8));
    }

    @Test
    public void testAsOfJoinSubQuery() throws Exception {
        this.assertQuery("select-choose c.customerId customerId, e.blah blah, e.lastName lastName, e.employeeId employeeId, e.timestamp timestamp, o.customerId customerId1 from (customers c asof join (select-virtual '1' blah, lastName, employeeId, timestamp from (employees) order by lastName) e on e.employeeId = c.customerId post-join-where e.lastName = 'x' and e.blah = 'y' join orders o on o.customerId = c.customerId)", "customers c asof join (select '1' blah, lastName, employeeId, timestamp from employees order by lastName) e on c.customerId = e.employeeId join orders o on c.customerId = o.customerId where e.lastName = 'x' and e.blah = 'y'", this.modelOf("customers").col("customerId", 8), this.modelOf("employees").col("employeeId", 7).col("lastName", 7).col("timestamp", 12), this.modelOf("orders").col("customerId", 8));
    }

    @Test
    public void testAsOfJoinSubQuerySimpleAlias() throws Exception {
        this.assertQuery("select-choose c.customerId customerId, a.blah blah, a.lastName lastName, a.customerId customerId1, a.timestamp timestamp from (customers c asof join (select-virtual '1' blah, lastName, customerId, timestamp from (select-choose lastName, employeeId customerId, timestamp from (employees)) order by lastName) a on a.customerId = c.customerId)", "customers c asof join (select '1' blah, lastName, employeeId customerId, timestamp from employees order by lastName) a on (customerId)", this.modelOf("customers").col("customerId", 8), this.modelOf("employees").col("employeeId", 7).col("lastName", 7).col("timestamp", 12));
    }

    @Test
    public void testAsOfJoinSubQuerySimpleNoAlias() throws Exception {
        this.assertQuery("select-choose c.customerId customerId, _xQdbA1.blah blah, _xQdbA1.lastName lastName, _xQdbA1.customerId customerId1, _xQdbA1.timestamp timestamp from (customers c asof join (select-virtual '1' blah, lastName, customerId, timestamp from (select-choose lastName, employeeId customerId, timestamp from (employees)) order by lastName) _xQdbA1 on _xQdbA1.customerId = c.customerId)", "customers c asof join (select '1' blah, lastName, employeeId customerId, timestamp from employees order by lastName) on (customerId)", this.modelOf("customers").col("customerId", 8), this.modelOf("employees").col("employeeId", 7).col("lastName", 7).col("timestamp", 12));
    }

    @Test
    public void testBlockCommentAtMiddle() throws Exception {
        this.assertQuery("select-choose x, a from ((x where a > 1 and x > 1) 'b a')", "(x where /*this is a random comment */a > 1) 'b a' where x > 1", this.modelOf("x").col("x", 3).col("a", 3));
    }

    @Test
    public void testBlockCommentNested() throws Exception {
        this.assertQuery("select-choose x, a from ((x where a > 1 and x > 1) 'b a')", "(x where a > 1) /* comment /* ok */  whatever */'b a' where x > 1", this.modelOf("x").col("x", 3).col("a", 3));
    }

    @Test
    public void testBlockCommentUnclosed() throws Exception {
        this.assertQuery("select-choose x, a from ((x where a > 1 and x > 1) 'b a')", "(x where a > 1) 'b a' where x > 1 /* this block comment", this.modelOf("x").col("x", 3).col("a", 3));
    }

    @Test
    public void testCaseImpossibleRewrite1() throws SqlException {
        this.assertQuery("select-virtual case(a = 1,'A',2 = b,'B','C') + 1 column, b from (tab)", "select case when a = 1 then 'A' when 2 = b then 'B' else 'C' end+1, b from tab", this.modelOf("tab").col("a", 3).col("b", 3));
    }

    @Test
    public void testCaseImpossibleRewrite2() throws SqlException {
        this.assertQuery("select-virtual case(a = 1,'A',2 + b = a,'B','C') + 1 column, b from (tab)", "select case when a = 1 then 'A' when 2 + b = a then 'B' else 'C' end+1, b from tab", this.modelOf("tab").col("a", 3).col("b", 3));
    }

    @Test
    public void testCaseNoElseClause() throws SqlException {
        this.assertQuery("select-virtual case(a = 1,'A',2 = b,'B') + 1 column, b from (tab)", "select case when a = 1 then 'A' when 2 = b then 'B' end+1, b from tab", this.modelOf("tab").col("a", 3).col("b", 3));
    }

    @Test
    public void testCaseToSwitchExpression() throws SqlException {
        this.assertQuery("select-virtual switch(a,1,'A',2,'B','C') + 1 column, b from (tab)", "select case when a = 1 then 'A' when a = 2 then 'B' else 'C' end+1, b from tab", this.modelOf("tab").col("a", 3).col("b", 3));
    }

    @Test
    public void testCaseToSwitchExpression2() throws SqlException {
        this.assertQuery("select-virtual switch(a,1,'A',2,'B','C') + 1 column, b from (tab)", "select case when a = 1 then 'A' when 2 = a then 'B' else 'C' end+1, b from tab", this.modelOf("tab").col("a", 3).col("b", 3));
    }

    @Test
    public void testConsistentColumnOrder() throws SqlException {
        this.assertQuery("select-choose rnd_int, rnd_int1, rnd_boolean, rnd_str, rnd_double, rnd_float, rnd_short, rnd_short1, rnd_date, rnd_timestamp, rnd_symbol, rnd_long, rnd_long1, ts, rnd_byte, rnd_bin from ((select-virtual rnd_int() rnd_int, rnd_int(0,30,2) rnd_int1, rnd_boolean() rnd_boolean, rnd_str(3,3,2) rnd_str, rnd_double(2) rnd_double, rnd_float(2) rnd_float, rnd_short(10,1024) rnd_short, rnd_short() rnd_short1, rnd_date(to_date('2015','yyyy'),to_date('2016','yyyy'),2) rnd_date, rnd_timestamp(to_timestamp('2015','yyyy'),to_timestamp('2016','yyyy'),2) rnd_timestamp, rnd_symbol(4,4,4,2) rnd_symbol, rnd_long(100,200,2) rnd_long, rnd_long() rnd_long1, timestamp_sequence(to_timestamp(0),1000000000) ts, rnd_byte(2,50) rnd_byte, rnd_bin(10,20,2) rnd_bin from (long_sequence(20))) _xQdbA1)", "select * from (select rnd_int(), rnd_int(0, 30, 2), rnd_boolean(), rnd_str(3,3,2), rnd_double(2), rnd_float(2), rnd_short(10,1024), rnd_short(), rnd_date(to_date('2015', 'yyyy'), to_date('2016', 'yyyy'), 2), rnd_timestamp(to_timestamp('2015', 'yyyy'), to_timestamp('2016', 'yyyy'), 2), rnd_symbol(4,4,4,2), rnd_long(100,200,2), rnd_long(), timestamp_sequence(to_timestamp(0), 1000000000) ts, rnd_byte(2,50), rnd_bin(10, 20, 2) from long_sequence(20))", new TableModel[0]);
    }

    @Test
    public void testConstantFunctionAsArg() throws Exception {
        this.assertQuery("select-choose customerId from (customers where f(1.2) > 1)", "select * from customers where f(1.2) > 1", this.modelOf("customers").col("customerId", 3));
    }

    @Test
    public void testCount() throws Exception {
        this.assertQuery("select-group-by customerId, count() count from (select-choose c.customerId customerId from (customers c outer join orders o on o.customerId = c.customerId post-join-where o.customerId = NaN))", "select c.customerId, count() from customers c outer join orders o on c.customerId = o.customerId  where o.customerId = NaN", this.modelOf("customers").col("customerId", 3).col("customerName", 7), this.modelOf("orders").col("customerId", 3).col("product", 7));
    }

    @Test
    public void testCreateAsSelectInvalidIndex() {
        SqlParserTest.assertSyntaxError("create table X as ( select a, b, c from tab ), index(x)", 53, "Invalid column", this.modelOf("tab").col("a", 3).col("b", 6).col("c", 7));
    }

    @Test
    public void testCreateNameWithDot() {
        SqlParserTest.assertSyntaxError("create table X.y as ( select a, b, c from tab )", 13, "'.' is not allowed here", this.modelOf("tab").col("a", 3).col("b", 6).col("c", 7));
    }

    @Test
    public void testCreateTable() throws SqlException {
        this.assertCreateTable("create table x (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL capacity 128 cache, z STRING, y BOOLEAN) timestamp(t) partition by MONTH", "create table x (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL, z STRING, y BOOLEAN) timestamp(t) partition by MONTH", new TableModel[0]);
    }

    @Test
    public void testCreateTableAsSelect() throws SqlException {
        this.assertCreateTable("create table X as (select-choose a, b, c from (tab))", "create table X as ( select a, b, c from tab )", this.modelOf("tab").col("a", 3).col("b", 6).col("c", 7));
    }

    @Test
    public void testCreateTableAsSelectIndex() throws SqlException {
        this.assertCreateTable("create table X as (select-choose a, b, c from (tab)), index(b capacity 256)", "create table X as ( select a, b, c from tab ), index(b)", this.modelOf("tab").col("a", 3).col("b", 6).col("c", 7));
    }

    @Test
    public void testCreateTableAsSelectIndexCapacity() throws SqlException {
        this.assertCreateTable("create table X as (select-choose a, b, c from (tab)), index(b capacity 64)", "create table X as ( select a, b, c from tab ), index(b capacity 64)", this.modelOf("tab").col("a", 3).col("b", 6).col("c", 7));
    }

    @Test
    public void testCreateTableAsSelectTimestamp() throws SqlException {
        this.assertCreateTable("create table X as (select-choose a, b, c from (tab)) timestamp(b)", "create table X as ( select a, b, c from tab ) timestamp(b)", this.modelOf("tab").col("a", 3).col("b", 6).col("c", 7));
    }

    @Test
    public void testCreateTableBadColumnDef() {
        SqlParserTest.assertSyntaxError("create table x (a INT, b BYTE, g DATE, h BINARY, t TIMESTAMP blah, x SYMBOL index, z STRING, bool BOOLEAN) timestamp(t) partition by YEAR index", 61, "',' or ')' expected", new TableModel[0]);
    }

    @Test
    public void testCreateTableCacheCapacity() throws SqlException {
        this.assertCreateTable("create table x (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL capacity 64 cache, z STRING, y BOOLEAN) timestamp(t) partition by YEAR", "create table x (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL capacity 64 cache, z STRING, y BOOLEAN) timestamp(t) partition by YEAR", new TableModel[0]);
    }

    @Test
    public void testCreateTableCastCapacityDef() throws SqlException {
        this.assertCreateTable("create table x as (select-choose a, b, c from (tab)), cast(a as DOUBLE:35), cast(c as SYMBOL:54 capacity 16 cache)", "create table x as (tab), cast(a as double), cast(c as symbol capacity 16)", this.modelOf("tab").col("a", 3).col("b", 4).col("c", 7));
    }

    @Test
    public void testCreateTableCastDef() throws SqlException {
        this.assertCreateTable("create table x as (select-choose a, b, c from (tab)), cast(a as DOUBLE:35), cast(c as SYMBOL:54 capacity 128 cache)", "create table x as (tab), cast(a as double), cast(c as symbol)", this.modelOf("tab").col("a", 3).col("b", 4).col("c", 7));
    }

    @Test
    public void testCreateTableCastDefSymbolCapacityHigh() {
        SqlParserTest.assertSyntaxError("create table x as (tab), cast(a as double), cast(c as symbol capacity 1100000000)", 70, "max symbol capacity is", this.modelOf("tab").col("a", 3).col("b", 4).col("c", 7));
    }

    @Test
    public void testCreateTableCastDefSymbolCapacityLow() {
        SqlParserTest.assertSyntaxError("create table x as (tab), cast(a as double), cast(c as symbol capacity -10)", 70, "min symbol capacity is", this.modelOf("tab").col("a", 3).col("b", 4).col("c", 7));
    }

    @Test
    public void testCreateTableCastIndexCapacityHigh() {
        SqlParserTest.assertSyntaxError("create table x as (tab), cast(a as double), cast(c as symbol capacity 20 nocache index capacity 100000000)", 96, "max index block capacity is", this.modelOf("tab").col("a", 3).col("b", 4).col("c", 7));
    }

    @Test
    public void testCreateTableCastIndexCapacityLow() {
        SqlParserTest.assertSyntaxError("create table x as (tab), cast(a as double), cast(c as symbol capacity 20 nocache index capacity 1)", 96, "min index block capacity is", this.modelOf("tab").col("a", 3).col("b", 4).col("c", 7));
    }

    @Test
    public void testCreateTableCastIndexDef() throws SqlException {
        this.assertCreateTable("create table x as (select-choose a, b, c from (tab)), cast(a as DOUBLE:35), cast(c as SYMBOL:54 capacity 32 nocache index capacity 512)", "create table x as (tab), cast(a as double), cast(c as symbol capacity 20 nocache index capacity 300)", this.modelOf("tab").col("a", 3).col("b", 4).col("c", 7));
    }

    @Test
    public void testCreateTableCastIndexInvalidCapacity() {
        SqlParserTest.assertSyntaxError("create table x as (tab), cast(a as double), cast(c as symbol capacity 20 nocache index capacity -)", 97, "bad integer", this.modelOf("tab").col("a", 3).col("b", 4).col("c", 7));
    }

    @Test
    public void testCreateTableCastIndexNegativeCapacity() {
        SqlParserTest.assertSyntaxError("create table x as (tab), cast(a as double), cast(c as symbol capacity 20 nocache index capacity -3)", 96, "min index block capacity is", this.modelOf("tab").col("a", 3).col("b", 4).col("c", 7));
    }

    @Test
    public void testCreateTableCastRoundedSymbolCapacityDef() throws SqlException {
        this.assertCreateTable("create table x as (select-choose a, b, c from (tab)), cast(a as DOUBLE:35), cast(c as SYMBOL:54 capacity 32 cache)", "create table x as (tab), cast(a as double), cast(c as symbol capacity 20)", this.modelOf("tab").col("a", 3).col("b", 4).col("c", 7));
    }

    @Test
    public void testCreateTableCastUnsupportedType() {
        SqlParserTest.assertSyntaxError("create table x as (tab), cast(b as integer)", 35, "unsupported column type", this.modelOf("tab").col("a", 3).col("b", 4).col("c", 7));
    }

    @Test
    public void testCreateTableDuplicateCast() {
        SqlParserTest.assertSyntaxError("create table x as (tab), cast(b as double), cast(b as long)", 49, "duplicate cast", this.modelOf("tab").col("a", 3).col("b", 4).col("c", 7));
    }

    @Test
    public void testCreateTableDuplicateColumn() {
        SqlParserTest.assertSyntaxError("create table x (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL index, z STRING, t BOOLEAN) timestamp(t) partition by YEAR", 122, "Duplicate column", new TableModel[0]);
    }

    @Test
    public void testCreateTableInPlaceIndex() throws SqlException {
        this.assertCreateTable("create table x (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL capacity 128 cache index capacity 256, z STRING, y BOOLEAN) timestamp(t) partition by YEAR", "create table x (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL index, z STRING, y BOOLEAN) timestamp(t) partition by YEAR", new TableModel[0]);
    }

    @Test
    public void testCreateTableInPlaceIndexAndBlockSize() throws SqlException {
        this.assertCreateTable("create table x (a INT, b BYTE, c SHORT, t TIMESTAMP, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, x SYMBOL capacity 128 cache index capacity 128, z STRING, y BOOLEAN) timestamp(t) partition by MONTH", "create table x (a INT, b BYTE, c SHORT, t TIMESTAMP, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, x SYMBOL index capacity 128, z STRING, y BOOLEAN) timestamp(t) partition by MONTH", new TableModel[0]);
    }

    @Test
    public void testCreateTableInPlaceIndexCapacityHigh() {
        SqlParserTest.assertSyntaxError("create table x (a INT, b BYTE, c SHORT, t TIMESTAMP, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, x SYMBOL index capacity 10000000, z STRING, y BOOLEAN) timestamp(t) partition by MONTH", 122, "max index block capacity is", new TableModel[0]);
    }

    @Test
    public void testCreateTableInPlaceIndexCapacityInvalid() {
        SqlParserTest.assertSyntaxError("create table x (a INT, b BYTE, c SHORT, t TIMESTAMP, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, x SYMBOL index capacity -, z STRING, y BOOLEAN) timestamp(t) partition by MONTH", 123, "bad integer", new TableModel[0]);
    }

    @Test
    public void testCreateTableInPlaceIndexCapacityLow() {
        SqlParserTest.assertSyntaxError("create table x (a INT, b BYTE, c SHORT, t TIMESTAMP, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, x SYMBOL index capacity 2, z STRING, y BOOLEAN) timestamp(t) partition by MONTH", 122, "min index block capacity is", new TableModel[0]);
    }

    @Test
    public void testCreateTableInPlaceIndexCapacityLow2() {
        SqlParserTest.assertSyntaxError("create table x (a INT, b BYTE, c SHORT, t TIMESTAMP, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, x SYMBOL index capacity -9, z STRING, y BOOLEAN) timestamp(t) partition by MONTH", 122, "min index block capacity is", new TableModel[0]);
    }

    @Test
    public void testCreateTableInPlaceIndexCapacityRounding() throws SqlException {
        this.assertCreateTable("create table x (a INT, b BYTE, c SHORT, t TIMESTAMP, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, x SYMBOL capacity 128 cache index capacity 128, z STRING, y BOOLEAN) timestamp(t) partition by MONTH", "create table x (a INT, b BYTE, c SHORT, t TIMESTAMP, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, x SYMBOL index capacity 120, z STRING, y BOOLEAN) timestamp(t) partition by MONTH", new TableModel[0]);
    }

    @Test
    public void testCreateTableInvalidCapacity() {
        SqlParserTest.assertSyntaxError("create table x (a symbol capacity z)", 34, "bad integer", new TableModel[0]);
    }

    @Test
    public void testCreateTableInvalidColumnInIndex() {
        SqlParserTest.assertSyntaxError("create table x (a INT, b BYTE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL index, z STRING, bool BOOLEAN), index(k) timestamp(t) partition by YEAR", 109, "Invalid column", new TableModel[0]);
    }

    @Test
    public void testCreateTableInvalidColumnType() {
        SqlParserTest.assertSyntaxError("create table tab (a int, b integer)", 27, "unsupported column type", new TableModel[0]);
    }

    @Test
    public void testCreateTableInvalidPartitionBy() {
        SqlParserTest.assertSyntaxError("create table x (a INT, b BYTE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL index, z STRING, bool BOOLEAN) timestamp(t) partition by EPOCH", 128, "'NONE', 'DAY', 'MONTH' or 'YEAR' expected", new TableModel[0]);
    }

    @Test
    public void testCreateTableInvalidTimestampColumn() {
        SqlParserTest.assertSyntaxError("create table x (a INT, b BYTE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL index, z STRING, bool BOOLEAN) timestamp(zyz) partition by YEAR", 112, "Invalid column", new TableModel[0]);
    }

    @Test
    public void testCreateTableMisplacedCastCapacity() {
        SqlParserTest.assertSyntaxError("create table x as (tab), cast(a as double capacity 16)", 42, "')' expected", this.modelOf("tab").col("a", 3).col("b", 4).col("c", 7));
    }

    @Test
    public void testCreateTableMisplacedCastDef() {
        SqlParserTest.assertSyntaxError("create table tab (a int, b long), cast (a as double)", 34, "cast is only supported", new TableModel[0]);
    }

    @Test
    public void testCreateTableMissingColumnDef() {
        SqlParserTest.assertSyntaxError("create table x (a INT, b BYTE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL index, z STRING, bool BOOLEAN, ) timestamp(t) partition by YEAR index", 102, "missing column definition", new TableModel[0]);
    }

    @Test
    public void testCreateTableMissingDef() {
        SqlParserTest.assertSyntaxError("create table xyx", 16, "'(' or 'as' expected", new TableModel[0]);
    }

    @Test
    public void testCreateTableMissingName() {
        SqlParserTest.assertSyntaxError("create table ", 13, "table name expected", new TableModel[0]);
    }

    @Test
    public void testCreateTableNoCache() throws SqlException {
        this.assertCreateTable("create table x (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL capacity 128 nocache, z STRING, y BOOLEAN) timestamp(t) partition by YEAR", "create table x (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL nocache, z STRING, y BOOLEAN) timestamp(t) partition by YEAR", new TableModel[0]);
    }

    @Test
    public void testCreateTableNoCacheIndex() throws SqlException {
        this.assertCreateTable("create table x (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL capacity 128 nocache index capacity 256, z STRING, y BOOLEAN) timestamp(t) partition by YEAR", "create table x (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL nocache index, z STRING, y BOOLEAN) timestamp(t) partition by YEAR", new TableModel[0]);
    }

    @Test
    public void testCreateTableOutOfPlaceIndex() throws SqlException {
        this.assertCreateTable("create table x (a INT index capacity 256, b BYTE, c SHORT, t TIMESTAMP, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, x SYMBOL capacity 128 cache index capacity 256, z STRING, y BOOLEAN) timestamp(t) partition by MONTH", "create table x (a INT, b BYTE, c SHORT, t TIMESTAMP, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, x SYMBOL, z STRING, y BOOLEAN) , index (a) , index (x) timestamp(t) partition by MONTH", new TableModel[0]);
    }

    @Test
    public void testCreateTableOutOfPlaceIndexAndCapacity() throws SqlException {
        this.assertCreateTable("create table x (a INT index capacity 16, b BYTE, c SHORT, t TIMESTAMP, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, x SYMBOL capacity 128 cache index capacity 32, z STRING, y BOOLEAN) timestamp(t) partition by MONTH", "create table x (a INT, b BYTE, c SHORT, t TIMESTAMP, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, x SYMBOL, z STRING, y BOOLEAN) , index (a capacity 16) , index (x capacity 24) timestamp(t) partition by MONTH", new TableModel[0]);
    }

    @Test
    public void testCreateTableOutOfPlaceIndexCapacityHigh() {
        SqlParserTest.assertSyntaxError("create table x (a INT, b BYTE, c SHORT, t TIMESTAMP, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, x SYMBOL, z STRING, y BOOLEAN) , index (a capacity 16) , index (x capacity 10000000) timestamp(t) partition by MONTH", 173, "max index block capacity is", new TableModel[0]);
    }

    @Test
    public void testCreateTableOutOfPlaceIndexCapacityInvalid() {
        SqlParserTest.assertSyntaxError("create table x (a INT, b BYTE, c SHORT, t TIMESTAMP, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, x SYMBOL, z STRING, y BOOLEAN) , index (a capacity 16) , index (x capacity -) timestamp(t) partition by MONTH", 174, "bad integer", new TableModel[0]);
    }

    @Test
    public void testCreateTableOutOfPlaceIndexCapacityLow() {
        SqlParserTest.assertSyntaxError("create table x (a INT, b BYTE, c SHORT, t TIMESTAMP, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, x SYMBOL, z STRING, y BOOLEAN) , index (a capacity 16) , index (x capacity 1) timestamp(t) partition by MONTH", 173, "min index block capacity is", new TableModel[0]);
    }

    @Test
    public void testCreateTableOutOfPlaceIndexCapacityLow2() {
        SqlParserTest.assertSyntaxError("create table x (a INT, b BYTE, c SHORT, t TIMESTAMP, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, x SYMBOL, z STRING, y BOOLEAN) , index (a capacity 16) , index (x capacity -10) timestamp(t) partition by MONTH", 173, "min index block capacity is", new TableModel[0]);
    }

    @Test
    public void testCreateTableRoundedSymbolCapacity() throws SqlException {
        this.assertCreateTable("create table x (a INT, b BYTE, c SHORT, t TIMESTAMP, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, x SYMBOL capacity 512 cache, z STRING, y BOOLEAN) timestamp(t) partition by MONTH", "create table x (a INT, b BYTE, c SHORT, t TIMESTAMP, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, x SYMBOL capacity 500, z STRING, y BOOLEAN) timestamp(t) partition by MONTH", new TableModel[0]);
    }

    @Test
    public void testCreateTableSymbolCapacityHigh() {
        SqlParserTest.assertSyntaxError("create table x (a INT, b BYTE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL capacity 1100000000, z STRING, bool BOOLEAN) timestamp(t) partition by YEAR", 80, "max symbol capacity is", new TableModel[0]);
    }

    @Test
    public void testCreateTableSymbolCapacityLow() {
        SqlParserTest.assertSyntaxError("create table x (a INT, b BYTE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL capacity -10, z STRING, bool BOOLEAN) timestamp(t) partition by YEAR", 80, "min symbol capacity is", new TableModel[0]);
    }

    @Test
    public void testCreateTableUnexpectedToken() {
        SqlParserTest.assertSyntaxError("create table x blah", 15, "unexpected token", new TableModel[0]);
    }

    @Test
    public void testCreateTableUnexpectedToken2() {
        SqlParserTest.assertSyntaxError("create table x (a int, b double), xyz", 34, "unexpected token", new TableModel[0]);
    }

    @Test
    public void testCreateTableUnexpectedTrailingToken() {
        SqlParserTest.assertSyntaxError("create table x (a INT, b BYTE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL index, z STRING, bool BOOLEAN) timestamp(t) partition by YEAR index", 133, "unexpected token", new TableModel[0]);
    }

    @Test
    public void testCreateTableUnexpectedTrailingToken2() {
        SqlParserTest.assertSyntaxError("create table x (a INT, b BYTE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL index, z STRING, bool BOOLEAN) timestamp(t)  index", 116, "unexpected token", new TableModel[0]);
    }

    @Test
    public void testCreateUnsupported() {
        SqlParserTest.assertSyntaxError("create object x", 7, "table", new TableModel[0]);
    }

    @Test
    public void testCrossJoin() {
        SqlParserTest.assertSyntaxError("select x from a a cross join b on b.x = a.x", 31, "cannot", new TableModel[0]);
    }

    @Test
    public void testCrossJoin2() throws Exception {
        this.assertQuery("select-choose a.x x from (a a cross join b z)", "select a.x from a a cross join b z", this.modelOf("a").col("x", 3), this.modelOf("b").col("x", 3));
    }

    @Test
    public void testCrossJoin3() throws Exception {
        this.assertQuery("select-choose a.x x from (a a join c on c.x = a.x cross join b z)", "select a.x from a a cross join b z join c on a.x = c.x", this.modelOf("a").col("x", 3), this.modelOf("b").col("x", 3), this.modelOf("c").col("x", 3));
    }

    @Test
    public void testCrossJoinNoAlias() throws Exception {
        this.assertQuery("select-choose a.x x from (a a join c on c.x = a.x cross join b)", "select a.x from a a cross join b join c on a.x = c.x", this.modelOf("a").col("x", 3), this.modelOf("b").col("x", 3), this.modelOf("c").col("x", 3));
    }

    @Test
    public void testCrossJoinWithClause() throws SqlException {
        this.assertQuery("select-choose c.customerId customerId, c.name name, c.age age, c1.customerId customerId1, c1.name name1, c1.age age1 from ((customers where name ~ 'X') c cross join (customers where name ~ 'X' and age = 30) c1 limit 10)", "with cust as (customers where name ~ 'X') cust c cross join cust c1 where c1.age = 30  limit 10", this.modelOf("customers").col("customerId", 3).col("name", 7).col("age", 1));
    }

    @Test
    public void testDisallowDotInColumnAlias() {
        SqlParserTest.assertSyntaxError("select x x.y, y from tab order by x", 9, "not allowed", new TableModel[0]);
    }

    @Test
    public void testDisallowedColumnAliases() throws SqlException {
        this.assertQuery("select-virtual x + z column, x - z column1, x * z column2, x / z column3, x % z column4, x ^ z column5 from (tab1)", "select x+z, x-z, x*z, x/z, x%z, x^z from tab1", this.modelOf("tab1").col("x", 3).col("z", 3));
    }

    @Test
    public void testDuplicateAlias() {
        SqlParserTest.assertSyntaxError("customers a cross join orders a", 30, "duplicate", this.modelOf("customers").col("customerId", 3).col("customerName", 7), this.modelOf("orders").col("customerId", 3).col("product", 7));
    }

    @Test
    public void testDuplicateColumnGroupBy() throws SqlException {
        this.assertQuery("select-group-by b, sum(a) sum, k1, k1 k from (select-choose b, a, k k1 from (x y timestamp (timestamp))) sample by 3h", "select b, sum(a), k k1, k from x y sample by 3h", this.modelOf("x").col("a", 6).col("b", 8).col("k", 12).timestamp());
    }

    @Test
    public void testDuplicateColumnsBasicSelect() throws SqlException {
        this.assertQuery("select-choose b, a, k1, k1 k from (select-choose b, a, k k1 from (x timestamp (timestamp)))", "select b, a, k k1, k from x", this.modelOf("x").col("a", 6).col("b", 8).col("k", 12).timestamp());
    }

    @Test
    public void testDuplicateColumnsVirtualAndGroupBySelect() throws SqlException {
        this.assertQuery("select-group-by sum(b + a) sum, column, k1, k1 k from (select-virtual a, b, a + b column, k1 from (select-choose a, b, k k1 from (x timestamp (timestamp)))) sample by 1m", "select sum(b+a), a+b, k k1, k from x sample by 1m", this.modelOf("x").col("a", 6).col("b", 8).col("k", 12).timestamp());
    }

    @Test
    public void testDuplicateColumnsVirtualSelect() throws SqlException {
        this.assertQuery("select-choose column, k1, k1 k from (select-virtual b + a column, k1 from (select-choose a, b, k k1 from (x timestamp (timestamp))))", "select b+a, k k1, k from x", this.modelOf("x").col("a", 6).col("b", 8).col("k", 12).timestamp());
    }

    @Test
    public void testDuplicateTables() throws Exception {
        this.assertQuery("select-choose customers.customerId customerId, customers.customerName customerName, cust.customerId customerId1, cust.customerName customerName1 from (customers cross join customers cust)", "customers cross join customers cust", this.modelOf("customers").col("customerId", 3).col("customerName", 7), this.modelOf("orders").col("customerId", 3).col("product", 7));
    }

    @Test
    public void testEmptyOrderBy() {
        SqlParserTest.assertSyntaxError("select x, y from tab order by", 29, "literal expected", new TableModel[0]);
    }

    @Test
    public void testEmptySampleBy() {
        SqlParserTest.assertSyntaxError("select x, y from tab sample by", 30, "literal expected", new TableModel[0]);
    }

    @Test
    public void testEqualsConstantTransitivityLhs() throws Exception {
        this.assertQuery("select-choose c.customerId customerId, o.customerId customerId1 from (customers c outer join (orders o where customerId = 100) o on o.customerId = c.customerId where 100 = customerId)", "customers c outer join orders o on c.customerId = o.customerId where 100 = c.customerId", this.modelOf("customers").col("customerId", 3), this.modelOf("orders").col("customerId", 3));
    }

    @Test
    public void testEqualsConstantTransitivityRhs() throws Exception {
        this.assertQuery("select-choose c.customerId customerId, o.customerId customerId1 from (customers c outer join (orders o where customerId = 100) o on o.customerId = c.customerId where customerId = 100)", "customers c outer join orders o on c.customerId = o.customerId where c.customerId = 100", this.modelOf("customers").col("customerId", 3), this.modelOf("orders").col("customerId", 3));
    }

    @Test
    public void testEraseColumnPrefix() throws SqlException {
        this.assertQuery("select-choose name from (cust where name ~ 'x')", "cust where cust.name ~ 'x'", this.modelOf("cust").col("name", 7));
    }

    @Test
    public void testEraseColumnPrefixInJoin() throws Exception {
        this.assertQuery("select-choose c.customerId customerId, o.customerId customerId1, o.x x from (customers c outer join (orders o where x = 10 and customerId = 100) o on customerId = c.customerId where customerId = 100)", "customers c outer join (orders o where o.x = 10) o on c.customerId = o.customerId where c.customerId = 100", this.modelOf("customers").col("customerId", 3), this.modelOf("orders").col("customerId", 3).col("x", 3));
    }

    @Test
    public void testExpressionSyntaxError() {
        SqlParserTest.assertSyntaxError("select x from a where a + b(c,) > 10", 30, "missing argument", new TableModel[0]);
        SqlParserTest.assertSyntaxError("orders join customers on orders.customerId = c.customerId", 45, "alias", this.modelOf("customers").col("customerId", 3), this.modelOf("orders").col("customerId", 3).col("productName", 7).col("productId", 3));
    }

    @Test
    public void testExtraComma2OrderByInAnalyticFunction() {
        SqlParserTest.assertSyntaxError("select a,b, f(c) my over (partition by b order by ts,) from xyz", 53, "literal expected", new TableModel[0]);
    }

    @Test
    public void testExtraCommaOrderByInAnalyticFunction() {
        SqlParserTest.assertSyntaxError("select a,b, f(c) my over (partition by b order by ,ts) from xyz", 50, "literal", new TableModel[0]);
    }

    @Test
    public void testExtraCommaPartitionByInAnalyticFunction() {
        SqlParserTest.assertSyntaxError("select a,b, f(c) my over (partition by b, order by ts) from xyz", 48, "')' expected", new TableModel[0]);
    }

    @Test
    public void testFilter2() throws Exception {
        this.assertQuery("select-virtual customerId + 1 column, name, count from ((select-group-by customerId, name, count() count from (select-choose customerId, customerName name from (customers where customerName = 'X'))) _xQdbA1)", "select customerId+1, name, count from (select customerId, customerName name, count() count from customers) where name = 'X'", this.modelOf("customers").col("customerId", 3).col("customerName", 7), this.modelOf("orders").col("orderId", 3).col("customerId", 3));
    }

    @Test
    public void testFilterOnSubQuery() throws Exception {
        this.assertQuery("select-choose c.customerId customerId, c.customerName customerName, c.count count, o.orderId orderId, o.customerId customerId1 from ((select-group-by customerId, customerName, count() count from (customers where customerId > 400 and customerId < 1200)) c outer join orders o on o.customerId = c.customerId post-join-where o.orderId = NaN where count > 1) order by customerId", "(select customerId, customerName, count() count from customers) c outer join orders o on c.customerId = o.customerId  where o.orderId = NaN and c.customerId > 400 and c.customerId < 1200 and count > 1 order by c.customerId", this.modelOf("customers").col("customerId", 3).col("customerName", 7), this.modelOf("orders").col("orderId", 3).col("customerId", 3));
    }

    @Test
    public void testGenericPreFilterPlacement() throws Exception {
        this.assertQuery("select-choose customerName, orderId, productId from (customers join (orders where product = 'X') orders on orders.customerId = customers.customerId where customerName ~ 'WTBHZVPVZZ')", "select customerName, orderId, productId from customers join orders on customers.customerId = orders.customerId where customerName ~ 'WTBHZVPVZZ' and product = 'X'", this.modelOf("customers").col("customerId", 3).col("customerName", 7), this.modelOf("orders").col("customerId", 3).col("product", 7).col("orderId", 3).col("productId", 3));
    }

    @Test
    public void testInnerJoin() throws Exception {
        this.assertQuery("select-choose a.x x from (a a join b on b.x = a.x)", "select a.x from a a inner join b on b.x = a.x", this.modelOf("a").col("x", 3), this.modelOf("b").col("x", 3));
    }

    @Test
    public void testInnerJoin2() throws Exception {
        this.assertQuery("select-choose customers.customerId customerId, customers.customerName customerName, orders.customerId customerId1 from (customers join orders on orders.customerId = customers.customerId where customerName ~ 'WTBHZVPVZZ')", "customers join orders on customers.customerId = orders.customerId where customerName ~ 'WTBHZVPVZZ'", this.modelOf("customers").col("customerId", 3).col("customerName", 7), this.modelOf("orders").col("customerId", 3));
    }

    @Test
    public void testInnerJoinColumnAliasNull() throws SqlException {
        this.assertQuery("select-choose customerId, kk, count from ((select-group-by customerId, kk, count() count from (select-choose c.customerId customerId, o.customerId kk from (customers c join (orders o where customerId = null) o on o.customerId = c.customerId))) _xQdbA1 limit 10)", "(select c.customerId, o.customerId kk, count() from customers c join orders o on c.customerId = o.customerId)  where kk = null limit 10", this.modelOf("customers").col("customerId", 3), this.modelOf("orders").col("customerId", 3));
    }

    @Test
    public void testInnerJoinEqualsConstant() throws Exception {
        this.assertQuery("select-choose customers.customerId customerId, orders.customerId customerId1, orders.productName productName from (customers join (orders where productName = 'WTBHZVPVZZ') orders on orders.customerId = customers.customerId)", "customers join orders on customers.customerId = orders.customerId where productName = 'WTBHZVPVZZ'", this.modelOf("customers").col("customerId", 3), this.modelOf("orders").col("customerId", 3).col("productName", 7));
    }

    @Test
    public void testInnerJoinEqualsConstantLhs() throws Exception {
        this.assertQuery("select-choose customers.customerId customerId, orders.customerId customerId1, orders.productName productName from (customers join (orders where 'WTBHZVPVZZ' = productName) orders on orders.customerId = customers.customerId)", "customers join orders on customers.customerId = orders.customerId where 'WTBHZVPVZZ' = productName", this.modelOf("customers").col("customerId", 3), this.modelOf("orders").col("customerId", 3).col("productName", 7));
    }

    @Test
    public void testInnerJoinPostFilter() throws SqlException {
        this.assertQuery("select-virtual c, a, b, d, d - b column from (select-choose z.c c, x.a a, b, d from (x join (y where b < 20) y on y.m = x.c join z on z.c = x.c))", "select z.c, x.a, b, d, d-b from x join y on y.m = x.c join z on (c) where y.b < 20", this.modelOf("x").col("c", 3).col("a", 3), this.modelOf("y").col("m", 3).col("b", 3), this.modelOf("z").col("c", 3).col("d", 3));
    }

    @Test
    public void testInnerJoinSubQuery() throws Exception {
        this.assertQuery("select-choose customerName, productName, orderId from ((select-choose customerName, orderId, productId, productName from (customers join (orders where productName ~ 'WTBHZVPVZZ') orders on orders.customerId = customers.customerId)) x join products p on p.productId = x.productId)", "select customerName, productName, orderId from (select customerName, orderId, productId, productName from customers join orders on customers.customerId = orders.customerId where productName ~ 'WTBHZVPVZZ') x join products p on p.productId = x.productId", this.modelOf("customers").col("customerId", 3).col("customerName", 7), this.modelOf("orders").col("customerId", 3).col("productName", 7).col("productId", 3).col("orderId", 3), this.modelOf("products").col("productId", 3));
        this.assertQuery("select-choose customerName, productName, orderId from (customers join (orders o where productName ~ 'WTBHZVPVZZ') o on o.customerId = customers.customerId join products p on p.productId = o.productId)", "select customerName, productName, orderId  from customers join orders o on customers.customerId = o.customerId  join products p on p.productId = o.productId where productName ~ 'WTBHZVPVZZ'", this.modelOf("customers").col("customerId", 3).col("customerName", 7), this.modelOf("orders").col("customerId", 3).col("productName", 7).col("productId", 3).col("orderId", 3), this.modelOf("products").col("productId", 3));
    }

    @Test
    public void testInsertAsSelect() throws SqlException {
        this.assertModel("insert into x select-choose c, d from (y)", "insert into x select * from y", 4, this.modelOf("x").col("a", 3).col("b", 7), this.modelOf("y").col("c", 3).col("d", 7));
    }

    @Test
    public void testInsertAsSelectColumnCountMismatch() {
        SqlParserTest.assertSyntaxError("insert into x (b) select * from y", 12, "column count mismatch", this.modelOf("x").col("a", 3).col("b", 7), this.modelOf("y").col("c", 3).col("d", 7));
    }

    @Test
    public void testInsertAsSelectColumnList() throws SqlException {
        this.assertModel("insert into x (a, b) select-choose c, d from (y)", "insert into x (a,b) select * from y", 4, this.modelOf("x").col("a", 3).col("b", 7), this.modelOf("y").col("c", 3).col("d", 7));
    }

    @Test
    public void testInsertAsSelectDuplicateColumns() {
        SqlParserTest.assertSyntaxError("insert into x (b,b) select * from y", 17, "duplicate column name", this.modelOf("x").col("a", 3).col("b", 7), this.modelOf("y").col("c", 3).col("d", 7));
    }

    @Test
    public void testInvalidAlias() {
        SqlParserTest.assertSyntaxError("orders join customers on orders.customerId = c.customerId", 45, "alias", this.modelOf("customers").col("customerId", 3), this.modelOf("orders").col("customerId", 3).col("productName", 7).col("productId", 3));
    }

    @Test
    public void testInvalidColumn() {
        SqlParserTest.assertSyntaxError("orders join customers on customerIdx = customerId", 25, "Invalid column", this.modelOf("customers").col("customerId", 3), this.modelOf("orders").col("customerId", 3).col("productName", 7).col("productId", 3));
    }

    @Test
    public void testInvalidColumnInExpression() {
        SqlParserTest.assertSyntaxError("select a + b x from tab", 11, "Invalid column", this.modelOf("tab").col("a", 3));
    }

    @Test
    public void testInvalidGroupBy1() {
        SqlParserTest.assertSyntaxError("select x, y from tab sample by x,", 32, "unexpected", new TableModel[0]);
    }

    @Test
    public void testInvalidGroupBy2() {
        SqlParserTest.assertSyntaxError("select x, y from (tab sample by x,)", 33, "')' expected", new TableModel[0]);
    }

    @Test
    public void testInvalidGroupBy3() {
        SqlParserTest.assertSyntaxError("select x, y from tab sample by x, order by y", 32, "unexpected token: ,", new TableModel[0]);
    }

    @Test
    public void testInvalidInnerJoin1() {
        SqlParserTest.assertSyntaxError("select x from a a inner join b z", 31, "'on'", new TableModel[0]);
    }

    @Test
    public void testInvalidInnerJoin2() {
        SqlParserTest.assertSyntaxError("select x from a a inner join b z on", 33, "Expression", new TableModel[0]);
    }

    @Test
    public void testInvalidOrderBy1() {
        SqlParserTest.assertSyntaxError("select x, y from tab order by x,", 32, "literal expected", new TableModel[0]);
    }

    @Test
    public void testInvalidOrderBy2() {
        SqlParserTest.assertSyntaxError("select x, y from (tab order by x,)", 33, "literal expected", new TableModel[0]);
    }

    @Test
    public void testInvalidOuterJoin1() {
        SqlParserTest.assertSyntaxError("select x from a a outer join b z", 31, "'on'", new TableModel[0]);
    }

    @Test
    public void testInvalidOuterJoin2() {
        SqlParserTest.assertSyntaxError("select x from a a outer join b z on", 33, "Expression", new TableModel[0]);
    }

    @Test
    public void testInvalidSelectColumn() {
        SqlParserTest.assertSyntaxError("select c.customerId, orderIdx, o.productId from customers c join (orders latest by customerId where customerId in (`customers where customerName ~ 'PJFSREKEUNMKWOF'`)) o on c.customerId = o.customerId", 21, "Invalid column", this.modelOf("customers").col("customerName", 7).col("customerId", 3), this.modelOf("orders").col("orderId", 3).col("customerId", 3));
        SqlParserTest.assertSyntaxError("select c.customerId, orderId, o.productId2 from customers c join (orders latest by customerId where customerId in (`customers where customerName ~ 'PJFSREKEUNMKWOF'`)) o on c.customerId = o.customerId", 30, "Invalid column", this.modelOf("customers").col("customerName", 7).col("customerId", 3), this.modelOf("orders").col("orderId", 3).col("customerId", 3));
        SqlParserTest.assertSyntaxError("select c.customerId, orderId, o2.productId from customers c join (orders latest by customerId where customerId in (`customers where customerName ~ 'PJFSREKEUNMKWOF'`)) o on c.customerId = o.customerId", 30, "Invalid table name", this.modelOf("customers").col("customerName", 7).col("customerId", 3), this.modelOf("orders").col("orderId", 3).col("customerId", 3));
    }

    @Test
    public void testInvalidSubQuery() {
        SqlParserTest.assertSyntaxError("select x,y from (tab where x = 100) latest by x", 36, "latest", new TableModel[0]);
    }

    @Test
    public void testInvalidTableName() {
        SqlParserTest.assertSyntaxError("orders join customer on customerId = customerId", 12, "does not exist", this.modelOf("orders").col("customerId", 3));
    }

    @Test
    public void testJoin1() throws Exception {
        this.assertQuery("select-choose t1.x x, y from ((select-choose x from (tab t2 latest by x where x > 100)) t1 join tab2 xx2 on xx2.x = t1.x join (select-choose x, y from (tab4 latest by z where a > b and y > 0)) x4 on x4.x = t1.x cross join tab3 post-join-where xx2.x > tab3.b)", "select t1.x, y from (select x from tab t2 latest by x where x > 100) t1 join tab2 xx2 on xx2.x = t1.x join tab3 on xx2.x > tab3.b join (select x,y from tab4 latest by z where a > b) x4 on x4.x = t1.x where y > 0", this.modelOf("tab").col("x", 3), this.modelOf("tab2").col("x", 3), this.modelOf("tab3").col("b", 3), this.modelOf("tab4").col("x", 3).col("y", 3).col("z", 3).col("a", 3).col("b", 3));
    }

    @Test
    public void testJoin2() throws Exception {
        this.assertQuery("select-choose x from (((select-choose tab2.x x from (tab join tab2 on tab2.x = tab.x)) t join tab3 on tab3.x = t.x) _xQdbA1)", "select x from ((select tab2.x from tab join tab2 on tab.x=tab2.x) t join tab3 on tab3.x = t.x)", this.modelOf("tab").col("x", 3), this.modelOf("tab2").col("x", 3), this.modelOf("tab3").col("x", 3));
    }

    @Test
    public void testJoin3() throws Exception {
        this.assertQuery("select-choose x from ((select-choose tab2.x x from (tab join tab2 on tab2.x = tab.x cross join tab3 post-join-where f(tab3.x,tab2.x) = tab.x)) _xQdbA1)", "select x from (select tab2.x from tab join tab2 on tab.x=tab2.x join tab3 on f(tab3.x,tab2.x) = tab.x)", this.modelOf("tab").col("x", 3), this.modelOf("tab2").col("x", 3), this.modelOf("tab3").col("x", 3));
    }

    @Test
    public void testJoinColumnResolutionOnSubQuery() throws SqlException {
        this.assertQuery("select-group-by sum(timestamp) sum from ((y) _xQdbA1 cross join (x) _xQdbA2)", "select sum(timestamp) from (y) cross join (x)", this.modelOf("x").col("ccy", 8), this.modelOf("y").col("ccy", 8).col("timestamp", 12));
    }

    @Test
    public void testJoinColumnResolutionOnSubQuery2() throws SqlException {
        this.assertQuery("select-group-by sum(timestamp) sum from ((y) _xQdbA1 join (x) _xQdbA2 on _xQdbA2.ccy = _xQdbA1.ccy and _xQdbA2.sym = _xQdbA1.sym)", "select sum(timestamp) from (y) join (x) on (ccy, sym)", this.modelOf("x").col("ccy", 8).col("sym", 3), this.modelOf("y").col("ccy", 8).col("timestamp", 12).col("sym", 3));
    }

    @Test
    public void testJoinColumnResolutionOnSubQuery3() throws SqlException {
        this.assertQuery("select-group-by sum(timestamp) sum from ((y) _xQdbA1 cross join x)", "select sum(timestamp) from (y) cross join x", this.modelOf("x").col("ccy", 8), this.modelOf("y").col("ccy", 8).col("timestamp", 12));
    }

    @Test
    public void testJoinCycle() throws Exception {
        this.assertQuery("select-choose orders.customerId customerId, orders.orderId orderId, customers.customerId customerId1, d.orderId orderId1, d.productId productId, suppliers.supplier supplier, products.productId productId1, products.supplier supplier1 from (orders join customers on customers.customerId = orders.customerId join (orderDetails d where orderId = productId) d on d.productId = orders.orderId join suppliers on suppliers.supplier = orders.orderId join products on products.productId = orders.orderId and products.supplier = suppliers.supplier)", "orders join customers on orders.customerId = customers.customerId join orderDetails d on d.orderId = orders.orderId and orders.orderId = products.productId join suppliers on products.supplier = suppliers.supplier join products on d.productId = products.productId and orders.orderId = products.productId where orders.orderId = suppliers.supplier", this.modelOf("orders").col("customerId", 3).col("orderId", 3), this.modelOf("customers").col("customerId", 3), this.modelOf("orderDetails").col("orderId", 3).col("productId", 3), this.modelOf("products").col("productId", 3).col("supplier", 8), this.modelOf("suppliers").col("supplier", 8));
    }

    @Test
    public void testJoinCycle2() throws Exception {
        this.assertQuery("select-choose orders.customerId customerId, orders.orderId orderId, customers.customerId customerId1, d.orderId orderId1, d.productId productId, suppliers.supplier supplier, suppliers.x x, products.productId productId1, products.supplier supplier1 from (orders join customers on customers.customerId = orders.customerId join orderDetails d on d.productId = orders.orderId join suppliers on suppliers.x = d.orderId and suppliers.supplier = orders.orderId join products on products.productId = orders.orderId and products.supplier = suppliers.supplier)", "orders join customers on orders.orderId = products.productId join orderDetails d on products.supplier = suppliers.supplier join suppliers on orders.customerId = customers.customerId join products on d.productId = products.productId and orders.orderId = products.productId where orders.orderId = suppliers.supplier and d.orderId = suppliers.x", this.modelOf("orders").col("customerId", 3).col("orderId", 3), this.modelOf("customers").col("customerId", 3), this.modelOf("orderDetails").col("orderId", 3).col("productId", 3), this.modelOf("products").col("productId", 3).col("supplier", 8), this.modelOf("suppliers").col("supplier", 8).col("x", 3));
    }

    @Test
    public void testJoinDuplicateTables() {
        SqlParserTest.assertSyntaxError("select * from tab cross join tab", 29, "duplicate", this.modelOf("tab").col("y", 3));
    }

    @Test
    public void testJoinFunction() throws SqlException {
        this.assertQuery("select-choose tab.x x, t.y y, t1.z z from (tab join t on f(y) = f(x) join t1 on z = f(x) const-where 1 = 1)", "select * from tab join t on f(x)=f(y) join t1 on 1=1 where z=f(x)", this.modelOf("tab").col("x", 3), this.modelOf("t").col("y", 3), this.modelOf("t1").col("z", 3));
    }

    @Test
    public void testJoinGroupBy() throws Exception {
        this.assertQuery("select-group-by country, sum(quantity) sum from (orders o join (customers c where country ~ '^Z') c on c.customerId = o.customerId join orderDetails d on d.orderId = o.orderId)", "select country, sum(quantity) from orders o join customers c on c.customerId = o.customerId join orderDetails d on o.orderId = d.orderId where country ~ '^Z'", this.modelOf("orders").col("customerId", 3).col("orderId", 3), this.modelOf("customers").col("customerId", 3).col("country", 8), this.modelOf("orderDetails").col("orderId", 3).col("quantity", 6));
    }

    @Test
    public void testJoinGroupByFilter() throws Exception {
        this.assertQuery("select-choose country, sum from ((select-group-by country, sum(quantity) sum from (orders o join (customers c where country ~ '^Z') c on c.customerId = o.customerId join orderDetails d on d.orderId = o.orderId)) _xQdbA1 where sum > 2)", "(select country, sum(quantity) sum from orders o join customers c on c.customerId = o.customerId join orderDetails d on o.orderId = d.orderId where country ~ '^Z') where sum > 2", this.modelOf("orders").col("customerId", 3).col("orderId", 3).col("quantity", 6), this.modelOf("customers").col("customerId", 3).col("country", 8), this.modelOf("orderDetails").col("orderId", 3));
    }

    @Test
    public void testJoinImpliedCrosses() throws Exception {
        this.assertQuery("select-choose orders.customerId customerId, orders.orderId orderId, customers.customerId customerId1, d.orderId orderId1, d.productId productId, products.productId productId1, products.supplier supplier, suppliers.supplier supplier1 from (orders cross join products join suppliers on suppliers.supplier = products.supplier cross join customers cross join orderDetails d const-where 1 = 1 and 2 = 2 and 3 = 3)", "orders join customers on 1=1 join orderDetails d on 2=2 join products on 3=3 join suppliers on products.supplier = suppliers.supplier", this.modelOf("orders").col("customerId", 3).col("orderId", 3), this.modelOf("customers").col("customerId", 3), this.modelOf("orderDetails").col("orderId", 3).col("productId", 3), this.modelOf("products").col("productId", 3).col("supplier", 8), this.modelOf("suppliers").col("supplier", 8));
    }

    @Test
    public void testJoinMultipleFields() throws Exception {
        this.assertQuery("select-choose orders.customerId customerId, orders.orderId orderId, customers.customerId customerId1, d.orderId orderId1, d.productId productId, products.productId productId1, products.supplier supplier, suppliers.supplier supplier1 from (orders join customers on customers.customerId = orders.customerId join (orderDetails d where productId = orderId) d on d.productId = customers.customerId and d.orderId = orders.orderId join products on products.productId = d.productId join suppliers on suppliers.supplier = products.supplier)", "orders join customers on orders.customerId = customers.customerId join orderDetails d on d.orderId = orders.orderId and d.productId = customers.customerId join products on d.productId = products.productId join suppliers on products.supplier = suppliers.supplier where d.productId = d.orderId", this.modelOf("orders").col("customerId", 3).col("orderId", 3), this.modelOf("customers").col("customerId", 3), this.modelOf("orderDetails").col("orderId", 3).col("productId", 3), this.modelOf("products").col("productId", 3).col("supplier", 8), this.modelOf("suppliers").col("supplier", 8));
    }

    @Test
    public void testJoinOfJoin() throws SqlException {
        this.assertQuery("select-choose tt.x x, tt.y y, tt.x1 x1, tt.z z, tab2.z z1, tab2.k k from ((select-choose tab.x x, tab.y y, tab1.x x1, tab1.z z from (tab join tab1 on tab1.x = tab.x)) tt join tab2 on tab2.z = tt.z)", "select * from (select * from tab join tab1 on (x)) tt join tab2 on(z)", this.modelOf("tab").col("x", 3).col("y", 3), this.modelOf("tab1").col("x", 3).col("z", 3), this.modelOf("tab2").col("z", 3).col("k", 3));
    }

    @Test
    public void testJoinOnCase() throws Exception {
        this.assertQuery("select-choose a.x x from (a a cross join b where switch(x,1,10,15))", "select a.x from a a join b on (case when a.x = 1 then 10 else 15 end)", this.modelOf("a").col("x", 3), this.modelOf("b").col("x", 3));
    }

    @Test
    public void testJoinOnColumns() throws SqlException {
        this.assertQuery("select-choose a.x x, b.y y from (tab1 a join tab2 b on b.z = a.z)", "select a.x, b.y from tab1 a join tab2 b on (z)", this.modelOf("tab1").col("x", 3).col("z", 3), this.modelOf("tab2").col("x", 3).col("y", 3).col("z", 3).col("s", 3));
    }

    @Test
    public void testJoinOnExpression() {
        SqlParserTest.assertSyntaxError("a join b on (x,x+1)", 18, "Column name expected", this.modelOf("a").col("x", 3), this.modelOf("b").col("x", 3));
    }

    @Test
    public void testJoinOnExpression2() throws SqlException {
        this.assertQuery("select-choose a.x x, b.x x1 from (a cross join (b where x) b where x + 1)", "a join b on a.x+1 and b.x", this.modelOf("a").col("x", 3), this.modelOf("b").col("x", 3));
    }

    @Test
    public void testJoinOneFieldToTwoAcross2() throws Exception {
        this.assertQuery("select-choose orders.orderId orderId, orders.customerId customerId, customers.customerId customerId1, d.orderId orderId1, d.productId productId, products.productId productId1, products.supplier supplier, suppliers.supplier supplier1 from (orders join customers on customers.customerId = orders.orderId join (orderDetails d where productId = orderId) d on d.orderId = orders.orderId join products on products.productId = d.productId join suppliers on suppliers.supplier = products.supplier where customerId = orderId)", "orders join customers on orders.customerId = customers.customerId join orderDetails d on d.orderId = customers.customerId and orders.orderId = d.orderId join products on d.productId = products.productId join suppliers on products.supplier = suppliers.supplier where d.productId = d.orderId", this.modelOf("orders").col("orderId", 3).col("customerId", 3), this.modelOf("customers").col("customerId", 3), this.modelOf("orderDetails").col("orderId", 3).col("productId", 3), this.modelOf("products").col("productId", 3).col("supplier", 3), this.modelOf("suppliers").col("supplier", 3));
    }

    @Test
    public void testJoinOneFieldToTwoReorder() throws Exception {
        this.assertQuery("select-choose orders.orderId orderId, orders.customerId customerId, d.orderId orderId1, d.productId productId, customers.customerId customerId1, products.productId productId1, products.supplier supplier, suppliers.supplier supplier1 from (orders join (orderDetails d where productId = orderId) d on d.orderId = orders.customerId join customers on customers.customerId = orders.customerId join products on products.productId = d.productId join suppliers on suppliers.supplier = products.supplier where orderId = customerId)", "orders join orderDetails d on d.orderId = orders.orderId and d.orderId = customers.customerId join customers on orders.customerId = customers.customerId join products on d.productId = products.productId join suppliers on products.supplier = suppliers.supplier where d.productId = d.orderId", this.modelOf("orders").col("orderId", 3).col("customerId", 3), this.modelOf("customers").col("customerId", 3), this.modelOf("orderDetails").col("orderId", 3).col("productId", 3), this.modelOf("products").col("productId", 3).col("supplier", 3), this.modelOf("suppliers").col("supplier", 3));
    }

    @Test
    public void testJoinOrder4() throws SqlException {
        this.assertQuery("select-choose b.id id, e.id id1 from (a cross join b asof join d join e on e.id = b.id cross join c)", "a cross join b cross join c asof join d inner join e on b.id = e.id", this.modelOf("a"), this.modelOf("b").col("id", 3), this.modelOf("c"), this.modelOf("d"), this.modelOf("e").col("id", 3));
    }

    @Test
    public void testJoinReorder() throws Exception {
        this.assertQuery("select-choose orders.orderId orderId, customers.customerId customerId, d.orderId orderId1, d.productId productId, products.productId productId1, products.supplier supplier, suppliers.supplier supplier1 from (orders join (orderDetails d where productId = orderId) d on d.orderId = orders.orderId join customers on customers.customerId = d.productId join products on products.productId = d.productId join suppliers on suppliers.supplier = products.supplier const-where 1 = 1)", "orders join customers on 1=1 join orderDetails d on d.orderId = orders.orderId and d.productId = customers.customerId join products on d.productId = products.productId join suppliers on products.supplier = suppliers.supplier where d.productId = d.orderId", this.modelOf("orders").col("orderId", 3), this.modelOf("customers").col("customerId", 3), this.modelOf("orderDetails").col("orderId", 3).col("productId", 3), this.modelOf("products").col("productId", 3).col("supplier", 3), this.modelOf("suppliers").col("supplier", 3));
    }

    @Test
    public void testJoinReorder3() throws Exception {
        this.assertQuery("select-choose orders.orderId orderId, customers.customerId customerId, shippers.shipper shipper, d.orderId orderId1, d.productId productId, suppliers.supplier supplier, products.productId productId1, products.supplier supplier1 from (orders join shippers on shippers.shipper = orders.orderId join (orderDetails d where productId = orderId) d on d.productId = shippers.shipper join products on products.productId = d.productId join suppliers on suppliers.supplier = products.supplier cross join customers const-where 1 = 1)", "orders outer join customers on 1=1 join shippers on shippers.shipper = orders.orderId join orderDetails d on d.orderId = orders.orderId and d.productId = shippers.shipper join suppliers on products.supplier = suppliers.supplier join products on d.productId = products.productId where d.productId = d.orderId", this.modelOf("orders").col("orderId", 3), this.modelOf("customers").col("customerId", 3), this.modelOf("orderDetails").col("orderId", 3).col("productId", 3), this.modelOf("products").col("productId", 3).col("supplier", 3), this.modelOf("suppliers").col("supplier", 3), this.modelOf("shippers").col("shipper", 3));
    }

    @Test
    public void testJoinReorderRoot() throws Exception {
        this.assertQuery("select-choose customers.customerId customerId, orders.orderId orderId, d.orderId orderId1, d.productId productId, products.productId productId1, products.supplier supplier, suppliers.supplier supplier1 from (customers join (orderDetails d where productId = orderId) d on d.productId = customers.customerId join orders on orders.orderId = d.orderId join products on products.productId = d.productId join suppliers on suppliers.supplier = products.supplier)", "customers cross join orders join orderDetails d on d.orderId = orders.orderId and d.productId = customers.customerId join products on d.productId = products.productId join suppliers on products.supplier = suppliers.supplier where d.productId = d.orderId", this.modelOf("orders").col("orderId", 3), this.modelOf("customers").col("customerId", 3), this.modelOf("orderDetails").col("orderId", 3).col("productId", 3), this.modelOf("products").col("productId", 3).col("supplier", 3), this.modelOf("suppliers").col("supplier", 3));
    }

    @Test
    public void testJoinReorderRoot2() throws Exception {
        this.assertQuery("select-choose orders.orderId orderId, customers.customerId customerId, shippers.shipper shipper, d.orderId orderId1, d.productId productId, products.productId productId1, products.supplier supplier, suppliers.supplier supplier1 from (orders join shippers on shippers.shipper = orders.orderId join (orderDetails d where productId = orderId) d on d.productId = shippers.shipper join products on products.productId = d.productId join suppliers on suppliers.supplier = products.supplier cross join customers const-where 1 = 1)", "orders outer join customers on 1=1 join shippers on shippers.shipper = orders.orderId join orderDetails d on d.orderId = orders.orderId and d.productId = shippers.shipper join products on d.productId = products.productId join suppliers on products.supplier = suppliers.supplier where d.productId = d.orderId", this.modelOf("orders").col("orderId", 3), this.modelOf("customers").col("customerId", 3), this.modelOf("orderDetails").col("orderId", 3).col("productId", 3), this.modelOf("products").col("productId", 3).col("supplier", 3), this.modelOf("suppliers").col("supplier", 3), this.modelOf("shippers").col("shipper", 3));
    }

    @Test
    public void testJoinSubQuery() throws Exception {
        this.assertQuery("select-choose orders.orderId orderId, _xQdbA1.customerId customerId, _xQdbA1.customerName customerName from (orders join (select-choose customerId, customerName from (customers where customerName ~ 'X')) _xQdbA1 on customerName = orderId)", "orders cross join (select customerId, customerName from customers where customerName ~ 'X') where orderId = customerName", this.modelOf("orders").col("orderId", 3), this.modelOf("customers").col("customerId", 3).col("customerName", 7));
    }

    @Test
    public void testJoinSubQueryConstantWhere() throws Exception {
        this.assertQuery("select-choose o.customerId customerId from ((select-choose customerId cid from (customers where 100 = customerId)) c outer join (orders o where customerId = 100) o on o.customerId = c.cid const-where 10 = 9)", "select o.customerId from (select customerId cid from customers) c outer join orders o on c.cid = o.customerId where 100 = c.cid and 10=9", this.modelOf("customers").col("customerId", 3), this.modelOf("orders").col("customerId", 3));
    }

    @Test
    public void testJoinSubQueryWherePosition() throws Exception {
        this.assertQuery("select-choose o.customerId customerId from ((select-choose customerId cid from (customers where 100 = customerId)) c outer join (orders o where customerId = 100) o on o.customerId = c.cid)", "select o.customerId from (select customerId cid from customers) c outer join orders o on c.cid = o.customerId where 100 = c.cid", this.modelOf("customers").col("customerId", 3), this.modelOf("orders").col("customerId", 3));
    }

    @Test
    public void testJoinSyntaxError() {
        SqlParserTest.assertSyntaxError("select a.x from a a join b on (a + case when a.x = 1 then 10 else end)", 66, "missing argument", this.modelOf("a").col("x", 3), this.modelOf("b").col("x", 3));
    }

    @Test
    public void testJoinTableMissing() {
        SqlParserTest.assertSyntaxError("select a from tab join", 22, "table name or sub-query expected", new TableModel[0]);
    }

    @Test
    public void testJoinTriangle() throws Exception {
        this.assertQuery("select-choose o.a a, o.b b, o.c c, c.c c1, c.d d, c.e e, d.b b1, d.d d1, d.quantity quantity from (orders o join customers c on c.c = o.c join orderDetails d on d.d = c.d and d.b = o.b)", "orders o join customers c on(c) join orderDetails d on o.b = d.b and c.d = d.d", this.modelOf("orders").col("a", 3).col("b", 3).col("c", 4), this.modelOf("customers").col("c", 4).col("d", 3).col("e", 3), this.modelOf("orderDetails").col("b", 3).col("d", 3).col("quantity", 6));
    }

    @Test
    public void testJoinWith() throws SqlException {
        this.assertQuery("select-choose x.y y, x1.y y1, x2.y y2 from ((select-choose y from (tab)) x cross join (select-choose y from (tab)) x1 cross join (select-choose y from (tab)) x2)", "with x as (select * from tab) x cross join x x1 cross join x x2", this.modelOf("tab").col("y", 3));
    }

    @Test
    public void testJoinWithClausesDefaultAlias() throws SqlException {
        this.assertQuery("select-choose cust.customerId customerId, cust.name name, ord.customerId customerId1 from ((customers where name ~ 'X') cust outer join (select-choose customerId from (orders where amount > 100)) ord on ord.customerId = cust.customerId post-join-where ord.customerId != null limit 10)", "with cust as (customers where name ~ 'X'), ord as (select customerId from orders where amount > 100) cust outer join ord on (customerId)  where ord.customerId != null limit 10", this.modelOf("customers").col("customerId", 3).col("name", 7), this.modelOf("orders").col("customerId", 3).col("amount", 6));
    }

    @Test
    public void testJoinWithClausesExplicitAlias() throws SqlException {
        this.assertQuery("select-choose c.customerId customerId, c.name name, o.customerId customerId1 from ((customers where name ~ 'X') c outer join (select-choose customerId from (orders where amount > 100)) o on o.customerId = c.customerId post-join-where o.customerId != null limit 10)", "with cust as (customers where name ~ 'X'), ord as (select customerId from orders where amount > 100) cust c outer join ord o on (customerId)  where o.customerId != null limit 10", this.modelOf("customers").col("customerId", 3).col("name", 7), this.modelOf("orders").col("customerId", 3).col("amount", 6));
    }

    @Test
    public void testJoinWithFilter() throws Exception {
        this.assertQuery("select-choose customers.customerId customerId, orders.orderId orderId, d.orderId orderId1, d.productId productId, d.quantity quantity, products.productId productId1, products.supplier supplier, products.price price, suppliers.supplier supplier1 from (customers join (orderDetails d where productId = orderId) d on d.productId = customers.customerId join orders on orders.orderId = d.orderId post-join-where d.quantity < orders.orderId join products on products.productId = d.productId post-join-where products.price > d.quantity or d.orderId = orders.orderId join suppliers on suppliers.supplier = products.supplier)", "customers cross join orders join orderDetails d on d.orderId = orders.orderId and d.productId = customers.customerId join products on d.productId = products.productId join suppliers on products.supplier = suppliers.supplier where d.productId = d.orderId and (products.price > d.quantity or d.orderId = orders.orderId) and d.quantity < orders.orderId", this.modelOf("orders").col("orderId", 3), this.modelOf("customers").col("customerId", 3), this.modelOf("orderDetails").col("orderId", 3).col("productId", 3).col("quantity", 6), this.modelOf("products").col("productId", 3).col("supplier", 3).col("price", 6), this.modelOf("suppliers").col("supplier", 3));
    }

    @Test
    public void testJoinWithFunction() throws SqlException {
        this.assertQuery("select-choose x1.a a, x1.s s, x2.a a1, x2.s s1 from ((select-choose a, s from (random_cursor(10,'a',rnd_int(),'s',rnd_symbol(4,4,4,2)))) x1 join (select-choose a, s from (random_cursor(10,'a',rnd_int(),'s',rnd_symbol(4,4,4,2)))) x2 on x2.s = x1.s)", "with x as (select * from random_cursor(10, 'a', rnd_int(), 's', rnd_symbol(4,4,4,2))) select * from x x1 join x x2 on (s)", new TableModel[0]);
    }

    @Test
    public void testLatestBySyntax() {
        SqlParserTest.assertSyntaxError("select * from tab latest", 24, "'by' expected", new TableModel[0]);
    }

    @Test
    public void testLexerReset() {
        for (int i = 0; i < 10; ++i) {
            try {
                compiler.compileExecutionModel((CharSequence)"select \n-- ltod(Date)\ncount() \n-- from acc\nfrom acc(Date) sample by 1d\n-- where x = 10\n", (SqlExecutionContext)sqlExecutionContext);
                Assert.fail();
                continue;
            }
            catch (SqlException e) {
                TestUtils.assertEquals((CharSequence)"Invalid column: Date", e.getFlyweightMessage());
            }
        }
    }

    @Test
    public void testLineCommentAtEnd() throws Exception {
        this.assertQuery("select-choose x, a from ((x where a > 1 and x > 1) 'b a')", "(x where a > 1) 'b a' where x > 1\n--this is comment", this.modelOf("x").col("x", 3).col("a", 3));
    }

    @Test
    public void testLineCommentAtMiddle() throws Exception {
        this.assertQuery("select-choose x, a from ((x where a > 1 and x > 1) 'b a')", "(x where a > 1) \n -- this is a comment \n'b a' where x > 1", this.modelOf("x").col("x", 3).col("a", 3));
    }

    @Test
    public void testLineCommentAtStart() throws Exception {
        this.assertQuery("select-choose x, a from ((x where a > 1 and x > 1) 'b a')", "-- hello, this is a comment\n (x where a > 1) 'b a' where x > 1", this.modelOf("x").col("x", 3).col("a", 3));
    }

    @Test
    public void testMissingArgument() {
        SqlParserTest.assertSyntaxError("select x from tab where not (x != 1 and)", 36, "Missing right argument", this.modelOf("tab").col("x", 3));
    }

    @Test
    public void testMissingTable() {
        SqlParserTest.assertSyntaxError("select a from", 13, "table name or sub-query expected", new TableModel[0]);
    }

    @Test
    public void testMissingTableInSubQuery() {
        SqlParserTest.assertSyntaxError("with x as (select a from) x", 25, "table name or sub-query expected", this.modelOf("tab").col("b", 3));
    }

    @Test
    public void testMissingWhere() {
        try {
            compiler.compileExecutionModel((CharSequence)"select id, x + 10, x from tab id ~ 'HBRO'", (SqlExecutionContext)sqlExecutionContext);
            Assert.fail((String)"Exception expected");
        }
        catch (SqlException e) {
            Assert.assertEquals((long)33L, (long)e.getPosition());
        }
    }

    @Test
    public void testMixedFieldsSubQuery() throws Exception {
        this.assertQuery("select-choose x, y from ((select-virtual x, z + x y from (tab t2 latest by x where x > 100)) t1 where y > 0)", "select x, y from (select x,z + x y from tab t2 latest by x where x > 100) t1 where y > 0", this.modelOf("tab").col("x", 3).col("z", 3));
    }

    @Test
    public void testMostRecentWhereClause() throws Exception {
        this.assertQuery("select-virtual x, sum + 25 ohoh from (select-group-by x, sum(z) sum from (select-virtual a + b * c x, z from (zyzy latest by x where a in (x,y) and b = 10)))", "select a+b*c x, sum(z)+25 ohoh from zyzy latest by x where a in (x,y) and b = 10", this.modelOf("zyzy").col("a", 3).col("b", 3).col("c", 3).col("x", 3).col("y", 3).col("z", 3));
    }

    @Test
    public void testMultipleExpressions() throws Exception {
        this.assertQuery("select-virtual x, sum + 25 ohoh from (select-group-by x, sum(z) sum from (select-virtual a + b * c x, z from (zyzy)))", "select a+b*c x, sum(z)+25 ohoh from zyzy", this.modelOf("zyzy").col("a", 3).col("b", 3).col("c", 3).col("x", 3).col("y", 3).col("z", 3));
    }

    @Test
    public void testNestedJoinReorder() throws Exception {
        this.assertQuery("select-choose x.orderId orderId, x.productId productId, y.orderId orderId1, y.customerId customerId from ((select-choose orders.orderId orderId, products.productId productId from (orders join (orderDetails d where productId = orderId) d on d.orderId = orders.customerId join customers on customers.customerId = orders.customerId join products on products.productId = d.productId join suppliers on suppliers.supplier = products.supplier where orderId = customerId)) x cross join (orders join customers on customers.customerId = orders.customerId join (orderDetails d where orderId = productId) d on d.productId = orders.orderId join suppliers on suppliers.supplier = orders.orderId join products on products.productId = orders.orderId and products.supplier = suppliers.supplier) y)", "with x as (select orders.orderId, products.productId from orders join orderDetails d on d.orderId = orders.orderId and d.orderId = customers.customerId join customers on orders.customerId = customers.customerId join products on d.productId = products.productId join suppliers on products.supplier = suppliers.supplier where d.productId = d.orderId),  y as (orders join customers on orders.customerId = customers.customerId join orderDetails d on d.orderId = orders.orderId and orders.orderId = products.productId join suppliers on products.supplier = suppliers.supplier join products on d.productId = products.productId and orders.orderId = products.productId where orders.orderId = suppliers.supplier) x cross join y", this.modelOf("orders").col("orderId", 3).col("customerId", 3), this.modelOf("customers").col("customerId", 3), this.modelOf("orderDetails").col("orderId", 3).col("productId", 3), this.modelOf("products").col("productId", 3).col("supplier", 3), this.modelOf("suppliers").col("supplier", 3), this.modelOf("shippers").col("shipper", 3));
    }

    @Test
    public void testOneAnalyticColumn() throws Exception {
        this.assertQuery("select-analytic a, b, f(c) f over (partition by b order by ts) from (xyz)", "select a,b, f(c) over (partition by b order by ts) from xyz", this.modelOf("xyz").col("a", 3).col("b", 3).col("c", 3));
    }

    @Test
    public void testOptimiseNotAnd() throws SqlException {
        this.assertQuery("select-choose a, b from (tab where a != b or b != a)", "select a, b from tab where not (a = b and b = a)", this.modelOf("tab").col("a", 3).col("b", 3));
    }

    @Test
    public void testOptimiseNotEqual() throws SqlException {
        this.assertQuery("select-choose a, b from (tab where a != b)", "select a, b from tab where not (a = b)", this.modelOf("tab").col("a", 3).col("b", 3));
    }

    @Test
    public void testOptimiseNotGreater() throws SqlException {
        this.assertQuery("select-choose a, b from (tab where a <= b)", "select a, b from tab where not (a > b)", this.modelOf("tab").col("a", 3).col("b", 3));
    }

    @Test
    public void testOptimiseNotGreaterOrEqual() throws SqlException {
        this.assertQuery("select-choose a, b from (tab where a < b)", "select a, b from tab where not (a >= b)", this.modelOf("tab").col("a", 3).col("b", 3));
    }

    @Test
    public void testOptimiseNotLess() throws SqlException {
        this.assertQuery("select-choose a, b from (tab where a >= b)", "select a, b from tab where not (a < b)", this.modelOf("tab").col("a", 3).col("b", 3));
    }

    @Test
    public void testOptimiseNotLessOrEqual() throws SqlException {
        this.assertQuery("select-choose a, b from (tab where a > b)", "select a, b from tab where not (a <= b)", this.modelOf("tab").col("a", 3).col("b", 3));
    }

    @Test
    public void testOptimiseNotLiteral() throws SqlException {
        this.assertQuery("select-choose a, b from (tab where not(a))", "select a, b from tab where not (a)", this.modelOf("tab").col("a", 3).col("b", 3));
    }

    @Test
    public void testOptimiseNotLiteralOr() throws SqlException {
        this.assertQuery("select-choose a, b from (tab where not(a) and b != a)", "select a, b from tab where not (a or b = a)", this.modelOf("tab").col("a", 3).col("b", 3));
    }

    @Test
    public void testOptimiseNotNotEqual() throws SqlException {
        this.assertQuery("select-choose a, b from (tab where a = b)", "select a, b from tab where not (a != b)", this.modelOf("tab").col("a", 3).col("b", 3));
    }

    @Test
    public void testOptimiseNotNotNotEqual() throws SqlException {
        this.assertQuery("select-choose a, b from (tab where a != b)", "select a, b from tab where not(not (a != b))", this.modelOf("tab").col("a", 3).col("b", 3));
    }

    @Test
    public void testOptimiseNotOr() throws SqlException {
        this.assertQuery("select-choose a, b from (tab where a != b and b != a)", "select a, b from tab where not (a = b or b = a)", this.modelOf("tab").col("a", 3).col("b", 3));
    }

    @Test
    public void testOptimiseNotOrLiterals() throws SqlException {
        this.assertQuery("select-choose a, b from (tab where not(a) and not(b))", "select a, b from tab where not (a or b)", this.modelOf("tab").col("a", 3).col("b", 3));
    }

    @Test
    public void testOptionalSelect() throws Exception {
        this.assertQuery("select-choose x from (tab t2 latest by x where x > 100)", "tab t2 latest by x where x > 100", this.modelOf("tab").col("x", 3));
    }

    @Test
    public void testOrderBy1() throws Exception {
        this.assertQuery("select-choose x, y from (select-choose x, y, z from (tab) order by x, y, z)", "select x,y from tab order by x,y,z", this.modelOf("tab").col("x", 3).col("y", 3).col("z", 3));
    }

    @Test
    public void testOrderByAmbiguousColumn() {
        SqlParserTest.assertSyntaxError("select tab1.x from tab1 join tab2 on (x) order by y", 50, "Ambiguous", this.modelOf("tab1").col("x", 3).col("y", 3), this.modelOf("tab2").col("x", 3).col("y", 3));
    }

    @Test
    public void testOrderByExpression() {
        SqlParserTest.assertSyntaxError("select x, y from tab order by x+y", 31, "unexpected", new TableModel[0]);
    }

    @Test
    public void testOrderByGroupByCol() throws SqlException {
        this.assertQuery("select-group-by a, sum(b) b from (tab) order by b", "select a, sum(b) b from tab order by b", this.modelOf("tab").col("a", 3).col("b", 3));
    }

    @Test
    public void testOrderByGroupByColPrefixed() throws SqlException {
        this.assertQuery("select-group-by a, sum(b) b from (tab)", "select a, sum(b) b from tab order by tab.b, a", this.modelOf("tab").col("a", 3).col("b", 3));
    }

    @Test
    public void testOrderByGroupByColPrefixed2() throws SqlException {
        this.assertQuery("select-group-by a, sum(b) b from (tab) order by a", "select a, sum(b) b from tab order by a, tab.b", this.modelOf("tab").col("a", 3).col("b", 3));
    }

    @Test
    public void testOrderByGroupByColPrefixed3() throws SqlException {
        this.assertQuery("select-group-by a, sum(b) b from (tab) order by a", "select a, sum(b) b from tab order by tab.a, tab.b", this.modelOf("tab").col("a", 3).col("b", 3));
    }

    @Test
    public void testOrderByOnAliasedColumn() throws SqlException {
        this.assertQuery("select-choose y from (select-choose y, tab.x x from (tab) order by x)", "select y from tab order by tab.x", this.modelOf("tab").col("x", 6).col("y", 3));
    }

    @Test
    public void testOrderByOnExpression() throws SqlException {
        this.assertQuery("select-virtual y + x z from (tab) order by z", "select y+x z from tab order by z", this.modelOf("tab").col("x", 6).col("y", 3));
    }

    @Test
    public void testOrderByOnJoinSubQuery() throws SqlException {
        this.assertQuery("select-choose x, y from (select-choose a.x x, b.y y, b.s s from ((select-choose x, z from (tab1 where x = 'Z')) a join (tab2 where s ~ 'K') b on b.z = a.z) order by s)", "select a.x, b.y from (select x,z from tab1 where x = 'Z' order by x) a join (tab2 where s ~ 'K') b on a.z=b.z order by b.s", this.modelOf("tab1").col("x", 3).col("z", 3), this.modelOf("tab2").col("x", 3).col("y", 3).col("z", 3).col("s", 3));
    }

    @Test
    public void testOrderByOnJoinSubQuery2() throws SqlException {
        this.assertQuery("select-choose a.x x, b.y y from ((select-choose x, z from (select-choose x, z, p from (tab1 where x = 'Z') order by p)) a join (tab2 where s ~ 'K') b on b.z = a.z)", "select a.x, b.y from (select x,z from tab1 where x = 'Z' order by p) a join (tab2 where s ~ 'K') b on a.z=b.z", this.modelOf("tab1").col("x", 3).col("z", 3).col("p", 3), this.modelOf("tab2").col("x", 3).col("y", 3).col("z", 3).col("s", 3));
    }

    @Test
    public void testOrderByOnJoinSubQuery3() throws SqlException {
        this.assertQuery("select-choose a.x x, b.y y from ((select-choose x from (select-choose x, z from (tab1 where x = 'Z') order by z)) a asof join (select-choose y, z from (select-choose y, z, s from (tab2 where s ~ 'K') order by s)) b on b.z = a.x)", "select a.x, b.y from (select x from tab1 where x = 'Z' order by z) a asof join (select y,z from tab2 where s ~ 'K' order by s) b where a.x = b.z", this.modelOf("tab1").col("x", 3).col("z", 3), this.modelOf("tab2").col("x", 3).col("y", 3).col("z", 3).col("s", 3));
    }

    @Test
    public void testOrderByOnJoinTableReference() throws SqlException {
        this.assertQuery("select-choose x, y from (select-choose a.x x, b.y y, b.s s from (tab1 a join tab2 b on b.z = a.z) order by s)", "select a.x, b.y from tab1 a join tab2 b on a.z = b.z order by b.s", this.modelOf("tab1").col("x", 3).col("z", 3), this.modelOf("tab2").col("x", 3).col("y", 3).col("z", 3).col("s", 3));
    }

    @Test
    public void testOrderByOnMultipleColumns() throws SqlException {
        this.assertQuery("select-choose z from (select-choose y z, x from (tab) order by z desc, x)", "select y z from tab order by z desc, x", this.modelOf("tab").col("x", 6).col("y", 3));
    }

    @Test
    public void testOrderByOnNonSelectedColumn() throws SqlException {
        this.assertQuery("select-choose y from (select-choose y, x from (tab) order by x)", "select y from tab order by x", this.modelOf("tab").col("x", 6).col("y", 3));
    }

    @Test
    public void testOrderByOnNonSelectedColumn2() throws SqlException {
        this.assertQuery("select-choose column from (select-virtual 2 * y + x column, x from (select-choose 2 * y + x column, x from (tab)) order by x)", "select 2*y+x from tab order by x", this.modelOf("tab").col("x", 6).col("y", 3));
    }

    @Test
    public void testOrderByOnNonSelectedColumn3() throws SqlException {
        this.assertQuery("select-choose column, column1 from (select-virtual 2 * y + x column, 3 / x column1, x from (select-choose 2 * y + x column, 3 / x column1, x from (tab)) order by x)", "select 2*y+x, 3/x from tab order by x", this.modelOf("tab").col("x", 6).col("y", 3));
    }

    @Test
    public void testOrderByOnOuterResult() throws SqlException {
        this.assertQuery("select-virtual x, sum1 + sum z from (select-group-by x, sum(3 / x) sum, sum(2 * y + x) sum1 from (tab)) order by z", "select x, sum(2*y+x) + sum(3/x) z from tab order by z asc, tab.y desc", this.modelOf("tab").col("x", 6).col("y", 3));
    }

    @Test
    public void testOrderByOnSelectedAlias() throws SqlException {
        this.assertQuery("select-choose y z from (tab) order by z", "select y z from tab order by z", this.modelOf("tab").col("x", 6).col("y", 3));
    }

    @Test
    public void testOrderByWithSampleBy() throws SqlException {
        this.assertQuery("select-group-by a, sum(b) sum from ((tab order by t) _xQdbA1) timestamp (t) sample by 2m order by a", "select a, sum(b) from (tab order by t) timestamp(t) sample by 2m order by a", this.modelOf("tab").col("a", 3).col("b", 3).col("t", 12));
    }

    @Test
    public void testOrderByWithSampleBy2() throws SqlException {
        this.assertQuery("select-group-by a, sum(b) sum from ((select-group-by a, sum(b) b from ((tab order by t) _xQdbA3) timestamp (t) sample by 10m) _xQdbA1) order by a", "select a, sum(b) from (select a,sum(b) b from (tab order by t) timestamp(t) sample by 10m order by t) order by a", this.modelOf("tab").col("a", 3).col("b", 3).col("t", 12));
    }

    @Test
    public void testOuterJoin() throws Exception {
        this.assertQuery("select-choose a.x x from (a a outer join b on b.x = a.x)", "select a.x from a a outer join b on b.x = a.x", this.modelOf("a").col("x", 3), this.modelOf("b").col("x", 3));
    }

    @Test
    public void testOuterJoinColumnAlias() throws SqlException {
        this.assertQuery("select-choose customerId, kk, count from ((select-group-by customerId, kk, count() count from (select-choose c.customerId customerId, o.customerId kk from (customers c outer join orders o on o.customerId = c.customerId post-join-where o.customerId = NaN))) _xQdbA1 limit 10)", "(select c.customerId, o.customerId kk, count() from customers c outer join orders o on c.customerId = o.customerId)  where kk = NaN limit 10", this.modelOf("customers").col("customerId", 3), this.modelOf("orders").col("customerId", 3));
    }

    @Test
    public void testOuterJoinColumnAliasConst() throws SqlException {
        this.assertQuery("select-choose customerId, kk, count from ((select-group-by customerId, kk, count() count from (select-choose c.customerId customerId, o.customerId kk from (customers c outer join (orders o where customerId = 10) o on o.customerId = c.customerId))) _xQdbA1 limit 10)", "(select c.customerId, o.customerId kk, count() from customers c outer join orders o on c.customerId = o.customerId)  where kk = 10 limit 10", this.modelOf("customers").col("customerId", 3), this.modelOf("orders").col("customerId", 3));
    }

    @Test
    public void testOuterJoinColumnAliasNull() throws SqlException {
        this.assertQuery("select-choose customerId, kk, count from ((select-group-by customerId, kk, count() count from (select-choose c.customerId customerId, o.customerId kk from (customers c outer join orders o on o.customerId = c.customerId post-join-where o.customerId = null))) _xQdbA1 limit 10)", "(select c.customerId, o.customerId kk, count() from customers c outer join orders o on c.customerId = o.customerId)  where kk = null limit 10", this.modelOf("customers").col("customerId", 3), this.modelOf("orders").col("customerId", 3));
    }

    @Test
    public void testSampleBy() throws Exception {
        this.assertQuery("select-group-by x, sum(y) sum from (tab timestamp (timestamp)) sample by 2m", "select x,sum(y) from tab sample by 2m", this.modelOf("tab").col("x", 3).col("y", 3).timestamp());
    }

    @Test
    public void testSampleByAliasedColumn() throws SqlException {
        this.assertQuery("select-group-by b, sum(a) sum, k, k k1 from (x y timestamp (timestamp)) sample by 3h", "select b, sum(a), k, k from x y sample by 3h", this.modelOf("x").col("a", 6).col("b", 8).col("k", 12).timestamp());
    }

    @Test
    public void testSampleByAlreadySelected() throws Exception {
        this.assertQuery("select-group-by x, sum(y) sum from (tab timestamp (x)) sample by 2m", "select x,sum(y) from tab timestamp(x) sample by 2m", this.modelOf("tab").col("x", 12).col("y", 3));
    }

    @Test
    public void testSampleByAltTimestamp() throws Exception {
        this.assertQuery("select-group-by x, sum(y) sum from (tab timestamp (t)) sample by 2m", "select x,sum(y) from tab timestamp(t) sample by 2m", this.modelOf("tab").col("x", 3).col("y", 3).col("t", 12));
    }

    @Test
    public void testSampleByFillList() throws SqlException {
        this.assertQuery("select-group-by a, sum(b) b from (tab timestamp (t)) sample by 10m fill(21.1,22,null,98)", "select a,sum(b) b from tab timestamp(t) sample by 10m fill(21.1,22,null,98)", this.modelOf("tab").col("a", 3).col("b", 3).col("t", 12));
    }

    @Test
    public void testSampleByFillMin() throws SqlException {
        this.assertQuery("select-group-by a, sum(b) b from (tab timestamp (t)) sample by 10m fill(mid)", "select a,sum(b) b from tab timestamp(t) sample by 10m fill(mid)", this.modelOf("tab").col("a", 3).col("b", 3).col("t", 12));
    }

    @Test
    public void testSampleByFillMissingCloseBrace() {
        SqlParserTest.assertSyntaxError("select a,sum(b) b from tab timestamp(t) sample by 10m fill (21231.2344", 70, "')' expected", this.modelOf("tab").col("a", 3).col("b", 3).col("t", 12));
    }

    @Test
    public void testSampleByFillMissingOpenBrace() {
        SqlParserTest.assertSyntaxError("select a,sum(b) b from tab timestamp(t) sample by 10m fill 21231.2344", 59, "'(' expected", this.modelOf("tab").col("a", 3).col("b", 3).col("t", 12));
    }

    @Test
    public void testSampleByFillMissingValue() {
        SqlParserTest.assertSyntaxError("select a,sum(b) b from tab timestamp(t) sample by 10m fill ()", 60, "'none', 'prev', 'mid', 'null' or number expected", this.modelOf("tab").col("a", 3).col("b", 3).col("t", 12));
    }

    @Test
    public void testSampleByFillValue() throws SqlException {
        this.assertQuery("select-group-by a, sum(b) b from (tab timestamp (t)) sample by 10m fill(21231.2344)", "select a,sum(b) b from tab timestamp(t) sample by 10m fill(21231.2344)", this.modelOf("tab").col("a", 3).col("b", 3).col("t", 12));
    }

    @Test
    public void testSampleByIncorrectPlacement() {
        SqlParserTest.assertSyntaxError("select a, sum(b) from ((tab order by t) timestamp(t) sample by 10m order by t) order by a", 63, "'sample by' must be used with 'select'", this.modelOf("tab").col("a", 3).col("b", 3).col("t", 12));
    }

    @Test
    public void testSampleByInvalidColumn() {
        SqlParserTest.assertSyntaxError("select x,sum(y) from tab timestamp(z) sample by 2m", 35, "Invalid column", this.modelOf("tab").col("x", 3).col("y", 3).timestamp());
    }

    @Test
    public void testSampleByInvalidType() {
        SqlParserTest.assertSyntaxError("select x,sum(y) from tab timestamp(x) sample by 2m", 35, "not a TIMESTAMP", this.modelOf("tab").col("x", 3).col("y", 3).timestamp());
    }

    @Test
    public void testSampleByNoAggregate() {
        SqlParserTest.assertSyntaxError("select x,y from tab sample by 2m", 30, "at least one", this.modelOf("tab").col("x", 3).col("y", 3).timestamp());
    }

    @Test
    public void testSampleByUndefinedTimestamp() {
        SqlParserTest.assertSyntaxError("select x,sum(y) from tab sample by 2m", 35, "TIMESTAMP column is not defined", this.modelOf("tab").col("x", 3).col("y", 3));
    }

    @Test
    public void testSelectAliasAsFunction() {
        SqlParserTest.assertSyntaxError("select sum(x) x() from tab", 15, "',' or 'from' expected", this.modelOf("tab").col("x", 3));
    }

    @Test
    public void testSelectAnalyticOperator() {
        SqlParserTest.assertSyntaxError("select sum(x), 2*x over() from tab", 16, "Analytic function expected", this.modelOf("tab").col("x", 3));
    }

    @Test
    public void testSelectColumnWithAlias() throws SqlException {
        this.assertQuery("select-virtual a, rnd_int() c from (select-choose x a from (long_sequence(5)))", "select x a, rnd_int() c from long_sequence(5)", new TableModel[0]);
    }

    @Test
    public void testSelectFromNonCursorFunction() {
        SqlParserTest.assertSyntaxError("select * from length('')", 14, "function must return CURSOR", new TableModel[0]);
    }

    @Test
    public void testSelectFromSubQuery() throws SqlException {
        this.assertQuery("select-choose x from ((tab where y > 10) a)", "select a.x from (tab where y > 10) a", this.modelOf("tab").col("x", 3).col("y", 3));
    }

    @Test
    public void testSelectGroupByAndAnalytic() {
        SqlParserTest.assertSyntaxError("select sum(x), count() over() from tab", 0, "Analytic function is not allowed", this.modelOf("tab").col("x", 3));
    }

    @Test
    public void testSelectGroupByArithmetic() throws SqlException {
        this.assertQuery("select-virtual sum + 10 column, sum1 from (select-group-by sum(x) sum, sum(y) sum1 from (tab))", "select sum(x)+10, sum(y) from tab", this.modelOf("tab").col("x", 3).col("y", 3));
    }

    @Test
    public void testSelectMissingExpression() {
        SqlParserTest.assertSyntaxError("select ,a from tab", 7, "missing expression", new TableModel[0]);
    }

    @Test
    public void testSelectMissingExpression2() {
        SqlParserTest.assertSyntaxError("select a, from tab", 15, "column name expected", new TableModel[0]);
    }

    @Test
    public void testSelectOnItsOwn() {
        SqlParserTest.assertSyntaxError("select ", 7, "column expected", new TableModel[0]);
    }

    @Test
    public void testSelectPlainColumns() throws Exception {
        this.assertQuery("select-choose a, b, c from (t)", "select a,b,c from t", this.modelOf("t").col("a", 3).col("b", 3).col("c", 3));
    }

    @Test
    public void testSelectSelectColumn() {
        SqlParserTest.assertSyntaxError("select a, select from tab", 17, "reserved name", new TableModel[0]);
    }

    @Test
    public void testSelectSingleExpression() throws Exception {
        this.assertQuery("select-virtual a + b * c x from (t)", "select a+b*c x from t", this.modelOf("t").col("a", 3).col("b", 3).col("c", 3));
    }

    @Test
    public void testSelectWildcard() throws SqlException {
        this.assertQuery("select-choose tab1.x x, tab1.y y, tab2.x x1, tab2.z z from (tab1 join tab2 on tab2.x = tab1.x)", "select * from tab1 join tab2 on (x)", this.modelOf("tab1").col("x", 3).col("y", 3), this.modelOf("tab2").col("x", 3).col("z", 3));
    }

    @Test
    public void testSelectWildcardAndExpr() throws SqlException {
        this.assertQuery("select-virtual x, y, x1, z, x + y1 column1 from (select-choose tab1.x x, tab1.y y, tab2.x x1, tab2.z z, y y1 from (tab1 join tab2 on tab2.x = tab1.x))", "select *, tab1.x + y from tab1 join tab2 on (x)", this.modelOf("tab1").col("x", 3).col("y", 3), this.modelOf("tab2").col("x", 3).col("z", 3));
    }

    @Test
    public void testSelectWildcardAndTimestamp() throws SqlException {
        this.assertQuery("select-choose x, y from ((select-choose x, y from (tab1)) _xQdbA1) timestamp (y)", "select * from (select x, y from tab1) timestamp(y)", this.modelOf("tab1").col("x", 3).col("y", 12));
    }

    @Test
    public void testSelectWildcardDetachedStar() {
        SqlParserTest.assertSyntaxError("select tab2.*, bxx.  * from tab1 a join tab2 on (x)", 19, "whitespace is not allowed", this.modelOf("tab1").col("x", 3).col("y", 3), this.modelOf("tab2").col("x", 3).col("z", 3));
    }

    @Test
    public void testSelectWildcardInvalidTableAlias() {
        SqlParserTest.assertSyntaxError("select tab2.*, b.* from tab1 a join tab2 on (x)", 17, "invalid table alias", this.modelOf("tab1").col("x", 3).col("y", 3), this.modelOf("tab2").col("x", 3).col("z", 3));
    }

    @Test
    public void testSelectWildcardMissingStar() {
        SqlParserTest.assertSyntaxError("select tab2.*, bxx. from tab1 a join tab2 on (x)", 19, "'*' expected", this.modelOf("tab1").col("x", 3).col("y", 3), this.modelOf("tab2").col("x", 3).col("z", 3));
    }

    @Test
    public void testSelectWildcardPrefixed() throws SqlException {
        this.assertQuery("select-choose tab2.x x, tab2.z z, tab1.x x1, tab1.y y from (tab1 join tab2 on tab2.x = tab1.x)", "select tab2.*, tab1.* from tab1 join tab2 on (x)", this.modelOf("tab1").col("x", 3).col("y", 3), this.modelOf("tab2").col("x", 3).col("z", 3));
    }

    @Test
    public void testSelectWildcardPrefixed2() throws SqlException {
        this.assertQuery("select-choose tab2.x x, tab2.z z, a.x x1, a.y y from (tab1 a join tab2 on tab2.x = a.x)", "select tab2.*, a.* from tab1 a join tab2 on (x)", this.modelOf("tab1").col("x", 3).col("y", 3), this.modelOf("tab2").col("x", 3).col("z", 3));
    }

    @Test
    public void testSimpleSubQuery() throws Exception {
        this.assertQuery("select-choose y from ((x where y > 1) _xQdbA1)", "(x) where y > 1", this.modelOf("x").col("y", 3));
    }

    @Test
    public void testSingleTableLimit() throws Exception {
        this.assertQuery("select-choose x, y from (tab where x > z limit 100)", "select x x, y y from tab where x > z limit 100", this.modelOf("tab").col("x", 3).col("y", 3).col("z", 3));
    }

    @Test
    public void testSingleTableLimitLoHi() throws Exception {
        this.assertQuery("select-choose x, y from (tab where x > z limit 100,200)", "select x x, y y from tab where x > z limit 100,200", this.modelOf("tab").col("x", 3).col("y", 3).col("z", 3));
    }

    @Test
    public void testSingleTableLimitLoHiExtraToken() {
        SqlParserTest.assertSyntaxError("select x x, y y from tab where x > z limit 100,200 b", 51, "unexpected", new TableModel[0]);
    }

    @Test
    public void testSingleTableNoWhereLimit() throws Exception {
        this.assertQuery("select-choose x, y from (tab limit 100)", "select x x, y y from tab limit 100", this.modelOf("tab").col("x", 3).col("y", 3));
    }

    @Test
    public void testStackOverflow() {
        SqlParserTest.assertSyntaxError("SELECT sym, sum(amount) from (SELECT a.amount, a.sym\nFROM 'tab' a\nLEFT OUTER JOIN 'tab' b\nON a.orderID = b.orderID \nAND a.seq < b.seq\nWHERE b.orderID IS NULL\nORDER BY a.seq desc) AS x group by sym", 10, "unexpected token", this.modelOf("tab").col("sym", 3).col("amount", 4).col("orderID", 4).col("seq", 4));
    }

    @Test
    public void testSubQuery() throws Exception {
        this.assertQuery("select-choose x, y from ((select-choose x, y from (tab t2 latest by x where x > 100 and y > 0)) t1)", "select x, y from (select x, y from tab t2 latest by x where x > 100) t1 where y > 0", this.modelOf("tab").col("x", 3).col("y", 3));
    }

    @Test
    public void testSubQueryAliasWithSpace() throws Exception {
        this.assertQuery("select-choose x, a from ((x where a > 1 and x > 1) 'b a')", "(x where a > 1) 'b a' where x > 1", this.modelOf("x").col("x", 3).col("a", 3));
    }

    @Test
    public void testSubQueryAsArg() throws Exception {
        this.assertQuery("select-choose customerId from (customers where (select-choose orderId from (orders)) > 1)", "select * from customers where (select * from orders) > 1", this.modelOf("orders").col("orderId", 3), this.modelOf("customers").col("customerId", 3));
    }

    @Test
    public void testSubQueryLimitLoHi() throws Exception {
        this.assertQuery("select-choose x, y from ((select-choose x, y from (tab where x > z and x = y limit 100,200)) _xQdbA1 limit 150)", "(select x x, y y from tab where x > z limit 100,200) where x = y limit 150", this.modelOf("tab").col("x", 3).col("y", 3).col("z", 3));
    }

    @Test
    public void testSubQuerySyntaxError() {
        SqlParserTest.assertSyntaxError("select x from (select tab. tab where x > 10 t1)", 26, "'*' expected", new TableModel[0]);
    }

    @Test
    public void testTableNameAsArithmetic() {
        SqlParserTest.assertSyntaxError("select x from 'tab' + 1", 20, "function, literal or constant is expected", this.modelOf("tab").col("x", 3));
    }

    @Test
    public void testTableNameCannotOpen() {
        FilesFacadeImpl ff = new FilesFacadeImpl(){

            public long openRO(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"_meta")) {
                    return -1L;
                }
                return super.openRO(name);
            }
        };
        DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root, (FilesFacade)ff){
            final /* synthetic */ FilesFacade val$ff;
            {
                this.val$ff = filesFacade;
                super(x0);
            }

            public FilesFacade getFilesFacade() {
                return this.val$ff;
            }
        };
        Engine engine = new Engine((CairoConfiguration)configuration);
        SqlCompiler compiler = new SqlCompiler((CairoEngine)engine, (CairoConfiguration)configuration);
        SqlParserTest.assertSyntaxError(compiler, (CairoEngine)engine, "select * from tab", 14, "Cannot open file", this.modelOf("tab").col("x", 3));
    }

    @Test
    public void testTableNameJustNoRowidMarker() {
        SqlParserTest.assertSyntaxError("select * from '*!*'", 14, "come on", new TableModel[0]);
    }

    @Test
    public void testTableNameLocked() {
        engine.lock((CharSequence)"tab");
        try {
            SqlParserTest.assertSyntaxError("select * from tab", 14, "table is locked", this.modelOf("tab").col("x", 3));
        }
        finally {
            engine.unlock((CharSequence)"tab", null);
        }
    }

    @Test
    public void testTableNameReserved() {
        try (Path path = new Path();){
            configuration.getFilesFacade().touch((LPSZ)path.of(root).concat((CharSequence)"tab").$());
        }
        SqlParserTest.assertSyntaxError("select * from tab", 14, "table directory is of unknown format", new TableModel[0]);
    }

    @Test
    public void testTableNameWithNoRowidMarker() throws SqlException {
        this.assertQuery("select-choose x from (*!*tab)", "select * from '*!*tab'", this.modelOf("tab").col("x", 3));
    }

    @Test
    public void testTimestampOnSubQuery() throws Exception {
        this.assertQuery("select-choose x from ((a b where x > y) _xQdbA1) timestamp (x)", "select x from (a b) timestamp(x) where x > y", this.modelOf("a").col("x", 3).col("y", 3));
    }

    @Test
    public void testTimestampOnTable() throws Exception {
        this.assertQuery("select-choose x from (a b timestamp (x) where x > y)", "select x from a b timestamp(x) where x > y", this.modelOf("a").col("x", 12).col("y", 12));
    }

    @Test
    public void testTooManyColumnsEdgeInOrderBy() throws Exception {
        try (TableModel model = new TableModel(configuration, "x", 3);){
            for (int i = 0; i < 1559; ++i) {
                model.col("f" + i, 3);
            }
            CairoTestUtils.create(model);
        }
        StringBuilder b = new StringBuilder();
        b.append("x order by ");
        for (int i = 0; i < 1559; ++i) {
            if (i > 0) {
                b.append(',');
            }
            b.append('f').append(i);
        }
        QueryModel st = (QueryModel)compiler.compileExecutionModel((CharSequence)b, (SqlExecutionContext)sqlExecutionContext);
        Assert.assertEquals((long)1559L, (long)st.getOrderBy().size());
    }

    @Test
    public void testTooManyColumnsInOrderBy() {
        StringBuilder b = new StringBuilder();
        b.append("x order by ");
        for (int i = 0; i < 1560; ++i) {
            if (i > 0) {
                b.append(',');
            }
            b.append('f').append(i);
        }
        try {
            compiler.compileExecutionModel((CharSequence)b, (SqlExecutionContext)sqlExecutionContext);
        }
        catch (SqlException e) {
            TestUtils.assertEquals((CharSequence)"Too many columns", e.getFlyweightMessage());
        }
    }

    @Test
    public void testTwoAnalyticColumns() throws Exception {
        this.assertQuery("select-analytic a, b, f(c) my over (partition by b order by ts), d(c) d over () from (xyz)", "select a,b, f(c) my over (partition by b order by ts), d(c) over() from xyz", this.modelOf("xyz").col("c", 3).col("b", 3).col("a", 3));
    }

    @Test
    public void testUnbalancedBracketInSubQuery() {
        SqlParserTest.assertSyntaxError("select x from (tab where x > 10 t1", 32, "expected", new TableModel[0]);
    }

    @Test
    public void testUnderTerminatedOver() {
        SqlParserTest.assertSyntaxError("select a,b, f(c) my over (partition by b order by ts from xyz", 53, "expected", new TableModel[0]);
    }

    @Test
    public void testUnderTerminatedOver2() {
        SqlParserTest.assertSyntaxError("select a,b, f(c) my over (partition by b order by ts", 52, "'asc' or 'desc' expected", new TableModel[0]);
    }

    @Test
    public void testUnexpectedTokenInAnalyticFunction() {
        SqlParserTest.assertSyntaxError("select a,b, f(c) my over (by b order by ts) from xyz", 26, "expected", new TableModel[0]);
    }

    @Test
    public void testWhereClause() throws Exception {
        this.assertQuery("select-virtual x, sum + 25 ohoh from (select-group-by x, sum(z) sum from (select-virtual a + b * c x, z from (zyzy where a in (0,10) and b = 10)))", "select a+b*c x, sum(z)+25 ohoh from zyzy where a in (0,10) and b = 10", this.modelOf("zyzy").col("a", 3).col("b", 3).col("c", 3).col("x", 3).col("y", 3).col("z", 3));
    }

    @Test
    public void testWithDuplicateName() {
        SqlParserTest.assertSyntaxError("with x as (tab), x as (tab2) x", 17, "duplicate name", this.modelOf("tab").col("x", 3), this.modelOf("tab2").col("x", 3));
    }

    @Test
    public void testWithSelectFrom() throws SqlException {
        this.assertQuery("select-choose a from ((select-choose a from (tab)) x)", "with x as ( select a from tab) select a from x", this.modelOf("tab").col("a", 3));
    }

    @Test
    public void testWithSelectFrom2() throws SqlException {
        this.assertQuery("select-choose a from ((select-choose a from (tab)) x)", "with x as ( select a from tab) x", this.modelOf("tab").col("a", 3));
    }

    @Test
    public void testWithSyntaxError() {
        SqlParserTest.assertSyntaxError("with x as ( select ,a from tab) x", 19, "missing expression", this.modelOf("tab").col("a", 3));
    }

    private static void assertSyntaxError(String query, int position, String contains, TableModel ... tableModels) {
        SqlParserTest.assertSyntaxError(compiler, (CairoEngine)engine, query, position, contains, tableModels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertSyntaxError(SqlCompiler compiler, CairoEngine engine, String query, int position, String contains, TableModel ... tableModels) {
        try {
            int n = tableModels.length;
            for (int i = 0; i < n; ++i) {
                CairoTestUtils.create(tableModels[i]);
            }
            compiler.compileExecutionModel((CharSequence)query, (SqlExecutionContext)sqlExecutionContext);
            Assert.fail((String)"Exception expected");
        }
        catch (SqlException e) {
            Assert.assertEquals((long)position, (long)e.getPosition());
            TestUtils.assertContains(e.getMessage(), contains);
        }
        finally {
            Assert.assertTrue((boolean)engine.releaseAllReaders());
            for (TableModel tableModel : tableModels) {
                Path path = tableModel.getPath().of(tableModel.getCairoCfg().getRoot()).concat((CharSequence)tableModel.getName()).put(Files.SEPARATOR).$();
                Assert.assertTrue((boolean)configuration.getFilesFacade().rmdir(path));
                tableModel.close();
            }
        }
    }

    private void assertCreateTable(String expected, String ddl, TableModel ... tableModels) throws SqlException {
        this.assertModel(expected, ddl, 2, tableModels);
    }

    private void assertModel(String expected, String query, int modelType, TableModel ... tableModels) throws SqlException {
        this.createModelsAndRun(() -> {
            sink.clear();
            ExecutionModel model = compiler.compileExecutionModel((CharSequence)query, (SqlExecutionContext)sqlExecutionContext);
            Assert.assertEquals((long)model.getModelType(), (long)modelType);
            ((Sinkable)model).toSink((CharSink)sink);
            TestUtils.assertEquals((CharSequence)expected, (CharSequence)sink);
        }, tableModels);
    }

    private void assertQuery(String expected, String query, TableModel ... tableModels) throws SqlException {
        this.assertModel(expected, query, 1, tableModels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createModelsAndRun(CairoAware runnable, TableModel ... tableModels) throws SqlException {
        try {
            int n = tableModels.length;
            for (int i = 0; i < n; ++i) {
                CairoTestUtils.create(tableModels[i]);
            }
            runnable.run();
        }
        finally {
            Assert.assertTrue((boolean)engine.releaseAllReaders());
            for (TableModel tableModel : tableModels) {
                Path path = tableModel.getPath().of(tableModel.getCairoCfg().getRoot()).concat((CharSequence)tableModel.getName()).put(Files.SEPARATOR).$();
                Assert.assertTrue((boolean)configuration.getFilesFacade().rmdir(path));
                tableModel.close();
            }
        }
    }

    private TableModel modelOf(String tableName) {
        return new TableModel(configuration, tableName, 3);
    }

    @FunctionalInterface
    private static interface CairoAware {
        public void run() throws SqlException;
    }
}

