/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.ColumnType;
import com.questdb.cairo.DefaultCairoConfiguration;
import com.questdb.cairo.Engine;
import com.questdb.cairo.SymbolMapReader;
import com.questdb.cairo.TableReader;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.sql.CairoEngine;
import com.questdb.cairo.sql.RecordCursor;
import com.questdb.cairo.sql.RecordCursorFactory;
import com.questdb.griffin.SqlCompiler;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.functions.bind.BindVariableService;
import com.questdb.griffin.engine.functions.rnd.SharedRandom;
import com.questdb.std.Chars;
import com.questdb.std.FilesFacade;
import com.questdb.std.FilesFacadeImpl;
import com.questdb.std.Rnd;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.Path;
import com.questdb.test.tools.TestUtils;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SqlCompilerTest
extends AbstractCairoTest {
    private static final Engine engine = new Engine(configuration);
    private static final SqlCompiler compiler = new SqlCompiler((CairoEngine)engine, configuration);
    private static final BindVariableService bindVariableService = new BindVariableService();
    private static final Path path = new Path();

    @Test
    public void assertCastString() throws SqlException, IOException {
        String expectedData = "a\nJWCPS\n\nRXPEHNRXG\n\n\nXIBBT\nGWFFY\nEYYQEHBHFO\nPDXYSBEOUO\nHRUEDRQQUL\nJGETJRSZS\nRFBVTMHGO\nZVDZJMY\nCXZOUICWEK\nVUVSDOTS\nYYCTG\nLYXWCKYLSU\nSWUGSHOLNV\n\nBZXIOVI\n";
        String expectedMeta = "{\"columnCount\":1,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"SYMBOL\"}],\"timestampIndex\":-1}";
        String sql = "create table y as (select * from random_cursor( 20, 'a', rnd_str(5,10,2))), cast(a as SYMBOL)";
        this.assertCast("a\nJWCPS\n\nRXPEHNRXG\n\n\nXIBBT\nGWFFY\nEYYQEHBHFO\nPDXYSBEOUO\nHRUEDRQQUL\nJGETJRSZS\nRFBVTMHGO\nZVDZJMY\nCXZOUICWEK\nVUVSDOTS\nYYCTG\nLYXWCKYLSU\nSWUGSHOLNV\n\nBZXIOVI\n", expectedMeta, sql);
    }

    @Before
    public void setUp2() {
        SharedRandom.RANDOM.set(new Rnd());
    }

    @After
    public void tearDown() {
        engine.releaseAllReaders();
        engine.releaseAllWriters();
    }

    @Test
    public void testCannotCreateTable() {
        FilesFacadeImpl ff = new FilesFacadeImpl(){

            public int mkdirs(LPSZ path, int mode) {
                return -1;
            }
        };
        DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root, (FilesFacade)ff){
            final /* synthetic */ FilesFacade val$ff;
            {
                this.val$ff = filesFacade;
                super(x0);
            }

            public FilesFacade getFilesFacade() {
                return this.val$ff;
            }
        };
        Engine engine = new Engine((CairoConfiguration)configuration);
        SqlCompiler compiler = new SqlCompiler((CairoEngine)engine, (CairoConfiguration)configuration);
        try {
            compiler.compile((CharSequence)"create table x (a int)", bindVariableService);
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)13L, (long)e.getPosition());
            TestUtils.assertContains(e.getMessage(), "Could not create table");
        }
    }

    @Test
    public void testCastByteDate() throws SqlException, IOException {
        this.assertCastByte("a\n1970-01-01T00:00:00.119Z\n1970-01-01T00:00:00.052Z\n1970-01-01T00:00:00.091Z\n1970-01-01T00:00:00.097Z\n1970-01-01T00:00:00.119Z\n1970-01-01T00:00:00.107Z\n1970-01-01T00:00:00.039Z\n1970-01-01T00:00:00.081Z\n1970-01-01T00:00:00.046Z\n1970-01-01T00:00:00.041Z\n1970-01-01T00:00:00.061Z\n1970-01-01T00:00:00.082Z\n1970-01-01T00:00:00.075Z\n1970-01-01T00:00:00.095Z\n1970-01-01T00:00:00.087Z\n1970-01-01T00:00:00.116Z\n1970-01-01T00:00:00.087Z\n1970-01-01T00:00:00.040Z\n1970-01-01T00:00:00.116Z\n1970-01-01T00:00:00.117Z\n", 10);
    }

    @Test
    public void testCloseFactoryWithoutUsingCursor() throws Exception {
        String query = "select * from y where j > :lim";
        TestUtils.assertMemoryLeak(() -> {
            try {
                compiler.compile((CharSequence)"create table y as (select to_int(x) i, rnd_symbol('msft','ibm', 'googl') sym2, round(rnd_double(0), 3) price, to_timestamp('2018-01', 'yyyy-MM') + x * 120000000 timestamp, rnd_boolean() b, rnd_str(1,1,2) c, rnd_double(2) d, rnd_float(2) e, rnd_short(10,1024) f, rnd_date(to_date('2015', 'yyyy'), to_date('2016', 'yyyy'), 2) g, rnd_symbol(4,4,4,2) ik, rnd_long() j, timestamp_sequence(to_timestamp(0), 1000000000) k, rnd_byte(2,50) l, rnd_bin(10, 20, 2) m, rnd_str(5,16,2) n from long_sequence(30)) timestamp(timestamp)", bindVariableService);
                bindVariableService.setLong((CharSequence)"lim", 4L);
                RecordCursorFactory factory = compiler.compile((CharSequence)query, bindVariableService);
                factory.close();
            }
            finally {
                engine.releaseAllWriters();
                engine.releaseAllReaders();
            }
        });
    }

    @Test
    public void testCastByteDouble() throws SqlException, IOException {
        this.assertCastByte("a\n119.000000000000\n52.000000000000\n91.000000000000\n97.000000000000\n119.000000000000\n107.000000000000\n39.000000000000\n81.000000000000\n46.000000000000\n41.000000000000\n61.000000000000\n82.000000000000\n75.000000000000\n95.000000000000\n87.000000000000\n116.000000000000\n87.000000000000\n40.000000000000\n116.000000000000\n117.000000000000\n", 6);
    }

    @Test
    public void testCastByteFloat() throws SqlException, IOException {
        this.assertCastByte("a\n119.0000\n52.0000\n91.0000\n97.0000\n119.0000\n107.0000\n39.0000\n81.0000\n46.0000\n41.0000\n61.0000\n82.0000\n75.0000\n95.0000\n87.0000\n116.0000\n87.0000\n40.0000\n116.0000\n117.0000\n", 5);
    }

    @Test
    public void testCastByteInt() throws SqlException, IOException {
        this.assertCastByte("a\n119\n52\n91\n97\n119\n107\n39\n81\n46\n41\n61\n82\n75\n95\n87\n116\n87\n40\n116\n117\n", 3);
    }

    @Test
    public void testCastByteLong() throws SqlException, IOException {
        this.assertCastByte("a\n119\n52\n91\n97\n119\n107\n39\n81\n46\n41\n61\n82\n75\n95\n87\n116\n87\n40\n116\n117\n", 4);
    }

    @Test
    public void testCastByteShort() throws SqlException, IOException {
        this.assertCastByte("a\n119\n52\n91\n97\n119\n107\n39\n81\n46\n41\n61\n82\n75\n95\n87\n116\n87\n40\n116\n117\n", 2);
    }

    @Test
    public void testCastByteTimestamp() throws SqlException, IOException {
        this.assertCastByte("a\n1970-01-01T00:00:00.000119Z\n1970-01-01T00:00:00.000052Z\n1970-01-01T00:00:00.000091Z\n1970-01-01T00:00:00.000097Z\n1970-01-01T00:00:00.000119Z\n1970-01-01T00:00:00.000107Z\n1970-01-01T00:00:00.000039Z\n1970-01-01T00:00:00.000081Z\n1970-01-01T00:00:00.000046Z\n1970-01-01T00:00:00.000041Z\n1970-01-01T00:00:00.000061Z\n1970-01-01T00:00:00.000082Z\n1970-01-01T00:00:00.000075Z\n1970-01-01T00:00:00.000095Z\n1970-01-01T00:00:00.000087Z\n1970-01-01T00:00:00.000116Z\n1970-01-01T00:00:00.000087Z\n1970-01-01T00:00:00.000040Z\n1970-01-01T00:00:00.000116Z\n1970-01-01T00:00:00.000117Z\n", 12);
    }

    @Test
    public void testCastDateByte() throws SqlException, IOException {
        this.assertCastDate("a\n11\n0\n121\n-2\n0\n-43\n-124\n100\n0\n124\n0\n-45\n0\n24\n-16\n58\n0\n-6\n73\n125\n", 1);
    }

    @Test
    public void testCastDateDouble() throws SqlException, IOException {
        this.assertCastDate("a\n1.426297242379E12\n-9.223372036854776E18\n1.446081058169E12\n1.434834113022E12\n-9.223372036854776E18\n1.439739868373E12\n1.443957889668E12\n1.440280260964E12\n-9.223372036854776E18\n1.44318380966E12\n-9.223372036854776E18\n1.435298544851E12\n-9.223372036854776E18\n1.447181628184E12\n1.4423615004E12\n1.428165287226E12\n-9.223372036854776E18\n1.434999533562E12\n1.423736755529E12\n1.426566352765E12\n", 6);
    }

    @Test
    public void testCastDateFloat() throws SqlException, IOException {
        this.assertCastDate("a\n1.42629719E12\n-9.223372E18\n1.44608107E12\n1.43483417E12\n-9.223372E18\n1.43973981E12\n1.44395783E12\n1.44028022E12\n-9.223372E18\n1.44318385E12\n-9.223372E18\n1.43529856E12\n-9.223372E18\n1.44718168E12\n1.44236151E12\n1.42816523E12\n-9.223372E18\n1.43499959E12\n1.4237367E12\n1.42656641E12\n", 5);
    }

    @Test
    public void testCastDateInt() throws SqlException, IOException {
        this.assertCastDate("a\n368100107\n0\n-1322920583\n315036158\n0\n925824213\n848878212\n1466216804\n0\n74798204\n0\n779467987\n0\n-222350568\n-747511056\n-2058822342\n0\n480456698\n2102580553\n637210493\n", 3);
    }

    @Test
    public void testCastDateLong() throws SqlException, IOException {
        this.assertCastDate("a\n1426297242379\nNaN\n1446081058169\n1434834113022\nNaN\n1439739868373\n1443957889668\n1440280260964\nNaN\n1443183809660\nNaN\n1435298544851\nNaN\n1447181628184\n1442361500400\n1428165287226\nNaN\n1434999533562\n1423736755529\n1426566352765\n", 4);
    }

    @Test
    public void testCastDateShort() throws SqlException, IOException {
        this.assertCastDate("a\n-15605\n0\n-10887\n4606\n0\n-2859\n-9596\n-20124\n0\n21628\n0\n-17197\n0\n13080\n-7440\n-8902\n0\n12282\n-10935\n3965\n", 2);
    }

    @Test
    public void testCastDateTimestamp() throws SqlException, IOException {
        this.assertCastDate("a\n1970-01-17T12:11:37.242379Z\n\n1970-01-17T17:41:21.058169Z\n1970-01-17T14:33:54.113022Z\n\n1970-01-17T15:55:39.868373Z\n1970-01-17T17:05:57.889668Z\n1970-01-17T16:04:40.260964Z\n\n1970-01-17T16:53:03.809660Z\n\n1970-01-17T14:41:38.544851Z\n\n1970-01-17T17:59:41.628184Z\n1970-01-17T16:39:21.500400Z\n1970-01-17T12:42:45.287226Z\n\n1970-01-17T14:36:39.533562Z\n1970-01-17T11:28:56.755529Z\n1970-01-17T12:16:06.352765Z\n", 12);
    }

    @Test
    public void testCastDoubleByte() throws SqlException, IOException {
        this.assertCastDouble("a\n80\n8\n8\n65\n79\n22\n34\n76\n42\n0\n72\n42\n70\n38\n0\n32\n0\n97\n24\n63\n", 1);
    }

    @Test
    public void testCastDoubleDate() throws SqlException, IOException {
        this.assertCastDouble("a\n1970-01-01T00:00:00.080Z\n1970-01-01T00:00:00.008Z\n1970-01-01T00:00:00.008Z\n1970-01-01T00:00:00.065Z\n1970-01-01T00:00:00.079Z\n1970-01-01T00:00:00.022Z\n1970-01-01T00:00:00.034Z\n1970-01-01T00:00:00.076Z\n1970-01-01T00:00:00.042Z\n1970-01-01T00:00:00.000Z\n1970-01-01T00:00:00.072Z\n1970-01-01T00:00:00.042Z\n1970-01-01T00:00:00.070Z\n1970-01-01T00:00:00.038Z\n1970-01-01T00:00:00.000Z\n1970-01-01T00:00:00.032Z\n1970-01-01T00:00:00.000Z\n1970-01-01T00:00:00.097Z\n1970-01-01T00:00:00.024Z\n1970-01-01T00:00:00.063Z\n", 10);
    }

    @Test
    public void testCastDoubleFloat() throws SqlException, IOException {
        this.assertCastDouble("a\n80.4322\n8.4870\n8.4383\n65.0859\n79.0568\n22.4523\n34.9107\n76.1103\n42.1777\nNaN\n72.6114\n42.2436\n70.9436\n38.5399\n0.3598\n32.8818\nNaN\n97.7110\n24.8088\n63.8161\n", 5);
    }

    @Test
    public void testCastDoubleInt() throws SqlException, IOException {
        this.assertCastDouble("a\n80\n8\n8\n65\n79\n22\n34\n76\n42\n0\n72\n42\n70\n38\n0\n32\n0\n97\n24\n63\n", 3);
    }

    @Test
    public void testCastDoubleLong() throws SqlException, IOException {
        this.assertCastDouble("a\n80\n8\n8\n65\n79\n22\n34\n76\n42\n0\n72\n42\n70\n38\n0\n32\n0\n97\n24\n63\n", 4);
    }

    @Test
    public void testCastDoubleShort() throws SqlException, IOException {
        this.assertCastDouble("a\n80\n8\n8\n65\n79\n22\n34\n76\n42\n0\n72\n42\n70\n38\n0\n32\n0\n97\n24\n63\n", 2);
    }

    @Test
    public void testCastDoubleTimestamp() throws SqlException, IOException {
        this.assertCastDouble("a\n1970-01-01T00:00:00.000080Z\n1970-01-01T00:00:00.000008Z\n1970-01-01T00:00:00.000008Z\n1970-01-01T00:00:00.000065Z\n1970-01-01T00:00:00.000079Z\n1970-01-01T00:00:00.000022Z\n1970-01-01T00:00:00.000034Z\n1970-01-01T00:00:00.000076Z\n1970-01-01T00:00:00.000042Z\n1970-01-01T00:00:00.000000Z\n1970-01-01T00:00:00.000072Z\n1970-01-01T00:00:00.000042Z\n1970-01-01T00:00:00.000070Z\n1970-01-01T00:00:00.000038Z\n1970-01-01T00:00:00.000000Z\n1970-01-01T00:00:00.000032Z\n1970-01-01T00:00:00.000000Z\n1970-01-01T00:00:00.000097Z\n1970-01-01T00:00:00.000024Z\n1970-01-01T00:00:00.000063Z\n", 12);
    }

    @Test
    public void testCastFloatByte() throws SqlException, IOException {
        this.assertCastFloat("a\n80\n0\n8\n29\n0\n93\n13\n79\n0\n22\n0\n34\n0\n76\n52\n55\n0\n72\n62\n66\n", 1);
    }

    @Test
    public void testCastFloatDate() throws SqlException, IOException {
        this.assertCastFloat("a\n1970-01-01T00:00:00.080Z\n1970-01-01T00:00:00.000Z\n1970-01-01T00:00:00.008Z\n1970-01-01T00:00:00.029Z\n1970-01-01T00:00:00.000Z\n1970-01-01T00:00:00.093Z\n1970-01-01T00:00:00.013Z\n1970-01-01T00:00:00.079Z\n1970-01-01T00:00:00.000Z\n1970-01-01T00:00:00.022Z\n1970-01-01T00:00:00.000Z\n1970-01-01T00:00:00.034Z\n1970-01-01T00:00:00.000Z\n1970-01-01T00:00:00.076Z\n1970-01-01T00:00:00.052Z\n1970-01-01T00:00:00.055Z\n1970-01-01T00:00:00.000Z\n1970-01-01T00:00:00.072Z\n1970-01-01T00:00:00.062Z\n1970-01-01T00:00:00.066Z\n", 10);
    }

    @Test
    public void testCastFloatDouble() throws SqlException, IOException {
        this.assertCastFloat("a\n80.432235717773\nNaN\n8.486962318420\n29.919904708862\nNaN\n93.446044921875\n13.123357772827\n79.056755065918\nNaN\n22.452337265015\nNaN\n34.910701751709\nNaN\n76.110290527344\n52.437229156494\n55.991615295410\nNaN\n72.611358642578\n62.769538879395\n66.938369750977\n", 6);
    }

    @Test
    public void testCastFloatInt() throws SqlException, IOException {
        this.assertCastFloat("a\n80\n0\n8\n29\n0\n93\n13\n79\n0\n22\n0\n34\n0\n76\n52\n55\n0\n72\n62\n66\n", 3);
    }

    @Test
    public void testCastFloatLong() throws SqlException, IOException {
        this.assertCastFloat("a\n80\n0\n8\n29\n0\n93\n13\n79\n0\n22\n0\n34\n0\n76\n52\n55\n0\n72\n62\n66\n", 4);
    }

    @Test
    public void testCastFloatShort() throws SqlException, IOException {
        this.assertCastFloat("a\n80\n0\n8\n29\n0\n93\n13\n79\n0\n22\n0\n34\n0\n76\n52\n55\n0\n72\n62\n66\n", 2);
    }

    @Test
    public void testCastFloatTimestamp() throws SqlException, IOException {
        this.assertCastFloat("a\n1970-01-01T00:00:00.000080Z\n1970-01-01T00:00:00.000000Z\n1970-01-01T00:00:00.000008Z\n1970-01-01T00:00:00.000029Z\n1970-01-01T00:00:00.000000Z\n1970-01-01T00:00:00.000093Z\n1970-01-01T00:00:00.000013Z\n1970-01-01T00:00:00.000079Z\n1970-01-01T00:00:00.000000Z\n1970-01-01T00:00:00.000022Z\n1970-01-01T00:00:00.000000Z\n1970-01-01T00:00:00.000034Z\n1970-01-01T00:00:00.000000Z\n1970-01-01T00:00:00.000076Z\n1970-01-01T00:00:00.000052Z\n1970-01-01T00:00:00.000055Z\n1970-01-01T00:00:00.000000Z\n1970-01-01T00:00:00.000072Z\n1970-01-01T00:00:00.000062Z\n1970-01-01T00:00:00.000066Z\n", 12);
    }

    @Test
    public void testCastIntByte() throws SqlException, IOException {
        this.assertCastInt("a\n1\n0\n22\n22\n0\n7\n26\n26\n0\n13\n0\n0\n0\n25\n21\n23\n0\n6\n19\n7\n", 1);
    }

    @Test
    public void testCastIntDate() throws SqlException, IOException {
        this.assertCastInt("a\n1970-01-01T00:00:00.001Z\n1969-12-07T03:28:36.352Z\n1970-01-01T00:00:00.022Z\n1970-01-01T00:00:00.022Z\n1969-12-07T03:28:36.352Z\n1970-01-01T00:00:00.007Z\n1970-01-01T00:00:00.026Z\n1970-01-01T00:00:00.026Z\n1969-12-07T03:28:36.352Z\n1970-01-01T00:00:00.013Z\n1969-12-07T03:28:36.352Z\n1970-01-01T00:00:00.000Z\n1969-12-07T03:28:36.352Z\n1970-01-01T00:00:00.025Z\n1970-01-01T00:00:00.021Z\n1970-01-01T00:00:00.023Z\n1969-12-07T03:28:36.352Z\n1970-01-01T00:00:00.006Z\n1970-01-01T00:00:00.019Z\n1970-01-01T00:00:00.007Z\n", 10);
    }

    @Test
    public void testCastIntDouble() throws SqlException, IOException {
        this.assertCastInt("a\n1.000000000000\n-2.147483648E9\n22.000000000000\n22.000000000000\n-2.147483648E9\n7.000000000000\n26.000000000000\n26.000000000000\n-2.147483648E9\n13.000000000000\n-2.147483648E9\n0.000000000000\n-2.147483648E9\n25.000000000000\n21.000000000000\n23.000000000000\n-2.147483648E9\n6.000000000000\n19.000000000000\n7.000000000000\n", 6);
    }

    @Test
    public void testCastIntFloat() throws SqlException, IOException {
        this.assertCastInt("a\n1.0000\n-2.14748365E9\n22.0000\n22.0000\n-2.14748365E9\n7.0000\n26.0000\n26.0000\n-2.14748365E9\n13.0000\n-2.14748365E9\n0.0000\n-2.14748365E9\n25.0000\n21.0000\n23.0000\n-2.14748365E9\n6.0000\n19.0000\n7.0000\n", 5);
    }

    @Test
    public void testCastIntLong() throws SqlException, IOException {
        this.assertCastInt("a\n1\n-2147483648\n22\n22\n-2147483648\n7\n26\n26\n-2147483648\n13\n-2147483648\n0\n-2147483648\n25\n21\n23\n-2147483648\n6\n19\n7\n", 4);
    }

    @Test
    public void testCastIntShort() throws SqlException, IOException {
        this.assertCastInt("a\n1\n0\n22\n22\n0\n7\n26\n26\n0\n13\n0\n0\n0\n25\n21\n23\n0\n6\n19\n7\n", 2);
    }

    @Test
    public void testCastIntTimestamp() throws SqlException, IOException {
        String expectedData = "a\n1970-01-01T00:00:00.000001Z\n1969-12-31T23:24:12.516352Z\n1970-01-01T00:00:00.000022Z\n1970-01-01T00:00:00.000022Z\n1969-12-31T23:24:12.516352Z\n1970-01-01T00:00:00.000007Z\n1970-01-01T00:00:00.000026Z\n1970-01-01T00:00:00.000026Z\n1969-12-31T23:24:12.516352Z\n1970-01-01T00:00:00.000013Z\n1969-12-31T23:24:12.516352Z\n1970-01-01T00:00:00.000000Z\n1969-12-31T23:24:12.516352Z\n1970-01-01T00:00:00.000025Z\n1970-01-01T00:00:00.000021Z\n1970-01-01T00:00:00.000023Z\n1969-12-31T23:24:12.516352Z\n1970-01-01T00:00:00.000006Z\n1970-01-01T00:00:00.000019Z\n1970-01-01T00:00:00.000007Z\n";
        this.assertCastInt(expectedData, 12);
    }

    @Test
    public void testCastLongByte() throws SqlException, IOException {
        this.assertCastLong("a\n22\n0\n17\n2\n0\n21\n1\n20\n0\n14\n0\n26\n0\n23\n2\n24\n0\n16\n10\n6\n", 1);
    }

    @Test
    public void testCastLongDate() throws SqlException, IOException {
        this.assertCastLong("a\n1970-01-01T00:00:00.022Z\n\n1970-01-01T00:00:00.017Z\n1970-01-01T00:00:00.002Z\n\n1970-01-01T00:00:00.021Z\n1970-01-01T00:00:00.001Z\n1970-01-01T00:00:00.020Z\n\n1970-01-01T00:00:00.014Z\n\n1970-01-01T00:00:00.026Z\n\n1970-01-01T00:00:00.023Z\n1970-01-01T00:00:00.002Z\n1970-01-01T00:00:00.024Z\n\n1970-01-01T00:00:00.016Z\n1970-01-01T00:00:00.010Z\n1970-01-01T00:00:00.006Z\n", 10);
    }

    @Test
    public void testCastLongDouble() throws SqlException, IOException {
        this.assertCastLong("a\n22.000000000000\n-9.223372036854776E18\n17.000000000000\n2.000000000000\n-9.223372036854776E18\n21.000000000000\n1.000000000000\n20.000000000000\n-9.223372036854776E18\n14.000000000000\n-9.223372036854776E18\n26.000000000000\n-9.223372036854776E18\n23.000000000000\n2.000000000000\n24.000000000000\n-9.223372036854776E18\n16.000000000000\n10.000000000000\n6.000000000000\n", 6);
    }

    @Test
    public void testCastLongFloat() throws SqlException, IOException {
        this.assertCastLong("a\n22.0000\n-9.223372E18\n17.0000\n2.0000\n-9.223372E18\n21.0000\n1.0000\n20.0000\n-9.223372E18\n14.0000\n-9.223372E18\n26.0000\n-9.223372E18\n23.0000\n2.0000\n24.0000\n-9.223372E18\n16.0000\n10.0000\n6.0000\n", 5);
    }

    @Test
    public void testCastLongInt() throws SqlException, IOException {
        this.assertCastLong("a\n22\n0\n17\n2\n0\n21\n1\n20\n0\n14\n0\n26\n0\n23\n2\n24\n0\n16\n10\n6\n", 3);
    }

    @Test
    public void testCastLongShort() throws SqlException, IOException {
        this.assertCastLong("a\n22\n0\n17\n2\n0\n21\n1\n20\n0\n14\n0\n26\n0\n23\n2\n24\n0\n16\n10\n6\n", 2);
    }

    @Test
    public void testCastLongTimestamp() throws SqlException, IOException {
        this.assertCastLong("a\n1970-01-01T00:00:00.000022Z\n\n1970-01-01T00:00:00.000017Z\n1970-01-01T00:00:00.000002Z\n\n1970-01-01T00:00:00.000021Z\n1970-01-01T00:00:00.000001Z\n1970-01-01T00:00:00.000020Z\n\n1970-01-01T00:00:00.000014Z\n\n1970-01-01T00:00:00.000026Z\n\n1970-01-01T00:00:00.000023Z\n1970-01-01T00:00:00.000002Z\n1970-01-01T00:00:00.000024Z\n\n1970-01-01T00:00:00.000016Z\n1970-01-01T00:00:00.000010Z\n1970-01-01T00:00:00.000006Z\n", 12);
    }

    @Test
    public void testCastNumberFail() {
        this.assertCastIntFail(0);
        this.assertCastLongFail(0);
        this.assertCastByteFail(0);
        this.assertCastShortFail(0);
        this.assertCastFloatFail(0);
        this.assertCastDoubleFail(0);
        this.assertCastIntFail(7);
        this.assertCastLongFail(7);
        this.assertCastByteFail(7);
        this.assertCastShortFail(7);
        this.assertCastFloatFail(7);
        this.assertCastDoubleFail(7);
        this.assertCastIntFail(8);
        this.assertCastLongFail(8);
        this.assertCastByteFail(8);
        this.assertCastShortFail(8);
        this.assertCastFloatFail(8);
        this.assertCastDoubleFail(8);
        this.assertCastIntFail(9);
        this.assertCastLongFail(9);
        this.assertCastByteFail(9);
        this.assertCastShortFail(9);
        this.assertCastFloatFail(9);
        this.assertCastDoubleFail(9);
        this.assertCastStringFail(1);
        this.assertCastStringFail(2);
        this.assertCastStringFail(3);
        this.assertCastStringFail(4);
        this.assertCastStringFail(5);
        this.assertCastStringFail(6);
        this.assertCastStringFail(10);
        this.assertCastStringFail(12);
        this.assertCastSymbolFail(1);
        this.assertCastSymbolFail(2);
        this.assertCastSymbolFail(3);
        this.assertCastSymbolFail(4);
        this.assertCastSymbolFail(5);
        this.assertCastSymbolFail(6);
        this.assertCastSymbolFail(10);
        this.assertCastSymbolFail(12);
    }

    @Test
    public void testCastShortByte() throws SqlException, IOException {
        this.assertCastShort("a\n-106\n-42\n-76\n-41\n-41\n-107\n117\n3\n-35\n21\n38\n-25\n46\n-8\n-120\n101\n30\n-122\n52\n91\n", 1);
    }

    @Test
    public void testCastShortDate() throws SqlException, IOException {
        this.assertCastShort("a\n1970-01-01T00:00:01.430Z\n1970-01-01T00:00:01.238Z\n1970-01-01T00:00:01.204Z\n1970-01-01T00:00:01.751Z\n1970-01-01T00:00:01.751Z\n1970-01-01T00:00:01.429Z\n1970-01-01T00:00:01.397Z\n1970-01-01T00:00:01.539Z\n1970-01-01T00:00:01.501Z\n1970-01-01T00:00:01.045Z\n1970-01-01T00:00:01.318Z\n1970-01-01T00:00:01.255Z\n1970-01-01T00:00:01.838Z\n1970-01-01T00:00:01.784Z\n1970-01-01T00:00:01.928Z\n1970-01-01T00:00:01.381Z\n1970-01-01T00:00:01.822Z\n1970-01-01T00:00:01.414Z\n1970-01-01T00:00:01.588Z\n1970-01-01T00:00:01.371Z\n", 10);
    }

    @Test
    public void testCastShortDouble() throws SqlException, IOException {
        this.assertCastShort("a\n1430.000000000000\n1238.000000000000\n1204.000000000000\n1751.000000000000\n1751.000000000000\n1429.000000000000\n1397.000000000000\n1539.000000000000\n1501.000000000000\n1045.000000000000\n1318.000000000000\n1255.000000000000\n1838.000000000000\n1784.000000000000\n1928.000000000000\n1381.000000000000\n1822.000000000000\n1414.000000000000\n1588.000000000000\n1371.000000000000\n", 6);
    }

    @Test
    public void testCastShortFloat() throws SqlException, IOException {
        this.assertCastShort("a\n1430.0000\n1238.0000\n1204.0000\n1751.0000\n1751.0000\n1429.0000\n1397.0000\n1539.0000\n1501.0000\n1045.0000\n1318.0000\n1255.0000\n1838.0000\n1784.0000\n1928.0000\n1381.0000\n1822.0000\n1414.0000\n1588.0000\n1371.0000\n", 5);
    }

    @Test
    public void testCastShortInt() throws SqlException, IOException {
        this.assertCastShort("a\n1430\n1238\n1204\n1751\n1751\n1429\n1397\n1539\n1501\n1045\n1318\n1255\n1838\n1784\n1928\n1381\n1822\n1414\n1588\n1371\n", 3);
    }

    @Test
    public void testCastShortLong() throws SqlException, IOException {
        this.assertCastShort("a\n1430\n1238\n1204\n1751\n1751\n1429\n1397\n1539\n1501\n1045\n1318\n1255\n1838\n1784\n1928\n1381\n1822\n1414\n1588\n1371\n", 4);
    }

    @Test
    public void testCastShortTimestamp() throws SqlException, IOException {
        this.assertCastShort("a\n1970-01-01T00:00:00.001430Z\n1970-01-01T00:00:00.001238Z\n1970-01-01T00:00:00.001204Z\n1970-01-01T00:00:00.001751Z\n1970-01-01T00:00:00.001751Z\n1970-01-01T00:00:00.001429Z\n1970-01-01T00:00:00.001397Z\n1970-01-01T00:00:00.001539Z\n1970-01-01T00:00:00.001501Z\n1970-01-01T00:00:00.001045Z\n1970-01-01T00:00:00.001318Z\n1970-01-01T00:00:00.001255Z\n1970-01-01T00:00:00.001838Z\n1970-01-01T00:00:00.001784Z\n1970-01-01T00:00:00.001928Z\n1970-01-01T00:00:00.001381Z\n1970-01-01T00:00:00.001822Z\n1970-01-01T00:00:00.001414Z\n1970-01-01T00:00:00.001588Z\n1970-01-01T00:00:00.001371Z\n", 12);
    }

    @Test
    public void testCastTimestampByte() throws SqlException, IOException {
        this.assertCastTimestamp("a\n89\n0\n-19\n-99\n0\n-102\n86\n83\n0\n30\n0\n-128\n0\n-115\n-106\n-76\n0\n25\n30\n-69\n", 1);
    }

    @Test
    public void testCastTimestampDate() throws SqlException, IOException {
        this.assertCastTimestamp("a\n47956-10-13T01:43:12.217Z\n\n47830-07-03T01:52:05.101Z\n47946-01-25T16:00:41.629Z\n\n47133-10-04T06:29:09.402Z\n47578-08-06T19:13:17.654Z\n47813-04-30T15:45:24.307Z\n\n47370-09-18T01:29:39.870Z\n\n47817-03-02T05:38:00.192Z\n\n47502-10-03T01:46:21.965Z\n47627-07-07T11:02:25.686Z\n47630-01-25T00:47:44.820Z\n\n47620-04-14T19:43:29.561Z\n47725-11-11T00:22:36.062Z\n47867-11-08T16:30:43.643Z\n", 10);
    }

    @Test
    public void testCastTimestampDouble() throws SqlException, IOException {
        this.assertCastTimestamp("a\n1.451202658992217E15\n-9.223372036854776E18\n1.447217632325101E15\n1.450864540841629E15\n-9.223372036854776E18\n1.425230490549402E15\n1.439268289997654E15\n1.446675695124307E15\n-9.223372036854776E18\n1.43270813337987E15\n-9.223372036854776E18\n1.446796791480192E15\n-9.223372036854776E18\n1.436874860781965E15\n1.440811969345686E15\n1.44089254366482E15\n-9.223372036854776E18\n1.440583904609561E15\n1.443915505356062E15\n1.448396353843643E15\n", 6);
    }

    @Test
    public void testCastTimestampFloat() throws SqlException, IOException {
        this.assertCastTimestamp("a\n1.45120261E15\n-9.223372E18\n1.44721768E15\n1.45086451E15\n-9.223372E18\n1.42523054E15\n1.43926824E15\n1.44667571E15\n-9.223372E18\n1.43270808E15\n-9.223372E18\n1.44679678E15\n-9.223372E18\n1.43687487E15\n1.44081201E15\n1.44089254E15\n-9.223372E18\n1.44058384E15\n1.44391553E15\n1.44839638E15\n", 5);
    }

    @Test
    public void testCastTimestampInt() throws SqlException, IOException {
        this.assertCastTimestamp("a\n1929150553\n0\n-1662833171\n-1181550947\n0\n1427946650\n-1020695722\n1860812627\n0\n1532714782\n0\n-1596883072\n0\n2141839757\n765393046\n-264666444\n0\n333923609\n-959951586\n237646267\n", 3);
    }

    @Test
    public void testCastTimestampLong() throws SqlException, IOException {
        this.assertCastTimestamp("a\n1451202658992217\nNaN\n1447217632325101\n1450864540841629\nNaN\n1425230490549402\n1439268289997654\n1446675695124307\nNaN\n1432708133379870\nNaN\n1446796791480192\nNaN\n1436874860781965\n1440811969345686\n1440892543664820\nNaN\n1440583904609561\n1443915505356062\n1448396353843643\n", 4);
    }

    @Test
    public void testCastTimestampShort() throws SqlException, IOException {
        this.assertCastTimestamp("a\n-32679\n0\n11757\n-2403\n0\n-17254\n27478\n-16557\n0\n24350\n0\n32640\n0\n-7795\n-1898\n-32076\n0\n17689\n19742\n12731\n", 2);
    }

    @Test
    public void testCreateAsSelect() throws SqlException, IOException {
        String expectedData = "a1\ta\tb\tc\td\te\tf\tf1\tg\th\ti\tj\tj1\tk\tl\tm\n1569490116\tNaN\tfalse\t\tNaN\t0.7611\t428\t-1593\t2015-04-04T16:34:47.226Z\t\t\t185\t7039584373105579285\t1970-01-01T00:00:00.000000Z\t4\t00000000 af 19 c4 95 94 36 53 49 b4 59 7e\n1253890363\t10\tfalse\tXYS\t0.191123461757\t0.5793\t881\t-1379\t\t2015-03-04T23:08:35.722465Z\tHYRX\t188\t-4986232506486815364\t1970-01-01T00:16:40.000000Z\t50\t00000000 42 fc 31 79 5f 8b 81 2b 93 4d 1a 8e 78 b5\n-1819240775\t27\ttrue\tGOO\t0.041428124702\t0.9205\t97\t-9039\t2015-08-25T03:15:07.653Z\t2015-12-06T09:41:30.297134Z\tHYRX\t109\t571924429013198086\t1970-01-01T00:33:20.000000Z\t21\t\n-1201923128\t18\ttrue\tUVS\t0.758817540345\t0.5779\t480\t-4379\t2015-12-16T09:15:02.086Z\t2015-05-31T18:12:45.686366Z\tCPSW\tNaN\t-6161552193869048721\t1970-01-01T00:50:00.000000Z\t27\t00000000 28 c7 84 47 dc d2 85 7f a5 b8 7b 4a 9d 46\n865832060\tNaN\ttrue\t\t0.148305523358\t0.9442\t95\t2508\t\t2015-10-20T09:33:20.502524Z\t\tNaN\t-3289070757475856942\t1970-01-01T01:06:40.000000Z\t40\t00000000 f2 3c ed 39 ac a8 3b a6 dc 3b 7d 2b e3 92 fe 69\n00000010 38 e1\n1100812407\t22\tfalse\tOVL\tNaN\t0.7633\t698\t-17778\t2015-09-13T09:55:17.815Z\t\tCPSW\t182\t-8757007522346766135\t1970-01-01T01:23:20.000000Z\t23\t\n1677463366\t18\tfalse\tMNZ\t0.337470756550\t0.1179\t533\t18904\t2015-05-13T23:13:05.262Z\t2015-05-10T00:20:17.926993Z\t\t175\t6351664568801157821\t1970-01-01T01:40:00.000000Z\t29\t00000000 5d d0 eb 67 44 a7 6a 71 34 e0 b0 e9 98 f7 67 62\n00000010 28 60\n39497392\t4\tfalse\tUOH\t0.029227696943\t0.1718\t652\t14242\t\t2015-05-24T22:09:55.175991Z\tVTJW\t141\t3527911398466283309\t1970-01-01T01:56:40.000000Z\t9\t00000000 d9 6f 04 ab 27 47 8f 23 3f ae 7c 9f 77 04 e9 0c\n00000010 ea 4e ea 8b\n1545963509\t10\tfalse\tNWI\t0.113718418361\t0.0620\t356\t-29980\t2015-09-12T14:33:11.105Z\t2015-08-06T04:51:01.526782Z\t\t168\t6380499796471875623\t1970-01-01T02:13:20.000000Z\t13\t00000000 54 52 d0 29 26 c5 aa da 18 ce 5f b2 8b 5c 54 90\n53462821\t4\tfalse\tGOO\t0.055149337562\t0.1195\t115\t-6087\t2015-08-09T19:28:14.249Z\t2015-09-20T01:50:37.694867Z\tCPSW\t145\t-7212878484370155026\t1970-01-01T02:30:00.000000Z\t46\t\n-2139296159\t30\tfalse\t\t0.185864355816\t0.5638\t299\t21020\t2015-12-30T22:10:50.759Z\t2015-01-19T15:54:44.696040Z\tHYRX\t105\t-3463832009795858033\t1970-01-01T02:46:40.000000Z\t38\t00000000 b8 07 b1 32 57 ff 9a ef 88 cb 4b\n-406528351\t21\tfalse\tNLE\tNaN\tNaN\t968\t21057\t2015-10-17T07:20:26.881Z\t2015-06-02T13:00:45.180827Z\tPEHN\t102\t5360746485515325739\t1970-01-01T03:03:20.000000Z\t43\t\n415709351\t17\tfalse\tGQZ\t0.491990017163\t0.6292\t581\t18605\t2015-03-04T06:48:42.194Z\t2015-08-14T15:51:23.307152Z\tHYRX\t185\t-5611837907908424613\t1970-01-01T03:20:00.000000Z\t19\t00000000 20 e2 37 f2 64 43 84 55 a0 dd 44 11 e2 a3 24 4e\n00000010 44 a8 0d fe\n-1387693529\t19\ttrue\tMCG\t0.848083900630\t0.4699\t119\t24206\t2015-03-01T23:54:10.204Z\t2015-10-01T12:02:08.698373Z\t\t175\t3669882909701240516\t1970-01-01T03:36:40.000000Z\t12\t00000000 8f bb 2a 4b af 8f 89 df 35 8f da fe 33 98 80 85\n00000010 20 53 3b 51\n346891421\t21\tfalse\t\t0.933609514583\t0.6380\t405\t15084\t2015-10-12T05:36:54.066Z\t2015-11-16T05:48:57.958190Z\tPEHN\t196\t-9200716729349404576\t1970-01-01T03:53:20.000000Z\t43\t\n263487884\t27\ttrue\tHZQ\t0.703978540803\t0.8461\t834\t31562\t2015-08-04T00:55:25.323Z\t2015-07-25T18:26:42.499255Z\tHYRX\t128\t8196544381931602027\t1970-01-01T04:10:00.000000Z\t15\t00000000 71 76 bc 45 24 cd 13 00 7c fb 01 19 ca f2\n-1034870849\t9\tfalse\tLSV\t0.650660460171\t0.7020\t110\t-838\t2015-08-17T23:50:39.534Z\t2015-03-17T03:23:26.126568Z\tHYRX\tNaN\t-6929866925584807039\t1970-01-01T04:26:40.000000Z\t4\t00000000 4b fb 2d 16 f3 89 a3 83 64 de\n1848218326\t26\ttrue\tSUW\t0.803404910559\t0.0440\t854\t-3502\t2015-04-04T20:55:02.116Z\t2015-11-23T07:46:10.570856Z\t\t145\t4290477379978201771\t1970-01-01T04:43:20.000000Z\t35\t00000000 6d 54 75 10 b3 4c 0e 8f f1 0c c5 60 b7 d1 5a\n-1496904948\t5\ttrue\tDBZ\t0.286271736488\tNaN\t764\t5698\t2015-02-06T02:49:54.147Z\t\t\tNaN\t-3058745577013275321\t1970-01-01T05:00:00.000000Z\t19\t00000000 d4 ab be 30 fa 8d ac 3d 98 a0 ad 9a 5d\n856634079\t20\ttrue\tRJU\t0.108206023861\t0.4565\t669\t13505\t2015-11-14T15:19:19.390Z\t\tVTJW\t134\t-3700177025310488849\t1970-01-01T05:16:40.000000Z\t3\t00000000 f8 a1 46 87 28 92 a3 9b e3 cb c2 64 8a b0 35 d8\n00000010 ab 3f a1 f5\n";
        String expectedMeta = "{\"columnCount\":16,\"columns\":[{\"index\":0,\"name\":\"a1\",\"type\":\"INT\"},{\"index\":1,\"name\":\"a\",\"type\":\"INT\"},{\"index\":2,\"name\":\"b\",\"type\":\"BOOLEAN\"},{\"index\":3,\"name\":\"c\",\"type\":\"STRING\"},{\"index\":4,\"name\":\"d\",\"type\":\"DOUBLE\"},{\"index\":5,\"name\":\"e\",\"type\":\"FLOAT\"},{\"index\":6,\"name\":\"f\",\"type\":\"SHORT\"},{\"index\":7,\"name\":\"f1\",\"type\":\"SHORT\"},{\"index\":8,\"name\":\"g\",\"type\":\"DATE\"},{\"index\":9,\"name\":\"h\",\"type\":\"TIMESTAMP\"},{\"index\":10,\"name\":\"i\",\"type\":\"SYMBOL\"},{\"index\":11,\"name\":\"j\",\"type\":\"LONG\"},{\"index\":12,\"name\":\"j1\",\"type\":\"LONG\"},{\"index\":13,\"name\":\"k\",\"type\":\"TIMESTAMP\"},{\"index\":14,\"name\":\"l\",\"type\":\"BYTE\"},{\"index\":15,\"name\":\"m\",\"type\":\"BINARY\"}],\"timestampIndex\":13}";
        this.assertCast(expectedData, expectedMeta, "create table y as (select * from random_cursor( 20, 'a1', rnd_int(), 'a', rnd_int(0, 30, 2), 'b', rnd_boolean(), 'c', rnd_str(3,3,2), 'd', rnd_double(2), 'e', rnd_float(2), 'f', rnd_short(10,1024), 'f1', rnd_short(), 'g', rnd_date(to_date('2015', 'yyyy'), to_date('2016', 'yyyy'), 2), 'h', rnd_timestamp(to_timestamp('2015', 'yyyy'), to_timestamp('2016', 'yyyy'), 2), 'i', rnd_symbol(4,4,4,2), 'j', rnd_long(100,200,2), 'j1', rnd_long(), 'k', timestamp_sequence(to_timestamp(0), 1000000000), 'l', rnd_byte(2,50), 'm', rnd_bin(10, 20, 2)))  timestamp(k) partition by DAY");
    }

    @Test
    public void testCreateAsSelectCastSymbol() throws SqlException, IOException {
        String expectedData = "a\nCPSW\nHYRX\n\nVTJW\nPEHN\n\nVTJW\n\nCPSW\n\nPEHN\nCPSW\nVTJW\n\n\nCPSW\n\n\n\nPEHN\n";
        String expectedMeta = "{\"columnCount\":1,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"STRING\"}],\"timestampIndex\":-1}";
        String sql = "create table y as (select * from random_cursor( 20, 'a', rnd_symbol(4,4,4,2))), cast(a as STRING)";
        this.assertCast("a\nCPSW\nHYRX\n\nVTJW\nPEHN\n\nVTJW\n\nCPSW\n\nPEHN\nCPSW\nVTJW\n\n\nCPSW\n\n\n\nPEHN\n", expectedMeta, sql);
    }

    @Test
    public void testCreateAsSelectConstantColumnRename() {
        try {
            this.assertCreateTableAsSelect(null, "create table Y as (select * from X) timestamp(t)", new Fiddler(){
                int state = 0;

                @Override
                public boolean isHappy() {
                    return this.state > 1;
                }

                @Override
                public void run(CairoEngine engine) {
                    if (this.state++ > 0) {
                        try (TableWriter writer = engine.getWriter((CharSequence)"X");){
                            if (this.state == 2) {
                                writer.removeColumn((CharSequence)"b");
                            } else {
                                writer.removeColumn((CharSequence)("b" + (this.state - 1)));
                            }
                            writer.addColumn((CharSequence)("b" + this.state), 3);
                        }
                    }
                }
            });
            Assert.fail();
        }
        catch (SqlException e) {
            TestUtils.assertContains(e.getMessage(), "underlying cursor is extremely volatile");
        }
    }

    @Test
    public void testCreateAsSelectIOError() throws Exception {
        TestUtils.assertMemoryLeak(new TestUtils.LeakProneCode(){

            @Override
            public void run() {
                String sql = "create table y as (select * from random_cursor( 10000, 'a', rnd_symbol(4,4,4,2))), cast(a as STRING)";
                FilesFacadeImpl ff = new FilesFacadeImpl(){
                    int mapCount = 0;

                    public long getMapPageSize() {
                        return this.getPageSize();
                    }

                    public long mmap(long fd, long len, long offset, int mode) {
                        if (this.mapCount++ > 5) {
                            return -1L;
                        }
                        return super.mmap(fd, len, offset, mode);
                    }
                };
                DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root, (FilesFacade)ff){
                    final /* synthetic */ FilesFacade val$ff;
                    {
                        this.val$ff = filesFacade;
                        super(x0);
                    }

                    public FilesFacade getFilesFacade() {
                        return this.val$ff;
                    }
                };
                try (Engine engine = new Engine((CairoConfiguration)configuration);
                     SqlCompiler compiler = new SqlCompiler((CairoEngine)engine, (CairoConfiguration)configuration);){
                    try {
                        compiler.compile((CharSequence)sql, bindVariableService);
                        Assert.fail();
                    }
                    catch (SqlException e) {
                        TestUtils.assertContains(e.getMessage(), "Could not create table. See log for details");
                    }
                    engine.releaseAllReaders();
                    engine.releaseAllWriters();
                    Assert.assertEquals((long)0L, (long)engine.getBusyReaderCount());
                    Assert.assertEquals((long)0L, (long)engine.getBusyWriterCount());
                }
            }
        });
    }

    @Test
    public void testCreateAsSelectIOError2() throws Exception {
        TestUtils.assertMemoryLeak(new TestUtils.LeakProneCode(){

            @Override
            public void run() {
                String sql = "create table y as (select * from random_cursor( 10000, 'a', rnd_symbol(4,4,4,2))), cast(a as STRING)";
                FilesFacadeImpl ff = new FilesFacadeImpl(){
                    int mapCount = 0;

                    public long getMapPageSize() {
                        return this.getPageSize();
                    }

                    public long mmap(long fd, long len, long offset, int mode) {
                        if (this.mapCount++ > 2) {
                            return -1L;
                        }
                        return super.mmap(fd, len, offset, mode);
                    }
                };
                DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root, (FilesFacade)ff){
                    final /* synthetic */ FilesFacade val$ff;
                    {
                        this.val$ff = filesFacade;
                        super(x0);
                    }

                    public FilesFacade getFilesFacade() {
                        return this.val$ff;
                    }
                };
                try (Engine engine = new Engine((CairoConfiguration)configuration);
                     SqlCompiler compiler = new SqlCompiler((CairoEngine)engine, (CairoConfiguration)configuration);){
                    try {
                        compiler.compile((CharSequence)sql, bindVariableService);
                        Assert.fail();
                    }
                    catch (SqlException e) {
                        TestUtils.assertContains(e.getMessage(), "Could not create table. See log for details");
                    }
                    engine.releaseAllReaders();
                    engine.releaseAllWriters();
                    Assert.assertEquals((long)0L, (long)engine.getBusyReaderCount());
                    Assert.assertEquals((long)0L, (long)engine.getBusyWriterCount());
                }
            }
        });
    }

    @Test
    public void testCreateAsSelectInvalidTimestamp() throws Exception {
        this.assertFailure(88, "TIMESTAMP column expected", "create table y as (select * from random_cursor( 20, 'a', rnd_int(0, 30, 2)))  timestamp(a) partition by DAY");
    }

    @Test
    public void testCreateAsSelectRemoveColumn() throws SqlException {
        this.assertCreateTableAsSelect("{\"columnCount\":2,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"INT\"},{\"index\":1,\"name\":\"t\",\"type\":\"TIMESTAMP\"}],\"timestampIndex\":1}", "create table Y as (select * from X) timestamp(t)", new Fiddler(){
            int state = 0;

            @Override
            public boolean isHappy() {
                return this.state > 1;
            }

            @Override
            public void run(CairoEngine engine) {
                if (this.state++ == 1) {
                    try (TableWriter writer = engine.getWriter((CharSequence)"X");){
                        writer.removeColumn((CharSequence)"b");
                    }
                }
            }
        });
    }

    @Test
    public void testCreateAsSelectRemoveColumnFromCast() {
        try {
            this.assertCreateTableAsSelect("{\"columnCount\":2,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"INT\"},{\"index\":1,\"name\":\"t\",\"type\":\"TIMESTAMP\"}],\"timestampIndex\":1}", "create table Y as (select * from X), cast (b as DOUBLE) timestamp(t)", new Fiddler(){
                int state = 0;

                @Override
                public boolean isHappy() {
                    return this.state > 1;
                }

                @Override
                public void run(CairoEngine engine) {
                    if (this.state++ == 1) {
                        try (TableWriter writer = engine.getWriter((CharSequence)"X");){
                            writer.removeColumn((CharSequence)"b");
                        }
                    }
                }
            });
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)43L, (long)e.getPosition());
            TestUtils.assertContains(e.getMessage(), "Invalid column: b");
        }
    }

    @Test
    public void testCreateAsSelectReplaceColumn() throws SqlException {
        this.assertCreateTableAsSelect("{\"columnCount\":3,\"columns\":[{\"index\":0,\"name\":\"b\",\"type\":\"INT\"},{\"index\":1,\"name\":\"t\",\"type\":\"TIMESTAMP\"},{\"index\":2,\"name\":\"c\",\"type\":\"FLOAT\"}],\"timestampIndex\":1}", "create table Y as (select * from X) timestamp(t)", new Fiddler(){
            int state = 0;

            @Override
            public boolean isHappy() {
                return this.state > 1;
            }

            @Override
            public void run(CairoEngine engine) {
                if (this.state++ == 1) {
                    try (TableWriter writer = engine.getWriter((CharSequence)"X");){
                        writer.removeColumn((CharSequence)"a");
                        writer.addColumn((CharSequence)"c", 5);
                    }
                }
            }
        });
    }

    @Test
    public void testCreateAsSelectReplaceTimestamp() {
        try {
            this.assertCreateTableAsSelect("{\"columnCount\":3,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"INT\"},{\"index\":1,\"name\":\"b\",\"type\":\"INT\"},{\"index\":2,\"name\":\"t\",\"type\":\"FLOAT\"}],\"timestampIndex\":-1}", "create table Y as (select * from X) timestamp(t)", new Fiddler(){
                int state = 0;

                @Override
                public boolean isHappy() {
                    return this.state > 1;
                }

                @Override
                public void run(CairoEngine engine) {
                    if (this.state++ == 1) {
                        try (TableWriter writer = engine.getWriter((CharSequence)"X");){
                            writer.removeColumn((CharSequence)"t");
                            writer.addColumn((CharSequence)"t", 5);
                        }
                    }
                }
            });
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)46L, (long)e.getPosition());
            TestUtils.assertContains(e.getMessage(), "TIMESTAMP column expected");
        }
    }

    @Test
    public void testCreateEmptyTableNoPartition() throws SqlException {
        compiler.compile((CharSequence)"create table x (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL capacity 16 cache, z STRING, y BOOLEAN) timestamp(t)", bindVariableService);
        try (TableReader reader = engine.getReader((CharSequence)"x", -1L);){
            sink.clear();
            reader.getMetadata().toJson((CharSink)sink);
            TestUtils.assertEquals((CharSequence)"{\"columnCount\":12,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"INT\"},{\"index\":1,\"name\":\"b\",\"type\":\"BYTE\"},{\"index\":2,\"name\":\"c\",\"type\":\"SHORT\"},{\"index\":3,\"name\":\"d\",\"type\":\"LONG\"},{\"index\":4,\"name\":\"e\",\"type\":\"FLOAT\"},{\"index\":5,\"name\":\"f\",\"type\":\"DOUBLE\"},{\"index\":6,\"name\":\"g\",\"type\":\"DATE\"},{\"index\":7,\"name\":\"h\",\"type\":\"BINARY\"},{\"index\":8,\"name\":\"t\",\"type\":\"TIMESTAMP\"},{\"index\":9,\"name\":\"x\",\"type\":\"SYMBOL\"},{\"index\":10,\"name\":\"z\",\"type\":\"STRING\"},{\"index\":11,\"name\":\"y\",\"type\":\"BOOLEAN\"}],\"timestampIndex\":8}", (CharSequence)sink);
            Assert.assertEquals((long)3L, (long)reader.getPartitionedBy());
            Assert.assertEquals((long)0L, (long)reader.size());
            SymbolMapReader symbolMapReader = reader.getSymbolMapReader(reader.getMetadata().getColumnIndexQuiet((CharSequence)"x"));
            Assert.assertNotNull((Object)symbolMapReader);
            Assert.assertEquals((long)16L, (long)symbolMapReader.getSymbolCapacity());
            Assert.assertTrue((boolean)symbolMapReader.isCached());
        }
    }

    @Test
    public void testCreateEmptyTableNoTimestamp() throws SqlException {
        compiler.compile((CharSequence)"create table x (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL capacity 16 cache, z STRING, y BOOLEAN) partition by MONTH", bindVariableService);
        try (TableReader reader = engine.getReader((CharSequence)"x", -1L);){
            sink.clear();
            reader.getMetadata().toJson((CharSink)sink);
            TestUtils.assertEquals((CharSequence)"{\"columnCount\":12,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"INT\"},{\"index\":1,\"name\":\"b\",\"type\":\"BYTE\"},{\"index\":2,\"name\":\"c\",\"type\":\"SHORT\"},{\"index\":3,\"name\":\"d\",\"type\":\"LONG\"},{\"index\":4,\"name\":\"e\",\"type\":\"FLOAT\"},{\"index\":5,\"name\":\"f\",\"type\":\"DOUBLE\"},{\"index\":6,\"name\":\"g\",\"type\":\"DATE\"},{\"index\":7,\"name\":\"h\",\"type\":\"BINARY\"},{\"index\":8,\"name\":\"t\",\"type\":\"TIMESTAMP\"},{\"index\":9,\"name\":\"x\",\"type\":\"SYMBOL\"},{\"index\":10,\"name\":\"z\",\"type\":\"STRING\"},{\"index\":11,\"name\":\"y\",\"type\":\"BOOLEAN\"}],\"timestampIndex\":-1}", (CharSequence)sink);
            Assert.assertEquals((long)1L, (long)reader.getPartitionedBy());
            Assert.assertEquals((long)0L, (long)reader.size());
            SymbolMapReader symbolMapReader = reader.getSymbolMapReader(reader.getMetadata().getColumnIndexQuiet((CharSequence)"x"));
            Assert.assertNotNull((Object)symbolMapReader);
            Assert.assertEquals((long)16L, (long)symbolMapReader.getSymbolCapacity());
            Assert.assertTrue((boolean)symbolMapReader.isCached());
        }
    }

    @Test
    public void testCreateEmptyTableSymbolCache() throws SqlException {
        compiler.compile((CharSequence)"create table x (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL capacity 16 cache, z STRING, y BOOLEAN) timestamp(t) partition by MONTH", bindVariableService);
        try (TableReader reader = engine.getReader((CharSequence)"x", -1L);){
            sink.clear();
            reader.getMetadata().toJson((CharSink)sink);
            TestUtils.assertEquals((CharSequence)"{\"columnCount\":12,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"INT\"},{\"index\":1,\"name\":\"b\",\"type\":\"BYTE\"},{\"index\":2,\"name\":\"c\",\"type\":\"SHORT\"},{\"index\":3,\"name\":\"d\",\"type\":\"LONG\"},{\"index\":4,\"name\":\"e\",\"type\":\"FLOAT\"},{\"index\":5,\"name\":\"f\",\"type\":\"DOUBLE\"},{\"index\":6,\"name\":\"g\",\"type\":\"DATE\"},{\"index\":7,\"name\":\"h\",\"type\":\"BINARY\"},{\"index\":8,\"name\":\"t\",\"type\":\"TIMESTAMP\"},{\"index\":9,\"name\":\"x\",\"type\":\"SYMBOL\"},{\"index\":10,\"name\":\"z\",\"type\":\"STRING\"},{\"index\":11,\"name\":\"y\",\"type\":\"BOOLEAN\"}],\"timestampIndex\":8}", (CharSequence)sink);
            Assert.assertEquals((long)1L, (long)reader.getPartitionedBy());
            Assert.assertEquals((long)0L, (long)reader.size());
            SymbolMapReader symbolMapReader = reader.getSymbolMapReader(reader.getMetadata().getColumnIndexQuiet((CharSequence)"x"));
            Assert.assertNotNull((Object)symbolMapReader);
            Assert.assertEquals((long)16L, (long)symbolMapReader.getSymbolCapacity());
            Assert.assertTrue((boolean)symbolMapReader.isCached());
        }
    }

    @Test
    public void testCreateEmptyTableSymbolNoCache() throws SqlException {
        compiler.compile((CharSequence)"create table x (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL capacity 16 nocache, z STRING, y BOOLEAN) timestamp(t) partition by MONTH", bindVariableService);
        try (TableReader reader = engine.getReader((CharSequence)"x", -1L);){
            sink.clear();
            reader.getMetadata().toJson((CharSink)sink);
            TestUtils.assertEquals((CharSequence)"{\"columnCount\":12,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"INT\"},{\"index\":1,\"name\":\"b\",\"type\":\"BYTE\"},{\"index\":2,\"name\":\"c\",\"type\":\"SHORT\"},{\"index\":3,\"name\":\"d\",\"type\":\"LONG\"},{\"index\":4,\"name\":\"e\",\"type\":\"FLOAT\"},{\"index\":5,\"name\":\"f\",\"type\":\"DOUBLE\"},{\"index\":6,\"name\":\"g\",\"type\":\"DATE\"},{\"index\":7,\"name\":\"h\",\"type\":\"BINARY\"},{\"index\":8,\"name\":\"t\",\"type\":\"TIMESTAMP\"},{\"index\":9,\"name\":\"x\",\"type\":\"SYMBOL\"},{\"index\":10,\"name\":\"z\",\"type\":\"STRING\"},{\"index\":11,\"name\":\"y\",\"type\":\"BOOLEAN\"}],\"timestampIndex\":8}", (CharSequence)sink);
            Assert.assertEquals((long)1L, (long)reader.getPartitionedBy());
            Assert.assertEquals((long)0L, (long)reader.size());
            SymbolMapReader symbolMapReader = reader.getSymbolMapReader(reader.getMetadata().getColumnIndexQuiet((CharSequence)"x"));
            Assert.assertNotNull((Object)symbolMapReader);
            Assert.assertEquals((long)16L, (long)symbolMapReader.getSymbolCapacity());
            Assert.assertFalse((boolean)symbolMapReader.isCached());
        }
    }

    @Test
    public void testCreateEmptyTableWithIndex() throws SqlException {
        compiler.compile((CharSequence)"create table x (a INT, b BYTE, c SHORT, d LONG, e FLOAT, f DOUBLE, g DATE, h BINARY, t TIMESTAMP, x SYMBOL capacity 16 cache index capacity 2048, z STRING, y BOOLEAN) timestamp(t) partition by MONTH", bindVariableService);
        try (TableReader reader = engine.getReader((CharSequence)"x", -1L);){
            sink.clear();
            reader.getMetadata().toJson((CharSink)sink);
            TestUtils.assertEquals((CharSequence)"{\"columnCount\":12,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"INT\"},{\"index\":1,\"name\":\"b\",\"type\":\"BYTE\"},{\"index\":2,\"name\":\"c\",\"type\":\"SHORT\"},{\"index\":3,\"name\":\"d\",\"type\":\"LONG\"},{\"index\":4,\"name\":\"e\",\"type\":\"FLOAT\"},{\"index\":5,\"name\":\"f\",\"type\":\"DOUBLE\"},{\"index\":6,\"name\":\"g\",\"type\":\"DATE\"},{\"index\":7,\"name\":\"h\",\"type\":\"BINARY\"},{\"index\":8,\"name\":\"t\",\"type\":\"TIMESTAMP\"},{\"index\":9,\"name\":\"x\",\"type\":\"SYMBOL\",\"indexed\":true,\"indexValueBlockCapacity\":2048},{\"index\":10,\"name\":\"z\",\"type\":\"STRING\"},{\"index\":11,\"name\":\"y\",\"type\":\"BOOLEAN\"}],\"timestampIndex\":8}", (CharSequence)sink);
            Assert.assertEquals((long)1L, (long)reader.getPartitionedBy());
            Assert.assertEquals((long)0L, (long)reader.size());
            SymbolMapReader symbolMapReader = reader.getSymbolMapReader(reader.getMetadata().getColumnIndexQuiet((CharSequence)"x"));
            Assert.assertNotNull((Object)symbolMapReader);
            Assert.assertEquals((long)16L, (long)symbolMapReader.getSymbolCapacity());
            Assert.assertTrue((boolean)symbolMapReader.isCached());
        }
    }

    @Test
    public void testCreateTableFail() throws Exception {
        FilesFacadeImpl ff = new FilesFacadeImpl(){
            int count = 8;

            public long mmap(long fd, long len, long offset, int mode) {
                if (this.count-- > 0) {
                    return super.mmap(fd, len, offset, mode);
                }
                return -1L;
            }
        };
        DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root, (FilesFacade)ff){
            final /* synthetic */ FilesFacade val$ff;
            {
                this.val$ff = filesFacade;
                super(x0);
            }

            public FilesFacade getFilesFacade() {
                return this.val$ff;
            }
        };
        TestUtils.assertMemoryLeak(() -> SqlCompilerTest.lambda$testCreateTableFail$1((CairoConfiguration)configuration));
    }

    @Test
    public void testCreateTableUtf8() throws SqlException, IOException {
        compiler.compile((CharSequence)"create table \u0434\u043e\u0445\u043e\u0434\u044b(\u044d\u043a\u0441\u043f\u043e\u0440\u0442 int)", bindVariableService);
        try (TableWriter writer = engine.getWriter((CharSequence)"\u0434\u043e\u0445\u043e\u0434\u044b");){
            for (int i = 0; i < 20; ++i) {
                TableWriter.Row row = writer.newRow(0L);
                row.putInt(0, i);
                row.append();
            }
            writer.commit();
        }
        compiler.compile((CharSequence)"create table \u043c\u0438\u043b\u043b\u0438\u043e\u043d\u044b as (select * from \u0434\u043e\u0445\u043e\u0434\u044b)", bindVariableService);
        var2_2 = null;
        try (TableReader reader = engine.getReader((CharSequence)"\u043c\u0438\u043b\u043b\u0438\u043e\u043d\u044b", -1L);){
            sink.clear();
            printer.print((RecordCursor)reader.getCursor(), reader.getMetadata(), true);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        String expected = "\u044d\u043a\u0441\u043f\u043e\u0440\u0442\n0\n1\n2\n3\n4\n5\n6\n7\n8\n9\n10\n11\n12\n13\n14\n15\n16\n17\n18\n19\n";
        TestUtils.assertEquals((CharSequence)"\u044d\u043a\u0441\u043f\u043e\u0440\u0442\n0\n1\n2\n3\n4\n5\n6\n7\n8\n9\n10\n11\n12\n13\n14\n15\n16\n17\n18\n19\n", (CharSequence)sink);
    }

    @Test
    public void testDuplicateTableName() throws Exception {
        compiler.compile((CharSequence)"create table x (a INT, b BYTE, t TIMESTAMP, y BOOLEAN) timestamp(t) partition by MONTH", bindVariableService);
        this.assertFailure(13, "table already exists", "create table x (t TIMESTAMP, y BOOLEAN) timestamp(t) partition by MONTH");
    }

    @Test
    public void testExecuteQuery() throws Exception {
        this.assertFailure(58, "not a TIMESTAMP", "select * from random_cursor(20, 'x', rnd_int()) timestamp(x)");
    }

    @Test
    public void testInsertAsSelect() throws Exception {
        String expectedData = "a\tb\tc\td\te\tf\tg\th\ti\tj\tk\tl\tm\tn\to\tp\n1569490116\tNaN\tfalse\t\tNaN\t0.7611\t428\t-1593\t2015-04-04T16:34:47.226Z\t\t\t185\t7039584373105579285\t1970-01-01T00:00:00.000000Z\t4\t00000000 af 19 c4 95 94 36 53 49 b4 59 7e\n1253890363\t10\tfalse\tXYS\t0.191123461757\t0.5793\t881\t-1379\t\t2015-03-04T23:08:35.722465Z\tHYRX\t188\t-4986232506486815364\t1970-01-01T00:16:40.000000Z\t50\t00000000 42 fc 31 79 5f 8b 81 2b 93 4d 1a 8e 78 b5\n-1819240775\t27\ttrue\tGOO\t0.041428124702\t0.9205\t97\t-9039\t2015-08-25T03:15:07.653Z\t2015-12-06T09:41:30.297134Z\tHYRX\t109\t571924429013198086\t1970-01-01T00:33:20.000000Z\t21\t\n-1201923128\t18\ttrue\tUVS\t0.758817540345\t0.5779\t480\t-4379\t2015-12-16T09:15:02.086Z\t2015-05-31T18:12:45.686366Z\tCPSW\tNaN\t-6161552193869048721\t1970-01-01T00:50:00.000000Z\t27\t00000000 28 c7 84 47 dc d2 85 7f a5 b8 7b 4a 9d 46\n865832060\tNaN\ttrue\t\t0.148305523358\t0.9442\t95\t2508\t\t2015-10-20T09:33:20.502524Z\t\tNaN\t-3289070757475856942\t1970-01-01T01:06:40.000000Z\t40\t00000000 f2 3c ed 39 ac a8 3b a6 dc 3b 7d 2b e3 92 fe 69\n00000010 38 e1\n1100812407\t22\tfalse\tOVL\tNaN\t0.7633\t698\t-17778\t2015-09-13T09:55:17.815Z\t\tCPSW\t182\t-8757007522346766135\t1970-01-01T01:23:20.000000Z\t23\t\n1677463366\t18\tfalse\tMNZ\t0.337470756550\t0.1179\t533\t18904\t2015-05-13T23:13:05.262Z\t2015-05-10T00:20:17.926993Z\t\t175\t6351664568801157821\t1970-01-01T01:40:00.000000Z\t29\t00000000 5d d0 eb 67 44 a7 6a 71 34 e0 b0 e9 98 f7 67 62\n00000010 28 60\n39497392\t4\tfalse\tUOH\t0.029227696943\t0.1718\t652\t14242\t\t2015-05-24T22:09:55.175991Z\tVTJW\t141\t3527911398466283309\t1970-01-01T01:56:40.000000Z\t9\t00000000 d9 6f 04 ab 27 47 8f 23 3f ae 7c 9f 77 04 e9 0c\n00000010 ea 4e ea 8b\n1545963509\t10\tfalse\tNWI\t0.113718418361\t0.0620\t356\t-29980\t2015-09-12T14:33:11.105Z\t2015-08-06T04:51:01.526782Z\t\t168\t6380499796471875623\t1970-01-01T02:13:20.000000Z\t13\t00000000 54 52 d0 29 26 c5 aa da 18 ce 5f b2 8b 5c 54 90\n53462821\t4\tfalse\tGOO\t0.055149337562\t0.1195\t115\t-6087\t2015-08-09T19:28:14.249Z\t2015-09-20T01:50:37.694867Z\tCPSW\t145\t-7212878484370155026\t1970-01-01T02:30:00.000000Z\t46\t\n-2139296159\t30\tfalse\t\t0.185864355816\t0.5638\t299\t21020\t2015-12-30T22:10:50.759Z\t2015-01-19T15:54:44.696040Z\tHYRX\t105\t-3463832009795858033\t1970-01-01T02:46:40.000000Z\t38\t00000000 b8 07 b1 32 57 ff 9a ef 88 cb 4b\n-406528351\t21\tfalse\tNLE\tNaN\tNaN\t968\t21057\t2015-10-17T07:20:26.881Z\t2015-06-02T13:00:45.180827Z\tPEHN\t102\t5360746485515325739\t1970-01-01T03:03:20.000000Z\t43\t\n415709351\t17\tfalse\tGQZ\t0.491990017163\t0.6292\t581\t18605\t2015-03-04T06:48:42.194Z\t2015-08-14T15:51:23.307152Z\tHYRX\t185\t-5611837907908424613\t1970-01-01T03:20:00.000000Z\t19\t00000000 20 e2 37 f2 64 43 84 55 a0 dd 44 11 e2 a3 24 4e\n00000010 44 a8 0d fe\n-1387693529\t19\ttrue\tMCG\t0.848083900630\t0.4699\t119\t24206\t2015-03-01T23:54:10.204Z\t2015-10-01T12:02:08.698373Z\t\t175\t3669882909701240516\t1970-01-01T03:36:40.000000Z\t12\t00000000 8f bb 2a 4b af 8f 89 df 35 8f da fe 33 98 80 85\n00000010 20 53 3b 51\n346891421\t21\tfalse\t\t0.933609514583\t0.6380\t405\t15084\t2015-10-12T05:36:54.066Z\t2015-11-16T05:48:57.958190Z\tPEHN\t196\t-9200716729349404576\t1970-01-01T03:53:20.000000Z\t43\t\n263487884\t27\ttrue\tHZQ\t0.703978540803\t0.8461\t834\t31562\t2015-08-04T00:55:25.323Z\t2015-07-25T18:26:42.499255Z\tHYRX\t128\t8196544381931602027\t1970-01-01T04:10:00.000000Z\t15\t00000000 71 76 bc 45 24 cd 13 00 7c fb 01 19 ca f2\n-1034870849\t9\tfalse\tLSV\t0.650660460171\t0.7020\t110\t-838\t2015-08-17T23:50:39.534Z\t2015-03-17T03:23:26.126568Z\tHYRX\tNaN\t-6929866925584807039\t1970-01-01T04:26:40.000000Z\t4\t00000000 4b fb 2d 16 f3 89 a3 83 64 de\n1848218326\t26\ttrue\tSUW\t0.803404910559\t0.0440\t854\t-3502\t2015-04-04T20:55:02.116Z\t2015-11-23T07:46:10.570856Z\t\t145\t4290477379978201771\t1970-01-01T04:43:20.000000Z\t35\t00000000 6d 54 75 10 b3 4c 0e 8f f1 0c c5 60 b7 d1 5a\n-1496904948\t5\ttrue\tDBZ\t0.286271736488\tNaN\t764\t5698\t2015-02-06T02:49:54.147Z\t\t\tNaN\t-3058745577013275321\t1970-01-01T05:00:00.000000Z\t19\t00000000 d4 ab be 30 fa 8d ac 3d 98 a0 ad 9a 5d\n856634079\t20\ttrue\tRJU\t0.108206023861\t0.4565\t669\t13505\t2015-11-14T15:19:19.390Z\t\tVTJW\t134\t-3700177025310488849\t1970-01-01T05:16:40.000000Z\t3\t00000000 f8 a1 46 87 28 92 a3 9b e3 cb c2 64 8a b0 35 d8\n00000010 ab 3f a1 f5\n";
        this.testInsertAsSelect(expectedData, "create table x (a INT, b INT, c BOOLEAN, d STRING, e DOUBLE, f FLOAT, g SHORT, h SHORT, i DATE, j TIMESTAMP, k SYMBOL, l LONG, m LONG, n TIMESTAMP, o BYTE, p BINARY)", "insert into x select rnd_int(), rnd_int(0, 30, 2), rnd_boolean(), rnd_str(3,3,2), rnd_double(2), rnd_float(2), rnd_short(10,1024), rnd_short(), rnd_date(to_date('2015', 'yyyy'), to_date('2016', 'yyyy'), 2), rnd_timestamp(to_timestamp('2015', 'yyyy'), to_timestamp('2016', 'yyyy'), 2), rnd_symbol(4,4,4,2), rnd_long(100,200,2), rnd_long(), timestamp_sequence(to_timestamp(0), 1000000000), rnd_byte(2,50), rnd_bin(10, 20, 2) from long_sequence(20)", "select * from x");
    }

    @Test
    public void testInsertAsSelectColumnList() throws Exception {
        String expectedData = "a\tb\tc\td\te\tf\tg\th\ti\tj\tk\tl\tm\tn\to\tp\n1569490116\tNaN\tfalse\t\tNaN\t0.7611\t428\t-1593\t2015-04-04T16:34:47.226Z\t\t\t185\t7039584373105579285\t1970-01-01T00:00:00.000000Z\t4\t00000000 af 19 c4 95 94 36 53 49 b4 59 7e\n1253890363\t10\tfalse\tXYS\t0.191123461757\t0.5793\t881\t-1379\t\t2015-03-04T23:08:35.722465Z\tHYRX\t188\t-4986232506486815364\t1970-01-01T00:16:40.000000Z\t50\t00000000 42 fc 31 79 5f 8b 81 2b 93 4d 1a 8e 78 b5\n-1819240775\t27\ttrue\tGOO\t0.041428124702\t0.9205\t97\t-9039\t2015-08-25T03:15:07.653Z\t2015-12-06T09:41:30.297134Z\tHYRX\t109\t571924429013198086\t1970-01-01T00:33:20.000000Z\t21\t\n-1201923128\t18\ttrue\tUVS\t0.758817540345\t0.5779\t480\t-4379\t2015-12-16T09:15:02.086Z\t2015-05-31T18:12:45.686366Z\tCPSW\tNaN\t-6161552193869048721\t1970-01-01T00:50:00.000000Z\t27\t00000000 28 c7 84 47 dc d2 85 7f a5 b8 7b 4a 9d 46\n865832060\tNaN\ttrue\t\t0.148305523358\t0.9442\t95\t2508\t\t2015-10-20T09:33:20.502524Z\t\tNaN\t-3289070757475856942\t1970-01-01T01:06:40.000000Z\t40\t00000000 f2 3c ed 39 ac a8 3b a6 dc 3b 7d 2b e3 92 fe 69\n00000010 38 e1\n1100812407\t22\tfalse\tOVL\tNaN\t0.7633\t698\t-17778\t2015-09-13T09:55:17.815Z\t\tCPSW\t182\t-8757007522346766135\t1970-01-01T01:23:20.000000Z\t23\t\n1677463366\t18\tfalse\tMNZ\t0.337470756550\t0.1179\t533\t18904\t2015-05-13T23:13:05.262Z\t2015-05-10T00:20:17.926993Z\t\t175\t6351664568801157821\t1970-01-01T01:40:00.000000Z\t29\t00000000 5d d0 eb 67 44 a7 6a 71 34 e0 b0 e9 98 f7 67 62\n00000010 28 60\n39497392\t4\tfalse\tUOH\t0.029227696943\t0.1718\t652\t14242\t\t2015-05-24T22:09:55.175991Z\tVTJW\t141\t3527911398466283309\t1970-01-01T01:56:40.000000Z\t9\t00000000 d9 6f 04 ab 27 47 8f 23 3f ae 7c 9f 77 04 e9 0c\n00000010 ea 4e ea 8b\n1545963509\t10\tfalse\tNWI\t0.113718418361\t0.0620\t356\t-29980\t2015-09-12T14:33:11.105Z\t2015-08-06T04:51:01.526782Z\t\t168\t6380499796471875623\t1970-01-01T02:13:20.000000Z\t13\t00000000 54 52 d0 29 26 c5 aa da 18 ce 5f b2 8b 5c 54 90\n53462821\t4\tfalse\tGOO\t0.055149337562\t0.1195\t115\t-6087\t2015-08-09T19:28:14.249Z\t2015-09-20T01:50:37.694867Z\tCPSW\t145\t-7212878484370155026\t1970-01-01T02:30:00.000000Z\t46\t\n-2139296159\t30\tfalse\t\t0.185864355816\t0.5638\t299\t21020\t2015-12-30T22:10:50.759Z\t2015-01-19T15:54:44.696040Z\tHYRX\t105\t-3463832009795858033\t1970-01-01T02:46:40.000000Z\t38\t00000000 b8 07 b1 32 57 ff 9a ef 88 cb 4b\n-406528351\t21\tfalse\tNLE\tNaN\tNaN\t968\t21057\t2015-10-17T07:20:26.881Z\t2015-06-02T13:00:45.180827Z\tPEHN\t102\t5360746485515325739\t1970-01-01T03:03:20.000000Z\t43\t\n415709351\t17\tfalse\tGQZ\t0.491990017163\t0.6292\t581\t18605\t2015-03-04T06:48:42.194Z\t2015-08-14T15:51:23.307152Z\tHYRX\t185\t-5611837907908424613\t1970-01-01T03:20:00.000000Z\t19\t00000000 20 e2 37 f2 64 43 84 55 a0 dd 44 11 e2 a3 24 4e\n00000010 44 a8 0d fe\n-1387693529\t19\ttrue\tMCG\t0.848083900630\t0.4699\t119\t24206\t2015-03-01T23:54:10.204Z\t2015-10-01T12:02:08.698373Z\t\t175\t3669882909701240516\t1970-01-01T03:36:40.000000Z\t12\t00000000 8f bb 2a 4b af 8f 89 df 35 8f da fe 33 98 80 85\n00000010 20 53 3b 51\n346891421\t21\tfalse\t\t0.933609514583\t0.6380\t405\t15084\t2015-10-12T05:36:54.066Z\t2015-11-16T05:48:57.958190Z\tPEHN\t196\t-9200716729349404576\t1970-01-01T03:53:20.000000Z\t43\t\n263487884\t27\ttrue\tHZQ\t0.703978540803\t0.8461\t834\t31562\t2015-08-04T00:55:25.323Z\t2015-07-25T18:26:42.499255Z\tHYRX\t128\t8196544381931602027\t1970-01-01T04:10:00.000000Z\t15\t00000000 71 76 bc 45 24 cd 13 00 7c fb 01 19 ca f2\n-1034870849\t9\tfalse\tLSV\t0.650660460171\t0.7020\t110\t-838\t2015-08-17T23:50:39.534Z\t2015-03-17T03:23:26.126568Z\tHYRX\tNaN\t-6929866925584807039\t1970-01-01T04:26:40.000000Z\t4\t00000000 4b fb 2d 16 f3 89 a3 83 64 de\n1848218326\t26\ttrue\tSUW\t0.803404910559\t0.0440\t854\t-3502\t2015-04-04T20:55:02.116Z\t2015-11-23T07:46:10.570856Z\t\t145\t4290477379978201771\t1970-01-01T04:43:20.000000Z\t35\t00000000 6d 54 75 10 b3 4c 0e 8f f1 0c c5 60 b7 d1 5a\n-1496904948\t5\ttrue\tDBZ\t0.286271736488\tNaN\t764\t5698\t2015-02-06T02:49:54.147Z\t\t\tNaN\t-3058745577013275321\t1970-01-01T05:00:00.000000Z\t19\t00000000 d4 ab be 30 fa 8d ac 3d 98 a0 ad 9a 5d\n856634079\t20\ttrue\tRJU\t0.108206023861\t0.4565\t669\t13505\t2015-11-14T15:19:19.390Z\t\tVTJW\t134\t-3700177025310488849\t1970-01-01T05:16:40.000000Z\t3\t00000000 f8 a1 46 87 28 92 a3 9b e3 cb c2 64 8a b0 35 d8\n00000010 ab 3f a1 f5\n";
        this.testInsertAsSelect(expectedData, "create table x (a INT, b INT, c BOOLEAN, d STRING, e DOUBLE, f FLOAT, g SHORT, h SHORT, i DATE, j TIMESTAMP, k SYMBOL, l LONG, m LONG, n TIMESTAMP, o BYTE, p BINARY)", "insert into x (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) select rnd_int(), rnd_int(0, 30, 2), rnd_boolean(), rnd_str(3,3,2), rnd_double(2), rnd_float(2), rnd_short(10,1024), rnd_short(), rnd_date(to_date('2015', 'yyyy'), to_date('2016', 'yyyy'), 2), rnd_timestamp(to_timestamp('2015', 'yyyy'), to_timestamp('2016', 'yyyy'), 2), rnd_symbol(4,4,4,2), rnd_long(100,200,2), rnd_long(), timestamp_sequence(to_timestamp(0), 1000000000), rnd_byte(2,50), rnd_bin(10, 20, 2) from long_sequence(20)", "select * from x");
    }

    @Test
    public void testInsertAsSelectColumnListAndTimestamp() throws Exception {
        String expectedData = "a\tb\tc\td\te\tf\tg\th\ti\tj\tk\tl\tm\tn\to\tp\n1569490116\tNaN\tfalse\t\tNaN\t0.7611\t428\t-1593\t2015-04-04T16:34:47.226Z\t\t\t185\t7039584373105579285\t1970-01-01T00:00:00.000000Z\t4\t00000000 af 19 c4 95 94 36 53 49 b4 59 7e\n1253890363\t10\tfalse\tXYS\t0.191123461757\t0.5793\t881\t-1379\t\t2015-03-04T23:08:35.722465Z\tHYRX\t188\t-4986232506486815364\t1970-01-01T00:16:40.000000Z\t50\t00000000 42 fc 31 79 5f 8b 81 2b 93 4d 1a 8e 78 b5\n-1819240775\t27\ttrue\tGOO\t0.041428124702\t0.9205\t97\t-9039\t2015-08-25T03:15:07.653Z\t2015-12-06T09:41:30.297134Z\tHYRX\t109\t571924429013198086\t1970-01-01T00:33:20.000000Z\t21\t\n-1201923128\t18\ttrue\tUVS\t0.758817540345\t0.5779\t480\t-4379\t2015-12-16T09:15:02.086Z\t2015-05-31T18:12:45.686366Z\tCPSW\tNaN\t-6161552193869048721\t1970-01-01T00:50:00.000000Z\t27\t00000000 28 c7 84 47 dc d2 85 7f a5 b8 7b 4a 9d 46\n865832060\tNaN\ttrue\t\t0.148305523358\t0.9442\t95\t2508\t\t2015-10-20T09:33:20.502524Z\t\tNaN\t-3289070757475856942\t1970-01-01T01:06:40.000000Z\t40\t00000000 f2 3c ed 39 ac a8 3b a6 dc 3b 7d 2b e3 92 fe 69\n00000010 38 e1\n1100812407\t22\tfalse\tOVL\tNaN\t0.7633\t698\t-17778\t2015-09-13T09:55:17.815Z\t\tCPSW\t182\t-8757007522346766135\t1970-01-01T01:23:20.000000Z\t23\t\n1677463366\t18\tfalse\tMNZ\t0.337470756550\t0.1179\t533\t18904\t2015-05-13T23:13:05.262Z\t2015-05-10T00:20:17.926993Z\t\t175\t6351664568801157821\t1970-01-01T01:40:00.000000Z\t29\t00000000 5d d0 eb 67 44 a7 6a 71 34 e0 b0 e9 98 f7 67 62\n00000010 28 60\n39497392\t4\tfalse\tUOH\t0.029227696943\t0.1718\t652\t14242\t\t2015-05-24T22:09:55.175991Z\tVTJW\t141\t3527911398466283309\t1970-01-01T01:56:40.000000Z\t9\t00000000 d9 6f 04 ab 27 47 8f 23 3f ae 7c 9f 77 04 e9 0c\n00000010 ea 4e ea 8b\n1545963509\t10\tfalse\tNWI\t0.113718418361\t0.0620\t356\t-29980\t2015-09-12T14:33:11.105Z\t2015-08-06T04:51:01.526782Z\t\t168\t6380499796471875623\t1970-01-01T02:13:20.000000Z\t13\t00000000 54 52 d0 29 26 c5 aa da 18 ce 5f b2 8b 5c 54 90\n53462821\t4\tfalse\tGOO\t0.055149337562\t0.1195\t115\t-6087\t2015-08-09T19:28:14.249Z\t2015-09-20T01:50:37.694867Z\tCPSW\t145\t-7212878484370155026\t1970-01-01T02:30:00.000000Z\t46\t\n-2139296159\t30\tfalse\t\t0.185864355816\t0.5638\t299\t21020\t2015-12-30T22:10:50.759Z\t2015-01-19T15:54:44.696040Z\tHYRX\t105\t-3463832009795858033\t1970-01-01T02:46:40.000000Z\t38\t00000000 b8 07 b1 32 57 ff 9a ef 88 cb 4b\n-406528351\t21\tfalse\tNLE\tNaN\tNaN\t968\t21057\t2015-10-17T07:20:26.881Z\t2015-06-02T13:00:45.180827Z\tPEHN\t102\t5360746485515325739\t1970-01-01T03:03:20.000000Z\t43\t\n415709351\t17\tfalse\tGQZ\t0.491990017163\t0.6292\t581\t18605\t2015-03-04T06:48:42.194Z\t2015-08-14T15:51:23.307152Z\tHYRX\t185\t-5611837907908424613\t1970-01-01T03:20:00.000000Z\t19\t00000000 20 e2 37 f2 64 43 84 55 a0 dd 44 11 e2 a3 24 4e\n00000010 44 a8 0d fe\n-1387693529\t19\ttrue\tMCG\t0.848083900630\t0.4699\t119\t24206\t2015-03-01T23:54:10.204Z\t2015-10-01T12:02:08.698373Z\t\t175\t3669882909701240516\t1970-01-01T03:36:40.000000Z\t12\t00000000 8f bb 2a 4b af 8f 89 df 35 8f da fe 33 98 80 85\n00000010 20 53 3b 51\n346891421\t21\tfalse\t\t0.933609514583\t0.6380\t405\t15084\t2015-10-12T05:36:54.066Z\t2015-11-16T05:48:57.958190Z\tPEHN\t196\t-9200716729349404576\t1970-01-01T03:53:20.000000Z\t43\t\n263487884\t27\ttrue\tHZQ\t0.703978540803\t0.8461\t834\t31562\t2015-08-04T00:55:25.323Z\t2015-07-25T18:26:42.499255Z\tHYRX\t128\t8196544381931602027\t1970-01-01T04:10:00.000000Z\t15\t00000000 71 76 bc 45 24 cd 13 00 7c fb 01 19 ca f2\n-1034870849\t9\tfalse\tLSV\t0.650660460171\t0.7020\t110\t-838\t2015-08-17T23:50:39.534Z\t2015-03-17T03:23:26.126568Z\tHYRX\tNaN\t-6929866925584807039\t1970-01-01T04:26:40.000000Z\t4\t00000000 4b fb 2d 16 f3 89 a3 83 64 de\n1848218326\t26\ttrue\tSUW\t0.803404910559\t0.0440\t854\t-3502\t2015-04-04T20:55:02.116Z\t2015-11-23T07:46:10.570856Z\t\t145\t4290477379978201771\t1970-01-01T04:43:20.000000Z\t35\t00000000 6d 54 75 10 b3 4c 0e 8f f1 0c c5 60 b7 d1 5a\n-1496904948\t5\ttrue\tDBZ\t0.286271736488\tNaN\t764\t5698\t2015-02-06T02:49:54.147Z\t\t\tNaN\t-3058745577013275321\t1970-01-01T05:00:00.000000Z\t19\t00000000 d4 ab be 30 fa 8d ac 3d 98 a0 ad 9a 5d\n856634079\t20\ttrue\tRJU\t0.108206023861\t0.4565\t669\t13505\t2015-11-14T15:19:19.390Z\t\tVTJW\t134\t-3700177025310488849\t1970-01-01T05:16:40.000000Z\t3\t00000000 f8 a1 46 87 28 92 a3 9b e3 cb c2 64 8a b0 35 d8\n00000010 ab 3f a1 f5\n";
        this.testInsertAsSelect(expectedData, "create table x (a INT, b INT, c BOOLEAN, d STRING, e DOUBLE, f FLOAT, g SHORT, h SHORT, i DATE, j TIMESTAMP, k SYMBOL, l LONG, m LONG, n TIMESTAMP, o BYTE, p BINARY) timestamp(n)", "insert into x (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p) select * from (select rnd_int(), rnd_int(0, 30, 2), rnd_boolean(), rnd_str(3,3,2), rnd_double(2), rnd_float(2), rnd_short(10,1024), rnd_short(), rnd_date(to_date('2015', 'yyyy'), to_date('2016', 'yyyy'), 2), rnd_timestamp(to_timestamp('2015', 'yyyy'), to_timestamp('2016', 'yyyy'), 2), rnd_symbol(4,4,4,2), rnd_long(100,200,2), rnd_long(), timestamp_sequence(to_timestamp(0), 1000000000) ts, rnd_byte(2,50), rnd_bin(10, 20, 2) from long_sequence(20)) timestamp(ts)", "select * from x");
    }

    @Test
    public void testInsertAsSelectColumnSubset() throws Exception {
        String expectedData = "a\tb\tc\td\te\tf\tg\tj\tk\tl\tm\tn\to\tp\nNaN\tNaN\tfalse\t\t0.804322409997\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T00:00:00.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.084869642326\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T00:16:40.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.084383207626\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T00:33:20.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.650859402586\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T00:50:00.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.790567531968\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T01:06:40.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.224523408561\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T01:23:20.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.349107036373\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T01:40:00.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.761102951500\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T01:56:40.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.421776884197\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T02:13:20.000000Z\t0\t\nNaN\tNaN\tfalse\t\tNaN\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T02:30:00.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.726113620982\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T02:46:40.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.422435666165\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T03:03:20.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.709436048717\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T03:20:00.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.385399478652\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T03:36:40.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.003598367215\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T03:53:20.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.328817690768\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T04:10:00.000000Z\t0\t\nNaN\tNaN\tfalse\t\tNaN\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T04:26:40.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.977110314605\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T04:43:20.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.248088123767\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T05:00:00.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.638160753118\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T05:16:40.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.125030421903\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T05:33:20.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.903806879651\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T05:50:00.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.134501705709\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T06:06:40.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.891258753660\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T06:23:20.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.975526354057\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T06:40:00.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.269221034797\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T06:56:40.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.413816474823\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T07:13:20.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.552249417051\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T07:30:00.000000Z\t0\t\nNaN\tNaN\tfalse\t\t0.245934527761\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T07:46:40.000000Z\t0\t\nNaN\tNaN\tfalse\t\tNaN\tNaN\t0\t\t\tNaN\tNaN\t1970-01-01T08:03:20.000000Z\t0\t\n";
        this.testInsertAsSelect(expectedData, "create table x (a INT, b INT, c BOOLEAN, d STRING, e DOUBLE, f FLOAT, g SHORT, j TIMESTAMP, k SYMBOL, l LONG, m LONG, n TIMESTAMP, o BYTE, p BINARY)", "insert into x (e,n)select rnd_double(2), timestamp_sequence(to_timestamp(0), 1000000000) from long_sequence(30)", "x");
    }

    @Test
    public void testInsertAsSelectColumnSubset2() throws Exception {
        String expectedData = "a\tb\tc\td\te\tf\tg\tj\tk\tl\tm\tn\to\tp\nNaN\tNaN\tfalse\t\t0.804322409997\tNaN\t-13027\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.284557779121\tNaN\t21015\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.934460485739\tNaN\t-5356\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.790567531968\tNaN\t-19832\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.889928691229\tNaN\t23922\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\tNaN\tNaN\t31987\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.462183542913\tNaN\t-4472\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.807237223338\tNaN\t4924\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.627695402837\tNaN\t-11679\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.709436048717\tNaN\t-12348\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.198558179736\tNaN\t-8877\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.524932106269\tNaN\t13182\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\tNaN\tNaN\t2056\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.215832242693\tNaN\t12941\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.814680794450\tNaN\t-5176\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.125030421903\tNaN\t-7976\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.968742327694\tNaN\t15926\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.670047639180\tNaN\t2276\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.975526354057\tNaN\t5639\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.810161274171\tNaN\t-391\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.376250170950\tNaN\t-30933\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.245934527761\tNaN\t20366\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.975019885373\tNaN\t-3567\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.490051044989\tNaN\t3428\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\tNaN\tNaN\t29978\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.041428124702\tNaN\t-19136\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.799773322997\tNaN\t-21442\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.659034160769\tNaN\t-2018\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.173705703243\tNaN\t9478\t\t\tNaN\tNaN\t\t0\t\nNaN\tNaN\tfalse\t\t0.046458498446\tNaN\t6093\t\t\tNaN\tNaN\t\t0\t\n";
        this.testInsertAsSelect(expectedData, "create table x (a INT, b INT, c BOOLEAN, d STRING, e DOUBLE, f FLOAT, g SHORT, j TIMESTAMP, k SYMBOL, l LONG, m LONG, n TIMESTAMP, o BYTE, p BINARY)", "insert into x (e,g)select rnd_double(2), rnd_short() from long_sequence(30)", "x");
    }

    @Test
    public void testInsertAsSelectConvertible1() throws Exception {
        this.testInsertAsSelect("a\tb\n-1148479920\tJWCPS\n592859671\tYRXPE\n806715481\tRXGZS\n1904508147\tXIBBT\n-85170055\tGWFFY\n-1715058769\tEYYQE\n-2119387831\tHFOWL\n-938514914\tXYSBE\n-461611463\tOJSHR\n-1272693194\tDRQQU\n-2144581835\tFJGET\n-296610933\tSZSRY\n1637847416\tBVTMH\n1627393380\tOZZVD\n-372268574\tMYICC\n-661194722\tOUICW\n-1201923128\tGHVUV\n-1950552842\tOTSED\n-916132123\tCTGQO\n659736535\tXWCKY\n-2075675260\tUWDSW\n1060917944\tSHOLN\n-1966408995\tIQBZX\n2124174232\tVIKJS\n-2088317486\tSUQSR\n1245795385\tKVVSJ\n116799613\tIPHZE\n359345889\tHVLTO\n-640305320\tJUMLG\n2011884585\tMLLEO\n", "create table x (a INT, b SYMBOL)", "insert into x select rnd_int(), rnd_str(5,5,0) from long_sequence(30)", "x");
    }

    @Test
    public void testInsertAsSelectConvertible2() throws Exception {
        this.testInsertAsSelect("b\ta\n-2144581835\tSBEOUOJSH\n-1162267908\tUEDRQQU\n-1575135393\tHYRXPEH\n326010667\t\n-1870444467\tSBEOUOJSH\n1637847416\tUEDRQQU\n-1533414895\tTJWCPS\n-1515787781\tBBTGPGWF\n1920890138\tTJWCPS\n-1538602195\tSBEOUOJSH\n-235358133\tRXGZSXUX\n-10505757\tHYRXPEH\n-661194722\tYUDEYYQEHB\n1196016669\t\n-1566901076\t\n-1201923128\t\n1876812930\tFOWLPDX\n-1424048819\tRXGZSXUX\n1234796102\t\n-45567293\tUEDRQQU\n-89906802\t\n-998315423\tYUDEYYQEHB\n-1794809330\tHYRXPEH\n659736535\t\n852921272\tSBEOUOJSH\n", "create table x (b INT, a STRING)", "insert into x (b,a)select rnd_int(), rnd_symbol(8,6,10,2) from long_sequence(25)", "x");
    }

    @Test
    public void testInsertAsSelectConvertibleList1() throws Exception {
        this.testInsertAsSelect("a\tb\tn\nJWCPS\t-1148479920\t\nYRXPE\t592859671\t\nRXGZS\t806715481\t\nXIBBT\t1904508147\t\nGWFFY\t-85170055\t\nEYYQE\t-1715058769\t\nHFOWL\t-2119387831\t\nXYSBE\t-938514914\t\nOJSHR\t-461611463\t\nDRQQU\t-1272693194\t\nFJGET\t-2144581835\t\nSZSRY\t-296610933\t\nBVTMH\t1637847416\t\nOZZVD\t1627393380\t\nMYICC\t-372268574\t\nOUICW\t-661194722\t\nGHVUV\t-1201923128\t\nOTSED\t-1950552842\t\nCTGQO\t-916132123\t\nXWCKY\t659736535\t\nUWDSW\t-2075675260\t\nSHOLN\t1060917944\t\nIQBZX\t-1966408995\t\nVIKJS\t2124174232\t\nSUQSR\t-2088317486\t\nKVVSJ\t1245795385\t\nIPHZE\t116799613\t\nHVLTO\t359345889\t\nJUMLG\t-640305320\t\nMLLEO\t2011884585\t\n", "create table x (a SYMBOL, b INT, n TIMESTAMP)", "insert into x (b,a)select rnd_int(), rnd_str(5,5,0) from long_sequence(30)", "x");
    }

    @Test
    public void testInsertAsSelectConvertibleList2() throws Exception {
        this.testInsertAsSelect("a\tb\tn\nSBEOUOJSH\t-2144581835\t\nUEDRQQU\t-1162267908\t\nHYRXPEH\t-1575135393\t\n\t326010667\t\nSBEOUOJSH\t-1870444467\t\nUEDRQQU\t1637847416\t\nTJWCPS\t-1533414895\t\nBBTGPGWF\t-1515787781\t\nTJWCPS\t1920890138\t\nSBEOUOJSH\t-1538602195\t\nRXGZSXUX\t-235358133\t\nHYRXPEH\t-10505757\t\nYUDEYYQEHB\t-661194722\t\n\t1196016669\t\n\t-1566901076\t\n\t-1201923128\t\nFOWLPDX\t1876812930\t\nRXGZSXUX\t-1424048819\t\n\t1234796102\t\nUEDRQQU\t-45567293\t\n\t-89906802\t\nYUDEYYQEHB\t-998315423\t\nHYRXPEH\t-1794809330\t\n\t659736535\t\nSBEOUOJSH\t852921272\t\nYUDEYYQEHB\t-1172180184\t\nSBEOUOJSH\t1254404167\t\nFOWLPDX\t-1768335227\t\n\t1060917944\t\n\t2060263242\t\n", "create table x (a STRING, b INT, n TIMESTAMP)", "insert into x (b,a)select rnd_int(), rnd_symbol(8,6,10,2) from long_sequence(30)", "x");
    }

    public void testInsertAsSelectError(CharSequence ddl, CharSequence insert, int errorPosition, CharSequence errorMessage) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try {
                if (ddl != null) {
                    compiler.compile(ddl, bindVariableService);
                }
                this.assertFailure0(errorPosition, errorMessage, insert);
                Assert.assertEquals((long)0L, (long)engine.getBusyReaderCount());
                Assert.assertEquals((long)0L, (long)engine.getBusyWriterCount());
            }
            finally {
                engine.releaseAllWriters();
                engine.releaseAllReaders();
            }
        });
    }

    @Test
    public void testInsertAsSelectFewerSelectColumns() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try {
                compiler.compile((CharSequence)"create table y as (select x, to_int(2*((x-1)/2))+2 m, abs(rnd_int() % 100) b from long_sequence(10))", bindVariableService);
                try {
                    compiler.compile((CharSequence)"insert into y select to_int(2*((x-1+10)/2))+2 m, abs(rnd_int() % 100) b from long_sequence(6)", bindVariableService);
                }
                catch (SqlException e) {
                    Assert.assertEquals((long)14L, (long)e.getPosition());
                    Assert.assertTrue((boolean)Chars.contains((CharSequence)e.getFlyweightMessage(), (CharSequence)"not enough"));
                }
                Assert.assertEquals((long)0L, (long)engine.getBusyReaderCount());
                Assert.assertEquals((long)0L, (long)engine.getBusyWriterCount());
            }
            finally {
                engine.releaseAllWriters();
                engine.releaseAllReaders();
            }
        });
    }

    @Test
    public void testInsertAsSelectInconvertible1() throws Exception {
        this.testInsertAsSelectError("create table x (a INT, b INT)", "insert into x select rnd_int(), rnd_long() from long_sequence(30)", 32, "inconvertible types");
    }

    @Test
    public void testInsertAsSelectInconvertible2() throws Exception {
        this.testInsertAsSelectError("create table x (a INT, b BYTE)", "insert into x select rnd_int(), rnd_long() from long_sequence(30)", 32, "inconvertible types");
    }

    @Test
    public void testInsertAsSelectInconvertibleList1() throws Exception {
        this.testInsertAsSelectError("create table x (a INT, b INT, n TIMESTAMP)", "insert into x (b,a)select rnd_int(), rnd_long() from long_sequence(30)", 17, "inconvertible types");
    }

    @Test
    public void testInsertAsSelectInconvertibleList2() throws Exception {
        this.testInsertAsSelectError("create table x (a BYTE, b INT, n TIMESTAMP)", "insert into x (b,a)select rnd_int(), rnd_long() from long_sequence(30)", 17, "inconvertible types");
    }

    @Test
    public void testInsertAsSelectInconvertibleList3() throws Exception {
        this.testInsertAsSelectError("create table x (a SHORT, b INT, n TIMESTAMP)", "insert into x (b,a)select rnd_int(), rnd_long() from long_sequence(30)", 17, "inconvertible types");
    }

    @Test
    public void testInsertAsSelectInconvertibleList4() throws Exception {
        this.testInsertAsSelectError("create table x (a FLOAT, b INT, n TIMESTAMP)", "insert into x (b,a)select rnd_int(), rnd_double(2) from long_sequence(30)", 17, "inconvertible types");
    }

    @Test
    public void testInsertAsSelectInconvertibleList5() throws Exception {
        this.testInsertAsSelectError("create table x (a FLOAT, b INT, n TIMESTAMP)", "insert into x (b,a)select rnd_int(), rnd_str(5,5,0) from long_sequence(30)", 17, "inconvertible types");
    }

    @Test
    public void testInsertAsSelectInvalidColumn() throws Exception {
        this.testInsertAsSelectError("create table x (aux1 INT, b INT)", "insert into x (aux1,blast)select rnd_int(), rnd_long() from long_sequence(30)", 20, "Invalid column: blast");
    }

    @Test
    public void testInsertAsSelectPersistentIOError() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            final AtomicBoolean inError = new AtomicBoolean(true);
            FilesFacadeImpl ff = new FilesFacadeImpl(){
                int pageCount = 0;

                public long getMapPageSize() {
                    return this.getPageSize();
                }

                public long mmap(long fd, long len, long offset, int mode) {
                    if (inError.get() && this.pageCount++ > 9) {
                        return -1L;
                    }
                    return super.mmap(fd, len, offset, mode);
                }
            };
            this.assertInsertAsSelectIOError(inError, (FilesFacade)ff);
        });
    }

    @Test
    public void testInsertAsSelectReplaceColumn() throws Exception {
        String expected = "a\tb\n315515118\tNaN\n-727724771\tNaN\n-948263339\tNaN\n592859671\tNaN\n-847531048\tNaN\n-2041844972\tNaN\n-1575378703\tNaN\n1545253512\tNaN\n1573662097\tNaN\n339631474\tNaN\n";
        final Fiddler fiddler = new Fiddler(){
            int state = 0;

            @Override
            public boolean isHappy() {
                return this.state > 1;
            }

            @Override
            public void run(CairoEngine engine) {
                if (this.state++ == 1) {
                    try (TableWriter writer = engine.getWriter((CharSequence)"y");){
                        writer.removeColumn((CharSequence)"int1");
                        writer.addColumn((CharSequence)"c", 3);
                    }
                }
            }
        };
        TestUtils.assertMemoryLeak(() -> {
            try (Engine engine = new Engine(configuration){

                public TableReader getReader(CharSequence tableName, long version) {
                    fiddler.run((CairoEngine)this);
                    return super.getReader(tableName, version);
                }
            };
                 SqlCompiler compiler = new SqlCompiler((CairoEngine)engine, configuration);){
                compiler.compile((CharSequence)"create table x (a INT, b INT)", bindVariableService);
                compiler.compile((CharSequence)"create table y as (select rnd_int() int1, rnd_int() int2 from long_sequence(10))", bindVariableService);
                compiler.compile((CharSequence)"insert into x select * from y", bindVariableService);
                try (RecordCursorFactory factory = compiler.compile((CharSequence)"select * from x", bindVariableService);){
                    sink.clear();
                    try (RecordCursor cursor = factory.getCursor(bindVariableService);){
                        printer.print(cursor, factory.getMetadata(), true);
                    }
                    TestUtils.assertEquals((CharSequence)"a\tb\n315515118\tNaN\n-727724771\tNaN\n-948263339\tNaN\n592859671\tNaN\n-847531048\tNaN\n-2041844972\tNaN\n-1575378703\tNaN\n1545253512\tNaN\n1573662097\tNaN\n339631474\tNaN\n", (CharSequence)sink);
                }
                Assert.assertEquals((long)0L, (long)engine.getBusyReaderCount());
                Assert.assertEquals((long)0L, (long)engine.getBusyWriterCount());
            }
        });
    }

    @Test
    public void testInsertAsSelectTableNotFound() throws Exception {
        this.testInsertAsSelectError(null, "insert into x (e,n)select rnd_double(2), timestamp_sequence(to_timestamp(0), 1000000000) from long_sequence(30)", 12, "table 'x' does not exist");
    }

    @Test
    public void testInsertAsSelectTemporaryIOError() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            final AtomicBoolean inError = new AtomicBoolean(true);
            FilesFacadeImpl ff = new FilesFacadeImpl(){
                int pageCount = 0;

                public long mmap(long fd, long len, long offset, int mode) {
                    if (inError.get() && this.pageCount++ == 9) {
                        return -1L;
                    }
                    return super.mmap(fd, len, offset, mode);
                }

                public long getMapPageSize() {
                    return this.getPageSize();
                }
            };
            this.assertInsertAsSelectIOError(inError, (FilesFacade)ff);
        });
    }

    @Test
    public void testInsertAsSelectTimestampNotInList() throws Exception {
        this.testInsertAsSelectError("create table x (a INT, b INT, n TIMESTAMP) timestamp(n)", "insert into x (b,a) select * from ( select rnd_int(), rnd_int() x from long_sequence(30)) timestamp(x)", 15, "column list must include timestamp");
    }

    @Test
    public void testInsertAsSelectTimestampNotSelected() throws Exception {
        this.testInsertAsSelectError("create table x (a INT, b INT, n TIMESTAMP) timestamp(n)", "insert into x (b,a)select rnd_int(), rnd_int() from long_sequence(30)", 12, "select clause must provide timestamp column");
    }

    @Test
    public void testRaceToCreateEmptyTable() throws InterruptedException {
        SqlCompiler compiler2 = new SqlCompiler((CairoEngine)engine, configuration);
        AtomicInteger index = new AtomicInteger();
        AtomicInteger success = new AtomicInteger();
        for (int i = 0; i < 50; ++i) {
            CyclicBarrier barrier = new CyclicBarrier(2);
            CountDownLatch haltLatch = new CountDownLatch(2);
            index.set(-1);
            success.set(0);
            new Thread(() -> {
                try {
                    barrier.await();
                    compiler.compile((CharSequence)"create table x (a INT, b FLOAT)", bindVariableService);
                    index.set(0);
                    success.incrementAndGet();
                }
                catch (Exception exception) {
                }
                finally {
                    haltLatch.countDown();
                }
            }).start();
            new Thread(() -> {
                try {
                    barrier.await();
                    compiler2.compile((CharSequence)"create table x (a STRING, b DOUBLE)", bindVariableService);
                    index.set(1);
                    success.incrementAndGet();
                }
                catch (Exception exception) {
                }
                finally {
                    haltLatch.countDown();
                }
            }).start();
            Assert.assertTrue((boolean)haltLatch.await(5L, TimeUnit.SECONDS));
            Assert.assertEquals((long)1L, (long)success.get());
            Assert.assertNotEquals((long)-1L, (long)index.get());
            try (TableReader reader = engine.getReader((CharSequence)"x", -1L);){
                sink.clear();
                reader.getMetadata().toJson((CharSink)sink);
                if (index.get() == 0) {
                    TestUtils.assertEquals((CharSequence)"{\"columnCount\":2,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"INT\"},{\"index\":1,\"name\":\"b\",\"type\":\"FLOAT\"}],\"timestampIndex\":-1}", (CharSequence)sink);
                } else {
                    TestUtils.assertEquals((CharSequence)"{\"columnCount\":2,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"STRING\"},{\"index\":1,\"name\":\"b\",\"type\":\"DOUBLE\"}],\"timestampIndex\":-1}", (CharSequence)sink);
                }
            }
            engine.remove(path, (CharSequence)"x");
        }
    }

    @Test
    public void testSqlCache() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            Throwable throwable;
            RecordCursor cursor3;
            String ddl = "create table x (a STRING, b INT, n TIMESTAMP)";
            String insert = "insert into x (b,a)select rnd_int(), rnd_symbol(8,6,10,2) from long_sequence(30)";
            String query = "x where a = :sym";
            compiler.compile((CharSequence)ddl, bindVariableService);
            compiler.compile((CharSequence)insert, bindVariableService);
            bindVariableService.setStr((CharSequence)"sym", null);
            RecordCursorFactory factory = compiler.compile((CharSequence)query, bindVariableService);
            sink.clear();
            bindVariableService.setStr((CharSequence)"sym", (CharSequence)"RXGZSXUX");
            try (RecordCursor cursor2 = factory.getCursor(bindVariableService);){
                printer.print(cursor2, factory.getMetadata(), true);
            }
            TestUtils.assertEquals((CharSequence)"a\tb\tn\nRXGZSXUX\t-235358133\t\nRXGZSXUX\t-1424048819\t\n", (CharSequence)sink);
            compiler.cache((CharSequence)query, factory);
            sink.clear();
            var5_5 = null;
            try (RecordCursorFactory f = compiler.compile((CharSequence)query, bindVariableService);){
                bindVariableService.setStr((CharSequence)"sym", null);
                cursor3 = f.getCursor(bindVariableService);
                throwable = null;
                try {
                    printer.print(cursor3, f.getMetadata(), true);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (cursor3 != null) {
                        if (throwable != null) {
                            try {
                                cursor3.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            cursor3.close();
                        }
                    }
                }
                TestUtils.assertEquals((CharSequence)"a\tb\tn\n\t326010667\t\n\t1196016669\t\n\t-1566901076\t\n\t-1201923128\t\n\t1234796102\t\n\t-89906802\t\n\t659736535\t\n\t1060917944\t\n\t2060263242\t\n", (CharSequence)sink);
            }
            catch (Throwable cursor3) {
                var5_5 = cursor3;
                throw cursor3;
            }
            bindVariableService.setStr((CharSequence)"sym", null);
            var5_5 = null;
            try (RecordCursorFactory f2 = compiler.compile((CharSequence)query, bindVariableService);){
                sink.clear();
                bindVariableService.setStr((CharSequence)"sym", (CharSequence)"RXGZSXUX");
                cursor3 = f2.getCursor(bindVariableService);
                throwable = null;
                try {
                    printer.print(cursor3, f2.getMetadata(), true);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (cursor3 != null) {
                        if (throwable != null) {
                            try {
                                cursor3.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            cursor3.close();
                        }
                    }
                }
                TestUtils.assertEquals((CharSequence)"a\tb\tn\nRXGZSXUX\t-235358133\t\nRXGZSXUX\t-1424048819\t\n", (CharSequence)sink);
            }
            catch (Throwable throwable6) {
                var5_5 = throwable6;
                throw throwable6;
            }
            engine.releaseAllWriters();
            engine.releaseAllReaders();
        });
    }

    private void assertCast(String expectedData, String expectedMeta, String sql) throws SqlException, IOException {
        compiler.compile((CharSequence)sql, bindVariableService);
        try (TableReader reader = engine.getReader((CharSequence)"y", -1L);){
            sink.clear();
            reader.getMetadata().toJson((CharSink)sink);
            TestUtils.assertEquals((CharSequence)expectedMeta, (CharSequence)sink);
            sink.clear();
            printer.print((RecordCursor)reader.getCursor(), reader.getMetadata(), true);
            TestUtils.assertEquals((CharSequence)expectedData, (CharSequence)sink);
        }
    }

    private void assertCastByte(String expectedData, int castTo) throws SqlException, IOException {
        String expectedMeta = "{\"columnCount\":1,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"" + ColumnType.nameOf((int)castTo) + "\"}],\"timestampIndex\":-1}";
        String sql = "create table y as (select * from random_cursor( 20, 'a', rnd_byte(33, 119))), cast(a as " + ColumnType.nameOf((int)castTo) + ")";
        this.assertCast(expectedData, expectedMeta, sql);
    }

    private void assertCastByteFail(int castTo) {
        try {
            compiler.compile((CharSequence)("create table y as (select * from random_cursor( 20, 'a', rnd_byte(2,50))), cast(a as " + ColumnType.nameOf((int)castTo) + ")"), bindVariableService);
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)85L, (long)e.getPosition());
            TestUtils.assertContains(e.getMessage(), "unsupported cast");
        }
    }

    private void assertCastDate(String expectedData, int castTo) throws SqlException, IOException {
        String expectedMeta = "{\"columnCount\":1,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"" + ColumnType.nameOf((int)castTo) + "\"}],\"timestampIndex\":-1}";
        String sql = "create table y as (select * from random_cursor( 20, 'a', rnd_date(to_date('2015', 'yyyy'), to_date('2016', 'yyyy'), 2))), cast(a as " + ColumnType.nameOf((int)castTo) + ")";
        this.assertCast(expectedData, expectedMeta, sql);
    }

    private void assertCastDouble(String expectedData, int castTo) throws SqlException, IOException {
        String expectedMeta = "{\"columnCount\":1,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"" + ColumnType.nameOf((int)castTo) + "\"}],\"timestampIndex\":-1}";
        String sql = "create table y as (select * from random_cursor( 20, 'a', 100 * rnd_double(2))), cast(a as " + ColumnType.nameOf((int)castTo) + ")";
        this.assertCast(expectedData, expectedMeta, sql);
    }

    private void assertCastDoubleFail(int castTo) {
        try {
            compiler.compile((CharSequence)("create table y as (select * from random_cursor( 20, 'a', rnd_double(2))), cast(a as " + ColumnType.nameOf((int)castTo) + ")"), bindVariableService);
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)84L, (long)e.getPosition());
            TestUtils.assertContains(e.getMessage(), "unsupported cast");
        }
    }

    private void assertCastFloat(String expectedData, int castTo) throws SqlException, IOException {
        String expectedMeta = "{\"columnCount\":1,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"" + ColumnType.nameOf((int)castTo) + "\"}],\"timestampIndex\":-1}";
        String sql = "create table y as (select * from random_cursor( 20, 'a', 100 * rnd_float(2))), cast(a as " + ColumnType.nameOf((int)castTo) + ")";
        this.assertCast(expectedData, expectedMeta, sql);
    }

    private void assertCastFloatFail(int castTo) {
        try {
            compiler.compile((CharSequence)("create table y as (select * from random_cursor( 20, 'a', rnd_float(2))), cast(a as " + ColumnType.nameOf((int)castTo) + ")"), bindVariableService);
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)83L, (long)e.getPosition());
            TestUtils.assertContains(e.getMessage(), "unsupported cast");
        }
    }

    private void assertCastInt(String expectedData, int castTo) throws SqlException, IOException {
        String expectedMeta = "{\"columnCount\":1,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"" + ColumnType.nameOf((int)castTo) + "\"}],\"timestampIndex\":-1}";
        String sql = "create table y as (select * from random_cursor( 20, 'a', rnd_int(0, 30, 2))), cast(a as " + ColumnType.nameOf((int)castTo) + ")";
        this.assertCast(expectedData, expectedMeta, sql);
    }

    private void assertCastIntFail(int castTo) {
        try {
            compiler.compile((CharSequence)("create table y as (select * from random_cursor( 20, 'a', rnd_int(0, 30, 2))), cast(a as " + ColumnType.nameOf((int)castTo) + ")"), bindVariableService);
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)88L, (long)e.getPosition());
            TestUtils.assertContains(e.getMessage(), "unsupported cast");
        }
    }

    private void assertCastLong(String expectedData, int castTo) throws SqlException, IOException {
        String expectedMeta = "{\"columnCount\":1,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"" + ColumnType.nameOf((int)castTo) + "\"}],\"timestampIndex\":-1}";
        String sql = "create table y as (select * from random_cursor( 20, 'a', rnd_long(0, 30, 2))), cast(a as " + ColumnType.nameOf((int)castTo) + ")";
        this.assertCast(expectedData, expectedMeta, sql);
    }

    private void assertCastLongFail(int castTo) {
        try {
            compiler.compile((CharSequence)("create table y as (select * from random_cursor( 20, 'a', rnd_long(0, 30, 2))), cast(a as " + ColumnType.nameOf((int)castTo) + ")"), bindVariableService);
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)89L, (long)e.getPosition());
            TestUtils.assertContains(e.getMessage(), "unsupported cast");
        }
    }

    private void assertCastShort(String expectedData, int castTo) throws SqlException, IOException {
        String expectedMeta = "{\"columnCount\":1,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"" + ColumnType.nameOf((int)castTo) + "\"}],\"timestampIndex\":-1}";
        String sql = "create table y as (select * from random_cursor( 20, 'a', rnd_short(1024, 2048))), cast(a as " + ColumnType.nameOf((int)castTo) + ")";
        this.assertCast(expectedData, expectedMeta, sql);
    }

    private void assertCastShortFail(int castTo) {
        try {
            compiler.compile((CharSequence)("create table y as (select * from random_cursor( 20, 'a', rnd_short(2,10))), cast(a as " + ColumnType.nameOf((int)castTo) + ")"), bindVariableService);
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)86L, (long)e.getPosition());
            TestUtils.assertContains(e.getMessage(), "unsupported cast");
        }
    }

    private void assertCastStringFail(int castTo) {
        try {
            compiler.compile((CharSequence)("create table y as (select * from random_cursor( 20, 'a', rnd_str(5,10,2))), cast(a as " + ColumnType.nameOf((int)castTo) + ")"), bindVariableService);
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)86L, (long)e.getPosition());
            TestUtils.assertContains(e.getMessage(), "unsupported cast");
        }
    }

    private void assertCastSymbolFail(int castTo) {
        try {
            compiler.compile((CharSequence)("create table y as (select * from random_cursor( 20, 'a', rnd_symbol(4,6,10,2))), cast(a as " + ColumnType.nameOf((int)castTo) + ")"), bindVariableService);
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)91L, (long)e.getPosition());
            TestUtils.assertContains(e.getMessage(), "unsupported cast");
        }
    }

    private void assertCastTimestamp(String expectedData, int castTo) throws SqlException, IOException {
        String expectedMeta = "{\"columnCount\":1,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"" + ColumnType.nameOf((int)castTo) + "\"}],\"timestampIndex\":-1}";
        String sql = "create table y as (select * from random_cursor( 20, 'a', rnd_timestamp(to_timestamp('2015', 'yyyy'), to_timestamp('2016', 'yyyy'), 2))), cast(a as " + ColumnType.nameOf((int)castTo) + ")";
        this.assertCast(expectedData, expectedMeta, sql);
    }

    private void assertCreateTableAsSelect(CharSequence expectedMetadata, CharSequence sql, final Fiddler fiddler) throws SqlException {
        compiler.compile((CharSequence)"create table X (a int, b int, t timestamp) timestamp(t)", bindVariableService);
        try (Engine engine = new Engine(configuration){

            public TableReader getReader(CharSequence tableName, long tableVersion) {
                fiddler.run((CairoEngine)this);
                return super.getReader(tableName, tableVersion);
            }
        };){
            SqlCompiler compiler = new SqlCompiler((CairoEngine)engine, configuration);
            compiler.compile(sql, bindVariableService);
            Assert.assertTrue((boolean)fiddler.isHappy());
            try (TableReader reader = engine.getReader((CharSequence)"Y", -1L);){
                sink.clear();
                reader.getMetadata().toJson((CharSink)sink);
                TestUtils.assertEquals(expectedMetadata, (CharSequence)sink);
            }
            Assert.assertEquals((long)0L, (long)engine.getBusyReaderCount());
        }
    }

    protected void assertFailure(int position, CharSequence expectedMessage, CharSequence sql) throws Exception {
        TestUtils.assertMemoryLeak(() -> this.assertFailure0(position, expectedMessage, sql));
    }

    private void assertFailure0(int position, CharSequence expectedMessage, CharSequence sql) {
        try {
            compiler.compile(sql, bindVariableService);
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)position, (long)e.getPosition());
            TestUtils.assertContains(e.getMessage(), expectedMessage);
        }
    }

    private void assertInsertAsSelectIOError(AtomicBoolean inError, final FilesFacade ff) throws SqlException {
        DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

            public FilesFacade getFilesFacade() {
                return ff;
            }
        };
        try (Engine engine = new Engine((CairoConfiguration)configuration);
             SqlCompiler compiler = new SqlCompiler((CairoEngine)engine, (CairoConfiguration)configuration);){
            compiler.compile((CharSequence)"create table x (a INT, b INT)", bindVariableService);
            try {
                compiler.compile((CharSequence)"insert into x select rnd_int() int1, rnd_int() int2 from long_sequence(1000000)", bindVariableService);
                Assert.fail();
            }
            catch (CairoException cairoException) {
                // empty catch block
            }
            try (TableWriter w = engine.getWriter((CharSequence)"x");){
                Assert.assertEquals((long)0L, (long)w.size());
            }
            inError.set(false);
            compiler.compile((CharSequence)"insert into x select rnd_int() int1, rnd_int() int2 from long_sequence(1000000)", bindVariableService);
            w = engine.getWriter((CharSequence)"x");
            var9_14 = null;
            try {
                Assert.assertEquals((long)1000000L, (long)w.size());
            }
            catch (Throwable throwable) {
                var9_14 = throwable;
                throw throwable;
            }
            finally {
                if (w != null) {
                    if (var9_14 != null) {
                        try {
                            w.close();
                        }
                        catch (Throwable throwable) {
                            var9_14.addSuppressed(throwable);
                        }
                    } else {
                        w.close();
                    }
                }
            }
            var9_14 = null;
            try (TableReader reader = engine.getReader((CharSequence)"x", 0L);){
                Assert.assertEquals((long)1000000L, (long)reader.size());
            }
            catch (Throwable throwable) {
                var9_14 = throwable;
                throw throwable;
            }
            Assert.assertEquals((long)0L, (long)engine.getBusyReaderCount());
            Assert.assertEquals((long)0L, (long)engine.getBusyWriterCount());
        }
    }

    private void testInsertAsSelect(CharSequence expectedData, CharSequence ddl, CharSequence insert, CharSequence select) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try {
                compiler.compile(ddl, bindVariableService);
                compiler.compile(insert, bindVariableService);
                try (RecordCursorFactory factory = compiler.compile(select, bindVariableService);){
                    sink.clear();
                    try (RecordCursor cursor = factory.getCursor(bindVariableService);){
                        printer.print(cursor, factory.getMetadata(), true);
                    }
                    TestUtils.assertEquals(expectedData, (CharSequence)sink);
                }
                Assert.assertEquals((long)0L, (long)engine.getBusyReaderCount());
                Assert.assertEquals((long)0L, (long)engine.getBusyWriterCount());
            }
            finally {
                engine.releaseAllWriters();
                engine.releaseAllReaders();
            }
        });
    }

    private static /* synthetic */ void lambda$testCreateTableFail$1(CairoConfiguration configuration) throws Exception {
        try (Engine engine = new Engine(configuration);
             SqlCompiler compiler = new SqlCompiler((CairoEngine)engine, configuration);){
            try {
                compiler.compile((CharSequence)"create table x as (select to_int(x) c, abs(rnd_int() % 650) a from long_sequence(5000000))", bindVariableService);
                Assert.fail();
            }
            catch (SqlException e) {
                TestUtils.assertContains(e.getMessage(), "Could not create table. See log for details");
            }
            Assert.assertEquals((long)0L, (long)engine.getBusyReaderCount());
            Assert.assertEquals((long)0L, (long)engine.getBusyWriterCount());
        }
    }

    private static interface Fiddler {
        public boolean isHappy();

        public void run(CairoEngine var1);
    }
}

