/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin;

import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.DefaultCairoConfiguration;
import com.questdb.cairo.GenericRecordMetadata;
import com.questdb.cairo.TableColumnMetadata;
import com.questdb.cairo.TestRecord;
import com.questdb.cairo.sql.Function;
import com.questdb.cairo.sql.Record;
import com.questdb.griffin.BaseFunctionFactoryTest;
import com.questdb.griffin.FunctionFactory;
import com.questdb.griffin.FunctionParser;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.functions.BinFunction;
import com.questdb.griffin.engine.functions.BooleanFunction;
import com.questdb.griffin.engine.functions.ByteFunction;
import com.questdb.griffin.engine.functions.DateFunction;
import com.questdb.griffin.engine.functions.DoubleFunction;
import com.questdb.griffin.engine.functions.FloatFunction;
import com.questdb.griffin.engine.functions.IntFunction;
import com.questdb.griffin.engine.functions.LongFunction;
import com.questdb.griffin.engine.functions.ShortFunction;
import com.questdb.griffin.engine.functions.StrFunction;
import com.questdb.griffin.engine.functions.SymbolFunction;
import com.questdb.griffin.engine.functions.TimestampFunction;
import com.questdb.griffin.engine.functions.bool.InFunctionFactory;
import com.questdb.griffin.engine.functions.bool.NotFunctionFactory;
import com.questdb.griffin.engine.functions.bool.OrFunctionFactory;
import com.questdb.griffin.engine.functions.constants.BooleanConstant;
import com.questdb.griffin.engine.functions.constants.ByteConstant;
import com.questdb.griffin.engine.functions.constants.DateConstant;
import com.questdb.griffin.engine.functions.constants.DoubleConstant;
import com.questdb.griffin.engine.functions.constants.FloatConstant;
import com.questdb.griffin.engine.functions.constants.IntConstant;
import com.questdb.griffin.engine.functions.constants.LongConstant;
import com.questdb.griffin.engine.functions.constants.NullConstant;
import com.questdb.griffin.engine.functions.constants.ShortConstant;
import com.questdb.griffin.engine.functions.constants.StrConstant;
import com.questdb.griffin.engine.functions.constants.TimestampConstant;
import com.questdb.griffin.engine.functions.date.SysdateFunctionFactory;
import com.questdb.griffin.engine.functions.math.AddDoubleFunctionFactory;
import com.questdb.griffin.engine.functions.math.AddFloatFunctionFactory;
import com.questdb.griffin.engine.functions.math.AddIntFunctionFactory;
import com.questdb.griffin.engine.functions.math.AddLongFunctionFactory;
import com.questdb.griffin.engine.functions.math.AddShortFunctionFactory;
import com.questdb.griffin.engine.functions.math.SubIntFunctionFactory;
import com.questdb.griffin.engine.functions.str.LengthStrFunctionFactory;
import com.questdb.griffin.engine.functions.str.LengthSymbolFunctionFactory;
import com.questdb.griffin.engine.functions.str.ToCharBinFunctionFactory;
import com.questdb.griffin.engine.functions.str.ToCharDateFunctionFactory;
import com.questdb.griffin.engine.functions.str.ToCharTimestampFunctionFactory;
import com.questdb.std.BinarySequence;
import com.questdb.std.NumericException;
import com.questdb.std.ObjList;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.std.time.MillisecondClock;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class FunctionParserTest
extends BaseFunctionFactoryTest {
    @Test
    public void testAmbiguousFunctionInvocation() {
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return "+(DD)";
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
                return null;
            }
        });
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return "+(FF)";
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
                return null;
            }
        });
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("a", 1));
        metadata.add(new TableColumnMetadata("c", 2));
        this.assertFail(2, "ambiguous function call: +(BYTE,SHORT)", "a + c", metadata);
    }

    @Test
    public void testBooleanConstants() throws SqlException {
        functions.add(new NotFunctionFactory());
        functions.add(new OrFunctionFactory());
        Record record = new Record(){

            public boolean getBool(int col) {
                return false;
            }
        };
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("a", 0));
        FunctionParser functionParser = this.createFunctionParser();
        Function function = FunctionParserTest.parseFunction("a or not false", metadata, functionParser);
        Assert.assertEquals((long)0L, (long)function.getType());
        Assert.assertTrue((boolean)function.getBool(record));
        Function function2 = FunctionParserTest.parseFunction("a or true", metadata, functionParser);
        Assert.assertTrue((boolean)function2.getBool(record));
    }

    @Test
    public void testBooleanFunctions() throws SqlException {
        functions.add(new NotFunctionFactory());
        functions.add(new OrFunctionFactory());
        Record record = new Record(){

            public boolean getBool(int col) {
                return col != 0;
            }
        };
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("a", 0));
        metadata.add(new TableColumnMetadata("b", 0));
        FunctionParser functionParser = this.createFunctionParser();
        Function function = FunctionParserTest.parseFunction("a or not b", metadata, functionParser);
        Assert.assertEquals((long)0L, (long)function.getType());
        Assert.assertFalse((boolean)function.getBool(record));
    }

    @Test
    public void testByteAndLongToFloatCast() throws SqlException {
        this.assertCastToFloat(363.0f, 1, 4, new Record(){

            public byte getByte(int col) {
                return 18;
            }

            public long getLong(int col) {
                return 345L;
            }
        });
    }

    @Test
    public void testByteAndShortToIntCast() throws SqlException {
        functions.add(new AddIntFunctionFactory());
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("a", 1));
        metadata.add(new TableColumnMetadata("b", 2));
        FunctionParser functionParser = this.createFunctionParser();
        Function function = FunctionParserTest.parseFunction("a+b", metadata, functionParser);
        Assert.assertEquals((long)3L, (long)function.getType());
        Assert.assertEquals((long)33L, (long)function.getInt(new Record(){

            public byte getByte(int col) {
                return 12;
            }

            public short getShort(int col) {
                return 21;
            }
        }));
    }

    @Test
    public void testByteToDoubleCast() throws SqlException {
        this.assertCastToDouble(131.0, 1, 1, new Record(){

            public byte getByte(int col) {
                if (col == 0) {
                    return 41;
                }
                return 90;
            }
        });
    }

    @Test
    public void testByteToLongCast() throws SqlException {
        this.assertCastToLong(131L, 1, 1, new Record(){

            public byte getByte(int col) {
                if (col == 0) {
                    return 41;
                }
                return 90;
            }
        });
    }

    @Test
    public void testByteToShortCast() throws SqlException {
        functions.add(new AddShortFunctionFactory());
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("a", 1));
        metadata.add(new TableColumnMetadata("b", 1));
        FunctionParser functionParser = this.createFunctionParser();
        Function function = FunctionParserTest.parseFunction("a+b", metadata, functionParser);
        Assert.assertEquals((long)2L, (long)function.getType());
        Assert.assertEquals((long)131L, (long)function.getShort(new Record(){

            public byte getByte(int col) {
                if (col == 0) {
                    return 41;
                }
                return 90;
            }
        }));
    }

    @Test
    public void testConstVarArgFunction() throws SqlException {
        functions.add(new InFunctionFactory());
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("a", 7));
        FunctionParser functionParser = this.createFunctionParser();
        Function function = FunctionParserTest.parseFunction("a in ('x', 'y')", metadata, functionParser);
        Assert.assertEquals((long)0L, (long)function.getType());
        Assert.assertTrue((boolean)function.getBool(new Record(){

            public CharSequence getStr(int col) {
                return "y";
            }
        }));
    }

    @Test
    public void testExplicitConstantBoolean() throws SqlException {
        this.testConstantPassThru((Function)new BooleanConstant(0, true));
    }

    @Test
    public void testExplicitConstantByte() throws SqlException {
        this.testConstantPassThru((Function)new ByteConstant(0, -56));
    }

    @Test
    public void testExplicitConstantDate() throws SqlException {
        this.testConstantPassThru((Function)new DateConstant(0, 123L));
    }

    @Test
    public void testExplicitConstantDouble() throws SqlException {
        this.testConstantPassThru((Function)new DoubleConstant(0, 200.0));
    }

    @Test
    public void testExplicitConstantFloat() throws SqlException {
        this.testConstantPassThru((Function)new FloatConstant(0, 200.0f));
    }

    @Test
    public void testExplicitConstantInt() throws SqlException {
        this.testConstantPassThru((Function)new IntConstant(0, 200));
    }

    @Test
    public void testExplicitConstantLong() throws SqlException {
        this.testConstantPassThru((Function)new LongConstant(0, 200L));
    }

    @Test
    public void testExplicitConstantNull() throws SqlException {
        this.testConstantPassThru((Function)new NullConstant(0));
    }

    @Test
    public void testExplicitConstantShort() throws SqlException {
        this.testConstantPassThru((Function)new ShortConstant(0, 200));
    }

    @Test
    public void testExplicitConstantStr() throws SqlException {
        this.testConstantPassThru((Function)new StrConstant(0, (CharSequence)"abc"));
    }

    @Test
    public void testExplicitConstantTimestamp() throws SqlException {
        this.testConstantPassThru((Function)new TimestampConstant(0, 123L));
    }

    @Test
    public void testFloatAndLongToDoubleCast() throws SqlException {
        this.assertCastToDouble(468.3, 5, 4, new Record(){

            public float getFloat(int col) {
                return 123.3f;
            }

            public long getLong(int col) {
                return 345L;
            }
        });
    }

    @Test
    public void testFunctionDoesNotExist() {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("a", 0));
        metadata.add(new TableColumnMetadata("c", 8));
        this.assertFail(5, "unknown function name: xyz(BOOLEAN,SYMBOL)", "a or xyz(a,c)", metadata);
    }

    @Test
    public void testFunctionFactoryException() {
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return "x()";
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
                throw new RuntimeException("oops");
            }
        });
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        this.assertFail(0, "exception in function factory", "x()", metadata);
    }

    @Test
    public void testFunctionFactoryNullFunction() {
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return "x()";
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
                return null;
            }
        });
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        this.assertFail(0, "bad function factory (NULL), check log", "x()", metadata);
    }

    @Test
    public void testFunctionFactoryNullSignature() {
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return null;
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
                return new IntConstant(position, 0);
            }
        });
        FunctionParser parser = this.createFunctionParser();
        Assert.assertEquals((long)0L, (long)parser.getFunctionCount());
    }

    @Test
    public void testFunctionOverload() throws SqlException {
        functions.add(new ToCharDateFunctionFactory());
        functions.add(new ToCharTimestampFunctionFactory());
        functions.add(new ToCharBinFunctionFactory());
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("a", 10));
        metadata.add(new TableColumnMetadata("b", 12));
        metadata.add(new TableColumnMetadata("c", 9));
        FunctionParser functionParser = this.createFunctionParser();
        TestRecord record = new TestRecord();
        Function function = FunctionParserTest.parseFunction("to_char(a, 'EE, dd-MMM-yyyy hh:mm:ss')", metadata, functionParser);
        Assert.assertEquals((long)7L, (long)function.getType());
        TestUtils.assertEquals((CharSequence)"Thursday, 03-Apr-150577 03:54:03", function.getStr((Record)record));
        Function function2 = FunctionParserTest.parseFunction("to_char(b, 'EE, dd-MMM-yyyy hh:mm:ss')", metadata, functionParser);
        Assert.assertEquals((long)7L, (long)function2.getType());
        TestUtils.assertEquals((CharSequence)"Tuesday, 21-Nov-2119 08:50:58", function2.getStr((Record)record));
        Function function3 = FunctionParserTest.parseFunction("to_char(c)", metadata, functionParser);
        String expectedBin = "00000000 1d 15 55 8a 17 fa d8 cc 14 ce f1 59 88 c4 91 3b\n00000010 72 db f3 04 1b c7 88 de a0 79 3c 77 15 68 61 26\n00000020 af 19 c4 95 94 36 53 49 b4 59 7e 3b 08 a1 1e 38\n00000030 8d 1b 9e f4 c8 39 09 fe d8 9d 30 78 36 6a 32 de\n00000040 e4 7c d2 35 07 42 fc 31 79 5f 8b 81 2b 93 4d 1a\n00000050 8e 78 b5 b9 11 53 d0 fb 64 bb 1a d4 f0 2d 40 e2\n00000060 4b b1 3e e3 f1 f1 1e ca 9c 1d 06 ac 37 c8 cd 82\n00000070 89 2b 4d 5f f6 46 90 c3 b3 59 8e e5 61 2f 64 0e\n00000080 2c 7f d7 6f b8 c9 ae 28 c7 84 47 dc d2 85 7f a5\n00000090 b8 7b 4a 9d 46 7c 8d dd 93 e6 d0 b3 2b 07 98 cc\n000000a0 76 48 a3 bb 64 d2 ad 49 1c f2 3c ed 39 ac a8 3b\n000000b0 a6 dc 3b 7d 2b e3 92 fe 69 38 e1 77 9a e7 0c 89\n000000c0 14 58 63 b7 c2 9f 29 8e 29 5e 69 c6 eb ea c3 c9\n000000d0 73 93 46 fe c2 d3 68 79 8b 43 1d 57 34 04 23 8d\n000000e0 d8 57 91 88 28 a5 18 93 bd 0b 61 f5 5d d0 eb 67\n000000f0 44 a7 6a 71 34 e0 b0 e9 98 f7 67 62 28 60 b0 ec\n00000100 0b 92 58 7d 24 bc 2e 60 6a 1c 0b 20 a2 86 89 37\n00000110 11 2c 14 0c 2d 20 84 52 d9 6f 04 ab 27 47 8f 23\n00000120 3f ae 7c 9f 77 04 e9 0c ea 4e ea 8b f5 0f 2d b3\n00000130 14 33 80 c9 eb a3 67 7a 1a 79 e4 35 e4 3a dc 5c\n00000140 65 ff 27 67 77 12 54 52 d0 29 26 c5 aa da 18 ce\n00000150 5f b2 8b 5c 54 90 25 c2 20 ff 70 3a c7 8a b3 14\n00000160 cd 47 0b 0c 39 12 f7 05 10 f4 6d f1 e3 ee 58 35\n00000170 61 52 8b 0b 93 e5 57 a5 db a1 76 1c 1c 26 fb 2e\n00000180 42 fa f5 6e 8f 80 e3 54 b8 07 b1 32 57 ff 9a ef\n00000190 88 cb 4b a1 cf cf 41 7d a6 d1 3e b4 48 d4 41 9d\n000001a0 fb 49 40 44 49 96 cf 2b b3 71 a7 d5 af 11 96 37\n000001b0 08 dd 98 ef 54 88 2a a2 ad e7 d4 62 e1 4e d6 b2\n000001c0 57 5b e3 71 3d 20 e2 37 f2 64 43 84 55 a0 dd 44\n000001d0 11 e2 a3 24 4e 44 a8 0d fe 27 ec 53 13 5d b2 15\n000001e0 e7 b8 35 67 9c 94 b9 8e 28 b6 a9 17 ec 0e 01 c4\n000001f0 eb 9f 13 8f bb 2a 4b af 8f 89 df 35 8f da fe 33\n00000200 98 80 85 20 53 3b 51 9d 5d 28 ac 02 2e fe 05 3b\n00000210 94 5f ec d3 dc f8 43 b2 e3 75 62 60 af 6d 8c d8\n00000220 ac c8 46 3b 47 3c e1 72 3b 9d ef c4 4a c9 cf fb\n00000230 9d 63 ca 94 00 6b dd 18 fe 71 76 bc 45 24 cd 13\n00000240 00 7c fb 01 19 ca f2 bf 84 5a 6f 38 35 15 29 83\n00000250 1f c3 2f ed b0 ba 08 e0 2c ee 41 de b6 81 df b7\n00000260 6c 4b fb 2d 16 f3 89 a3 83 64 de d6 fd c4 5b c4\n00000270 e9 19 47 8d ad 11 bc fe b9 52 dd 4d f3 f9 76 f6\n00000280 85 ab a3 ab ee 6d 54 75 10 b3 4c 0e 8f f1 0c c5\n00000290 60 b7 d1 5a 0c e9 db 51 13 4d 59 20 c9 37 a1 00\n000002a0 f8 42 23 37 03 a1 8c 47 64 59 1a d4 ab be 30 fa\n000002b0 8d ac 3d 98 a0 ad 9a 5d df dc 72 d7 97 cb f6 2c\n000002c0 23 45 a3 76 60 15 c1 8c d9 11 69 94 3f 7d ef 3b\n000002d0 b8 be f8 a1 46 87 28 92 a3 9b e3 cb c2 64 8a b0\n000002e0 35 d8 ab 3f a1 f5 4b ea 01 c9 63 b4 fc 92 60 1f\n000002f0 df 41 ec 2c 38 88 88 e7 59 40 10 20 81 c6 3d bc\n00000300 b5 05 2b 73 51 cf c3 7e c0 1d 6c a9 65 81 ad 79\n00000310 87 fc 92 83 fc 88 f3 32 27 70 c8 01 b0 dc c9 3a\n00000320 5b 7e 0e 98 0a 8a 0b 1e c4 fd a2 9e b3 77 f8 f6\n00000330 78 09 1c 5d 88 f5 52 fd 36 02 50 d9 a0 b5 90 6c\n00000340 9c 23 22 89 99 ad f7 fe 9a 9e 1b fd a9 d7 0e 39\n00000350 5a 28 ed 97 99 d8 77 33 3f b2 67 da 98 47 47 bf\n00000360 4f ea 5f 48 ed f6 bb 28 a2 3c d0 65 5e b7 95 2e\n00000370 4a af c6 d0 19 6a de 46 04 d3 81 e7 a2 16 22 35\n00000380 3b 1c 9c 1d 5c c1 5d 2d 44 ea 00 81 c4 19 a1 ec\n00000390 74 f8 10 fc 6e 23 3d e0 2d 04 86 e7 ca 29 98 07\n000003a0 69 ca 5b d6 cf 09 69 01 b1 55 38 ad b2 4a 4e 7d\n000003b0 85 f9 39 25 42 67 78 47 b3 80 69 b9 14 d6 fc ee\n000003c0 03 22 81 b8 06 c4 06 af 38 71 1f e1 e4 91 7d e9\n000003d0 5d 4b 6a cd 4e f9 17 9e cf 6a 34 2c 37 a3 6f 2a\n000003e0 12 61 3a 9a ad 98 2e 75 52 ad 62 87 88 45 b9 9d\n000003f0 20 13 51 c0 e0 b7 a4 24 40 4d 50 b1 8c 4d 66 e8";
        TestUtils.assertEquals((CharSequence)expectedBin, function3.getStr((Record)record));
    }

    @Test
    public void testImplicitConstantBin() throws SqlException {
        final BinFunction function = new BinFunction(0){

            public void close() {
            }

            public BinarySequence getBin(Record rec) {
                return null;
            }

            public boolean isConstant() {
                return true;
            }

            public long getBinLen(Record rec) {
                return -1L;
            }
        };
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return "x()";
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration1) {
                return function;
            }
        });
        Assert.assertSame((Object)function, (Object)FunctionParserTest.parseFunction("x()", new GenericRecordMetadata(), this.createFunctionParser()));
        Assert.assertTrue((boolean)function.isConstant());
    }

    @Test
    public void testImplicitConstantBoolean() throws SqlException {
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return "x()";
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration1) {
                return new BooleanFunction(position){

                    public boolean getBool(Record rec) {
                        return false;
                    }

                    public boolean isConstant() {
                        return true;
                    }

                    public void close() {
                    }
                };
            }
        });
        Function function = FunctionParserTest.parseFunction("x()", new GenericRecordMetadata(), this.createFunctionParser());
        Assert.assertTrue((boolean)(function instanceof BooleanConstant));
    }

    @Test
    public void testImplicitConstantByte() throws SqlException {
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return "x()";
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration1) {
                return new ByteFunction(position){

                    public byte getByte(Record rec) {
                        return 0;
                    }

                    public boolean isConstant() {
                        return true;
                    }
                };
            }
        });
        Function function = FunctionParserTest.parseFunction("x()", new GenericRecordMetadata(), this.createFunctionParser());
        Assert.assertTrue((boolean)(function instanceof ByteConstant));
    }

    @Test
    public void testImplicitConstantDate() throws SqlException {
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return "x()";
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration1) {
                return new DateFunction(position){

                    public long getDate(Record rec) {
                        return 0L;
                    }

                    public boolean isConstant() {
                        return true;
                    }
                };
            }
        });
        Function function = FunctionParserTest.parseFunction("x()", new GenericRecordMetadata(), this.createFunctionParser());
        Assert.assertTrue((boolean)(function instanceof DateConstant));
    }

    @Test
    public void testImplicitConstantDouble() throws SqlException {
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return "x()";
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration1) {
                return new DoubleFunction(position){

                    public double getDouble(Record rec) {
                        return 0.0;
                    }

                    public boolean isConstant() {
                        return true;
                    }
                };
            }
        });
        Function function = FunctionParserTest.parseFunction("x()", new GenericRecordMetadata(), this.createFunctionParser());
        Assert.assertTrue((boolean)(function instanceof DoubleConstant));
    }

    @Test
    public void testImplicitConstantFloat() throws SqlException {
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return "x()";
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration1) {
                return new FloatFunction(position){

                    public float getFloat(Record rec) {
                        return 0.0f;
                    }

                    public boolean isConstant() {
                        return true;
                    }
                };
            }
        });
        Function function = FunctionParserTest.parseFunction("x()", new GenericRecordMetadata(), this.createFunctionParser());
        Assert.assertTrue((boolean)(function instanceof FloatConstant));
    }

    @Test
    public void testImplicitConstantInt() throws SqlException {
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return "x()";
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration1) {
                return new IntFunction(position){

                    public int getInt(Record rec) {
                        return 0;
                    }

                    public boolean isConstant() {
                        return true;
                    }
                };
            }
        });
        Function function = FunctionParserTest.parseFunction("x()", new GenericRecordMetadata(), this.createFunctionParser());
        Assert.assertTrue((boolean)(function instanceof IntConstant));
    }

    @Test
    public void testImplicitConstantLong() throws SqlException {
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return "x()";
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration1) {
                return new LongFunction(position){

                    public long getLong(Record rec) {
                        return 0L;
                    }

                    public boolean isConstant() {
                        return true;
                    }
                };
            }
        });
        Function function = FunctionParserTest.parseFunction("x()", new GenericRecordMetadata(), this.createFunctionParser());
        Assert.assertTrue((boolean)(function instanceof LongConstant));
    }

    @Test
    public void testImplicitConstantNull() throws SqlException {
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return "x()";
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration1) {
                return new StrFunction(position){

                    public CharSequence getStr(Record rec) {
                        return null;
                    }

                    public CharSequence getStrB(Record rec) {
                        return null;
                    }

                    public boolean isConstant() {
                        return true;
                    }
                };
            }
        });
        Function function = FunctionParserTest.parseFunction("x()", new GenericRecordMetadata(), this.createFunctionParser());
        Assert.assertTrue((boolean)(function instanceof NullConstant));
    }

    @Test
    public void testImplicitConstantNullSymbol() throws SqlException {
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return "x()";
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration1) {
                return new SymbolFunction(position){

                    public CharSequence getSymbol(Record rec) {
                        return null;
                    }

                    public boolean isConstant() {
                        return true;
                    }
                };
            }
        });
        Function function = FunctionParserTest.parseFunction("x()", new GenericRecordMetadata(), this.createFunctionParser());
        Assert.assertTrue((boolean)(function instanceof NullConstant));
    }

    @Test
    public void testImplicitConstantShort() throws SqlException {
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return "x()";
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration1) {
                return new ShortFunction(position){

                    public short getShort(Record rec) {
                        return 0;
                    }

                    public boolean isConstant() {
                        return true;
                    }
                };
            }
        });
        Function function = FunctionParserTest.parseFunction("x()", new GenericRecordMetadata(), this.createFunctionParser());
        Assert.assertTrue((boolean)(function instanceof ShortConstant));
    }

    @Test
    public void testImplicitConstantStr() throws SqlException {
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return "x()";
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration1) {
                return new StrFunction(position){
                    private final String x = "abc";
                    {
                        this.x = "abc";
                    }

                    public CharSequence getStr(Record rec) {
                        return "abc";
                    }

                    public CharSequence getStrB(Record rec) {
                        return "abc";
                    }

                    public boolean isConstant() {
                        return true;
                    }
                };
            }
        });
        Function function = FunctionParserTest.parseFunction("x()", new GenericRecordMetadata(), this.createFunctionParser());
        Assert.assertTrue((boolean)(function instanceof StrConstant));
    }

    @Test
    public void testImplicitConstantSymbol() throws SqlException {
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return "x()";
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration1) {
                return new SymbolFunction(position){

                    public CharSequence getSymbol(Record rec) {
                        return "xyz";
                    }

                    public boolean isConstant() {
                        return true;
                    }
                };
            }
        });
        Function function = FunctionParserTest.parseFunction("x()", new GenericRecordMetadata(), this.createFunctionParser());
        Assert.assertTrue((boolean)(function instanceof StrConstant));
    }

    @Test
    public void testImplicitConstantTimestamp() throws SqlException {
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return "x()";
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration1) {
                return new TimestampFunction(position){

                    public long getTimestamp(Record rec) {
                        return 0L;
                    }

                    public boolean isConstant() {
                        return true;
                    }
                };
            }
        });
        Function function = FunctionParserTest.parseFunction("x()", new GenericRecordMetadata(), this.createFunctionParser());
        Assert.assertTrue((boolean)(function instanceof TimestampConstant));
    }

    @Test
    public void testIntAndShortToDoubleCast() throws SqlException {
        this.assertCastToDouble(33.0, 3, 2, new Record(){

            public int getInt(int col) {
                return 12;
            }

            public short getShort(int col) {
                return 21;
            }
        });
    }

    @Test
    public void testIntAndShortToFloatCast() throws SqlException {
        this.assertCastToFloat(33.0f, 3, 2, new Record(){

            public int getInt(int col) {
                return 12;
            }

            public short getShort(int col) {
                return 21;
            }
        });
    }

    @Test
    public void testIntAndShortToLongCast() throws SqlException {
        this.assertCastToLong(33L, 3, 2, new Record(){

            public int getInt(int col) {
                return 12;
            }

            public short getShort(int col) {
                return 21;
            }
        });
    }

    @Test
    public void testInvalidColumn() {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("a", 2));
        metadata.add(new TableColumnMetadata("c", 2));
        this.assertFail(4, "Invalid column: d", "a + d", metadata);
    }

    @Test
    public void testInvalidConstant() {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("a", 0));
        metadata.add(new TableColumnMetadata("c", 8));
        this.assertFail(4, "invalid constant: 1c", "a + 1c", metadata);
    }

    @Test
    public void testNoArgFunction() throws SqlException {
        functions.add(new SysdateFunctionFactory());
        functions.add(new ToCharDateFunctionFactory());
        FunctionParser functionParser = new FunctionParser((CairoConfiguration)new DefaultCairoConfiguration(root){

            public MillisecondClock getMillisecondClock() {
                return () -> {
                    try {
                        return DateFormatUtils.parseDateTime((CharSequence)"2018-03-04T21:40:00.000Z");
                    }
                    catch (NumericException e) {
                        Assert.fail();
                        return 0L;
                    }
                };
            }
        }, (Iterable)functions);
        Function function = FunctionParserTest.parseFunction("to_char(sysdate(), 'EE, dd-MMM-yyyy HH:mm:ss')", new GenericRecordMetadata(), functionParser);
        TestUtils.assertEquals((CharSequence)"Sunday, 04-Mar-2018 21:40:00", function.getStr(null));
    }

    @Test
    public void testNoArgFunctionDoesNotExist() {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("a", 0));
        this.assertFail(5, "unknown function name", "a or xyz()", metadata);
    }

    @Test
    public void testNoArgFunctionWrongSignature() {
        functions.add(new SysdateFunctionFactory());
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("a", 0));
        this.assertFail(7, "no signature match", "a or   sysdate(a)", metadata);
    }

    @Test
    public void testPassColumnToConstVarArgFunction() {
        functions.add(new InFunctionFactory());
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("a", 7));
        metadata.add(new TableColumnMetadata("b", 7));
        this.assertFail(6, "constant expected", "a in (b, 'y')", metadata);
    }

    @Test
    public void testPassNaNAsShort() {
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return "x(E)";
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
                return null;
            }
        });
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        try {
            FunctionParserTest.parseFunction("x(NaN)", metadata, this.createFunctionParser());
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)0L, (long)e.getPosition());
            TestUtils.assertContains(e.getMessage(), "no signature match");
        }
    }

    @Test
    public void testPassVarToConstArg() {
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return "x(i)";
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
                return null;
            }
        });
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("a", 3));
        try {
            FunctionParserTest.parseFunction("x(a)", metadata, this.createFunctionParser());
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)0L, (long)e.getPosition());
            TestUtils.assertContains(e.getMessage(), "no signature match");
        }
    }

    @Test
    public void testSignatureBeginsWithDigit() throws SqlException {
        this.assertSignatureFailure("1x()");
    }

    @Test
    public void testSignatureEmptyFunctionName() throws SqlException {
        this.assertSignatureFailure("(B)");
    }

    @Test
    public void testSignatureIllegalArgumentType() throws SqlException {
        this.assertSignatureFailure("x(Bz)");
    }

    @Test
    public void testSignatureIllegalCharacter() throws SqlException {
        this.assertSignatureFailure("x'x()");
    }

    @Test
    public void testSignatureIllegalName1() throws SqlException {
        this.assertSignatureFailure("/*()");
    }

    @Test
    public void testSignatureIllegalName2() throws SqlException {
        this.assertSignatureFailure("--()");
    }

    @Test
    public void testSignatureMissingCloseBrace() throws SqlException {
        this.assertSignatureFailure("a(");
    }

    @Test
    public void testSignatureMissingOpenBrace() throws SqlException {
        this.assertSignatureFailure("x");
    }

    @Test
    public void testSimpleFunction() throws SqlException {
        this.assertCastToDouble(13.1, 6, 6, new Record(){

            public double getDouble(int col) {
                if (col == 0) {
                    return 5.3;
                }
                return 7.8;
            }
        });
    }

    @Test
    public void testSymbolFunction() throws SqlException {
        functions.add(new LengthStrFunctionFactory());
        functions.add(new LengthSymbolFunctionFactory());
        functions.add(new SubIntFunctionFactory());
        FunctionParser functionParser = this.createFunctionParser();
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("a", 7));
        metadata.add(new TableColumnMetadata("b", 8));
        Function function = FunctionParserTest.parseFunction("length(b) - length(a)", metadata, functionParser);
        Record record = new Record(){

            public CharSequence getStr(int col) {
                return "ABC";
            }

            public int getStrLen(int col) {
                return this.getStr(col).length();
            }

            public CharSequence getSym(int col) {
                return "EFGHT";
            }
        };
        Assert.assertEquals((long)2L, (long)function.getInt(record));
        Function function1 = FunctionParserTest.parseFunction("length(null)", metadata, functionParser);
        Assert.assertEquals((long)-1L, (long)function1.getInt(record));
        Function function2 = FunctionParserTest.parseFunction("length(NULL)", metadata, functionParser);
        Assert.assertEquals((long)-1L, (long)function2.getInt(record));
    }

    @Test
    public void testTooFewArguments() {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("a", 2));
        this.assertFail(2, "too few arguments [found=1,expected=2]", "a + ", metadata);
    }

    @Test
    public void testVarArgFunction() throws SqlException {
        functions.add(new InFunctionFactory());
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("a", 7));
        FunctionParser functionParser = this.createFunctionParser();
        Record record = new Record(){

            public CharSequence getStr(int col) {
                return "Y";
            }
        };
        Function function = FunctionParserTest.parseFunction("a in ('X', 'Y')", metadata, functionParser);
        Assert.assertEquals((long)0L, (long)function.getType());
        Assert.assertTrue((boolean)function.getBool(record));
    }

    @Test
    public void testVarArgFunctionNoArg() throws SqlException {
        functions.add(new InFunctionFactory());
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("a", 7));
        FunctionParser functionParser = this.createFunctionParser();
        Record record = new Record(){

            public CharSequence getStr(int col) {
                return "Y";
            }
        };
        Function function = FunctionParserTest.parseFunction("a in ()", metadata, functionParser);
        Assert.assertEquals((long)0L, (long)function.getType());
        Assert.assertFalse((boolean)function.getBool(record));
    }

    private void assertCastToDouble(double expected, int type1, int type2, Record record) throws SqlException {
        functions.add(new AddDoubleFunctionFactory());
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("a", type1));
        metadata.add(new TableColumnMetadata("b", type2));
        FunctionParser functionParser = this.createFunctionParser();
        Function function = FunctionParserTest.parseFunction("a+b", metadata, functionParser);
        Assert.assertEquals((long)6L, (long)function.getType());
        Assert.assertEquals((double)expected, (double)function.getDouble(record), (double)1.0E-5);
    }

    private void assertCastToFloat(float expected, int type1, int type2, Record record) throws SqlException {
        functions.add(new AddFloatFunctionFactory());
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("a", type1));
        metadata.add(new TableColumnMetadata("b", type2));
        FunctionParser functionParser = this.createFunctionParser();
        Function function = FunctionParserTest.parseFunction("a+b", metadata, functionParser);
        Assert.assertEquals((long)5L, (long)function.getType());
        Assert.assertEquals((double)expected, (double)function.getFloat(record), (double)1.0E-5);
    }

    private void assertCastToLong(long expected, int type1, int type2, Record record) throws SqlException {
        functions.add(new AddLongFunctionFactory());
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("a", type1));
        metadata.add(new TableColumnMetadata("b", type2));
        FunctionParser functionParser = this.createFunctionParser();
        Function function = FunctionParserTest.parseFunction("a+b", metadata, functionParser);
        Assert.assertEquals((long)4L, (long)function.getType());
        Assert.assertEquals((long)expected, (long)function.getLong(record));
    }

    private void assertFail(int expectedPos, String expectedMessage, String expression, GenericRecordMetadata metadata) {
        FunctionParser functionParser = this.createFunctionParser();
        try {
            FunctionParserTest.parseFunction(expression, metadata, functionParser);
            Assert.fail();
        }
        catch (SqlException e) {
            Assert.assertEquals((long)expectedPos, (long)e.getPosition());
            TestUtils.assertContains(e.getMessage(), expectedMessage);
        }
    }

    private void assertSignatureFailure(final String signature) throws SqlException {
        functions.add(new OrFunctionFactory());
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return signature;
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
                return null;
            }
        });
        functions.add(new NotFunctionFactory());
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("a", 0));
        metadata.add(new TableColumnMetadata("b", 0));
        FunctionParser functionParser = this.createFunctionParser();
        Assert.assertNotNull((Object)FunctionParserTest.parseFunction("a or not b", metadata, functionParser));
        Assert.assertEquals((long)2L, (long)functionParser.getFunctionCount());
    }

    private void testConstantPassThru(final Function constant) throws SqlException {
        functions.add(new FunctionFactory(){

            public String getSignature() {
                return "x()";
            }

            public Function newInstance(ObjList<Function> args, int position, CairoConfiguration configuration) {
                return constant;
            }
        });
        Assert.assertSame((Object)constant, (Object)FunctionParserTest.parseFunction("x()", new GenericRecordMetadata(), this.createFunctionParser()));
    }
}

