/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.Engine;
import com.questdb.cairo.sql.CairoEngine;
import com.questdb.griffin.ExpressionParserListener;
import com.questdb.griffin.RpnBuilder;
import com.questdb.griffin.SqlCompiler;
import com.questdb.griffin.SqlException;
import com.questdb.std.Chars;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class ExpressionParserTest
extends AbstractCairoTest {
    private static final SqlCompiler compiler = new SqlCompiler((CairoEngine)new Engine(configuration), configuration);
    private static final RpnBuilder rpnBuilder = new RpnBuilder();

    @Test
    public void testBinaryMinus() throws Exception {
        this.x("4c-", "4-c");
    }

    @Test
    public void testCaseInArithmetic() throws SqlException {
        this.x("w11+10='th1'w23*1>'th2'0case5*1+", "case when w1+1=10 then 'th1' when w2*3>1 then 'th2' else 0 end * 5 + 1");
    }

    @Test
    public void testCaseInFunction() throws SqlException {
        this.x("xyab+10>'a'ab-3<'b'0case10+zf*", "x*f(y,case when (a+b) > 10 then 'a' when (a-b)<3 then 'b' else 0 end + 10,z)");
    }

    @Test
    public void testCaseMisplacedElse() {
        this.assertFail("case when x else y end", 12, "'then' expected");
    }

    @Test
    public void testCaseMissingElseArg() {
        this.assertFail("case when a > b then 1 else end", 28, "missing arguments");
    }

    @Test
    public void testCaseMissingThen() {
        this.assertFail("case when x when y end", 12, "'then' expected");
    }

    @Test
    public void testCaseMissingThenArg() {
        this.assertFail("case when a > b then else 2 end", 21, "missing arguments");
    }

    @Test
    public void testCaseMissingWhen() {
        this.assertFail("case then x end", 5, "'when' expected");
    }

    @Test
    public void testCaseMissingWhenArg() {
        this.assertFail("case when then 1 else 2 end", 10, "missing arguments");
    }

    @Test
    public void testCaseNested() throws SqlException {
        this.x("x0>y1='a''b'casex0<'c'case", "case when x > 0 then case when y = 1 then 'a' else 'b' end when x < 0 then 'c' end");
    }

    @Test
    public void testCaseUnbalanced() {
        this.assertFail("case when x then y", 0, "unbalanced 'case'");
    }

    @Test
    public void testCaseWhenOutsideOfCase() throws SqlException {
        this.x("when1+10>", "when + 1 > 10");
    }

    @Test
    public void testCaseWithArithmetic() throws SqlException {
        this.x("w11+10='th1'w23*1>'th2'0case", "case when w1+1=10 then 'th1' when w2*3>1 then 'th2' else 0 end");
    }

    @Test
    public void testCaseWithBraces() throws SqlException {
        this.x("10w11+5*10='th1'1-w23*1>'th2'0case1+*", "10*(case when (w1+1)*5=10 then 'th1'-1 when w2*3>1 then 'th2' else 0 end + 1)");
    }

    @Test
    public void testCaseWithOuterBraces() throws SqlException {
        this.x("10w11+10='th1'w23*1>'th2'0case1+*", "10*(case when w1+1=10 then 'th1' when w2*3>1 then 'th2' else 0 end + 1)");
    }

    @Test
    public void testCommaExit() throws Exception {
        this.x("abxybzc*+", "a + b * c(b(x,y),z),");
    }

    @Test
    public void testComplexUnary1() throws Exception {
        this.x("4xyc-^", "4^-c(x,y)");
    }

    @Test
    public void testComplexUnary2() throws Exception {
        this.x("ab^-", "-a^b");
    }

    @Test
    public void testEqualPrecedence() throws Exception {
        this.x("abc^^", "a^b^c");
    }

    @Test
    public void testExprCompiler() throws Exception {
        this.x("ac098dzf+1234x+", "a+f(c,d(0,9,8),z)+x(1,2,3,4)");
    }

    @Test
    public void testIn() throws Exception {
        this.x("abcin", "a in (b,c)");
    }

    @Test
    public void testInOperator() throws Exception {
        this.x("a10=bxyinand", "a = 10 and b in (x,y)");
    }

    @Test
    public void testLambda() throws Exception {
        this.x("a`blah blah`inyand", "a in (`blah blah`) and y");
    }

    @Test
    public void testLiteralAndConstant() throws Exception {
        this.x("x", "x 'a b'");
    }

    @Test
    public void testLiteralExit() throws Exception {
        this.x("abxybzc*+", "a + b * c(b(x,y),z) lit");
    }

    @Test
    public void testMissingArgAtBraceError() {
        this.assertFail("x * 4 + c(x,y,)", 14, "missing arguments");
    }

    @Test
    public void testMissingArgError() {
        this.assertFail("x * 4 + c(x,,y)", 12, "missing arguments");
    }

    @Test
    public void testMissingArgError2() {
        this.assertFail("x * 4 + c(,x,y)", 10, "missing arguments");
    }

    @Test
    public void testNestedFunctions() throws Exception {
        this.x("48yfrz", "z(4, r(f(8,y)))");
    }

    @Test
    public void testNestedOperator() throws Exception {
        this.x("ac4*db+", "a + b( c * 4, d)");
    }

    @Test
    public void testNewLambda() throws SqlException {
        this.x("x(select-choose a from (tab))in", "x in (select a from tab)");
    }

    @Test
    public void testNewLambdaMultipleExpressions() throws SqlException {
        this.x("x(select-choose a from (tab))iny(select-choose * column from (X))inandk10>and", "x in (select a from tab) and y in (select * from X) and k > 10");
    }

    @Test
    public void testNewLambdaNested() throws SqlException {
        this.x("x(select-choose a, b from (T where c in (select-choose * column from (Y)) and a = b))in", "x in (select a,b from T where c in (select * from Y) and a=b)");
    }

    @Test
    public void testNewLambdaQuerySyntax() {
        this.assertFail("x in (select a,b, from T)", 23, "column name expected");
    }

    @Test
    public void testNewLambdaUnbalancedBrace() {
        this.assertFail("x in (select a,b from T", 23, "')' expected");
    }

    @Test
    public void testNoArgFunction() throws Exception {
        this.x("ab4*+", "a+b()*4");
    }

    @Test
    public void testSimple() throws Exception {
        this.x("abxyc*2/+", "a + b * c(x,y)/2");
    }

    @Test
    public void testSimpleCase() throws SqlException {
        this.x("w1th1w2th2elscase", "case when w1 then th1 when w2 then th2 else els end");
    }

    @Test
    public void testSimpleLiteralExit() throws Exception {
        this.x("a", "a lit");
    }

    @Test
    public void testUnary() throws Exception {
        this.x("4c-*", "4 * -c");
    }

    @Test
    public void testUnbalancedLeftBrace() {
        this.assertFail("a+b(5,c(x,y)", 3, "unbalanced");
    }

    @Test
    public void testUnbalancedRightBraceExit() throws Exception {
        this.x("a5xycb+", "a+b(5,c(x,y)))");
    }

    @Test
    public void testWhacky() throws Exception {
        this.x("ab^-", "a-^b");
    }

    private void assertFail(String content, int pos, String contains) {
        block2: {
            try {
                compiler.parseExpression((CharSequence)content, (ExpressionParserListener)rpnBuilder);
                Assert.fail((String)"expected exception");
            }
            catch (SqlException e) {
                Assert.assertEquals((long)pos, (long)e.getPosition());
                if (Chars.contains((CharSequence)e.getFlyweightMessage(), (CharSequence)contains)) break block2;
                Assert.fail((String)(e.getMessage() + " does not contain '" + contains + '\''));
            }
        }
    }

    private void x(CharSequence expectedRpn, String content) throws SqlException {
        rpnBuilder.reset();
        compiler.parseExpression((CharSequence)content, (ExpressionParserListener)rpnBuilder);
        TestUtils.assertEquals(expectedRpn, rpnBuilder.rpn());
    }
}

