/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin;

import com.questdb.cairo.TableReader;
import com.questdb.cairo.TableWriter;
import com.questdb.griffin.AbstractGriffinTest;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.functions.rnd.SharedRandom;
import com.questdb.std.Rnd;
import com.questdb.std.str.CharSink;
import com.questdb.test.tools.TestUtils;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AlterTableDropColumnTest
extends AbstractGriffinTest {
    @Before
    public void setUp3() {
        SharedRandom.RANDOM.set(new Rnd());
    }

    @Test
    public void testBadSyntax() throws Exception {
        this.assertFailure("alter table x drop column l m", 28, "',' expected");
    }

    @Test
    public void testBusyTable() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            CountDownLatch allHaltLatch = new CountDownLatch(1);
            try {
                this.createX();
                AtomicInteger errorCounter = new AtomicInteger();
                CyclicBarrier startBarrier = new CyclicBarrier(2);
                CountDownLatch haltLatch = new CountDownLatch(1);
                new Thread(() -> {
                    try (TableWriter ignore = engine.getWriter((CharSequence)"x");){
                        startBarrier.await();
                        Assert.assertTrue((boolean)haltLatch.await(5L, TimeUnit.SECONDS));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        errorCounter.incrementAndGet();
                    }
                    finally {
                        engine.releaseAllReaders();
                        engine.releaseAllWriters();
                        allHaltLatch.countDown();
                    }
                }).start();
                startBarrier.await();
                try {
                    compiler.compile((CharSequence)"alter table x drop column ik", bindVariableService);
                    Assert.fail();
                }
                finally {
                    haltLatch.countDown();
                }
            }
            catch (SqlException e) {
                Assert.assertEquals((long)12L, (long)e.getPosition());
                TestUtils.assertContains(e.getFlyweightMessage(), "table 'x' is busy");
            }
            engine.releaseAllReaders();
            engine.releaseAllWriters();
            allHaltLatch.await(2L, TimeUnit.SECONDS);
        });
    }

    @Test
    public void testDropExpectColumnKeyword() throws Exception {
        this.assertFailure("alter table x drop", 18, "'column' expected");
    }

    @Test
    public void testDropExpectColumnName() throws Exception {
        this.assertFailure("alter table x drop column", 25, "column name expected");
    }

    @Test
    public void testDropTwoColumns() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try {
                this.createX();
                Assert.assertNull((Object)compiler.compile((CharSequence)"alter table x drop column e, m", bindVariableService));
                String expected = "{\"columnCount\":14,\"columns\":[{\"index\":0,\"name\":\"i\",\"type\":\"INT\"},{\"index\":1,\"name\":\"sym\",\"type\":\"SYMBOL\"},{\"index\":2,\"name\":\"amt\",\"type\":\"DOUBLE\"},{\"index\":3,\"name\":\"timestamp\",\"type\":\"TIMESTAMP\"},{\"index\":4,\"name\":\"b\",\"type\":\"BOOLEAN\"},{\"index\":5,\"name\":\"c\",\"type\":\"STRING\"},{\"index\":6,\"name\":\"d\",\"type\":\"DOUBLE\"},{\"index\":7,\"name\":\"f\",\"type\":\"SHORT\"},{\"index\":8,\"name\":\"g\",\"type\":\"DATE\"},{\"index\":9,\"name\":\"ik\",\"type\":\"SYMBOL\"},{\"index\":10,\"name\":\"j\",\"type\":\"LONG\"},{\"index\":11,\"name\":\"k\",\"type\":\"TIMESTAMP\"},{\"index\":12,\"name\":\"l\",\"type\":\"BYTE\"},{\"index\":13,\"name\":\"n\",\"type\":\"STRING\"}],\"timestampIndex\":3}";
                try (TableReader reader = engine.getReader((CharSequence)"x", -1L);){
                    sink.clear();
                    reader.getMetadata().toJson((CharSink)sink);
                    TestUtils.assertEquals((CharSequence)expected, (CharSequence)sink);
                }
                Assert.assertEquals((long)0L, (long)engine.getBusyWriterCount());
                Assert.assertEquals((long)0L, (long)engine.getBusyReaderCount());
            }
            finally {
                engine.releaseAllReaders();
                engine.releaseAllWriters();
            }
        });
    }

    @Test
    public void testExpectActionKeyword() throws Exception {
        this.assertFailure("alter table x", 13, "'add' or 'drop' expected");
    }

    @Test
    public void testExpectTableKeyword() throws Exception {
        this.assertFailure("alter x", 6, "'table' expected");
    }

    @Test
    public void testExpectTableKeyword2() throws Exception {
        this.assertFailure("alter", 5, "'table' expected");
    }

    @Test
    public void testExpectTableName() throws Exception {
        this.assertFailure("alter table", 11, "table name expected");
    }

    @Test
    public void testInvalidColumn() throws Exception {
        this.assertFailure("alter table x drop column l, kk", 29, "Invalid column: kk");
    }

    @Test
    public void testTableDoesNotExist() throws Exception {
        this.assertFailure("alter table y", 12, "table 'y' does not");
    }

    private void assertFailure(String sql, int position, String message) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try {
                this.createX();
                compiler.compile((CharSequence)sql, bindVariableService);
                Assert.fail();
            }
            catch (SqlException e) {
                Assert.assertEquals((long)position, (long)e.getPosition());
                TestUtils.assertContains(e.getFlyweightMessage(), message);
            }
            engine.releaseAllReaders();
            engine.releaseAllWriters();
        });
    }

    private void createX() throws SqlException {
        compiler.compile((CharSequence)"create table x as (select to_int(x) i, rnd_symbol('msft','ibm', 'googl') sym, round(rnd_double(0)*100, 3) amt, to_timestamp('2018-01', 'yyyy-MM') + x * 720000000 timestamp, rnd_boolean() b, rnd_str('ABC', 'CDE', null, 'XYZ') c, rnd_double(2) d, rnd_float(2) e, rnd_short(10,1024) f, rnd_date(to_date('2015', 'yyyy'), to_date('2016', 'yyyy'), 2) g, rnd_symbol(4,4,4,2) ik, rnd_long() j, timestamp_sequence(to_timestamp(0), 1000000000) k, rnd_byte(2,50) l, rnd_bin(10, 20, 2) m, rnd_str(5,16,2) n from long_sequence(10)) timestamp (timestamp)", bindVariableService);
    }
}

