/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin;

import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.DefaultCairoConfiguration;
import com.questdb.cairo.Engine;
import com.questdb.cairo.SymbolMapReader;
import com.questdb.cairo.TableReader;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.sql.CairoEngine;
import com.questdb.griffin.AbstractGriffinTest;
import com.questdb.griffin.SqlCompiler;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.engine.functions.rnd.SharedRandom;
import com.questdb.std.Rnd;
import com.questdb.test.tools.TestUtils;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AlterTableAddColumnTest
extends AbstractGriffinTest {
    @Before
    public void setUp3() {
        SharedRandom.RANDOM.set(new Rnd());
    }

    @Test
    public void testAddBadSyntax() throws Exception {
        this.assertFailure("alter table x add column abc int k", 33, "',' expected");
    }

    @Test
    public void testAddBusyTable() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            CountDownLatch allHaltLatch = new CountDownLatch(1);
            try {
                this.createX();
                AtomicInteger errorCounter = new AtomicInteger();
                CyclicBarrier startBarrier = new CyclicBarrier(2);
                CountDownLatch haltLatch = new CountDownLatch(1);
                new Thread(() -> {
                    try (TableWriter ignore = engine.getWriter((CharSequence)"x");){
                        startBarrier.await();
                        Assert.assertTrue((boolean)haltLatch.await(5L, TimeUnit.SECONDS));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        errorCounter.incrementAndGet();
                    }
                    finally {
                        engine.releaseAllReaders();
                        engine.releaseAllWriters();
                        allHaltLatch.countDown();
                    }
                }).start();
                startBarrier.await();
                try {
                    compiler.compile((CharSequence)"alter table x add column xx int", bindVariableService);
                    Assert.fail();
                }
                finally {
                    haltLatch.countDown();
                }
            }
            catch (SqlException e) {
                Assert.assertEquals((long)12L, (long)e.getPosition());
                TestUtils.assertContains(e.getFlyweightMessage(), "table 'x' is busy");
            }
            engine.releaseAllReaders();
            engine.releaseAllWriters();
            allHaltLatch.await(2L, TimeUnit.SECONDS);
        });
    }

    @Test
    public void testAddDuplicateColumn() throws Exception {
        this.assertFailure("alter table x add column d int", 25, "column 'd' already exists");
    }

    @Test
    public void testAddExpectColumnKeyword() throws Exception {
        this.assertFailure("alter table x add", 17, "'column' expected");
    }

    @Test
    public void testAddExpectColumnName() throws Exception {
        this.assertFailure("alter table x add column", 24, "column name expected");
    }

    @Test
    public void testAddSymbolExpectCapacity() throws Exception {
        this.assertFailure("alter table x add column abc symbol capacity", 44, "symbol capacity expected");
    }

    @Test
    public void testAddSymbolExpectCapacityTooHigh() throws Exception {
        this.assertFailure("alter table x add column abc symbol capacity 1073741825 nocache", 45, "max symbol capacity is");
    }

    @Test
    public void testAddSymbolExpectCapacityTooHigh2() throws Exception {
        this.assertFailure("alter table x add column abc symbol capacity 1073741824", 45, "max cached symbol capacity is");
    }

    @Test
    public void testAddSymbolExpectCapacityTooLow() throws Exception {
        this.assertFailure("alter table x add column abc symbol capacity -100", 45, "min symbol capacity is");
    }

    @Test
    public void testAddSymbolCache() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try {
                this.createX();
                engine.releaseAllWriters();
                engine.releaseAllReaders();
                DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

                    public boolean getDefaultSymbolCacheFlag() {
                        return false;
                    }
                };
                try (Engine engine = new Engine((CairoConfiguration)configuration);
                     SqlCompiler compiler = new SqlCompiler((CairoEngine)engine, (CairoConfiguration)configuration);){
                    Assert.assertNull((Object)compiler.compile((CharSequence)"alter table x add column meh symbol cache", bindVariableService));
                    try (TableReader reader = engine.getReader((CharSequence)"x", -1L);){
                        SymbolMapReader smr = reader.getSymbolMapReader(16);
                        Assert.assertNotNull((Object)smr);
                        Assert.assertEquals((long)configuration.getDefaultSymbolCapacity(), (long)smr.getSymbolCapacity());
                        Assert.assertFalse((boolean)reader.getMetadata().isColumnIndexed(16));
                        Assert.assertEquals((long)configuration.getIndexValueBlockSize(), (long)reader.getMetadata().getIndexValueBlockCapacity(16));
                        Assert.assertTrue((boolean)smr.isCached());
                    }
                    Assert.assertEquals((long)0L, (long)engine.getBusyWriterCount());
                    Assert.assertEquals((long)0L, (long)engine.getBusyReaderCount());
                }
            }
            finally {
                engine.releaseAllReaders();
                engine.releaseAllWriters();
            }
        });
    }

    @Test
    public void testAddSymbolExpectCapacityTooLow2() throws Exception {
        this.assertFailure("alter table x add column abc symbol capacity 1", 45, "min symbol capacity is");
    }

    @Test
    public void testAddSymbolExpectNumericCapacity() throws Exception {
        this.assertFailure("alter table x add column abc symbol capacity 1b", 45, "numeric capacity expected");
    }

    @Test
    public void testAddSymbolInvalidIndexCapacity() throws Exception {
        this.assertFailure("alter table x add column abc symbol index capacity a0", 51, "numeric capacity expected");
    }

    @Test
    public void testAddExpectColumnType() throws Exception {
        this.assertFailure("alter table x add column abc", 28, "column type expected");
    }

    @Test
    public void testAddInvalidType() throws Exception {
        this.assertFailure("alter table x add column abc blah", 29, "invalid type");
    }

    @Test
    public void testAddSymbolCapacity() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try {
                this.createX();
                Assert.assertNull((Object)compiler.compile((CharSequence)"alter table x add column meh symbol capacity 2048", bindVariableService));
                try (TableReader reader = engine.getReader((CharSequence)"x", -1L);){
                    SymbolMapReader smr = reader.getSymbolMapReader(16);
                    Assert.assertNotNull((Object)smr);
                    Assert.assertEquals((long)2048L, (long)smr.getSymbolCapacity());
                    Assert.assertFalse((boolean)reader.getMetadata().isColumnIndexed(16));
                    Assert.assertEquals((long)configuration.getIndexValueBlockSize(), (long)reader.getMetadata().getIndexValueBlockCapacity(16));
                    Assert.assertEquals((Object)configuration.getDefaultSymbolCacheFlag(), (Object)smr.isCached());
                }
                Assert.assertEquals((long)0L, (long)engine.getBusyWriterCount());
                Assert.assertEquals((long)0L, (long)engine.getBusyReaderCount());
            }
            finally {
                engine.releaseAllReaders();
                engine.releaseAllWriters();
            }
        });
    }

    @Test
    public void testAddSymbolIndex() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try {
                this.createX();
                Assert.assertNull((Object)compiler.compile((CharSequence)"alter table x add column meh symbol index", bindVariableService));
                try (TableReader reader = engine.getReader((CharSequence)"x", -1L);){
                    SymbolMapReader smr = reader.getSymbolMapReader(16);
                    Assert.assertNotNull((Object)smr);
                    Assert.assertEquals((long)configuration.getDefaultSymbolCapacity(), (long)smr.getSymbolCapacity());
                    Assert.assertTrue((boolean)reader.getMetadata().isColumnIndexed(16));
                    Assert.assertEquals((long)configuration.getIndexValueBlockSize(), (long)reader.getMetadata().getIndexValueBlockCapacity(16));
                    Assert.assertEquals((Object)configuration.getDefaultSymbolCacheFlag(), (Object)smr.isCached());
                }
                Assert.assertEquals((long)0L, (long)engine.getBusyWriterCount());
                Assert.assertEquals((long)0L, (long)engine.getBusyReaderCount());
            }
            finally {
                engine.releaseAllReaders();
                engine.releaseAllWriters();
            }
        });
    }

    @Test
    public void testAddSymbolIndexCapacity() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try {
                this.createX();
                Assert.assertNull((Object)compiler.compile((CharSequence)"alter table x add column meh symbol index capacity 9000", bindVariableService));
                try (TableReader reader = engine.getReader((CharSequence)"x", -1L);){
                    SymbolMapReader smr = reader.getSymbolMapReader(16);
                    Assert.assertNotNull((Object)smr);
                    Assert.assertEquals((long)configuration.getDefaultSymbolCapacity(), (long)smr.getSymbolCapacity());
                    Assert.assertTrue((boolean)reader.getMetadata().isColumnIndexed(16));
                    Assert.assertEquals((long)16384L, (long)reader.getMetadata().getIndexValueBlockCapacity(16));
                    Assert.assertEquals((Object)configuration.getDefaultSymbolCacheFlag(), (Object)smr.isCached());
                }
                Assert.assertEquals((long)0L, (long)engine.getBusyWriterCount());
                Assert.assertEquals((long)0L, (long)engine.getBusyReaderCount());
            }
            finally {
                engine.releaseAllReaders();
                engine.releaseAllWriters();
            }
        });
    }

    @Test
    public void testAddSymbolNoCache() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try {
                this.createX();
                Assert.assertNull((Object)compiler.compile((CharSequence)"alter table x add column meh symbol nocache", bindVariableService));
                try (TableReader reader = engine.getReader((CharSequence)"x", -1L);){
                    SymbolMapReader smr = reader.getSymbolMapReader(16);
                    Assert.assertNotNull((Object)smr);
                    Assert.assertEquals((long)configuration.getDefaultSymbolCapacity(), (long)smr.getSymbolCapacity());
                    Assert.assertFalse((boolean)reader.getMetadata().isColumnIndexed(16));
                    Assert.assertEquals((long)configuration.getIndexValueBlockSize(), (long)reader.getMetadata().getIndexValueBlockCapacity(16));
                    Assert.assertFalse((boolean)smr.isCached());
                }
                Assert.assertEquals((long)0L, (long)engine.getBusyWriterCount());
                Assert.assertEquals((long)0L, (long)engine.getBusyReaderCount());
            }
            finally {
                engine.releaseAllReaders();
                engine.releaseAllWriters();
            }
        });
    }

    @Test
    public void testAddSymbolIncorrectCapacity() throws Exception {
        this.assertFailure("alter table x add column abc symbol capacity -", 46, "symbol capacity expected");
    }

    @Test
    public void testAddTwoColumns() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try {
                this.createX();
                Assert.assertNull((Object)compiler.compile((CharSequence)"alter table x add column mycol int, second symbol", bindVariableService));
                this.assertQuery("c\tmycol\tsecond\nXYZ\tNaN\t\nABC\tNaN\t\nABC\tNaN\t\nXYZ\tNaN\t\n\tNaN\t\nCDE\tNaN\t\nCDE\tNaN\t\nABC\tNaN\t\n\tNaN\t\nXYZ\tNaN\t\n", "select c, mycol, second from x", null, true);
                Assert.assertEquals((long)0L, (long)engine.getBusyWriterCount());
                Assert.assertEquals((long)0L, (long)engine.getBusyReaderCount());
            }
            finally {
                engine.releaseAllReaders();
                engine.releaseAllWriters();
            }
        });
    }

    @Test
    public void testAddUnknown() throws Exception {
        this.assertFailure("alter table x add blah", 18, "'column' expected");
    }

    @Test
    public void testExpectActionKeyword() throws Exception {
        this.assertFailure("alter table x", 13, "'add' or 'drop' expected");
    }

    @Test
    public void testExpectTableKeyword() throws Exception {
        this.assertFailure("alter x", 6, "'table' expected");
    }

    @Test
    public void testExpectTableKeyword2() throws Exception {
        this.assertFailure("alter", 5, "'table' expected");
    }

    @Test
    public void testExpectTableName() throws Exception {
        this.assertFailure("alter table", 11, "table name expected");
    }

    @Test
    public void testAddColumn() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try {
                this.createX();
                Assert.assertNull((Object)compiler.compile((CharSequence)"alter table x add column mycol int", bindVariableService));
                this.assertQuery("c\tmycol\nXYZ\tNaN\nABC\tNaN\nABC\tNaN\nXYZ\tNaN\n\tNaN\nCDE\tNaN\nCDE\tNaN\nABC\tNaN\n\tNaN\nXYZ\tNaN\n", "select c, mycol from x", null, true);
                Assert.assertEquals((long)0L, (long)engine.getBusyWriterCount());
                Assert.assertEquals((long)0L, (long)engine.getBusyReaderCount());
            }
            finally {
                engine.releaseAllReaders();
                engine.releaseAllWriters();
            }
        });
    }

    @Test
    public void testTableDoesNotExist() throws Exception {
        this.assertFailure("alter table y", 12, "table 'y' does not");
    }

    private void assertFailure(String sql, int position, String message) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try {
                this.createX();
                compiler.compile((CharSequence)sql, bindVariableService);
                Assert.fail();
            }
            catch (SqlException e) {
                Assert.assertEquals((long)position, (long)e.getPosition());
                TestUtils.assertContains(e.getFlyweightMessage(), message);
            }
            engine.releaseAllReaders();
            engine.releaseAllWriters();
        });
    }

    private void createX() throws SqlException {
        compiler.compile((CharSequence)"create table x as (select to_int(x) i, rnd_symbol('msft','ibm', 'googl') sym, round(rnd_double(0)*100, 3) amt, to_timestamp('2018-01', 'yyyy-MM') + x * 720000000 timestamp, rnd_boolean() b, rnd_str('ABC', 'CDE', null, 'XYZ') c, rnd_double(2) d, rnd_float(2) e, rnd_short(10,1024) f, rnd_date(to_date('2015', 'yyyy'), to_date('2016', 'yyyy'), 2) g, rnd_symbol(4,4,4,2) ik, rnd_long() j, timestamp_sequence(to_timestamp(0), 1000000000) k, rnd_byte(2,50) l, rnd_bin(10, 20, 2) m, rnd_str(5,16,2) n from long_sequence(10)) timestamp (timestamp)", bindVariableService);
    }
}

