/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.griffin;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.Engine;
import com.questdb.cairo.sql.CairoEngine;
import com.questdb.cairo.sql.Record;
import com.questdb.cairo.sql.RecordCursor;
import com.questdb.cairo.sql.RecordCursorFactory;
import com.questdb.cairo.sql.RecordMetadata;
import com.questdb.cairo.sql.SymbolTable;
import com.questdb.griffin.SqlCompiler;
import com.questdb.griffin.SqlException;
import com.questdb.griffin.TestExecutionContext;
import com.questdb.griffin.engine.functions.bind.BindVariableService;
import com.questdb.std.BinarySequence;
import com.questdb.std.IntList;
import com.questdb.std.LongList;
import com.questdb.test.tools.TestUtils;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;

public class AbstractGriffinTest
extends AbstractCairoTest {
    protected static final BindVariableService bindVariableService = new BindVariableService();
    private static final LongList rows = new LongList();
    protected static Engine engine;
    protected static SqlCompiler compiler;
    protected static TestExecutionContext sqlExecutionContext;

    public static void assertVariableColumns(RecordCursorFactory factory) {
        try (RecordCursor cursor = factory.getCursor(bindVariableService);){
            RecordMetadata metadata = factory.getMetadata();
            int columnCount = metadata.getColumnCount();
            Record record = cursor.getRecord();
            while (cursor.hasNext()) {
                block14: for (int i = 0; i < columnCount; ++i) {
                    switch (metadata.getColumnType(i)) {
                        case 7: {
                            CharSequence a = record.getStr(i);
                            CharSequence b = record.getStrB(i);
                            if (a == null) {
                                Assert.assertNull((Object)b);
                                Assert.assertEquals((long)-1L, (long)record.getStrLen(i));
                                continue block14;
                            }
                            Assert.assertNotSame((Object)a, (Object)b);
                            TestUtils.assertEquals(a, b);
                            Assert.assertEquals((long)a.length(), (long)record.getStrLen(i));
                            continue block14;
                        }
                        case 9: {
                            BinarySequence s = record.getBin(i);
                            if (s == null) {
                                Assert.assertEquals((long)-1L, (long)record.getBinLen(i));
                                continue block14;
                            }
                            Assert.assertEquals((long)s.length(), (long)record.getBinLen(i));
                            continue block14;
                        }
                    }
                }
            }
        }
    }

    @BeforeClass
    public static void setUp2() {
        engine = new Engine(configuration);
        compiler = new SqlCompiler((CairoEngine)engine, configuration);
        sqlExecutionContext = new TestExecutionContext(compiler.getCodeGenerator());
    }

    @AfterClass
    public static void tearDown() {
        engine.close();
        compiler.close();
    }

    protected static void assertCursor(CharSequence expected, RecordCursorFactory factory, boolean supportsRandomAccess) throws IOException {
        block30: {
            try (RecordCursor cursor = factory.getCursor(bindVariableService);){
                if (expected == null) {
                    Assert.assertFalse((boolean)cursor.hasNext());
                    cursor.toTop();
                    Assert.assertFalse((boolean)cursor.hasNext());
                    return;
                }
                sink.clear();
                rows.clear();
                printer.print(cursor, factory.getMetadata(), true);
                TestUtils.assertEquals(expected, (CharSequence)sink);
                RecordMetadata metadata = factory.getMetadata();
                AbstractGriffinTest.testSymbolAPI(metadata, cursor);
                cursor.toTop();
                Record record = cursor.getRecord();
                Assert.assertNotNull((Object)record);
                sink.clear();
                printer.printHeader(metadata);
                while (cursor.hasNext()) {
                    printer.print(record, metadata);
                }
                TestUtils.assertEquals(expected, (CharSequence)sink);
                if (supportsRandomAccess) {
                    int i;
                    Assert.assertTrue((boolean)factory.isRandomAccessCursor());
                    cursor.toTop();
                    sink.clear();
                    while (cursor.hasNext()) {
                        rows.add(record.getRowId());
                    }
                    printer.printHeader(metadata);
                    int n = rows.size();
                    for (i = 0; i < n; ++i) {
                        cursor.recordAt(record, rows.getQuick(i));
                        printer.print(record, metadata);
                    }
                    TestUtils.assertEquals(expected, (CharSequence)sink);
                    sink.clear();
                    printer.printHeader(metadata);
                    n = rows.size();
                    for (i = 0; i < n; ++i) {
                        cursor.recordAt(rows.getQuick(i));
                        printer.print(record, metadata);
                    }
                    TestUtils.assertEquals(expected, (CharSequence)sink);
                    sink.clear();
                    record = cursor.newRecord();
                    printer.printHeader(metadata);
                    n = rows.size();
                    for (i = 0; i < n; ++i) {
                        cursor.recordAt(record, rows.getQuick(i));
                        printer.print(record, metadata);
                    }
                    TestUtils.assertEquals(expected, (CharSequence)sink);
                    break block30;
                }
                Assert.assertFalse((boolean)factory.isRandomAccessCursor());
                try {
                    record.getRowId();
                    Assert.fail();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    cursor.newRecord();
                    Assert.fail();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    cursor.recordAt(0L);
                    Assert.fail();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
                try {
                    cursor.recordAt(record, 0L);
                    Assert.fail();
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
        }
    }

    protected static void testSymbolAPI(RecordMetadata metadata, RecordCursor cursor) {
        IntList symbolIndexes = null;
        int n = metadata.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (metadata.getColumnType(i) != 8) continue;
            if (symbolIndexes == null) {
                symbolIndexes = new IntList();
            }
            symbolIndexes.add(i);
        }
        if (symbolIndexes != null) {
            cursor.toTop();
            Record record = cursor.getRecord();
            while (cursor.hasNext()) {
                int n2 = symbolIndexes.size();
                for (int i = 0; i < n2; ++i) {
                    int column = symbolIndexes.getQuick(i);
                    SymbolTable symbolTable = cursor.getSymbolTable(column);
                    CharSequence sym = record.getSym(column);
                    int value = record.getInt(column);
                    Assert.assertEquals((long)value, (long)symbolTable.getQuick(sym));
                    TestUtils.assertEquals(sym, symbolTable.value(value));
                }
            }
        }
    }

    protected static void assertTimestampColumnValues(RecordCursorFactory factory) {
        int index = factory.getMetadata().getTimestampIndex();
        long timestamp = Long.MIN_VALUE;
        try (RecordCursor cursor = factory.getCursor(bindVariableService);){
            Record record = cursor.getRecord();
            while (cursor.hasNext()) {
                long ts = record.getTimestamp(index);
                Assert.assertTrue((timestamp <= ts ? 1 : 0) != 0);
                timestamp = ts;
            }
        }
    }

    protected static void printSqlResult(CharSequence expected, CharSequence query, CharSequence expectedTimestamp, CharSequence ddl2, CharSequence expected2, boolean supportsRandomAccess) throws IOException, SqlException {
        try (RecordCursorFactory factory = compiler.compile(query, bindVariableService);){
            AbstractGriffinTest.assertTimestamp(expectedTimestamp, factory);
            AbstractGriffinTest.assertCursor(expected, factory, supportsRandomAccess);
            AbstractGriffinTest.assertCursor(expected, factory, supportsRandomAccess);
            AbstractGriffinTest.assertVariableColumns(factory);
            if (ddl2 != null) {
                compiler.compile(ddl2, bindVariableService);
                AbstractGriffinTest.assertCursor(expected2, factory, supportsRandomAccess);
                AbstractGriffinTest.assertCursor(expected2, factory, supportsRandomAccess);
            }
        }
    }

    private static void assertQuery(CharSequence expected, CharSequence query, @Nullable CharSequence ddl, @Nullable CharSequence verify, @Nullable CharSequence expectedTimestamp, @Nullable CharSequence ddl2, @Nullable CharSequence expected2, boolean supportsRandomAccess) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try {
                if (ddl != null) {
                    compiler.compile(ddl, bindVariableService);
                }
                if (verify != null) {
                    AbstractGriffinTest.printSqlResult(null, verify, expectedTimestamp, ddl2, expected2, supportsRandomAccess);
                }
                AbstractGriffinTest.printSqlResult(expected, query, expectedTimestamp, ddl2, expected2, supportsRandomAccess);
                Assert.assertEquals((long)0L, (long)engine.getBusyReaderCount());
                Assert.assertEquals((long)0L, (long)engine.getBusyWriterCount());
            }
            finally {
                engine.releaseAllWriters();
                engine.releaseAllReaders();
            }
        });
    }

    protected static void assertQuery(CharSequence expected, CharSequence query, CharSequence ddl, @Nullable CharSequence expectedTimestamp) throws Exception {
        AbstractGriffinTest.assertQuery(expected, query, ddl, null, expectedTimestamp, null, null, true);
    }

    protected static void assertQuery(CharSequence expected, CharSequence query, CharSequence ddl, @Nullable CharSequence expectedTimestamp, boolean supportsRandomAccess) throws Exception {
        AbstractGriffinTest.assertQuery(expected, query, ddl, null, expectedTimestamp, null, null, supportsRandomAccess);
    }

    protected static void assertQuery(CharSequence expected, CharSequence query, CharSequence ddl, @Nullable CharSequence expectedTimestamp, @Nullable CharSequence ddl2, @Nullable CharSequence expected2) throws Exception {
        AbstractGriffinTest.assertQuery(expected, query, ddl, null, expectedTimestamp, ddl2, expected2, true);
    }

    protected static void assertQuery(CharSequence expected, CharSequence query, CharSequence ddl, @Nullable CharSequence expectedTimestamp, @Nullable CharSequence ddl2, @Nullable CharSequence expected2, boolean supportsRandomAccess) throws Exception {
        AbstractGriffinTest.assertQuery(expected, query, ddl, null, expectedTimestamp, ddl2, expected2, supportsRandomAccess);
    }

    protected static void assertTimestamp(CharSequence expectedTimestamp, RecordCursorFactory factory) {
        if (expectedTimestamp == null) {
            Assert.assertEquals((long)-1L, (long)factory.getMetadata().getTimestampIndex());
        } else {
            int index = factory.getMetadata().getColumnIndex(expectedTimestamp);
            Assert.assertNotEquals((long)-1L, (long)index);
            Assert.assertEquals((long)index, (long)factory.getMetadata().getTimestampIndex());
            AbstractGriffinTest.assertTimestampColumnValues(factory);
        }
    }

    void assertFactoryCursor(String expected, String expectedTimestamp, RecordCursorFactory factory) throws IOException {
        this.assertFactoryCursor(expected, expectedTimestamp, factory, false);
    }

    void assertFactoryCursor(String expected, String expectedTimestamp, RecordCursorFactory factory, boolean supportsRandomAccess) throws IOException {
        AbstractGriffinTest.assertTimestamp(expectedTimestamp, factory);
        AbstractGriffinTest.assertCursor(expected, factory, supportsRandomAccess);
        AbstractGriffinTest.assertCursor(expected, factory, supportsRandomAccess);
        AbstractGriffinTest.assertVariableColumns(factory);
    }

    protected void assertFailure(CharSequence query, @Nullable CharSequence ddl, int expectedPosition, @NotNull CharSequence expectedMessage) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try {
                if (ddl != null) {
                    compiler.compile(ddl, bindVariableService);
                }
                try {
                    compiler.compile(query, bindVariableService);
                    Assert.fail();
                }
                catch (SqlException e) {
                    Assert.assertEquals((long)expectedPosition, (long)e.getPosition());
                    TestUtils.assertContains(e.getFlyweightMessage(), expectedMessage);
                }
                Assert.assertEquals((long)0L, (long)engine.getBusyReaderCount());
                Assert.assertEquals((long)0L, (long)engine.getBusyWriterCount());
            }
            finally {
                engine.releaseAllWriters();
                engine.releaseAllReaders();
            }
        });
    }

    protected void assertQuery(String expected, String query, String expectedTimestamp) throws IOException, SqlException {
        this.assertQuery(expected, query, expectedTimestamp, false);
    }

    protected void assertQuery(String expected, String query, String expectedTimestamp, boolean supportsRandomAccess) throws IOException, SqlException {
        try (RecordCursorFactory factory = compiler.compile((CharSequence)query, bindVariableService);){
            this.assertFactoryCursor(expected, expectedTimestamp, factory, supportsRandomAccess);
        }
    }

    protected void assertQueryAndCache(String expected, String query, String expectedTimestamp) throws IOException, SqlException {
        this.assertQueryAndCache(expected, query, expectedTimestamp, false);
    }

    protected void assertQueryAndCache(String expected, String query, String expectedTimestamp, boolean supportsRandomAccess) throws IOException, SqlException {
        RecordCursorFactory factory = compiler.compile((CharSequence)query, bindVariableService);
        this.assertFactoryCursor(expected, expectedTimestamp, factory, supportsRandomAccess);
        compiler.cache((CharSequence)query, factory);
    }
}

