/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cutlass.text.types;

import com.questdb.cairo.CairoException;
import com.questdb.cutlass.json.JsonException;
import com.questdb.cutlass.json.JsonLexer;
import com.questdb.cutlass.text.DefaultTextConfiguration;
import com.questdb.cutlass.text.TextConfiguration;
import com.questdb.cutlass.text.types.TypeManager;
import com.questdb.std.Misc;
import com.questdb.std.str.DirectCharSink;
import com.questdb.test.tools.TestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TypeManagerTest {
    private static DirectCharSink utf8Sink;
    private static JsonLexer jsonLexer;

    @BeforeClass
    public static void setUp() {
        utf8Sink = new DirectCharSink(64);
        jsonLexer = new JsonLexer(1024, 2048);
    }

    @AfterClass
    public static void tearDown() {
        Misc.free((Object)utf8Sink);
        Misc.free((Object)jsonLexer);
    }

    @Before
    public void setUp2() {
        jsonLexer.clear();
    }

    @Test
    public void testDateFormatArray() {
        this.assertFailure("/textloader/types/date_format_array.json", 127, "format value expected (array)");
    }

    @Test
    public void testDateFormatNull() {
        this.assertFailure("/textloader/types/date_format_null.json", 37, "null format");
    }

    @Test
    public void testDateFormatObj() {
        this.assertFailure("/textloader/types/date_format_obj.json", 127, "format value expected (obj)");
    }

    @Test
    public void testDateLocaleArray() {
        this.assertFailure("/textloader/types/date_locale_array.json", 171, "locale value expected (array)");
    }

    @Test
    public void testDateLocaleObj() {
        this.assertFailure("/textloader/types/date_locale_obj.json", 171, "locale value expected (obj)");
    }

    @Test
    public void testDateMissingFormat() {
        this.assertFailure("/textloader/types/date_missing_format.json", 49, "date format is missing");
    }

    @Test
    public void testDateObj() {
        this.assertFailure("/textloader/types/date_obj.json", 13, "array expected (obj)");
    }

    @Test
    public void testDateUnknownLocale() {
        this.assertFailure("/textloader/types/date_unknown_locale.json", 65, "invalid [locale=zyx]");
    }

    @Test
    public void testDateUnknownTag() {
        this.assertFailure("/textloader/types/date_unknown_tag.json", 55, "unknown [tag=whatsup]");
    }

    @Test
    public void testDateValue() {
        this.assertFailure("/textloader/types/date_value.json", 14, "array expected (value)");
    }

    @Test
    public void testEmpty() throws JsonException {
        TypeManager typeManager = this.createTypeManager("/textloader/types/empty.json");
        Assert.assertEquals((Object)"[INT,LONG,DOUBLE,BOOLEAN]", (Object)typeManager.getAllAdapters().toString());
    }

    @Test
    public void testResourceNotFound() {
        this.assertFailure("/textloader/types/not_found.json", 0, "could not find [resource=/textloader/types/not_found.json]");
    }

    @Test
    public void testTimestampFormatArray() {
        this.assertFailure("/textloader/types/timestamp_format_array.json", 243, "format value expected (array)");
    }

    @Test
    public void testTimestampFormatNull() {
        this.assertFailure("/textloader/types/timestamp_format_null.json", 229, "null format");
    }

    @Test
    public void testTimestampFormatObj() {
        this.assertFailure("/textloader/types/timestamp_format_obj.json", 243, "format value expected (obj)");
    }

    @Test
    public void testTimestampLocaleArray() {
        this.assertFailure("/textloader/types/timestamp_locale_array.json", 287, "locale value expected (array)");
    }

    @Test
    public void testTimestampLocaleObj() {
        this.assertFailure("/textloader/types/timestamp_locale_obj.json", 366, "locale value expected (obj)");
    }

    @Test
    public void testTimestampMissingFormat() {
        this.assertFailure("/textloader/types/timestamp_missing_format.json", 241, "timestamp format is missing");
    }

    @Test
    public void testTimestampObj() {
        this.assertFailure("/textloader/types/timestamp_obj.json", 244, "array expected (obj)");
    }

    @Test
    public void testTimestampUnknownLocale() {
        this.assertFailure("/textloader/types/timestamp_unknown_locale.json", 313, "invalid [locale=zyx]");
    }

    @Test
    public void testTimestampUnknownTag() {
        this.assertFailure("/textloader/types/timestamp_unknown_tag.json", 303, "unknown [tag=ehlo]");
    }

    @Test
    public void testTimestampValue() {
        this.assertFailure("/textloader/types/timestamp_value.json", 245, "array expected (value)");
    }

    @Test
    public void testUnknownTopLevelProp() {
        this.assertFailure("/textloader/types/unknown_top_level_prop.json", 309, "'date' and/or 'timestamp' expected");
    }

    @Test
    public void testIllegalMethodParameterBinary() throws JsonException {
        this.testIllegalParameterForGetTypeAdapter(9);
    }

    @Test
    public void testIllegalMethodParameterDate() throws JsonException {
        this.testIllegalParameterForGetTypeAdapter(10);
    }

    @Test
    public void testIllegalMethodParameterTimestamp() throws JsonException {
        this.testIllegalParameterForGetTypeAdapter(12);
    }

    private void testIllegalParameterForGetTypeAdapter(int columnType) throws JsonException {
        TypeManager typeManager = new TypeManager((TextConfiguration)new DefaultTextConfiguration(), utf8Sink, jsonLexer);
        try {
            typeManager.getTypeAdapter(columnType);
            Assert.fail();
        }
        catch (CairoException e) {
            TestUtils.assertContains(e.getMessage(), "no adapter for type");
        }
    }

    private void assertFailure(String resourceName, int position, CharSequence text) {
        try {
            this.createTypeManager(resourceName);
            Assert.fail((String)"has to fail");
        }
        catch (JsonException e) {
            Assert.assertEquals((long)position, (long)e.getPosition());
            TestUtils.assertContains(e.getFlyweightMessage(), text);
        }
    }

    private TypeManager createTypeManager(final String fileResource) throws JsonException {
        return new TypeManager((TextConfiguration)new DefaultTextConfiguration(){

            public String getAdapterSetConfigurationFileName() {
                return fileResource;
            }
        }, utf8Sink, jsonLexer);
    }
}

