/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cutlass.text;

import com.questdb.cutlass.json.JsonException;
import com.questdb.cutlass.json.JsonLexer;
import com.questdb.cutlass.json.JsonParser;
import com.questdb.cutlass.text.DefaultTextConfiguration;
import com.questdb.cutlass.text.TextConfiguration;
import com.questdb.cutlass.text.TextMetadataParser;
import com.questdb.cutlass.text.types.TypeManager;
import com.questdb.std.Unsafe;
import com.questdb.std.microtime.DateLocaleFactory;
import com.questdb.std.str.DirectCharSink;
import com.questdb.std.time.DateFormatFactory;
import com.questdb.test.tools.TestUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class TextMetadataParserTest {
    private static final JsonLexer LEXER = new JsonLexer(1024, 4096);
    private static TextMetadataParser textMetadataParser;
    private static TypeManager typeManager;
    private static DirectCharSink utf8Sink;
    private static JsonLexer jsonLexer;

    @BeforeClass
    public static void setUpClass() throws JsonException {
        utf8Sink = new DirectCharSink(1024);
        jsonLexer = new JsonLexer(1024, 1024);
        typeManager = new TypeManager((TextConfiguration)new DefaultTextConfiguration(), utf8Sink, jsonLexer);
        textMetadataParser = new TextMetadataParser((TextConfiguration)new DefaultTextConfiguration(), com.questdb.std.time.DateLocaleFactory.INSTANCE, new DateFormatFactory(), DateLocaleFactory.INSTANCE, new com.questdb.std.microtime.DateFormatFactory(), typeManager);
    }

    @AfterClass
    public static void tearDown() {
        LEXER.close();
        jsonLexer.close();
        utf8Sink.close();
        textMetadataParser.close();
    }

    @Before
    public void setUp() {
        LEXER.clear();
        textMetadataParser.clear();
        typeManager.clear();
    }

    @Test
    public void testArrayProperty() {
        this.assertFailure("[\n{\"name\": \"x\", \"type\": \"DOUBLE\", \"pattern\":\"xyz\", \"locale\": []}\n]", 62, "Unexpected array");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCorrectSchema() throws Exception {
        String in = "[\n{\"name\": \"x\", \"type\": \"INT\", \"pattern\":\"xyz\", \"locale\": \"en-US\"},\n{\"name\": \"y\", \"type\": \"DATE\", \"pattern\":\"xyz\"}\n]";
        long buf = TestUtils.toMemory(in);
        try {
            LEXER.parse(buf, (long)in.length(), (JsonParser)textMetadataParser);
            Assert.assertEquals((long)2L, (long)textMetadataParser.getColumnTypes().size());
            Assert.assertEquals((long)2L, (long)textMetadataParser.getColumnNames().size());
            Assert.assertEquals((Object)"[INT,DATE]", (Object)textMetadataParser.getColumnTypes().toString());
            Assert.assertEquals((Object)"[x,y]", (Object)textMetadataParser.getColumnNames().toString());
        }
        finally {
            Unsafe.free((long)buf, (long)in.length());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyList() throws Exception {
        String in = "[]";
        long buf = TestUtils.toMemory(in);
        try {
            LEXER.parse(buf, (long)in.length(), (JsonParser)textMetadataParser);
            Assert.assertEquals((long)0L, (long)textMetadataParser.getColumnTypes().size());
            Assert.assertEquals((long)0L, (long)textMetadataParser.getColumnNames().size());
        }
        finally {
            Unsafe.free((long)buf, (long)in.length());
        }
    }

    @Test
    public void testEmptyObject() {
        this.assertFailure("[{}]", 3, "Missing 'name' property");
    }

    @Test
    public void testMissingName() {
        String in = "[\n{\"name\": \"x\", \"type\": \"INT\", \"pattern\":\"xyz\", \"locale\": \"en-GB\"},\n{\"type\": \"DOUBLE\", \"pattern\":\"xyz\"}\n]";
        this.assertFailure(in, 103, "Missing 'name' property");
    }

    @Test
    public void testMissingType() {
        String in = "[\n{\"name\": \"x\", \"pattern\":\"xyz\", \"locale\": \"en-GB\"},\n{\"name\": \"y\", \"type\": \"DOUBLE\", \"pattern\":\"xyz\"}\n]";
        this.assertFailure(in, 51, "Missing 'type' property");
    }

    @Test
    public void testNonArray() {
        this.assertFailure("{}", 1, "Unexpected object");
    }

    @Test
    public void testNonObjectArrayMember() {
        this.assertFailure("[2,\n{\"name\": \"x\", \"type\": \"DOUBLE\", \"pattern\":\"xyz\"}\n]", 2, "Must be an object");
    }

    @Test
    public void testWrongDateLocale() {
        this.assertFailure("[\n{\"name\": \"x\", \"type\": \"DATE\", \"pattern\":\"xyz\", \"locale\": \"enk\"}\n]", 61, "Invalid date locale");
    }

    @Test
    public void testWrongTimestampLocale() {
        this.assertFailure("[\n{\"name\": \"x\", \"type\": \"TIMESTAMP\", \"pattern\":\"xyz\", \"locale\": \"enk\"}\n]", 66, "Invalid timestamp locale");
    }

    @Test
    public void testWrongType() {
        this.assertFailure("[\n{\"name\": \"y\", \"type\": \"ABC\", \"pattern\":\"xyz\"}\n]", 26, "Invalid type");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertFailure(CharSequence schema, int position, CharSequence message) {
        long buf = TestUtils.toMemory(schema);
        try {
            LEXER.parse(buf, (long)schema.length(), (JsonParser)textMetadataParser);
            Assert.fail();
        }
        catch (JsonException e) {
            Assert.assertEquals((long)position, (long)e.getPosition());
            TestUtils.assertContains(e.getMessage(), message);
        }
        finally {
            Unsafe.free((long)buf, (long)schema.length());
        }
    }
}

