/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cutlass.text;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.Engine;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.sql.CairoEngine;
import com.questdb.cairo.sql.RecordCursor;
import com.questdb.cairo.sql.RecordCursorFactory;
import com.questdb.cutlass.json.JsonException;
import com.questdb.cutlass.text.DefaultTextConfiguration;
import com.questdb.cutlass.text.TextConfiguration;
import com.questdb.cutlass.text.TextLoader;
import com.questdb.cutlass.text.UnknownDelimiterException;
import com.questdb.griffin.SqlCompiler;
import com.questdb.griffin.SqlException;
import com.questdb.std.Files;
import com.questdb.std.Unsafe;
import com.questdb.std.microtime.DateLocaleFactory;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.Path;
import com.questdb.std.time.DateFormatFactory;
import com.questdb.std.time.DateLocale;
import com.questdb.test.tools.TestUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class TextLoaderTest
extends AbstractCairoTest {
    private static final Engine engine = new Engine(configuration);
    private static final SqlCompiler compiler = new SqlCompiler((CairoEngine)engine, configuration);
    private static final ByteManipulator ENTITY_MANIPULATOR = (index, len, b) -> b;

    @AfterClass
    public static void tearDownClass() {
        compiler.close();
        engine.close();
    }

    @After
    public void tearDown() {
        sink.clear();
        engine.releaseAllWriters();
        engine.releaseAllReaders();
    }

    @Test
    public void testBrokenUtf8All() throws Exception {
        this.assertNoLeak(textLoader -> {
            String csv = "\"\u2116 \u043f/\u043f\",\"\u041e\u0431\u044a\u0435\u043a\u0442\u044b \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e \u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"\u0412\u0438\u0434 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e \u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"\u0422\u0435\u043c\u0430 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e \u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434\",\"\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\",\"\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\",\"\u0412\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f, \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438\",\"\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\"\n1,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0443\u043d\u0438\u0442\u0430\u0440\u043d\u043e\u0435 \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u0435 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0435 \u0442\u0435\u043f\u043b\u043e\u0432\u044b\u0435 \u0441\u0435\u0442\u0438\u00bb\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2015\u0433. - 31.12.2015\u0433.\",\"09.03.2016\u0433.\",\"01.04.2016\u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                          - \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432;                                            -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u044f.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.04.2016 \u0433\u043e\u0434\u0430\"\n2,\"\u041e\u0410\u041e \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0430\u044f \u0410\u041a \u21161468\u00bb\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u041e\u0410\u041e \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0430\u044f \u0410\u041a \u21161468\u00bb \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043d\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043e\u043a \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 \u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430\u043c \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u043e\u0442 31.12.2015 \u0433\u043e\u0434\u0430 \u2116 12-53\",\"01 - 29.02.16 \u0433.  01.01.2016 \u0433. -  31.01.2016 \u0433.,   01.03.2016 \u0433. - 30.04.2016 \u0433.\",\"04.04.2016\u0433.  10.05.2016\u0433.\",\"15.04.2016\u0433.  31.05.2016\u0433.\",\"\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043d\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \n\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043e\u043a \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 \u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430\u043c \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \n\u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u043e\u0442 31.12.2015 \u0433\u043e\u0434\u0430 \u211612-53    \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.06.2016 \u0433\u043e\u0434\u0430\"\n3,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438; \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\",\"01.01.2015 \u0433. -                   31.01.2016 \u0433.\",\"08.02.2016\u0433 \u043f\u0435\u0440\u0435\u0440\u044b\u0432 04.05.2016.\",\"04.03.2016\u0433. 38 \u0440\u0430\u0431. \u0434\u043d\u0435\u0439 06.05.2016\u0433.\",\"\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                               - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                             \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 01.07.2016 \u0433\u043e\u0434\u0430\"\n4,\"\u041c\u041a\u0423\u041a \u00ab\u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438; \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\",\"01.01.2015 \u0433. - 31.05.2016 \u0433.\",\"06.06.2016\u0433.\",\"27.06.2016\u0433.\",\"\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                                     \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 11.08.2016 \u0433\u043e\u0434\u0430\"\n5,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438, \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\",\"01.01.2015 \u0433. - 30.06.2016 \u0433.\",\"11.07.2016\u0433.\",\"29.07.2016\u0433.\",\"\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                                     \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 10.09.2016 \u0433\u043e\u0434\u0430\"\n6,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041c\u0424\u0426 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430\u00bb\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2015 \u0433. - 19.09.2016 \u0433.\",\"18.08.2016\u0433.\",\"19.09.2016\u0433.\",\"- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u041f\u0440\u0430\u0432\u0438\u043b \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043c\u043d\u043e\u0433\u043e\u0444\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0445 \u0446\u0435\u043d\u0442\u0440\u043e\u0432 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u041f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0420\u0424 \u043e\u0442 22.12.2012 \u0433\u043e\u0434\u0430 \u2116 1376.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.10.2016 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 07.11.2016 \u0433\u043e\u0434\u0430\"\n7,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2015 \u0433. - 31.08.2016 \u0433.\",\"22.09.2016\u0433.\",\"14.10.2016\u0433.\",\"\u0447.2 \u0441\u0442.34; \u043f.4 \u0441\u0442.38; \u0441\u0442.94; \u0441\u0442.95; \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;    - \u043f.1 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424- \u043f.1 \u0441\u0442.432; \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465; \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;           - \u043f.11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430 N 157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 21.11.2016 \u0433\u043e\u0434\u0430\"\n8,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2015 \u0433. - 31.08.2016 \u0433.\",\"22.09.2016\u0433.\",\"14.10.2016\u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                            - \u043d\u0435\u0446\u0435\u043b\u0435\u0432\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430;                                                     -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                   - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 14.12.2016 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 19.12.2016 \u0433\u043e\u0434\u0430\"\n9,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u00ab\u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2015\u0433 \u2014 31.10.2016\u0433\",\"01.11.2016 \u0433.\",\"11.11.2016 \u0433.\",\"\u0447.4 \u0441\u0442.30; \u0447.2 \u0441\u0442.34; \u043f.4 \u0441\u0442.38; \u0441\u0442.94; \u0447. 2, \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                           - \u043f.2 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;      - \u043f.1 \u0441\u0442.432; \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465; \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;           - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433.\u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                              - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  N 157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.12.2016 \u0433\u043e\u0434\u0430\"\n10,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u00ab\u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2015\u0433 \u2014 31.10.2016\u0433\",\"03.08.2016\u0433 \u043f\u0435\u0440\u0435\u0440\u044b\u0432 26.10.2016.\",\"18.08.2016\u0433. 48 \u0440\u0430\u0431. \u0434\u043d\u0435\u0439 11.11.2016\u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                           -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                  - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.01.2017 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 10.02.2017 \u0433\u043e\u0434\u0430\"\n11,\"\u041c\u0411\u0423\u0421\u041e\u0421\u0421\u0417\u041d \"\u041a\u043e\u043c\u043f\u043b\u0435\u043a\u0441\u043d\u044b\u0439 \u0446\u0435\u043d\u0442\u0440 \u0441\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u043d\u0430\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430\"\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2016\u0433 \u2014 30.11.2016\u0433\",\"19.12.2016 \u0433.\",\"29.12.2016 \u0433.\",\"\u0447.2 \u0441\u0442.34; \u0441\u0442.94; \u0447. 2, \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                -  \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                   - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433.\u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                             - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116 157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.01.2017 \u0433\u043e\u0434\u0430\"\n12,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2016 \u0433. -                   31.12.2016 \u0433.\",\"23.01.2017\u0433.\",\"15.02.2017 \u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                            - \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430;                                                     -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                   - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u043e\u0432 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 10.05.2017 \u0433\u043e\u0434\u0430\"\n13,\"\u041c\u041a\u0423\u041a \u00ab\u041b\u043e\u0437\u043e\u0432\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2015 \u0433. -                   31.12.2016 \u0433.\",\"20.02.2017\u0433.\",\"15.03.2017 \u0433.\",\"\u0447.2 \u0441\u0442.34, \u043f.4 \u0441\u0442.38, \u0441\u0442.93, \u0441\u0442.94, \u0441\u0442.95, \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;     - \u043f.2 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;       - \u043f.1 \u0441\u0442.432, \u043f.3 \u0441\u0442.455, \u043f.2 \u0441\u0442.465, \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;            - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                 - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116 157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439  \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.04.2017 \u0433\u043e\u0434\u0430\"\n14,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0440\u0430\u043d\u0435\u0435 \u0432\u044b\u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0433\u043b\u0430\u0432\u0435 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f\",\"-\",\"23.03.2017\u0433.\",\"23.03.2017 \u0433.\",\"\u041d\u0435\u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0432 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0439 \u0441\u0440\u043e\u043a \u0437\u0430\u043a\u043e\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432 \u0438 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0439 \u043f\u043e\u043b\u0438\u0442\u0438\u043a\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 (\u043f.4 \u0441\u0442. 270.2 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438).\",\"\u0421\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u043e\u0431 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u043c \u043f\u0440\u0430\u0432\u043e\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0438, \u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u044c \u0437\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0447\u0430\u0441\u0442\u044c\u044e 20 \u0441\u0442\u0430\u0442\u044c\u0438 19.5 \u041a\u043e\u0410\u041f \u0420\u0424. \u0414\u0435\u043b\u043e \u043e\u0431 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u043c \u043f\u0440\u0430\u0432\u043e\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0438 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0435\u0434\u0430\u0442\u0435\u043b\u044e \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u043d\u043e\u0433\u043e \u0441\u0443\u0434\u0430.\"\n15,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u043b\u0435\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2015\u0433.- 31.12.2016\u0433.\",\"20.03.2017\u0433.\",\"11.04.2017\u0433.\",\"- \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0432 \u0441\u0443\u043c\u043c\u0435 0,5 \u0442\u044b\u0441. \u0440\u0443\u0431\u043b\u0435\u0439;                                                  - \u0447.2 \u0441\u0442.34, \u0447.2 \u0441\u0442.93, \u0447.9 \u0441\u0442.94, \u0441\u0442.95, \u0447.2 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                                      - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439  \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.05.2017 \u0433\u043e\u0434\u0430\"\n16,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u043b\u0435\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438   \u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432, \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u043d\u0430 \u043e\u043a\u0430\u0437\u0430\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433\",\"01.01.2015 \u0433.-                  31.01.2016 \u0433.\",\"27.02.2017\u0433.\",\"11.04.2017\u0433.\",\"\u0412\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b. \u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438: \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u043d\u0435\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438  \u043e \u0441\u043e\u0441\u0442\u0430\u0432\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430 \u0438 \u0435\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438, \u0437\u0430\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u043d\u043e\u0440\u043c \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0413\u0421\u041c \u0438 \u043f\u0440\u043e\u0447\u0438\u0435. \u0412\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430 \u0438 \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 23.06.2017 \u0433\u043e\u0434\u0430\"\n17,\"\u041c\u0410\u0423 \u00ab\u041c\u0424\u0426 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438,  \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438 \u043e\u0442 14.10.2016 \u0433\u043e\u0434\u0430 \u21163001\",\"09.2016 \u0433.-05.2017 \u0433.\",\"19.04.2017\u0433\",\"19.05.2017 \u0433.\",\"\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b.                      \u0412\u044b\u044f\u0432\u043b\u0435\u043d\u043e \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 21.08.2017 \u0433\u043e\u0434\u0430\"\n18,\"\u041c\u0411\u041e\u0423 \u00ab\u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2016 \u0433. - 30.05.2017 \u0433.\",\"25.05.2017\u0433\",\"20.06.2017 \u0433.\",\"- \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u043f.4 \u0441\u0442.38, \u0447.2 \u0441\u0442.93, \u0447.9, 11 \u0441\u0442.94, \u0441\u0442.95 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                              - \u043f.3 \u0441\u0442.455, \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                       - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\",\"\u041f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\"\n19,\"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430, \u043f\u0440\u0438\u0440\u043e\u0434\u043e\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438 \u0440\u0430\u0437\u0432\u0438\u0442\u0438\u044f \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0439\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432, \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044e \u043f\u043e\u0434\u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b_5 \u00ab\u041e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b\u00bb \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u0430\u0437\u0432\u0438\u0442\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430 \u0432 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u043c \u0440\u0430\u0439\u043e\u043d\u0435 \u043d\u0430 2015-2020 \u0433\u043e\u0434\u044b\u00bb\",\"01.01.2016 \u0433. - 31.12.2016 \u0433.\",\"19.01.2017 \u0433. \u043f\u0435\u0440\u0435\u0440\u044b\u0432     01.06.2017 \u0433.\",\"20.01.2017 \u0433.  4\u043c\u0435\u0441. 11\u043a.\u0434\u043d.    07.07.2017 \u0433.\",\"\u041a\u0432\u0430\u0440\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u0438 \u0433\u043e\u0434\u043e\u0432\u043e\u0439 \u043e\u0442\u0447\u0435\u0442\u044b \u043e \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u00ab\u0420\u0430\u0437\u0432\u0438\u0442\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430 \u0432 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u043c \u0440\u0430\u0439\u043e\u043d\u0435 \u043d\u0430 2015-2020 \u0433\u043e\u0434\u044b\u00bb \u0437\u0430 2016 \u0433\u043e\u0434 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438.\",\"\u041f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\"\n20,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \"\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\" \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e, \u0440\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u043d\u0430\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e\u0441\u044f \u0432 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u0438\",\"01.07.2016 \u0433. - 30.06.2017 \u0433.\",\"03.07.2017 \u0433.\",\"04.08.2017 \u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;          - \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.09.2017 \u0433\u043e\u0434\u0430\"\n21,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041b\u043e\u0437\u043d\u044f\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2016 \u0433. - 31.07.2017 \u0433.\",\"07.08.2017 \u0433.\",\"25.08.2017 \u0433.\",\"- \u0447.10 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0447.2 \u0441\u0442.93, \u0447.9,11 \u0441\u0442.94, \u0441\u0442.95, \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                             - \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.09.2017 \u0433\u043e\u0434\u0430\"\n22,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0443\u0431\u0441\u0438\u0434\u0438\u0439 \u043d\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u0438 \u0441\u0443\u0431\u0441\u0438\u0434\u0438\u0439 \u043d\u0430 \u0438\u043d\u044b\u0435 \u0446\u0435\u043b\u0438\",\"01.01.2016 \u0433. - 31.08.2017 \u0433.\",\"01.09.2017 \u0433.\",\"25.09.2017 \u0433.\",\"\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043e\u0442\u0434\u0435\u043b\u044c\u043d\u044b\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f, \u043a\u0430\u0441\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.12.2017 \u0433\u043e\u0434\u0430\"\n23,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0438\u0436\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0430\u044f \u043e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2016 \u0433. - 31.09.2017 \u0433.\",\"12.10.2017 \u0433.\",\"27.10.2017 \u0433.\",\"- \u0447.10 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0447.9 \u0441\u0442.94, \u0441\u0442.95, \u0447.2,3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417\",\"\u041f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\"\n24,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u00ab\u0414\u0435\u0442\u0441\u043a\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u00bb \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u043e\u0435 \u043e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435\",\"\u041e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e \u0432\u043e\u043f\u0440\u043e\u0441\u0443 \u043e\u0431\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u043d\u043e\u0441\u0442\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0432\u044b\u043f\u043b\u0430\u0442 \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0433\u043e \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0430 \u0440\u0430\u0431\u043e\u0442\u043d\u0438\u043a\u0430\u043c \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f\",\"01.01.2017 \u0433. - 31.09.2017 \u0433.\",\"18.10.2017 \u0433.\",\"27.10.2017 \u0433.\",\"\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043e \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u0444\u043e\u043d\u0434\u0430 \u043e\u043f\u043b\u0430\u0442\u044b \u0442\u0440\u0443\u0434\u0430 (\u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u21163 \u043a \u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044e \u043e\u0431 \u043e\u043f\u043b\u0430\u0442\u0435 \u0442\u0440\u0443\u0434\u0430 \u0440\u0430\u0431\u043e\u0442\u043d\u0438\u043a\u043e\u0432 \u041c\u0411\u0423 \u0414\u041e  \u00ab\u0414\u0435\u0442\u0441\u043a\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u00bb \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043e\u0442 23.05.2017 \u0433. \u2116239) \u0438 \u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043e \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u0444\u043e\u043d\u0434\u0430 \u043e\u043f\u043b\u0430\u0442\u044b \u0442\u0440\u0443\u0434\u0430 \u041c\u0411\u0423 \u0414\u041e  \u00ab\u0414\u0435\u0442\u0441\u043a\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u00bb \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e 22.08.2017 \u0433.\",\"\u0412 \u0430\u0434\u0440\u0435\u0441 \u0443\u0447\u0440\u0435\u0434\u0438\u0442\u0435\u043b\u044f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0438\u0441\u044c\u043c\u043e \u0441 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f\u043c\u0438 \u043e \u043f\u0440\u0438\u043d\u044f\u0442\u0438\u0438 \u043c\u0435\u0440 \u043f\u043e \u043d\u0435\u0434\u043e\u043f\u0443\u0449\u0435\u043d\u0438\u044e \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u043d\u044b\u0445 \u0432 \u0437\u0430\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439\"\n25,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041f\u043b\u0430\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0431\u0430\u0441\u0441\u0435\u0439\u043d \u00ab\u0414\u0435\u043b\u044c\u0444\u0438\u043d\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.09.2016 \u0433. - 31.10.2017 \u0433.\",\"30.10.2017 \u0433.\",\"08.12.2017 \u0433.\",\"\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0439 \u0434\u0438\u0441\u0446\u0438\u043f\u043b\u0438\u043d\u044b, \u043a\u0430\u0441\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043d\u0430\u0434\u0431\u0430\u0432\u043e\u043a \u0438 \u0434\u043e\u043f\u043b\u0430\u0442, \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u0430 \u0442\u0430\u043a\u0436\u0435 \u0434\u0440\u0443\u0433\u0438\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0434\u043e 15.02.2018 \u0433\u043e\u0434\u0430.    \u0413\u043b\u0430\u0432\u0435 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0438 \u0437\u0430\u043c\u0435\u0441\u0442\u0438\u0442\u0435\u043b\u044e \u0433\u043b\u0430\u0432\u044b \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043f\u043e \u0441\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u043e\u043b\u0438\u0442\u0438\u043a\u0438, \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u0435 \u0438 \u0441\u043f\u043e\u0440\u0442\u0443 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u043c \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u043c \u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u0438\"\n26,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u0438\u0439 \u0434\u0435\u0442\u0441\u043a\u0438\u0439 \u0441\u0430\u0434\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2017 \u0433. - 31.11.2017 \u0433.\",\"13.12.2017 \u0433.\",\"27.12.2017 \u0433.\",\"- \u0447.10 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0441\u0442.94, \u0441\u0442.95, \u0447.2 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;     - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043e\u0432 \u0432 \u0447\u0430\u0441\u0442\u0438 \u0441\u0440\u043e\u043a\u043e\u0432 \u043e\u043f\u043b\u0430\u0442\u044b.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.01.2018 \u0433\u043e\u0434\u0430\"\n27,\"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u043e\u0435 \u043e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435\",\"\u0410\u043d\u0430\u043b\u0438\u0437 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430                           \u0437\u0430 2016-2017 \u0433\u043e\u0434\u044b\",\"01.01.2016 \u0433. - 31.12.2017 \u0433.\",\"05.02.2018 \u0433.\",\"12.02.2018 \u0433.\",\"- \u0447. 1, 2, 4 \u0441\u0442.160.2-1 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438;                  - \u043f.3.1 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043e\u0442 30.10.2015 \u0433\u043e\u0434\u0430 \u2116569;                               - \u043f.\u043f.4, 16, 20, 22, 23, 28, 30, 37 \u043f\u043e\u0440\u044f\u0434\u043a\u0430 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438 (\u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438) \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0434\u043e\u0445\u043e\u0434\u043e\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0444\u0438\u043d\u0430\u043d\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u0444\u0438\u0446\u0438\u0442\u0430 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u0432\u044b\u0448\u0435\u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.03.2018 \u0433\u043e\u0434\u0430\"\n28,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041b\u0430\u0434\u043e\u043c\u0438\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2017 \u0433. - 31.01.2018 \u0433.\",\"05.02.2018 \u0433.\",\"26.02.2018 \u0433.\",\"- \u0447.8 \u0441\u0442.17, \u0447.10-11 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0447.3 \u0441\u0442.94, \u0441\u0442.95 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                          - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043e\u0432 \u0432 \u0447\u0430\u0441\u0442\u0438 \u0441\u0440\u043e\u043a\u043e\u0432 \u043e\u043f\u043b\u0430\u0442\u044b.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 26.03.2018 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 30.03.2018 \u0433\u043e\u0434\u0430\"\n29,\"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u0438 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0442\u0443\u0440\u0438\u0437\u043c\u0430 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u043e\u0435 \u043e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435\",\"\u0410\u043d\u0430\u043b\u0438\u0437 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430                           \u0437\u0430 2016-2017 \u0433\u043e\u0434\u044b\",\"01.01.2016 \u0433. - 31.12.2017 \u0433.\",\"21.02.2018 \u0433.\",\"02.03.2018 \u0433.\",\"- \u0447. 1, 2, 4, 5 \u0441\u0442.160.2-1 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438;                  - \u0447.3 \u0441\u0442.7 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.10.2003 \u0433\u043e\u0434\u0430 \u2116131-\u0424\u0417 \u00ab\u041e\u0431 \u043e\u0431\u0449\u0438\u0445 \u043f\u0440\u0438\u043d\u0446\u0438\u043f\u0430\u0445 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u0430\u043c\u043e\u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0432 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438\u00bb;                                                   - \u043f.3 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043e\u0442 30.10.2015 \u0433\u043e\u0434\u0430 \u2116569;                                                      - \u043f.\u043f.4, 14, 16-20, 22-23, 28-30, 37 \u043f\u043e\u0440\u044f\u0434\u043a\u0430 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438 (\u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438) \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0434\u043e\u0445\u043e\u0434\u043e\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0444\u0438\u043d\u0430\u043d\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u0444\u0438\u0446\u0438\u0442\u0430 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u0432\u044b\u0448\u0435\u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.04.2018 \u0433\u043e\u0434\u0430\"\n30,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u0434\u043e\u0448\u043a\u043e\u043b\u044c\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0425\u0430\u0440\u044c\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0434\u0435\u0442\u0441\u043a\u0438\u0439 \u0441\u0430\u0434 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2017 \u0433. - 31.03.2018 \u0433.\",\"06.04.2018 \u0433.\",\"16.04.2018 \u0433.\",\"- \u0447.4,6 \u0441\u0442.38, \u0447.8 \u0441\u0442.17, \u0447. 10,11,13 \u0441\u0442.21, \u0441\u0442.34, \u043f.4,6 \u0441\u0442.38, \u0447.2 \u0441\u0442.93, \u0447.9 \u0441\u0442.94, \u0447.2 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                             - \u043f.1 \u0441\u0442. 708 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424; - \u0447.2 \u0441\u0442.72 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u041a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                              - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 28.05.2018 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 31.05.2018 \u0433\u043e\u0434\u0430\"\n31,\"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430, \u043f\u0440\u0438\u0440\u043e\u0434\u043e\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438 \u0440\u0430\u0437\u0432\u0438\u0442\u0438\u044f \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0439\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2016 \u0433.-23.05.2018 \u0433.\",\"16.05.2018 \u0433.\",\"06.06.2018 \u0433.\",\"- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                            - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438  \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.07.2018 \u0433\u043e\u0434\u0430\"\n32,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u0434\u043e\u0448\u043a\u043e\u043b\u044c\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0425\u0430\u0440\u044c\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0434\u0435\u0442\u0441\u043a\u0438\u0439 \u0441\u0430\u0434 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2017 \u0433. - 31.03.2018 \u0433.\",\"14.03.2018 \u0433. \u043f\u0435\u0440\u0435\u0440\u044b\u0432\",\"21.06.2018 \u0433. 41 \u0440\u0430\u0431. \u0434\u0435\u043d\u044c\",\"- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438 \u0441\u0442.57, \u0441\u0442.60.1, \u0441\u0442.60.2, \u0447.3 \u0441\u0442.93, \u0441\u0442.100, \u0441\u0442.103, \u0447.1 \u0441\u0442.154, \u0441\u0442.284;                                             - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                            - \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 01.09.2018 \u0433\u043e\u0434\u0430\"\n33,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u0436\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e, \u0440\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u043d\u0430\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e\u0441\u044f \u0432 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u0438\",\"01.01.2017  - 30.06.2018 \u0433.\",\"09.07.2018 \u0433.\",\"27.07.2018 \u0433.\",\"- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                            - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424 \u0441\u0442.136, 284;      - \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.09.2018 \u0433\u043e\u0434\u0430\"\n34,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u0436\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f  \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2017 \u0433. - 31.07.2018 \u0433.\",\"02.08.2018 \u0433.\",\"16.08.2018 \u0433.\",\"- \u0447.4,6 \u0441\u0442.38, \u0447.7 \u0441\u0442.18, \u043f.4 \u0447.1 \u0441\u0442.93, \u0447.3,\u0447. 6 \u0441\u0442.94 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                          - \u0441\u0442.457, \u0441\u0442.506 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                                 - \u0447.2 \u0441\u0442.72, \u043f.1 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u041a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                   - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.09.2018 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 29.09.2018 \u0433\u043e\u0434\u0430\"\n35,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u0430\u044f \u0441\u043b\u0443\u0436\u0431\u0430 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043e\u0440\u0433\u0430\u043d\u043e\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u0430\u043c\u043e\u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0420\u0436\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430  \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f   \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2017 \u0433.  - 20.08.2018 \u0433.\",\"20.08.2018 \u0433.\",\"07.09.2018 \u0433.\",\"- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424 \u0441\u0442. 72, 100, 136;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u043e\u043f\u043b\u0430\u0442\u044b \u0442\u0440\u0443\u0434\u0430; - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u043f.3 ,11, 108, 265 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u2116157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.10.2018 \u0433\u043e\u0434\u0430\"\n36,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u0430\u044f \u0441\u043b\u0443\u0436\u0431\u0430 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043e\u0440\u0433\u0430\u043d\u043e\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u0430\u043c\u043e\u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u00ab\u041f\u043e\u0441\u0435\u043b\u043e\u043a \u0420\u043e\u0432\u0435\u043d\u044c\u043a\u0438\u00bb \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f   \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2017 \u0433.-31.10.2018 \u0433.\",\"15.10.2018 \u0433.\",\"12.11.2018 \u0433.\",\"- \u043d\u0435\u043e\u0431\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 828,7 \u0442\u044b\u0441. \u0440\u0443\u0431.;                                                      - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432 \u0443 1 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u044c\u043d\u043e-\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430 \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 139,9 \u0442\u044b\u0441. \u0440\u0443\u0431\u043b\u0435\u0439;                          - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0441\u0442.19,21 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u044b\u043c \u0437\u0430\u043a\u043e\u043d\u043e\u043c \u043e\u0442 5 \u0430\u043f\u0440\u0435\u043b\u044f 2013 \u0433\u043e\u0434\u0430 \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb \u0438 \u0447.2 \u0441\u0442.72 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                   -  \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424 \u0441\u0442.136 \u0438 \u0434\u0440\u0443\u0433\u0438\u0435  \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043e\u0431\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043f\u0435\u043d\u0441\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0445 \u0432\u044b\u043f\u043b\u0430\u0442 \u0437\u0430 \u0441\u043e\u0432\u043c\u0435\u0449\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0444\u0435\u0441\u0441\u0438\u0439 \u0438 \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u044b\u0439 \u043e\u0431\u044a\u0435\u043c.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.12.2018 \u0433\u043e\u0434\u0430\"";
            String expected = "\u2116\u041f\u041f\t\u041e\u0431\u044a\u0435\u043a\u0442\u044b\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e\u041c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\t\u0412\u0438\u0434\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e\u041c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\t\u0422\u0435\u043c\u0430\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e\u041c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\t\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c\u044b\u0439\u041f\u0435\u0440\u0438\u043e\u0434\t\u041d\u0430\u0447\u0430\u043b\u043e\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\t\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\t\u0412\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0435\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438\t\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\n";
            this.configureLoaderDefaults(textLoader, (byte)44, 0);
            textLoader.setForceHeaders(true);
            textLoader.setState(1);
            try {
                this.playText0(textLoader, csv, 1024, (index, len, b) -> {
                    switch (index) {
                        case 1560: 
                        case 1561: 
                        case 1562: {
                            return -96;
                        }
                    }
                    return b;
                });
                Assert.fail();
            }
            catch (CairoException e) {
                this.assertTable(expected);
            }
        });
    }

    @Test
    public void testBrokenUtf8Column() throws Exception {
        this.assertNoLeak(textLoader -> {
            String csv = "\"\u2116 \u043f/\u043f\",\"\u041e\u0431\u044a\u0435\u043a\u0442\u044b \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e \u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"\u0412\u0438\u0434 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e \u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"\u0422\u0435\u043c\u0430 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e \u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434\",\"\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\",\"\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\",\"\u0412\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f, \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438\",\"\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\"\n1,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0443\u043d\u0438\u0442\u0430\u0440\u043d\u043e\u0435 \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u0435 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0435 \u0442\u0435\u043f\u043b\u043e\u0432\u044b\u0435 \u0441\u0435\u0442\u0438\u00bb\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2015\u0433. - 31.12.2015\u0433.\",\"09.03.2016\u0433.\",\"01.04.2016\u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                          - \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432;                                            -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u044f.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.04.2016 \u0433\u043e\u0434\u0430\"\n2,\"\u041e\u0410\u041e \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0430\u044f \u0410\u041a \u21161468\u00bb\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u041e\u0410\u041e \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0430\u044f \u0410\u041a \u21161468\u00bb \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043d\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043e\u043a \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 \u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430\u043c \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u043e\u0442 31.12.2015 \u0433\u043e\u0434\u0430 \u2116 12-53\",\"01 - 29.02.16 \u0433.  01.01.2016 \u0433. -  31.01.2016 \u0433.,   01.03.2016 \u0433. - 30.04.2016 \u0433.\",\"04.04.2016\u0433.  10.05.2016\u0433.\",\"15.04.2016\u0433.  31.05.2016\u0433.\",\"\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043d\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \n\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043e\u043a \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 \u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430\u043c \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \n\u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u043e\u0442 31.12.2015 \u0433\u043e\u0434\u0430 \u211612-53    \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.06.2016 \u0433\u043e\u0434\u0430\"\n3,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438; \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\",\"01.01.2015 \u0433. -                   31.01.2016 \u0433.\",\"08.02.2016\u0433 \u043f\u0435\u0440\u0435\u0440\u044b\u0432 04.05.2016.\",\"04.03.2016\u0433. 38 \u0440\u0430\u0431. \u0434\u043d\u0435\u0439 06.05.2016\u0433.\",\"\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                               - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                             \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 01.07.2016 \u0433\u043e\u0434\u0430\"\n4,\"\u041c\u041a\u0423\u041a \u00ab\u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438; \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\",\"01.01.2015 \u0433. - 31.05.2016 \u0433.\",\"06.06.2016\u0433.\",\"27.06.2016\u0433.\",\"\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                                     \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 11.08.2016 \u0433\u043e\u0434\u0430\"\n5,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438, \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\",\"01.01.2015 \u0433. - 30.06.2016 \u0433.\",\"11.07.2016\u0433.\",\"29.07.2016\u0433.\",\"\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                                     \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 10.09.2016 \u0433\u043e\u0434\u0430\"\n6,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041c\u0424\u0426 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430\u00bb\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2015 \u0433. - 19.09.2016 \u0433.\",\"18.08.2016\u0433.\",\"19.09.2016\u0433.\",\"- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u041f\u0440\u0430\u0432\u0438\u043b \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043c\u043d\u043e\u0433\u043e\u0444\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0445 \u0446\u0435\u043d\u0442\u0440\u043e\u0432 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u041f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0420\u0424 \u043e\u0442 22.12.2012 \u0433\u043e\u0434\u0430 \u2116 1376.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.10.2016 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 07.11.2016 \u0433\u043e\u0434\u0430\"\n7,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2015 \u0433. - 31.08.2016 \u0433.\",\"22.09.2016\u0433.\",\"14.10.2016\u0433.\",\"\u0447.2 \u0441\u0442.34; \u043f.4 \u0441\u0442.38; \u0441\u0442.94; \u0441\u0442.95; \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;    - \u043f.1 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424- \u043f.1 \u0441\u0442.432; \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465; \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;           - \u043f.11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430 N 157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 21.11.2016 \u0433\u043e\u0434\u0430\"\n8,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2015 \u0433. - 31.08.2016 \u0433.\",\"22.09.2016\u0433.\",\"14.10.2016\u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                            - \u043d\u0435\u0446\u0435\u043b\u0435\u0432\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430;                                                     -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                   - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 14.12.2016 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 19.12.2016 \u0433\u043e\u0434\u0430\"\n9,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u00ab\u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2015\u0433 \u2014 31.10.2016\u0433\",\"01.11.2016 \u0433.\",\"11.11.2016 \u0433.\",\"\u0447.4 \u0441\u0442.30; \u0447.2 \u0441\u0442.34; \u043f.4 \u0441\u0442.38; \u0441\u0442.94; \u0447. 2, \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                           - \u043f.2 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;      - \u043f.1 \u0441\u0442.432; \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465; \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;           - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433.\u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                              - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  N 157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.12.2016 \u0433\u043e\u0434\u0430\"\n10,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u00ab\u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2015\u0433 \u2014 31.10.2016\u0433\",\"03.08.2016\u0433 \u043f\u0435\u0440\u0435\u0440\u044b\u0432 26.10.2016.\",\"18.08.2016\u0433. 48 \u0440\u0430\u0431. \u0434\u043d\u0435\u0439 11.11.2016\u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                           -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                  - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.01.2017 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 10.02.2017 \u0433\u043e\u0434\u0430\"\n11,\"\u041c\u0411\u0423\u0421\u041e\u0421\u0421\u0417\u041d \"\u041a\u043e\u043c\u043f\u043b\u0435\u043a\u0441\u043d\u044b\u0439 \u0446\u0435\u043d\u0442\u0440 \u0441\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u043d\u0430\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430\"\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2016\u0433 \u2014 30.11.2016\u0433\",\"19.12.2016 \u0433.\",\"29.12.2016 \u0433.\",\"\u0447.2 \u0441\u0442.34; \u0441\u0442.94; \u0447. 2, \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                -  \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                   - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433.\u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                             - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116 157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.01.2017 \u0433\u043e\u0434\u0430\"\n12,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2016 \u0433. -                   31.12.2016 \u0433.\",\"23.01.2017\u0433.\",\"15.02.2017 \u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                            - \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430;                                                     -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                   - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u043e\u0432 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 10.05.2017 \u0433\u043e\u0434\u0430\"\n13,\"\u041c\u041a\u0423\u041a \u00ab\u041b\u043e\u0437\u043e\u0432\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2015 \u0433. -                   31.12.2016 \u0433.\",\"20.02.2017\u0433.\",\"15.03.2017 \u0433.\",\"\u0447.2 \u0441\u0442.34, \u043f.4 \u0441\u0442.38, \u0441\u0442.93, \u0441\u0442.94, \u0441\u0442.95, \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;     - \u043f.2 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;       - \u043f.1 \u0441\u0442.432, \u043f.3 \u0441\u0442.455, \u043f.2 \u0441\u0442.465, \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;            - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                 - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116 157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439  \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.04.2017 \u0433\u043e\u0434\u0430\"\n14,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0440\u0430\u043d\u0435\u0435 \u0432\u044b\u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0433\u043b\u0430\u0432\u0435 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f\",\"-\",\"23.03.2017\u0433.\",\"23.03.2017 \u0433.\",\"\u041d\u0435\u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0432 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0439 \u0441\u0440\u043e\u043a \u0437\u0430\u043a\u043e\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432 \u0438 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0439 \u043f\u043e\u043b\u0438\u0442\u0438\u043a\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 (\u043f.4 \u0441\u0442. 270.2 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438).\",\"\u0421\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u043e\u0431 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u043c \u043f\u0440\u0430\u0432\u043e\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0438, \u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u044c \u0437\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0447\u0430\u0441\u0442\u044c\u044e 20 \u0441\u0442\u0430\u0442\u044c\u0438 19.5 \u041a\u043e\u0410\u041f \u0420\u0424. \u0414\u0435\u043b\u043e \u043e\u0431 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u043c \u043f\u0440\u0430\u0432\u043e\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0438 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0435\u0434\u0430\u0442\u0435\u043b\u044e \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u043d\u043e\u0433\u043e \u0441\u0443\u0434\u0430.\"\n15,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u043b\u0435\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2015\u0433.- 31.12.2016\u0433.\",\"20.03.2017\u0433.\",\"11.04.2017\u0433.\",\"- \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0432 \u0441\u0443\u043c\u043c\u0435 0,5 \u0442\u044b\u0441. \u0440\u0443\u0431\u043b\u0435\u0439;                                                  - \u0447.2 \u0441\u0442.34, \u0447.2 \u0441\u0442.93, \u0447.9 \u0441\u0442.94, \u0441\u0442.95, \u0447.2 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                                      - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439  \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.05.2017 \u0433\u043e\u0434\u0430\"\n16,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u043b\u0435\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438   \u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432, \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u043d\u0430 \u043e\u043a\u0430\u0437\u0430\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433\",\"01.01.2015 \u0433.-                  31.01.2016 \u0433.\",\"27.02.2017\u0433.\",\"11.04.2017\u0433.\",\"\u0412\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b. \u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438: \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u043d\u0435\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438  \u043e \u0441\u043e\u0441\u0442\u0430\u0432\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430 \u0438 \u0435\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438, \u0437\u0430\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u043d\u043e\u0440\u043c \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0413\u0421\u041c \u0438 \u043f\u0440\u043e\u0447\u0438\u0435. \u0412\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430 \u0438 \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 23.06.2017 \u0433\u043e\u0434\u0430\"\n17,\"\u041c\u0410\u0423 \u00ab\u041c\u0424\u0426 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438,  \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438 \u043e\u0442 14.10.2016 \u0433\u043e\u0434\u0430 \u21163001\",\"09.2016 \u0433.-05.2017 \u0433.\",\"19.04.2017\u0433\",\"19.05.2017 \u0433.\",\"\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b.                      \u0412\u044b\u044f\u0432\u043b\u0435\u043d\u043e \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 21.08.2017 \u0433\u043e\u0434\u0430\"\n18,\"\u041c\u0411\u041e\u0423 \u00ab\u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2016 \u0433. - 30.05.2017 \u0433.\",\"25.05.2017\u0433\",\"20.06.2017 \u0433.\",\"- \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u043f.4 \u0441\u0442.38, \u0447.2 \u0441\u0442.93, \u0447.9, 11 \u0441\u0442.94, \u0441\u0442.95 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                              - \u043f.3 \u0441\u0442.455, \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                       - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\",\"\u041f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\"\n19,\"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430, \u043f\u0440\u0438\u0440\u043e\u0434\u043e\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438 \u0440\u0430\u0437\u0432\u0438\u0442\u0438\u044f \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0439\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432, \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044e \u043f\u043e\u0434\u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b_5 \u00ab\u041e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b\u00bb \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u0430\u0437\u0432\u0438\u0442\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430 \u0432 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u043c \u0440\u0430\u0439\u043e\u043d\u0435 \u043d\u0430 2015-2020 \u0433\u043e\u0434\u044b\u00bb\",\"01.01.2016 \u0433. - 31.12.2016 \u0433.\",\"19.01.2017 \u0433. \u043f\u0435\u0440\u0435\u0440\u044b\u0432     01.06.2017 \u0433.\",\"20.01.2017 \u0433.  4\u043c\u0435\u0441. 11\u043a.\u0434\u043d.    07.07.2017 \u0433.\",\"\u041a\u0432\u0430\u0440\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u0438 \u0433\u043e\u0434\u043e\u0432\u043e\u0439 \u043e\u0442\u0447\u0435\u0442\u044b \u043e \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u00ab\u0420\u0430\u0437\u0432\u0438\u0442\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430 \u0432 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u043c \u0440\u0430\u0439\u043e\u043d\u0435 \u043d\u0430 2015-2020 \u0433\u043e\u0434\u044b\u00bb \u0437\u0430 2016 \u0433\u043e\u0434 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438.\",\"\u041f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\"\n20,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \"\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\" \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e, \u0440\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u043d\u0430\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e\u0441\u044f \u0432 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u0438\",\"01.07.2016 \u0433. - 30.06.2017 \u0433.\",\"03.07.2017 \u0433.\",\"04.08.2017 \u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;          - \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.09.2017 \u0433\u043e\u0434\u0430\"\n21,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041b\u043e\u0437\u043d\u044f\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2016 \u0433. - 31.07.2017 \u0433.\",\"07.08.2017 \u0433.\",\"25.08.2017 \u0433.\",\"- \u0447.10 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0447.2 \u0441\u0442.93, \u0447.9,11 \u0441\u0442.94, \u0441\u0442.95, \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                             - \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.09.2017 \u0433\u043e\u0434\u0430\"\n22,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0443\u0431\u0441\u0438\u0434\u0438\u0439 \u043d\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u0438 \u0441\u0443\u0431\u0441\u0438\u0434\u0438\u0439 \u043d\u0430 \u0438\u043d\u044b\u0435 \u0446\u0435\u043b\u0438\",\"01.01.2016 \u0433. - 31.08.2017 \u0433.\",\"01.09.2017 \u0433.\",\"25.09.2017 \u0433.\",\"\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043e\u0442\u0434\u0435\u043b\u044c\u043d\u044b\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f, \u043a\u0430\u0441\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.12.2017 \u0433\u043e\u0434\u0430\"\n23,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0438\u0436\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0430\u044f \u043e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2016 \u0433. - 31.09.2017 \u0433.\",\"12.10.2017 \u0433.\",\"27.10.2017 \u0433.\",\"- \u0447.10 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0447.9 \u0441\u0442.94, \u0441\u0442.95, \u0447.2,3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417\",\"\u041f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\"\n24,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u00ab\u0414\u0435\u0442\u0441\u043a\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u00bb \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u043e\u0435 \u043e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435\",\"\u041e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e \u0432\u043e\u043f\u0440\u043e\u0441\u0443 \u043e\u0431\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u043d\u043e\u0441\u0442\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0432\u044b\u043f\u043b\u0430\u0442 \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0433\u043e \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0430 \u0440\u0430\u0431\u043e\u0442\u043d\u0438\u043a\u0430\u043c \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f\",\"01.01.2017 \u0433. - 31.09.2017 \u0433.\",\"18.10.2017 \u0433.\",\"27.10.2017 \u0433.\",\"\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043e \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u0444\u043e\u043d\u0434\u0430 \u043e\u043f\u043b\u0430\u0442\u044b \u0442\u0440\u0443\u0434\u0430 (\u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u21163 \u043a \u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044e \u043e\u0431 \u043e\u043f\u043b\u0430\u0442\u0435 \u0442\u0440\u0443\u0434\u0430 \u0440\u0430\u0431\u043e\u0442\u043d\u0438\u043a\u043e\u0432 \u041c\u0411\u0423 \u0414\u041e  \u00ab\u0414\u0435\u0442\u0441\u043a\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u00bb \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043e\u0442 23.05.2017 \u0433. \u2116239) \u0438 \u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043e \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u0444\u043e\u043d\u0434\u0430 \u043e\u043f\u043b\u0430\u0442\u044b \u0442\u0440\u0443\u0434\u0430 \u041c\u0411\u0423 \u0414\u041e  \u00ab\u0414\u0435\u0442\u0441\u043a\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u00bb \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e 22.08.2017 \u0433.\",\"\u0412 \u0430\u0434\u0440\u0435\u0441 \u0443\u0447\u0440\u0435\u0434\u0438\u0442\u0435\u043b\u044f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0438\u0441\u044c\u043c\u043e \u0441 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f\u043c\u0438 \u043e \u043f\u0440\u0438\u043d\u044f\u0442\u0438\u0438 \u043c\u0435\u0440 \u043f\u043e \u043d\u0435\u0434\u043e\u043f\u0443\u0449\u0435\u043d\u0438\u044e \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u043d\u044b\u0445 \u0432 \u0437\u0430\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439\"\n25,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041f\u043b\u0430\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0431\u0430\u0441\u0441\u0435\u0439\u043d \u00ab\u0414\u0435\u043b\u044c\u0444\u0438\u043d\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.09.2016 \u0433. - 31.10.2017 \u0433.\",\"30.10.2017 \u0433.\",\"08.12.2017 \u0433.\",\"\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0439 \u0434\u0438\u0441\u0446\u0438\u043f\u043b\u0438\u043d\u044b, \u043a\u0430\u0441\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043d\u0430\u0434\u0431\u0430\u0432\u043e\u043a \u0438 \u0434\u043e\u043f\u043b\u0430\u0442, \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u0430 \u0442\u0430\u043a\u0436\u0435 \u0434\u0440\u0443\u0433\u0438\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0434\u043e 15.02.2018 \u0433\u043e\u0434\u0430.    \u0413\u043b\u0430\u0432\u0435 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0438 \u0437\u0430\u043c\u0435\u0441\u0442\u0438\u0442\u0435\u043b\u044e \u0433\u043b\u0430\u0432\u044b \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043f\u043e \u0441\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u043e\u043b\u0438\u0442\u0438\u043a\u0438, \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u0435 \u0438 \u0441\u043f\u043e\u0440\u0442\u0443 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u043c \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u043c \u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u0438\"\n26,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u0438\u0439 \u0434\u0435\u0442\u0441\u043a\u0438\u0439 \u0441\u0430\u0434\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2017 \u0433. - 31.11.2017 \u0433.\",\"13.12.2017 \u0433.\",\"27.12.2017 \u0433.\",\"- \u0447.10 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0441\u0442.94, \u0441\u0442.95, \u0447.2 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;     - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043e\u0432 \u0432 \u0447\u0430\u0441\u0442\u0438 \u0441\u0440\u043e\u043a\u043e\u0432 \u043e\u043f\u043b\u0430\u0442\u044b.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.01.2018 \u0433\u043e\u0434\u0430\"\n27,\"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u043e\u0435 \u043e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435\",\"\u0410\u043d\u0430\u043b\u0438\u0437 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430                           \u0437\u0430 2016-2017 \u0433\u043e\u0434\u044b\",\"01.01.2016 \u0433. - 31.12.2017 \u0433.\",\"05.02.2018 \u0433.\",\"12.02.2018 \u0433.\",\"- \u0447. 1, 2, 4 \u0441\u0442.160.2-1 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438;                  - \u043f.3.1 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043e\u0442 30.10.2015 \u0433\u043e\u0434\u0430 \u2116569;                               - \u043f.\u043f.4, 16, 20, 22, 23, 28, 30, 37 \u043f\u043e\u0440\u044f\u0434\u043a\u0430 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438 (\u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438) \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0434\u043e\u0445\u043e\u0434\u043e\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0444\u0438\u043d\u0430\u043d\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u0444\u0438\u0446\u0438\u0442\u0430 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u0432\u044b\u0448\u0435\u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.03.2018 \u0433\u043e\u0434\u0430\"\n28,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041b\u0430\u0434\u043e\u043c\u0438\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2017 \u0433. - 31.01.2018 \u0433.\",\"05.02.2018 \u0433.\",\"26.02.2018 \u0433.\",\"- \u0447.8 \u0441\u0442.17, \u0447.10-11 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0447.3 \u0441\u0442.94, \u0441\u0442.95 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                          - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043e\u0432 \u0432 \u0447\u0430\u0441\u0442\u0438 \u0441\u0440\u043e\u043a\u043e\u0432 \u043e\u043f\u043b\u0430\u0442\u044b.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 26.03.2018 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 30.03.2018 \u0433\u043e\u0434\u0430\"\n29,\"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u0438 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0442\u0443\u0440\u0438\u0437\u043c\u0430 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u043e\u0435 \u043e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435\",\"\u0410\u043d\u0430\u043b\u0438\u0437 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430                           \u0437\u0430 2016-2017 \u0433\u043e\u0434\u044b\",\"01.01.2016 \u0433. - 31.12.2017 \u0433.\",\"21.02.2018 \u0433.\",\"02.03.2018 \u0433.\",\"- \u0447. 1, 2, 4, 5 \u0441\u0442.160.2-1 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438;                  - \u0447.3 \u0441\u0442.7 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.10.2003 \u0433\u043e\u0434\u0430 \u2116131-\u0424\u0417 \u00ab\u041e\u0431 \u043e\u0431\u0449\u0438\u0445 \u043f\u0440\u0438\u043d\u0446\u0438\u043f\u0430\u0445 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u0430\u043c\u043e\u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0432 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438\u00bb;                                                   - \u043f.3 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043e\u0442 30.10.2015 \u0433\u043e\u0434\u0430 \u2116569;                                                      - \u043f.\u043f.4, 14, 16-20, 22-23, 28-30, 37 \u043f\u043e\u0440\u044f\u0434\u043a\u0430 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438 (\u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438) \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0434\u043e\u0445\u043e\u0434\u043e\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0444\u0438\u043d\u0430\u043d\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u0444\u0438\u0446\u0438\u0442\u0430 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u0432\u044b\u0448\u0435\u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.04.2018 \u0433\u043e\u0434\u0430\"\n30,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u0434\u043e\u0448\u043a\u043e\u043b\u044c\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0425\u0430\u0440\u044c\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0434\u0435\u0442\u0441\u043a\u0438\u0439 \u0441\u0430\u0434 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2017 \u0433. - 31.03.2018 \u0433.\",\"06.04.2018 \u0433.\",\"16.04.2018 \u0433.\",\"- \u0447.4,6 \u0441\u0442.38, \u0447.8 \u0441\u0442.17, \u0447. 10,11,13 \u0441\u0442.21, \u0441\u0442.34, \u043f.4,6 \u0441\u0442.38, \u0447.2 \u0441\u0442.93, \u0447.9 \u0441\u0442.94, \u0447.2 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                             - \u043f.1 \u0441\u0442. 708 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424; - \u0447.2 \u0441\u0442.72 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u041a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                              - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 28.05.2018 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 31.05.2018 \u0433\u043e\u0434\u0430\"\n31,\"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430, \u043f\u0440\u0438\u0440\u043e\u0434\u043e\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438 \u0440\u0430\u0437\u0432\u0438\u0442\u0438\u044f \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0439\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2016 \u0433.-23.05.2018 \u0433.\",\"16.05.2018 \u0433.\",\"06.06.2018 \u0433.\",\"- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                            - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438  \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.07.2018 \u0433\u043e\u0434\u0430\"\n32,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u0434\u043e\u0448\u043a\u043e\u043b\u044c\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0425\u0430\u0440\u044c\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0434\u0435\u0442\u0441\u043a\u0438\u0439 \u0441\u0430\u0434 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2017 \u0433. - 31.03.2018 \u0433.\",\"14.03.2018 \u0433. \u043f\u0435\u0440\u0435\u0440\u044b\u0432\",\"21.06.2018 \u0433. 41 \u0440\u0430\u0431. \u0434\u0435\u043d\u044c\",\"- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438 \u0441\u0442.57, \u0441\u0442.60.1, \u0441\u0442.60.2, \u0447.3 \u0441\u0442.93, \u0441\u0442.100, \u0441\u0442.103, \u0447.1 \u0441\u0442.154, \u0441\u0442.284;                                             - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                            - \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 01.09.2018 \u0433\u043e\u0434\u0430\"\n33,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u0436\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e, \u0440\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u043d\u0430\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e\u0441\u044f \u0432 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u0438\",\"01.01.2017  - 30.06.2018 \u0433.\",\"09.07.2018 \u0433.\",\"27.07.2018 \u0433.\",\"- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                            - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424 \u0441\u0442.136, 284;      - \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.09.2018 \u0433\u043e\u0434\u0430\"\n34,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u0436\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f  \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2017 \u0433. - 31.07.2018 \u0433.\",\"02.08.2018 \u0433.\",\"16.08.2018 \u0433.\",\"- \u0447.4,6 \u0441\u0442.38, \u0447.7 \u0441\u0442.18, \u043f.4 \u0447.1 \u0441\u0442.93, \u0447.3,\u0447. 6 \u0441\u0442.94 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                          - \u0441\u0442.457, \u0441\u0442.506 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                                 - \u0447.2 \u0441\u0442.72, \u043f.1 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u041a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                   - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.09.2018 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 29.09.2018 \u0433\u043e\u0434\u0430\"\n35,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u0430\u044f \u0441\u043b\u0443\u0436\u0431\u0430 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043e\u0440\u0433\u0430\u043d\u043e\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u0430\u043c\u043e\u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0420\u0436\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430  \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f   \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2017 \u0433.  - 20.08.2018 \u0433.\",\"20.08.2018 \u0433.\",\"07.09.2018 \u0433.\",\"- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424 \u0441\u0442. 72, 100, 136;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u043e\u043f\u043b\u0430\u0442\u044b \u0442\u0440\u0443\u0434\u0430; - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u043f.3 ,11, 108, 265 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u2116157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.10.2018 \u0433\u043e\u0434\u0430\"\n36,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u0430\u044f \u0441\u043b\u0443\u0436\u0431\u0430 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043e\u0440\u0433\u0430\u043d\u043e\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u0430\u043c\u043e\u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u00ab\u041f\u043e\u0441\u0435\u043b\u043e\u043a \u0420\u043e\u0432\u0435\u043d\u044c\u043a\u0438\u00bb \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f   \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2017 \u0433.-31.10.2018 \u0433.\",\"15.10.2018 \u0433.\",\"12.11.2018 \u0433.\",\"- \u043d\u0435\u043e\u0431\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 828,7 \u0442\u044b\u0441. \u0440\u0443\u0431.;                                                      - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432 \u0443 1 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u044c\u043d\u043e-\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430 \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 139,9 \u0442\u044b\u0441. \u0440\u0443\u0431\u043b\u0435\u0439;                          - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0441\u0442.19,21 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u044b\u043c \u0437\u0430\u043a\u043e\u043d\u043e\u043c \u043e\u0442 5 \u0430\u043f\u0440\u0435\u043b\u044f 2013 \u0433\u043e\u0434\u0430 \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb \u0438 \u0447.2 \u0441\u0442.72 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                   -  \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424 \u0441\u0442.136 \u0438 \u0434\u0440\u0443\u0433\u0438\u0435  \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043e\u0431\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043f\u0435\u043d\u0441\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0445 \u0432\u044b\u043f\u043b\u0430\u0442 \u0437\u0430 \u0441\u043e\u0432\u043c\u0435\u0449\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0444\u0435\u0441\u0441\u0438\u0439 \u0438 \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u044b\u0439 \u043e\u0431\u044a\u0435\u043c.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.12.2018 \u0433\u043e\u0434\u0430\"";
            String expected = "\u2116\u041f\u041f\t\u041e\u0431\u044a\u0435\u043a\u0442\u044b\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e\u041c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\t\u0412\u0438\u0434\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e\u041c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\t\u0422\u0435\u043c\u0430\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e\u041c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\t\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c\u044b\u0439\u041f\u0435\u0440\u0438\u043e\u0434\t\u041d\u0430\u0447\u0430\u043b\u043e\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\t\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\t\u0412\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0435\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438\t\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\n1\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0443\u043d\u0438\u0442\u0430\u0440\u043d\u043e\u0435 \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u0435 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0435 \u0442\u0435\u043f\u043b\u043e\u0432\u044b\u0435 \u0441\u0435\u0442\u0438\u00bb\t\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2015\u0433. - 31.12.2015\u0433.\t09.03.2016\u0433.\t01.04.2016\u0433.\t-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                          - \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432;                                            -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u044f.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.04.2016 \u0433\u043e\u0434\u0430\n2\t\u041e\u0410\u041e \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0430\u044f \u0410\u041a \u21161468\u00bb\t\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\t01 - 29.02.16 \u0433.  01.01.2016 \u0433. -  31.01.2016 \u0433.,   01.03.2016 \u0433. - 30.04.2016 \u0433.\t04.04.2016\u0433.  10.05.2016\u0433.\t15.04.2016\u0433.  31.05.2016\u0433.\t\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043d\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \n\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043e\u043a \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 \u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430\u043c \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \n\u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u043e\u0442 31.12.2015 \u0433\u043e\u0434\u0430 \u211612-53    \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.06.2016 \u0433\u043e\u0434\u0430\n3\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438; \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\t01.01.2015 \u0433. -                   31.01.2016 \u0433.\t08.02.2016\u0433 \u043f\u0435\u0440\u0435\u0440\u044b\u0432 04.05.2016.\t04.03.2016\u0433. 38 \u0440\u0430\u0431. \u0434\u043d\u0435\u0439 06.05.2016\u0433.\t\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                               - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                             \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 01.07.2016 \u0433\u043e\u0434\u0430\n4\t\u041c\u041a\u0423\u041a \u00ab\u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438; \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\t01.01.2015 \u0433. - 31.05.2016 \u0433.\t06.06.2016\u0433.\t27.06.2016\u0433.\t\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                                     \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 11.08.2016 \u0433\u043e\u0434\u0430\n5\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438, \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\t01.01.2015 \u0433. - 30.06.2016 \u0433.\t11.07.2016\u0433.\t29.07.2016\u0433.\t\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                                     \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 10.09.2016 \u0433\u043e\u0434\u0430\n6\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041c\u0424\u0426 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430\u00bb\t\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2015 \u0433. - 19.09.2016 \u0433.\t18.08.2016\u0433.\t19.09.2016\u0433.\t- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u041f\u0440\u0430\u0432\u0438\u043b \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043c\u043d\u043e\u0433\u043e\u0444\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0445 \u0446\u0435\u043d\u0442\u0440\u043e\u0432 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u041f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0420\u0424 \u043e\u0442 22.12.2012 \u0433\u043e\u0434\u0430 \u2116 1376.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.10.2016 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 07.11.2016 \u0433\u043e\u0434\u0430\n7\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\t01.01.2015 \u0433. - 31.08.2016 \u0433.\t22.09.2016\u0433.\t14.10.2016\u0433.\t\u0447.2 \u0441\u0442.34; \u043f.4 \u0441\u0442.38; \u0441\u0442.94; \u0441\u0442.95; \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;    - \u043f.1 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424- \u043f.1 \u0441\u0442.432; \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465; \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;           - \u043f.11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430 N 157\u043d.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 21.11.2016 \u0433\u043e\u0434\u0430\n8\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2015 \u0433. - 31.08.2016 \u0433.\t22.09.2016\u0433.\t14.10.2016\u0433.\t-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                            - \u043d\u0435\u0446\u0435\u043b\u0435\u0432\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430;                                                     -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                   - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 14.12.2016 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 19.12.2016 \u0433\u043e\u0434\u0430\n9\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u00ab\u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\t01.01.2015\u0433 \u2014 31.10.2016\u0433\t01.11.2016 \u0433.\t11.11.2016 \u0433.\t\u0447.4 \u0441\u0442.30; \u0447.2 \u0441\u0442.34; \u043f.4 \u0441\u0442.38; \u0441\u0442.94; \u0447. 2, \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                           - \u043f.2 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;      - \u043f.1 \u0441\u0442.432; \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465; \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;           - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433.\u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                              - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  N 157\u043d.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.12.2016 \u0433\u043e\u0434\u0430\n10\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u00ab\u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2015\u0433 \u2014 31.10.2016\u0433\t03.08.2016\u0433 \u043f\u0435\u0440\u0435\u0440\u044b\u0432 26.10.2016.\t18.08.2016\u0433. 48 \u0440\u0430\u0431. \u0434\u043d\u0435\u0439 11.11.2016\u0433.\t-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                           -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                  - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.01.2017 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 10.02.2017 \u0433\u043e\u0434\u0430\n11\t\u041c\u0411\u0423\u0421\u041e\u0421\u0421\u0417\u041d \t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\t01.01.2016\u0433 \u2014 30.11.2016\u0433\t19.12.2016 \u0433.\t29.12.2016 \u0433.\t\u0447.2 \u0441\u0442.34; \u0441\u0442.94; \u0447. 2, \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                -  \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                   - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433.\u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                             - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116 157\u043d.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.01.2017 \u0433\u043e\u0434\u0430\n12\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2016 \u0433. -                   31.12.2016 \u0433.\t23.01.2017\u0433.\t15.02.2017 \u0433.\t-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                            - \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430;                                                     -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                   - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u043e\u0432 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 10.05.2017 \u0433\u043e\u0434\u0430\n13\t\u041c\u041a\u0423\u041a \u00ab\u041b\u043e\u0437\u043e\u0432\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\t01.01.2015 \u0433. -                   31.12.2016 \u0433.\t20.02.2017\u0433.\t15.03.2017 \u0433.\t\u0447.2 \u0441\u0442.34, \u043f.4 \u0441\u0442.38, \u0441\u0442.93, \u0441\u0442.94, \u0441\u0442.95, \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;     - \u043f.2 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;       - \u043f.1 \u0441\u0442.432, \u043f.3 \u0441\u0442.455, \u043f.2 \u0441\u0442.465, \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;            - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                 - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116 157\u043d.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439  \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.04.2017 \u0433\u043e\u0434\u0430\n14\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0440\u0430\u043d\u0435\u0435 \u0432\u044b\u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0433\u043b\u0430\u0432\u0435 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f\t-\t23.03.2017\u0433.\t23.03.2017 \u0433.\t\u041d\u0435\u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0432 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0439 \u0441\u0440\u043e\u043a \u0437\u0430\u043a\u043e\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432 \u0438 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0439 \u043f\u043e\u043b\u0438\u0442\u0438\u043a\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 (\u043f.4 \u0441\u0442. 270.2 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438).\t\u0421\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u043e\u0431 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u043c \u043f\u0440\u0430\u0432\u043e\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0438, \u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u044c \u0437\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0447\u0430\u0441\u0442\u044c\u044e 20 \u0441\u0442\u0430\u0442\u044c\u0438 19.5 \u041a\u043e\u0410\u041f \u0420\u0424. \u0414\u0435\u043b\u043e \u043e\u0431 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u043c \u043f\u0440\u0430\u0432\u043e\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0438 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0435\u0434\u0430\u0442\u0435\u043b\u044e \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u043d\u043e\u0433\u043e \u0441\u0443\u0434\u0430.\n15\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u043b\u0435\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\t01.01.2015\u0433.- 31.12.2016\u0433.\t20.03.2017\u0433.\t11.04.2017\u0433.\t- \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0432 \u0441\u0443\u043c\u043c\u0435 0,5 \u0442\u044b\u0441. \u0440\u0443\u0431\u043b\u0435\u0439;                                                  - \u0447.2 \u0441\u0442.34, \u0447.2 \u0441\u0442.93, \u0447.9 \u0441\u0442.94, \u0441\u0442.95, \u0447.2 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                                      - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439  \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.05.2017 \u0433\u043e\u0434\u0430\n16\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u043b\u0435\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438   \u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432, \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u043d\u0430 \u043e\u043a\u0430\u0437\u0430\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433\t01.01.2015 \u0433.-                  31.01.2016 \u0433.\t27.02.2017\u0433.\t11.04.2017\u0433.\t\u0412\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b. \u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438: \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u043d\u0435\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438  \u043e \u0441\u043e\u0441\u0442\u0430\u0432\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430 \u0438 \u0435\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438, \u0437\u0430\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u043d\u043e\u0440\u043c \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0413\u0421\u041c \u0438 \u043f\u0440\u043e\u0447\u0438\u0435. \u0412\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430 \u0438 \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 23.06.2017 \u0433\u043e\u0434\u0430\n17\t\u041c\u0410\u0423 \u00ab\u041c\u0424\u0426 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438,  \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438 \u043e\u0442 14.10.2016 \u0433\u043e\u0434\u0430 \u21163001\t09.2016 \u0433.-05.2017 \u0433.\t19.04.2017\u0433\t19.05.2017 \u0433.\t\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b.                      \u0412\u044b\u044f\u0432\u043b\u0435\u043d\u043e \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 21.08.2017 \u0433\u043e\u0434\u0430\n18\t\u041c\u0411\u041e\u0423 \u00ab\u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\t01.01.2016 \u0433. - 30.05.2017 \u0433.\t25.05.2017\u0433\t20.06.2017 \u0433.\t- \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u043f.4 \u0441\u0442.38, \u0447.2 \u0441\u0442.93, \u0447.9, 11 \u0441\u0442.94, \u0441\u0442.95 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                              - \u043f.3 \u0441\u0442.455, \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                       - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\t\u041f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\n19\t\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430, \u043f\u0440\u0438\u0440\u043e\u0434\u043e\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438 \u0440\u0430\u0437\u0432\u0438\u0442\u0438\u044f \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0439\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432, \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044e \u043f\u043e\u0434\u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b_5 \u00ab\u041e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b\u00bb \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u0430\u0437\u0432\u0438\u0442\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430 \u0432 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u043c \u0440\u0430\u0439\u043e\u043d\u0435 \u043d\u0430 2015-2020 \u0433\u043e\u0434\u044b\u00bb\t01.01.2016 \u0433. - 31.12.2016 \u0433.\t19.01.2017 \u0433. \u043f\u0435\u0440\u0435\u0440\u044b\u0432     01.06.2017 \u0433.\t20.01.2017 \u0433.  4\u043c\u0435\u0441. 11\u043a.\u0434\u043d.    07.07.2017 \u0433.\t\u041a\u0432\u0430\u0440\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u0438 \u0433\u043e\u0434\u043e\u0432\u043e\u0439 \u043e\u0442\u0447\u0435\u0442\u044b \u043e \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u00ab\u0420\u0430\u0437\u0432\u0438\u0442\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430 \u0432 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u043c \u0440\u0430\u0439\u043e\u043d\u0435 \u043d\u0430 2015-2020 \u0433\u043e\u0434\u044b\u00bb \u0437\u0430 2016 \u0433\u043e\u0434 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438.\t\u041f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\n20\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e, \u0440\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u043d\u0430\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e\u0441\u044f \u0432 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u0438\t01.07.2016 \u0433. - 30.06.2017 \u0433.\t03.07.2017 \u0433.\t04.08.2017 \u0433.\t-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;          - \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.09.2017 \u0433\u043e\u0434\u0430\n21\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041b\u043e\u0437\u043d\u044f\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\t01.01.2016 \u0433. - 31.07.2017 \u0433.\t07.08.2017 \u0433.\t25.08.2017 \u0433.\t- \u0447.10 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0447.2 \u0441\u0442.93, \u0447.9,11 \u0441\u0442.94, \u0441\u0442.95, \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                             - \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.09.2017 \u0433\u043e\u0434\u0430\n22\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0443\u0431\u0441\u0438\u0434\u0438\u0439 \u043d\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u0438 \u0441\u0443\u0431\u0441\u0438\u0434\u0438\u0439 \u043d\u0430 \u0438\u043d\u044b\u0435 \u0446\u0435\u043b\u0438\t01.01.2016 \u0433. - 31.08.2017 \u0433.\t01.09.2017 \u0433.\t25.09.2017 \u0433.\t\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043e\u0442\u0434\u0435\u043b\u044c\u043d\u044b\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f, \u043a\u0430\u0441\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.12.2017 \u0433\u043e\u0434\u0430\n23\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0438\u0436\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0430\u044f \u043e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\t01.01.2016 \u0433. - 31.09.2017 \u0433.\t12.10.2017 \u0433.\t27.10.2017 \u0433.\t- \u0447.10 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0447.9 \u0441\u0442.94, \u0441\u0442.95, \u0447.2,3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417\t\u041f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\n24\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u00ab\u0414\u0435\u0442\u0441\u043a\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u00bb \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u043e\u0435 \u043e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435\t\u041e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e \u0432\u043e\u043f\u0440\u043e\u0441\u0443 \u043e\u0431\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u043d\u043e\u0441\u0442\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0432\u044b\u043f\u043b\u0430\u0442 \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0433\u043e \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0430 \u0440\u0430\u0431\u043e\u0442\u043d\u0438\u043a\u0430\u043c \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f\t01.01.2017 \u0433. - 31.09.2017 \u0433.\t18.10.2017 \u0433.\t27.10.2017 \u0433.\t\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043e \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u0444\u043e\u043d\u0434\u0430 \u043e\u043f\u043b\u0430\u0442\u044b \u0442\u0440\u0443\u0434\u0430 (\u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u21163 \u043a \u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044e \u043e\u0431 \u043e\u043f\u043b\u0430\u0442\u0435 \u0442\u0440\u0443\u0434\u0430 \u0440\u0430\u0431\u043e\u0442\u043d\u0438\u043a\u043e\u0432 \u041c\u0411\u0423 \u0414\u041e  \u00ab\u0414\u0435\u0442\u0441\u043a\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u00bb \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043e\u0442 23.05.2017 \u0433. \u2116239) \u0438 \u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043e \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u0444\u043e\u043d\u0434\u0430 \u043e\u043f\u043b\u0430\u0442\u044b \u0442\u0440\u0443\u0434\u0430 \u041c\u0411\u0423 \u0414\u041e  \u00ab\u0414\u0435\u0442\u0441\u043a\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u00bb \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e 22.08.2017 \u0433.\t\u0412 \u0430\u0434\u0440\u0435\u0441 \u0443\u0447\u0440\u0435\u0434\u0438\u0442\u0435\u043b\u044f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0438\u0441\u044c\u043c\u043e \u0441 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f\u043c\u0438 \u043e \u043f\u0440\u0438\u043d\u044f\u0442\u0438\u0438 \u043c\u0435\u0440 \u043f\u043e \u043d\u0435\u0434\u043e\u043f\u0443\u0449\u0435\u043d\u0438\u044e \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u043d\u044b\u0445 \u0432 \u0437\u0430\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439\n25\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041f\u043b\u0430\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0431\u0430\u0441\u0441\u0435\u0439\u043d \u00ab\u0414\u0435\u043b\u044c\u0444\u0438\u043d\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.09.2016 \u0433. - 31.10.2017 \u0433.\t30.10.2017 \u0433.\t08.12.2017 \u0433.\t\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0439 \u0434\u0438\u0441\u0446\u0438\u043f\u043b\u0438\u043d\u044b, \u043a\u0430\u0441\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043d\u0430\u0434\u0431\u0430\u0432\u043e\u043a \u0438 \u0434\u043e\u043f\u043b\u0430\u0442, \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u0430 \u0442\u0430\u043a\u0436\u0435 \u0434\u0440\u0443\u0433\u0438\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0434\u043e 15.02.2018 \u0433\u043e\u0434\u0430.    \u0413\u043b\u0430\u0432\u0435 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0438 \u0437\u0430\u043c\u0435\u0441\u0442\u0438\u0442\u0435\u043b\u044e \u0433\u043b\u0430\u0432\u044b \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043f\u043e \u0441\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u043e\u043b\u0438\u0442\u0438\u043a\u0438, \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u0435 \u0438 \u0441\u043f\u043e\u0440\u0442\u0443 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u043c \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u043c \u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u0438\n26\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u0438\u0439 \u0434\u0435\u0442\u0441\u043a\u0438\u0439 \u0441\u0430\u0434\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\t01.01.2017 \u0433. - 31.11.2017 \u0433.\t13.12.2017 \u0433.\t27.12.2017 \u0433.\t- \u0447.10 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0441\u0442.94, \u0441\u0442.95, \u0447.2 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;     - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043e\u0432 \u0432 \u0447\u0430\u0441\u0442\u0438 \u0441\u0440\u043e\u043a\u043e\u0432 \u043e\u043f\u043b\u0430\u0442\u044b.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.01.2018 \u0433\u043e\u0434\u0430\n27\t\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u043e\u0435 \u043e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435\t\u0410\u043d\u0430\u043b\u0438\u0437 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430                           \u0437\u0430 2016-2017 \u0433\u043e\u0434\u044b\t01.01.2016 \u0433. - 31.12.2017 \u0433.\t05.02.2018 \u0433.\t12.02.2018 \u0433.\t- \u0447. 1, 2, 4 \u0441\u0442.160.2-1 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438;                  - \u043f.3.1 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043e\u0442 30.10.2015 \u0433\u043e\u0434\u0430 \u2116569;                               - \u043f.\u043f.4, 16, 20, 22, 23, 28, 30, 37 \u043f\u043e\u0440\u044f\u0434\u043a\u0430 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438 (\u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438) \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0434\u043e\u0445\u043e\u0434\u043e\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0444\u0438\u043d\u0430\u043d\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u0444\u0438\u0446\u0438\u0442\u0430 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u0432\u044b\u0448\u0435\u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.03.2018 \u0433\u043e\u0434\u0430\n28\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041b\u0430\u0434\u043e\u043c\u0438\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\t01.01.2017 \u0433. - 31.01.2018 \u0433.\t05.02.2018 \u0433.\t26.02.2018 \u0433.\t- \u0447.8 \u0441\u0442.17, \u0447.10-11 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0447.3 \u0441\u0442.94, \u0441\u0442.95 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                          - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043e\u0432 \u0432 \u0447\u0430\u0441\u0442\u0438 \u0441\u0440\u043e\u043a\u043e\u0432 \u043e\u043f\u043b\u0430\u0442\u044b.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 26.03.2018 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 30.03.2018 \u0433\u043e\u0434\u0430\n29\t\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u0438 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0442\u0443\u0440\u0438\u0437\u043c\u0430 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u043e\u0435 \u043e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435\t\u0410\u043d\u0430\u043b\u0438\u0437 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430                           \u0437\u0430 2016-2017 \u0433\u043e\u0434\u044b\t01.01.2016 \u0433. - 31.12.2017 \u0433.\t21.02.2018 \u0433.\t02.03.2018 \u0433.\t- \u0447. 1, 2, 4, 5 \u0441\u0442.160.2-1 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438;                  - \u0447.3 \u0441\u0442.7 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.10.2003 \u0433\u043e\u0434\u0430 \u2116131-\u0424\u0417 \u00ab\u041e\u0431 \u043e\u0431\u0449\u0438\u0445 \u043f\u0440\u0438\u043d\u0446\u0438\u043f\u0430\u0445 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u0430\u043c\u043e\u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0432 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438\u00bb;                                                   - \u043f.3 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043e\u0442 30.10.2015 \u0433\u043e\u0434\u0430 \u2116569;                                                      - \u043f.\u043f.4, 14, 16-20, 22-23, 28-30, 37 \u043f\u043e\u0440\u044f\u0434\u043a\u0430 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438 (\u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438) \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0434\u043e\u0445\u043e\u0434\u043e\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0444\u0438\u043d\u0430\u043d\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u0444\u0438\u0446\u0438\u0442\u0430 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u0432\u044b\u0448\u0435\u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.04.2018 \u0433\u043e\u0434\u0430\n30\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u0434\u043e\u0448\u043a\u043e\u043b\u044c\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0425\u0430\u0440\u044c\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0434\u0435\u0442\u0441\u043a\u0438\u0439 \u0441\u0430\u0434 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\t01.01.2017 \u0433. - 31.03.2018 \u0433.\t06.04.2018 \u0433.\t16.04.2018 \u0433.\t- \u0447.4,6 \u0441\u0442.38, \u0447.8 \u0441\u0442.17, \u0447. 10,11,13 \u0441\u0442.21, \u0441\u0442.34, \u043f.4,6 \u0441\u0442.38, \u0447.2 \u0441\u0442.93, \u0447.9 \u0441\u0442.94, \u0447.2 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                             - \u043f.1 \u0441\u0442. 708 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424; - \u0447.2 \u0441\u0442.72 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u041a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                              - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 28.05.2018 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 31.05.2018 \u0433\u043e\u0434\u0430\n31\t\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430, \u043f\u0440\u0438\u0440\u043e\u0434\u043e\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438 \u0440\u0430\u0437\u0432\u0438\u0442\u0438\u044f \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0439\t\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2016 \u0433.-23.05.2018 \u0433.\t16.05.2018 \u0433.\t06.06.2018 \u0433.\t- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                            - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438  \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.07.2018 \u0433\u043e\u0434\u0430\n32\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u0434\u043e\u0448\u043a\u043e\u043b\u044c\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0425\u0430\u0440\u044c\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0434\u0435\u0442\u0441\u043a\u0438\u0439 \u0441\u0430\u0434 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2017 \u0433. - 31.03.2018 \u0433.\t14.03.2018 \u0433. \u043f\u0435\u0440\u0435\u0440\u044b\u0432\t21.06.2018 \u0433. 41 \u0440\u0430\u0431. \u0434\u0435\u043d\u044c\t- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438 \u0441\u0442.57, \u0441\u0442.60.1, \u0441\u0442.60.2, \u0447.3 \u0441\u0442.93, \u0441\u0442.100, \u0441\u0442.103, \u0447.1 \u0441\u0442.154, \u0441\u0442.284;                                             - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                            - \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 01.09.2018 \u0433\u043e\u0434\u0430\n33\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u0436\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e, \u0440\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u043d\u0430\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e\u0441\u044f \u0432 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u0438\t01.01.2017  - 30.06.2018 \u0433.\t09.07.2018 \u0433.\t27.07.2018 \u0433.\t- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                            - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424 \u0441\u0442.136, 284;      - \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.09.2018 \u0433\u043e\u0434\u0430\n34\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u0436\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f  \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\t01.01.2017 \u0433. - 31.07.2018 \u0433.\t02.08.2018 \u0433.\t16.08.2018 \u0433.\t- \u0447.4,6 \u0441\u0442.38, \u0447.7 \u0441\u0442.18, \u043f.4 \u0447.1 \u0441\u0442.93, \u0447.3,\u0447. 6 \u0441\u0442.94 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                          - \u0441\u0442.457, \u0441\u0442.506 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                                 - \u0447.2 \u0441\u0442.72, \u043f.1 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u041a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                   - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.09.2018 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 29.09.2018 \u0433\u043e\u0434\u0430\n35\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u0430\u044f \u0441\u043b\u0443\u0436\u0431\u0430 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043e\u0440\u0433\u0430\u043d\u043e\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u0430\u043c\u043e\u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0420\u0436\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430  \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f   \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2017 \u0433.  - 20.08.2018 \u0433.\t20.08.2018 \u0433.\t07.09.2018 \u0433.\t- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424 \u0441\u0442. 72, 100, 136;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u043e\u043f\u043b\u0430\u0442\u044b \u0442\u0440\u0443\u0434\u0430; - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u043f.3 ,11, 108, 265 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u2116157\u043d.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.10.2018 \u0433\u043e\u0434\u0430\n36\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u0430\u044f \u0441\u043b\u0443\u0436\u0431\u0430 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043e\u0440\u0433\u0430\u043d\u043e\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u0430\u043c\u043e\u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u00ab\u041f\u043e\u0441\u0435\u043b\u043e\u043a \u0420\u043e\u0432\u0435\u043d\u044c\u043a\u0438\u00bb \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f   \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2017 \u0433.-31.10.2018 \u0433.\t15.10.2018 \u0433.\t12.11.2018 \u0433.\t- \u043d\u0435\u043e\u0431\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 828,7 \u0442\u044b\u0441. \u0440\u0443\u0431.;                                                      - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432 \u0443 1 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u044c\u043d\u043e-\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430 \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 139,9 \u0442\u044b\u0441. \u0440\u0443\u0431\u043b\u0435\u0439;                          - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0441\u0442.19,21 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u044b\u043c \u0437\u0430\u043a\u043e\u043d\u043e\u043c \u043e\u0442 5 \u0430\u043f\u0440\u0435\u043b\u044f 2013 \u0433\u043e\u0434\u0430 \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb \u0438 \u0447.2 \u0441\u0442.72 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                   -  \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424 \u0441\u0442.136 \u0438 \u0434\u0440\u0443\u0433\u0438\u0435  \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043e\u0431\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043f\u0435\u043d\u0441\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0445 \u0432\u044b\u043f\u043b\u0430\u0442 \u0437\u0430 \u0441\u043e\u0432\u043c\u0435\u0449\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0444\u0435\u0441\u0441\u0438\u0439 \u0438 \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u044b\u0439 \u043e\u0431\u044a\u0435\u043c.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.12.2018 \u0433\u043e\u0434\u0430\n";
            this.configureLoaderDefaults(textLoader, (byte)44, 2);
            textLoader.setForceHeaders(true);
            textLoader.setState(1);
            this.playText(textLoader, csv, 1024, expected, (index, len, b) -> {
                switch (index) {
                    case 1560: 
                    case 1561: 
                    case 1562: {
                        return -96;
                    }
                }
                return b;
            }, "{\"columnCount\":9,\"columns\":[{\"index\":0,\"name\":\"\u2116\u041f\u041f\",\"type\":\"STRING\"},{\"index\":1,\"name\":\"\u041e\u0431\u044a\u0435\u043a\u0442\u044b\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e\u041c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"type\":\"STRING\"},{\"index\":2,\"name\":\"\u0412\u0438\u0434\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e\u041c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"type\":\"STRING\"},{\"index\":3,\"name\":\"\u0422\u0435\u043c\u0430\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e\u041c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"type\":\"STRING\"},{\"index\":4,\"name\":\"\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c\u044b\u0439\u041f\u0435\u0440\u0438\u043e\u0434\",\"type\":\"STRING\"},{\"index\":5,\"name\":\"\u041d\u0430\u0447\u0430\u043b\u043e\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\",\"type\":\"STRING\"},{\"index\":6,\"name\":\"\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\",\"type\":\"STRING\"},{\"index\":7,\"name\":\"\u0412\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0435\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438\",\"type\":\"STRING\"},{\"index\":8,\"name\":\"\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\",\"type\":\"STRING\"}],\"timestampIndex\":-1}", 36L, 36L);
        });
    }

    @Test
    public void testBrokenUtf8Header() throws Exception {
        this.assertNoLeak(textLoader -> {
            String csv = "\"\u2116 \u043f/\u043f\",\"\u041e\u0431\u044a\u0435\u043a\u0442\u044b \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e \u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"\u0412\u0438\u0434 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e \u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"\u0422\u0435\u043c\u0430 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e \u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434\",\"\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\",\"\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\",\"\u0412\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f, \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438\",\"\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\"\n1,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0443\u043d\u0438\u0442\u0430\u0440\u043d\u043e\u0435 \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u0435 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0435 \u0442\u0435\u043f\u043b\u043e\u0432\u044b\u0435 \u0441\u0435\u0442\u0438\u00bb\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2015\u0433. - 31.12.2015\u0433.\",\"09.03.2016\u0433.\",\"01.04.2016\u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                          - \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432;                                            -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u044f.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.04.2016 \u0433\u043e\u0434\u0430\"\n2,\"\u041e\u0410\u041e \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0430\u044f \u0410\u041a \u21161468\u00bb\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u041e\u0410\u041e \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0430\u044f \u0410\u041a \u21161468\u00bb \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043d\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043e\u043a \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 \u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430\u043c \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u043e\u0442 31.12.2015 \u0433\u043e\u0434\u0430 \u2116 12-53\",\"01 - 29.02.16 \u0433.  01.01.2016 \u0433. -  31.01.2016 \u0433.,   01.03.2016 \u0433. - 30.04.2016 \u0433.\",\"04.04.2016\u0433.  10.05.2016\u0433.\",\"15.04.2016\u0433.  31.05.2016\u0433.\",\"\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043d\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \n\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043e\u043a \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 \u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430\u043c \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \n\u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u043e\u0442 31.12.2015 \u0433\u043e\u0434\u0430 \u211612-53    \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.06.2016 \u0433\u043e\u0434\u0430\"\n3,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438; \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\",\"01.01.2015 \u0433. -                   31.01.2016 \u0433.\",\"08.02.2016\u0433 \u043f\u0435\u0440\u0435\u0440\u044b\u0432 04.05.2016.\",\"04.03.2016\u0433. 38 \u0440\u0430\u0431. \u0434\u043d\u0435\u0439 06.05.2016\u0433.\",\"\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                               - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                             \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 01.07.2016 \u0433\u043e\u0434\u0430\"\n4,\"\u041c\u041a\u0423\u041a \u00ab\u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438; \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\",\"01.01.2015 \u0433. - 31.05.2016 \u0433.\",\"06.06.2016\u0433.\",\"27.06.2016\u0433.\",\"\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                                     \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 11.08.2016 \u0433\u043e\u0434\u0430\"\n5,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438, \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\",\"01.01.2015 \u0433. - 30.06.2016 \u0433.\",\"11.07.2016\u0433.\",\"29.07.2016\u0433.\",\"\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                                     \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 10.09.2016 \u0433\u043e\u0434\u0430\"\n6,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041c\u0424\u0426 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430\u00bb\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2015 \u0433. - 19.09.2016 \u0433.\",\"18.08.2016\u0433.\",\"19.09.2016\u0433.\",\"- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u041f\u0440\u0430\u0432\u0438\u043b \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043c\u043d\u043e\u0433\u043e\u0444\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0445 \u0446\u0435\u043d\u0442\u0440\u043e\u0432 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u041f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0420\u0424 \u043e\u0442 22.12.2012 \u0433\u043e\u0434\u0430 \u2116 1376.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.10.2016 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 07.11.2016 \u0433\u043e\u0434\u0430\"\n7,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2015 \u0433. - 31.08.2016 \u0433.\",\"22.09.2016\u0433.\",\"14.10.2016\u0433.\",\"\u0447.2 \u0441\u0442.34; \u043f.4 \u0441\u0442.38; \u0441\u0442.94; \u0441\u0442.95; \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;    - \u043f.1 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424- \u043f.1 \u0441\u0442.432; \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465; \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;           - \u043f.11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430 N 157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 21.11.2016 \u0433\u043e\u0434\u0430\"\n8,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2015 \u0433. - 31.08.2016 \u0433.\",\"22.09.2016\u0433.\",\"14.10.2016\u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                            - \u043d\u0435\u0446\u0435\u043b\u0435\u0432\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430;                                                     -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                   - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 14.12.2016 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 19.12.2016 \u0433\u043e\u0434\u0430\"\n9,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u00ab\u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2015\u0433 \u2014 31.10.2016\u0433\",\"01.11.2016 \u0433.\",\"11.11.2016 \u0433.\",\"\u0447.4 \u0441\u0442.30; \u0447.2 \u0441\u0442.34; \u043f.4 \u0441\u0442.38; \u0441\u0442.94; \u0447. 2, \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                           - \u043f.2 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;      - \u043f.1 \u0441\u0442.432; \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465; \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;           - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433.\u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                              - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  N 157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.12.2016 \u0433\u043e\u0434\u0430\"\n10,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u00ab\u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2015\u0433 \u2014 31.10.2016\u0433\",\"03.08.2016\u0433 \u043f\u0435\u0440\u0435\u0440\u044b\u0432 26.10.2016.\",\"18.08.2016\u0433. 48 \u0440\u0430\u0431. \u0434\u043d\u0435\u0439 11.11.2016\u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                           -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                  - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.01.2017 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 10.02.2017 \u0433\u043e\u0434\u0430\"\n11,\"\u041c\u0411\u0423\u0421\u041e\u0421\u0421\u0417\u041d \"\u041a\u043e\u043c\u043f\u043b\u0435\u043a\u0441\u043d\u044b\u0439 \u0446\u0435\u043d\u0442\u0440 \u0441\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u043d\u0430\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430\"\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2016\u0433 \u2014 30.11.2016\u0433\",\"19.12.2016 \u0433.\",\"29.12.2016 \u0433.\",\"\u0447.2 \u0441\u0442.34; \u0441\u0442.94; \u0447. 2, \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                -  \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                   - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433.\u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                             - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116 157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.01.2017 \u0433\u043e\u0434\u0430\"\n12,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2016 \u0433. -                   31.12.2016 \u0433.\",\"23.01.2017\u0433.\",\"15.02.2017 \u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                            - \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430;                                                     -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                   - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u043e\u0432 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 10.05.2017 \u0433\u043e\u0434\u0430\"\n13,\"\u041c\u041a\u0423\u041a \u00ab\u041b\u043e\u0437\u043e\u0432\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2015 \u0433. -                   31.12.2016 \u0433.\",\"20.02.2017\u0433.\",\"15.03.2017 \u0433.\",\"\u0447.2 \u0441\u0442.34, \u043f.4 \u0441\u0442.38, \u0441\u0442.93, \u0441\u0442.94, \u0441\u0442.95, \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;     - \u043f.2 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;       - \u043f.1 \u0441\u0442.432, \u043f.3 \u0441\u0442.455, \u043f.2 \u0441\u0442.465, \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;            - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                 - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116 157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439  \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.04.2017 \u0433\u043e\u0434\u0430\"\n14,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0440\u0430\u043d\u0435\u0435 \u0432\u044b\u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0433\u043b\u0430\u0432\u0435 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f\",\"-\",\"23.03.2017\u0433.\",\"23.03.2017 \u0433.\",\"\u041d\u0435\u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0432 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0439 \u0441\u0440\u043e\u043a \u0437\u0430\u043a\u043e\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432 \u0438 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0439 \u043f\u043e\u043b\u0438\u0442\u0438\u043a\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 (\u043f.4 \u0441\u0442. 270.2 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438).\",\"\u0421\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u043e\u0431 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u043c \u043f\u0440\u0430\u0432\u043e\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0438, \u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u044c \u0437\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0447\u0430\u0441\u0442\u044c\u044e 20 \u0441\u0442\u0430\u0442\u044c\u0438 19.5 \u041a\u043e\u0410\u041f \u0420\u0424. \u0414\u0435\u043b\u043e \u043e\u0431 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u043c \u043f\u0440\u0430\u0432\u043e\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0438 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0435\u0434\u0430\u0442\u0435\u043b\u044e \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u043d\u043e\u0433\u043e \u0441\u0443\u0434\u0430.\"\n15,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u043b\u0435\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2015\u0433.- 31.12.2016\u0433.\",\"20.03.2017\u0433.\",\"11.04.2017\u0433.\",\"- \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0432 \u0441\u0443\u043c\u043c\u0435 0,5 \u0442\u044b\u0441. \u0440\u0443\u0431\u043b\u0435\u0439;                                                  - \u0447.2 \u0441\u0442.34, \u0447.2 \u0441\u0442.93, \u0447.9 \u0441\u0442.94, \u0441\u0442.95, \u0447.2 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                                      - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439  \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.05.2017 \u0433\u043e\u0434\u0430\"\n16,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u043b\u0435\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438   \u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432, \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u043d\u0430 \u043e\u043a\u0430\u0437\u0430\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433\",\"01.01.2015 \u0433.-                  31.01.2016 \u0433.\",\"27.02.2017\u0433.\",\"11.04.2017\u0433.\",\"\u0412\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b. \u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438: \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u043d\u0435\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438  \u043e \u0441\u043e\u0441\u0442\u0430\u0432\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430 \u0438 \u0435\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438, \u0437\u0430\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u043d\u043e\u0440\u043c \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0413\u0421\u041c \u0438 \u043f\u0440\u043e\u0447\u0438\u0435. \u0412\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430 \u0438 \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 23.06.2017 \u0433\u043e\u0434\u0430\"\n17,\"\u041c\u0410\u0423 \u00ab\u041c\u0424\u0426 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438,  \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438 \u043e\u0442 14.10.2016 \u0433\u043e\u0434\u0430 \u21163001\",\"09.2016 \u0433.-05.2017 \u0433.\",\"19.04.2017\u0433\",\"19.05.2017 \u0433.\",\"\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b.                      \u0412\u044b\u044f\u0432\u043b\u0435\u043d\u043e \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 21.08.2017 \u0433\u043e\u0434\u0430\"\n18,\"\u041c\u0411\u041e\u0423 \u00ab\u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2016 \u0433. - 30.05.2017 \u0433.\",\"25.05.2017\u0433\",\"20.06.2017 \u0433.\",\"- \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u043f.4 \u0441\u0442.38, \u0447.2 \u0441\u0442.93, \u0447.9, 11 \u0441\u0442.94, \u0441\u0442.95 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                              - \u043f.3 \u0441\u0442.455, \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                       - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\",\"\u041f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\"\n19,\"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430, \u043f\u0440\u0438\u0440\u043e\u0434\u043e\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438 \u0440\u0430\u0437\u0432\u0438\u0442\u0438\u044f \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0439\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432, \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044e \u043f\u043e\u0434\u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b_5 \u00ab\u041e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b\u00bb \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u0430\u0437\u0432\u0438\u0442\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430 \u0432 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u043c \u0440\u0430\u0439\u043e\u043d\u0435 \u043d\u0430 2015-2020 \u0433\u043e\u0434\u044b\u00bb\",\"01.01.2016 \u0433. - 31.12.2016 \u0433.\",\"19.01.2017 \u0433. \u043f\u0435\u0440\u0435\u0440\u044b\u0432     01.06.2017 \u0433.\",\"20.01.2017 \u0433.  4\u043c\u0435\u0441. 11\u043a.\u0434\u043d.    07.07.2017 \u0433.\",\"\u041a\u0432\u0430\u0440\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u0438 \u0433\u043e\u0434\u043e\u0432\u043e\u0439 \u043e\u0442\u0447\u0435\u0442\u044b \u043e \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u00ab\u0420\u0430\u0437\u0432\u0438\u0442\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430 \u0432 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u043c \u0440\u0430\u0439\u043e\u043d\u0435 \u043d\u0430 2015-2020 \u0433\u043e\u0434\u044b\u00bb \u0437\u0430 2016 \u0433\u043e\u0434 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438.\",\"\u041f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\"\n20,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \"\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\" \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e, \u0440\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u043d\u0430\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e\u0441\u044f \u0432 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u0438\",\"01.07.2016 \u0433. - 30.06.2017 \u0433.\",\"03.07.2017 \u0433.\",\"04.08.2017 \u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;          - \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.09.2017 \u0433\u043e\u0434\u0430\"\n21,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041b\u043e\u0437\u043d\u044f\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2016 \u0433. - 31.07.2017 \u0433.\",\"07.08.2017 \u0433.\",\"25.08.2017 \u0433.\",\"- \u0447.10 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0447.2 \u0441\u0442.93, \u0447.9,11 \u0441\u0442.94, \u0441\u0442.95, \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                             - \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.09.2017 \u0433\u043e\u0434\u0430\"\n22,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0443\u0431\u0441\u0438\u0434\u0438\u0439 \u043d\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u0438 \u0441\u0443\u0431\u0441\u0438\u0434\u0438\u0439 \u043d\u0430 \u0438\u043d\u044b\u0435 \u0446\u0435\u043b\u0438\",\"01.01.2016 \u0433. - 31.08.2017 \u0433.\",\"01.09.2017 \u0433.\",\"25.09.2017 \u0433.\",\"\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043e\u0442\u0434\u0435\u043b\u044c\u043d\u044b\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f, \u043a\u0430\u0441\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.12.2017 \u0433\u043e\u0434\u0430\"\n23,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0438\u0436\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0430\u044f \u043e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2016 \u0433. - 31.09.2017 \u0433.\",\"12.10.2017 \u0433.\",\"27.10.2017 \u0433.\",\"- \u0447.10 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0447.9 \u0441\u0442.94, \u0441\u0442.95, \u0447.2,3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417\",\"\u041f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\"\n24,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u00ab\u0414\u0435\u0442\u0441\u043a\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u00bb \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u043e\u0435 \u043e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435\",\"\u041e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e \u0432\u043e\u043f\u0440\u043e\u0441\u0443 \u043e\u0431\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u043d\u043e\u0441\u0442\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0432\u044b\u043f\u043b\u0430\u0442 \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0433\u043e \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0430 \u0440\u0430\u0431\u043e\u0442\u043d\u0438\u043a\u0430\u043c \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f\",\"01.01.2017 \u0433. - 31.09.2017 \u0433.\",\"18.10.2017 \u0433.\",\"27.10.2017 \u0433.\",\"\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043e \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u0444\u043e\u043d\u0434\u0430 \u043e\u043f\u043b\u0430\u0442\u044b \u0442\u0440\u0443\u0434\u0430 (\u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u21163 \u043a \u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044e \u043e\u0431 \u043e\u043f\u043b\u0430\u0442\u0435 \u0442\u0440\u0443\u0434\u0430 \u0440\u0430\u0431\u043e\u0442\u043d\u0438\u043a\u043e\u0432 \u041c\u0411\u0423 \u0414\u041e  \u00ab\u0414\u0435\u0442\u0441\u043a\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u00bb \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043e\u0442 23.05.2017 \u0433. \u2116239) \u0438 \u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043e \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u0444\u043e\u043d\u0434\u0430 \u043e\u043f\u043b\u0430\u0442\u044b \u0442\u0440\u0443\u0434\u0430 \u041c\u0411\u0423 \u0414\u041e  \u00ab\u0414\u0435\u0442\u0441\u043a\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u00bb \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e 22.08.2017 \u0433.\",\"\u0412 \u0430\u0434\u0440\u0435\u0441 \u0443\u0447\u0440\u0435\u0434\u0438\u0442\u0435\u043b\u044f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0438\u0441\u044c\u043c\u043e \u0441 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f\u043c\u0438 \u043e \u043f\u0440\u0438\u043d\u044f\u0442\u0438\u0438 \u043c\u0435\u0440 \u043f\u043e \u043d\u0435\u0434\u043e\u043f\u0443\u0449\u0435\u043d\u0438\u044e \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u043d\u044b\u0445 \u0432 \u0437\u0430\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439\"\n25,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041f\u043b\u0430\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0431\u0430\u0441\u0441\u0435\u0439\u043d \u00ab\u0414\u0435\u043b\u044c\u0444\u0438\u043d\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.09.2016 \u0433. - 31.10.2017 \u0433.\",\"30.10.2017 \u0433.\",\"08.12.2017 \u0433.\",\"\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0439 \u0434\u0438\u0441\u0446\u0438\u043f\u043b\u0438\u043d\u044b, \u043a\u0430\u0441\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043d\u0430\u0434\u0431\u0430\u0432\u043e\u043a \u0438 \u0434\u043e\u043f\u043b\u0430\u0442, \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u0430 \u0442\u0430\u043a\u0436\u0435 \u0434\u0440\u0443\u0433\u0438\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0434\u043e 15.02.2018 \u0433\u043e\u0434\u0430.    \u0413\u043b\u0430\u0432\u0435 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0438 \u0437\u0430\u043c\u0435\u0441\u0442\u0438\u0442\u0435\u043b\u044e \u0433\u043b\u0430\u0432\u044b \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043f\u043e \u0441\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u043e\u043b\u0438\u0442\u0438\u043a\u0438, \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u0435 \u0438 \u0441\u043f\u043e\u0440\u0442\u0443 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u043c \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u043c \u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u0438\"\n26,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u0438\u0439 \u0434\u0435\u0442\u0441\u043a\u0438\u0439 \u0441\u0430\u0434\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2017 \u0433. - 31.11.2017 \u0433.\",\"13.12.2017 \u0433.\",\"27.12.2017 \u0433.\",\"- \u0447.10 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0441\u0442.94, \u0441\u0442.95, \u0447.2 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;     - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043e\u0432 \u0432 \u0447\u0430\u0441\u0442\u0438 \u0441\u0440\u043e\u043a\u043e\u0432 \u043e\u043f\u043b\u0430\u0442\u044b.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.01.2018 \u0433\u043e\u0434\u0430\"\n27,\"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u043e\u0435 \u043e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435\",\"\u0410\u043d\u0430\u043b\u0438\u0437 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430                           \u0437\u0430 2016-2017 \u0433\u043e\u0434\u044b\",\"01.01.2016 \u0433. - 31.12.2017 \u0433.\",\"05.02.2018 \u0433.\",\"12.02.2018 \u0433.\",\"- \u0447. 1, 2, 4 \u0441\u0442.160.2-1 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438;                  - \u043f.3.1 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043e\u0442 30.10.2015 \u0433\u043e\u0434\u0430 \u2116569;                               - \u043f.\u043f.4, 16, 20, 22, 23, 28, 30, 37 \u043f\u043e\u0440\u044f\u0434\u043a\u0430 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438 (\u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438) \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0434\u043e\u0445\u043e\u0434\u043e\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0444\u0438\u043d\u0430\u043d\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u0444\u0438\u0446\u0438\u0442\u0430 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u0432\u044b\u0448\u0435\u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.03.2018 \u0433\u043e\u0434\u0430\"\n28,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041b\u0430\u0434\u043e\u043c\u0438\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2017 \u0433. - 31.01.2018 \u0433.\",\"05.02.2018 \u0433.\",\"26.02.2018 \u0433.\",\"- \u0447.8 \u0441\u0442.17, \u0447.10-11 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0447.3 \u0441\u0442.94, \u0441\u0442.95 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                          - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043e\u0432 \u0432 \u0447\u0430\u0441\u0442\u0438 \u0441\u0440\u043e\u043a\u043e\u0432 \u043e\u043f\u043b\u0430\u0442\u044b.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 26.03.2018 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 30.03.2018 \u0433\u043e\u0434\u0430\"\n29,\"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u0438 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0442\u0443\u0440\u0438\u0437\u043c\u0430 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u043e\u0435 \u043e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435\",\"\u0410\u043d\u0430\u043b\u0438\u0437 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430                           \u0437\u0430 2016-2017 \u0433\u043e\u0434\u044b\",\"01.01.2016 \u0433. - 31.12.2017 \u0433.\",\"21.02.2018 \u0433.\",\"02.03.2018 \u0433.\",\"- \u0447. 1, 2, 4, 5 \u0441\u0442.160.2-1 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438;                  - \u0447.3 \u0441\u0442.7 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.10.2003 \u0433\u043e\u0434\u0430 \u2116131-\u0424\u0417 \u00ab\u041e\u0431 \u043e\u0431\u0449\u0438\u0445 \u043f\u0440\u0438\u043d\u0446\u0438\u043f\u0430\u0445 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u0430\u043c\u043e\u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0432 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438\u00bb;                                                   - \u043f.3 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043e\u0442 30.10.2015 \u0433\u043e\u0434\u0430 \u2116569;                                                      - \u043f.\u043f.4, 14, 16-20, 22-23, 28-30, 37 \u043f\u043e\u0440\u044f\u0434\u043a\u0430 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438 (\u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438) \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0434\u043e\u0445\u043e\u0434\u043e\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0444\u0438\u043d\u0430\u043d\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u0444\u0438\u0446\u0438\u0442\u0430 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u0432\u044b\u0448\u0435\u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.04.2018 \u0433\u043e\u0434\u0430\"\n30,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u0434\u043e\u0448\u043a\u043e\u043b\u044c\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0425\u0430\u0440\u044c\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0434\u0435\u0442\u0441\u043a\u0438\u0439 \u0441\u0430\u0434 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2017 \u0433. - 31.03.2018 \u0433.\",\"06.04.2018 \u0433.\",\"16.04.2018 \u0433.\",\"- \u0447.4,6 \u0441\u0442.38, \u0447.8 \u0441\u0442.17, \u0447. 10,11,13 \u0441\u0442.21, \u0441\u0442.34, \u043f.4,6 \u0441\u0442.38, \u0447.2 \u0441\u0442.93, \u0447.9 \u0441\u0442.94, \u0447.2 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                             - \u043f.1 \u0441\u0442. 708 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424; - \u0447.2 \u0441\u0442.72 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u041a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                              - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 28.05.2018 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 31.05.2018 \u0433\u043e\u0434\u0430\"\n31,\"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430, \u043f\u0440\u0438\u0440\u043e\u0434\u043e\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438 \u0440\u0430\u0437\u0432\u0438\u0442\u0438\u044f \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0439\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2016 \u0433.-23.05.2018 \u0433.\",\"16.05.2018 \u0433.\",\"06.06.2018 \u0433.\",\"- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                            - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438  \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.07.2018 \u0433\u043e\u0434\u0430\"\n32,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u0434\u043e\u0448\u043a\u043e\u043b\u044c\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0425\u0430\u0440\u044c\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0434\u0435\u0442\u0441\u043a\u0438\u0439 \u0441\u0430\u0434 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2017 \u0433. - 31.03.2018 \u0433.\",\"14.03.2018 \u0433. \u043f\u0435\u0440\u0435\u0440\u044b\u0432\",\"21.06.2018 \u0433. 41 \u0440\u0430\u0431. \u0434\u0435\u043d\u044c\",\"- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438 \u0441\u0442.57, \u0441\u0442.60.1, \u0441\u0442.60.2, \u0447.3 \u0441\u0442.93, \u0441\u0442.100, \u0441\u0442.103, \u0447.1 \u0441\u0442.154, \u0441\u0442.284;                                             - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                            - \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 01.09.2018 \u0433\u043e\u0434\u0430\"\n33,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u0436\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e, \u0440\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u043d\u0430\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e\u0441\u044f \u0432 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u0438\",\"01.01.2017  - 30.06.2018 \u0433.\",\"09.07.2018 \u0433.\",\"27.07.2018 \u0433.\",\"- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                            - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424 \u0441\u0442.136, 284;      - \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.09.2018 \u0433\u043e\u0434\u0430\"\n34,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u0436\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f  \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2017 \u0433. - 31.07.2018 \u0433.\",\"02.08.2018 \u0433.\",\"16.08.2018 \u0433.\",\"- \u0447.4,6 \u0441\u0442.38, \u0447.7 \u0441\u0442.18, \u043f.4 \u0447.1 \u0441\u0442.93, \u0447.3,\u0447. 6 \u0441\u0442.94 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                          - \u0441\u0442.457, \u0441\u0442.506 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                                 - \u0447.2 \u0441\u0442.72, \u043f.1 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u041a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                   - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.09.2018 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 29.09.2018 \u0433\u043e\u0434\u0430\"\n35,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u0430\u044f \u0441\u043b\u0443\u0436\u0431\u0430 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043e\u0440\u0433\u0430\u043d\u043e\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u0430\u043c\u043e\u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0420\u0436\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430  \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f   \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2017 \u0433.  - 20.08.2018 \u0433.\",\"20.08.2018 \u0433.\",\"07.09.2018 \u0433.\",\"- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424 \u0441\u0442. 72, 100, 136;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u043e\u043f\u043b\u0430\u0442\u044b \u0442\u0440\u0443\u0434\u0430; - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u043f.3 ,11, 108, 265 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u2116157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.10.2018 \u0433\u043e\u0434\u0430\"\n36,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u0430\u044f \u0441\u043b\u0443\u0436\u0431\u0430 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043e\u0440\u0433\u0430\u043d\u043e\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u0430\u043c\u043e\u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u00ab\u041f\u043e\u0441\u0435\u043b\u043e\u043a \u0420\u043e\u0432\u0435\u043d\u044c\u043a\u0438\u00bb \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f   \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2017 \u0433.-31.10.2018 \u0433.\",\"15.10.2018 \u0433.\",\"12.11.2018 \u0433.\",\"- \u043d\u0435\u043e\u0431\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 828,7 \u0442\u044b\u0441. \u0440\u0443\u0431.;                                                      - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432 \u0443 1 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u044c\u043d\u043e-\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430 \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 139,9 \u0442\u044b\u0441. \u0440\u0443\u0431\u043b\u0435\u0439;                          - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0441\u0442.19,21 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u044b\u043c \u0437\u0430\u043a\u043e\u043d\u043e\u043c \u043e\u0442 5 \u0430\u043f\u0440\u0435\u043b\u044f 2013 \u0433\u043e\u0434\u0430 \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb \u0438 \u0447.2 \u0441\u0442.72 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                   -  \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424 \u0441\u0442.136 \u0438 \u0434\u0440\u0443\u0433\u0438\u0435  \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043e\u0431\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043f\u0435\u043d\u0441\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0445 \u0432\u044b\u043f\u043b\u0430\u0442 \u0437\u0430 \u0441\u043e\u0432\u043c\u0435\u0449\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0444\u0435\u0441\u0441\u0438\u0439 \u0438 \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u044b\u0439 \u043e\u0431\u044a\u0435\u043c.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.12.2018 \u0433\u043e\u0434\u0430\"";
            String expected = "\u2116\u041f\u041f\t\u041e\u0431\u044a\u0435\u043a\u0442\u044b\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e\u041c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\t\u0412\u0438\u0434\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e\u041c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\t\u0422\u0435\u043c\u0430\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e\u041c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\t\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c\u044b\u0439\u041f\u0435\u0440\u0438\u043e\u0434\tf5\t\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\t\u0412\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0435\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438\t\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\n1\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0443\u043d\u0438\u0442\u0430\u0440\u043d\u043e\u0435 \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u0435 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0435 \u0442\u0435\u043f\u043b\u043e\u0432\u044b\u0435 \u0441\u0435\u0442\u0438\u00bb\t\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2015\u0433. - 31.12.2015\u0433.\t09.03.2016\u0433.\t01.04.2016\u0433.\t-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                          - \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432;                                            -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u044f.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.04.2016 \u0433\u043e\u0434\u0430\n2\t\u041e\u0410\u041e \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0430\u044f \u0410\u041a \u21161468\u00bb\t\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u041e\u0410\u041e \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0430\u044f \u0410\u041a \u21161468\u00bb \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043d\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043e\u043a \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 \u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430\u043c \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u043e\u0442 31.12.2015 \u0433\u043e\u0434\u0430 \u2116 12-53\t01 - 29.02.16 \u0433.  01.01.2016 \u0433. -  31.01.2016 \u0433.,   01.03.2016 \u0433. - 30.04.2016 \u0433.\t04.04.2016\u0433.  10.05.2016\u0433.\t15.04.2016\u0433.  31.05.2016\u0433.\t\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043d\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \n\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043e\u043a \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 \u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430\u043c \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \n\u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u043e\u0442 31.12.2015 \u0433\u043e\u0434\u0430 \u211612-53    \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.06.2016 \u0433\u043e\u0434\u0430\n3\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438; \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\t01.01.2015 \u0433. -                   31.01.2016 \u0433.\t08.02.2016\u0433 \u043f\u0435\u0440\u0435\u0440\u044b\u0432 04.05.2016.\t04.03.2016\u0433. 38 \u0440\u0430\u0431. \u0434\u043d\u0435\u0439 06.05.2016\u0433.\t\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                               - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                             \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 01.07.2016 \u0433\u043e\u0434\u0430\n4\t\u041c\u041a\u0423\u041a \u00ab\u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438; \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\t01.01.2015 \u0433. - 31.05.2016 \u0433.\t06.06.2016\u0433.\t27.06.2016\u0433.\t\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                                     \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 11.08.2016 \u0433\u043e\u0434\u0430\n5\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438, \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\t01.01.2015 \u0433. - 30.06.2016 \u0433.\t11.07.2016\u0433.\t29.07.2016\u0433.\t\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                                     \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 10.09.2016 \u0433\u043e\u0434\u0430\n6\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041c\u0424\u0426 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430\u00bb\t\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2015 \u0433. - 19.09.2016 \u0433.\t18.08.2016\u0433.\t19.09.2016\u0433.\t- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u041f\u0440\u0430\u0432\u0438\u043b \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043c\u043d\u043e\u0433\u043e\u0444\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0445 \u0446\u0435\u043d\u0442\u0440\u043e\u0432 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u041f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0420\u0424 \u043e\u0442 22.12.2012 \u0433\u043e\u0434\u0430 \u2116 1376.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.10.2016 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 07.11.2016 \u0433\u043e\u0434\u0430\n7\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\t01.01.2015 \u0433. - 31.08.2016 \u0433.\t22.09.2016\u0433.\t14.10.2016\u0433.\t\u0447.2 \u0441\u0442.34; \u043f.4 \u0441\u0442.38; \u0441\u0442.94; \u0441\u0442.95; \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;    - \u043f.1 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424- \u043f.1 \u0441\u0442.432; \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465; \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;           - \u043f.11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430 N 157\u043d.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 21.11.2016 \u0433\u043e\u0434\u0430\n8\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2015 \u0433. - 31.08.2016 \u0433.\t22.09.2016\u0433.\t14.10.2016\u0433.\t-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                            - \u043d\u0435\u0446\u0435\u043b\u0435\u0432\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430;                                                     -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                   - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 14.12.2016 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 19.12.2016 \u0433\u043e\u0434\u0430\n9\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u00ab\u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\t01.01.2015\u0433 \u2014 31.10.2016\u0433\t01.11.2016 \u0433.\t11.11.2016 \u0433.\t\u0447.4 \u0441\u0442.30; \u0447.2 \u0441\u0442.34; \u043f.4 \u0441\u0442.38; \u0441\u0442.94; \u0447. 2, \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                           - \u043f.2 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;      - \u043f.1 \u0441\u0442.432; \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465; \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;           - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433.\u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                              - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  N 157\u043d.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.12.2016 \u0433\u043e\u0434\u0430\n10\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u00ab\u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2015\u0433 \u2014 31.10.2016\u0433\t03.08.2016\u0433 \u043f\u0435\u0440\u0435\u0440\u044b\u0432 26.10.2016.\t18.08.2016\u0433. 48 \u0440\u0430\u0431. \u0434\u043d\u0435\u0439 11.11.2016\u0433.\t-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                           -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                  - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.01.2017 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 10.02.2017 \u0433\u043e\u0434\u0430\n11\t\u041c\u0411\u0423\u0421\u041e\u0421\u0421\u0417\u041d \t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\t01.01.2016\u0433 \u2014 30.11.2016\u0433\t19.12.2016 \u0433.\t29.12.2016 \u0433.\t\u0447.2 \u0441\u0442.34; \u0441\u0442.94; \u0447. 2, \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                -  \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                   - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433.\u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                             - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116 157\u043d.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.01.2017 \u0433\u043e\u0434\u0430\n12\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2016 \u0433. -                   31.12.2016 \u0433.\t23.01.2017\u0433.\t15.02.2017 \u0433.\t-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                            - \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430;                                                     -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                   - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u043e\u0432 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 10.05.2017 \u0433\u043e\u0434\u0430\n13\t\u041c\u041a\u0423\u041a \u00ab\u041b\u043e\u0437\u043e\u0432\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\t01.01.2015 \u0433. -                   31.12.2016 \u0433.\t20.02.2017\u0433.\t15.03.2017 \u0433.\t\u0447.2 \u0441\u0442.34, \u043f.4 \u0441\u0442.38, \u0441\u0442.93, \u0441\u0442.94, \u0441\u0442.95, \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;     - \u043f.2 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;       - \u043f.1 \u0441\u0442.432, \u043f.3 \u0441\u0442.455, \u043f.2 \u0441\u0442.465, \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;            - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                 - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116 157\u043d.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439  \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.04.2017 \u0433\u043e\u0434\u0430\n14\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0440\u0430\u043d\u0435\u0435 \u0432\u044b\u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0433\u043b\u0430\u0432\u0435 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f\t-\t23.03.2017\u0433.\t23.03.2017 \u0433.\t\u041d\u0435\u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0432 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0439 \u0441\u0440\u043e\u043a \u0437\u0430\u043a\u043e\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432 \u0438 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0439 \u043f\u043e\u043b\u0438\u0442\u0438\u043a\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 (\u043f.4 \u0441\u0442. 270.2 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438).\t\u0421\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u043e\u0431 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u043c \u043f\u0440\u0430\u0432\u043e\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0438, \u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u044c \u0437\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0447\u0430\u0441\u0442\u044c\u044e 20 \u0441\u0442\u0430\u0442\u044c\u0438 19.5 \u041a\u043e\u0410\u041f \u0420\u0424. \u0414\u0435\u043b\u043e \u043e\u0431 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u043c \u043f\u0440\u0430\u0432\u043e\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0438 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0435\u0434\u0430\u0442\u0435\u043b\u044e \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u043d\u043e\u0433\u043e \u0441\u0443\u0434\u0430.\n15\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u043b\u0435\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\t01.01.2015\u0433.- 31.12.2016\u0433.\t20.03.2017\u0433.\t11.04.2017\u0433.\t- \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0432 \u0441\u0443\u043c\u043c\u0435 0,5 \u0442\u044b\u0441. \u0440\u0443\u0431\u043b\u0435\u0439;                                                  - \u0447.2 \u0441\u0442.34, \u0447.2 \u0441\u0442.93, \u0447.9 \u0441\u0442.94, \u0441\u0442.95, \u0447.2 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                                      - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439  \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.05.2017 \u0433\u043e\u0434\u0430\n16\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u043b\u0435\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438   \u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432, \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u043d\u0430 \u043e\u043a\u0430\u0437\u0430\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433\t01.01.2015 \u0433.-                  31.01.2016 \u0433.\t27.02.2017\u0433.\t11.04.2017\u0433.\t\u0412\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b. \u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438: \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u043d\u0435\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438  \u043e \u0441\u043e\u0441\u0442\u0430\u0432\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430 \u0438 \u0435\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438, \u0437\u0430\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u043d\u043e\u0440\u043c \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0413\u0421\u041c \u0438 \u043f\u0440\u043e\u0447\u0438\u0435. \u0412\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430 \u0438 \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 23.06.2017 \u0433\u043e\u0434\u0430\n17\t\u041c\u0410\u0423 \u00ab\u041c\u0424\u0426 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438,  \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438 \u043e\u0442 14.10.2016 \u0433\u043e\u0434\u0430 \u21163001\t09.2016 \u0433.-05.2017 \u0433.\t19.04.2017\u0433\t19.05.2017 \u0433.\t\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b.                      \u0412\u044b\u044f\u0432\u043b\u0435\u043d\u043e \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 21.08.2017 \u0433\u043e\u0434\u0430\n18\t\u041c\u0411\u041e\u0423 \u00ab\u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\t01.01.2016 \u0433. - 30.05.2017 \u0433.\t25.05.2017\u0433\t20.06.2017 \u0433.\t- \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u043f.4 \u0441\u0442.38, \u0447.2 \u0441\u0442.93, \u0447.9, 11 \u0441\u0442.94, \u0441\u0442.95 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                              - \u043f.3 \u0441\u0442.455, \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                       - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\t\u041f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\n19\t\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430, \u043f\u0440\u0438\u0440\u043e\u0434\u043e\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438 \u0440\u0430\u0437\u0432\u0438\u0442\u0438\u044f \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0439\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432, \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044e \u043f\u043e\u0434\u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b_5 \u00ab\u041e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b\u00bb \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u0430\u0437\u0432\u0438\u0442\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430 \u0432 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u043c \u0440\u0430\u0439\u043e\u043d\u0435 \u043d\u0430 2015-2020 \u0433\u043e\u0434\u044b\u00bb\t01.01.2016 \u0433. - 31.12.2016 \u0433.\t19.01.2017 \u0433. \u043f\u0435\u0440\u0435\u0440\u044b\u0432     01.06.2017 \u0433.\t20.01.2017 \u0433.  4\u043c\u0435\u0441. 11\u043a.\u0434\u043d.    07.07.2017 \u0433.\t\u041a\u0432\u0430\u0440\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u0438 \u0433\u043e\u0434\u043e\u0432\u043e\u0439 \u043e\u0442\u0447\u0435\u0442\u044b \u043e \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u00ab\u0420\u0430\u0437\u0432\u0438\u0442\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430 \u0432 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u043c \u0440\u0430\u0439\u043e\u043d\u0435 \u043d\u0430 2015-2020 \u0433\u043e\u0434\u044b\u00bb \u0437\u0430 2016 \u0433\u043e\u0434 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438.\t\u041f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\n20\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e, \u0440\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u043d\u0430\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e\u0441\u044f \u0432 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u0438\t01.07.2016 \u0433. - 30.06.2017 \u0433.\t03.07.2017 \u0433.\t04.08.2017 \u0433.\t-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;          - \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.09.2017 \u0433\u043e\u0434\u0430\n21\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041b\u043e\u0437\u043d\u044f\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\t01.01.2016 \u0433. - 31.07.2017 \u0433.\t07.08.2017 \u0433.\t25.08.2017 \u0433.\t- \u0447.10 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0447.2 \u0441\u0442.93, \u0447.9,11 \u0441\u0442.94, \u0441\u0442.95, \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                             - \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.09.2017 \u0433\u043e\u0434\u0430\n22\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0443\u0431\u0441\u0438\u0434\u0438\u0439 \u043d\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u0438 \u0441\u0443\u0431\u0441\u0438\u0434\u0438\u0439 \u043d\u0430 \u0438\u043d\u044b\u0435 \u0446\u0435\u043b\u0438\t01.01.2016 \u0433. - 31.08.2017 \u0433.\t01.09.2017 \u0433.\t25.09.2017 \u0433.\t\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043e\u0442\u0434\u0435\u043b\u044c\u043d\u044b\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f, \u043a\u0430\u0441\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.12.2017 \u0433\u043e\u0434\u0430\n23\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0438\u0436\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0430\u044f \u043e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\t01.01.2016 \u0433. - 31.09.2017 \u0433.\t12.10.2017 \u0433.\t27.10.2017 \u0433.\t- \u0447.10 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0447.9 \u0441\u0442.94, \u0441\u0442.95, \u0447.2,3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417\t\u041f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\n24\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u00ab\u0414\u0435\u0442\u0441\u043a\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u00bb \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u043e\u0435 \u043e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435\t\u041e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e \u0432\u043e\u043f\u0440\u043e\u0441\u0443 \u043e\u0431\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u043d\u043e\u0441\u0442\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0432\u044b\u043f\u043b\u0430\u0442 \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0433\u043e \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0430 \u0440\u0430\u0431\u043e\u0442\u043d\u0438\u043a\u0430\u043c \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f\t01.01.2017 \u0433. - 31.09.2017 \u0433.\t18.10.2017 \u0433.\t27.10.2017 \u0433.\t\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043e \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u0444\u043e\u043d\u0434\u0430 \u043e\u043f\u043b\u0430\u0442\u044b \u0442\u0440\u0443\u0434\u0430 (\u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u21163 \u043a \u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044e \u043e\u0431 \u043e\u043f\u043b\u0430\u0442\u0435 \u0442\u0440\u0443\u0434\u0430 \u0440\u0430\u0431\u043e\u0442\u043d\u0438\u043a\u043e\u0432 \u041c\u0411\u0423 \u0414\u041e  \u00ab\u0414\u0435\u0442\u0441\u043a\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u00bb \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043e\u0442 23.05.2017 \u0433. \u2116239) \u0438 \u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043e \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u0444\u043e\u043d\u0434\u0430 \u043e\u043f\u043b\u0430\u0442\u044b \u0442\u0440\u0443\u0434\u0430 \u041c\u0411\u0423 \u0414\u041e  \u00ab\u0414\u0435\u0442\u0441\u043a\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u00bb \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e 22.08.2017 \u0433.\t\u0412 \u0430\u0434\u0440\u0435\u0441 \u0443\u0447\u0440\u0435\u0434\u0438\u0442\u0435\u043b\u044f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0438\u0441\u044c\u043c\u043e \u0441 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f\u043c\u0438 \u043e \u043f\u0440\u0438\u043d\u044f\u0442\u0438\u0438 \u043c\u0435\u0440 \u043f\u043e \u043d\u0435\u0434\u043e\u043f\u0443\u0449\u0435\u043d\u0438\u044e \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u043d\u044b\u0445 \u0432 \u0437\u0430\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439\n25\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041f\u043b\u0430\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0431\u0430\u0441\u0441\u0435\u0439\u043d \u00ab\u0414\u0435\u043b\u044c\u0444\u0438\u043d\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.09.2016 \u0433. - 31.10.2017 \u0433.\t30.10.2017 \u0433.\t08.12.2017 \u0433.\t\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0439 \u0434\u0438\u0441\u0446\u0438\u043f\u043b\u0438\u043d\u044b, \u043a\u0430\u0441\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043d\u0430\u0434\u0431\u0430\u0432\u043e\u043a \u0438 \u0434\u043e\u043f\u043b\u0430\u0442, \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u0430 \u0442\u0430\u043a\u0436\u0435 \u0434\u0440\u0443\u0433\u0438\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0434\u043e 15.02.2018 \u0433\u043e\u0434\u0430.    \u0413\u043b\u0430\u0432\u0435 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0438 \u0437\u0430\u043c\u0435\u0441\u0442\u0438\u0442\u0435\u043b\u044e \u0433\u043b\u0430\u0432\u044b \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043f\u043e \u0441\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u043e\u043b\u0438\u0442\u0438\u043a\u0438, \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u0435 \u0438 \u0441\u043f\u043e\u0440\u0442\u0443 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u043c \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u043c \u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u0438\n26\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u0438\u0439 \u0434\u0435\u0442\u0441\u043a\u0438\u0439 \u0441\u0430\u0434\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\t01.01.2017 \u0433. - 31.11.2017 \u0433.\t13.12.2017 \u0433.\t27.12.2017 \u0433.\t- \u0447.10 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0441\u0442.94, \u0441\u0442.95, \u0447.2 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;     - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043e\u0432 \u0432 \u0447\u0430\u0441\u0442\u0438 \u0441\u0440\u043e\u043a\u043e\u0432 \u043e\u043f\u043b\u0430\u0442\u044b.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.01.2018 \u0433\u043e\u0434\u0430\n27\t\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u043e\u0435 \u043e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435\t\u0410\u043d\u0430\u043b\u0438\u0437 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430                           \u0437\u0430 2016-2017 \u0433\u043e\u0434\u044b\t01.01.2016 \u0433. - 31.12.2017 \u0433.\t05.02.2018 \u0433.\t12.02.2018 \u0433.\t- \u0447. 1, 2, 4 \u0441\u0442.160.2-1 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438;                  - \u043f.3.1 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043e\u0442 30.10.2015 \u0433\u043e\u0434\u0430 \u2116569;                               - \u043f.\u043f.4, 16, 20, 22, 23, 28, 30, 37 \u043f\u043e\u0440\u044f\u0434\u043a\u0430 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438 (\u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438) \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0434\u043e\u0445\u043e\u0434\u043e\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0444\u0438\u043d\u0430\u043d\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u0444\u0438\u0446\u0438\u0442\u0430 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u0432\u044b\u0448\u0435\u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.03.2018 \u0433\u043e\u0434\u0430\n28\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041b\u0430\u0434\u043e\u043c\u0438\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\t01.01.2017 \u0433. - 31.01.2018 \u0433.\t05.02.2018 \u0433.\t26.02.2018 \u0433.\t- \u0447.8 \u0441\u0442.17, \u0447.10-11 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0447.3 \u0441\u0442.94, \u0441\u0442.95 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                          - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043e\u0432 \u0432 \u0447\u0430\u0441\u0442\u0438 \u0441\u0440\u043e\u043a\u043e\u0432 \u043e\u043f\u043b\u0430\u0442\u044b.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 26.03.2018 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 30.03.2018 \u0433\u043e\u0434\u0430\n29\t\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u0438 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0442\u0443\u0440\u0438\u0437\u043c\u0430 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u043e\u0435 \u043e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435\t\u0410\u043d\u0430\u043b\u0438\u0437 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430                           \u0437\u0430 2016-2017 \u0433\u043e\u0434\u044b\t01.01.2016 \u0433. - 31.12.2017 \u0433.\t21.02.2018 \u0433.\t02.03.2018 \u0433.\t- \u0447. 1, 2, 4, 5 \u0441\u0442.160.2-1 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438;                  - \u0447.3 \u0441\u0442.7 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.10.2003 \u0433\u043e\u0434\u0430 \u2116131-\u0424\u0417 \u00ab\u041e\u0431 \u043e\u0431\u0449\u0438\u0445 \u043f\u0440\u0438\u043d\u0446\u0438\u043f\u0430\u0445 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u0430\u043c\u043e\u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0432 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438\u00bb;                                                   - \u043f.3 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043e\u0442 30.10.2015 \u0433\u043e\u0434\u0430 \u2116569;                                                      - \u043f.\u043f.4, 14, 16-20, 22-23, 28-30, 37 \u043f\u043e\u0440\u044f\u0434\u043a\u0430 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438 (\u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438) \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0434\u043e\u0445\u043e\u0434\u043e\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0444\u0438\u043d\u0430\u043d\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u0444\u0438\u0446\u0438\u0442\u0430 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u0432\u044b\u0448\u0435\u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.04.2018 \u0433\u043e\u0434\u0430\n30\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u0434\u043e\u0448\u043a\u043e\u043b\u044c\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0425\u0430\u0440\u044c\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0434\u0435\u0442\u0441\u043a\u0438\u0439 \u0441\u0430\u0434 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\t01.01.2017 \u0433. - 31.03.2018 \u0433.\t06.04.2018 \u0433.\t16.04.2018 \u0433.\t- \u0447.4,6 \u0441\u0442.38, \u0447.8 \u0441\u0442.17, \u0447. 10,11,13 \u0441\u0442.21, \u0441\u0442.34, \u043f.4,6 \u0441\u0442.38, \u0447.2 \u0441\u0442.93, \u0447.9 \u0441\u0442.94, \u0447.2 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                             - \u043f.1 \u0441\u0442. 708 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424; - \u0447.2 \u0441\u0442.72 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u041a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                              - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 28.05.2018 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 31.05.2018 \u0433\u043e\u0434\u0430\n31\t\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430, \u043f\u0440\u0438\u0440\u043e\u0434\u043e\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438 \u0440\u0430\u0437\u0432\u0438\u0442\u0438\u044f \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0439\t\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2016 \u0433.-23.05.2018 \u0433.\t16.05.2018 \u0433.\t06.06.2018 \u0433.\t- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                            - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438  \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.07.2018 \u0433\u043e\u0434\u0430\n32\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u0434\u043e\u0448\u043a\u043e\u043b\u044c\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0425\u0430\u0440\u044c\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0434\u0435\u0442\u0441\u043a\u0438\u0439 \u0441\u0430\u0434 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2017 \u0433. - 31.03.2018 \u0433.\t14.03.2018 \u0433. \u043f\u0435\u0440\u0435\u0440\u044b\u0432\t21.06.2018 \u0433. 41 \u0440\u0430\u0431. \u0434\u0435\u043d\u044c\t- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438 \u0441\u0442.57, \u0441\u0442.60.1, \u0441\u0442.60.2, \u0447.3 \u0441\u0442.93, \u0441\u0442.100, \u0441\u0442.103, \u0447.1 \u0441\u0442.154, \u0441\u0442.284;                                             - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                            - \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 01.09.2018 \u0433\u043e\u0434\u0430\n33\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u0436\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e, \u0440\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u043d\u0430\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e\u0441\u044f \u0432 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u0438\t01.01.2017  - 30.06.2018 \u0433.\t09.07.2018 \u0433.\t27.07.2018 \u0433.\t- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                            - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424 \u0441\u0442.136, 284;      - \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.09.2018 \u0433\u043e\u0434\u0430\n34\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u0436\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f  \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\t01.01.2017 \u0433. - 31.07.2018 \u0433.\t02.08.2018 \u0433.\t16.08.2018 \u0433.\t- \u0447.4,6 \u0441\u0442.38, \u0447.7 \u0441\u0442.18, \u043f.4 \u0447.1 \u0441\u0442.93, \u0447.3,\u0447. 6 \u0441\u0442.94 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                          - \u0441\u0442.457, \u0441\u0442.506 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                                 - \u0447.2 \u0441\u0442.72, \u043f.1 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u041a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                   - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.09.2018 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 29.09.2018 \u0433\u043e\u0434\u0430\n35\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u0430\u044f \u0441\u043b\u0443\u0436\u0431\u0430 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043e\u0440\u0433\u0430\u043d\u043e\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u0430\u043c\u043e\u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0420\u0436\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430  \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f   \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2017 \u0433.  - 20.08.2018 \u0433.\t20.08.2018 \u0433.\t07.09.2018 \u0433.\t- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424 \u0441\u0442. 72, 100, 136;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u043e\u043f\u043b\u0430\u0442\u044b \u0442\u0440\u0443\u0434\u0430; - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u043f.3 ,11, 108, 265 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u2116157\u043d.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.10.2018 \u0433\u043e\u0434\u0430\n36\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u0430\u044f \u0441\u043b\u0443\u0436\u0431\u0430 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043e\u0440\u0433\u0430\u043d\u043e\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u0430\u043c\u043e\u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u00ab\u041f\u043e\u0441\u0435\u043b\u043e\u043a \u0420\u043e\u0432\u0435\u043d\u044c\u043a\u0438\u00bb \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f   \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2017 \u0433.-31.10.2018 \u0433.\t15.10.2018 \u0433.\t12.11.2018 \u0433.\t- \u043d\u0435\u043e\u0431\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 828,7 \u0442\u044b\u0441. \u0440\u0443\u0431.;                                                      - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432 \u0443 1 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u044c\u043d\u043e-\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430 \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 139,9 \u0442\u044b\u0441. \u0440\u0443\u0431\u043b\u0435\u0439;                          - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0441\u0442.19,21 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u044b\u043c \u0437\u0430\u043a\u043e\u043d\u043e\u043c \u043e\u0442 5 \u0430\u043f\u0440\u0435\u043b\u044f 2013 \u0433\u043e\u0434\u0430 \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb \u0438 \u0447.2 \u0441\u0442.72 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                   -  \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424 \u0441\u0442.136 \u0438 \u0434\u0440\u0443\u0433\u0438\u0435  \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043e\u0431\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043f\u0435\u043d\u0441\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0445 \u0432\u044b\u043f\u043b\u0430\u0442 \u0437\u0430 \u0441\u043e\u0432\u043c\u0435\u0449\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0444\u0435\u0441\u0441\u0438\u0439 \u0438 \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u044b\u0439 \u043e\u0431\u044a\u0435\u043c.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.12.2018 \u0433\u043e\u0434\u0430\n";
            this.configureLoaderDefaults(textLoader);
            textLoader.setForceHeaders(true);
            textLoader.setState(1);
            this.playText(textLoader, csv, 2048, expected, (index, len, b) -> {
                switch (index) {
                    case 256: 
                    case 257: 
                    case 258: {
                        return -96;
                    }
                }
                return b;
            }, "{\"columnCount\":9,\"columns\":[{\"index\":0,\"name\":\"\u2116\u041f\u041f\",\"type\":\"INT\"},{\"index\":1,\"name\":\"\u041e\u0431\u044a\u0435\u043a\u0442\u044b\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e\u041c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"type\":\"STRING\"},{\"index\":2,\"name\":\"\u0412\u0438\u0434\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e\u041c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"type\":\"STRING\"},{\"index\":3,\"name\":\"\u0422\u0435\u043c\u0430\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e\u041c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"type\":\"STRING\"},{\"index\":4,\"name\":\"\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c\u044b\u0439\u041f\u0435\u0440\u0438\u043e\u0434\",\"type\":\"STRING\"},{\"index\":5,\"name\":\"f5\",\"type\":\"STRING\"},{\"index\":6,\"name\":\"\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\",\"type\":\"STRING\"},{\"index\":7,\"name\":\"\u0412\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0435\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438\",\"type\":\"STRING\"},{\"index\":8,\"name\":\"\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\",\"type\":\"STRING\"}],\"timestampIndex\":-1}", 36L, 36L);
        });
    }

    @Test
    public void testBrokenUtf8Row() throws Exception {
        this.assertNoLeak(textLoader -> {
            String csv = "\"\u2116 \u043f/\u043f\",\"\u041e\u0431\u044a\u0435\u043a\u0442\u044b \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e \u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"\u0412\u0438\u0434 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e \u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"\u0422\u0435\u043c\u0430 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e \u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434\",\"\u041d\u0430\u0447\u0430\u043b\u043e \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\",\"\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\",\"\u0412\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f, \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438\",\"\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\"\n1,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0443\u043d\u0438\u0442\u0430\u0440\u043d\u043e\u0435 \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u0435 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0435 \u0442\u0435\u043f\u043b\u043e\u0432\u044b\u0435 \u0441\u0435\u0442\u0438\u00bb\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2015\u0433. - 31.12.2015\u0433.\",\"09.03.2016\u0433.\",\"01.04.2016\u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                          - \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432;                                            -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u044f.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.04.2016 \u0433\u043e\u0434\u0430\"\n2,\"\u041e\u0410\u041e \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0430\u044f \u0410\u041a \u21161468\u00bb\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u041e\u0410\u041e \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0430\u044f \u0410\u041a \u21161468\u00bb \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043d\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043e\u043a \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 \u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430\u043c \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u043e\u0442 31.12.2015 \u0433\u043e\u0434\u0430 \u2116 12-53\",\"01 - 29.02.16 \u0433.  01.01.2016 \u0433. -  31.01.2016 \u0433.,   01.03.2016 \u0433. - 30.04.2016 \u0433.\",\"04.04.2016\u0433.  10.05.2016\u0433.\",\"15.04.2016\u0433.  31.05.2016\u0433.\",\"\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043d\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \n\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043e\u043a \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 \u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430\u043c \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \n\u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u043e\u0442 31.12.2015 \u0433\u043e\u0434\u0430 \u211612-53    \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.06.2016 \u0433\u043e\u0434\u0430\"\n3,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438; \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\",\"01.01.2015 \u0433. -                   31.01.2016 \u0433.\",\"08.02.2016\u0433 \u043f\u0435\u0440\u0435\u0440\u044b\u0432 04.05.2016.\",\"04.03.2016\u0433. 38 \u0440\u0430\u0431. \u0434\u043d\u0435\u0439 06.05.2016\u0433.\",\"\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                               - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                             \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 01.07.2016 \u0433\u043e\u0434\u0430\"\n4,\"\u041c\u041a\u0423\u041a \u00ab\u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438; \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\",\"01.01.2015 \u0433. - 31.05.2016 \u0433.\",\"06.06.2016\u0433.\",\"27.06.2016\u0433.\",\"\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                                     \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 11.08.2016 \u0433\u043e\u0434\u0430\"\n5,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438, \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\",\"01.01.2015 \u0433. - 30.06.2016 \u0433.\",\"11.07.2016\u0433.\",\"29.07.2016\u0433.\",\"\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                                     \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 10.09.2016 \u0433\u043e\u0434\u0430\"\n6,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041c\u0424\u0426 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430\u00bb\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2015 \u0433. - 19.09.2016 \u0433.\",\"18.08.2016\u0433.\",\"19.09.2016\u0433.\",\"- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u041f\u0440\u0430\u0432\u0438\u043b \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043c\u043d\u043e\u0433\u043e\u0444\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0445 \u0446\u0435\u043d\u0442\u0440\u043e\u0432 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u041f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0420\u0424 \u043e\u0442 22.12.2012 \u0433\u043e\u0434\u0430 \u2116 1376.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.10.2016 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 07.11.2016 \u0433\u043e\u0434\u0430\"\n7,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2015 \u0433. - 31.08.2016 \u0433.\",\"22.09.2016\u0433.\",\"14.10.2016\u0433.\",\"\u0447.2 \u0441\u0442.34; \u043f.4 \u0441\u0442.38; \u0441\u0442.94; \u0441\u0442.95; \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;    - \u043f.1 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424- \u043f.1 \u0441\u0442.432; \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465; \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;           - \u043f.11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430 N 157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 21.11.2016 \u0433\u043e\u0434\u0430\"\n8,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2015 \u0433. - 31.08.2016 \u0433.\",\"22.09.2016\u0433.\",\"14.10.2016\u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                            - \u043d\u0435\u0446\u0435\u043b\u0435\u0432\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430;                                                     -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                   - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 14.12.2016 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 19.12.2016 \u0433\u043e\u0434\u0430\"\n9,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u00ab\u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2015\u0433 \u2014 31.10.2016\u0433\",\"01.11.2016 \u0433.\",\"11.11.2016 \u0433.\",\"\u0447.4 \u0441\u0442.30; \u0447.2 \u0441\u0442.34; \u043f.4 \u0441\u0442.38; \u0441\u0442.94; \u0447. 2, \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                           - \u043f.2 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;      - \u043f.1 \u0441\u0442.432; \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465; \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;           - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433.\u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                              - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  N 157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.12.2016 \u0433\u043e\u0434\u0430\"\n10,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u00ab\u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2015\u0433 \u2014 31.10.2016\u0433\",\"03.08.2016\u0433 \u043f\u0435\u0440\u0435\u0440\u044b\u0432 26.10.2016.\",\"18.08.2016\u0433. 48 \u0440\u0430\u0431. \u0434\u043d\u0435\u0439 11.11.2016\u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                           -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                  - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.01.2017 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 10.02.2017 \u0433\u043e\u0434\u0430\"\n11,\"\u041c\u0411\u0423\u0421\u041e\u0421\u0421\u0417\u041d \"\u041a\u043e\u043c\u043f\u043b\u0435\u043a\u0441\u043d\u044b\u0439 \u0446\u0435\u043d\u0442\u0440 \u0441\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u043d\u0430\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430\"\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2016\u0433 \u2014 30.11.2016\u0433\",\"19.12.2016 \u0433.\",\"29.12.2016 \u0433.\",\"\u0447.2 \u0441\u0442.34; \u0441\u0442.94; \u0447. 2, \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                -  \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                   - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433.\u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                             - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116 157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.01.2017 \u0433\u043e\u0434\u0430\"\n12,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2016 \u0433. -                   31.12.2016 \u0433.\",\"23.01.2017\u0433.\",\"15.02.2017 \u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                            - \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430;                                                     -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                   - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u043e\u0432 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 10.05.2017 \u0433\u043e\u0434\u0430\"\n13,\"\u041c\u041a\u0423\u041a \u00ab\u041b\u043e\u0437\u043e\u0432\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2015 \u0433. -                   31.12.2016 \u0433.\",\"20.02.2017\u0433.\",\"15.03.2017 \u0433.\",\"\u0447.2 \u0441\u0442.34, \u043f.4 \u0441\u0442.38, \u0441\u0442.93, \u0441\u0442.94, \u0441\u0442.95, \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;     - \u043f.2 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;       - \u043f.1 \u0441\u0442.432, \u043f.3 \u0441\u0442.455, \u043f.2 \u0441\u0442.465, \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;            - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                 - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116 157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439  \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.04.2017 \u0433\u043e\u0434\u0430\"\n14,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0440\u0430\u043d\u0435\u0435 \u0432\u044b\u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0433\u043b\u0430\u0432\u0435 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f\",\"-\",\"23.03.2017\u0433.\",\"23.03.2017 \u0433.\",\"\u041d\u0435\u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0432 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0439 \u0441\u0440\u043e\u043a \u0437\u0430\u043a\u043e\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432 \u0438 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0439 \u043f\u043e\u043b\u0438\u0442\u0438\u043a\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 (\u043f.4 \u0441\u0442. 270.2 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438).\",\"\u0421\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u043e\u0431 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u043c \u043f\u0440\u0430\u0432\u043e\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0438, \u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u044c \u0437\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0447\u0430\u0441\u0442\u044c\u044e 20 \u0441\u0442\u0430\u0442\u044c\u0438 19.5 \u041a\u043e\u0410\u041f \u0420\u0424. \u0414\u0435\u043b\u043e \u043e\u0431 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u043c \u043f\u0440\u0430\u0432\u043e\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0438 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0435\u0434\u0430\u0442\u0435\u043b\u044e \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u043d\u043e\u0433\u043e \u0441\u0443\u0434\u0430.\"\n15,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u043b\u0435\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2015\u0433.- 31.12.2016\u0433.\",\"20.03.2017\u0433.\",\"11.04.2017\u0433.\",\"- \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0432 \u0441\u0443\u043c\u043c\u0435 0,5 \u0442\u044b\u0441. \u0440\u0443\u0431\u043b\u0435\u0439;                                                  - \u0447.2 \u0441\u0442.34, \u0447.2 \u0441\u0442.93, \u0447.9 \u0441\u0442.94, \u0441\u0442.95, \u0447.2 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                                      - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439  \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.05.2017 \u0433\u043e\u0434\u0430\"\n16,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u043b\u0435\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438   \u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432, \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u043d\u0430 \u043e\u043a\u0430\u0437\u0430\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433\",\"01.01.2015 \u0433.-                  31.01.2016 \u0433.\",\"27.02.2017\u0433.\",\"11.04.2017\u0433.\",\"\u0412\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b. \u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438: \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u043d\u0435\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438  \u043e \u0441\u043e\u0441\u0442\u0430\u0432\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430 \u0438 \u0435\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438, \u0437\u0430\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u043d\u043e\u0440\u043c \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0413\u0421\u041c \u0438 \u043f\u0440\u043e\u0447\u0438\u0435. \u0412\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430 \u0438 \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 23.06.2017 \u0433\u043e\u0434\u0430\"\n17,\"\u041c\u0410\u0423 \u00ab\u041c\u0424\u0426 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438,  \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438 \u043e\u0442 14.10.2016 \u0433\u043e\u0434\u0430 \u21163001\",\"09.2016 \u0433.-05.2017 \u0433.\",\"19.04.2017\u0433\",\"19.05.2017 \u0433.\",\"\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b.                      \u0412\u044b\u044f\u0432\u043b\u0435\u043d\u043e \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 21.08.2017 \u0433\u043e\u0434\u0430\"\n18,\"\u041c\u0411\u041e\u0423 \u00ab\u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2016 \u0433. - 30.05.2017 \u0433.\",\"25.05.2017\u0433\",\"20.06.2017 \u0433.\",\"- \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u043f.4 \u0441\u0442.38, \u0447.2 \u0441\u0442.93, \u0447.9, 11 \u0441\u0442.94, \u0441\u0442.95 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                              - \u043f.3 \u0441\u0442.455, \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                       - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\",\"\u041f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\"\n19,\"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430, \u043f\u0440\u0438\u0440\u043e\u0434\u043e\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438 \u0440\u0430\u0437\u0432\u0438\u0442\u0438\u044f \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0439\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432, \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044e \u043f\u043e\u0434\u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b_5 \u00ab\u041e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b\u00bb \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u0430\u0437\u0432\u0438\u0442\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430 \u0432 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u043c \u0440\u0430\u0439\u043e\u043d\u0435 \u043d\u0430 2015-2020 \u0433\u043e\u0434\u044b\u00bb\",\"01.01.2016 \u0433. - 31.12.2016 \u0433.\",\"19.01.2017 \u0433. \u043f\u0435\u0440\u0435\u0440\u044b\u0432     01.06.2017 \u0433.\",\"20.01.2017 \u0433.  4\u043c\u0435\u0441. 11\u043a.\u0434\u043d.    07.07.2017 \u0433.\",\"\u041a\u0432\u0430\u0440\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u0438 \u0433\u043e\u0434\u043e\u0432\u043e\u0439 \u043e\u0442\u0447\u0435\u0442\u044b \u043e \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u00ab\u0420\u0430\u0437\u0432\u0438\u0442\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430 \u0432 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u043c \u0440\u0430\u0439\u043e\u043d\u0435 \u043d\u0430 2015-2020 \u0433\u043e\u0434\u044b\u00bb \u0437\u0430 2016 \u0433\u043e\u0434 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438.\",\"\u041f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\"\n20,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \"\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\" \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e, \u0440\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u043d\u0430\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e\u0441\u044f \u0432 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u0438\",\"01.07.2016 \u0433. - 30.06.2017 \u0433.\",\"03.07.2017 \u0433.\",\"04.08.2017 \u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;          - \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.09.2017 \u0433\u043e\u0434\u0430\"\n21,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041b\u043e\u0437\u043d\u044f\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2016 \u0433. - 31.07.2017 \u0433.\",\"07.08.2017 \u0433.\",\"25.08.2017 \u0433.\",\"- \u0447.10 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0447.2 \u0441\u0442.93, \u0447.9,11 \u0441\u0442.94, \u0441\u0442.95, \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                             - \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.09.2017 \u0433\u043e\u0434\u0430\"\n22,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0443\u0431\u0441\u0438\u0434\u0438\u0439 \u043d\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u0438 \u0441\u0443\u0431\u0441\u0438\u0434\u0438\u0439 \u043d\u0430 \u0438\u043d\u044b\u0435 \u0446\u0435\u043b\u0438\",\"01.01.2016 \u0433. - 31.08.2017 \u0433.\",\"01.09.2017 \u0433.\",\"25.09.2017 \u0433.\",\"\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043e\u0442\u0434\u0435\u043b\u044c\u043d\u044b\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f, \u043a\u0430\u0441\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.12.2017 \u0433\u043e\u0434\u0430\"\n23,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0438\u0436\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0430\u044f \u043e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2016 \u0433. - 31.09.2017 \u0433.\",\"12.10.2017 \u0433.\",\"27.10.2017 \u0433.\",\"- \u0447.10 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0447.9 \u0441\u0442.94, \u0441\u0442.95, \u0447.2,3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417\",\"\u041f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\"\n24,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u00ab\u0414\u0435\u0442\u0441\u043a\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u00bb \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u043e\u0435 \u043e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435\",\"\u041e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e \u0432\u043e\u043f\u0440\u043e\u0441\u0443 \u043e\u0431\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u043d\u043e\u0441\u0442\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0432\u044b\u043f\u043b\u0430\u0442 \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0433\u043e \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0430 \u0440\u0430\u0431\u043e\u0442\u043d\u0438\u043a\u0430\u043c \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f\",\"01.01.2017 \u0433. - 31.09.2017 \u0433.\",\"18.10.2017 \u0433.\",\"27.10.2017 \u0433.\",\"\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043e \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u0444\u043e\u043d\u0434\u0430 \u043e\u043f\u043b\u0430\u0442\u044b \u0442\u0440\u0443\u0434\u0430 (\u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u21163 \u043a \u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044e \u043e\u0431 \u043e\u043f\u043b\u0430\u0442\u0435 \u0442\u0440\u0443\u0434\u0430 \u0440\u0430\u0431\u043e\u0442\u043d\u0438\u043a\u043e\u0432 \u041c\u0411\u0423 \u0414\u041e  \u00ab\u0414\u0435\u0442\u0441\u043a\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u00bb \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043e\u0442 23.05.2017 \u0433. \u2116239) \u0438 \u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043e \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u0444\u043e\u043d\u0434\u0430 \u043e\u043f\u043b\u0430\u0442\u044b \u0442\u0440\u0443\u0434\u0430 \u041c\u0411\u0423 \u0414\u041e  \u00ab\u0414\u0435\u0442\u0441\u043a\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u00bb \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e 22.08.2017 \u0433.\",\"\u0412 \u0430\u0434\u0440\u0435\u0441 \u0443\u0447\u0440\u0435\u0434\u0438\u0442\u0435\u043b\u044f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0438\u0441\u044c\u043c\u043e \u0441 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f\u043c\u0438 \u043e \u043f\u0440\u0438\u043d\u044f\u0442\u0438\u0438 \u043c\u0435\u0440 \u043f\u043e \u043d\u0435\u0434\u043e\u043f\u0443\u0449\u0435\u043d\u0438\u044e \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u043d\u044b\u0445 \u0432 \u0437\u0430\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439\"\n25,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041f\u043b\u0430\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0431\u0430\u0441\u0441\u0435\u0439\u043d \u00ab\u0414\u0435\u043b\u044c\u0444\u0438\u043d\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.09.2016 \u0433. - 31.10.2017 \u0433.\",\"30.10.2017 \u0433.\",\"08.12.2017 \u0433.\",\"\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0439 \u0434\u0438\u0441\u0446\u0438\u043f\u043b\u0438\u043d\u044b, \u043a\u0430\u0441\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043d\u0430\u0434\u0431\u0430\u0432\u043e\u043a \u0438 \u0434\u043e\u043f\u043b\u0430\u0442, \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u0430 \u0442\u0430\u043a\u0436\u0435 \u0434\u0440\u0443\u0433\u0438\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0434\u043e 15.02.2018 \u0433\u043e\u0434\u0430.    \u0413\u043b\u0430\u0432\u0435 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0438 \u0437\u0430\u043c\u0435\u0441\u0442\u0438\u0442\u0435\u043b\u044e \u0433\u043b\u0430\u0432\u044b \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043f\u043e \u0441\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u043e\u043b\u0438\u0442\u0438\u043a\u0438, \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u0435 \u0438 \u0441\u043f\u043e\u0440\u0442\u0443 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u043c \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u043c \u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u0438\"\n26,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u0438\u0439 \u0434\u0435\u0442\u0441\u043a\u0438\u0439 \u0441\u0430\u0434\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2017 \u0433. - 31.11.2017 \u0433.\",\"13.12.2017 \u0433.\",\"27.12.2017 \u0433.\",\"- \u0447.10 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0441\u0442.94, \u0441\u0442.95, \u0447.2 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;     - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043e\u0432 \u0432 \u0447\u0430\u0441\u0442\u0438 \u0441\u0440\u043e\u043a\u043e\u0432 \u043e\u043f\u043b\u0430\u0442\u044b.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.01.2018 \u0433\u043e\u0434\u0430\"\n27,\"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u043e\u0435 \u043e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435\",\"\u0410\u043d\u0430\u043b\u0438\u0437 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430                           \u0437\u0430 2016-2017 \u0433\u043e\u0434\u044b\",\"01.01.2016 \u0433. - 31.12.2017 \u0433.\",\"05.02.2018 \u0433.\",\"12.02.2018 \u0433.\",\"- \u0447. 1, 2, 4 \u0441\u0442.160.2-1 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438;                  - \u043f.3.1 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043e\u0442 30.10.2015 \u0433\u043e\u0434\u0430 \u2116569;                               - \u043f.\u043f.4, 16, 20, 22, 23, 28, 30, 37 \u043f\u043e\u0440\u044f\u0434\u043a\u0430 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438 (\u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438) \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0434\u043e\u0445\u043e\u0434\u043e\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0444\u0438\u043d\u0430\u043d\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u0444\u0438\u0446\u0438\u0442\u0430 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u0432\u044b\u0448\u0435\u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.03.2018 \u0433\u043e\u0434\u0430\"\n28,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041b\u0430\u0434\u043e\u043c\u0438\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2017 \u0433. - 31.01.2018 \u0433.\",\"05.02.2018 \u0433.\",\"26.02.2018 \u0433.\",\"- \u0447.8 \u0441\u0442.17, \u0447.10-11 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0447.3 \u0441\u0442.94, \u0441\u0442.95 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                          - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043e\u0432 \u0432 \u0447\u0430\u0441\u0442\u0438 \u0441\u0440\u043e\u043a\u043e\u0432 \u043e\u043f\u043b\u0430\u0442\u044b.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 26.03.2018 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 30.03.2018 \u0433\u043e\u0434\u0430\"\n29,\"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u0438 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0442\u0443\u0440\u0438\u0437\u043c\u0430 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u043e\u0435 \u043e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435\",\"\u0410\u043d\u0430\u043b\u0438\u0437 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430                           \u0437\u0430 2016-2017 \u0433\u043e\u0434\u044b\",\"01.01.2016 \u0433. - 31.12.2017 \u0433.\",\"21.02.2018 \u0433.\",\"02.03.2018 \u0433.\",\"- \u0447. 1, 2, 4, 5 \u0441\u0442.160.2-1 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438;                  - \u0447.3 \u0441\u0442.7 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.10.2003 \u0433\u043e\u0434\u0430 \u2116131-\u0424\u0417 \u00ab\u041e\u0431 \u043e\u0431\u0449\u0438\u0445 \u043f\u0440\u0438\u043d\u0446\u0438\u043f\u0430\u0445 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u0430\u043c\u043e\u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0432 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438\u00bb;                                                   - \u043f.3 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043e\u0442 30.10.2015 \u0433\u043e\u0434\u0430 \u2116569;                                                      - \u043f.\u043f.4, 14, 16-20, 22-23, 28-30, 37 \u043f\u043e\u0440\u044f\u0434\u043a\u0430 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438 (\u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438) \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0434\u043e\u0445\u043e\u0434\u043e\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0444\u0438\u043d\u0430\u043d\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u0444\u0438\u0446\u0438\u0442\u0430 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u0432\u044b\u0448\u0435\u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.04.2018 \u0433\u043e\u0434\u0430\"\n30,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u0434\u043e\u0448\u043a\u043e\u043b\u044c\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0425\u0430\u0440\u044c\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0434\u0435\u0442\u0441\u043a\u0438\u0439 \u0441\u0430\u0434 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2017 \u0433. - 31.03.2018 \u0433.\",\"06.04.2018 \u0433.\",\"16.04.2018 \u0433.\",\"- \u0447.4,6 \u0441\u0442.38, \u0447.8 \u0441\u0442.17, \u0447. 10,11,13 \u0441\u0442.21, \u0441\u0442.34, \u043f.4,6 \u0441\u0442.38, \u0447.2 \u0441\u0442.93, \u0447.9 \u0441\u0442.94, \u0447.2 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                             - \u043f.1 \u0441\u0442. 708 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424; - \u0447.2 \u0441\u0442.72 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u041a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                              - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 28.05.2018 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 31.05.2018 \u0433\u043e\u0434\u0430\"\n31,\"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430, \u043f\u0440\u0438\u0440\u043e\u0434\u043e\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438 \u0440\u0430\u0437\u0432\u0438\u0442\u0438\u044f \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0439\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2016 \u0433.-23.05.2018 \u0433.\",\"16.05.2018 \u0433.\",\"06.06.2018 \u0433.\",\"- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                            - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438  \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.07.2018 \u0433\u043e\u0434\u0430\"\n32,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u0434\u043e\u0448\u043a\u043e\u043b\u044c\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0425\u0430\u0440\u044c\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0434\u0435\u0442\u0441\u043a\u0438\u0439 \u0441\u0430\u0434 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2017 \u0433. - 31.03.2018 \u0433.\",\"14.03.2018 \u0433. \u043f\u0435\u0440\u0435\u0440\u044b\u0432\",\"21.06.2018 \u0433. 41 \u0440\u0430\u0431. \u0434\u0435\u043d\u044c\",\"- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438 \u0441\u0442.57, \u0441\u0442.60.1, \u0441\u0442.60.2, \u0447.3 \u0441\u0442.93, \u0441\u0442.100, \u0441\u0442.103, \u0447.1 \u0441\u0442.154, \u0441\u0442.284;                                             - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                            - \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 01.09.2018 \u0433\u043e\u0434\u0430\"\n33,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u0436\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e, \u0440\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u043d\u0430\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e\u0441\u044f \u0432 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u0438\",\"01.01.2017  - 30.06.2018 \u0433.\",\"09.07.2018 \u0433.\",\"27.07.2018 \u0433.\",\"- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                            - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424 \u0441\u0442.136, 284;      - \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.09.2018 \u0433\u043e\u0434\u0430\"\n34,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u0436\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f  \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\",\"01.01.2017 \u0433. - 31.07.2018 \u0433.\",\"02.08.2018 \u0433.\",\"16.08.2018 \u0433.\",\"- \u0447.4,6 \u0441\u0442.38, \u0447.7 \u0441\u0442.18, \u043f.4 \u0447.1 \u0441\u0442.93, \u0447.3,\u0447. 6 \u0441\u0442.94 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                          - \u0441\u0442.457, \u0441\u0442.506 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                                 - \u0447.2 \u0441\u0442.72, \u043f.1 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u041a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                   - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.09.2018 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 29.09.2018 \u0433\u043e\u0434\u0430\"\n35,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u0430\u044f \u0441\u043b\u0443\u0436\u0431\u0430 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043e\u0440\u0433\u0430\u043d\u043e\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u0430\u043c\u043e\u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0420\u0436\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430  \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f   \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2017 \u0433.  - 20.08.2018 \u0433.\",\"20.08.2018 \u0433.\",\"07.09.2018 \u0433.\",\"- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424 \u0441\u0442. 72, 100, 136;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u043e\u043f\u043b\u0430\u0442\u044b \u0442\u0440\u0443\u0434\u0430; - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u043f.3 ,11, 108, 265 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u2116157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.10.2018 \u0433\u043e\u0434\u0430\"\n36,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u0430\u044f \u0441\u043b\u0443\u0436\u0431\u0430 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043e\u0440\u0433\u0430\u043d\u043e\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u0430\u043c\u043e\u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u00ab\u041f\u043e\u0441\u0435\u043b\u043e\u043a \u0420\u043e\u0432\u0435\u043d\u044c\u043a\u0438\u00bb \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f   \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2017 \u0433.-31.10.2018 \u0433.\",\"15.10.2018 \u0433.\",\"12.11.2018 \u0433.\",\"- \u043d\u0435\u043e\u0431\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 828,7 \u0442\u044b\u0441. \u0440\u0443\u0431.;                                                      - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432 \u0443 1 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u044c\u043d\u043e-\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430 \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 139,9 \u0442\u044b\u0441. \u0440\u0443\u0431\u043b\u0435\u0439;                          - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0441\u0442.19,21 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u044b\u043c \u0437\u0430\u043a\u043e\u043d\u043e\u043c \u043e\u0442 5 \u0430\u043f\u0440\u0435\u043b\u044f 2013 \u0433\u043e\u0434\u0430 \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb \u0438 \u0447.2 \u0441\u0442.72 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                   -  \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424 \u0441\u0442.136 \u0438 \u0434\u0440\u0443\u0433\u0438\u0435  \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043e\u0431\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043f\u0435\u043d\u0441\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0445 \u0432\u044b\u043f\u043b\u0430\u0442 \u0437\u0430 \u0441\u043e\u0432\u043c\u0435\u0449\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0444\u0435\u0441\u0441\u0438\u0439 \u0438 \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u044b\u0439 \u043e\u0431\u044a\u0435\u043c.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.12.2018 \u0433\u043e\u0434\u0430\"";
            String expected = "\u2116\u041f\u041f\t\u041e\u0431\u044a\u0435\u043a\u0442\u044b\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e\u041c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\t\u0412\u0438\u0434\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e\u041c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\t\u0422\u0435\u043c\u0430\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e\u041c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\t\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c\u044b\u0439\u041f\u0435\u0440\u0438\u043e\u0434\t\u041d\u0430\u0447\u0430\u043b\u043e\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\t\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\t\u0412\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0435\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438\t\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\n1\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0443\u043d\u0438\u0442\u0430\u0440\u043d\u043e\u0435 \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u0435 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0435 \u0442\u0435\u043f\u043b\u043e\u0432\u044b\u0435 \u0441\u0435\u0442\u0438\u00bb\t\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2015\u0433. - 31.12.2015\u0433.\t09.03.2016\u0433.\t01.04.2016\u0433.\t-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                          - \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432;                                            -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u044f.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.04.2016 \u0433\u043e\u0434\u0430\n3\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438; \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\t01.01.2015 \u0433. -                   31.01.2016 \u0433.\t08.02.2016\u0433 \u043f\u0435\u0440\u0435\u0440\u044b\u0432 04.05.2016.\t04.03.2016\u0433. 38 \u0440\u0430\u0431. \u0434\u043d\u0435\u0439 06.05.2016\u0433.\t\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                               - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                             \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 01.07.2016 \u0433\u043e\u0434\u0430\n4\t\u041c\u041a\u0423\u041a \u00ab\u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438; \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\t01.01.2015 \u0433. - 31.05.2016 \u0433.\t06.06.2016\u0433.\t27.06.2016\u0433.\t\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                                     \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 11.08.2016 \u0433\u043e\u0434\u0430\n5\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438, \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\t01.01.2015 \u0433. - 30.06.2016 \u0433.\t11.07.2016\u0433.\t29.07.2016\u0433.\t\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                                     \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 10.09.2016 \u0433\u043e\u0434\u0430\n6\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041c\u0424\u0426 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430\u00bb\t\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2015 \u0433. - 19.09.2016 \u0433.\t18.08.2016\u0433.\t19.09.2016\u0433.\t- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u041f\u0440\u0430\u0432\u0438\u043b \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043c\u043d\u043e\u0433\u043e\u0444\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0445 \u0446\u0435\u043d\u0442\u0440\u043e\u0432 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u041f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0420\u0424 \u043e\u0442 22.12.2012 \u0433\u043e\u0434\u0430 \u2116 1376.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.10.2016 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 07.11.2016 \u0433\u043e\u0434\u0430\n7\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\t01.01.2015 \u0433. - 31.08.2016 \u0433.\t22.09.2016\u0433.\t14.10.2016\u0433.\t\u0447.2 \u0441\u0442.34; \u043f.4 \u0441\u0442.38; \u0441\u0442.94; \u0441\u0442.95; \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;    - \u043f.1 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424- \u043f.1 \u0441\u0442.432; \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465; \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;           - \u043f.11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430 N 157\u043d.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 21.11.2016 \u0433\u043e\u0434\u0430\n8\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2015 \u0433. - 31.08.2016 \u0433.\t22.09.2016\u0433.\t14.10.2016\u0433.\t-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                            - \u043d\u0435\u0446\u0435\u043b\u0435\u0432\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430;                                                     -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                   - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 14.12.2016 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 19.12.2016 \u0433\u043e\u0434\u0430\n9\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u00ab\u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\t01.01.2015\u0433 \u2014 31.10.2016\u0433\t01.11.2016 \u0433.\t11.11.2016 \u0433.\t\u0447.4 \u0441\u0442.30; \u0447.2 \u0441\u0442.34; \u043f.4 \u0441\u0442.38; \u0441\u0442.94; \u0447. 2, \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                           - \u043f.2 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;      - \u043f.1 \u0441\u0442.432; \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465; \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;           - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433.\u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                              - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  N 157\u043d.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.12.2016 \u0433\u043e\u0434\u0430\n10\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u00ab\u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2015\u0433 \u2014 31.10.2016\u0433\t03.08.2016\u0433 \u043f\u0435\u0440\u0435\u0440\u044b\u0432 26.10.2016.\t18.08.2016\u0433. 48 \u0440\u0430\u0431. \u0434\u043d\u0435\u0439 11.11.2016\u0433.\t-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                           -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                  - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.01.2017 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 10.02.2017 \u0433\u043e\u0434\u0430\n11\t\u041c\u0411\u0423\u0421\u041e\u0421\u0421\u0417\u041d \t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\t01.01.2016\u0433 \u2014 30.11.2016\u0433\t19.12.2016 \u0433.\t29.12.2016 \u0433.\t\u0447.2 \u0441\u0442.34; \u0441\u0442.94; \u0447. 2, \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                -  \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                   - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433.\u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                             - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116 157\u043d.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.01.2017 \u0433\u043e\u0434\u0430\n12\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2016 \u0433. -                   31.12.2016 \u0433.\t23.01.2017\u0433.\t15.02.2017 \u0433.\t-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                            - \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430;                                                     -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                   - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u043e\u0432 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 10.05.2017 \u0433\u043e\u0434\u0430\n13\t\u041c\u041a\u0423\u041a \u00ab\u041b\u043e\u0437\u043e\u0432\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\t01.01.2015 \u0433. -                   31.12.2016 \u0433.\t20.02.2017\u0433.\t15.03.2017 \u0433.\t\u0447.2 \u0441\u0442.34, \u043f.4 \u0441\u0442.38, \u0441\u0442.93, \u0441\u0442.94, \u0441\u0442.95, \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;     - \u043f.2 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;       - \u043f.1 \u0441\u0442.432, \u043f.3 \u0441\u0442.455, \u043f.2 \u0441\u0442.465, \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;            - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                 - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116 157\u043d.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439  \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.04.2017 \u0433\u043e\u0434\u0430\n14\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0440\u0430\u043d\u0435\u0435 \u0432\u044b\u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0433\u043b\u0430\u0432\u0435 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f\t-\t23.03.2017\u0433.\t23.03.2017 \u0433.\t\u041d\u0435\u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0432 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0439 \u0441\u0440\u043e\u043a \u0437\u0430\u043a\u043e\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432 \u0438 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0439 \u043f\u043e\u043b\u0438\u0442\u0438\u043a\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 (\u043f.4 \u0441\u0442. 270.2 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438).\t\u0421\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u043e\u0431 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u043c \u043f\u0440\u0430\u0432\u043e\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0438, \u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u044c \u0437\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0447\u0430\u0441\u0442\u044c\u044e 20 \u0441\u0442\u0430\u0442\u044c\u0438 19.5 \u041a\u043e\u0410\u041f \u0420\u0424. \u0414\u0435\u043b\u043e \u043e\u0431 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u043c \u043f\u0440\u0430\u0432\u043e\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0438 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0435\u0434\u0430\u0442\u0435\u043b\u044e \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u043d\u043e\u0433\u043e \u0441\u0443\u0434\u0430.\n15\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u043b\u0435\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\t01.01.2015\u0433.- 31.12.2016\u0433.\t20.03.2017\u0433.\t11.04.2017\u0433.\t- \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0432 \u0441\u0443\u043c\u043c\u0435 0,5 \u0442\u044b\u0441. \u0440\u0443\u0431\u043b\u0435\u0439;                                                  - \u0447.2 \u0441\u0442.34, \u0447.2 \u0441\u0442.93, \u0447.9 \u0441\u0442.94, \u0441\u0442.95, \u0447.2 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                                      - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439  \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.05.2017 \u0433\u043e\u0434\u0430\n16\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u043b\u0435\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438   \u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432, \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u043d\u0430 \u043e\u043a\u0430\u0437\u0430\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433\t01.01.2015 \u0433.-                  31.01.2016 \u0433.\t27.02.2017\u0433.\t11.04.2017\u0433.\t\u0412\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b. \u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438: \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u043d\u0435\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438  \u043e \u0441\u043e\u0441\u0442\u0430\u0432\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430 \u0438 \u0435\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438, \u0437\u0430\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u043d\u043e\u0440\u043c \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0413\u0421\u041c \u0438 \u043f\u0440\u043e\u0447\u0438\u0435. \u0412\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430 \u0438 \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 23.06.2017 \u0433\u043e\u0434\u0430\n17\t\u041c\u0410\u0423 \u00ab\u041c\u0424\u0426 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438,  \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438 \u043e\u0442 14.10.2016 \u0433\u043e\u0434\u0430 \u21163001\t09.2016 \u0433.-05.2017 \u0433.\t19.04.2017\u0433\t19.05.2017 \u0433.\t\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b.                      \u0412\u044b\u044f\u0432\u043b\u0435\u043d\u043e \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 21.08.2017 \u0433\u043e\u0434\u0430\n18\t\u041c\u0411\u041e\u0423 \u00ab\u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\t01.01.2016 \u0433. - 30.05.2017 \u0433.\t25.05.2017\u0433\t20.06.2017 \u0433.\t- \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u043f.4 \u0441\u0442.38, \u0447.2 \u0441\u0442.93, \u0447.9, 11 \u0441\u0442.94, \u0441\u0442.95 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                              - \u043f.3 \u0441\u0442.455, \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                       - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\t\u041f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\n19\t\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430, \u043f\u0440\u0438\u0440\u043e\u0434\u043e\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438 \u0440\u0430\u0437\u0432\u0438\u0442\u0438\u044f \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0439\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432, \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044e \u043f\u043e\u0434\u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b_5 \u00ab\u041e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b\u00bb \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u0430\u0437\u0432\u0438\u0442\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430 \u0432 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u043c \u0440\u0430\u0439\u043e\u043d\u0435 \u043d\u0430 2015-2020 \u0433\u043e\u0434\u044b\u00bb\t01.01.2016 \u0433. - 31.12.2016 \u0433.\t19.01.2017 \u0433. \u043f\u0435\u0440\u0435\u0440\u044b\u0432     01.06.2017 \u0433.\t20.01.2017 \u0433.  4\u043c\u0435\u0441. 11\u043a.\u0434\u043d.    07.07.2017 \u0433.\t\u041a\u0432\u0430\u0440\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u0438 \u0433\u043e\u0434\u043e\u0432\u043e\u0439 \u043e\u0442\u0447\u0435\u0442\u044b \u043e \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u00ab\u0420\u0430\u0437\u0432\u0438\u0442\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430 \u0432 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u043c \u0440\u0430\u0439\u043e\u043d\u0435 \u043d\u0430 2015-2020 \u0433\u043e\u0434\u044b\u00bb \u0437\u0430 2016 \u0433\u043e\u0434 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438.\t\u041f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\n20\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e, \u0440\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u043d\u0430\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e\u0441\u044f \u0432 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u0438\t01.07.2016 \u0433. - 30.06.2017 \u0433.\t03.07.2017 \u0433.\t04.08.2017 \u0433.\t-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;          - \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.09.2017 \u0433\u043e\u0434\u0430\n21\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041b\u043e\u0437\u043d\u044f\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\t01.01.2016 \u0433. - 31.07.2017 \u0433.\t07.08.2017 \u0433.\t25.08.2017 \u0433.\t- \u0447.10 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0447.2 \u0441\u0442.93, \u0447.9,11 \u0441\u0442.94, \u0441\u0442.95, \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                             - \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.09.2017 \u0433\u043e\u0434\u0430\n22\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0443\u0431\u0441\u0438\u0434\u0438\u0439 \u043d\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u0438 \u0441\u0443\u0431\u0441\u0438\u0434\u0438\u0439 \u043d\u0430 \u0438\u043d\u044b\u0435 \u0446\u0435\u043b\u0438\t01.01.2016 \u0433. - 31.08.2017 \u0433.\t01.09.2017 \u0433.\t25.09.2017 \u0433.\t\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043e\u0442\u0434\u0435\u043b\u044c\u043d\u044b\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f, \u043a\u0430\u0441\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.12.2017 \u0433\u043e\u0434\u0430\n23\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0438\u0436\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0430\u044f \u043e\u0441\u043d\u043e\u0432\u043d\u0430\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\t01.01.2016 \u0433. - 31.09.2017 \u0433.\t12.10.2017 \u0433.\t27.10.2017 \u0433.\t- \u0447.10 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0447.9 \u0441\u0442.94, \u0441\u0442.95, \u0447.2,3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417\t\u041f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\n24\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u0434\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u043e\u0433\u043e \u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u00ab\u0414\u0435\u0442\u0441\u043a\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u00bb \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u043e\u0435 \u043e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435\t\u041e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435 \u043f\u043e \u0432\u043e\u043f\u0440\u043e\u0441\u0443 \u043e\u0431\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u043d\u043e\u0441\u0442\u0438 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0432\u044b\u043f\u043b\u0430\u0442 \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0433\u043e \u0445\u0430\u0440\u0430\u043a\u0442\u0435\u0440\u0430 \u0440\u0430\u0431\u043e\u0442\u043d\u0438\u043a\u0430\u043c \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f\t01.01.2017 \u0433. - 31.09.2017 \u0433.\t18.10.2017 \u0433.\t27.10.2017 \u0433.\t\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043e \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u0444\u043e\u043d\u0434\u0430 \u043e\u043f\u043b\u0430\u0442\u044b \u0442\u0440\u0443\u0434\u0430 (\u043f\u0440\u0438\u043b\u043e\u0436\u0435\u043d\u0438\u0435 \u21163 \u043a \u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044e \u043e\u0431 \u043e\u043f\u043b\u0430\u0442\u0435 \u0442\u0440\u0443\u0434\u0430 \u0440\u0430\u0431\u043e\u0442\u043d\u0438\u043a\u043e\u0432 \u041c\u0411\u0423 \u0414\u041e  \u00ab\u0414\u0435\u0442\u0441\u043a\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u00bb \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043e\u0442 23.05.2017 \u0433. \u2116239) \u0438 \u041f\u043e\u043b\u043e\u0436\u0435\u043d\u0438\u044f \u043e \u0440\u0430\u0441\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d\u0438\u0438 \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u0444\u043e\u043d\u0434\u0430 \u043e\u043f\u043b\u0430\u0442\u044b \u0442\u0440\u0443\u0434\u0430 \u041c\u0411\u0423 \u0414\u041e  \u00ab\u0414\u0435\u0442\u0441\u043a\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0438\u0441\u043a\u0443\u0441\u0441\u0442\u0432\u00bb \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e 22.08.2017 \u0433.\t\u0412 \u0430\u0434\u0440\u0435\u0441 \u0443\u0447\u0440\u0435\u0434\u0438\u0442\u0435\u043b\u044f \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0438\u0441\u044c\u043c\u043e \u0441 \u043f\u0440\u0435\u0434\u043b\u043e\u0436\u0435\u043d\u0438\u044f\u043c\u0438 \u043e \u043f\u0440\u0438\u043d\u044f\u0442\u0438\u0438 \u043c\u0435\u0440 \u043f\u043e \u043d\u0435\u0434\u043e\u043f\u0443\u0449\u0435\u043d\u0438\u044e \u043f\u0435\u0440\u0435\u0447\u0438\u0441\u043b\u0435\u043d\u043d\u044b\u0445 \u0432 \u0437\u0430\u043a\u043b\u044e\u0447\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439\n25\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041f\u043b\u0430\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u044b\u0439 \u0431\u0430\u0441\u0441\u0435\u0439\u043d \u00ab\u0414\u0435\u043b\u044c\u0444\u0438\u043d\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.09.2016 \u0433. - 31.10.2017 \u0433.\t30.10.2017 \u0433.\t08.12.2017 \u0433.\t\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0439 \u0434\u0438\u0441\u0446\u0438\u043f\u043b\u0438\u043d\u044b, \u043a\u0430\u0441\u0430\u044e\u0449\u0438\u0435\u0441\u044f \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u043d\u0430\u0434\u0431\u0430\u0432\u043e\u043a \u0438 \u0434\u043e\u043f\u043b\u0430\u0442, \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0441\u0442\u0438 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u0430 \u0442\u0430\u043a\u0436\u0435 \u0434\u0440\u0443\u0433\u0438\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u044f.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0434\u043e 15.02.2018 \u0433\u043e\u0434\u0430.    \u0413\u043b\u0430\u0432\u0435 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0438 \u0437\u0430\u043c\u0435\u0441\u0442\u0438\u0442\u0435\u043b\u044e \u0433\u043b\u0430\u0432\u044b \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043f\u043e \u0441\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u043e\u043b\u0438\u0442\u0438\u043a\u0438, \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u0435 \u0438 \u0441\u043f\u043e\u0440\u0442\u0443 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e \u043f\u0440\u043e\u0432\u0435\u0434\u0435\u043d\u043d\u043e\u043c \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u043c \u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u0438\n26\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u0438\u0439 \u0434\u0435\u0442\u0441\u043a\u0438\u0439 \u0441\u0430\u0434\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\t01.01.2017 \u0433. - 31.11.2017 \u0433.\t13.12.2017 \u0433.\t27.12.2017 \u0433.\t- \u0447.10 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0441\u0442.94, \u0441\u0442.95, \u0447.2 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;     - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043e\u0432 \u0432 \u0447\u0430\u0441\u0442\u0438 \u0441\u0440\u043e\u043a\u043e\u0432 \u043e\u043f\u043b\u0430\u0442\u044b.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.01.2018 \u0433\u043e\u0434\u0430\n27\t\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u043e\u0435 \u043e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435\t\u0410\u043d\u0430\u043b\u0438\u0437 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430                           \u0437\u0430 2016-2017 \u0433\u043e\u0434\u044b\t01.01.2016 \u0433. - 31.12.2017 \u0433.\t05.02.2018 \u0433.\t12.02.2018 \u0433.\t- \u0447. 1, 2, 4 \u0441\u0442.160.2-1 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438;                  - \u043f.3.1 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043e\u0442 30.10.2015 \u0433\u043e\u0434\u0430 \u2116569;                               - \u043f.\u043f.4, 16, 20, 22, 23, 28, 30, 37 \u043f\u043e\u0440\u044f\u0434\u043a\u0430 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438 (\u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438) \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0434\u043e\u0445\u043e\u0434\u043e\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0444\u0438\u043d\u0430\u043d\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u0444\u0438\u0446\u0438\u0442\u0430 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u0432\u044b\u0448\u0435\u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.03.2018 \u0433\u043e\u0434\u0430\n28\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041b\u0430\u0434\u043e\u043c\u0438\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\t01.01.2017 \u0433. - 31.01.2018 \u0433.\t05.02.2018 \u0433.\t26.02.2018 \u0433.\t- \u0447.8 \u0441\u0442.17, \u0447.10-11 \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u0447.3 \u0441\u0442.94, \u0441\u0442.95 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                          - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043e\u0432 \u0432 \u0447\u0430\u0441\u0442\u0438 \u0441\u0440\u043e\u043a\u043e\u0432 \u043e\u043f\u043b\u0430\u0442\u044b.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 26.03.2018 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 30.03.2018 \u0433\u043e\u0434\u0430\n29\t\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u0438 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0442\u0443\u0440\u0438\u0437\u043c\u0430 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u043e\u0435 \u043e\u0431\u0441\u043b\u0435\u0434\u043e\u0432\u0430\u043d\u0438\u0435\t\u0410\u043d\u0430\u043b\u0438\u0437 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430                           \u0437\u0430 2016-2017 \u0433\u043e\u0434\u044b\t01.01.2016 \u0433. - 31.12.2017 \u0433.\t21.02.2018 \u0433.\t02.03.2018 \u0433.\t- \u0447. 1, 2, 4, 5 \u0441\u0442.160.2-1 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438;                  - \u0447.3 \u0441\u0442.7 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.10.2003 \u0433\u043e\u0434\u0430 \u2116131-\u0424\u0417 \u00ab\u041e\u0431 \u043e\u0431\u0449\u0438\u0445 \u043f\u0440\u0438\u043d\u0446\u0438\u043f\u0430\u0445 \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u0430\u043c\u043e\u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0432 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438\u00bb;                                                   - \u043f.3 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u044f \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u043e\u0442 30.10.2015 \u0433\u043e\u0434\u0430 \u2116569;                                                      - \u043f.\u043f.4, 14, 16-20, 22-23, 28-30, 37 \u043f\u043e\u0440\u044f\u0434\u043a\u0430 \u043e\u0441\u0443\u0449\u0435\u0441\u0442\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438 (\u0440\u0430\u0441\u043f\u043e\u0440\u044f\u0434\u0438\u0442\u0435\u043b\u044f\u043c\u0438) \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0434\u043e\u0445\u043e\u0434\u043e\u0432 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430, \u0433\u043b\u0430\u0432\u043d\u044b\u043c\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438 (\u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u043e\u0440\u0430\u043c\u0438) \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u043e\u0432 \u0444\u0438\u043d\u0430\u043d\u0441\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u0444\u0438\u0446\u0438\u0442\u0430 \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044f \u0438 \u0432\u043d\u0443\u0442\u0440\u0435\u043d\u043d\u0435\u0433\u043e \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0430\u0443\u0434\u0438\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0433\u043e \u0432\u044b\u0448\u0435\u0443\u043a\u0430\u0437\u0430\u043d\u043d\u044b\u043c \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.04.2018 \u0433\u043e\u0434\u0430\n30\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u0434\u043e\u0448\u043a\u043e\u043b\u044c\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0425\u0430\u0440\u044c\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0434\u0435\u0442\u0441\u043a\u0438\u0439 \u0441\u0430\u0434 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\t01.01.2017 \u0433. - 31.03.2018 \u0433.\t06.04.2018 \u0433.\t16.04.2018 \u0433.\t- \u0447.4,6 \u0441\u0442.38, \u0447.8 \u0441\u0442.17, \u0447. 10,11,13 \u0441\u0442.21, \u0441\u0442.34, \u043f.4,6 \u0441\u0442.38, \u0447.2 \u0441\u0442.93, \u0447.9 \u0441\u0442.94, \u0447.2 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                             - \u043f.1 \u0441\u0442. 708 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424; - \u0447.2 \u0441\u0442.72 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u041a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                              - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 28.05.2018 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 31.05.2018 \u0433\u043e\u0434\u0430\n31\t\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430, \u043f\u0440\u0438\u0440\u043e\u0434\u043e\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438 \u0440\u0430\u0437\u0432\u0438\u0442\u0438\u044f \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0439\t\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2016 \u0433.-23.05.2018 \u0433.\t16.05.2018 \u0433.\t06.06.2018 \u0433.\t- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                            - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438  \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.07.2018 \u0433\u043e\u0434\u0430\n32\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u0434\u043e\u0448\u043a\u043e\u043b\u044c\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0425\u0430\u0440\u044c\u043a\u043e\u0432\u0441\u043a\u0438\u0439 \u0434\u0435\u0442\u0441\u043a\u0438\u0439 \u0441\u0430\u0434 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2017 \u0433. - 31.03.2018 \u0433.\t14.03.2018 \u0433. \u043f\u0435\u0440\u0435\u0440\u044b\u0432\t21.06.2018 \u0433. 41 \u0440\u0430\u0431. \u0434\u0435\u043d\u044c\t- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438 \u0441\u0442.57, \u0441\u0442.60.1, \u0441\u0442.60.2, \u0447.3 \u0441\u0442.93, \u0441\u0442.100, \u0441\u0442.103, \u0447.1 \u0441\u0442.154, \u0441\u0442.284;                                             - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                            - \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 01.09.2018 \u0433\u043e\u0434\u0430\n33\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u0436\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e, \u0440\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u043d\u0430\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e\u0441\u044f \u0432 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u0438\t01.01.2017  - 30.06.2018 \u0433.\t09.07.2018 \u0433.\t27.07.2018 \u0433.\t- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                            - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424 \u0441\u0442.136, 284;      - \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.09.2018 \u0433\u043e\u0434\u0430\n34\t\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u0436\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f  \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\t\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435\t01.01.2017 \u0433. - 31.07.2018 \u0433.\t02.08.2018 \u0433.\t16.08.2018 \u0433.\t- \u0447.4,6 \u0441\u0442.38, \u0447.7 \u0441\u0442.18, \u043f.4 \u0447.1 \u0441\u0442.93, \u0447.3,\u0447. 6 \u0441\u0442.94 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                          - \u0441\u0442.457, \u0441\u0442.506 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                                 - \u0447.2 \u0441\u0442.72, \u043f.1 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u041a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                   - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\t\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.09.2018 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 29.09.2018 \u0433\u043e\u0434\u0430\n35\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u0430\u044f \u0441\u043b\u0443\u0436\u0431\u0430 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043e\u0440\u0433\u0430\u043d\u043e\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u0430\u043c\u043e\u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0420\u0436\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430  \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f   \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2017 \u0433.  - 20.08.2018 \u0433.\t20.08.2018 \u0433.\t07.09.2018 \u0433.\t- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424 \u0441\u0442. 72, 100, 136;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0441\u0442\u0438\u043c\u0443\u043b\u0438\u0440\u0443\u044e\u0449\u0435\u0439 \u0447\u0430\u0441\u0442\u0438 \u043e\u043f\u043b\u0430\u0442\u044b \u0442\u0440\u0443\u0434\u0430; - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u043f.3 ,11, 108, 265 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u2116157\u043d.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.10.2018 \u0433\u043e\u0434\u0430\n36\t\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u0430\u044f \u0441\u043b\u0443\u0436\u0431\u0430 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043e\u0440\u0433\u0430\u043d\u043e\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0441\u0430\u043c\u043e\u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u00ab\u041f\u043e\u0441\u0435\u043b\u043e\u043a \u0420\u043e\u0432\u0435\u043d\u044c\u043a\u0438\u00bb \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\t\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f   \u0440\u0435\u0432\u0438\u0437\u0438\u044f\t\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\t01.01.2017 \u0433.-31.10.2018 \u0433.\t15.10.2018 \u0433.\t12.11.2018 \u0433.\t- \u043d\u0435\u043e\u0431\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 828,7 \u0442\u044b\u0441. \u0440\u0443\u0431.;                                                      - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432 \u0443 1 \u043c\u0430\u0442\u0435\u0440\u0438\u0430\u043b\u044c\u043d\u043e-\u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0433\u043e \u043b\u0438\u0446\u0430 \u043d\u0430 \u0441\u0443\u043c\u043c\u0443 139,9 \u0442\u044b\u0441. \u0440\u0443\u0431\u043b\u0435\u0439;                          - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0441\u0442.19,21 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u044b\u043c \u0437\u0430\u043a\u043e\u043d\u043e\u043c \u043e\u0442 5 \u0430\u043f\u0440\u0435\u043b\u044f 2013 \u0433\u043e\u0434\u0430 \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb \u0438 \u0447.2 \u0441\u0442.72 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                   -  \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u043d\u043e\u0440\u043c \u0422\u0440\u0443\u0434\u043e\u0432\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424 \u0441\u0442.136 \u0438 \u0434\u0440\u0443\u0433\u0438\u0435  \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043e\u0431\u043e\u0441\u043d\u043e\u0432\u0430\u043d\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u043a\u043e\u043c\u043f\u0435\u043d\u0441\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0445 \u0432\u044b\u043f\u043b\u0430\u0442 \u0437\u0430 \u0441\u043e\u0432\u043c\u0435\u0449\u0435\u043d\u0438\u0435 \u043f\u0440\u043e\u0444\u0435\u0441\u0441\u0438\u0439 \u0438 \u0440\u0430\u0441\u0448\u0438\u0440\u0435\u043d\u043d\u044b\u0439 \u043e\u0431\u044a\u0435\u043c.\t\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.12.2018 \u0433\u043e\u0434\u0430\n";
            this.configureLoaderDefaults(textLoader, (byte)44, 1);
            textLoader.setForceHeaders(true);
            textLoader.setState(1);
            this.playText(textLoader, csv, 1024, expected, (index, len, b) -> {
                switch (index) {
                    case 1560: 
                    case 1561: 
                    case 1562: {
                        return -96;
                    }
                }
                return b;
            }, "{\"columnCount\":9,\"columns\":[{\"index\":0,\"name\":\"\u2116\u041f\u041f\",\"type\":\"STRING\"},{\"index\":1,\"name\":\"\u041e\u0431\u044a\u0435\u043a\u0442\u044b\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e\u041c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"type\":\"STRING\"},{\"index\":2,\"name\":\"\u0412\u0438\u0434\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e\u041c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"type\":\"STRING\"},{\"index\":3,\"name\":\"\u0422\u0435\u043c\u0430\u041a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e\u041c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"type\":\"STRING\"},{\"index\":4,\"name\":\"\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c\u044b\u0439\u041f\u0435\u0440\u0438\u043e\u0434\",\"type\":\"STRING\"},{\"index\":5,\"name\":\"\u041d\u0430\u0447\u0430\u043b\u043e\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\",\"type\":\"STRING\"},{\"index\":6,\"name\":\"\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\",\"type\":\"STRING\"},{\"index\":7,\"name\":\"\u0412\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0435\u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f\u041d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438\",\"type\":\"STRING\"},{\"index\":8,\"name\":\"\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\",\"type\":\"STRING\"}],\"timestampIndex\":-1}", 36L, 35L);
        });
    }

    @Test
    public void testCannotOverwriteTable() throws Exception {
        this.assertNoLeak(textLoader -> {
            String csv = "\"\"\"CMP2\",8,8000,2.27636352181435,2015-01-29T19:15:09.000Z,2015-01-29 19:15:09,01/29/2015,323,TRUE,14925407\nCMP1,2,1581,9.01423481060192,2015-01-30T19:15:09.000Z,2015-01-30 19:15:09,01/30/2015,9138,FALSE,68225213\nCMP2,8,7067,9.6284336107783,2015-01-31T19:15:09.000Z,2015-01-31 19:15:09,01/31/2015,8197,TRUE,58403960\nCMP1,8,5313,8.87764661805704,2015-02-01T19:15:09.000Z,2015-02-01 19:15:09,02/01/2015,2733,FALSE,69698373\n,4,3883,7.96873019309714,2015-02-02T19:15:09.000Z,2015-02-02 19:15:09,02/02/2015,6912,TRUE,91147394\nCMP1,7,4256,2.46553522534668,2015-02-03T19:15:09.000Z,2015-02-03 19:15:09,02/03/2015,9453,FALSE,50278940\nCMP2,4,155,5.08547495584935,2015-02-04T19:15:09.000Z,2015-02-04 19:15:09,02/04/2015,8919,TRUE,8671995\n\"CMP1\",7,4486,,2015-02-05T19:15:09.000Z,2015-02-05 19:15:09,02/05/2015,8670,FALSE,751877\nCMP2,2,6641,0.0381825352087617,2015-02-06T19:15:09.000Z,2015-02-06 19:15:09,02/06/2015,8331,TRUE,40909232527\nCMP1,1,3579,0.849663221742958,2015-02-07T19:15:09.000Z,2015-02-07 19:15:09,02/07/2015,9592,FALSE,11490662\nCMP2,2,4770,2.85092033445835,2015-02-08T19:15:09.000Z,2015-02-08 19:15:09,02/08/2015,253,TRUE,33766814\nCMP1,5,4938,4.42754498450086,2015-02-09T19:15:09.000Z,2015-02-09 19:15:09,02/09/2015,7817,FALSE,61983099\n";
            compiler.compile((CharSequence)"create table test(a symbol, b int, c long, d float, e date, f date, g date, h long, i boolean, k long, t timestamp)", null);
            this.configureLoaderDefaults(textLoader, (byte)-1, 1, true);
            try (TableWriter ignore = engine.getWriter((CharSequence)"test");){
                try {
                    this.playText0(textLoader, csv, 1024, ENTITY_MANIPULATOR);
                    Assert.fail();
                }
                catch (CairoException e) {
                    TestUtils.assertContains(e.getMessage(), "Cannot lock");
                }
            }
        });
    }

    @Test
    public void testDOSLineEnds() throws Exception {
        this.assertNoLeak(textLoader -> {
            String expected = "f0\tf1\tf2\tf3\tf4\tf5\tf6\n123\tabc\t2015-01-20T21:00:00.000Z\t3.141500000000\ttrue\tLorem ipsum dolor sit amet.\t122\n124\tabc\t2015-01-20T21:00:00.000Z\t7.342000000000\tfalse\tLorem ipsum \n\ndolor \"sit\" amet.\t546756\n125\tabc\t2015-01-20T21:00:00.000Z\t9.334000000000\tfalse\tLorem ipsum \"dolor\" sit amet.\t23\n126\tabc\t2015-01-20T21:00:00.000Z\t1.345000000000\ttrue\tLorem, ipsum, dolor sit amet.\t434\n127\tabc\t2015-01-20T21:00:00.000Z\t1.533210000000\ttrue\tLorem ipsum dolor sit amet.\t112\n128\tabc\t2015-01-20T21:00:00.000Z\t2.456000000000\ttrue\tLorem ipsum dolor sit amet.\t122\n";
            String csv = "123,abc,2015-01-20T21:00:00.000Z,3.1415,TRUE,Lorem ipsum dolor sit amet.,122\r\n124,abc,2015-01-20T21:00:00.000Z,7.342,FALSE,\"Lorem ipsum \n\ndolor \"\"sit\"\" amet.\",546756\r\n125,abc,2015-01-20T21:00:00.000Z,9.334,,\"Lorem ipsum \"\"dolor\"\" sit amet.\",23\r\n126,abc,2015-01-20T21:00:00.000Z,1.345,TRUE,\"Lorem, ipsum, dolor sit amet.\",434\r\n126,abc,2015-01-20T21:00:00.000Z,1.345,TRUE,\"Lorem, ipsum, dolor sit amet.\",434,asdfasdf,asdfasdf,asdfasd\r\n127,abc,2015-01-20T21:00:00.000Z,1.53321,TRUE,Lorem ipsum dolor sit amet.,112\r\n128,abc,2015-01-20T21:00:00.000Z,2.456,TRUE,Lorem ipsum dolor sit amet.,122\r\n";
            this.configureLoaderDefaults(textLoader, (byte)44);
            textLoader.setForceHeaders(false);
            this.playText(textLoader, csv, 200, "f0\tf1\tf2\tf3\tf4\tf5\tf6\n123\tabc\t2015-01-20T21:00:00.000Z\t3.141500000000\ttrue\tLorem ipsum dolor sit amet.\t122\n124\tabc\t2015-01-20T21:00:00.000Z\t7.342000000000\tfalse\tLorem ipsum \n\ndolor \"sit\" amet.\t546756\n125\tabc\t2015-01-20T21:00:00.000Z\t9.334000000000\tfalse\tLorem ipsum \"dolor\" sit amet.\t23\n126\tabc\t2015-01-20T21:00:00.000Z\t1.345000000000\ttrue\tLorem, ipsum, dolor sit amet.\t434\n127\tabc\t2015-01-20T21:00:00.000Z\t1.533210000000\ttrue\tLorem ipsum dolor sit amet.\t112\n128\tabc\t2015-01-20T21:00:00.000Z\t2.456000000000\ttrue\tLorem ipsum dolor sit amet.\t122\n", "{\"columnCount\":7,\"columns\":[{\"index\":0,\"name\":\"f0\",\"type\":\"INT\"},{\"index\":1,\"name\":\"f1\",\"type\":\"STRING\"},{\"index\":2,\"name\":\"f2\",\"type\":\"DATE\"},{\"index\":3,\"name\":\"f3\",\"type\":\"DOUBLE\"},{\"index\":4,\"name\":\"f4\",\"type\":\"BOOLEAN\"},{\"index\":5,\"name\":\"f5\",\"type\":\"STRING\"},{\"index\":6,\"name\":\"f6\",\"type\":\"INT\"}],\"timestampIndex\":-1}", 6L, 6L);
        });
    }

    @Test
    public void testDanglingQuote() throws Exception {
        this.assertNoLeak(textLoader -> {
            String expected = "f0\tf1\tf2\tf3\tf4\tf5\tf6\n123\tabc\t2015-01-20T21:00:00.000Z\t3.141500000000\ttrue\tLorem ipsum dolor sit amet.\t122\n124\tabc\t2015-01-20T21:00:00.000Z\t7.342000000000\tfalse\tLorem ipsum \n\ndolor \"sit\" amet.\t546756\n125\tabc\t2015-01-20T21:00:00.000Z\t9.334000000000\tfalse\tLorem ipsum \"dolor\" sit amet.\t23\n126\tabc\t2015-01-20T21:00:00.000Z\t1.345000000000\ttrue\tLorem, ipsum, dolor sit amet.\t434\n127\tabc\t2015-01-20T21:00:00.000Z\t1.533210000000\ttrue\tLorem ipsum dolor sit amet.\t112\n";
            String csv = "123\tabc\t2015-01-20T21:00:00.000Z\t3.1415\tTRUE\tLorem ipsum dolor sit amet.\t122\n124\tabc\t2015-01-20T21:00:00.000Z\t7.342\tFALSE\t\"Lorem ipsum \n\ndolor \"\"sit\"\" amet.\"\t546756\n125\tabc\t2015-01-20T21:00:00.000Z\t9.334\t\t\"Lorem ipsum \"\"dolor\"\" sit amet.\"\t23\n126\tabc\t2015-01-20T21:00:00.000Z\t1.345\tTRUE\t\"Lorem, ipsum, dolor sit amet.\"\t434\n120\tabc\t2015-01-20T21:00:00.000Z\t1.345\tTRUE\t\"Lorem, ipsum, dolor sit amet.\"\t434\tasdfasdf\tasdfasdf\tasdfasd\n127\tabc\t2015-01-20T21:00:00.000Z\t1.53321\tTRUE\tLorem ipsum dolor sit amet.\t112\n128\tabc\t2015-01-20T21:00:00.000Z\t2.456\tTRUE\tLorem ipsum dolor sit amet.\t\"";
            this.configureLoaderDefaults(textLoader, (byte)9);
            textLoader.setForceHeaders(false);
            this.playText(textLoader, csv, 85, "f0\tf1\tf2\tf3\tf4\tf5\tf6\n123\tabc\t2015-01-20T21:00:00.000Z\t3.141500000000\ttrue\tLorem ipsum dolor sit amet.\t122\n124\tabc\t2015-01-20T21:00:00.000Z\t7.342000000000\tfalse\tLorem ipsum \n\ndolor \"sit\" amet.\t546756\n125\tabc\t2015-01-20T21:00:00.000Z\t9.334000000000\tfalse\tLorem ipsum \"dolor\" sit amet.\t23\n126\tabc\t2015-01-20T21:00:00.000Z\t1.345000000000\ttrue\tLorem, ipsum, dolor sit amet.\t434\n127\tabc\t2015-01-20T21:00:00.000Z\t1.533210000000\ttrue\tLorem ipsum dolor sit amet.\t112\n", "{\"columnCount\":7,\"columns\":[{\"index\":0,\"name\":\"f0\",\"type\":\"INT\"},{\"index\":1,\"name\":\"f1\",\"type\":\"STRING\"},{\"index\":2,\"name\":\"f2\",\"type\":\"DATE\"},{\"index\":3,\"name\":\"f3\",\"type\":\"DOUBLE\"},{\"index\":4,\"name\":\"f4\",\"type\":\"BOOLEAN\"},{\"index\":5,\"name\":\"f5\",\"type\":\"STRING\"},{\"index\":6,\"name\":\"f6\",\"type\":\"INT\"}],\"timestampIndex\":-1}", 5L, 5L);
        });
    }

    @Test
    public void testDateFormat() throws Exception {
        this.assertNoLeak(textLoader -> {
            String csv = "\"name\",\"date\"\n\"\u0412\u0441\u0435\u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0435 \u0441\u043f\u043e\u0440\u0442\u0438\u0432\u043d\u044b\u0435 \u0441\u043e\u0440\u0435\u0432\u043d\u043e\u0432\u0430\u043d\u0438\u044f \u0448\u043a\u043e\u043b\u044c\u043d\u0438\u043a\u043e\u0432 \u00ab\u041f\u0420\u0415\u0417\u0418\u0414\u0415\u041d\u0422\u0421\u041a\u0418\u0415 \u0421\u041e\u0421\u0422\u042f\u0417\u0410\u041d\u0418\u042f\u00bb\",\"3 \u0438\u044e\u043b\u044f 2017 \u0433.\"\n\"\u0412\u0441\u0435\u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0435 \u0441\u043f\u043e\u0440\u0442\u0438\u0432\u043d\u044b\u0435 \u0438\u0433\u0440\u044b \u0448\u043a\u043e\u043b\u044c\u043d\u0438\u043a\u043e\u0432 \u00ab\u041f\u0420\u0415\u0417\u0418\u0414\u0415\u041d\u0422\u0421\u041a\u0418\u0415 \u0421\u041f\u041e\u0420\u0422\u0418\u0412\u041d\u042b\u0415 \u0418\u0413\u0420\u042b\u00bb\",\"10 \u043c\u0430\u0440\u0442\u0430 2018 \u0433.\"\n\"\u0412\u0441\u0435\u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0439 \u043b\u0435\u0442\u043d\u0438\u0439 \u0424\u0415\u0421\u0422\u0418\u0412\u0410\u041b\u042c \u0413\u0422\u041e\",\"28 \u0444\u0435\u0432\u0440\u0430\u043b\u044f 2016 \u0433.\"\n";
            String expected = "name\tdate\n\u0412\u0441\u0435\u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0435 \u0441\u043f\u043e\u0440\u0442\u0438\u0432\u043d\u044b\u0435 \u0441\u043e\u0440\u0435\u0432\u043d\u043e\u0432\u0430\u043d\u0438\u044f \u0448\u043a\u043e\u043b\u044c\u043d\u0438\u043a\u043e\u0432 \u00ab\u041f\u0420\u0415\u0417\u0418\u0414\u0415\u041d\u0422\u0421\u041a\u0418\u0415 \u0421\u041e\u0421\u0422\u042f\u0417\u0410\u041d\u0418\u042f\u00bb\t2017-07-03T00:00:00.000Z\n\u0412\u0441\u0435\u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0435 \u0441\u043f\u043e\u0440\u0442\u0438\u0432\u043d\u044b\u0435 \u0438\u0433\u0440\u044b \u0448\u043a\u043e\u043b\u044c\u043d\u0438\u043a\u043e\u0432 \u00ab\u041f\u0420\u0415\u0417\u0418\u0414\u0415\u041d\u0422\u0421\u041a\u0418\u0415 \u0421\u041f\u041e\u0420\u0422\u0418\u0412\u041d\u042b\u0415 \u0418\u0413\u0420\u042b\u00bb\t2018-03-10T00:00:00.000Z\n\u0412\u0441\u0435\u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0439 \u043b\u0435\u0442\u043d\u0438\u0439 \u0424\u0415\u0421\u0422\u0418\u0412\u0410\u041b\u042c \u0413\u0422\u041e\t2016-02-28T00:00:00.000Z\n";
            this.configureLoaderDefaults(textLoader);
            this.playJson(textLoader, "[\n  {\n    \"name\": \"date\",\n    \"type\": \"DATE\",\n    \"pattern\": \"d MMMM y \u0433.\",\n    \"locale\": \"ru-RU\"\n  }\n]");
            textLoader.setForceHeaders(true);
            textLoader.setState(1);
            this.playText0(textLoader, csv, 1024, ENTITY_MANIPULATOR);
            sink.clear();
            textLoader.getMetadata().toJson((CharSink)sink);
            TestUtils.assertEquals((CharSequence)"{\"columnCount\":2,\"columns\":[{\"index\":0,\"name\":\"name\",\"type\":\"STRING\"},{\"index\":1,\"name\":\"date\",\"type\":\"DATE\"}],\"timestampIndex\":-1}", (CharSequence)sink);
            Assert.assertEquals((long)3L, (long)textLoader.getParsedLineCount());
            Assert.assertEquals((long)3L, (long)textLoader.getWrittenLineCount());
            this.assertTable(expected);
            textLoader.clear();
        });
    }

    @Test
    public void testIgnoreLongLine() throws Exception {
        this.assertNoLeak(textLoader -> {
            String expected = "f0\tf1\tf2\tf3\tf4\tf5\tf6\tf7\tf8\tf9\nCMP2\t8\t8000\t2.276363521814\t2015-01-29T19:15:09.000Z\t2015-01-29T19:15:09.000Z\t2015-01-29T00:00:00.000Z\t323\ttrue\t14925407\nCMP1\t2\t1581\t9.014234810602\t2015-01-30T19:15:09.000Z\t2015-01-30T19:15:09.000Z\t2015-01-30T00:00:00.000Z\t9138\tfalse\t68225213\nCMP2\t8\t7067\t9.628433610778\t2015-01-31T19:15:09.000Z\t2015-01-31T19:15:09.000Z\t2015-01-31T00:00:00.000Z\t8197\ttrue\t58403960\nCMP1\t8\t5313\t8.877646618057\t2015-02-01T19:15:09.000Z\t2015-02-01T19:15:09.000Z\t2015-02-01T00:00:00.000Z\t2733\tfalse\t69698373\n\t4\t3883\t7.968730193097\t2015-02-02T19:15:09.000Z\t2015-02-02T19:15:09.000Z\t2015-02-02T00:00:00.000Z\t6912\ttrue\t91147394\nCMP1\t7\t4256\t2.465535225347\t2015-02-03T19:15:09.000Z\t2015-02-03T19:15:09.000Z\t2015-02-03T00:00:00.000Z\t9453\tfalse\t50278940\nCMP1\t7\t4486\tNaN\t2015-02-05T19:15:09.000Z\t2015-02-05T19:15:09.000Z\t2015-02-05T00:00:00.000Z\t8670\tfalse\t751877\nCMP2\t2\t6641\t0.038182535209\t2015-02-06T19:15:09.000Z\t2015-02-06T19:15:09.000Z\t2015-02-06T00:00:00.000Z\t8331\ttrue\t409092527\nCMP1\t1\t3579\t0.849663221743\t2015-02-07T19:15:09.000Z\t2015-02-07T19:15:09.000Z\t2015-02-07T00:00:00.000Z\t9592\tfalse\t11490662\nCMP2\t2\t4770\t2.850920334458\t2015-02-08T19:15:09.000Z\t2015-02-08T19:15:09.000Z\t2015-02-08T00:00:00.000Z\t253\ttrue\t33766814\nCMP1\t5\t4938\t4.427544984501\t2015-02-09T19:15:09.000Z\t2015-02-09T19:15:09.000Z\t2015-02-09T00:00:00.000Z\t7817\tfalse\t61983099\n";
            String csv = "CMP2,8,8000,2.27636352181435,2015-01-29T19:15:09.000Z,2015-01-29 19:15:09,01/29/2015,323,TRUE,14925407\nCMP1,2,1581,9.01423481060192,2015-01-30T19:15:09.000Z,2015-01-30 19:15:09,01/30/2015,9138,FALSE,68225213\nCMP2,8,7067,9.6284336107783,2015-01-31T19:15:09.000Z,2015-01-31 19:15:09,01/31/2015,8197,TRUE,58403960\nCMP1,8,5313,8.87764661805704,2015-02-01T19:15:09.000Z,2015-02-01 19:15:09,02/01/2015,2733,FALSE,69698373\n,4,3883,7.96873019309714,2015-02-02T19:15:09.000Z,2015-02-02 19:15:09,02/02/2015,6912,TRUE,91147394\nCMP1,7,4256,2.46553522534668,2015-02-03T19:15:09.000Z,2015-02-03 19:15:09,02/03/2015,9453,FALSE,50278940\nCMP2dwkjqwelkrkqjwrasdsdfhaksjhfkahsfasdfasfasfas,4,155,5.08547495584935,2015-02-04T19:15:09.000Z,2015-02-04 19:15:09,02/04/2015,8919,TRUE,867198908\nCMP1,7,4486,,2015-02-05T19:15:09.000Z,2015-02-05 19:15:09,02/05/2015,8670,FALSE,751877\nCMP2,2,6641,0.0381825352087617,2015-02-06T19:15:09.000Z,2015-02-06 19:15:09,02/06/2015,8331,TRUE,409092527\nCMP1,1,3579,0.849663221742958,2015-02-07T19:15:09.000Z,2015-02-07 19:15:09,02/07/2015,9592,FALSE,11490662\nCMP2,2,4770,2.85092033445835,2015-02-08T19:15:09.000Z,2015-02-08 19:15:09,02/08/2015,253,TRUE,33766814\nCMP1,5,4938,4.42754498450086,2015-02-09T19:15:09.000Z,2015-02-09 19:15:09,02/09/2015,7817,FALSE,61983099\n";
            try (TextLoader loader = new TextLoader(configuration, (TextConfiguration)new DefaultTextConfiguration(){

                public long getRollBufferLimit() {
                    return 128L;
                }

                public long getRollBufferSize() {
                    return 32L;
                }
            }, (CairoEngine)engine, com.questdb.std.time.DateLocaleFactory.INSTANCE, new DateFormatFactory(), DateLocaleFactory.INSTANCE, new com.questdb.std.microtime.DateFormatFactory());){
                this.configureLoaderDefaults(loader, (byte)44);
                this.playText(loader, csv, 240, expected, "{\"columnCount\":10,\"columns\":[{\"index\":0,\"name\":\"f0\",\"type\":\"STRING\"},{\"index\":1,\"name\":\"f1\",\"type\":\"INT\"},{\"index\":2,\"name\":\"f2\",\"type\":\"INT\"},{\"index\":3,\"name\":\"f3\",\"type\":\"DOUBLE\"},{\"index\":4,\"name\":\"f4\",\"type\":\"DATE\"},{\"index\":5,\"name\":\"f5\",\"type\":\"DATE\"},{\"index\":6,\"name\":\"f6\",\"type\":\"DATE\"},{\"index\":7,\"name\":\"f7\",\"type\":\"INT\"},{\"index\":8,\"name\":\"f8\",\"type\":\"BOOLEAN\"},{\"index\":9,\"name\":\"f9\",\"type\":\"INT\"}],\"timestampIndex\":-1}", 12L, 11L);
            }
        });
    }

    @Test
    public void testDateFormatNoLocale() throws Exception {
        DateLocale locale = com.questdb.std.time.DateLocaleFactory.INSTANCE.getDefaultDateLocale();
        this.assertNoLeak(textLoader -> {
            String csv = "\"name\",\"date\"\n\"\u0412\u0441\u0435\u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0435 \u0441\u043f\u043e\u0440\u0442\u0438\u0432\u043d\u044b\u0435 \u0441\u043e\u0440\u0435\u0432\u043d\u043e\u0432\u0430\u043d\u0438\u044f \u0448\u043a\u043e\u043b\u044c\u043d\u0438\u043a\u043e\u0432 \u00ab\u041f\u0420\u0415\u0417\u0418\u0414\u0415\u041d\u0422\u0421\u041a\u0418\u0415 \u0421\u041e\u0421\u0422\u042f\u0417\u0410\u041d\u0418\u042f\u00bb\",\"3 " + locale.getMonth(6) + " 2017 \u0433.\"\n\"\u0412\u0441\u0435\u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0435 \u0441\u043f\u043e\u0440\u0442\u0438\u0432\u043d\u044b\u0435 \u0438\u0433\u0440\u044b \u0448\u043a\u043e\u043b\u044c\u043d\u0438\u043a\u043e\u0432 \u00ab\u041f\u0420\u0415\u0417\u0418\u0414\u0415\u041d\u0422\u0421\u041a\u0418\u0415 \u0421\u041f\u041e\u0420\u0422\u0418\u0412\u041d\u042b\u0415 \u0418\u0413\u0420\u042b\u00bb\",\"10 " + locale.getMonth(2) + " 2018 \u0433.\"\n\"\u0412\u0441\u0435\u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0439 \u043b\u0435\u0442\u043d\u0438\u0439 \u0424\u0415\u0421\u0422\u0418\u0412\u0410\u041b\u042c \u0413\u0422\u041e\",\"28 " + locale.getMonth(1) + " 2016 \u0433.\"\n";
            String expected = "name\tdate\n\u0412\u0441\u0435\u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0435 \u0441\u043f\u043e\u0440\u0442\u0438\u0432\u043d\u044b\u0435 \u0441\u043e\u0440\u0435\u0432\u043d\u043e\u0432\u0430\u043d\u0438\u044f \u0448\u043a\u043e\u043b\u044c\u043d\u0438\u043a\u043e\u0432 \u00ab\u041f\u0420\u0415\u0417\u0418\u0414\u0415\u041d\u0422\u0421\u041a\u0418\u0415 \u0421\u041e\u0421\u0422\u042f\u0417\u0410\u041d\u0418\u042f\u00bb\t2017-07-03T00:00:00.000Z\n\u0412\u0441\u0435\u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0435 \u0441\u043f\u043e\u0440\u0442\u0438\u0432\u043d\u044b\u0435 \u0438\u0433\u0440\u044b \u0448\u043a\u043e\u043b\u044c\u043d\u0438\u043a\u043e\u0432 \u00ab\u041f\u0420\u0415\u0417\u0418\u0414\u0415\u041d\u0422\u0421\u041a\u0418\u0415 \u0421\u041f\u041e\u0420\u0422\u0418\u0412\u041d\u042b\u0415 \u0418\u0413\u0420\u042b\u00bb\t2018-03-10T00:00:00.000Z\n\u0412\u0441\u0435\u0440\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0439 \u043b\u0435\u0442\u043d\u0438\u0439 \u0424\u0415\u0421\u0422\u0418\u0412\u0410\u041b\u042c \u0413\u0422\u041e\t2016-02-28T00:00:00.000Z\n";
            this.configureLoaderDefaults(textLoader, (byte)44, 2);
            this.playJson(textLoader, "[\n  {\n    \"name\": \"date\",\n    \"type\": \"DATE\",\n    \"pattern\": \"d MMMM y \u0433.\"\n  }\n]");
            textLoader.setForceHeaders(true);
            textLoader.setState(1);
            this.playText0(textLoader, csv, 1024, ENTITY_MANIPULATOR);
            sink.clear();
            textLoader.getMetadata().toJson((CharSink)sink);
            TestUtils.assertEquals((CharSequence)"{\"columnCount\":2,\"columns\":[{\"index\":0,\"name\":\"name\",\"type\":\"STRING\"},{\"index\":1,\"name\":\"date\",\"type\":\"DATE\"}],\"timestampIndex\":-1}", (CharSequence)sink);
            Assert.assertEquals((long)3L, (long)textLoader.getParsedLineCount());
            Assert.assertEquals((long)3L, (long)textLoader.getWrittenLineCount());
            this.assertTable(expected);
            textLoader.clear();
        });
    }

    @Test
    public void testDelimiterPriority() throws Exception {
        this.assertNoLeak(textLoader -> {
            String expected = "f0\tf1\tf2\n;;;\t;;\t0.000000000000\n;;;\t;;\t0.000000000000\n";
            String csv = ";;;,;;,....\n;;;,;;,....\n";
            this.configureLoaderDefaults(textLoader);
            textLoader.setForceHeaders(false);
            this.playText(textLoader, csv, 200, "f0\tf1\tf2\n;;;\t;;\t0.000000000000\n;;;\t;;\t0.000000000000\n", "{\"columnCount\":3,\"columns\":[{\"index\":0,\"name\":\"f0\",\"type\":\"STRING\"},{\"index\":1,\"name\":\"f1\",\"type\":\"STRING\"},{\"index\":2,\"name\":\"f2\",\"type\":\"DOUBLE\"}],\"timestampIndex\":-1}", 2L, 2L);
        });
    }

    @Test
    public void testDelimiterPriority2() throws Exception {
        this.assertNoLeak(textLoader -> {
            String expected = "f0\tf1\tf2\n   \t  \t  \n   \t  \t  \n";
            String csv = "   |  |  \n   |  |  \n";
            this.configureLoaderDefaults(textLoader);
            textLoader.setForceHeaders(false);
            this.playText(textLoader, csv, 200, "f0\tf1\tf2\n   \t  \t  \n   \t  \t  \n", "{\"columnCount\":3,\"columns\":[{\"index\":0,\"name\":\"f0\",\"type\":\"STRING\"},{\"index\":1,\"name\":\"f1\",\"type\":\"STRING\"},{\"index\":2,\"name\":\"f2\",\"type\":\"STRING\"}],\"timestampIndex\":-1}", 2L, 2L);
        });
    }

    @Test
    public void testDelimiterPriority3() throws Exception {
        this.assertNoLeak(textLoader -> {
            String expected = "f0\tf1\tf2\tf3\n+\t+\t+\t+\n+\t+\t+\t+\n";
            String csv = "+-+-+-+\n+-+-+-+\n";
            this.configureLoaderDefaults(textLoader);
            textLoader.setForceHeaders(false);
            this.playText(textLoader, csv, 200, "f0\tf1\tf2\tf3\n+\t+\t+\t+\n+\t+\t+\t+\n", "{\"columnCount\":4,\"columns\":[{\"index\":0,\"name\":\"f0\",\"type\":\"STRING\"},{\"index\":1,\"name\":\"f1\",\"type\":\"STRING\"},{\"index\":2,\"name\":\"f2\",\"type\":\"STRING\"},{\"index\":3,\"name\":\"f3\",\"type\":\"STRING\"}],\"timestampIndex\":-1}", 2L, 2L);
        });
    }

    @Test
    public void testHeaders() throws Exception {
        this.assertNoLeak(textLoader -> {
            String expected = "type\tvalue\tactive\tdesc\tgrp\nABC\t13\ttrue\tbrown fox jumped over the fence\tGROUP1\nCDE\t14\tfalse\tsentence 1\nsentence 2\tGROUP1\nXYZ\t16\ttrue\t\tGROUP2\nXCB\t29\ttrue\tthis is not the end\tGROUP2\n";
            String csv = "type,value,active,desc,grp\nABC,13,TRUE,brown fox jumped over the fence,GROUP1\nCDE,14,FALSE,\"sentence 1\nsentence 2\",GROUP1\nEFD,14.4,FALSE,xyz > ?abc?,GROUP1\nXYZ,16,TRUE,,GROUP2\nXCB,29,TRUE,this is not the end,GROUP2\n";
            this.configureLoaderDefaults(textLoader, (byte)44);
            this.playText(textLoader, csv, 85, "type\tvalue\tactive\tdesc\tgrp\nABC\t13\ttrue\tbrown fox jumped over the fence\tGROUP1\nCDE\t14\tfalse\tsentence 1\nsentence 2\tGROUP1\nXYZ\t16\ttrue\t\tGROUP2\nXCB\t29\ttrue\tthis is not the end\tGROUP2\n", "{\"columnCount\":5,\"columns\":[{\"index\":0,\"name\":\"type\",\"type\":\"STRING\"},{\"index\":1,\"name\":\"value\",\"type\":\"INT\"},{\"index\":2,\"name\":\"active\",\"type\":\"BOOLEAN\"},{\"index\":3,\"name\":\"desc\",\"type\":\"STRING\"},{\"index\":4,\"name\":\"grp\",\"type\":\"STRING\"}],\"timestampIndex\":-1}", 5L, 4L);
        });
    }

    @Test
    public void testHeadersLargerBuffer() throws Exception {
        this.assertNoLeak(textLoader -> {
            String expected = "type\tvalue\tactive\tdesc\tgrp\nABC\t13.000000000000\ttrue\tbrown fox jumped over the fence\tGROUP1\nCDE\t14.000000000000\tfalse\tsentence 1\nsentence 2\tGROUP1\nEFD\t14.400000000000\tfalse\txyz > ?abc?\tGROUP1\nXYZ\t16.000000000000\ttrue\t\tGROUP2\nXCB\t29.000000000000\ttrue\tthis is not the end\tGROUP2\n";
            String csv = "type,value,active,desc,grp\nABC,13,TRUE,brown fox jumped over the fence,GROUP1\nCDE,14,FALSE,\"sentence 1\nsentence 2\",GROUP1\nEFD,14.4,FALSE,xyz > ?abc?,GROUP1\nXYZ,16,TRUE,,GROUP2\nXCB,29,TRUE,this is not the end,GROUP2\n";
            this.configureLoaderDefaults(textLoader, (byte)44);
            this.playText(textLoader, csv, 250, "type\tvalue\tactive\tdesc\tgrp\nABC\t13.000000000000\ttrue\tbrown fox jumped over the fence\tGROUP1\nCDE\t14.000000000000\tfalse\tsentence 1\nsentence 2\tGROUP1\nEFD\t14.400000000000\tfalse\txyz > ?abc?\tGROUP1\nXYZ\t16.000000000000\ttrue\t\tGROUP2\nXCB\t29.000000000000\ttrue\tthis is not the end\tGROUP2\n", "{\"columnCount\":5,\"columns\":[{\"index\":0,\"name\":\"type\",\"type\":\"STRING\"},{\"index\":1,\"name\":\"value\",\"type\":\"DOUBLE\"},{\"index\":2,\"name\":\"active\",\"type\":\"BOOLEAN\"},{\"index\":3,\"name\":\"desc\",\"type\":\"STRING\"},{\"index\":4,\"name\":\"grp\",\"type\":\"STRING\"}],\"timestampIndex\":-1}", 5L, 5L);
        });
    }

    @Test
    public void testHeadersNumeric() throws Exception {
        this.assertNoLeak(textLoader -> {
            String expected = "type\tvalue\tactive\tdesc\t_1\nABC\txy\ta\tbrown fox jumped over the fence\t10\nCDE\tbb\tb\tsentence 1\nsentence 2\t12\n";
            String csv = "type,value,active,desc,1\nABC,xy,a,brown fox jumped over the fence,10\nCDE,bb,b,\"sentence 1\nsentence 2\",12\n";
            this.configureLoaderDefaults(textLoader);
            textLoader.setForceHeaders(true);
            textLoader.setState(1);
            this.playText(textLoader, csv, 90, "type\tvalue\tactive\tdesc\t_1\nABC\txy\ta\tbrown fox jumped over the fence\t10\nCDE\tbb\tb\tsentence 1\nsentence 2\t12\n", "{\"columnCount\":5,\"columns\":[{\"index\":0,\"name\":\"type\",\"type\":\"STRING\"},{\"index\":1,\"name\":\"value\",\"type\":\"STRING\"},{\"index\":2,\"name\":\"active\",\"type\":\"STRING\"},{\"index\":3,\"name\":\"desc\",\"type\":\"STRING\"},{\"index\":4,\"name\":\"_1\",\"type\":\"INT\"}],\"timestampIndex\":-1}", 2L, 2L);
        });
    }

    @Test
    public void testLineRoll() throws Exception {
        this.assertNoLeak(textLoader -> {
            String expected = "f0\tf1\tf2\tf3\tf4\tf5\tf6\tf7\tf8\tf9\n\"CMP2\t8\t8000\t2.276363521814\t2015-01-29T19:15:09.000Z\t2015-01-29T19:15:09.000Z\t2015-01-29T00:00:00.000Z\t323\ttrue\t14925407\nCMP1\t2\t1581\t9.014234810602\t2015-01-30T19:15:09.000Z\t2015-01-30T19:15:09.000Z\t2015-01-30T00:00:00.000Z\t9138\tfalse\t68225213\nCMP2\t8\t7067\t9.628433610778\t2015-01-31T19:15:09.000Z\t2015-01-31T19:15:09.000Z\t2015-01-31T00:00:00.000Z\t8197\ttrue\t58403960\nCMP1\t8\t5313\t8.877646618057\t2015-02-01T19:15:09.000Z\t2015-02-01T19:15:09.000Z\t2015-02-01T00:00:00.000Z\t2733\tfalse\t69698373\n\t4\t3883\t7.968730193097\t2015-02-02T19:15:09.000Z\t2015-02-02T19:15:09.000Z\t2015-02-02T00:00:00.000Z\t6912\ttrue\t91147394\nCMP1\t7\t4256\t2.465535225347\t2015-02-03T19:15:09.000Z\t2015-02-03T19:15:09.000Z\t2015-02-03T00:00:00.000Z\t9453\tfalse\t50278940\nCMP2\t4\t155\t5.085474955849\t2015-02-04T19:15:09.000Z\t2015-02-04T19:15:09.000Z\t2015-02-04T00:00:00.000Z\t8919\ttrue\t8671995\nCMP1\t7\t4486\tNaN\t2015-02-05T19:15:09.000Z\t2015-02-05T19:15:09.000Z\t2015-02-05T00:00:00.000Z\t8670\tfalse\t751877\nCMP2\t2\t6641\t0.038182535209\t2015-02-06T19:15:09.000Z\t2015-02-06T19:15:09.000Z\t2015-02-06T00:00:00.000Z\t8331\ttrue\t40909232527\nCMP1\t1\t3579\t0.849663221743\t2015-02-07T19:15:09.000Z\t2015-02-07T19:15:09.000Z\t2015-02-07T00:00:00.000Z\t9592\tfalse\t11490662\nCMP2\t2\t4770\t2.850920334458\t2015-02-08T19:15:09.000Z\t2015-02-08T19:15:09.000Z\t2015-02-08T00:00:00.000Z\t253\ttrue\t33766814\nCMP1\t5\t4938\t4.427544984501\t2015-02-09T19:15:09.000Z\t2015-02-09T19:15:09.000Z\t2015-02-09T00:00:00.000Z\t7817\tfalse\t61983099\n";
            String csv = "\"\"\"CMP2\",8,8000,2.27636352181435,2015-01-29T19:15:09.000Z,2015-01-29 19:15:09,01/29/2015,323,TRUE,14925407\nCMP1,2,1581,9.01423481060192,2015-01-30T19:15:09.000Z,2015-01-30 19:15:09,01/30/2015,9138,FALSE,68225213\nCMP2,8,7067,9.6284336107783,2015-01-31T19:15:09.000Z,2015-01-31 19:15:09,01/31/2015,8197,TRUE,58403960\nCMP1,8,5313,8.87764661805704,2015-02-01T19:15:09.000Z,2015-02-01 19:15:09,02/01/2015,2733,FALSE,69698373\n,4,3883,7.96873019309714,2015-02-02T19:15:09.000Z,2015-02-02 19:15:09,02/02/2015,6912,TRUE,91147394\nCMP1,7,4256,2.46553522534668,2015-02-03T19:15:09.000Z,2015-02-03 19:15:09,02/03/2015,9453,FALSE,50278940\nCMP2,4,155,5.08547495584935,2015-02-04T19:15:09.000Z,2015-02-04 19:15:09,02/04/2015,8919,TRUE,8671995\n\"CMP1\",7,4486,,2015-02-05T19:15:09.000Z,2015-02-05 19:15:09,02/05/2015,8670,FALSE,751877\nCMP2,2,6641,0.0381825352087617,2015-02-06T19:15:09.000Z,2015-02-06 19:15:09,02/06/2015,8331,TRUE,40909232527\nCMP1,1,3579,0.849663221742958,2015-02-07T19:15:09.000Z,2015-02-07 19:15:09,02/07/2015,9592,FALSE,11490662\nCMP2,2,4770,2.85092033445835,2015-02-08T19:15:09.000Z,2015-02-08 19:15:09,02/08/2015,253,TRUE,33766814\nCMP1,5,4938,4.42754498450086,2015-02-09T19:15:09.000Z,2015-02-09 19:15:09,02/09/2015,7817,FALSE,61983099\n";
            try (TextLoader loader = new TextLoader(configuration, (TextConfiguration)new DefaultTextConfiguration(){

                public long getRollBufferLimit() {
                    return 128L;
                }

                public long getRollBufferSize() {
                    return 32L;
                }
            }, (CairoEngine)engine, com.questdb.std.time.DateLocaleFactory.INSTANCE, new DateFormatFactory(), DateLocaleFactory.INSTANCE, new com.questdb.std.microtime.DateFormatFactory());){
                this.configureLoaderDefaults(loader, (byte)44);
                this.playText(loader, csv, 1024, expected, "{\"columnCount\":10,\"columns\":[{\"index\":0,\"name\":\"f0\",\"type\":\"STRING\"},{\"index\":1,\"name\":\"f1\",\"type\":\"INT\"},{\"index\":2,\"name\":\"f2\",\"type\":\"INT\"},{\"index\":3,\"name\":\"f3\",\"type\":\"DOUBLE\"},{\"index\":4,\"name\":\"f4\",\"type\":\"DATE\"},{\"index\":5,\"name\":\"f5\",\"type\":\"DATE\"},{\"index\":6,\"name\":\"f6\",\"type\":\"DATE\"},{\"index\":7,\"name\":\"f7\",\"type\":\"INT\"},{\"index\":8,\"name\":\"f8\",\"type\":\"BOOLEAN\"},{\"index\":9,\"name\":\"f9\",\"type\":\"LONG\"}],\"timestampIndex\":-1}", 12L, 12L);
            }
        });
    }

    @Test
    public void testIllegalCharactersInHeader() throws Exception {
        this.assertNoLeak(textLoader -> {
            String csv = "\"%1\",,\"(\u0412\u0438\u0434 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e \u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"'\u0422\u0435\u043c\u0430 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0433\u043e \u043c\u0435\u0440\u043e\u043f\u0440\u0438\u044f\u0442\u0438\u044f\",\"+\u041f\u0440\u043e\u0432\u0435\u0440\u044f\u0435\u043c\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434\",123,\"\u041e\u043a\u043e\u043d\u0447\u0430\u043d\u0438\u0435 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\",\"\u0412\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f, \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438\",\"\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442\u044b \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438\"\n1,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0443\u043d\u0438\u0442\u0430\u0440\u043d\u043e\u0435 \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u0435 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0435 \u0442\u0435\u043f\u043b\u043e\u0432\u044b\u0435 \u0441\u0435\u0442\u0438\u00bb\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2015\u0433. - 31.12.2015\u0433.\",\"09.03.2016\u0433.\",\"01.04.2016\u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                          - \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0434\u0435\u043d\u0435\u0436\u043d\u044b\u0445 \u0441\u0440\u0435\u0434\u0441\u0442\u0432;                                            -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043f\u0440\u0435\u0434\u043f\u0440\u0438\u044f\u0442\u0438\u044f.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.04.2016 \u0433\u043e\u0434\u0430\"\n2,\"\u041e\u0410\u041e \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0430\u044f \u0410\u041a \u21161468\u00bb\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0414\u043e\u043f\u043e\u043b\u043d\u0438\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u041e\u0410\u041e \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0430\u044f \u0410\u041a \u21161468\u00bb \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043d\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043e\u043a \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 \u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430\u043c \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u043e\u0442 31.12.2015 \u0433\u043e\u0434\u0430 \u2116 12-53\",\"01 - 29.02.16 \u0433.  01.01.2016 \u0433. -  31.01.2016 \u0433.,   01.03.2016 \u0433. - 30.04.2016 \u0433.\",\"04.04.2016\u0433.  10.05.2016\u0433.\",\"15.04.2016\u0433.  31.05.2016\u0433.\",\"\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0443\u0441\u043b\u043e\u0432\u0438\u0439 \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u0430 \u043d\u0430 \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \n\u043f\u0435\u0440\u0435\u0432\u043e\u0437\u043e\u043a \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432 \u043f\u043e \u043c\u0430\u0440\u0448\u0440\u0443\u0442\u0430\u043c \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \n\u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u043e\u0442 31.12.2015 \u0433\u043e\u0434\u0430 \u211612-53    \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 20.06.2016 \u0433\u043e\u0434\u0430\"\n3,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438; \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\",\"01.01.2015 \u0433. -                   31.01.2016 \u0433.\",\"08.02.2016\u0433 \u043f\u0435\u0440\u0435\u0440\u044b\u0432 04.05.2016.\",\"04.03.2016\u0433. 38 \u0440\u0430\u0431. \u0434\u043d\u0435\u0439 06.05.2016\u0433.\",\"\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                               - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                             \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 01.07.2016 \u0433\u043e\u0434\u0430\"\n4,\"\u041c\u041a\u0423\u041a \u00ab\u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438; \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\",\"01.01.2015 \u0433. - 31.05.2016 \u0433.\",\"06.06.2016\u0433.\",\"27.06.2016\u0433.\",\"\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                                     \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 11.08.2016 \u0433\u043e\u0434\u0430\"\n5,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438, \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439  \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u043e\u0442\u043d\u043e\u0448\u0435\u043d\u0438\u0438 \u0432\u043e\u043f\u0440\u043e\u0441\u043e\u0432, \u043f\u0440\u0435\u0434\u0443\u0441\u043c\u043e\u0442\u0440\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u211644-\u0444\u0437\",\"01.01.2015 \u0433. - 30.06.2016 \u0433.\",\"11.07.2016\u0433.\",\"29.07.2016\u0433.\",\"\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.                                                                     \u041f\u043e \u0424\u0417 \u211644-\u0444\u0437 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u043d\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043e.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 10.09.2016 \u0433\u043e\u0434\u0430\"\n6,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0430\u0432\u0442\u043e\u043d\u043e\u043c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041c\u0424\u0426 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430\u00bb\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e- \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2015 \u0433. - 19.09.2016 \u0433.\",\"18.08.2016\u0433.\",\"19.09.2016\u0433.\",\"- \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u041f\u0440\u0430\u0432\u0438\u043b \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u0438 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438 \u043c\u043d\u043e\u0433\u043e\u0444\u0443\u043d\u043a\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0445 \u0446\u0435\u043d\u0442\u0440\u043e\u0432 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u044b\u0445 \u043f\u043e\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u041f\u0440\u0430\u0432\u0438\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0420\u0424 \u043e\u0442 22.12.2012 \u0433\u043e\u0434\u0430 \u2116 1376.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.10.2016 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 07.11.2016 \u0433\u043e\u0434\u0430\"\n7,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2015 \u0433. - 31.08.2016 \u0433.\",\"22.09.2016\u0433.\",\"14.10.2016\u0433.\",\"\u0447.2 \u0441\u0442.34; \u043f.4 \u0441\u0442.38; \u0441\u0442.94; \u0441\u0442.95; \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;    - \u043f.1 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424- \u043f.1 \u0441\u0442.432; \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465; \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;           - \u043f.11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430 N 157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 21.11.2016 \u0433\u043e\u0434\u0430\"\n8,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2015 \u0433. - 31.08.2016 \u0433.\",\"22.09.2016\u0433.\",\"14.10.2016\u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                            - \u043d\u0435\u0446\u0435\u043b\u0435\u0432\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430;                                                     -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                   - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 14.12.2016 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 19.12.2016 \u0433\u043e\u0434\u0430\"\n9,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u00ab\u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2015\u0433 \u2014 31.10.2016\u0433\",\"01.11.2016 \u0433.\",\"11.11.2016 \u0433.\",\"\u0447.4 \u0441\u0442.30; \u0447.2 \u0441\u0442.34; \u043f.4 \u0441\u0442.38; \u0441\u0442.94; \u0447. 2, \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                           - \u043f.2 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;      - \u043f.1 \u0441\u0442.432; \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465; \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;           - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433.\u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                              - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  N 157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.12.2016 \u0433\u043e\u0434\u0430\"\n10,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u043a\u0430\u0437\u0435\u043d\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b \u00ab\u0412\u0435\u0440\u0445\u043d\u0435\u0441\u0435\u0440\u0435\u0431\u0440\u044f\u043d\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2015\u0433 \u2014 31.10.2016\u0433\",\"03.08.2016\u0433 \u043f\u0435\u0440\u0435\u0440\u044b\u0432 26.10.2016.\",\"18.08.2016\u0433. 48 \u0440\u0430\u0431. \u0434\u043d\u0435\u0439 11.11.2016\u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                           -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                  - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 31.01.2017 \u0433\u043e\u0434\u0430 \u0441 \u043f\u0440\u0435\u0434\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435\u043c \u043e\u0442\u0447\u0435\u0442\u0430 \u0434\u043e 10.02.2017 \u0433\u043e\u0434\u0430\"\n11,\"\u041c\u0411\u0423\u0421\u041e\u0421\u0421\u0417\u041d \"\u041a\u043e\u043c\u043f\u043b\u0435\u043a\u0441\u043d\u044b\u0439 \u0446\u0435\u043d\u0442\u0440 \u0441\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u043e\u0431\u0441\u043b\u0443\u0436\u0438\u0432\u0430\u043d\u0438\u044f \u043d\u0430\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430\"\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2016\u0433 \u2014 30.11.2016\u0433\",\"19.12.2016 \u0433.\",\"29.12.2016 \u0433.\",\"\u0447.2 \u0441\u0442.34; \u0441\u0442.94; \u0447. 2, \u0447.3 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                -  \u043f.3 \u0441\u0442.455; \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                   - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433.\u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                             - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116 157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 29.01.2017 \u0433\u043e\u0434\u0430\"\n12,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u0430\u0433\u043e\u0440\u044c\u0435\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438\",\"01.01.2016 \u0433. -                   31.12.2016 \u0433.\",\"23.01.2017\u0433.\",\"15.02.2017 \u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0447\u0430 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;                                                            - \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430;                                                     -\u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                   - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0438 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u043e\u0432 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 10.05.2017 \u0433\u043e\u0434\u0430\"\n13,\"\u041c\u041a\u0423\u041a \u00ab\u041b\u043e\u0437\u043e\u0432\u0441\u043a\u0438\u0439 \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0439 \u0434\u043e\u043c \u043a\u0443\u043b\u044c\u0442\u0443\u0440\u044b\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u043a\u0430\u043c\u0435\u0440\u0430\u043b\u044c\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2015 \u0433. -                   31.12.2016 \u0433.\",\"20.02.2017\u0433.\",\"15.03.2017 \u0433.\",\"\u0447.2 \u0441\u0442.34, \u043f.4 \u0441\u0442.38, \u0441\u0442.93, \u0441\u0442.94, \u0441\u0442.95, \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;     - \u043f.2 \u0441\u0442.73 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;       - \u043f.1 \u0441\u0442.432, \u043f.3 \u0441\u0442.455, \u043f.2 \u0441\u0442.465, \u043f.1 \u0441\u0442.702 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;            - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                 - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116 157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439  \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.04.2017 \u0433\u043e\u0434\u0430\"\n14,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\u00bb \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u0412\u043d\u0435\u043f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u0440\u0430\u043d\u0435\u0435 \u0432\u044b\u0434\u0430\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0433\u043b\u0430\u0432\u0435 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u041b\u043e\u0437\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f\",\"-\",\"23.03.2017\u0433.\",\"23.03.2017 \u0433.\",\"\u041d\u0435\u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u0435 \u0432 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0439 \u0441\u0440\u043e\u043a \u0437\u0430\u043a\u043e\u043d\u043d\u043e\u0433\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0443\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432 \u0438 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0439 \u043f\u043e\u043b\u0438\u0442\u0438\u043a\u0438 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 (\u043f.4 \u0441\u0442. 270.2 \u0411\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u043e\u0439 \u0424\u0435\u0434\u0435\u0440\u0430\u0446\u0438\u0438).\",\"\u0421\u043e\u0441\u0442\u0430\u0432\u043b\u0435\u043d \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b \u043e\u0431 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u043c \u043f\u0440\u0430\u0432\u043e\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0438, \u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u044c \u0437\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u0435 \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0447\u0430\u0441\u0442\u044c\u044e 20 \u0441\u0442\u0430\u0442\u044c\u0438 19.5 \u041a\u043e\u0410\u041f \u0420\u0424. \u0414\u0435\u043b\u043e \u043e\u0431 \u0430\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0442\u0438\u0432\u043d\u043e\u043c \u043f\u0440\u0430\u0432\u043e\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0438 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0435\u0434\u0430\u0442\u0435\u043b\u044e \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u043d\u043e\u0433\u043e \u0441\u0443\u0434\u0430.\"\n15,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u043b\u0435\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2015\u0433.- 31.12.2016\u0433.\",\"20.03.2017\u0433.\",\"11.04.2017\u0433.\",\"- \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0432 \u0441\u0443\u043c\u043c\u0435 0,5 \u0442\u044b\u0441. \u0440\u0443\u0431\u043b\u0435\u0439;                                                  - \u0447.2 \u0441\u0442.34, \u0447.2 \u0441\u0442.93, \u0447.9 \u0441\u0442.94, \u0441\u0442.95, \u0447.2 \u0441\u0442.103 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                                                      - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116 402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\",\"\u0412\u044b\u0434\u0430\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439  \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 18.05.2017 \u0433\u043e\u0434\u0430\"\n16,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041d\u0430\u0433\u043e\u043b\u0435\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438   \u0438 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432, \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430 \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0435 \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u0434\u0430\u043d\u0438\u044f \u043d\u0430 \u043e\u043a\u0430\u0437\u0430\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u0443\u0441\u043b\u0443\u0433\",\"01.01.2015 \u0433.-                  31.01.2016 \u0433.\",\"27.02.2017\u0433.\",\"11.04.2017\u0433.\",\"\u0412\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b. \u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u044b \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438: \u043d\u0430\u043b\u0438\u0447\u0438\u0435 \u043d\u0435\u0434\u043e\u0441\u0442\u043e\u0432\u0435\u0440\u043d\u043e\u0439 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u0438  \u043e \u0441\u043e\u0441\u0442\u0430\u0432\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430 \u0438 \u0435\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0438, \u0437\u0430\u0432\u044b\u0448\u0435\u043d\u0438\u0435 \u043d\u043e\u0440\u043c \u0441\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u0413\u0421\u041c \u0438 \u043f\u0440\u043e\u0447\u0438\u0435. \u0412\u044b\u044f\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430 \u0438 \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 23.06.2017 \u0433\u043e\u0434\u0430\"\n17,\"\u041c\u0410\u0423 \u00ab\u041c\u0424\u0426 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u0440\u0435\u0432\u0438\u0437\u0438\u044f\",\"\u0420\u0435\u0432\u0438\u0437\u0438\u044f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438,  \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0438\u0441\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u044f \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0438 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438 \u043e\u0442 14.10.2016 \u0433\u043e\u0434\u0430 \u21163001\",\"09.2016 \u0433.-05.2017 \u0433.\",\"19.04.2017\u0433\",\"19.05.2017 \u0433.\",\"\u0423\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b.                      \u0412\u044b\u044f\u0432\u043b\u0435\u043d\u043e \u043d\u0435\u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0435 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u0435 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u0432\u044b\u044f\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 21.08.2017 \u0433\u043e\u0434\u0430\"\n18,\"\u041c\u0411\u041e\u0423 \u00ab\u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\u00bb\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0441\u043e\u0431\u043b\u044e\u0434\u0435\u043d\u0438\u044f \u0442\u0440\u0435\u0431\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430\u043a\u043e\u043d\u043e\u0434\u0430\u0442\u0435\u043b\u044c\u0441\u0442\u0432\u0430 \u043e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0440\u0430\u043c\u043a\u0430\u0445 \u043f\u043e\u043b\u043d\u043e\u043c\u043e\u0447\u0438\u0439, \u0443\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044b\u0445 \u0447\u0430\u0441\u0442\u044c\u044e 8 \u0441\u0442\u0430\u0442\u044c\u0438 99 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 05.04.2013 \u0433. \u211644-\u0424\u0417 \u00ab\u041e \u043a\u043e\u043d\u0442\u0440\u0430\u043a\u0442\u043d\u043e\u0439 \u0441\u0438\u0441\u0442\u0435\u043c\u0435 \u0432 \u0441\u0444\u0435\u0440\u0435 \u0437\u0430\u043a\u0443\u043f\u043e\u043a, \u0442\u043e\u0432\u0430\u0440\u043e\u0432, \u0440\u0430\u0431\u043e\u0442, \u0443\u0441\u043b\u0443\u0433 \u0434\u043b\u044f \u043e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u044f \u0433\u043e\u0441\u0443\u0434\u0430\u0440\u0441\u0442\u0432\u0435\u043d\u043d\u044b\u0445 \u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u044b\u0445 \u043d\u0443\u0436\u0434\u00bb\",\"01.01.2016 \u0433. - 30.05.2017 \u0433.\",\"25.05.2017\u0433\",\"20.06.2017 \u0433.\",\"- \u0441\u0442.21, \u0447.2 \u0441\u0442.34, \u043f.4 \u0441\u0442.38, \u0447.2 \u0441\u0442.93, \u0447.9, 11 \u0441\u0442.94, \u0441\u0442.95 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u211644-\u0424\u0417;                                              - \u043f.3 \u0441\u0442.455, \u043f.2 \u0441\u0442.465 \u0413\u0440\u0430\u0436\u0434\u0430\u043d\u0441\u043a\u043e\u0433\u043e \u043a\u043e\u0434\u0435\u043a\u0441\u0430 \u0420\u0424;                                                       - \u0441\u0442. 9, 10 \u0424\u0435\u0434\u0435\u0440\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0437\u0430\u043a\u043e\u043d\u0430 \u043e\u0442 06.12.2011\u0433. \u2116402-\u0424\u0417 \u00ab\u041e \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u043c \u0443\u0447\u0451\u0442\u0435\u00bb;                                  - \u043f.9,11 \u0447.1 \u0418\u043d\u0441\u0442\u0440\u0443\u043a\u0446\u0438\u0438 \u043f\u043e \u043f\u0440\u0438\u043c\u0435\u043d\u0435\u043d\u0438\u044e \u0415\u0434\u0438\u043d\u043e\u0433\u043e \u043f\u043b\u0430\u043d\u0430 \u0441\u0447\u0435\u0442\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u0443\u0442\u0432\u0435\u0440\u0436\u0434\u0435\u043d\u043d\u043e\u0439 \u043f\u0440\u0438\u043a\u0430\u0437\u043e\u043c \u041c\u0438\u043d\u0444\u0438\u043d\u0430 \u0420\u043e\u0441\u0441\u0438\u0438 \u043e\u0442 01.12.2010 \u0433\u043e\u0434\u0430  \u2116157\u043d.\",\"\u041f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\"\n19,\"\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430, \u043f\u0440\u0438\u0440\u043e\u0434\u043e\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0438 \u0440\u0430\u0437\u0432\u0438\u0442\u0438\u044f \u0441\u0435\u043b\u044c\u0441\u043a\u0438\u0445 \u0442\u0435\u0440\u0440\u0438\u0442\u043e\u0440\u0438\u0439\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432, \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043d\u044b\u0445 \u043d\u0430 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044e \u043f\u043e\u0434\u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b_5 \u00ab\u041e\u0431\u0435\u0441\u043f\u0435\u0447\u0435\u043d\u0438\u0435 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b\u00bb \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \u00ab\u0420\u0430\u0437\u0432\u0438\u0442\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430 \u0432 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u043c \u0440\u0430\u0439\u043e\u043d\u0435 \u043d\u0430 2015-2020 \u0433\u043e\u0434\u044b\u00bb\",\"01.01.2016 \u0433. - 31.12.2016 \u0433.\",\"19.01.2017 \u0433. \u043f\u0435\u0440\u0435\u0440\u044b\u0432     01.06.2017 \u0433.\",\"20.01.2017 \u0433.  4\u043c\u0435\u0441. 11\u043a.\u0434\u043d.    07.07.2017 \u0433.\",\"\u041a\u0432\u0430\u0440\u0442\u0430\u043b\u044c\u043d\u044b\u0435 \u0438 \u0433\u043e\u0434\u043e\u0432\u043e\u0439 \u043e\u0442\u0447\u0435\u0442\u044b \u043e \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u0438 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u043f\u0440\u043e\u0433\u0440\u0430\u043c\u043c\u044b \u00ab\u0420\u0430\u0437\u0432\u0438\u0442\u0438\u0435 \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0430 \u0432 \u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u043e\u043c \u0440\u0430\u0439\u043e\u043d\u0435 \u043d\u0430 2015-2020 \u0433\u043e\u0434\u044b\u00bb \u0437\u0430 2016 \u0433\u043e\u0434 \u0441\u043e\u0434\u0435\u0440\u0436\u0430\u0442 \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438.\",\"\u041f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0438\u0435 \u043d\u0435 \u0432\u044b\u0434\u0430\u043d\u043e\"\n20,\"\u0410\u0434\u043c\u0438\u043d\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u044f \u041d\u043e\u0432\u043e\u0430\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\u043e\u0432\u0441\u043a\u043e\u0433\u043e \u0441\u0435\u043b\u044c\u0441\u043a\u043e\u0433\u043e \u043f\u043e\u0441\u0435\u043b\u0435\u043d\u0438\u044f \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0440\u0430\u0439\u043e\u043d\u0430 \"\u0420\u043e\u0432\u0435\u043d\u044c\u0441\u043a\u0438\u0439 \u0440\u0430\u0439\u043e\u043d\" \u0411\u0435\u043b\u0433\u043e\u0440\u043e\u0434\u0441\u043a\u043e\u0439 \u043e\u0431\u043b\u0430\u0441\u0442\u0438\",\"\u041f\u043b\u0430\u043d\u043e\u0432\u0430\u044f \u0432\u044b\u0435\u0437\u0434\u043d\u0430\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0430\",\"\u041f\u0440\u043e\u0432\u0435\u0440\u043a\u0430 \u0446\u0435\u043b\u0435\u0432\u043e\u0433\u043e, \u0440\u0430\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u043e\u0433\u043e \u0438 \u044d\u0444\u0444\u0435\u043a\u0442\u0438\u0432\u043d\u043e\u0433\u043e \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u0438\u044f \u0441\u0440\u0435\u0434\u0441\u0442\u0432 \u043c\u0435\u0441\u0442\u043d\u043e\u0433\u043e \u0431\u044e\u0434\u0436\u0435\u0442\u0430 \u0438 \u0438\u043c\u0443\u0449\u0435\u0441\u0442\u0432\u0430, \u043d\u0430\u0445\u043e\u0434\u044f\u0449\u0435\u0433\u043e\u0441\u044f \u0432 \u043c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0439 \u0441\u043e\u0431\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u0438\",\"01.07.2016 \u0433. - 30.06.2017 \u0433.\",\"03.07.2017 \u0433.\",\"04.08.2017 \u0433.\",\"-\u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432 \u0447\u0430\u0441\u0442\u0438 \u043f\u0440\u0430\u0432\u043e\u043c\u0435\u0440\u043d\u043e\u0441\u0442\u0438 \u043d\u0430\u0447\u0438\u0441\u043b\u0435\u043d\u0438\u044f \u0438 \u0432\u044b\u043f\u043b\u0430\u0442\u044b \u0437\u0430\u0440\u0430\u0431\u043e\u0442\u043d\u043e\u0439 \u043f\u043b\u0430\u0442\u044b;                                                             - \u0438\u0437\u043b\u0438\u0448\u043a\u0438 \u043d\u0435\u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u044b\u0445 \u0430\u043a\u0442\u0438\u0432\u043e\u0432;          - \u043d\u0435\u0434\u043e\u0441\u0442\u0430\u0442\u043a\u0438 \u0432 \u0432\u0435\u0434\u0435\u043d\u0438\u0438 \u0443\u0447\u0435\u0442\u0430 \u0440\u0430\u0431\u043e\u0442\u044b \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e-\u0445\u043e\u0437\u044f\u0439\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0439 \u0434\u0435\u044f\u0442\u0435\u043b\u044c\u043d\u043e\u0441\u0442\u0438;                                                - \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u044f \u0432\u0435\u0434\u0435\u043d\u0438\u044f \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430, \u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d\u0438\u044f \u043f\u0435\u0440\u0432\u0438\u0447\u043d\u044b\u0445 \u0443\u0447\u0435\u0442\u043d\u044b\u0445 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u043e\u0432 \u0438 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u043e\u0432 \u0431\u0443\u0445\u0433\u0430\u043b\u0442\u0435\u0440\u0441\u043a\u043e\u0433\u043e \u0443\u0447\u0435\u0442\u0430.\",\"\u041d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u043e \u043f\u0440\u0435\u0434\u043f\u0438\u0441\u0430\u043d\u0438\u0435 \u043e\u0431 \u0443\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u0438\u0438 \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0439 \u0432 \u0441\u0440\u043e\u043a \u0434\u043e 30.09.2017 \u0433\u043e\u0434\u0430\"\n21,\"\u041c\u0443\u043d\u0438\u0446\u0438\u043f\u0430\u043b\u044c\u043d\u043e\u0435 \u0431\u044e\u0434\u0436\u0435\u0442\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u043e\u0435 \u0443\u0447\u0440\u0435\u0436\u0434\u0435\u043d\u0438\u0435 \u00ab\u041b\u043e\u0437\u043d\u044f\u043d\u0441\u043a\u0430\u044f \u0441\u0440\u0435\u0434\u043d\u044f\u044f \u043e\u0431\u0449\u0435\u043e\u0431\u0440\u0430\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044c\u043d\u0430\u044f \u0448\u043a\u043e\u043b\u0430 \u0420\u043e\u0432\u0435\