/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cutlass.line;

import com.questdb.cutlass.line.CachedCharSequence;
import com.questdb.cutlass.line.CharSequenceCache;
import com.questdb.cutlass.line.LineProtoException;
import com.questdb.cutlass.line.LineProtoLexer;
import com.questdb.cutlass.line.LineProtoParser;
import com.questdb.std.Unsafe;
import com.questdb.std.str.StringSink;
import com.questdb.test.tools.TestUtils;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class LineProtoLexerTest {
    private static final LineProtoLexer lexer = new LineProtoLexer(4096);
    private final StringSink sink = new StringSink();
    private final TestLineProtoParser lineAssemblingParser = new TestLineProtoParser();

    @Before
    public void setUp() {
        lexer.clear();
    }

    @Test
    public void testCommaInTagName() {
        this.assertThat((CharSequence)"measurement,t,ag=value,tag2=value field=10000i,field2=\"str\" 100000\n", "measurement,t\\,ag=value,tag2=value field=10000i,field2=\"str\" 100000\n");
    }

    @Test
    public void testCommaInTagValue() {
        this.assertThat((CharSequence)"measurement,tag=value,tag2=va,lue field=10000i,field2=\"str\" 100000\n", "measurement,tag=value,tag2=va\\,lue field=10000i,field2=\"str\" 100000\n");
    }

    @Test
    public void testCorruptUtf8Sequence() {
        byte[] bytesA = "\u8fdd\u6cd5\u8fdd,\u63a7\u7f51\u7ad9\u6f0f\u6d1e\u98ce=\u4e0d\u4e00\u5b9a\u4ee3,\u7f51\u7ad9\u53ef\u80fd\u5b58\u5728=\u043a\u043e\u043c\u0438\u0442\u0435\u0442\u0430 \u7684\u98ce\u9669=10000i,\u0432\u044b\u0448\u0435\u043b=\"\u9669\" 100000\n".getBytes(StandardCharsets.UTF_8);
        byte[] bytesB = new byte[]{-116, -76, -55, 55, -34, 0, -11, 15, 13};
        byte[] bytesC = "\u043c\u0435\u043c\u043e\u0440\u0430\u043d\u0434\u0443\u043c,tag=value,tag2=value field=10000i,field2=\"str\" 100000\n".getBytes(StandardCharsets.UTF_8);
        byte[] bytes = new byte[bytesA.length + bytesB.length + bytesC.length];
        System.arraycopy(bytesA, 0, bytes, 0, bytesA.length);
        System.arraycopy(bytesB, 0, bytes, bytesA.length, bytesB.length);
        System.arraycopy(bytesC, 0, bytes, bytesA.length + bytesB.length, bytesC.length);
        this.assertThat((CharSequence)"\u8fdd\u6cd5\u8fdd,\u63a7\u7f51\u7ad9\u6f0f\u6d1e\u98ce=\u4e0d\u4e00\u5b9a\u4ee3,\u7f51\u7ad9\u53ef\u80fd\u5b58\u5728=\u043a\u043e\u043c\u0438\u0442\u0435\u0442\u0430 \u7684\u98ce\u9669=10000i,\u0432\u044b\u0448\u0435\u043b=\"\u9669\" 100000\n-- error --\n\u043c\u0435\u043c\u043e\u0440\u0430\u043d\u0434\u0443\u043c,tag=value,tag2=value field=10000i,field2=\"str\" 100000\n", bytes);
    }

    @Test
    public void testDanglingCommaOnTag() {
        this.assertError("measurement,tag=value, field=x 10000\n", 4, 1, 22);
    }

    @Test
    public void testEmptyLine() {
        this.assertThat((CharSequence)"measurement,tag=value,tag2=value field=10000i,field2=\"str\" 100000\nmeasurement,tag=value3,tag2=value2 field=100i,field2=\"ok\"\n", "measurement,tag=value,tag2=value field=10000i,field2=\"str\" 100000\n\nmeasurement,tag=value3,tag2=value2 field=100i,field2=\"ok\"\n");
    }

    @Test
    public void testMissingFields() {
        this.assertThat((CharSequence)"measurement,field=10000i,field2=str\n", "measurement,field=10000i,field2=str");
    }

    @Test
    public void testMissingFields2() {
        this.assertThat((CharSequence)"measurement,field=10000i,field2=str\n", "measurement,field=10000i,field2=str\n");
    }

    @Test
    public void testMissingLineEnd() {
        this.assertThat((CharSequence)"measurement,tag=value,tag2=value field=10000i,field2=\"str\" 100000\n", "measurement,tag=value,tag2=value field=10000i,field2=\"str\" 100000");
    }

    @Test
    public void testMissingTags() {
        this.assertThat((CharSequence)"measurement field=10000i,field2=\"str\"\n", "measurement field=10000i,field2=\"str\"");
    }

    @Test
    public void testMissingTimestamp() {
        this.assertThat((CharSequence)"measurement,tag=value,tag2=value field=10000i,field2=\"str\"\n", "measurement,tag=value,tag2=value field=10000i,field2=\"str\"");
    }

    @Test
    public void testMultiLines() {
        this.assertThat((CharSequence)"measurement,tag=value,tag2=value field=10000i,field2=\"str\" 100000\nmeasurement,tag=value3,tag2=value2 field=100i,field2=\"ok\"\n", "measurement,tag=value,tag2=value field=10000i,field2=\"str\" 100000\nmeasurement,tag=value3,tag2=value2 field=100i,field2=\"ok\"\n");
    }

    @Test
    public void testNoFieldName1() {
        this.assertError("measurement,tag=x f=10i,f2 10000", 5, 1, 26);
    }

    @Test
    public void testNoFieldName2() {
        this.assertError("measurement,tag=x f=10i,=f2 10000", 5, 3, 24);
    }

    @Test
    public void testNoFieldName3() {
        this.assertError("measurement,tag=x =10i,=f2 10000", 5, 3, 18);
    }

    @Test
    public void testNoFieldValue1() {
        this.assertError("measurement,tag=x f 10000", 5, 1, 19);
    }

    @Test
    public void testNoFieldValue2() {
        this.assertError("measurement,tag=x f= 10000", 3, 3, 20);
    }

    @Test
    public void testNoFieldValue3() {
        this.assertError("measurement,tag=x f=, 10000", 3, 3, 20);
    }

    @Test
    public void testNoFields1() {
        this.assertError("measurement  \n", 5, 1, 12);
    }

    @Test
    public void testNoFields2() {
        this.assertError("measurement  ", 5, 1, 12);
    }

    @Test
    public void testNoFields3() {
        this.assertError("measurement  10000", 5, 1, 12);
    }

    @Test
    public void testNoFields4() {
        this.assertError("measurement,tag=x 10000", 5, 1, 23);
    }

    @Test
    public void testNoMeasure1() {
        this.assertError("tag=value field=x 10000\n", 1, 1, 3);
    }

    @Test
    public void testNoMeasure2() {
        this.assertError("tag=value field=x 10000\n", 1, 1, 3);
    }

    @Test
    public void testNoTag4() {
        this.assertError("measurement, \n", 4, 1, 12);
    }

    @Test
    public void testNoTagEquals1() {
        this.assertError("measurement,tag field=x 10000\n", 4, 1, 15);
    }

    @Test
    public void testNoTagEquals2() {
        this.assertError("measurement,tag, field=x 10000\n", 4, 1, 15);
    }

    @Test
    public void testNoTagValue1() {
        this.assertError("measurement,tag= field=x 10000\n", 2, 3, 16);
    }

    @Test
    public void testNoTagValue2() {
        this.assertError("measurement,tag=, field=x 10000\n", 2, 3, 16);
    }

    @Test
    public void testNoTagValue3() {
        this.assertError("measurement,tag=", 2, 3, 16);
    }

    @Test
    public void testNoTagValue4() {
        this.assertError("measurement,tag=\n", 2, 3, 16);
    }

    @Test
    public void testNoTags1() {
        this.assertError("measurement,", 4, 1, 12);
    }

    @Test
    public void testNoTags2() {
        this.assertError("measurement,\n", 4, 1, 12);
    }

    @Test
    public void testNoTags3() {
        this.assertError("measurement, 100000\n", 4, 1, 12);
    }

    @Test
    public void testSimpleParse() {
        this.assertThat((CharSequence)"measurement,tag=value,tag2=value field=10000i,field2=\"str\" 100000\n", "measurement,tag=value,tag2=value field=10000i,field2=\"str\" 100000\n");
    }

    @Test
    public void testSkipLine() {
        this.assertThat((CharSequence)"measurement,tag=value,tag2=value field=10000i,field2=\"str\" 100000\nmeasurement,tag=value3,tag2=value2 field=-- error --\nmeasurement,tag=value4,tag2=value4 field=200i,field2=\"super\"\n", "measurement,tag=value,tag2=value field=10000i,field2=\"str\" 100000\nmeasurement,tag=value3,tag2=value2 field=,field2=\"ok\"\nmeasurement,tag=value4,tag2=value4 field=200i,field2=\"super\"\n");
    }

    @Test
    public void testSpaceTagName() {
        this.assertThat((CharSequence)"measurement,t ag=value,tag2=value field=10000i,field2=\"str\" 100000\n", "measurement,t\\ ag=value,tag2=value field=10000i,field2=\"str\" 100000\n");
    }

    @Test
    public void testSpaceTagValue() {
        this.assertThat((CharSequence)"measurement,tag=value,tag2=valu e field=10000i,field2=\"str\" 100000\n", "measurement,tag=value,tag2=valu\\ e field=10000i,field2=\"str\" 100000\n");
    }

    @Test
    public void testTrailingSpace() {
        this.assertError("measurement,tag=value,tag2=value field=10000i,field2=\"str\" \nmeasurement,tag=value3,tag2=value2 field=100i,field2=\"ok\"\n", 6, 3, 59);
    }

    @Test
    public void testUtf8() {
        this.assertThat((CharSequence)"\u043c\u0435\u043c\u043e\u0440\u0430\u043d\u0434\u0443\u043c,\u043a\u0440\u043e\u043c\u0435=\u043d\u0438\u043a\u0442\u043e,\u044d\u0442\u043e\u043c=\u043a\u043e\u043c\u0438\u0442\u0435\u0442\u0430 \u043d\u0430\u0445\u043e\u0434\u0438\u043b\u0441\u044f=10000i,\u0432\u044b\u0448\u0435\u043b=\"\u0410\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\" 100000\n", "\u043c\u0435\u043c\u043e\u0440\u0430\u043d\u0434\u0443\u043c,\u043a\u0440\u043e\u043c\u0435=\u043d\u0438\u043a\u0442\u043e,\u044d\u0442\u043e\u043c=\u043a\u043e\u043c\u0438\u0442\u0435\u0442\u0430 \u043d\u0430\u0445\u043e\u0434\u0438\u043b\u0441\u044f=10000i,\u0432\u044b\u0448\u0435\u043b=\"\u0410\u043b\u0435\u043a\u0441\u0430\u043d\u0434\u0440\" 100000\n");
    }

    @Test
    public void testUtf8Measurement() {
        this.assertThat((CharSequence)"\u043c\u0435\u043c\u043e\u0440\u0430\u043d\u0434\u0443\u043c,tag=value,tag2=value field=10000i,field2=\"str\" 100000\n", "\u043c\u0435\u043c\u043e\u0440\u0430\u043d\u0434\u0443\u043c,tag=value,tag2=value field=10000i,field2=\"str\" 100000\n");
    }

    @Test
    public void testUtf8ThreeBytes() {
        this.assertThat((CharSequence)"\u8fdd\u6cd5\u8fdd,\u63a7\u7f51\u7ad9\u6f0f\u6d1e\u98ce=\u4e0d\u4e00\u5b9a\u4ee3,\u7f51\u7ad9\u53ef\u80fd\u5b58\u5728=\u043a\u043e\u043c\u0438\u0442\u0435\u0442\u0430 \u7684\u98ce\u9669=10000i,\u0432\u044b\u0448\u0435\u043b=\"\u9669\" 100000\n", "\u8fdd\u6cd5\u8fdd,\u63a7\u7f51\u7ad9\u6f0f\u6d1e\u98ce=\u4e0d\u4e00\u5b9a\u4ee3,\u7f51\u7ad9\u53ef\u80fd\u5b58\u5728=\u043a\u043e\u043c\u0438\u0442\u0435\u0442\u0430 \u7684\u98ce\u9669=10000i,\u0432\u044b\u0448\u0435\u043b=\"\u9669\" 100000\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertError(CharSequence line, int state, int code, int position) throws LineProtoException {
        byte[] bytes = line.toString().getBytes(StandardCharsets.UTF_8);
        long mem = Unsafe.malloc((long)bytes.length);
        try {
            int i;
            int len = bytes.length;
            for (i = 0; i < len; ++i) {
                Unsafe.getUnsafe().putByte(mem + (long)i, bytes[i]);
            }
            for (i = 0; i < len; ++i) {
                this.lineAssemblingParser.clear();
                lexer.clear();
                lexer.withParser((LineProtoParser)this.lineAssemblingParser);
                lexer.parse(mem, mem + (long)i);
                lexer.parse(mem + (long)i, mem + (long)len);
                lexer.parseLast();
                Assert.assertEquals((long)state, (long)this.lineAssemblingParser.errorState);
                Assert.assertEquals((long)code, (long)this.lineAssemblingParser.errorCode);
                Assert.assertEquals((long)position, (long)this.lineAssemblingParser.errorPosition);
            }
        }
        finally {
            Unsafe.free((long)mem, (long)bytes.length);
        }
    }

    private void assertThat(CharSequence expected, CharSequence line) throws LineProtoException {
        this.assertThat(expected, line.toString().getBytes(StandardCharsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertThat(CharSequence expected, byte[] line) throws LineProtoException {
        int len = line.length;
        long mem = Unsafe.malloc((long)line.length);
        try {
            int i;
            for (i = 0; i < len; ++i) {
                Unsafe.getUnsafe().putByte(mem + (long)i, line[i]);
            }
            if (len < 10) {
                for (i = 0; i < len; ++i) {
                    this.lineAssemblingParser.clear();
                    lexer.clear();
                    lexer.withParser((LineProtoParser)this.lineAssemblingParser);
                    lexer.parse(mem, mem + (long)i);
                    lexer.parse(mem + (long)i, mem + (long)len);
                    lexer.parseLast();
                    TestUtils.assertEquals(expected, (CharSequence)this.sink);
                }
            } else {
                for (i = 0; i < len - 10; ++i) {
                    this.lineAssemblingParser.clear();
                    lexer.clear();
                    lexer.withParser((LineProtoParser)this.lineAssemblingParser);
                    lexer.parse(mem, mem + (long)i);
                    lexer.parse(mem + (long)i, mem + (long)i + 10L);
                    lexer.parse(mem + (long)i + 10L, mem + (long)len);
                    lexer.parseLast();
                    TestUtils.assertEquals(expected, (CharSequence)this.sink);
                }
            }
            LineProtoLexer smallBufLexer = new LineProtoLexer(64);
            this.lineAssemblingParser.clear();
            smallBufLexer.withParser((LineProtoParser)this.lineAssemblingParser);
            smallBufLexer.parse(mem, mem + (long)len);
            smallBufLexer.parseLast();
            TestUtils.assertEquals(expected, (CharSequence)this.sink);
        }
        finally {
            Unsafe.free((long)mem, (long)len);
        }
    }

    private class TestLineProtoParser
    implements LineProtoParser {
        final HashMap<Long, String> tokens = new HashMap();
        boolean fields = false;
        int errorState;
        int errorCode;
        int errorPosition;

        private TestLineProtoParser() {
        }

        public void onError(int position, int state, int code) {
            this.errorCode = code;
            this.errorPosition = position;
            this.errorState = state;
            this.fields = false;
            LineProtoLexerTest.this.sink.put((CharSequence)"-- error --\n");
            this.tokens.clear();
        }

        public void onEvent(CachedCharSequence token, int type, CharSequenceCache cache) {
            Assert.assertNull((Object)this.tokens.put(token.getCacheAddress(), token.toString()));
            switch (type) {
                case 1: {
                    LineProtoLexerTest.this.sink.put((CharSequence)token);
                    break;
                }
                case 4: {
                    LineProtoLexerTest.this.sink.put(',').put((CharSequence)token).put('=');
                    break;
                }
                case 5: {
                    if (this.fields) {
                        LineProtoLexerTest.this.sink.put(',');
                    } else {
                        try {
                            this.fields = true;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        LineProtoLexerTest.this.sink.put(' ');
                    }
                    LineProtoLexerTest.this.sink.put((CharSequence)token).put('=');
                    break;
                }
                case 2: 
                case 3: {
                    LineProtoLexerTest.this.sink.put((CharSequence)token);
                    break;
                }
                case 6: {
                    if (token.length() <= 0) break;
                    LineProtoLexerTest.this.sink.put(' ').put((CharSequence)token);
                    break;
                }
            }
        }

        public void onLineEnd(CharSequenceCache cache) {
            LineProtoLexerTest.this.sink.put('\n');
            for (Map.Entry<Long, String> e : this.tokens.entrySet()) {
                TestUtils.assertEquals((CharSequence)e.getValue(), cache.get(e.getKey().longValue()));
            }
            this.tokens.clear();
            this.fields = false;
        }

        private void clear() {
            LineProtoLexerTest.this.sink.clear();
            this.errorCode = 0;
            this.errorPosition = 0;
            this.tokens.clear();
        }
    }
}

