/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cutlass.line;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.DefaultCairoConfiguration;
import com.questdb.cairo.TableModel;
import com.questdb.cairo.TableReader;
import com.questdb.cairo.TableUtils;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.TestFilesFacade;
import com.questdb.cairo.pool.ResourcePool;
import com.questdb.cairo.pool.WriterPool;
import com.questdb.cairo.sql.RecordCursor;
import com.questdb.cutlass.line.CairoLineProtoParser;
import com.questdb.cutlass.line.LineProtoLexer;
import com.questdb.cutlass.line.LineProtoParser;
import com.questdb.std.Chars;
import com.questdb.std.Files;
import com.questdb.std.FilesFacade;
import com.questdb.std.NumericException;
import com.questdb.std.Unsafe;
import com.questdb.std.microtime.DateFormatUtils;
import com.questdb.std.microtime.MicrosecondClock;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.Path;
import com.questdb.test.tools.TestMicroClock;
import com.questdb.test.tools.TestUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import org.junit.Assert;
import org.junit.Test;

public class CairoLineProtoParserTest
extends AbstractCairoTest {
    @Test
    public void testAddColumn() throws Exception {
        String expected = "tag\ttag2\tfield\tf4\tfield2\tfx\ttimestamp\tf5\nabc\txyz\t10000\t9.034000000000\tstr\ttrue\t1970-01-01T00:01:40.000000Z\tNaN\nwoopsie\tdaisy\t2000\t3.088910000000\tcomment\ttrue\t1970-01-01T00:01:40.000000Z\tNaN\n444\td555\t510\t1.400000000000\tcomment\ttrue\t1970-01-01T00:01:40.000000Z\t55\n666\t777\t410\t1.100000000000\tcomment X\tfalse\t1970-01-01T00:01:40.000000Z\tNaN\n";
        String lines = "tab,tag=abc,tag2=xyz field=10000i,f4=9.034,field2=\"str\",fx=true 100000000\ntab,tag=woopsie,tag2=daisy field=2000i,f4=3.08891,field2=\"comment\",fx=true 100000000\ntab,tag=444,tag2=d555 field=510i,f4=1.4,f5=55i,field2=\"comment\",fx=true 100000000\ntab,tag=666,tag2=777 field=410i,f4=1.1,field2=\"comment\\ X\",fx=false 100000000\n";
        this.assertThat("tag\ttag2\tfield\tf4\tfield2\tfx\ttimestamp\tf5\nabc\txyz\t10000\t9.034000000000\tstr\ttrue\t1970-01-01T00:01:40.000000Z\tNaN\nwoopsie\tdaisy\t2000\t3.088910000000\tcomment\ttrue\t1970-01-01T00:01:40.000000Z\tNaN\n444\td555\t510\t1.400000000000\tcomment\ttrue\t1970-01-01T00:01:40.000000Z\t55\n666\t777\t410\t1.100000000000\tcomment X\tfalse\t1970-01-01T00:01:40.000000Z\tNaN\n", "tab,tag=abc,tag2=xyz field=10000i,f4=9.034,field2=\"str\",fx=true 100000000\ntab,tag=woopsie,tag2=daisy field=2000i,f4=3.08891,field2=\"comment\",fx=true 100000000\ntab,tag=444,tag2=d555 field=510i,f4=1.4,f5=55i,field2=\"comment\",fx=true 100000000\ntab,tag=666,tag2=777 field=410i,f4=1.1,field2=\"comment\\ X\",fx=false 100000000\n", "tab");
    }

    @Test
    public void testAppendExistingTable() throws Exception {
        String expected = "double\tint\tbool\tsym1\tsym2\tstr\ttimestamp\n1.600000000000\t15\ttrue\t\txyz\tstring1\t2017-10-03T10:00:00.000000Z\n1.300000000000\t11\tfalse\tabc\t\tstring2\t2017-10-03T10:00:00.010000Z\n";
        try (TableModel model = new TableModel(configuration, "x", 3).col("double", 6).col("int", 3).col("bool", 0).col("sym1", 8).col("sym2", 8).col("str", 7).timestamp();){
            CairoTestUtils.create(model);
        }
        String lines = "x,sym2=xyz double=1.6,int=15i,bool=true,str=\"string1\"\nx,sym1=abc double=1.3,int=11i,bool=false,str=\"string2\"\n";
        DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

            public MicrosecondClock getMicrosecondClock() {
                try {
                    return new TestMicroClock(DateFormatUtils.parseDateTime((CharSequence)"2017-10-03T10:00:00.000Z"), 10L);
                }
                catch (NumericException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.assertThat("double\tint\tbool\tsym1\tsym2\tstr\ttimestamp\n1.600000000000\t15\ttrue\t\txyz\tstring1\t2017-10-03T10:00:00.000000Z\n1.300000000000\t11\tfalse\tabc\t\tstring2\t2017-10-03T10:00:00.010000Z\n", lines, "x", (CairoConfiguration)configuration);
    }

    @Test
    public void testBadDouble1() throws Exception {
        String expected1 = "sym2\tdouble\tint\tbool\tstr\ttimestamp\tsym1\nxyz\t1.600000000000\t15\ttrue\tstring1\t1970-01-01T00:25:00.000000Z\t\n\t9.400000000000\t6\tfalse\tstring3\t1970-01-01T00:25:00.000000Z\trow3\n\t0.300000000000\t91\ttrue\tstring4\t1970-01-01T00:25:00.000000Z\trow4\n";
        String expected2 = "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t1970-01-01T00:28:20.000000Z\n66\tbox\t7.900000000000\t1970-01-01T00:28:20.000000Z\n";
        String lines = "x,sym2=xyz double=1.6,int=15i,bool=true,str=\"string1\" 1500000000\nx,sym1=abc double=1x.3,int=11i,bool=false,str=\"string2\" 1500000000\ny,asym1=55,asym2=box adouble=5.9 1700000000\nx,sym1=row3 double=9.4,int=6i,bool=false,str=\"string3\" 1500000000\ny,asym1=66,asym2=box adouble=7.9 1700000000\nx,sym1=row4 double=.3,int=91i,bool=true,str=\"string4\" 1500000000\n";
        this.assertMultiTable("sym2\tdouble\tint\tbool\tstr\ttimestamp\tsym1\nxyz\t1.600000000000\t15\ttrue\tstring1\t1970-01-01T00:25:00.000000Z\t\n\t9.400000000000\t6\tfalse\tstring3\t1970-01-01T00:25:00.000000Z\trow3\n\t0.300000000000\t91\ttrue\tstring4\t1970-01-01T00:25:00.000000Z\trow4\n", "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t1970-01-01T00:28:20.000000Z\n66\tbox\t7.900000000000\t1970-01-01T00:28:20.000000Z\n", lines);
    }

    @Test
    public void testBadDouble2() throws Exception {
        String expected1 = "sym2\tdouble\tint\tbool\tstr\ttimestamp\tsym1\n\t1.300000000000\t11\tfalse\tstring2\t1970-01-01T00:25:00.000000Z\tabc\n\t9.400000000000\t6\tfalse\tstring3\t1970-01-01T00:25:00.000000Z\trow3\n\t0.300000000000\t91\ttrue\tstring4\t1970-01-01T00:25:00.000000Z\trow4\n";
        String expected2 = "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t1970-01-01T00:28:20.000000Z\n66\tbox\t7.900000000000\t1970-01-01T00:28:20.000000Z\n";
        String lines = "x,sym2=xyz double=1.6x,int=15i,bool=true,str=\"string1\" 1500000000\nx,sym1=abc double=1.3,int=11i,bool=false,str=\"string2\" 1500000000\ny,asym1=55,asym2=box adouble=5.9 1700000000\nx,sym1=row3 double=9.4,int=6i,bool=false,str=\"string3\" 1500000000\ny,asym1=66,asym2=box adouble=7.9 1700000000\nx,sym1=row4 double=.3,int=91i,bool=true,str=\"string4\" 1500000000\n";
        this.assertMultiTable("sym2\tdouble\tint\tbool\tstr\ttimestamp\tsym1\n\t1.300000000000\t11\tfalse\tstring2\t1970-01-01T00:25:00.000000Z\tabc\n\t9.400000000000\t6\tfalse\tstring3\t1970-01-01T00:25:00.000000Z\trow3\n\t0.300000000000\t91\ttrue\tstring4\t1970-01-01T00:25:00.000000Z\trow4\n", "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t1970-01-01T00:28:20.000000Z\n66\tbox\t7.900000000000\t1970-01-01T00:28:20.000000Z\n", lines);
    }

    @Test
    public void testBadInt1() throws Exception {
        String expected1 = "sym2\tdouble\tint\tbool\tstr\ttimestamp\tsym1\nxyz\t1.600000000000\t15\ttrue\tstring1\t1970-01-01T00:25:00.000000Z\t\n\t9.400000000000\t6\tfalse\tstring3\t1970-01-01T00:25:00.000000Z\trow3\n\t0.300000000000\t91\ttrue\tstring4\t1970-01-01T00:25:00.000000Z\trow4\n";
        String expected2 = "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t1970-01-01T00:28:20.000000Z\n66\tbox\t7.900000000000\t1970-01-01T00:28:20.000000Z\n";
        String lines = "x,sym2=xyz double=1.6,int=15i,bool=true,str=\"string1\" 1500000000\nx,sym1=abc double=1.3,int=1s1i,bool=false,str=\"string2\" 1500000000\ny,asym1=55,asym2=box adouble=5.9 1700000000\nx,sym1=row3 double=9.4,int=6i,bool=false,str=\"string3\" 1500000000\ny,asym1=66,asym2=box adouble=7.9 1700000000\nx,sym1=row4 double=.3,int=91i,bool=true,str=\"string4\" 1500000000\n";
        this.assertMultiTable("sym2\tdouble\tint\tbool\tstr\ttimestamp\tsym1\nxyz\t1.600000000000\t15\ttrue\tstring1\t1970-01-01T00:25:00.000000Z\t\n\t9.400000000000\t6\tfalse\tstring3\t1970-01-01T00:25:00.000000Z\trow3\n\t0.300000000000\t91\ttrue\tstring4\t1970-01-01T00:25:00.000000Z\trow4\n", "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t1970-01-01T00:28:20.000000Z\n66\tbox\t7.900000000000\t1970-01-01T00:28:20.000000Z\n", lines);
    }

    @Test
    public void testBadInt2() throws Exception {
        String expected1 = "sym2\tdouble\tint\tbool\tstr\ttimestamp\tsym1\n\t1.300000000000\t11\tfalse\tstring2\t1970-01-01T00:25:00.000000Z\tabc\n\t9.400000000000\t6\tfalse\tstring3\t1970-01-01T00:25:00.000000Z\trow3\n\t0.300000000000\t91\ttrue\tstring4\t1970-01-01T00:25:00.000000Z\trow4\n";
        String expected2 = "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t1970-01-01T00:28:20.000000Z\n66\tbox\t7.900000000000\t1970-01-01T00:28:20.000000Z\n";
        String lines = "x,sym2=xyz double=1.6,int=1i5i,bool=true,str=\"string1\" 1500000000\nx,sym1=abc double=1.3,int=11i,bool=false,str=\"string2\" 1500000000\ny,asym1=55,asym2=box adouble=5.9 1700000000\nx,sym1=row3 double=9.4,int=6i,bool=false,str=\"string3\" 1500000000\ny,asym1=66,asym2=box adouble=7.9 1700000000\nx,sym1=row4 double=.3,int=91i,bool=true,str=\"string4\" 1500000000\n";
        this.assertMultiTable("sym2\tdouble\tint\tbool\tstr\ttimestamp\tsym1\n\t1.300000000000\t11\tfalse\tstring2\t1970-01-01T00:25:00.000000Z\tabc\n\t9.400000000000\t6\tfalse\tstring3\t1970-01-01T00:25:00.000000Z\trow3\n\t0.300000000000\t91\ttrue\tstring4\t1970-01-01T00:25:00.000000Z\trow4\n", "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t1970-01-01T00:28:20.000000Z\n66\tbox\t7.900000000000\t1970-01-01T00:28:20.000000Z\n", lines);
    }

    @Test
    public void testBadTimestamp1() throws Exception {
        String expected1 = "sym2\tdouble\tint\tbool\tstr\ttimestamp\tsym1\n\t1.300000000000\t11\tfalse\tstring2\t1970-01-01T00:25:00.000000Z\tabc\n\t9.400000000000\t6\tfalse\tstring3\t1970-01-01T00:25:00.000000Z\trow3\n\t0.300000000000\t91\ttrue\tstring4\t1970-01-01T00:25:00.000000Z\trow4\n";
        String expected2 = "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t1970-01-01T00:28:20.000000Z\n66\tbox\t7.900000000000\t1970-01-01T00:28:20.000000Z\n";
        String lines = "x,sym2=xyz double=1.6,int=15i,bool=true,str=\"string1\" 1234ab\nx,sym1=abc double=1.3,int=11i,bool=false,str=\"string2\" 1500000000\ny,asym1=55,asym2=box adouble=5.9 1700000000\nx,sym1=row3 double=9.4,int=6i,bool=false,str=\"string3\" 1500000000\ny,asym1=66,asym2=box adouble=7.9 1700000000\nx,sym1=row4 double=.3,int=91i,bool=true,str=\"string4\" 1500000000\n";
        this.assertMultiTable("sym2\tdouble\tint\tbool\tstr\ttimestamp\tsym1\n\t1.300000000000\t11\tfalse\tstring2\t1970-01-01T00:25:00.000000Z\tabc\n\t9.400000000000\t6\tfalse\tstring3\t1970-01-01T00:25:00.000000Z\trow3\n\t0.300000000000\t91\ttrue\tstring4\t1970-01-01T00:25:00.000000Z\trow4\n", "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t1970-01-01T00:28:20.000000Z\n66\tbox\t7.900000000000\t1970-01-01T00:28:20.000000Z\n", lines);
    }

    @Test
    public void testBadTimestamp2() throws Exception {
        String expected1 = "sym2\tdouble\tint\tbool\tstr\ttimestamp\tsym1\nxyz\t1.600000000000\t15\ttrue\tstring1\t1970-01-01T00:00:01.234000Z\t\n\t1.300000000000\t11\tfalse\tstring2\t1970-01-01T00:25:00.000000Z\tabc\n\t0.300000000000\t91\ttrue\tstring4\t1970-01-01T00:25:00.000000Z\trow4\n";
        String expected2 = "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t1970-01-01T00:28:20.000000Z\n66\tbox\t7.900000000000\t1970-01-01T00:28:20.000000Z\n";
        String lines = "x,sym2=xyz double=1.6,int=15i,bool=true,str=\"string1\" 1234000\nx,sym1=abc double=1.3,int=11i,bool=false,str=\"string2\" 1500000000\ny,asym1=55,asym2=box adouble=5.9 1700000000\nx,sym1=row3 double=9.4,int=6i,bool=false,str=\"string3\" 1500x000\ny,asym1=66,asym2=box adouble=7.9 1700000000\nx,sym1=row4 double=.3,int=91i,bool=true,str=\"string4\" 1500000000\n";
        this.assertMultiTable("sym2\tdouble\tint\tbool\tstr\ttimestamp\tsym1\nxyz\t1.600000000000\t15\ttrue\tstring1\t1970-01-01T00:00:01.234000Z\t\n\t1.300000000000\t11\tfalse\tstring2\t1970-01-01T00:25:00.000000Z\tabc\n\t0.300000000000\t91\ttrue\tstring4\t1970-01-01T00:25:00.000000Z\trow4\n", "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t1970-01-01T00:28:20.000000Z\n66\tbox\t7.900000000000\t1970-01-01T00:28:20.000000Z\n", lines);
    }

    @Test
    public void testBusyTable() throws Exception {
        String expected = "double\tint\tbool\tsym1\tsym2\tstr\ttimestamp\n";
        try (TableModel model = new TableModel(configuration, "x", 3).col("double", 6).col("int", 3).col("bool", 0).col("sym1", 8).col("sym2", 8).col("str", 7).timestamp();){
            CairoTestUtils.create(model);
        }
        String lines = "x,sym2=xyz double=1.6,int=15i,bool=true,str=\"string1\"\nx,sym1=abc double=1.3,int=11i,bool=false,str=\"string2\"\n";
        DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

            public MicrosecondClock getMicrosecondClock() {
                try {
                    return new TestMicroClock(DateFormatUtils.parseDateTime((CharSequence)"2017-10-03T10:00:00.000Z"), 10L);
                }
                catch (NumericException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        try (TableWriter ignored = new TableWriter((CairoConfiguration)configuration, (CharSequence)"x");){
            this.assertThat("double\tint\tbool\tsym1\tsym2\tstr\ttimestamp\n", lines, "x", (CairoConfiguration)configuration);
        }
    }

    @Test
    public void testCannotCreateTable() throws Exception {
        final TestFilesFacade ff = new TestFilesFacade(){
            boolean called = false;

            public int mkdirs(LPSZ path, int mode) {
                if (Chars.endsWith((CharSequence)path, (CharSequence)("x" + Files.SEPARATOR))) {
                    this.called = true;
                    return -1;
                }
                return super.mkdirs(path, mode);
            }

            @Override
            public boolean wasCalled() {
                return this.called;
            }
        };
        String expected = "sym\tdouble\tint\tbool\tstr\ttimestamp\nzzz\t1.300000000000\t11\tfalse\tnice\t2017-10-03T10:00:00.000000Z\n";
        String lines = "x,sym2=xyz double=1.6,int=15i,bool=true,str=\"string1\"\nx,sym1=abc double=1.3,int=11i,bool=false,str=\"string2\"\ny,sym=zzz double=1.3,int=11i,bool=false,str=\"nice\"\n";
        DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

            public FilesFacade getFilesFacade() {
                return ff;
            }

            public MicrosecondClock getMicrosecondClock() {
                try {
                    return new TestMicroClock(DateFormatUtils.parseDateTime((CharSequence)"2017-10-03T10:00:00.000Z"), 10L);
                }
                catch (NumericException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        this.assertThat("sym\tdouble\tint\tbool\tstr\ttimestamp\nzzz\t1.300000000000\t11\tfalse\tnice\t2017-10-03T10:00:00.000000Z\n", lines, "y", (CairoConfiguration)configuration);
        Assert.assertTrue((boolean)ff.wasCalled());
        try (Path path = new Path();){
            Assert.assertEquals((long)1L, (long)TableUtils.exists((FilesFacade)ff, (Path)path, (CharSequence)root, (CharSequence)"all"));
        }
    }

    @Test
    public void testCreateAndAppend() throws Exception {
        String expected = "tag\ttag2\tfield\tf4\tfield2\tfx\ttimestamp\nabc\txyz\t10000\t9.034000000000\tstr\ttrue\t1970-01-01T00:01:40.000000Z\nwoopsie\tdaisy\t2000\t3.088910000000\tcomment\ttrue\t1970-01-01T00:01:40.000000Z\n";
        String lines = "tab,tag=abc,tag2=xyz field=10000i,f4=9.034,field2=\"str\",fx=true 100000000\ntab,tag=woopsie,tag2=daisy field=2000i,f4=3.08891,field2=\"comment\",fx=true 100000000\n";
        this.assertThat("tag\ttag2\tfield\tf4\tfield2\tfx\ttimestamp\nabc\txyz\t10000\t9.034000000000\tstr\ttrue\t1970-01-01T00:01:40.000000Z\nwoopsie\tdaisy\t2000\t3.088910000000\tcomment\ttrue\t1970-01-01T00:01:40.000000Z\n", "tab,tag=abc,tag2=xyz field=10000i,f4=9.034,field2=\"str\",fx=true 100000000\ntab,tag=woopsie,tag2=daisy field=2000i,f4=3.08891,field2=\"comment\",fx=true 100000000\n", "tab");
    }

    @Test
    public void testCreateAndAppendTwoTables() throws Exception {
        String expected1 = "sym2\tdouble\tint\tbool\tstr\ttimestamp\tsym1\nxyz\t1.600000000000\t15\ttrue\tstring1\t2017-10-03T10:00:00.000000Z\t\n\t1.300000000000\t11\tfalse\tstring2\t2017-10-03T10:00:00.010000Z\tabc\n\t0.900000000000\t6\tfalse\tstring3\t2017-10-03T10:00:00.030000Z\trow3\n\t0.300000000000\t91\ttrue\tstring4\t2017-10-03T10:00:00.050000Z\trow4\n";
        String expected2 = "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t2017-10-03T10:00:00.020000Z\n66\tbox\t7.900000000000\t2017-10-03T10:00:00.040000Z\n";
        String lines = "x,sym2=xyz double=1.6,int=15i,bool=true,str=\"string1\"\nx,sym1=abc double=1.3,int=11i,bool=false,str=\"string2\"\ny,asym1=55,asym2=box adouble=5.9\nx,sym1=row3 double=.9,int=6i,bool=false,str=\"string3\"\ny,asym1=66,asym2=box adouble=7.9\nx,sym1=row4 double=.3,int=91i,bool=true,str=\"string4\"\n";
        this.assertMultiTable("sym2\tdouble\tint\tbool\tstr\ttimestamp\tsym1\nxyz\t1.600000000000\t15\ttrue\tstring1\t2017-10-03T10:00:00.000000Z\t\n\t1.300000000000\t11\tfalse\tstring2\t2017-10-03T10:00:00.010000Z\tabc\n\t0.900000000000\t6\tfalse\tstring3\t2017-10-03T10:00:00.030000Z\trow3\n\t0.300000000000\t91\ttrue\tstring4\t2017-10-03T10:00:00.050000Z\trow4\n", "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t2017-10-03T10:00:00.020000Z\n66\tbox\t7.900000000000\t2017-10-03T10:00:00.040000Z\n", lines);
    }

    @Test
    public void testCreateTable() throws Exception {
        String expected = "tag\ttag2\tfield\tf4\tfield2\tfx\ttimestamp\nabc\txyz\t10000\t9.034000000000\tstr\ttrue\t1970-01-01T00:01:40.000000Z\n";
        String lines = "measurement,tag=abc,tag2=xyz field=10000i,f4=9.034,field2=\"str\",fx=true 100000000\n";
        this.assertThat("tag\ttag2\tfield\tf4\tfield2\tfx\ttimestamp\nabc\txyz\t10000\t9.034000000000\tstr\ttrue\t1970-01-01T00:01:40.000000Z\n", "measurement,tag=abc,tag2=xyz field=10000i,f4=9.034,field2=\"str\",fx=true 100000000\n", "measurement");
    }

    @Test
    public void testReservedName() throws Exception {
        String expected = "sym\tdouble\tint\tbool\tstr\ttimestamp\nok\t2.100000000000\t11\tfalse\tdone\t2017-10-03T10:00:00.000000Z\n";
        String lines = "x,sym2=xyz double=1.6,int=15i,bool=true,str=\"string1\"\nx,sym1=abc double=1.3,int=11i,bool=false,str=\"string2\"\ny,sym=ok double=2.1,int=11i,bool=false,str=\"done\"\n";
        DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

            public MicrosecondClock getMicrosecondClock() {
                try {
                    return new TestMicroClock(DateFormatUtils.parseDateTime((CharSequence)"2017-10-03T10:00:00.000Z"), 10L);
                }
                catch (NumericException e) {
                    throw new RuntimeException(e);
                }
            }
        };
        try (Path path = new Path();){
            Files.mkdirs((LPSZ)path.of(root).concat((CharSequence)"x").put(Files.SEPARATOR).$(), (int)configuration.getMkDirMode());
            this.assertThat("sym\tdouble\tint\tbool\tstr\ttimestamp\nok\t2.100000000000\t11\tfalse\tdone\t2017-10-03T10:00:00.000000Z\n", lines, "y", (CairoConfiguration)configuration);
            Assert.assertEquals((long)2L, (long)TableUtils.exists((FilesFacade)configuration.getFilesFacade(), (Path)path, (CharSequence)root, (CharSequence)"x"));
        }
    }

    @Test
    public void testSyntaxError() throws Exception {
        String expected1 = "sym2\tdouble\tint\tbool\tstr\ttimestamp\tsym1\nxyz\t1.600000000000\t15\ttrue\tstring1\t2017-10-03T10:00:00.000000Z\t\n\t1.300000000000\t11\tfalse\tstring2\t2017-10-03T10:00:00.010000Z\tabc\n\t0.300000000000\t91\ttrue\tstring4\t2017-10-03T10:00:00.040000Z\trow4\n";
        String expected2 = "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t2017-10-03T10:00:00.020000Z\n66\tbox\t7.900000000000\t2017-10-03T10:00:00.030000Z\n";
        String lines = "x,sym2=xyz double=1.6,int=15i,bool=true,str=\"string1\"\nx,sym1=abc double=1.3,int=11i,bool=false,str=\"string2\"\ny,asym1=55,asym2=box adouble=5.9\nx,sym1=row3 double=,int=6i,bool=false,str=\"string3\"\ny,asym1=66,asym2=box adouble=7.9\nx,sym1=row4 double=.3,int=91i,bool=true,str=\"string4\"\n";
        this.assertMultiTable("sym2\tdouble\tint\tbool\tstr\ttimestamp\tsym1\nxyz\t1.600000000000\t15\ttrue\tstring1\t2017-10-03T10:00:00.000000Z\t\n\t1.300000000000\t11\tfalse\tstring2\t2017-10-03T10:00:00.010000Z\tabc\n\t0.300000000000\t91\ttrue\tstring4\t2017-10-03T10:00:00.040000Z\trow4\n", "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t2017-10-03T10:00:00.020000Z\n66\tbox\t7.900000000000\t2017-10-03T10:00:00.030000Z\n", lines);
    }

    @Test
    public void testTypeMismatch1() throws Exception {
        String expected1 = "sym2\tdouble\tint\tbool\tstr\ttimestamp\tsym1\nxyz\t1.600000000000\t15\ttrue\tstring1\t2017-10-03T10:00:00.000000Z\t\n\t1.300000000000\t11\tfalse\tstring2\t2017-10-03T10:00:00.010000Z\tabc\n\t0.300000000000\t91\ttrue\tstring4\t2017-10-03T10:00:00.040000Z\trow4\n";
        String expected2 = "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t2017-10-03T10:00:00.020000Z\n66\tbox\t7.900000000000\t2017-10-03T10:00:00.030000Z\n";
        String lines = "x,sym2=xyz double=1.6,int=15i,bool=true,str=\"string1\"\nx,sym1=abc double=1.3,int=11i,bool=false,str=\"string2\"\ny,asym1=55,asym2=box adouble=5.9\nx,sym1=row3 double=\"z\",int=6i,bool=false,str=\"string3\"\ny,asym1=66,asym2=box adouble=7.9\nx,sym1=row4 double=.3,int=91i,bool=true,str=\"string4\"\n";
        this.assertMultiTable("sym2\tdouble\tint\tbool\tstr\ttimestamp\tsym1\nxyz\t1.600000000000\t15\ttrue\tstring1\t2017-10-03T10:00:00.000000Z\t\n\t1.300000000000\t11\tfalse\tstring2\t2017-10-03T10:00:00.010000Z\tabc\n\t0.300000000000\t91\ttrue\tstring4\t2017-10-03T10:00:00.040000Z\trow4\n", "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t2017-10-03T10:00:00.020000Z\n66\tbox\t7.900000000000\t2017-10-03T10:00:00.030000Z\n", lines);
    }

    @Test
    public void testTypeMismatch2() throws Exception {
        String expected1 = "sym2\tdouble\tint\tbool\tstr\ttimestamp\tsym1\nxyz\t1.600000000000\t15\ttrue\tstring1\t2017-10-03T10:00:00.000000Z\t\n\t1.300000000000\t11\tfalse\tstring2\t2017-10-03T10:00:00.010000Z\tabc\n\t0.300000000000\t91\ttrue\tstring4\t2017-10-03T10:00:00.040000Z\trow4\n";
        String expected2 = "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t2017-10-03T10:00:00.020000Z\n66\tbox\t7.900000000000\t2017-10-03T10:00:00.030000Z\n";
        String lines = "x,sym2=xyz double=1.6,int=15i,bool=true,str=\"string1\"\nx,sym1=abc double=1.3,int=11i,bool=false,str=\"string2\"\ny,asym1=55,asym2=box adouble=5.9\nx,sym1=row3 double=9.4,int=6.3,bool=false,str=\"string3\"\ny,asym1=66,asym2=box adouble=7.9\nx,sym1=row4 double=.3,int=91i,bool=true,str=\"string4\"\n";
        this.assertMultiTable("sym2\tdouble\tint\tbool\tstr\ttimestamp\tsym1\nxyz\t1.600000000000\t15\ttrue\tstring1\t2017-10-03T10:00:00.000000Z\t\n\t1.300000000000\t11\tfalse\tstring2\t2017-10-03T10:00:00.010000Z\tabc\n\t0.300000000000\t91\ttrue\tstring4\t2017-10-03T10:00:00.040000Z\trow4\n", "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t2017-10-03T10:00:00.020000Z\n66\tbox\t7.900000000000\t2017-10-03T10:00:00.030000Z\n", lines);
    }

    @Test
    public void testUnquotedString1() throws Exception {
        String expected1 = "sym2\tdouble\tint\tbool\tstr\ttimestamp\tsym1\nxyz\t1.600000000000\t15\ttrue\tstring1\t2017-10-03T10:00:00.000000Z\t\n\t9.400000000000\t6\tfalse\tstring3\t2017-10-03T10:00:00.020000Z\trow3\n\t0.300000000000\t91\ttrue\tstring4\t2017-10-03T10:00:00.040000Z\trow4\n";
        String expected2 = "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t2017-10-03T10:00:00.010000Z\n66\tbox\t7.900000000000\t2017-10-03T10:00:00.030000Z\n";
        String lines = "x,sym2=xyz double=1.6,int=15i,bool=true,str=\"string1\"\nx,sym1=abc double=1.3,int=11i,bool=false,str=string2\"\ny,asym1=55,asym2=box adouble=5.9\nx,sym1=row3 double=9.4,int=6i,bool=false,str=\"string3\"\ny,asym1=66,asym2=box adouble=7.9\nx,sym1=row4 double=.3,int=91i,bool=true,str=\"string4\"\n";
        this.assertMultiTable("sym2\tdouble\tint\tbool\tstr\ttimestamp\tsym1\nxyz\t1.600000000000\t15\ttrue\tstring1\t2017-10-03T10:00:00.000000Z\t\n\t9.400000000000\t6\tfalse\tstring3\t2017-10-03T10:00:00.020000Z\trow3\n\t0.300000000000\t91\ttrue\tstring4\t2017-10-03T10:00:00.040000Z\trow4\n", "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t2017-10-03T10:00:00.010000Z\n66\tbox\t7.900000000000\t2017-10-03T10:00:00.030000Z\n", lines);
    }

    @Test
    public void testUnquotedString2() throws Exception {
        String expected1 = "sym1\tdouble\tint\tbool\tstr\ttimestamp\nabc\t1.300000000000\t11\tfalse\tstring2\t2017-10-03T10:00:00.000000Z\nrow3\t9.400000000000\t6\tfalse\tstring3\t2017-10-03T10:00:00.020000Z\nrow4\t0.300000000000\t91\ttrue\tstring4\t2017-10-03T10:00:00.040000Z\n";
        String expected2 = "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t2017-10-03T10:00:00.010000Z\n66\tbox\t7.900000000000\t2017-10-03T10:00:00.030000Z\n";
        String lines = "x,sym2=xyz double=1.6,int=15i,bool=true,str=string1\"\nx,sym1=abc double=1.3,int=11i,bool=false,str=\"string2\"\ny,asym1=55,asym2=box adouble=5.9\nx,sym1=row3 double=9.4,int=6i,bool=false,str=\"string3\"\ny,asym1=66,asym2=box adouble=7.9\nx,sym1=row4 double=.3,int=91i,bool=true,str=\"string4\"\n";
        this.assertMultiTable("sym1\tdouble\tint\tbool\tstr\ttimestamp\nabc\t1.300000000000\t11\tfalse\tstring2\t2017-10-03T10:00:00.000000Z\nrow3\t9.400000000000\t6\tfalse\tstring3\t2017-10-03T10:00:00.020000Z\nrow4\t0.300000000000\t91\ttrue\tstring4\t2017-10-03T10:00:00.040000Z\n", "asym1\tasym2\tadouble\ttimestamp\n55\tbox\t5.900000000000\t2017-10-03T10:00:00.010000Z\n66\tbox\t7.900000000000\t2017-10-03T10:00:00.030000Z\n", lines);
    }

    private void assertMultiTable(String expected1, String expected2, String lines) throws Exception {
        DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

            public MicrosecondClock getMicrosecondClock() {
                try {
                    return new TestMicroClock(DateFormatUtils.parseDateTime((CharSequence)"2017-10-03T10:00:00.000Z"), 10L);
                }
                catch (NumericException e) {
                    throw CairoException.instance((int)0).put((CharSequence)"numeric");
                }
            }
        };
        this.assertThat(expected1, lines, "x", (CairoConfiguration)configuration);
        this.assertTable(expected2, "y");
    }

    private void assertTable(CharSequence expected, CharSequence tableName) throws IOException {
        try (TableReader reader = new TableReader(configuration, tableName);){
            this.assertThat(expected, (RecordCursor)reader.getCursor(), reader.getMetadata(), true);
        }
    }

    private void assertThat(String expected, String lines, CharSequence tableName, CairoConfiguration configuration) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (WriterPool pool = new WriterPool(configuration, null);
                 CairoLineProtoParser parser = new CairoLineProtoParser(configuration, (ResourcePool)pool);){
                byte[] bytes = lines.getBytes(StandardCharsets.UTF_8);
                int len = bytes.length;
                long mem = Unsafe.malloc((long)len);
                try {
                    for (int i = 0; i < len; ++i) {
                        Unsafe.getUnsafe().putByte(mem + (long)i, bytes[i]);
                    }
                    try (LineProtoLexer lexer = new LineProtoLexer(4096);){
                        lexer.withParser((LineProtoParser)parser);
                        lexer.parse(mem, mem + (long)len);
                        lexer.parseLast();
                        parser.commitAll();
                    }
                }
                finally {
                    Unsafe.free((long)mem, (long)len);
                }
            }
            this.assertTable(expected, tableName);
        });
    }

    private void assertThat(String expected, String lines, CharSequence tableName) throws Exception {
        this.assertThat(expected, lines, tableName, configuration);
    }
}

