/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cutlass.json;

import com.questdb.cutlass.json.JsonException;
import com.questdb.cutlass.json.JsonLexer;
import com.questdb.cutlass.json.JsonParser;
import com.questdb.std.Files;
import com.questdb.std.IntStack;
import com.questdb.std.Mutable;
import com.questdb.std.Os;
import com.questdb.std.Unsafe;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.Path;
import com.questdb.test.tools.TestUtils;
import java.nio.charset.StandardCharsets;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class JsonLexerTest {
    private static final JsonLexer LEXER = new JsonLexer(4, 1024);
    private static final JsonAssemblingParser listener = new JsonAssemblingParser();

    @AfterClass
    public static void tearDown() {
        LEXER.close();
    }

    @Before
    public void setUp() {
        LEXER.clear();
        listener.clear();
    }

    @Test
    public void tesStringTooLong() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            String json = "{\"a\":1, \"b\": \"123456789012345678901234567890\"]}";
            int len = json.length() - 6;
            long address = TestUtils.toMemory(json);
            try (JsonLexer lexer = new JsonLexer(4, 4);){
                try {
                    lexer.parse(address, (long)len, (JsonParser)listener);
                    lexer.parseLast();
                    Assert.fail();
                }
                catch (JsonException e) {
                    TestUtils.assertEquals((CharSequence)"String is too long", e.getFlyweightMessage());
                    Assert.assertEquals((long)41L, (long)e.getPosition());
                }
            }
            finally {
                Unsafe.free((long)address, (long)json.length());
            }
        });
    }

    @Test
    public void testArrayObjArray() throws Exception {
        this.assertThat("[{\"A\":[\"122\",\"133\"],\"x\":\"y\"},\"134\",\"abc\"]", "[\n{\"A\":[122, 133], \"x\": \"y\"}, 134  , \"abc\"\n]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBreakOnValue() throws Exception {
        String in = "{\"x\": \"abcdefhijklmn\"}";
        int len = in.length();
        long address = TestUtils.toMemory(in);
        try {
            LEXER.parse(address, (long)(len - 7), (JsonParser)listener);
            LEXER.parse(address + (long)len - 7L, 7L, (JsonParser)listener);
            LEXER.parseLast();
            TestUtils.assertEquals((CharSequence)"{\"x\":\"abcdefhijklmn\"}", listener.value());
        }
        finally {
            Unsafe.free((long)address, (long)len);
        }
    }

    @Test
    public void testDanglingArrayEnd() {
        this.assertError("Dangling ]", 8, "[1,2,3]]");
    }

    @Test
    public void testDanglingComma() {
        this.assertError("Attribute name expected", 12, "{\"x\": \"abc\",}");
    }

    @Test
    public void testDanglingObjectEnd() {
        this.assertError("Dangling }", 8, "[1,2,3]}");
    }

    @Test
    public void testEmptyArray() throws Exception {
        this.assertThat("[]", "[]");
    }

    @Test
    public void testEmptyObject() throws Exception {
        this.assertThat("{}", "{}");
    }

    @Test
    public void testExponent() throws Exception {
        this.assertThat("[\"-1.34E4\",\"3\"]", "[-1.34E4,3]");
    }

    @Test
    public void testIncorrectArrayStart() {
        this.assertError("[ is not expected here", 3, "[1[]]");
    }

    @Test
    public void testInvalidObjectNesting() {
        this.assertError("{ is not expected here", 11, "{\"a\":\"x\", {}}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalidUtf8Value() {
        int i;
        byte[] bytesA = "{\"x\":\"\u8fdd\u6cd5\u8fdd,\u63a7\u7f51\u7ad9\u6f0f\u6d1e\u98ce\", \"y\":\"\u7ad9\u6f0f\u6d1e\u98ce".getBytes(StandardCharsets.UTF_8);
        byte[] bytesB = new byte[]{-116, -76, -55, 55, -34, 0, -11, 15, 13};
        byte[] bytesC = "\"}".getBytes(StandardCharsets.UTF_8);
        byte[] bytes = new byte[bytesA.length + bytesB.length + bytesC.length];
        System.arraycopy(bytesA, 0, bytes, 0, bytesA.length);
        System.arraycopy(bytesB, 0, bytes, bytesA.length, bytesB.length);
        System.arraycopy(bytesC, 0, bytes, bytesA.length + bytesB.length, bytesC.length);
        int len = bytes.length;
        long address = Unsafe.malloc((long)len);
        for (i = 0; i < len; ++i) {
            Unsafe.getUnsafe().putByte(address + (long)i, bytes[i]);
        }
        try {
            for (i = 0; i < len; ++i) {
                try {
                    listener.clear();
                    LEXER.clear();
                    LEXER.parse(address, (long)i, (JsonParser)listener);
                    LEXER.parse(address + (long)i, (long)(len - i), (JsonParser)listener);
                    LEXER.parseLast();
                    Assert.fail();
                    continue;
                }
                catch (JsonException e) {
                    TestUtils.assertEquals((CharSequence)"Unsupported encoding", e.getFlyweightMessage());
                    Assert.assertEquals((long)43L, (long)e.getPosition());
                }
            }
        }
        finally {
            Unsafe.free((long)address, (long)len);
        }
    }

    @Test
    public void testJsonSlicingAndPositions() throws Exception {
        this.assertThat("<1>[<2>{<4>\"name\":<11>\"null\"<18>,\"type\":<25>\"true\"<32>,\"formatPattern\":<47>\"12E-2\"<55>,\"locale\":<65>\"en-GB\"<71>}<72>]", "[{\"name\": null, \"type\": true, \"formatPattern\":12E-2, \"locale\": \"en-GB\"}]", true);
    }

    @Test
    public void testMisplacedArrayEnd() {
        this.assertError("] is not expected here. You have non-terminated object", 18, "{\"a\":1, \"b\": 15.2]}");
    }

    @Test
    public void testMisplacedColon() {
        this.assertError("Misplaced ':'", 9, "{\"a\":\"x\":}");
    }

    @Test
    public void testMisplacedQuote() {
        this.assertError("Unexpected quote '\"'", 9, "{\"a\":\"1\"\", \"b\": 15.2}");
    }

    @Test
    public void testMisplacesObjectEnd() {
        this.assertError("} is not expected here. You have non-terminated array", 7, "[1,2,3}");
    }

    @Test
    public void testMissingArrayValue() {
        this.assertError("Unexpected comma", 2, "[,]");
    }

    @Test
    public void testMissingAttributeValue() {
        this.assertError("Attribute value expected", 6, "{\"x\": }");
    }

    @Test
    public void testNestedObjNestedArray() throws Exception {
        this.assertThat("{\"x\":{\"y\":[[\"1\",\"2\",\"3\"],[\"5\",\"2\",\"3\"],[\"0\",\"1\"]],\"a\":\"b\"}}", "{\"x\": { \"y\": [[1,2,3], [5,2,3], [0,1]], \"a\":\"b\"}}");
    }

    @Test
    public void testNestedObjects() throws Exception {
        this.assertThat("{\"abc\":{\"x\":\"123\"},\"val\":\"000\"}", "{\"abc\": {\"x\":\"123\"}, \"val\": \"000\"}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParseLargeFile() throws Exception {
        String path = JsonLexerTest.class.getResource("/json/test.json").getPath();
        Path p = new Path();
        if (Os.type == 3 && path.startsWith("/")) {
            p.of((CharSequence)path.substring(1));
        } else {
            p.of((CharSequence)path);
        }
        try {
            long l = Files.length((LPSZ)p.$());
            long fd = Files.openRO((LPSZ)p);
            NoOpParser listener = new NoOpParser();
            try {
                long buf = Unsafe.malloc((long)l);
                long bufA = Unsafe.malloc((long)l);
                long bufB = Unsafe.malloc((long)l);
                try {
                    Assert.assertEquals((long)l, (long)Files.read((long)fd, (long)buf, (long)((int)l), (long)0L));
                    long t = System.nanoTime();
                    int i = 0;
                    while ((long)i < l) {
                        try {
                            LEXER.clear();
                            Unsafe.getUnsafe().copyMemory(buf, bufA, i);
                            Unsafe.getUnsafe().copyMemory(buf + (long)i, bufB, l - (long)i);
                            LEXER.parse(bufA, (long)i, (JsonParser)listener);
                            LEXER.parse(bufB, l - (long)i, (JsonParser)listener);
                            LEXER.parseLast();
                        }
                        catch (JsonException e) {
                            System.out.println(i);
                            throw e;
                        }
                        ++i;
                    }
                    System.out.println((System.nanoTime() - t) / l);
                }
                finally {
                    Unsafe.free((long)buf, (long)l);
                    Unsafe.free((long)bufA, (long)l);
                    Unsafe.free((long)bufB, (long)l);
                }
            }
            finally {
                Files.close((long)fd);
            }
        }
        finally {
            p.close();
        }
    }

    @Test
    public void testQuoteEscape() throws Exception {
        this.assertThat("{\"x\":\"a\\\"bc\"}", "{\"x\": \"a\\\"bc\"}");
    }

    @Test
    public void testSimpleJson() throws Exception {
        this.assertThat("{\"abc\":\"123\"}", "{\"abc\": \"123\"}");
    }

    @Test
    public void testUnclosedQuote() {
        this.assertError("Unexpected symbol", 11, "{\"a\":\"1, \"b\": 15.2}");
    }

    @Test
    public void testUnquotedNumbers() throws Exception {
        this.assertThat("[{\"A\":\"122\"},\"134\",\"abc\"]", "[\n{\"A\":122}, 134  , \"abc\"\n]");
    }

    @Test
    public void testUnterminatedArray() {
        this.assertError("Unterminated array", 37, "{\"x\": { \"y\": [[1,2,3], [5,2,3], [0,1]");
    }

    @Test
    public void testUnterminatedObject() {
        this.assertError("Unterminated object", 38, "{\"x\": { \"y\": [[1,2,3], [5,2,3], [0,1]]");
    }

    @Test
    public void testUnterminatedString() {
        this.assertError("Unterminated string", 46, "{\"x\": { \"y\": [[1,2,3], [5,2,3], [0,1]], \"a\":\"b");
    }

    @Test
    public void testUtf8() throws Exception {
        this.assertThat("{\"id\":\"japanese_cheat_sheet\",\"name\":\"Basic Japanese\",\"description\":\"A guide to basic Japanese\",\"metadata\":,{\"sourceName\":\"Tofugu\",\"sourceUrl\":\"https://www.tofugu.com/japanese/important-japanese-words/\"},\"template_type\":\"language\",\"section_order\":,[\"Numbers\",\"Polite Phrases\",\"Greetings\",\"Questions\",\"Locations\",\"Verbs\"],\"sections\":,{\"Numbers\":[{\"trn\":\"rei/zero\",\"val\":\"\u96f6\",\"key\":\"0\"},{\"trn\":\"ichi\",\"val\":\"\u4e00\",\"key\":\"1\"},{\"trn\":\"ni\",\"val\":\"\u4e8c\",\"key\":\"2\"},{\"trn\":\"san\",\"val\":\"\u4e09\",\"key\":\"3\"},{\"trn\":\"shi/yon\",\"val\":\"\u56db\",\"key\":\"4\"},{\"trn\":\"go\",\"val\":\"\u4e94\",\"key\":\"5\"},{\"trn\":\"roku\",\"val\":\"\u516d\",\"key\":\"6\"},{\"trn\":\"nana/shichi\",\"val\":\"\u4e03\",\"key\":\"7\"},{\"trn\":\"hachi\",\"val\":\"\u516b\",\"key\":\"8\"},{\"trn\":\"ky\u016b\",\"val\":\"\u4e5d\",\"key\":\"9\"},{\"trn\":\"j\u016b\",\"val\":\"\u5341\",\"key\":\"10\"},{\"trn\":\"nij\u016b\",\"val\":\"\u4e8c\u5341\",\"key\":\"20\"},{\"trn\":\"sanj\u016b\",\"val\":\"\u4e09\u5341\",\"key\":\"30\"},{\"trn\":\"yonj\u016b\",\"val\":\"\u56db\u5341\",\"key\":\"40\"},{\"trn\":\"goj\u016b\",\"val\":\"\u4e94\u5341\",\"key\":\"50\"},{\"trn\":\"hyaku\",\"val\":\"\u767e\",\"key\":\"100\"},{\"trn\":\"gohyaku\",\"val\":\"\u4e94\u767e\",\"key\":\"500\"},{\"trn\":\"sen\",\"val\":\"\u5343\",\"key\":\"1000\"},{\"trn\":\"sanzen\",\"val\":\"\u4e09\u5343\",\"key\":\"3000\"},{\"trn\":\"gosen\",\"val\":\"\u4e94\u5343\",\"key\":\"5000\"},{\"trn\":\"ichiman\",\"val\":\"\u4e00\u4e07/\u842c\",\"key\":\"10000\"}],\"Polite Phrases\":,[{\"trn\":\"arigatou gozaimasu\",\"val\":\"\u3042\u308a\u304c\u3068\u3046\u3054\u3056\u3044\u307e\u3059\",\"key\":\"Thank you\"},{\"trn\":\"gomen-nasai\",\"val\":\"\u3054\u3081\u3093\u306a\u3055\u3044\",\"key\":\"I'm sorry\"},{\"trn\":\"sumimasen\",\"val\":\"\u3059\u307f\u307e\u305b\u3093\",\"key\":\"Excuse me/I'm sorry\"},{\"trn\":\"domo arigatou gozaimasu\",\"val\":\"\u3069\u3046\u3082\u3042\u308a\u304c\u3068\u3046\u3054\u3056\u3044\u307e\u3059\",\"key\":\"Thank you very much\"},{\"trn\":\"itadakimasu\",\"val\":\"\u3044\u305f\u3060\u304d\u307e\u3059\",\"key\":\"Thanks for the food\"}],\"Greetings\":,[{\"trn\":\"Matthew desu\",\"val\":\"\u30de\u30b7\u30e5\u30fc\u3067\u3059\",\"key\":\"I'm Matthew\"},{\"trn\":\"hajimemashite\",\"val\":\"\u306f\u3058\u3081\u307e\u3057\u3066\",\"key\":\"How do you do\"},{\"trn\":\"anata no namae wa nandesuka\",\"val\":\"\u3042\u306a\u305f\u306e\u540d\u524d\u306f\u4f55\u3067\u3059\u304b\",\"key\":\"What's your name\"},{\"trn\":\"yoroshiku onegai shimasu\",\"val\":\"\u3088\u308d\u3057\u304f\u304a\u9858\u3044\u3057\u307e\u3059\",\"key\":\"I'm pleased to meet you\"},{\"trn\":\"ohayou gozaimasu\",\"val\":\"\u304a\u306f\u3088\u3046\u3054\u3056\u3044\u307e\u3059\",\"key\":\"Good morning\"},{\"trn\":\"kon-nichi-wa\",\"val\":\"\u3053\u3093\u306b\u3061\u306f\",\"key\":\"Hello/Good Afternoon\"},{\"trn\":\"kon-ban-wa\",\"val\":\"\u3053\u3093\u3070\u3093\u306f\",\"key\":\"Good Evening\"},{\"trn\":\"oyasuminasai\",\"val\":\"\u304a\u3084\u3059\u307f\u306a\u3055\u3044\",\"key\":\"Good Night\"},{\"trn\":\"say\u014dnara\",\"val\":\"\u3055\u3088\u3046\u306a\u3089\",\"key\":\"GoodBye\"},{\"trn\":\"mata aimash\u014d\",\"val\":\"\u307e\u305f\u4f1a\u3044\u307e\u3057\u3087\u3046\",\"key\":\"See you again\"},{\"trn\":\"dewamata\",\"val\":\"\u3067\u306f\u307e\u305f\",\"key\":\"See you later\"},{\"trn\":\"mata ashita\",\"val\":\"\u307e\u305f\u660e\u65e5\",\"key\":\"See you Tomorrow\"}],\"Questions\":,[{\"trn\":\"dare desu ka\",\"val\":\"\u8ab0\u3067\u3059\u304b\",\"key\":\"Who is it\"},{\"trn\":\"d\u014d desu ka\",\"val\":\"\u3069\u3046\u3067\u3059\u304b\",\"key\":\"How is it\"},{\"trn\":\"doko desu ka\",\"val\":\"\u3069\u3053\u3067\u3059\u304b\",\"key\":\"Where is it\"},{\"trn\":\"doushita\",\"val\":\"\u3069\u3046\u3057\u305f\",\"key\":\"What happened\"},{\"trn\":\"d\u014dshite\",\"val\":\"\u3069\u3046\u3057\u3066\",\"key\":\"Why\"},{\"trn\":\"dore\",\"val\":\"\u3069\u308c\",\"key\":\"Which one\"},{\"trn\":\"ikura desu ka\",\"val\":\"\u3044\u304f\u3089\u3067\u3059\u304b\",\"key\":\"How much is this?\"},{\"trn\":\"itsu\",\"val\":\"\u3044\u3064\",\"key\":\"When\"},{\"trn\":\"nan desu ka\",\"val\":\"\u4f55\u3067\u3059\u304b\",\"key\":\"What is it\"},{\"trn\":\"ima nanji desu ka\",\"val\":\"\u4eca\u4f55\u6642\u3067\u3059\u304b\",\"key\":\"What time is it\"}],\"Locations\":,[{\"trn\":\"hoteru\",\"val\":\"\u30db\u30c6\u30eb\",\"key\":\"Hotel\"},{\"trn\":\"kuukou\",\"val\":\"\u7a7a\u6e2f\",\"key\":\"Airport\"},{\"trn\":\"eki\",\"val\":\"\u99c5\",\"key\":\"Station\"},{\"trn\":\"nihon/nippon\",\"val\":\"\u65e5\u672c\",\"key\":\"Japan\"},{\"trn\":\"daigaku\",\"val\":\"\u5927\u5b66\",\"key\":\"university\"},{\"trn\":\"takushi\",\"val\":\"\u30bf\u30af\u30b7\u30fc\",\"key\":\"Taxi\"}],\"Verbs\":,[{\"trn\":\"iku\",\"val\":\"\u884c\u304f\",\"key\":\"To Go\"},{\"trn\":\"kaeru\",\"val\":\"\u5e30\u308b\",\"key\":\"To Return\"},{\"trn\":\"taberu\",\"val\":\"\u98df\u3079\u308b\",\"key\":\"Eat\"},{\"trn\":\"yaru/suru\",\"val\":\"\u3084\u308b\u30fb\u3059\u308b\",\"key\":\"To Do\"},{\"trn\":\"miru\",\"val\":\"\u898b\u308b\",\"key\":\"To See\"},{\"trn\":\"kau\",\"val\":\"\u8cb7\u3046\",\"key\":\"To Buy\"},{\"trn\":\"matsu\",\"val\":\"\u5f85\u3064\",\"key\":\"To Wait\"},{\"trn\":\"tomaru\",\"val\":\"\u6b62\u307e\u308b\",\"key\":\"To Stop\"},{\"trn\":\"oshieru\",\"val\":\"\u6559\u3048\u308b\",\"key\":\"Teach\"},{\"trn\":\"hanasu\",\"val\":\"\u8a71\u3059\",\"key\":\"To Speak\"}]}}", "{\n   \"id\":\"japanese_cheat_sheet\",\n   \"name\":\"Basic Japanese\",\n   \"description\":\"A guide to basic Japanese\",\n   \"metadata\":{\n      \"sourceName\":\"Tofugu\",\n      \"sourceUrl\":\"https://www.tofugu.com/japanese/important-japanese-words/\"\n   },\n   \"template_type\":\"language\",\n   \"section_order\":[\n      \"Numbers\",\n      \"Polite Phrases\",\n      \"Greetings\",\n      \"Questions\",\n      \"Locations\",\n      \"Verbs\"\n   ],\n   \"sections\":{\n      \"Numbers\":[\n         {\n            \"trn\":\"rei/zero\",\n            \"val\":\"\u96f6\",\n            \"key\":\"0\"\n         },\n         {\n            \"trn\":\"ichi\",\n            \"val\":\"\u4e00\",\n            \"key\":\"1\"\n         },\n         {\n            \"trn\":\"ni\",\n            \"val\":\"\u4e8c\",\n            \"key\":\"2\"\n         },\n         {\n            \"trn\":\"san\",\n            \"val\":\"\u4e09\",\n            \"key\":\"3\"\n         },\n         {\n            \"trn\":\"shi/yon\",\n            \"val\":\"\u56db\",\n            \"key\":\"4\"\n         },\n         {\n            \"trn\":\"go\",\n            \"val\":\"\u4e94\",\n            \"key\":\"5\"\n         },\n         {\n            \"trn\":\"roku\",\n            \"val\":\"\u516d\",\n            \"key\":\"6\"\n         },\n         {\n            \"trn\":\"nana/shichi\",\n            \"val\":\"\u4e03\",\n            \"key\":\"7\"\n         },\n         {\n            \"trn\":\"hachi\",\n            \"val\":\"\u516b\",\n            \"key\":\"8\"\n         },\n         {\n            \"trn\":\"ky\u016b\",\n            \"val\":\"\u4e5d\",\n            \"key\":\"9\"\n         },\n         {\n            \"trn\":\"j\u016b\",\n            \"val\":\"\u5341\",\n            \"key\":\"10\"\n         },\n         {\n            \"trn\":\"nij\u016b\",\n            \"val\":\"\u4e8c\u5341\",\n            \"key\":\"20\"\n         },\n         {\n            \"trn\":\"sanj\u016b\",\n            \"val\":\"\u4e09\u5341\",\n            \"key\":\"30\"\n         },\n         {\n            \"trn\":\"yonj\u016b\",\n            \"val\":\"\u56db\u5341\",\n            \"key\":\"40\"\n         },\n         {\n            \"trn\":\"goj\u016b\",\n            \"val\":\"\u4e94\u5341\",\n            \"key\":\"50\"\n         },\n         {\n            \"trn\":\"hyaku\",\n            \"val\":\"\u767e\",\n            \"key\":\"100\"\n         },\n         {\n            \"trn\":\"gohyaku\",\n            \"val\":\"\u4e94\u767e\",\n            \"key\":\"500\"\n         },\n         {\n            \"trn\":\"sen\",\n            \"val\":\"\u5343\",\n            \"key\":\"1000\"\n         },\n         {\n            \"trn\":\"sanzen\",\n            \"val\":\"\u4e09\u5343\",\n            \"key\":\"3000\"\n         },\n         {\n            \"trn\":\"gosen\",\n            \"val\":\"\u4e94\u5343\",\n            \"key\":\"5000\"\n         },\n         {\n            \"trn\":\"ichiman\",\n            \"val\":\"\u4e00\u4e07/\u842c\",\n            \"key\":\"10000\"\n         }\n      ],\n      \"Polite Phrases\":[\n         {\n            \"trn\":\"arigatou gozaimasu\",\n            \"val\":\"\u3042\u308a\u304c\u3068\u3046\u3054\u3056\u3044\u307e\u3059\",\n            \"key\":\"Thank you\"\n         },\n         {\n            \"trn\":\"gomen-nasai\",\n            \"val\":\"\u3054\u3081\u3093\u306a\u3055\u3044\",\n            \"key\":\"I'm sorry\"\n         },\n         {\n            \"trn\":\"sumimasen\",\n            \"val\":\"\u3059\u307f\u307e\u305b\u3093\",\n            \"key\":\"Excuse me/I'm sorry\"\n         },\n         {\n            \"trn\":\"domo arigatou gozaimasu\",\n            \"val\":\"\u3069\u3046\u3082\u3042\u308a\u304c\u3068\u3046\u3054\u3056\u3044\u307e\u3059\",\n            \"key\":\"Thank you very much\"\n         },\n         {\n            \"trn\":\"itadakimasu\",\n            \"val\":\"\u3044\u305f\u3060\u304d\u307e\u3059\",\n            \"key\":\"Thanks for the food\"\n         }\n      ],\n      \"Greetings\":[\n         {\n            \"trn\":\"Matthew desu\",\n            \"val\":\"\u30de\u30b7\u30e5\u30fc\u3067\u3059\",\n            \"key\":\"I'm Matthew\"\n         },\n         {\n            \"trn\":\"hajimemashite\",\n            \"val\":\"\u306f\u3058\u3081\u307e\u3057\u3066\",\n            \"key\":\"How do you do\"\n         },\n         {\n            \"trn\":\"anata no namae wa nandesuka\",\n            \"val\":\"\u3042\u306a\u305f\u306e\u540d\u524d\u306f\u4f55\u3067\u3059\u304b\",\n            \"key\":\"What's your name\"\n         },\n         {\n            \"trn\":\"yoroshiku onegai shimasu\",\n            \"val\":\"\u3088\u308d\u3057\u304f\u304a\u9858\u3044\u3057\u307e\u3059\",\n            \"key\":\"I'm pleased to meet you\"\n         },\n         {\n            \"trn\":\"ohayou gozaimasu\",\n            \"val\":\"\u304a\u306f\u3088\u3046\u3054\u3056\u3044\u307e\u3059\",\n            \"key\":\"Good morning\"\n         },\n         {\n            \"trn\":\"kon-nichi-wa\",\n            \"val\":\"\u3053\u3093\u306b\u3061\u306f\",\n            \"key\":\"Hello/Good Afternoon\"\n         },\n         {\n            \"trn\":\"kon-ban-wa\",\n            \"val\":\"\u3053\u3093\u3070\u3093\u306f\",\n            \"key\":\"Good Evening\"\n         },\n         {\n            \"trn\":\"oyasuminasai\",\n            \"val\":\"\u304a\u3084\u3059\u307f\u306a\u3055\u3044\",\n            \"key\":\"Good Night\"\n         },\n         {\n            \"trn\":\"say\u014dnara\",\n            \"val\":\"\u3055\u3088\u3046\u306a\u3089\",\n            \"key\":\"GoodBye\"\n         },\n         {\n            \"trn\":\"mata aimash\u014d\",\n            \"val\":\"\u307e\u305f\u4f1a\u3044\u307e\u3057\u3087\u3046\",\n            \"key\":\"See you again\"\n         },\n         {\n            \"trn\":\"dewamata\",\n            \"val\":\"\u3067\u306f\u307e\u305f\",\n            \"key\":\"See you later\"\n         },\n         {\n            \"trn\":\"mata ashita\",\n            \"val\":\"\u307e\u305f\u660e\u65e5\",\n            \"key\":\"See you Tomorrow\"\n         }\n      ],\n      \"Questions\":[\n         {\n            \"trn\":\"dare desu ka\",\n            \"val\":\"\u8ab0\u3067\u3059\u304b\",\n            \"key\":\"Who is it\"\n         },\n         {\n            \"trn\":\"d\u014d desu ka\",\n            \"val\":\"\u3069\u3046\u3067\u3059\u304b\",\n            \"key\":\"How is it\"\n         },\n         {\n            \"trn\":\"doko desu ka\",\n            \"val\":\"\u3069\u3053\u3067\u3059\u304b\",\n            \"key\":\"Where is it\"\n         },\n         {\n            \"trn\":\"doushita\",\n            \"val\":\"\u3069\u3046\u3057\u305f\",\n            \"key\":\"What happened\"\n         },\n         {\n            \"trn\":\"d\u014dshite\",\n            \"val\":\"\u3069\u3046\u3057\u3066\",\n            \"key\":\"Why\"\n         },\n         {\n            \"trn\":\"dore\",\n            \"val\":\"\u3069\u308c\",\n            \"key\":\"Which one\"\n         },\n         {\n            \"trn\":\"ikura desu ka\",\n            \"val\":\"\u3044\u304f\u3089\u3067\u3059\u304b\",\n            \"key\":\"How much is this?\"\n         },\n         {\n            \"trn\":\"itsu\",\n            \"val\":\"\u3044\u3064\",\n            \"key\":\"When\"\n         },\n         {\n            \"trn\":\"nan desu ka\",\n            \"val\":\"\u4f55\u3067\u3059\u304b\",\n            \"key\":\"What is it\"\n         },\n         {\n            \"trn\":\"ima nanji desu ka\",\n            \"val\":\"\u4eca\u4f55\u6642\u3067\u3059\u304b\",\n            \"key\":\"What time is it\"\n         }\n      ],\n      \"Locations\":[\n         {\n            \"trn\":\"hoteru\",\n            \"val\":\"\u30db\u30c6\u30eb\",\n            \"key\":\"Hotel\"\n         },\n         {\n            \"trn\":\"kuukou\",\n            \"val\":\"\u7a7a\u6e2f\",\n            \"key\":\"Airport\"\n         },\n         {\n            \"trn\":\"eki\",\n            \"val\":\"\u99c5\",\n            \"key\":\"Station\"\n         },\n         {\n            \"trn\":\"nihon/nippon\",\n            \"val\":\"\u65e5\u672c\",\n            \"key\":\"Japan\"\n         },\n         {\n            \"trn\":\"daigaku\",\n            \"val\":\"\u5927\u5b66\",\n            \"key\":\"university\"\n         },\n         {\n            \"trn\":\"takushi\",\n            \"val\":\"\u30bf\u30af\u30b7\u30fc\",\n            \"key\":\"Taxi\"\n         }\n      ],\n      \"Verbs\":[\n         {\n            \"trn\":\"iku\",\n            \"val\":\"\u884c\u304f\",\n            \"key\":\"To Go\"\n         },\n         {\n            \"trn\":\"kaeru\",\n            \"val\":\"\u5e30\u308b\",\n            \"key\":\"To Return\"\n         },\n         {\n            \"trn\":\"taberu\",\n            \"val\":\"\u98df\u3079\u308b\",\n            \"key\":\"Eat\"\n         },\n         {\n            \"trn\":\"yaru/suru\",\n            \"val\":\"\u3084\u308b\u30fb\u3059\u308b\",\n            \"key\":\"To Do\"\n         },\n         {\n            \"trn\":\"miru\",\n            \"val\":\"\u898b\u308b\",\n            \"key\":\"To See\"\n         },\n         {\n            \"trn\":\"kau\",\n            \"val\":\"\u8cb7\u3046\",\n            \"key\":\"To Buy\"\n         },\n         {\n            \"trn\":\"matsu\",\n            \"val\":\"\u5f85\u3064\",\n            \"key\":\"To Wait\"\n         },\n         {\n            \"trn\":\"tomaru\",\n            \"val\":\"\u6b62\u307e\u308b\",\n            \"key\":\"To Stop\"\n         },\n         {\n            \"trn\":\"oshieru\",\n            \"val\":\"\u6559\u3048\u308b\",\n            \"key\":\"Teach\"\n         },\n         {\n            \"trn\":\"hanasu\",\n            \"val\":\"\u8a71\u3059\",\n            \"key\":\"To Speak\"\n         }\n      ]\n   }\n}");
    }

    @Test
    public void testWrongQuote() {
        this.assertError("Unexpected symbol", 10, "{\"x\": \"a\"bc\",}");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertError(String expected, int expectedPosition, String input) {
        int len = input.length();
        long address = TestUtils.toMemory(input);
        try (JsonLexer lexer = new JsonLexer(4, 4);){
            for (int i = 0; i < len; ++i) {
                try {
                    listener.clear();
                    lexer.clear();
                    lexer.parse(address, (long)i, (JsonParser)listener);
                    lexer.parse(address + (long)i, (long)(len - i), (JsonParser)listener);
                    lexer.parseLast();
                    Assert.fail();
                    continue;
                }
                catch (JsonException e) {
                    TestUtils.assertEquals((CharSequence)expected, e.getFlyweightMessage());
                    Assert.assertEquals((long)expectedPosition, (long)e.getPosition());
                }
            }
        }
        finally {
            Unsafe.free((long)address, (long)len);
        }
    }

    private void assertThat(String expected, String input) throws Exception {
        this.assertThat(expected, input, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertThat(String expected, String input, boolean recordPositions) throws Exception {
        int i;
        byte[] bytes = input.getBytes(StandardCharsets.UTF_8);
        int len = bytes.length;
        long address = Unsafe.malloc((long)len);
        for (i = 0; i < len; ++i) {
            Unsafe.getUnsafe().putByte(address + (long)i, bytes[i]);
        }
        try {
            listener.recordPositions = recordPositions;
            for (i = 0; i < len; ++i) {
                listener.clear();
                LEXER.clear();
                LEXER.parse(address, (long)i, (JsonParser)listener);
                LEXER.parse(address + (long)i, (long)(len - i), (JsonParser)listener);
                LEXER.parseLast();
                TestUtils.assertEquals((CharSequence)expected, listener.value());
            }
        }
        finally {
            Unsafe.free((long)address, (long)len);
        }
    }

    private static class JsonAssemblingParser
    implements JsonParser,
    Mutable {
        private final StringBuffer buffer = new StringBuffer();
        private final IntStack itemCountStack = new IntStack();
        private int itemCount = 0;
        private boolean recordPositions = false;

        private JsonAssemblingParser() {
        }

        public void clear() {
            this.buffer.setLength(0);
            this.itemCount = 0;
            this.itemCountStack.clear();
        }

        public CharSequence value() {
            return this.buffer;
        }

        public void onEvent(int code, CharSequence tag, int position) {
            if (this.recordPositions) {
                this.buffer.append('<').append(position).append('>');
            }
            switch (code) {
                case 1: {
                    if (this.itemCount++ > 0) {
                        this.buffer.append(',');
                    }
                    this.buffer.append('{');
                    this.itemCountStack.push(this.itemCount);
                    this.itemCount = 0;
                    break;
                }
                case 2: {
                    this.buffer.append('}');
                    this.itemCount = this.itemCountStack.pop();
                    break;
                }
                case 3: {
                    if (this.itemCount++ > 0) {
                        this.buffer.append(',');
                    }
                    this.buffer.append('[');
                    this.itemCountStack.push(this.itemCount);
                    this.itemCount = 0;
                    break;
                }
                case 4: {
                    this.itemCount = this.itemCountStack.pop();
                    this.buffer.append(']');
                    break;
                }
                case 5: {
                    if (this.itemCount > 0) {
                        this.buffer.append(',');
                    }
                    this.buffer.append('\"');
                    this.buffer.append(tag);
                    this.buffer.append('\"');
                    this.buffer.append(':');
                    break;
                }
                case 6: {
                    this.buffer.append('\"');
                    this.buffer.append(tag);
                    this.buffer.append('\"');
                    ++this.itemCount;
                    break;
                }
                case 7: {
                    if (this.itemCount++ > 0) {
                        this.buffer.append(',');
                    }
                    this.buffer.append('\"');
                    this.buffer.append(tag);
                    this.buffer.append('\"');
                    break;
                }
            }
        }
    }

    private static final class NoOpParser
    implements JsonParser {
        private NoOpParser() {
        }

        public void onEvent(int code, CharSequence tag, int position) {
        }
    }
}

