/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo.pool;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.DefaultCairoConfiguration;
import com.questdb.cairo.DefaultLifecycleManager;
import com.questdb.cairo.LifecycleManager;
import com.questdb.cairo.TableModel;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.TestFilesFacade;
import com.questdb.cairo.pool.PoolListener;
import com.questdb.cairo.pool.WriterPool;
import com.questdb.cairo.pool.ex.EntryLockedException;
import com.questdb.cairo.pool.ex.EntryUnavailableException;
import com.questdb.cairo.pool.ex.PoolClosedException;
import com.questdb.std.Chars;
import com.questdb.std.FilesFacade;
import com.questdb.std.str.LPSZ;
import com.questdb.test.tools.TestUtils;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class WriterPoolTest
extends AbstractCairoTest {
    private static final DefaultCairoConfiguration CONFIGURATION = new DefaultCairoConfiguration(root);

    @Before
    public void setUpInstance() {
        try (TableModel model = new TableModel(configuration, "z", 3).col("ts", 10);){
            CairoTestUtils.create(model);
        }
    }

    @Test
    public void testAllocateAndClear() throws Exception {
        this.assertWithPool(pool -> {
            int n = 2;
            CyclicBarrier barrier = new CyclicBarrier(n);
            CountDownLatch halt = new CountDownLatch(n);
            AtomicInteger errors1 = new AtomicInteger();
            AtomicInteger errors2 = new AtomicInteger();
            AtomicInteger writerCount = new AtomicInteger();
            new Thread(() -> {
                try {
                    for (int i = 0; i < 10000; ++i) {
                        try (TableWriter ignored = pool.get((CharSequence)"z");){
                            writerCount.incrementAndGet();
                        }
                        catch (EntryUnavailableException entryUnavailableException) {
                            // empty catch block
                        }
                        if (i == 1) {
                            barrier.await();
                            continue;
                        }
                        LockSupport.parkNanos(1L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors1.incrementAndGet();
                }
                finally {
                    halt.countDown();
                }
            }).start();
            new Thread(() -> {
                try {
                    barrier.await();
                    for (int i = 0; i < 10000; ++i) {
                        pool.releaseInactive();
                        LockSupport.parkNanos(1L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors2.incrementAndGet();
                }
                finally {
                    halt.countDown();
                }
            }).start();
            halt.await();
            Assert.assertTrue((writerCount.get() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)errors1.get());
            Assert.assertEquals((long)0L, (long)errors2.get());
        });
    }

    @Test
    public void testBasicCharSequence() throws Exception {
        try (TableModel model = new TableModel(configuration, "x", 3).col("ts", 10);){
            CairoTestUtils.create(model);
        }
        this.assertWithPool(pool -> {
            sink.clear();
            sink.put((CharSequence)"x");
            TableWriter writer1 = pool.get((CharSequence)sink);
            Assert.assertNotNull((Object)writer1);
            writer1.close();
            sink.clear();
            sink.put((CharSequence)"y");
            try (TableWriter writer2 = pool.get((CharSequence)"x");){
                Assert.assertSame((Object)writer1, (Object)writer2);
            }
        });
    }

    @Test
    public void testCannotLockWriter() throws Exception {
        final TestFilesFacade ff = new TestFilesFacade(){
            int count = 1;

            public long openRW(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"z.lock") && this.count-- > 0) {
                    return -1L;
                }
                return super.openRW(name);
            }

            @Override
            public boolean wasCalled() {
                return this.count <= 0;
            }
        };
        DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

            public FilesFacade getFilesFacade() {
                return ff;
            }
        };
        this.assertWithPool(pool -> {
            Assert.assertFalse((boolean)pool.lock((CharSequence)"z"));
            Assert.assertTrue((boolean)ff.wasCalled());
            TableWriter writer = pool.get((CharSequence)"z");
            Assert.assertNotNull((Object)writer);
            writer.close();
            Assert.assertTrue((boolean)pool.lock((CharSequence)"z"));
            try {
                pool.get((CharSequence)"z");
                Assert.fail();
            }
            catch (CairoException cairoException) {
                // empty catch block
            }
            try {
                new TableWriter((CairoConfiguration)configuration, (CharSequence)"z");
                Assert.fail();
            }
            catch (CairoException cairoException) {
                // empty catch block
            }
            pool.unlock((CharSequence)"z");
            writer = new TableWriter((CairoConfiguration)configuration, (CharSequence)"z");
            Assert.assertNotNull((Object)writer);
            writer.close();
            writer = pool.get((CharSequence)"z");
            Assert.assertNotNull((Object)writer);
            writer.close();
        }, (CairoConfiguration)configuration);
        Assert.assertTrue((boolean)ff.wasCalled());
    }

    @Test
    public void testClosedPoolLock() throws Exception {
        this.assertWithPool(pool -> {
            class X
            implements PoolListener {
                short ev = (short)-1;

                X() {
                }

                public void onEvent(byte factoryType, long thread, CharSequence name, short event, short segment, short position) {
                    this.ev = event;
                }
            }
            X x = new X();
            pool.setPoolListener((PoolListener)x);
            pool.close();
            try {
                pool.lock((CharSequence)"x");
                Assert.fail();
            }
            catch (PoolClosedException poolClosedException) {
                // empty catch block
            }
            Assert.assertEquals((long)24L, (long)x.ev);
        });
    }

    @Test
    public void testFactoryCloseBeforeRelease() throws Exception {
        this.assertWithPool(pool -> {
            try (TableWriter x = pool.get((CharSequence)"z");){
                Assert.assertEquals((long)0L, (long)pool.countFreeWriters());
                Assert.assertNotNull((Object)x);
                Assert.assertTrue((boolean)x.isOpen());
                Assert.assertSame((Object)x, (Object)pool.get((CharSequence)"z"));
                pool.close();
            }
            Assert.assertFalse((boolean)x.isOpen());
            try {
                pool.get((CharSequence)"z");
                Assert.fail();
            }
            catch (PoolClosedException poolClosedException) {
                // empty catch block
            }
        });
    }

    @Test
    public void testGetAndCloseRace() throws Exception {
        try (TableModel model = new TableModel(configuration, "xyz", 3).col("ts", 10);){
            CairoTestUtils.create(model);
        }
        for (int i = 0; i < 100; ++i) {
            this.assertWithPool(pool -> {
                AtomicInteger exceptionCount = new AtomicInteger();
                CyclicBarrier barrier = new CyclicBarrier(2);
                CountDownLatch stopLatch = new CountDownLatch(2);
                try (TableWriter writer = pool.get((CharSequence)"xyz");){
                    Assert.assertNotNull((Object)writer);
                }
                new Thread(() -> {
                    try {
                        barrier.await();
                        pool.close();
                    }
                    catch (Exception e) {
                        exceptionCount.incrementAndGet();
                        e.printStackTrace();
                    }
                    finally {
                        stopLatch.countDown();
                    }
                }).start();
                new Thread(() -> {
                    try {
                        barrier.await();
                        try (TableWriter writer2 = pool.get((CharSequence)"xyz");){
                            Assert.assertNotNull((Object)writer2);
                        }
                        catch (EntryUnavailableException | PoolClosedException writer2) {
                            // empty catch block
                        }
                    }
                    catch (Exception e) {
                        exceptionCount.incrementAndGet();
                        e.printStackTrace();
                    }
                    finally {
                        stopLatch.countDown();
                    }
                }).start();
                Assert.assertTrue((boolean)stopLatch.await(2L, TimeUnit.SECONDS));
                Assert.assertEquals((long)0L, (long)exceptionCount.get());
            });
        }
    }

    @Test
    public void testLockNonExisting() throws Exception {
        this.assertWithPool(pool -> {
            Assert.assertTrue((boolean)pool.lock((CharSequence)"z"));
            try {
                pool.get((CharSequence)"z");
                Assert.fail();
            }
            catch (EntryLockedException entryLockedException) {
                // empty catch block
            }
            pool.unlock((CharSequence)"z");
            try (TableWriter wx = pool.get((CharSequence)"z");){
                Assert.assertNotNull((Object)wx);
            }
        });
    }

    @Test
    public void testLockUnlock() throws Exception {
        try (TableModel model = new TableModel(configuration, "x", 3).col("ts", 10);){
            CairoTestUtils.create(model);
        }
        model = new TableModel(configuration, "y", 3).col("ts", 10);
        var2_2 = null;
        try {
            CairoTestUtils.create(model);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (model != null) {
                if (var2_2 != null) {
                    try {
                        model.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    model.close();
                }
            }
        }
        this.assertWithPool(pool -> {
            TableWriter wy = pool.get((CharSequence)"y");
            Assert.assertNotNull((Object)wy);
            Assert.assertTrue((boolean)wy.isOpen());
            try {
                Assert.assertTrue((boolean)pool.lock((CharSequence)"x"));
                Assert.assertTrue((boolean)wy.isOpen());
                try {
                    pool.get((CharSequence)"x");
                    Assert.fail();
                }
                catch (EntryLockedException entryLockedException) {
                    // empty catch block
                }
                CountDownLatch done = new CountDownLatch(1);
                AtomicBoolean result = new AtomicBoolean();
                new Thread(() -> {
                    try (TableWriter ignored = pool.get((CharSequence)"x");){
                        result.set(false);
                    }
                    catch (EntryUnavailableException ignored2) {
                        result.set(true);
                    }
                    catch (CairoException e) {
                        e.printStackTrace();
                        result.set(false);
                    }
                    done.countDown();
                }).start();
                Assert.assertTrue((boolean)done.await(1L, TimeUnit.SECONDS));
                Assert.assertTrue((boolean)result.get());
                pool.unlock((CharSequence)"x");
                try (TableWriter wx = pool.get((CharSequence)"x");){
                    Assert.assertNotNull((Object)wx);
                    Assert.assertTrue((boolean)wx.isOpen());
                    try {
                        pool.unlock((CharSequence)"x");
                        Assert.fail();
                    }
                    catch (CairoException cairoException) {
                        // empty catch block
                    }
                    Assert.assertTrue((boolean)wx.isOpen());
                }
            }
            finally {
                wy.close();
            }
        });
    }

    @Test
    public void testNewLock() throws Exception {
        this.assertWithPool(pool -> {
            Assert.assertTrue((boolean)pool.lock((CharSequence)"z"));
            try {
                pool.get((CharSequence)"z");
                Assert.fail();
            }
            catch (EntryLockedException entryLockedException) {
                // empty catch block
            }
            pool.unlock((CharSequence)"z");
        });
    }

    @Test
    public void testOneThreadGetRelease() throws Exception {
        this.assertWithPool(pool -> {
            try (TableWriter x = pool.get((CharSequence)"z");){
                Assert.assertEquals((long)0L, (long)pool.countFreeWriters());
                Assert.assertNotNull((Object)x);
                Assert.assertTrue((boolean)x.isOpen());
                Assert.assertSame((Object)x, (Object)pool.get((CharSequence)"z"));
            }
            Assert.assertEquals((long)1L, (long)pool.countFreeWriters());
            try (TableWriter y = pool.get((CharSequence)"z");){
                Assert.assertNotNull((Object)y);
                Assert.assertTrue((boolean)y.isOpen());
                Assert.assertSame((Object)y, (Object)x);
            }
            Assert.assertEquals((long)1L, (long)pool.countFreeWriters());
        });
    }

    @Test
    public void testReplaceWriterAfterUnlock() throws Exception {
        this.assertWithPool(pool -> {
            try (TableModel model = new TableModel(configuration, "x", 3).col("ts", 10);){
                CairoTestUtils.create(model);
            }
            Assert.assertTrue((boolean)pool.lock((CharSequence)"x"));
            TableWriter writer = new TableWriter(configuration, (CharSequence)"x", null, false, (LifecycleManager)DefaultLifecycleManager.INSTANCE);
            for (int i = 0; i < 100; ++i) {
                TableWriter.Row row = writer.newRow(0L);
                row.putDate(0, (long)i);
                row.append();
            }
            writer.commit();
            pool.unlock((CharSequence)"x", writer);
            Assert.assertSame((Object)writer, (Object)pool.get((CharSequence)"x"));
            writer.close();
            Assert.assertSame((Object)writer, (Object)pool.get((CharSequence)"x"));
            writer.close();
        });
    }

    @Test
    public void testToStringOnWriter() throws Exception {
        this.assertWithPool(pool -> {
            try (TableWriter w = pool.get((CharSequence)"z");){
                Assert.assertEquals((Object)"TableWriter{name=z}", (Object)w.toString());
            }
        });
    }

    @Test
    public void testTwoThreadsRaceToAllocate() throws Exception {
        this.assertWithPool(pool -> {
            for (int k = 0; k < 1000; ++k) {
                int n = 2;
                CyclicBarrier barrier = new CyclicBarrier(n);
                CountDownLatch halt = new CountDownLatch(n);
                AtomicInteger errors = new AtomicInteger();
                AtomicInteger writerCount = new AtomicInteger();
                for (int i = 0; i < n; ++i) {
                    new Thread(() -> {
                        try {
                            barrier.await();
                            try (TableWriter w2 = pool.get((CharSequence)"z");){
                                writerCount.incrementAndGet();
                                this.populate(w2);
                            }
                            catch (EntryUnavailableException w2) {
                                // empty catch block
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            errors.incrementAndGet();
                        }
                        finally {
                            halt.countDown();
                        }
                    }).start();
                }
                halt.await();
                Assert.assertTrue((writerCount.get() > 0 ? 1 : 0) != 0);
                Assert.assertEquals((long)0L, (long)errors.get());
                Assert.assertEquals((long)1L, (long)pool.countFreeWriters());
            }
        });
    }

    @Test
    public void testTwoThreadsRaceToAllocateAndLock() throws Exception {
        this.assertWithPool(pool -> {
            for (int k = 0; k < 1000; ++k) {
                int n = 2;
                CyclicBarrier barrier = new CyclicBarrier(n);
                CountDownLatch halt = new CountDownLatch(n);
                AtomicInteger errors = new AtomicInteger();
                AtomicInteger writerCount = new AtomicInteger();
                for (int i = 0; i < n; ++i) {
                    new Thread(() -> {
                        try {
                            barrier.await();
                            try (TableWriter w2 = pool.get((CharSequence)"z");){
                                writerCount.incrementAndGet();
                                this.populate(w2);
                                Assert.assertSame((Object)w2, (Object)pool.get((CharSequence)"z"));
                            }
                            catch (EntryUnavailableException w2) {
                                // empty catch block
                            }
                            if (pool.lock((CharSequence)"z")) {
                                pool.unlock((CharSequence)"z");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            errors.incrementAndGet();
                        }
                        finally {
                            halt.countDown();
                        }
                    }).start();
                }
                halt.await();
                Assert.assertTrue((writerCount.get() > 0 ? 1 : 0) != 0);
                Assert.assertEquals((long)0L, (long)errors.get());
                Assert.assertEquals((long)0L, (long)pool.countFreeWriters());
            }
        });
    }

    @Test
    public void testTwoThreadsRaceToLock() throws Exception {
        this.assertWithPool(pool -> {
            for (int k = 0; k < 1000; ++k) {
                int n = 2;
                CyclicBarrier barrier = new CyclicBarrier(n);
                CountDownLatch halt = new CountDownLatch(n);
                AtomicInteger errors = new AtomicInteger();
                AtomicInteger writerCount = new AtomicInteger();
                for (int i = 0; i < n; ++i) {
                    new Thread(() -> {
                        try {
                            barrier.await();
                            if (pool.lock((CharSequence)"z")) {
                                LockSupport.parkNanos(1L);
                                pool.unlock((CharSequence)"z");
                            } else {
                                Thread.yield();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            errors.incrementAndGet();
                        }
                        finally {
                            halt.countDown();
                        }
                    }).start();
                }
                halt.await();
                Assert.assertEquals((long)0L, (long)writerCount.get());
                Assert.assertEquals((long)0L, (long)errors.get());
                Assert.assertEquals((long)0L, (long)pool.countFreeWriters());
            }
        });
    }

    @Test
    public void testUnlockInAnotherThread() throws Exception {
        this.assertWithPool(pool -> {
            Assert.assertTrue((boolean)pool.lock((CharSequence)"x"));
            AtomicInteger errors = new AtomicInteger();
            CountDownLatch latch = new CountDownLatch(1);
            new Thread(() -> {
                try {
                    try {
                        pool.unlock((CharSequence)"x");
                        Assert.fail();
                    }
                    catch (CairoException e) {
                        TestUtils.assertContains(e.getMessage(), "Not lock owner");
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    latch.countDown();
                }
            }).start();
            Assert.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
            Assert.assertEquals((long)0L, (long)errors.get());
            try {
                pool.get((CharSequence)"x");
                Assert.fail();
            }
            catch (EntryLockedException entryLockedException) {
                // empty catch block
            }
            pool.unlock((CharSequence)"x");
        });
    }

    @Test
    public void testUnlockNonExisting() throws Exception {
        this.assertWithPool(pool -> {
            class X
            implements PoolListener {
                short ev = (short)-1;

                X() {
                }

                public void onEvent(byte factoryType, long thread, CharSequence name, short event, short segment, short position) {
                    this.ev = event;
                }
            }
            X x = new X();
            pool.setPoolListener((PoolListener)x);
            pool.unlock((CharSequence)"x");
            Assert.assertEquals((long)9L, (long)x.ev);
        });
    }

    @Test
    public void testUnlockWriterWhenPoolIsClosed() throws Exception {
        this.assertWithPool(pool -> {
            Assert.assertTrue((boolean)pool.lock((CharSequence)"z"));
            pool.close();
            TableWriter writer = new TableWriter(configuration, (CharSequence)"z");
            Assert.assertNotNull((Object)writer);
            writer.close();
        });
    }

    @Test
    public void testWriterDoubleClose() throws Exception {
        this.assertWithPool(pool -> {
            class X
            implements PoolListener {
                short ev = (short)-1;

                X() {
                }

                public void onEvent(byte factoryType, long thread, CharSequence name, short event, short segment, short position) {
                    this.ev = event;
                }
            }
            X x = new X();
            pool.setPoolListener((PoolListener)x);
            TableWriter w = pool.get((CharSequence)"z");
            Assert.assertNotNull((Object)w);
            Assert.assertEquals((long)1L, (long)pool.getBusyCount());
            w.close();
            Assert.assertEquals((long)1L, (long)x.ev);
            Assert.assertEquals((long)0L, (long)pool.getBusyCount());
            w.close();
            Assert.assertEquals((long)3L, (long)x.ev);
            Assert.assertEquals((long)0L, (long)pool.getBusyCount());
        });
    }

    @Test
    public void testWriterOpenFailOnce() throws Exception {
        final TestFilesFacade ff = new TestFilesFacade(){
            int count = 1;

            public long openRW(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"z.lock") && this.count-- > 0) {
                    return -1L;
                }
                return super.openRW(name);
            }

            @Override
            public boolean wasCalled() {
                return this.count <= 0;
            }
        };
        DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

            public FilesFacade getFilesFacade() {
                return ff;
            }
        };
        this.assertWithPool(pool -> {
            try {
                pool.get((CharSequence)"z");
                Assert.fail();
            }
            catch (CairoException cairoException) {
                // empty catch block
            }
            try {
                pool.get((CharSequence)"z");
                Assert.fail();
            }
            catch (CairoException cairoException) {
                // empty catch block
            }
            Assert.assertEquals((long)1L, (long)pool.size());
            Assert.assertEquals((long)1L, (long)pool.getBusyCount());
            pool.releaseInactive();
            Assert.assertEquals((long)0L, (long)pool.size());
            TableWriter w = pool.get((CharSequence)"z");
            Assert.assertEquals((long)1L, (long)pool.getBusyCount());
            w.close();
        }, (CairoConfiguration)configuration);
        Assert.assertTrue((boolean)ff.wasCalled());
    }

    private void assertWithPool(PoolAwareCode code, CairoConfiguration configuration) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (WriterPool pool = new WriterPool(configuration, null);){
                code.run(pool);
            }
        });
    }

    private void assertWithPool(PoolAwareCode code) throws Exception {
        this.assertWithPool(code, (CairoConfiguration)CONFIGURATION);
    }

    private void populate(TableWriter w) {
        long start = w.getMaxTimestamp();
        for (int i = 0; i < 1000; ++i) {
            w.newRow(start + (long)i).append();
            w.commit();
        }
    }

    private static interface PoolAwareCode {
        public void run(WriterPool var1) throws Exception;
    }
}

