/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo.pool;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.DefaultCairoConfiguration;
import com.questdb.cairo.RecordCursorPrinter;
import com.questdb.cairo.TableModel;
import com.questdb.cairo.TableReader;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.TestFilesFacade;
import com.questdb.cairo.pool.PoolListener;
import com.questdb.cairo.pool.ReaderPool;
import com.questdb.cairo.pool.ex.EntryLockedException;
import com.questdb.cairo.pool.ex.EntryUnavailableException;
import com.questdb.cairo.pool.ex.PoolClosedException;
import com.questdb.cairo.sql.RecordCursor;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.CharSequenceObjHashMap;
import com.questdb.std.Chars;
import com.questdb.std.FilesFacade;
import com.questdb.std.IntList;
import com.questdb.std.LongList;
import com.questdb.std.ObjHashSet;
import com.questdb.std.ObjList;
import com.questdb.std.Rnd;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.StringSink;
import com.questdb.test.tools.TestUtils;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ReaderPoolTest
extends AbstractCairoTest {
    private static final Log LOG = LogFactory.getLog(ReaderPoolTest.class);

    @Before
    public void setUpInstance() {
        try (TableModel model = new TableModel(configuration, "u", 3).col("ts", 10);){
            CairoTestUtils.create(model);
        }
    }

    @Test
    public void testAllocateAndClear() throws Exception {
        this.assertWithPool(pool -> {
            int n = 2;
            CyclicBarrier barrier = new CyclicBarrier(n);
            CountDownLatch halt = new CountDownLatch(n);
            AtomicInteger errors = new AtomicInteger();
            AtomicInteger readerCount = new AtomicInteger();
            new Thread(() -> {
                try {
                    for (int i = 0; i < 1000; ++i) {
                        try (TableReader ignored = pool.get((CharSequence)"u");){
                            readerCount.incrementAndGet();
                        }
                        catch (EntryUnavailableException entryUnavailableException) {
                            // empty catch block
                        }
                        if (i == 1) {
                            barrier.await();
                        }
                        LockSupport.parkNanos(10L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    halt.countDown();
                }
            }).start();
            new Thread(() -> {
                try {
                    barrier.await();
                    for (int i = 0; i < 1000; ++i) {
                        pool.releaseInactive();
                        LockSupport.parkNanos(10L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    halt.countDown();
                }
            }).start();
            halt.await();
            Assert.assertTrue((readerCount.get() > 0 ? 1 : 0) != 0);
            Assert.assertEquals((long)0L, (long)errors.get());
        });
    }

    @Test
    public void testBasicCharSequence() throws Exception {
        try (TableModel model = new TableModel(configuration, "x", 3).col("ts", 10);){
            CairoTestUtils.create(model);
        }
        this.assertWithPool(pool -> {
            sink.clear();
            sink.put((CharSequence)"x");
            TableReader reader1 = pool.get((CharSequence)sink);
            Assert.assertNotNull((Object)reader1);
            reader1.close();
            sink.clear();
            sink.put((CharSequence)"y");
            try (TableReader reader2 = pool.get((CharSequence)"x");){
                Assert.assertSame((Object)reader1, (Object)reader2);
            }
        });
    }

    @Test
    public void testClosePoolWhenReaderIsOut() throws Exception {
        this.assertWithPool(pool -> {
            try (TableModel model = new TableModel(configuration, "x", 3).col("ts", 10);){
                CairoTestUtils.create(model);
            }
            var2_2 = null;
            try (TableReader reader = pool.get((CharSequence)"x");){
                Assert.assertNotNull((Object)reader);
                pool.close();
                Assert.assertTrue((boolean)reader.isOpen());
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
        });
    }

    @Test
    public void testCloseReaderWhenPoolClosed() throws Exception {
        this.assertWithPool(pool -> {
            TableReader reader = pool.get((CharSequence)"u");
            Assert.assertNotNull((Object)reader);
            pool.close();
            Assert.assertTrue((boolean)reader.isOpen());
            reader.close();
            reader.close();
        });
    }

    @Test
    public void testCloseWithActiveReader() throws Exception {
        this.assertWithPool(pool -> {
            TableReader reader = pool.get((CharSequence)"u");
            Assert.assertNotNull((Object)reader);
            pool.close();
            Assert.assertTrue((boolean)reader.isOpen());
            reader.close();
            Assert.assertFalse((boolean)reader.isOpen());
        });
    }

    @Test
    public void testCloseWithInactiveReader() throws Exception {
        this.assertWithPool(pool -> {
            TableReader reader = pool.get((CharSequence)"u");
            Assert.assertNotNull((Object)reader);
            reader.close();
            Assert.assertTrue((boolean)reader.isOpen());
            pool.close();
            Assert.assertFalse((boolean)reader.isOpen());
        });
    }

    @Test
    public void testConcurrentOpenAndClose() throws Exception {
        int readerCount = 5;
        int threadCount = 2;
        int iterations = 1000;
        String[] names = new String[5];
        for (int i = 0; i < 5; ++i) {
            names[i] = "x" + i;
            try (TableModel model = new TableModel(configuration, names[i], 3).col("ts", 10);){
                CairoTestUtils.create(model);
                continue;
            }
        }
        this.assertWithPool(pool -> {
            CyclicBarrier barrier = new CyclicBarrier(threadCount);
            CountDownLatch halt = new CountDownLatch(threadCount);
            AtomicInteger errors = new AtomicInteger();
            int i = 0;
            while (i < threadCount) {
                int x = i++;
                new Thread(() -> {
                    Rnd rnd = new Rnd((long)x, (long)(-x));
                    try {
                        barrier.await();
                        for (int i1 = 0; i1 < 1000; ++i1) {
                            String m = names[rnd.nextPositiveInt() % 5];
                            try (TableReader ignored = pool.get((CharSequence)m);){
                                LockSupport.parkNanos(100L);
                                continue;
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        errors.incrementAndGet();
                    }
                    finally {
                        halt.countDown();
                    }
                }).start();
            }
            halt.await();
            Assert.assertEquals((long)0L, (long)errors.get());
        });
    }

    @Test
    public void testConcurrentRead() throws Exception {
        int readerCount = 5;
        int threadCount = 2;
        int iterations = 1000000;
        Rnd dataRnd = new Rnd();
        final String[] names = new String[5];
        String[] expectedRows = new String[5];
        final CharSequenceObjHashMap expectedRowMap = new CharSequenceObjHashMap();
        for (int i = 0; i < 5; ++i) {
            names[i] = "x" + i;
            try (TableModel model = new TableModel(configuration, names[i], 3).col("ts", 10);){
                CairoTestUtils.create(model);
            }
            var10_10 = null;
            try (TableWriter w = new TableWriter(configuration, (CharSequence)names[i]);){
                for (int k = 0; k < 10; ++k) {
                    TableWriter.Row r = w.newRow(0L);
                    r.putDate(0, dataRnd.nextLong());
                    r.append();
                }
                w.commit();
            }
            catch (Throwable throwable) {
                var10_10 = throwable;
                throw throwable;
            }
            sink.clear();
            var10_10 = null;
            try (TableReader r = new TableReader(configuration, (CharSequence)names[i]);){
                printer.print((RecordCursor)r.getCursor(), r.getMetadata(), true);
            }
            catch (Throwable throwable) {
                var10_10 = throwable;
                throw throwable;
            }
            expectedRows[i] = sink.toString();
            expectedRowMap.put((CharSequence)names[i], (Object)expectedRows[i]);
        }
        this.assertWithPool(pool -> {
            final CyclicBarrier barrier = new CyclicBarrier(threadCount);
            final CountDownLatch halt = new CountDownLatch(threadCount);
            final AtomicInteger errors = new AtomicInteger();
            for (int k = 0; k < threadCount; ++k) {
                new Thread(new Runnable(){
                    final StringSink sink;
                    final RecordCursorPrinter printer;
                    final ObjHashSet readers = new ObjHashSet();
                    {
                        this.sink = new StringSink();
                        this.printer = new RecordCursorPrinter((CharSink)this.sink);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Rnd rnd = new Rnd();
                        try {
                            barrier.await();
                            for (int i = 0; i < 1000000; ++i) {
                                if (this.readers.size() == 0 || this.readers.size() < 40 && rnd.nextPositiveInt() % 4 == 0) {
                                    String name = names[rnd.nextPositiveInt() % 5];
                                    try {
                                        Assert.assertTrue((boolean)this.readers.add((Object)pool.get((CharSequence)name)));
                                    }
                                    catch (EntryUnavailableException entryUnavailableException) {
                                        // empty catch block
                                    }
                                }
                                Thread.yield();
                                if (this.readers.size() == 0) continue;
                                int index = rnd.nextPositiveInt() % this.readers.size();
                                TableReader reader = (TableReader)this.readers.get(index);
                                Assert.assertTrue((boolean)reader.isOpen());
                                this.sink.clear();
                                this.printer.print((RecordCursor)reader.getCursor(), reader.getMetadata(), true);
                                TestUtils.assertEquals((CharSequence)expectedRowMap.get(reader.getTableName()), (CharSequence)this.sink);
                                Thread.yield();
                                if (this.readers.size() > 0 && rnd.nextPositiveInt() % 4 == 0) {
                                    TableReader r2 = (TableReader)this.readers.get(rnd.nextPositiveInt() % this.readers.size());
                                    Assert.assertTrue((boolean)r2.isOpen());
                                    r2.close();
                                    Assert.assertTrue((boolean)this.readers.remove((Object)r2));
                                }
                                Thread.yield();
                            }
                        }
                        catch (Exception e) {
                            errors.incrementAndGet();
                            e.printStackTrace();
                        }
                        finally {
                            for (int i = 0; i < this.readers.size(); ++i) {
                                ((TableReader)this.readers.get(i)).close();
                            }
                            halt.countDown();
                        }
                    }
                }).start();
            }
            halt.await();
            Assert.assertEquals((long)0L, (long)halt.getCount());
            Assert.assertEquals((long)0L, (long)errors.get());
        });
    }

    @Test
    public void testDoubleLock() throws Exception {
        try (TableModel model = new TableModel(configuration, "xyz", 3).col("ts", 10);){
            CairoTestUtils.create(model);
        }
        this.assertWithPool(pool -> {
            Assert.assertTrue((boolean)pool.lock((CharSequence)"xyz"));
            Assert.assertTrue((boolean)pool.lock((CharSequence)"xyz"));
            try {
                pool.get((CharSequence)"xyz");
                Assert.fail();
            }
            catch (EntryLockedException entryLockedException) {
                // empty catch block
            }
            pool.unlock((CharSequence)"xyz");
            try (TableReader reader = pool.get((CharSequence)"xyz");){
                Assert.assertNotNull((Object)reader);
            }
        });
    }

    @Test
    public void testGetAndCloseRace() throws Exception {
        try (TableModel model = new TableModel(configuration, "xyz", 3).col("ts", 10);){
            CairoTestUtils.create(model);
        }
        for (int i = 0; i < 100; ++i) {
            this.assertWithPool(pool -> {
                AtomicInteger exceptionCount = new AtomicInteger();
                CyclicBarrier barrier = new CyclicBarrier(2);
                CountDownLatch stopLatch = new CountDownLatch(2);
                new Thread(() -> {
                    try {
                        barrier.await();
                        pool.close();
                    }
                    catch (Exception e) {
                        exceptionCount.incrementAndGet();
                        e.printStackTrace();
                    }
                    finally {
                        stopLatch.countDown();
                    }
                }).start();
                new Thread(() -> {
                    try {
                        barrier.await();
                        try (TableReader reader2 = pool.get((CharSequence)"xyz");){
                            Assert.assertNotNull((Object)reader2);
                        }
                        catch (PoolClosedException reader2) {
                            // empty catch block
                        }
                    }
                    catch (Exception e) {
                        exceptionCount.incrementAndGet();
                        e.printStackTrace();
                    }
                    finally {
                        stopLatch.countDown();
                    }
                }).start();
                Assert.assertTrue((boolean)stopLatch.await(2L, TimeUnit.SECONDS));
                Assert.assertEquals((long)0L, (long)exceptionCount.get());
            });
        }
    }

    @Test
    public void testGetMultipleReaders() throws Exception {
        this.assertWithPool(pool -> {
            int i;
            ObjHashSet readers = new ObjHashSet();
            for (i = 0; i < 64; ++i) {
                Assert.assertTrue((boolean)readers.add((Object)pool.get((CharSequence)"u")));
            }
            int n = readers.size();
            for (i = 0; i < n; ++i) {
                TableReader reader = (TableReader)readers.get(i);
                Assert.assertTrue((boolean)reader.isOpen());
                reader.close();
            }
        });
    }

    @Test
    public void testGetReaderFailure() throws Exception {
        int N = 3;
        int K = 40;
        final TestFilesFacade ff = new TestFilesFacade(){
            int count = 3;

            public long openRO(LPSZ name) {
                if (this.count-- > 0) {
                    return -1L;
                }
                return super.openRO(name);
            }

            @Override
            public boolean wasCalled() {
                return this.count < 3;
            }
        };
        this.assertWithPool(pool -> {
            int i;
            for (int i2 = 0; i2 < 3; ++i2) {
                try {
                    pool.get((CharSequence)"u");
                    Assert.fail();
                }
                catch (CairoException cairoException) {
                    // empty catch block
                }
                Assert.assertEquals((long)0L, (long)pool.getBusyCount());
            }
            ObjHashSet readers = new ObjHashSet();
            for (i = 0; i < 40; ++i) {
                Assert.assertTrue((boolean)readers.add((Object)pool.get((CharSequence)"u")));
            }
            Assert.assertEquals((long)40L, (long)pool.getBusyCount());
            Assert.assertEquals((long)40L, (long)readers.size());
            for (i = 0; i < 40; ++i) {
                TableReader reader = (TableReader)readers.get(i);
                Assert.assertTrue((boolean)reader.isOpen());
                reader.close();
            }
        }, (CairoConfiguration)new DefaultCairoConfiguration(root){

            public FilesFacade getFilesFacade() {
                return ff;
            }
        });
        Assert.assertTrue((boolean)ff.wasCalled());
    }

    @Test
    public void testGetReaderWhenPoolClosed() throws Exception {
        this.assertWithPool(pool -> {
            pool.close();
            try {
                pool.get((CharSequence)"u");
                Assert.fail();
            }
            catch (PoolClosedException poolClosedException) {
                // empty catch block
            }
        });
    }

    @Test
    public void testGetReadersBeforeFailure() throws Exception {
        this.assertWithPool(pool -> {
            ObjList readers = new ObjList();
            try {
                try {
                    while (true) {
                        readers.add((Object)pool.get((CharSequence)"u"));
                    }
                }
                catch (EntryUnavailableException e) {
                    Assert.assertEquals((long)pool.getMaxEntries(), (long)readers.size());
                    int n = readers.size();
                    for (int i = 0; i < n; ++i) {
                        ((TableReader)readers.getQuick(i)).close();
                    }
                }
            }
            catch (Throwable throwable) {
                int n = readers.size();
                for (int i = 0; i < n; ++i) {
                    ((TableReader)readers.getQuick(i)).close();
                }
                throw throwable;
            }
        });
    }

    @Test
    public void testLockBusyReader() throws Exception {
        int readerCount = 5;
        int threadCount = 2;
        int iterations = 10000;
        Rnd dataRnd = new Rnd();
        StringSink sink = new StringSink();
        RecordCursorPrinter printer = new RecordCursorPrinter((CharSink)sink);
        String[] names = new String[5];
        String[] expectedRows = new String[5];
        for (int i = 0; i < 5; ++i) {
            names[i] = "x" + i;
            try (TableModel model = new TableModel(configuration, names[i], 3).col("ts", 10);){
                CairoTestUtils.create(model);
            }
            var11_11 = null;
            try (TableWriter w = new TableWriter(configuration, (CharSequence)names[i]);){
                for (int k = 0; k < 10; ++k) {
                    TableWriter.Row r = w.newRow(0L);
                    r.putDate(0, dataRnd.nextLong());
                    r.append();
                }
                w.commit();
            }
            catch (Throwable throwable) {
                var11_11 = throwable;
                throw throwable;
            }
            sink.clear();
            var11_11 = null;
            try (TableReader r = new TableReader(configuration, (CharSequence)names[i]);){
                printer.print((RecordCursor)r.getCursor(), r.getMetadata(), true);
            }
            catch (Throwable throwable) {
                var11_11 = throwable;
                throw throwable;
            }
            expectedRows[i] = sink.toString();
        }
        LOG.info().$((CharSequence)"testLockBusyReader BEGIN").$();
        this.assertWithPool(pool -> {
            CyclicBarrier barrier = new CyclicBarrier(threadCount);
            CountDownLatch halt = new CountDownLatch(threadCount);
            AtomicInteger errors = new AtomicInteger();
            LongList lockTimes = new LongList();
            LongList workerTimes = new LongList();
            new Thread(() -> {
                Rnd rnd = new Rnd();
                try {
                    barrier.await();
                    for (int i = 0; i < 10000; ++i) {
                        String name = names[rnd.nextPositiveInt() % 5];
                        while (!pool.lock((CharSequence)name)) {
                        }
                        lockTimes.add(System.currentTimeMillis());
                        LockSupport.parkNanos(10L);
                        pool.unlock((CharSequence)name);
                    }
                }
                catch (Exception e) {
                    errors.incrementAndGet();
                    e.printStackTrace();
                }
                finally {
                    halt.countDown();
                }
            }).start();
            new Thread(() -> {
                Rnd rnd = new Rnd();
                try {
                    workerTimes.add(System.currentTimeMillis());
                    for (int i = 0; i < 10000; ++i) {
                        int index = rnd.nextPositiveInt() % 5;
                        String name = names[index];
                        try (TableReader r2 = pool.get((CharSequence)name);){
                            sink.clear();
                            printer.print((RecordCursor)r2.getCursor(), r2.getMetadata(), true);
                            TestUtils.assertEquals((CharSequence)expectedRows[index], (CharSequence)sink);
                            if (name.equals(names[4]) && barrier.getNumberWaiting() > 0) {
                                barrier.await();
                            }
                            LockSupport.parkNanos(10L);
                            continue;
                        }
                        catch (EntryLockedException | EntryUnavailableException r2) {
                            continue;
                        }
                        catch (Exception e) {
                            errors.incrementAndGet();
                            e.printStackTrace();
                            break;
                        }
                    }
                    workerTimes.add(System.currentTimeMillis());
                }
                finally {
                    halt.countDown();
                }
            }).start();
            halt.await();
            Assert.assertEquals((long)0L, (long)halt.getCount());
            Assert.assertEquals((long)0L, (long)errors.get());
            int count = 0;
            Assert.assertEquals((long)2L, (long)workerTimes.size());
            long lo = workerTimes.get(0);
            long hi = workerTimes.get(1);
            Assert.assertTrue((lockTimes.size() > 0 ? 1 : 0) != 0);
            int n = lockTimes.size();
            for (int i = 0; i < n; ++i) {
                long t = lockTimes.getQuick(i);
                if (t <= lo || t >= hi) continue;
                ++count;
            }
            Assert.assertTrue((count > 0 ? 1 : 0) != 0);
            LOG.info().$((CharSequence)"testLockBusyReader END").$();
        });
    }

    @Test
    public void testLockMultipleReaders() throws Exception {
        this.assertWithPool(pool -> {
            int i;
            ObjHashSet readers = new ObjHashSet();
            for (i = 0; i < 64; ++i) {
                Assert.assertTrue((boolean)readers.add((Object)pool.get((CharSequence)"u")));
            }
            Assert.assertEquals((long)64L, (long)pool.getBusyCount());
            int n = readers.size();
            for (i = 0; i < n; ++i) {
                TableReader reader = (TableReader)readers.get(i);
                Assert.assertTrue((boolean)reader.isOpen());
                reader.close();
            }
            Assert.assertTrue((boolean)pool.lock((CharSequence)"u"));
            Assert.assertEquals((long)0L, (long)pool.getBusyCount());
            n = readers.size();
            for (i = 0; i < n; ++i) {
                Assert.assertFalse((boolean)((TableReader)readers.get(i)).isOpen());
            }
            pool.unlock((CharSequence)"u");
        });
    }

    @Test
    public void testLockRace() throws Exception {
        this.assertWithPool(pool -> {
            AtomicInteger successCount = new AtomicInteger();
            AtomicInteger failureCount = new AtomicInteger();
            AtomicInteger exceptionCount = new AtomicInteger();
            CyclicBarrier barrier = new CyclicBarrier(2);
            CountDownLatch stopLatch = new CountDownLatch(2);
            Runnable runnable = () -> {
                try {
                    barrier.await();
                    if (pool.lock((CharSequence)"xyz")) {
                        successCount.incrementAndGet();
                    } else {
                        failureCount.incrementAndGet();
                    }
                }
                catch (Exception e) {
                    exceptionCount.incrementAndGet();
                    e.printStackTrace();
                }
                finally {
                    stopLatch.countDown();
                }
            };
            new Thread(runnable).start();
            new Thread(runnable).start();
            Assert.assertTrue((boolean)stopLatch.await(2L, TimeUnit.SECONDS));
            Assert.assertEquals((long)0L, (long)exceptionCount.get());
            Assert.assertEquals((long)1L, (long)successCount.get());
            Assert.assertEquals((long)1L, (long)failureCount.get());
        });
    }

    @Test
    public void testLockRaceAgainstGet() throws Exception {
        this.assertWithPool(pool -> {
            try (TableModel model = new TableModel(configuration, "x", 3).col("ts", 10);){
                CairoTestUtils.create(model);
            }
            for (int k = 0; k < 10000; ++k) {
                int i;
                int n = 64;
                TableReader[] readers = new TableReader[n];
                try {
                    for (i = 0; i < n; ++i) {
                        readers[i] = pool.get((CharSequence)"x");
                        Assert.assertNotNull((Object)readers[i]);
                    }
                    CyclicBarrier barrier = new CyclicBarrier(2);
                    CountDownLatch latch = new CountDownLatch(1);
                    new Thread(() -> {
                        try {
                            barrier.await();
                            boolean locked = pool.lock((CharSequence)"x");
                            if (locked) {
                                pool.unlock((CharSequence)"x");
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        finally {
                            latch.countDown();
                        }
                    }).start();
                    barrier.await();
                    try {
                        pool.get((CharSequence)"x").close();
                    }
                    catch (EntryLockedException entryLockedException) {
                        // empty catch block
                    }
                    Assert.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
                    continue;
                }
                finally {
                    for (i = 0; i < n; ++i) {
                        readers[i].close();
                    }
                }
            }
        });
    }

    @Test
    public void testLockUnlock() throws Exception {
        try (TableModel model = new TableModel(configuration, "x", 3).col("ts", 10);){
            CairoTestUtils.create(model);
        }
        model = new TableModel(configuration, "y", 3).col("ts", 10);
        var2_2 = null;
        try {
            CairoTestUtils.create(model);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (model != null) {
                if (var2_2 != null) {
                    try {
                        model.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    model.close();
                }
            }
        }
        this.assertWithPool(pool -> {
            TableReader x = pool.get((CharSequence)"x");
            Assert.assertNotNull((Object)x);
            TableReader y = pool.get((CharSequence)"y");
            Assert.assertNotNull((Object)y);
            Assert.assertFalse((boolean)pool.lock((CharSequence)"x"));
            x.close();
            Assert.assertTrue((boolean)pool.lock((CharSequence)"x"));
            Assert.assertFalse((boolean)x.isOpen());
            try {
                Assert.assertNull((Object)pool.get((CharSequence)"x"));
            }
            catch (EntryLockedException entryLockedException) {
                // empty catch block
            }
            pool.unlock((CharSequence)"x");
            x = pool.get((CharSequence)"x");
            Assert.assertNotNull((Object)x);
            x.close();
            Assert.assertTrue((boolean)x.isOpen());
            Assert.assertTrue((boolean)y.isOpen());
            y.close();
            pool.close();
            Assert.assertFalse((boolean)y.isOpen());
            Assert.assertFalse((boolean)x.isOpen());
        });
    }

    @Test
    public void testLockUnlockMultiple() throws Exception {
        this.assertWithPool(pool -> {
            TableReader r1 = pool.get((CharSequence)"u");
            TableReader r2 = pool.get((CharSequence)"u");
            r1.close();
            Assert.assertFalse((boolean)pool.lock((CharSequence)"u"));
            r2.close();
            Assert.assertTrue((boolean)pool.lock((CharSequence)"u"));
            pool.unlock((CharSequence)"u");
        });
    }

    @Test
    public void testReaderDoubleClose() throws Exception {
        this.assertWithPool(pool -> {
            class Listener
            implements PoolListener {
                private final IntList events;
                private final ObjList names = new ObjList();

                Listener() {
                    this.events = new IntList();
                }

                public void onEvent(byte factoryType, long thread, CharSequence name, short event, short segment, short position) {
                    this.names.add((Object)(name == null ? "" : Chars.stringOf((CharSequence)name)));
                    this.events.add((int)event);
                }
            }
            Listener listener = new Listener();
            pool.setPoolListener((PoolListener)listener);
            TableReader reader = pool.get((CharSequence)"u");
            Assert.assertNotNull((Object)reader);
            Assert.assertTrue((boolean)reader.isOpen());
            Assert.assertEquals((long)1L, (long)pool.getBusyCount());
            reader.close();
            Assert.assertEquals((long)0L, (long)pool.getBusyCount());
            reader.close();
            reader = pool.get((CharSequence)"u");
            Assert.assertNotNull((Object)reader);
            Assert.assertTrue((boolean)reader.isOpen());
            reader.close();
            Assert.assertEquals((Object)"[10,1,11,1]", (Object)listener.events.toString());
        });
    }

    @Test
    public void testSerialOpenClose() throws Exception {
        this.assertWithPool(pool -> {
            TableReader firstReader = null;
            for (int i = 0; i < 1000; ++i) {
                try (TableReader reader = pool.get((CharSequence)"u");){
                    if (firstReader == null) {
                        firstReader = reader;
                    }
                    Assert.assertNotNull((Object)reader);
                    Assert.assertSame((Object)firstReader, (Object)reader);
                    continue;
                }
            }
        });
    }

    @Test
    public void testUnlockByAnotherThread() throws Exception {
        this.assertWithPool(pool -> {
            Assert.assertTrue((boolean)pool.lock((CharSequence)"x"));
            AtomicInteger errors = new AtomicInteger();
            CountDownLatch latch = new CountDownLatch(1);
            new Thread(() -> {
                try {
                    try {
                        pool.unlock((CharSequence)"x");
                        Assert.fail();
                    }
                    catch (CairoException e) {
                        TestUtils.assertContains(e.getMessage(), "Not lock owner");
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    latch.countDown();
                }
            }).start();
            Assert.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
            Assert.assertEquals((long)0L, (long)errors.get());
            try {
                pool.get((CharSequence)"x");
                Assert.fail();
            }
            catch (EntryLockedException entryLockedException) {
                // empty catch block
            }
            pool.unlock((CharSequence)"x");
        });
    }

    @Test
    public void testUnlockNonExisting() throws Exception {
        this.assertWithPool(pool -> {
            AtomicInteger counter = new AtomicInteger();
            pool.setPoolListener((factoryType, thread, name, event, segment, position) -> {
                if (event == 9) {
                    counter.incrementAndGet();
                }
            });
            pool.unlock((CharSequence)"xyz");
            Assert.assertEquals((long)1L, (long)counter.get());
        });
    }

    private void assertWithPool(PoolAwareCode code) throws Exception {
        this.assertWithPool(code, configuration);
    }

    private void assertWithPool(PoolAwareCode code, CairoConfiguration configuration) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (ReaderPool pool = new ReaderPool(configuration);){
                code.run(pool);
            }
        });
    }

    private static interface PoolAwareCode {
        public void run(ReaderPool var1) throws Exception;
    }
}

