/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo.map;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.ArrayColumnTypes;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.ColumnFilter;
import com.questdb.cairo.ColumnTypes;
import com.questdb.cairo.EntityColumnFilter;
import com.questdb.cairo.ListColumnFilter;
import com.questdb.cairo.SingleColumnType;
import com.questdb.cairo.SymbolAsIntTypes;
import com.questdb.cairo.SymbolMapReader;
import com.questdb.cairo.TableModel;
import com.questdb.cairo.TableReader;
import com.questdb.cairo.TableReaderRecordCursor;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.map.FastMap;
import com.questdb.cairo.map.MapKey;
import com.questdb.cairo.map.MapValue;
import com.questdb.cairo.map.RecordValueSink;
import com.questdb.cairo.map.RecordValueSinkFactory;
import com.questdb.cairo.sql.Record;
import com.questdb.std.BytecodeAssembler;
import com.questdb.std.Rnd;
import org.junit.Assert;
import org.junit.Test;

public class RecordValueSinkFactoryTest
extends AbstractCairoTest {
    @Test
    public void testAllSupportedTypes() {
        SingleColumnType keyTypes = new SingleColumnType(3);
        try (TableModel model = new TableModel(configuration, "all", 3).col("int", 3).col("short", 2).col("byte", 1).col("double", 6).col("float", 5).col("long", 4).col("sym", 8).symbolCapacity(64).col("bool", 0).col("date", 10).col("ts", 12);){
            CairoTestUtils.create(model);
        }
        int N = 1024;
        Rnd rnd = new Rnd();
        try (TableWriter writer = new TableWriter(configuration, (CharSequence)"all");){
            for (int i = 0; i < 1024; ++i) {
                TableWriter.Row row = writer.newRow(0L);
                row.putInt(0, rnd.nextInt());
                row.putShort(1, rnd.nextShort());
                row.putByte(2, rnd.nextByte());
                row.putDouble(3, rnd.nextDouble2());
                row.putFloat(4, rnd.nextFloat2());
                row.putLong(5, rnd.nextLong());
                row.putSym(6, rnd.nextChars(10));
                row.putBool(7, rnd.nextBoolean());
                row.putDate(8, rnd.nextLong());
                row.putTimestamp(9, rnd.nextLong());
                row.append();
            }
            writer.commit();
        }
        var5_9 = null;
        try (TableReader reader = new TableReader(configuration, (CharSequence)"all");){
            SymbolAsIntTypes valueTypes = new SymbolAsIntTypes().of((ColumnTypes)reader.getMetadata());
            try (FastMap map = new FastMap(0x100000, (ColumnTypes)keyTypes, (ColumnTypes)valueTypes, 1024, 0.5);){
                EntityColumnFilter columnFilter = new EntityColumnFilter();
                columnFilter.of(reader.getMetadata().getColumnCount());
                RecordValueSink sink = RecordValueSinkFactory.getInstance((BytecodeAssembler)new BytecodeAssembler(), (ColumnTypes)reader.getMetadata(), (ColumnFilter)columnFilter);
                TableReaderRecordCursor cursor = reader.getCursor();
                Record record = cursor.getRecord();
                int index = 0;
                while (cursor.hasNext()) {
                    MapKey key = map.withKey();
                    key.putInt(index++);
                    MapValue value = key.createValue();
                    sink.copy(record, value);
                }
                Assert.assertEquals((long)1024L, (long)index);
                rnd.reset();
                SymbolMapReader symbolTable = reader.getSymbolMapReader(6);
                for (int i = 0; i < 1024; ++i) {
                    MapKey key = map.withKey();
                    key.putInt(i);
                    MapValue value = key.findValue();
                    Assert.assertNotNull((Object)value);
                    Assert.assertEquals((long)rnd.nextInt(), (long)value.getInt(0));
                    Assert.assertEquals((long)rnd.nextShort(), (long)value.getShort(1));
                    Assert.assertEquals((long)rnd.nextByte(), (long)value.getByte(2));
                    Assert.assertEquals((double)rnd.nextDouble2(), (double)value.getDouble(3), (double)1.0E-6);
                    Assert.assertEquals((float)rnd.nextFloat2(), (float)value.getFloat(4), (float)1.0E-6f);
                    Assert.assertEquals((long)rnd.nextLong(), (long)value.getLong(5));
                    Assert.assertEquals((long)symbolTable.getQuick(rnd.nextChars(10)), (long)value.getInt(6));
                    Assert.assertEquals((Object)rnd.nextBoolean(), (Object)value.getBool(7));
                    Assert.assertEquals((long)rnd.nextLong(), (long)value.getDate(8));
                    Assert.assertEquals((long)rnd.nextLong(), (long)value.getTimestamp(9));
                }
            }
        }
        catch (Throwable throwable) {
            var5_9 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testSubset() {
        SingleColumnType keyTypes = new SingleColumnType(3);
        try (TableModel model = new TableModel(configuration, "all", 3).col("int", 3).col("short", 2).col("byte", 1).col("double", 6).col("float", 5).col("long", 4).col("sym", 8).symbolCapacity(64).col("bool", 0).col("date", 10).col("ts", 12);){
            CairoTestUtils.create(model);
        }
        int N = 1024;
        Rnd rnd = new Rnd();
        try (TableWriter writer = new TableWriter(configuration, (CharSequence)"all");){
            for (int i = 0; i < 1024; ++i) {
                TableWriter.Row row = writer.newRow(0L);
                row.putInt(0, rnd.nextInt());
                row.putShort(1, rnd.nextShort());
                row.putByte(2, rnd.nextByte());
                row.putDouble(3, rnd.nextDouble2());
                row.putFloat(4, rnd.nextFloat2());
                row.putLong(5, rnd.nextLong());
                row.putSym(6, rnd.nextChars(10));
                row.putBool(7, rnd.nextBoolean());
                row.putDate(8, rnd.nextLong());
                row.putTimestamp(9, rnd.nextLong());
                row.append();
            }
            writer.commit();
        }
        var5_9 = null;
        try (TableReader reader = new TableReader(configuration, (CharSequence)"all");){
            ArrayColumnTypes valueTypes = new ArrayColumnTypes();
            valueTypes.add(0);
            valueTypes.add(12);
            valueTypes.add(3);
            try (FastMap map = new FastMap(0x100000, (ColumnTypes)keyTypes, (ColumnTypes)valueTypes, 1024, 0.5);){
                ListColumnFilter columnFilter = new ListColumnFilter();
                columnFilter.add(7);
                columnFilter.add(9);
                columnFilter.add(6);
                RecordValueSink sink = RecordValueSinkFactory.getInstance((BytecodeAssembler)new BytecodeAssembler(), (ColumnTypes)reader.getMetadata(), (ColumnFilter)columnFilter);
                TableReaderRecordCursor cursor = reader.getCursor();
                Record record = cursor.getRecord();
                int index = 0;
                while (cursor.hasNext()) {
                    MapKey key = map.withKey();
                    key.putInt(index++);
                    MapValue value = key.createValue();
                    sink.copy(record, value);
                }
                Assert.assertEquals((long)1024L, (long)index);
                rnd.reset();
                SymbolMapReader symbolTable = reader.getSymbolMapReader(6);
                for (int i = 0; i < 1024; ++i) {
                    MapKey key = map.withKey();
                    key.putInt(i);
                    MapValue value = key.findValue();
                    Assert.assertNotNull((Object)value);
                    rnd.nextInt();
                    rnd.nextShort();
                    rnd.nextByte();
                    rnd.nextDouble2();
                    rnd.nextFloat2();
                    rnd.nextLong();
                    Assert.assertEquals((long)symbolTable.getQuick(rnd.nextChars(10)), (long)value.getInt(2));
                    Assert.assertEquals((Object)rnd.nextBoolean(), (Object)value.getBool(0));
                    rnd.nextLong();
                    Assert.assertEquals((long)rnd.nextLong(), (long)value.getTimestamp(1));
                }
            }
        }
        catch (Throwable throwable) {
            var5_9 = throwable;
            throw throwable;
        }
    }
}

