/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo.map;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.ArrayColumnTypes;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.ColumnFilter;
import com.questdb.cairo.ColumnTypes;
import com.questdb.cairo.EntityColumnFilter;
import com.questdb.cairo.ListColumnFilter;
import com.questdb.cairo.RecordSink;
import com.questdb.cairo.RecordSinkFactory;
import com.questdb.cairo.SingleColumnType;
import com.questdb.cairo.SymbolAsIntTypes;
import com.questdb.cairo.SymbolAsStrTypes;
import com.questdb.cairo.TableModel;
import com.questdb.cairo.TableReader;
import com.questdb.cairo.TableReaderRecordCursor;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.TestRecord;
import com.questdb.cairo.map.CompactMap;
import com.questdb.cairo.map.FastMap;
import com.questdb.cairo.map.MapKey;
import com.questdb.cairo.map.MapRecord;
import com.questdb.cairo.map.MapValue;
import com.questdb.cairo.sql.Record;
import com.questdb.cairo.sql.RecordCursor;
import com.questdb.std.BinarySequence;
import com.questdb.std.BytecodeAssembler;
import com.questdb.std.Chars;
import com.questdb.std.LongList;
import com.questdb.std.ObjList;
import com.questdb.std.Rnd;
import com.questdb.std.str.CharSink;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class FastMapTest
extends AbstractCairoTest {
    @Test
    public void testAllTypes() {
        Rnd rnd = new Rnd();
        ArrayColumnTypes keyTypes = new ArrayColumnTypes();
        ArrayColumnTypes valueTypes = new ArrayColumnTypes();
        keyTypes.add(1);
        keyTypes.add(2);
        keyTypes.add(3);
        keyTypes.add(4);
        keyTypes.add(5);
        keyTypes.add(6);
        keyTypes.add(7);
        keyTypes.add(0);
        keyTypes.add(10);
        valueTypes.add(1);
        valueTypes.add(2);
        valueTypes.add(3);
        valueTypes.add(4);
        valueTypes.add(5);
        valueTypes.add(6);
        valueTypes.add(0);
        valueTypes.add(10);
        try (FastMap map = new FastMap(64, (ColumnTypes)keyTypes, (ColumnTypes)valueTypes, 64, 0.8);){
            MapValue value;
            MapKey key;
            int i;
            int N = 100000;
            for (i = 0; i < 100000; ++i) {
                key = map.withKey();
                key.putByte(rnd.nextByte());
                key.putShort(rnd.nextShort());
                key.putInt(rnd.nextInt());
                key.putLong(rnd.nextLong());
                key.putFloat(rnd.nextFloat2());
                key.putDouble(rnd.nextDouble2());
                if (rnd.nextPositiveInt() % 4 == 0) {
                    key.putStr(null);
                } else {
                    key.putStr(rnd.nextChars(rnd.nextPositiveInt() % 16));
                }
                key.putBool(rnd.nextBoolean());
                key.putDate(rnd.nextLong());
                value = key.createValue();
                Assert.assertTrue((boolean)value.isNew());
                value.putByte(0, rnd.nextByte());
                value.putShort(1, rnd.nextShort());
                value.putInt(2, rnd.nextInt());
                value.putLong(3, rnd.nextLong());
                value.putFloat(4, rnd.nextFloat2());
                value.putDouble(5, rnd.nextDouble2());
                value.putBool(6, rnd.nextBoolean());
                value.putDate(7, rnd.nextLong());
            }
            rnd.reset();
            for (i = 0; i < 100000; ++i) {
                key = map.withKey();
                key.putByte(rnd.nextByte());
                key.putShort(rnd.nextShort());
                key.putInt(rnd.nextInt());
                key.putLong(rnd.nextLong());
                key.putFloat(rnd.nextFloat2());
                key.putDouble(rnd.nextDouble2());
                if (rnd.nextPositiveInt() % 4 == 0) {
                    key.putStr(null);
                } else {
                    key.putStr(rnd.nextChars(rnd.nextPositiveInt() % 16));
                }
                key.putBool(rnd.nextBoolean());
                key.putDate(rnd.nextLong());
                value = key.createValue();
                Assert.assertFalse((boolean)value.isNew());
                Assert.assertEquals((long)rnd.nextByte(), (long)value.getByte(0));
                Assert.assertEquals((long)rnd.nextShort(), (long)value.getShort(1));
                Assert.assertEquals((long)rnd.nextInt(), (long)value.getInt(2));
                Assert.assertEquals((long)rnd.nextLong(), (long)value.getLong(3));
                Assert.assertEquals((float)rnd.nextFloat2(), (float)value.getFloat(4), (float)1.0E-9f);
                Assert.assertEquals((double)rnd.nextDouble2(), (double)value.getDouble(5), (double)1.0E-9);
                Assert.assertEquals((Object)rnd.nextBoolean(), (Object)value.getBool(6));
                Assert.assertEquals((long)rnd.nextLong(), (long)value.getDate(7));
            }
            try (RecordCursor cursor = map.getCursor();){
                rnd.reset();
                this.assertCursor1(rnd, cursor);
                rnd.reset();
                cursor.toTop();
                this.assertCursor1(rnd, cursor);
            }
        }
    }

    @Test
    public void testAppendExisting() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            Rnd rnd = new Rnd();
            int N = 10;
            try (FastMap map = new FastMap(0x100000, (ColumnTypes)new SingleColumnType(7), (ColumnTypes)new SingleColumnType(4), N / 2, 0.5);){
                MapKey key;
                int i;
                ObjList keys = new ObjList();
                for (i = 0; i < N; ++i) {
                    CharSequence s = rnd.nextChars(11);
                    keys.add((Object)s.toString());
                    key = map.withKey();
                    key.putStr(s);
                    MapValue value = key.createValue();
                    Assert.assertTrue((boolean)value.isNew());
                    value.putLong(0, (long)(i + 1));
                }
                Assert.assertEquals((long)N, (long)map.size());
                int n = keys.size();
                for (i = 0; i < n; ++i) {
                    key = map.withKey();
                    CharSequence s = (CharSequence)keys.getQuick(i);
                    key.putStr(s);
                    MapValue value = key.createValue();
                    Assert.assertFalse((boolean)value.isNew());
                    Assert.assertEquals((long)(i + 1), (long)value.getLong(0));
                }
            }
        });
    }

    @Test
    public void testAppendUnique() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            Rnd rnd = new Rnd();
            int N = 100000;
            int M = 25;
            try (FastMap map = new FastMap(0x100000, (ColumnTypes)new SingleColumnType(7), (ColumnTypes)new SingleColumnType(4), N / 4, 0.5);){
                for (int i = 0; i < N; ++i) {
                    CharSequence s = rnd.nextChars(M);
                    MapKey key = map.withKey();
                    key.putStr(s);
                    MapValue value = key.createValue();
                    value.putLong(0, (long)(i + 1));
                }
                Assert.assertEquals((long)N, (long)map.size());
                long expectedAppendOffset = map.getAppendOffset();
                rnd.reset();
                for (int i = 0; i < N; ++i) {
                    CharSequence s = rnd.nextChars(M);
                    MapKey key = map.withKey();
                    key.putStr(s);
                    MapValue value = key.findValue();
                    Assert.assertNotNull((Object)value);
                    Assert.assertEquals((long)(i + 1), (long)value.getLong(0));
                }
                Assert.assertEquals((long)N, (long)map.size());
                Assert.assertEquals((long)expectedAppendOffset, (long)map.getAppendOffset());
            }
        });
    }

    @Test
    public void testConstructorRecovery() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            TestRecord.ArrayBinarySequence binarySequence = new TestRecord.ArrayBinarySequence();
            this.createTestTable(10, new Rnd(), binarySequence);
            try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                try {
                    new CompactMap(1024, (ColumnTypes)reader.getMetadata(), (ColumnTypes)new SingleColumnType(4), 16L, 0.75);
                    Assert.fail();
                }
                catch (Exception e) {
                    TestUtils.assertContains(e.getMessage(), "Unsupported column type");
                }
            }
        });
    }

    @Test
    public void testDuplicateValues() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            Rnd rnd = new Rnd();
            int N = 100;
            SingleColumnType types = new SingleColumnType(3);
            FastMap.HashFunction hash = (address, len) -> 0;
            try (FastMap map = new FastMap(1024, (ColumnTypes)types, (ColumnTypes)types, N / 4, 0.5, hash);){
                MapKey key = map.withKey();
                key.putInt(10);
                Assert.assertTrue((boolean)key.notFound());
                this.assertDupes(map, rnd, N);
                map.clear();
                this.assertDupes(map, rnd, N);
            }
        });
    }

    @Test
    public void testLargeBinSequence() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            SingleColumnType keyTypes = new SingleColumnType(9);
            SingleColumnType valueTypes = new SingleColumnType(3);
            TestRecord.ArrayBinarySequence binarySequence = new TestRecord.ArrayBinarySequence();
            try (FastMap map = new FastMap(0x100000, (ColumnTypes)keyTypes, (ColumnTypes)valueTypes, 64, 0.5);){
                Rnd rnd = new Rnd();
                MapKey key = map.withKey();
                key.putBin((BinarySequence)binarySequence.of(rnd.nextBytes(10)));
                MapValue value = key.createValue();
                value.putInt(0, rnd.nextInt());
                BinarySequence bad = new BinarySequence(){

                    public byte byteAt(long index) {
                        return 0;
                    }

                    public long length() {
                        return 0x80000000L;
                    }
                };
                try {
                    map.withKey().putBin(bad);
                    Assert.fail();
                }
                catch (CairoException e) {
                    TestUtils.assertContains(e.getMessage(), "binary column is too large");
                }
                key = map.withKey();
                key.putBin((BinarySequence)binarySequence.of(rnd.nextBytes(20)));
                value = key.createValue();
                value.putInt(0, rnd.nextInt());
                Assert.assertEquals((long)2L, (long)map.size());
                rnd.reset();
                key = map.withKey();
                key.putBin((BinarySequence)binarySequence.of(rnd.nextBytes(10)));
                Assert.assertEquals((long)rnd.nextInt(), (long)key.findValue().getInt(0));
                key = map.withKey();
                key.putBin((BinarySequence)binarySequence.of(rnd.nextBytes(20)));
                Assert.assertEquals((long)rnd.nextInt(), (long)key.findValue().getInt(0));
            }
        });
    }

    @Test
    public void testMemoryStretch() throws Exception {
        if (System.getProperty("questdb.enable_heavy_tests") != null) {
            TestUtils.assertMemoryLeak(() -> {
                ArrayColumnTypes keyTypes = new ArrayColumnTypes();
                SingleColumnType valueTypes = new SingleColumnType(4);
                int N = 1500000;
                for (int i = 0; i < N; ++i) {
                    keyTypes.add(7);
                }
                Rnd rnd = new Rnd();
                try (FastMap map = new FastMap(0x100000, (ColumnTypes)keyTypes, (ColumnTypes)valueTypes, 1024, 0.5);){
                    try {
                        MapKey key = map.withKey();
                        for (int i = 0; i < N; ++i) {
                            key.putStr(rnd.nextChars(1024));
                        }
                        key.createValue();
                        Assert.fail();
                    }
                    catch (CairoException e) {
                        TestUtils.assertContains(e.getMessage(), "row data is too large");
                    }
                }
            });
        }
    }

    @Test
    public void testNoValueColumns() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            SingleColumnType keyTypes = new SingleColumnType();
            Rnd rnd = new Rnd();
            int N = 100;
            try (FastMap map = new FastMap(0x200000, keyTypes.of(3), 128, (double)0.7f);){
                MapKey key;
                int i;
                for (i = 0; i < 100; ++i) {
                    key = map.withKey();
                    key.putInt(rnd.nextInt());
                    Assert.assertTrue((boolean)key.create());
                }
                Assert.assertEquals((long)100L, (long)map.size());
                rnd.reset();
                for (i = 0; i < 100; ++i) {
                    key = map.withKey();
                    key.putInt(rnd.nextInt());
                    Assert.assertFalse((boolean)key.notFound());
                }
                Assert.assertEquals((long)100L, (long)map.size());
            }
        });
    }

    @Test
    public void testRecordAsKey() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 5000;
            Rnd rnd = new Rnd();
            TestRecord.ArrayBinarySequence binarySequence = new TestRecord.ArrayBinarySequence();
            this.createTestTable(5000, rnd, binarySequence);
            BytecodeAssembler asm = new BytecodeAssembler();
            try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                EntityColumnFilter entityColumnFilter = new EntityColumnFilter();
                entityColumnFilter.of(reader.getMetadata().getColumnCount());
                try (FastMap map = new FastMap(0x100000, (ColumnTypes)new SymbolAsStrTypes((ColumnTypes)reader.getMetadata()), (ColumnTypes)new ArrayColumnTypes().reset().add(4).add(3).add(2).add(1).add(5).add(6).add(10).add(12).add(0), 5000, (double)0.9f);){
                    RecordSink sink = RecordSinkFactory.getInstance((BytecodeAssembler)asm, (ColumnTypes)reader.getMetadata(), (ColumnFilter)entityColumnFilter, (boolean)true);
                    int keyColumnOffset = map.getValueColumnCount();
                    Rnd rnd2 = new Rnd();
                    TableReaderRecordCursor cursor = reader.getCursor();
                    this.populateMap(map, rnd2, (RecordCursor)cursor, sink);
                    try (RecordCursor mapCursor = map.getCursor();){
                        this.assertCursor2(rnd, binarySequence, keyColumnOffset, rnd2, mapCursor);
                        mapCursor.toTop();
                        this.assertCursor2(rnd, binarySequence, keyColumnOffset, rnd2, mapCursor);
                    }
                }
            }
        });
    }

    @Test
    public void testRowIdAccess() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            SingleColumnType types = new SingleColumnType(3);
            int N = 10000;
            Rnd rnd = new Rnd();
            try (FastMap map = new FastMap(0x100000, (ColumnTypes)types, (ColumnTypes)types, 64, 0.5);){
                for (int i = 0; i < 10000; ++i) {
                    MapKey key = map.withKey();
                    key.putInt(rnd.nextInt());
                    MapValue values = key.createValue();
                    Assert.assertTrue((boolean)values.isNew());
                    values.putInt(0, i + 1);
                }
                rnd.reset();
                LongList list = new LongList();
                try (RecordCursor cursor = map.getCursor();){
                    MapRecord record = (MapRecord)cursor.getRecord();
                    while (cursor.hasNext()) {
                        list.add(record.getRowId());
                        Assert.assertEquals((long)rnd.nextInt(), (long)record.getInt(1));
                        MapValue value = record.getValue();
                        value.putInt(0, value.getInt(0) * 2);
                    }
                    rnd.reset();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        cursor.recordAt(list.getQuick(i));
                        Assert.assertEquals((long)((i + 1) * 2), (long)record.getInt(0));
                        Assert.assertEquals((long)rnd.nextInt(), (long)record.getInt(1));
                    }
                    MapRecord rec = (MapRecord)cursor.newRecord();
                    Assert.assertNotSame((Object)rec, (Object)record);
                    rnd.reset();
                    int n2 = list.size();
                    for (int i = 0; i < n2; ++i) {
                        cursor.recordAt((Record)rec, list.getQuick(i));
                        Assert.assertEquals((long)((i + 1) * 2), (long)rec.getInt(0));
                        Assert.assertEquals((long)rnd.nextInt(), (long)rec.getInt(1));
                    }
                }
            }
        });
    }

    @Test
    public void testRowIdStore() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 10000;
            Rnd rnd = new Rnd();
            TestRecord.ArrayBinarySequence binarySequence = new TestRecord.ArrayBinarySequence();
            this.createTestTable(10000, rnd, binarySequence);
            SingleColumnType types = new SingleColumnType(4);
            try (FastMap map = new FastMap(1024, (ColumnTypes)types, (ColumnTypes)types, 2500, 0.5);){
                try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                    MapValue values;
                    MapKey key;
                    TableReaderRecordCursor cursor = reader.getCursor();
                    Record record = cursor.getRecord();
                    long counter = 0L;
                    while (cursor.hasNext()) {
                        key = map.withKeyAsLong(record.getRowId());
                        values = key.createValue();
                        Assert.assertTrue((boolean)values.isNew());
                        values.putLong(0, ++counter);
                    }
                    cursor.toTop();
                    counter = 0L;
                    while (cursor.hasNext()) {
                        key = map.withKeyAsLong(record.getRowId());
                        values = key.findValue();
                        Assert.assertNotNull((Object)values);
                        Assert.assertEquals((long)(++counter), (long)values.getLong(0));
                    }
                }
                Assert.assertEquals((long)10000L, (long)map.size());
            }
        });
    }

    @Test
    public void testUnsupportedKeyValueBinary() throws Exception {
        this.testUnsupportedValueType(9);
    }

    @Test
    public void testValueAccess() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "x", 3);){
                model.col("a", 1).col("b", 2).col("c", 3).col("d", 4).col("e", 10).col("f", 12).col("g", 5).col("h", 6).col("i", 7).col("j", 8).col("k", 0).col("l", 9);
                CairoTestUtils.create(model);
            }
            int N = 1000;
            Rnd rnd = new Rnd();
            TestRecord.ArrayBinarySequence binarySequence = new TestRecord.ArrayBinarySequence();
            this.createTestTable(1000, rnd, binarySequence);
            BytecodeAssembler asm = new BytecodeAssembler();
            try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                EntityColumnFilter entityColumnFilter = new EntityColumnFilter();
                entityColumnFilter.of(reader.getMetadata().getColumnCount());
                try (FastMap map = new FastMap(0x100000, (ColumnTypes)new SymbolAsStrTypes((ColumnTypes)reader.getMetadata()), (ColumnTypes)new ArrayColumnTypes().reset().add(4).add(3).add(2).add(1).add(5).add(6).add(10).add(12).add(0), 1000, (double)0.9f);){
                    RecordSink sink = RecordSinkFactory.getInstance((BytecodeAssembler)asm, (ColumnTypes)reader.getMetadata(), (ColumnFilter)entityColumnFilter, (boolean)true);
                    Rnd rnd2 = new Rnd();
                    TableReaderRecordCursor cursor = reader.getCursor();
                    Record record = cursor.getRecord();
                    this.populateMap(map, rnd2, (RecordCursor)cursor, sink);
                    cursor.toTop();
                    rnd2.reset();
                    long c = 0L;
                    while (cursor.hasNext()) {
                        MapKey key = map.withKey();
                        key.put(record, sink);
                        MapValue value = key.findValue();
                        Assert.assertNotNull((Object)value);
                        Assert.assertEquals((long)(++c), (long)value.getLong(0));
                        Assert.assertEquals((long)rnd2.nextInt(), (long)value.getInt(1));
                        Assert.assertEquals((long)rnd2.nextShort(), (long)value.getShort(2));
                        Assert.assertEquals((long)rnd2.nextByte(), (long)value.getByte(3));
                        Assert.assertEquals((float)rnd2.nextFloat2(), (float)value.getFloat(4), (float)1.0E-6f);
                        Assert.assertEquals((double)rnd2.nextDouble2(), (double)value.getDouble(5), (double)1.0E-9);
                        Assert.assertEquals((long)rnd2.nextLong(), (long)value.getDate(6));
                        Assert.assertEquals((long)rnd2.nextLong(), (long)value.getTimestamp(7));
                        Assert.assertEquals((Object)rnd2.nextBoolean(), (Object)value.getBool(8));
                    }
                }
            }
        });
    }

    @Test
    public void testValueRandomWrite() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 10000;
            Rnd rnd = new Rnd();
            TestRecord.ArrayBinarySequence binarySequence = new TestRecord.ArrayBinarySequence();
            this.createTestTable(10000, rnd, binarySequence);
            BytecodeAssembler asm = new BytecodeAssembler();
            try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                ListColumnFilter listColumnFilter = new ListColumnFilter();
                int n = reader.getMetadata().getColumnCount();
                for (int i = 0; i < n; ++i) {
                    listColumnFilter.add(i);
                }
                try (FastMap map = new FastMap(0x100000, (ColumnTypes)new SymbolAsIntTypes().of((ColumnTypes)reader.getMetadata()), (ColumnTypes)new ArrayColumnTypes().reset().add(4).add(3).add(2).add(1).add(5).add(6).add(10).add(12).add(0), 10000, (double)0.9f);){
                    RecordSink sink = RecordSinkFactory.getInstance((BytecodeAssembler)asm, (ColumnTypes)reader.getMetadata(), (ColumnFilter)listColumnFilter, (boolean)false);
                    Rnd rnd2 = new Rnd();
                    TableReaderRecordCursor cursor = reader.getCursor();
                    Record record = cursor.getRecord();
                    long counter = 0L;
                    while (cursor.hasNext()) {
                        MapKey key = map.withKey();
                        key.put(record, sink);
                        MapValue value = key.createValue();
                        Assert.assertTrue((boolean)value.isNew());
                        value.putFloat(4, rnd2.nextFloat2());
                        value.putDouble(5, rnd2.nextDouble2());
                        value.putDate(6, rnd2.nextLong());
                        value.putTimestamp(7, rnd2.nextLong());
                        value.putBool(8, rnd2.nextBoolean());
                        value.putLong(0, ++counter);
                        value.putInt(1, rnd2.nextInt());
                        value.putShort(2, rnd2.nextShort());
                        value.putByte(3, rnd2.nextByte());
                    }
                    cursor.toTop();
                    rnd2.reset();
                    long c = 0L;
                    while (cursor.hasNext()) {
                        MapKey key = map.withKey();
                        key.put(record, sink);
                        MapValue value = key.findValue();
                        Assert.assertNotNull((Object)value);
                        Assert.assertEquals((float)rnd2.nextFloat2(), (float)value.getFloat(4), (float)1.0E-6f);
                        Assert.assertEquals((double)rnd2.nextDouble2(), (double)value.getDouble(5), (double)1.0E-9);
                        Assert.assertEquals((long)rnd2.nextLong(), (long)value.getDate(6));
                        Assert.assertEquals((long)rnd2.nextLong(), (long)value.getTimestamp(7));
                        Assert.assertEquals((Object)rnd2.nextBoolean(), (Object)value.getBool(8));
                        Assert.assertEquals((long)(++c), (long)value.getLong(0));
                        Assert.assertEquals((long)rnd2.nextInt(), (long)value.getInt(1));
                        Assert.assertEquals((long)rnd2.nextShort(), (long)value.getShort(2));
                        Assert.assertEquals((long)rnd2.nextByte(), (long)value.getByte(3));
                    }
                }
            }
        });
    }

    private void assertCursor1(Rnd rnd, RecordCursor cursor) {
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            Assert.assertEquals((long)rnd.nextByte(), (long)record.getByte(8));
            Assert.assertEquals((long)rnd.nextShort(), (long)record.getShort(9));
            Assert.assertEquals((long)rnd.nextInt(), (long)record.getInt(10));
            Assert.assertEquals((long)rnd.nextLong(), (long)record.getLong(11));
            Assert.assertEquals((float)rnd.nextFloat2(), (float)record.getFloat(12), (float)1.0E-9f);
            Assert.assertEquals((double)rnd.nextDouble2(), (double)record.getDouble(13), (double)1.0E-9);
            if (rnd.nextPositiveInt() % 4 == 0) {
                Assert.assertNull((Object)record.getStr(14));
                Assert.assertEquals((long)-1L, (long)record.getStrLen(14));
            } else {
                CharSequence expected = rnd.nextChars(rnd.nextPositiveInt() % 16);
                TestUtils.assertEquals(expected, record.getStr(14));
            }
            Assert.assertEquals((Object)rnd.nextBoolean(), (Object)record.getBool(15));
            Assert.assertEquals((long)rnd.nextLong(), (long)record.getDate(16));
            Assert.assertEquals((long)rnd.nextByte(), (long)record.getByte(0));
            Assert.assertEquals((long)rnd.nextShort(), (long)record.getShort(1));
            Assert.assertEquals((long)rnd.nextInt(), (long)record.getInt(2));
            Assert.assertEquals((long)rnd.nextLong(), (long)record.getLong(3));
            Assert.assertEquals((float)rnd.nextFloat2(), (float)record.getFloat(4), (float)1.0E-9f);
            Assert.assertEquals((double)rnd.nextDouble2(), (double)record.getDouble(5), (double)1.0E-9);
            Assert.assertEquals((Object)rnd.nextBoolean(), (Object)record.getBool(6));
            Assert.assertEquals((long)rnd.nextLong(), (long)record.getDate(7));
        }
    }

    private void assertCursor2(Rnd rnd, TestRecord.ArrayBinarySequence binarySequence, int keyColumnOffset, Rnd rnd2, RecordCursor mapCursor) {
        long c = 0L;
        rnd.reset();
        rnd2.reset();
        Record record = mapCursor.getRecord();
        while (mapCursor.hasNext()) {
            Assert.assertEquals((long)(++c), (long)record.getLong(0));
            Assert.assertEquals((long)rnd2.nextInt(), (long)record.getInt(1));
            Assert.assertEquals((long)rnd2.nextShort(), (long)record.getShort(2));
            Assert.assertEquals((long)rnd2.nextByte(), (long)record.getByte(3));
            Assert.assertEquals((float)rnd2.nextFloat2(), (float)record.getFloat(4), (float)1.0E-6f);
            Assert.assertEquals((double)rnd2.nextDouble2(), (double)record.getDouble(5), (double)1.0E-9);
            Assert.assertEquals((long)rnd2.nextLong(), (long)record.getDate(6));
            Assert.assertEquals((long)rnd2.nextLong(), (long)record.getTimestamp(7));
            Assert.assertEquals((Object)rnd2.nextBoolean(), (Object)record.getBool(8));
            Assert.assertEquals((long)rnd.nextByte(), (long)record.getByte(keyColumnOffset));
            Assert.assertEquals((long)rnd.nextShort(), (long)record.getShort(keyColumnOffset + 1));
            if (rnd.nextInt() % 4 == 0) {
                Assert.assertEquals((long)Integer.MIN_VALUE, (long)record.getInt(keyColumnOffset + 2));
            } else {
                Assert.assertEquals((long)rnd.nextInt(), (long)record.getInt(keyColumnOffset + 2));
            }
            if (rnd.nextInt() % 4 == 0) {
                Assert.assertEquals((long)Long.MIN_VALUE, (long)record.getLong(keyColumnOffset + 3));
            } else {
                Assert.assertEquals((long)rnd.nextLong(), (long)record.getLong(keyColumnOffset + 3));
            }
            if (rnd.nextInt() % 4 == 0) {
                Assert.assertEquals((long)Long.MIN_VALUE, (long)record.getDate(keyColumnOffset + 4));
            } else {
                Assert.assertEquals((long)rnd.nextLong(), (long)record.getDate(keyColumnOffset + 4));
            }
            if (rnd.nextInt() % 4 == 0) {
                Assert.assertEquals((long)Long.MIN_VALUE, (long)record.getTimestamp(keyColumnOffset + 5));
            } else {
                Assert.assertEquals((long)rnd.nextLong(), (long)record.getTimestamp(keyColumnOffset + 5));
            }
            if (rnd.nextInt() % 4 == 0) {
                Assert.assertTrue((boolean)Float.isNaN(record.getFloat(keyColumnOffset + 6)));
            } else {
                Assert.assertEquals((float)rnd.nextFloat2(), (float)record.getFloat(keyColumnOffset + 6), (float)1.0E-8f);
            }
            if (rnd.nextInt() % 4 == 0) {
                Assert.assertTrue((boolean)Double.isNaN(record.getDouble(keyColumnOffset + 7)));
            } else {
                Assert.assertEquals((double)rnd.nextDouble2(), (double)record.getDouble(keyColumnOffset + 7), (double)1.0E-10);
            }
            if (rnd.nextInt() % 4 == 0) {
                Assert.assertNull((Object)record.getStr(keyColumnOffset + 8));
                Assert.assertNull((Object)record.getStrB(keyColumnOffset + 8));
                Assert.assertEquals((long)-1L, (long)record.getStrLen(keyColumnOffset + 8));
                AbstractCairoTest.sink.clear();
                record.getStr(keyColumnOffset + 8, (CharSink)AbstractCairoTest.sink);
                Assert.assertEquals((long)0L, (long)AbstractCairoTest.sink.length());
            } else {
                CharSequence tmp = rnd.nextChars(5);
                TestUtils.assertEquals(tmp, record.getStr(keyColumnOffset + 8));
                TestUtils.assertEquals(tmp, record.getStrB(keyColumnOffset + 8));
                Assert.assertEquals((long)tmp.length(), (long)record.getStrLen(keyColumnOffset + 8));
                AbstractCairoTest.sink.clear();
                record.getStr(keyColumnOffset + 8, (CharSink)AbstractCairoTest.sink);
                TestUtils.assertEquals(tmp, (CharSequence)AbstractCairoTest.sink);
            }
            if (rnd.nextInt() % 4 == 0) {
                Assert.assertNull((Object)record.getStr(keyColumnOffset + 9));
            } else {
                TestUtils.assertEquals(rnd.nextChars(3), record.getStr(keyColumnOffset + 9));
            }
            Assert.assertEquals((Object)rnd.nextBoolean(), (Object)record.getBool(keyColumnOffset + 10));
            if (rnd.nextInt() % 4 == 0) {
                TestUtils.assertEquals(null, record.getBin(keyColumnOffset + 11), record.getBinLen(keyColumnOffset + 11));
                continue;
            }
            binarySequence.of(rnd.nextBytes(25));
            TestUtils.assertEquals(binarySequence, record.getBin(keyColumnOffset + 11), record.getBinLen(keyColumnOffset + 11));
        }
        Assert.assertEquals((long)5000L, (long)c);
    }

    private void assertDupes(FastMap map, Rnd rnd, int n) {
        MapKey k;
        int key;
        int i;
        for (i = 0; i < n; ++i) {
            key = rnd.nextInt() & 0xF;
            k = map.withKey();
            k.putInt(key);
            MapValue values = k.createValue();
            if (values.isNew()) {
                values.putInt(0, 0);
                continue;
            }
            values.putInt(0, values.getInt(0) + 1);
        }
        Assert.assertEquals((long)map.size(), (long)16L);
        for (i = 0; i < n * 2; ++i) {
            key = (rnd.nextInt() & 0xF) + 16;
            k = map.withKey();
            k.putInt(key);
            Assert.assertTrue((boolean)k.notFound());
        }
    }

    private void createTestTable(int n, Rnd rnd, TestRecord.ArrayBinarySequence binarySequence) {
        try (TableModel model = new TableModel(configuration, "x", 3);){
            model.col("a", 1).col("b", 2).col("c", 3).col("d", 4).col("e", 10).col("f", 12).col("g", 5).col("h", 6).col("i", 7).col("j", 8).col("k", 0).col("l", 9);
            CairoTestUtils.create(model);
        }
        var5_5 = null;
        try (TableWriter writer = new TableWriter(configuration, (CharSequence)"x");){
            for (int i = 0; i < n; ++i) {
                TableWriter.Row row = writer.newRow(0L);
                row.putByte(0, rnd.nextByte());
                row.putShort(1, rnd.nextShort());
                if (rnd.nextInt() % 4 == 0) {
                    row.putInt(2, Integer.MIN_VALUE);
                } else {
                    row.putInt(2, rnd.nextInt());
                }
                if (rnd.nextInt() % 4 == 0) {
                    row.putLong(3, Long.MIN_VALUE);
                } else {
                    row.putLong(3, rnd.nextLong());
                }
                if (rnd.nextInt() % 4 == 0) {
                    row.putLong(4, Long.MIN_VALUE);
                } else {
                    row.putDate(4, rnd.nextLong());
                }
                if (rnd.nextInt() % 4 == 0) {
                    row.putLong(5, Long.MIN_VALUE);
                } else {
                    row.putTimestamp(5, rnd.nextLong());
                }
                if (rnd.nextInt() % 4 == 0) {
                    row.putFloat(6, Float.NaN);
                } else {
                    row.putFloat(6, rnd.nextFloat2());
                }
                if (rnd.nextInt() % 4 == 0) {
                    row.putDouble(7, Double.NaN);
                } else {
                    row.putDouble(7, rnd.nextDouble2());
                }
                if (rnd.nextInt() % 4 == 0) {
                    row.putStr(8, null);
                } else {
                    row.putStr(8, rnd.nextChars(5));
                }
                if (rnd.nextInt() % 4 == 0) {
                    row.putSym(9, null);
                } else {
                    row.putSym(9, rnd.nextChars(3));
                }
                row.putBool(10, rnd.nextBoolean());
                if (rnd.nextInt() % 4 == 0) {
                    row.putBin(11, null);
                } else {
                    binarySequence.of(rnd.nextBytes(25));
                    row.putBin(11, (BinarySequence)binarySequence);
                }
                row.append();
            }
            writer.commit();
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    private void populateMap(FastMap map, Rnd rnd2, RecordCursor cursor, RecordSink sink) {
        long counter = 0L;
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            MapKey key = map.withKey();
            key.put(record, sink);
            MapValue value = key.createValue();
            Assert.assertTrue((boolean)value.isNew());
            value.putLong(0, ++counter);
            value.putInt(1, rnd2.nextInt());
            value.putShort(2, rnd2.nextShort());
            value.putByte(3, rnd2.nextByte());
            value.putFloat(4, rnd2.nextFloat2());
            value.putDouble(5, rnd2.nextDouble2());
            value.putDate(6, rnd2.nextLong());
            value.putTimestamp(7, rnd2.nextLong());
            value.putBool(8, rnd2.nextBoolean());
        }
    }

    private void testUnsupportedValueType(int columnType) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try {
                new FastMap(0x100000, (ColumnTypes)new SingleColumnType(4), (ColumnTypes)new SingleColumnType(columnType), 64, 0.5);
                Assert.fail();
            }
            catch (CairoException e) {
                Assert.assertTrue((boolean)Chars.contains((CharSequence)e.getMessage(), (CharSequence)"value type is not supported"));
            }
        });
    }
}

