/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo.map;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.ArrayColumnTypes;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.ColumnFilter;
import com.questdb.cairo.ColumnTypes;
import com.questdb.cairo.EntityColumnFilter;
import com.questdb.cairo.RecordSink;
import com.questdb.cairo.RecordSinkFactory;
import com.questdb.cairo.SingleColumnType;
import com.questdb.cairo.SymbolAsIntTypes;
import com.questdb.cairo.SymbolAsStrTypes;
import com.questdb.cairo.TableModel;
import com.questdb.cairo.TableReader;
import com.questdb.cairo.TableReaderRecordCursor;
import com.questdb.cairo.TestRecord;
import com.questdb.cairo.VirtualMemory;
import com.questdb.cairo.map.CompactMap;
import com.questdb.cairo.map.MapKey;
import com.questdb.cairo.map.MapRecord;
import com.questdb.cairo.map.MapValue;
import com.questdb.cairo.sql.Record;
import com.questdb.cairo.sql.RecordCursor;
import com.questdb.std.BytecodeAssembler;
import com.questdb.std.LongList;
import com.questdb.std.Numbers;
import com.questdb.std.NumericException;
import com.questdb.std.ObjList;
import com.questdb.std.Rnd;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class CompactMapTest
extends AbstractCairoTest {
    @Test
    public void testAppendExisting() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            Rnd rnd = new Rnd();
            int N = 10;
            try (CompactMap map = new CompactMap(0x100000, (ColumnTypes)new SingleColumnType(7), (ColumnTypes)new SingleColumnType(4), (long)(N / 2), 0.9);){
                MapKey key;
                int i;
                ObjList keys = new ObjList();
                for (i = 0; i < N; ++i) {
                    CharSequence s = rnd.nextChars(11);
                    keys.add((Object)s.toString());
                    key = map.withKey();
                    key.putStr(s);
                    MapValue value = key.createValue();
                    Assert.assertTrue((boolean)value.isNew());
                    value.putLong(0, (long)(i + 1));
                }
                Assert.assertEquals((long)N, (long)map.size());
                int n = keys.size();
                for (i = 0; i < n; ++i) {
                    key = map.withKey();
                    CharSequence s = (CharSequence)keys.getQuick(i);
                    key.putStr(s);
                    MapValue value = key.createValue();
                    Assert.assertFalse((boolean)value.isNew());
                    Assert.assertEquals((long)(i + 1), (long)value.getLong(0));
                }
            }
        });
    }

    @Test
    public void testAppendUnique() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            Rnd rnd = new Rnd();
            int N = 100000;
            int M = 25;
            try (CompactMap map = new CompactMap(0x100000, (ColumnTypes)new SingleColumnType(7), (ColumnTypes)new SingleColumnType(4), (long)(2 * N), 0.7);){
                for (int i = 0; i < N; ++i) {
                    CharSequence s = rnd.nextChars(M);
                    MapKey key = map.withKey();
                    key.putStr(s);
                    MapValue value = key.createValue();
                    value.putLong(0, (long)(i + 1));
                }
                Assert.assertEquals((long)N, (long)map.size());
                long expectedAppendOffset = map.getAppendOffset();
                rnd.reset();
                for (int i = 0; i < N; ++i) {
                    CharSequence s = rnd.nextChars(M);
                    MapKey key = map.withKey();
                    key.putStr(s);
                    MapValue value = key.findValue();
                    Assert.assertNotNull((Object)value);
                    Assert.assertEquals((long)(i + 1), (long)value.getLong(0));
                }
                Assert.assertEquals((long)N, (long)map.size());
                Assert.assertEquals((long)expectedAppendOffset, (long)map.getAppendOffset());
            }
        });
    }

    @Test
    public void testConstructorRecovery() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            TestRecord.ArrayBinarySequence binarySequence = new TestRecord.ArrayBinarySequence();
            CairoTestUtils.createTestTable(10, new Rnd(), binarySequence);
            SingleColumnType columnTypes = new SingleColumnType();
            try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                try {
                    new CompactMap(1024, (ColumnTypes)reader.getMetadata(), columnTypes.of(4), 16L, 0.75);
                    Assert.fail();
                }
                catch (Exception e) {
                    TestUtils.assertContains(e.getMessage(), "Unsupported column type");
                }
            }
        });
    }

    @Test
    public void testKeyLookup() {
        double loadFactor = 0.9;
        try (CompactMap map = new CompactMap(0x100000, (ColumnTypes)new SingleColumnType(7), (ColumnTypes)new SingleColumnType(4), 12L, loadFactor, (CompactMap.HashFunction)new MockHash());){
            MapKey key = map.withKey();
            key.putStr((CharSequence)"000-ABCDE");
            MapValue value = key.createValue();
            Assert.assertTrue((boolean)value.isNew());
            value.putDouble(0, 12.5);
            key = map.withKey();
            key.putStr((CharSequence)"000-ABCDG");
            value = key.createValue();
            Assert.assertTrue((boolean)value.isNew());
            value.putDouble(0, 11.5);
            key = map.withKey();
            key.putStr((CharSequence)"100-ABCDE");
            value = key.createValue();
            Assert.assertTrue((boolean)value.isNew());
            value.putDouble(0, 10.5);
            key = map.withKey();
            key.putStr((CharSequence)"200-ABCDE");
            Assert.assertNull((Object)key.findValue());
            key = map.withKey();
            key.putStr((CharSequence)"004-ABCDE");
            Assert.assertNull((Object)key.findValue());
            key = map.withKey();
            key.putStr((CharSequence)"033-ABCDE");
            Assert.assertNull((Object)key.findValue());
        }
    }

    @Test
    public void testRecordAsKey() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 5000;
            Rnd rnd = new Rnd();
            TestRecord.ArrayBinarySequence binarySequence = new TestRecord.ArrayBinarySequence();
            CairoTestUtils.createTestTable(5000, rnd, binarySequence);
            BytecodeAssembler asm = new BytecodeAssembler();
            try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                EntityColumnFilter entityColumnFilter = new EntityColumnFilter();
                entityColumnFilter.of(reader.getMetadata().getColumnCount());
                try (CompactMap map = new CompactMap(0x100000, (ColumnTypes)new SymbolAsStrTypes((ColumnTypes)reader.getMetadata()), (ColumnTypes)new ArrayColumnTypes().reset().add(4).add(3).add(2).add(1).add(5).add(6).add(10).add(12).add(0), 5000L, 0.9);){
                    RecordSink sink = RecordSinkFactory.getInstance((BytecodeAssembler)asm, (ColumnTypes)reader.getMetadata(), (ColumnFilter)entityColumnFilter, (boolean)true);
                    int keyColumnOffset = map.getValueColumnCount();
                    Rnd rnd2 = new Rnd();
                    TableReaderRecordCursor cursor = reader.getCursor();
                    this.populateMap(map, rnd2, (RecordCursor)cursor, sink);
                    try (RecordCursor mapCursor = map.getCursor();){
                        this.assertMap2(5000, rnd, binarySequence, keyColumnOffset, rnd2, mapCursor);
                        mapCursor.toTop();
                        this.assertMap2(5000, rnd, binarySequence, keyColumnOffset, rnd2, mapCursor);
                    }
                }
            }
        });
    }

    @Test
    public void testRowIdAccess() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            SingleColumnType types = new SingleColumnType(3);
            int N = 10000;
            Rnd rnd = new Rnd();
            try (CompactMap map = new CompactMap(0x100000, (ColumnTypes)types, (ColumnTypes)types, 64L, 0.5);){
                for (int i = 0; i < 10000; ++i) {
                    MapKey key = map.withKey();
                    key.putInt(rnd.nextInt());
                    MapValue values = key.createValue();
                    Assert.assertTrue((boolean)values.isNew());
                    values.putInt(0, i + 1);
                }
                rnd.reset();
                LongList list = new LongList();
                try (RecordCursor mapCursor = map.getCursor();){
                    MapRecord record = (MapRecord)mapCursor.getRecord();
                    while (mapCursor.hasNext()) {
                        list.add(record.getRowId());
                        Assert.assertEquals((long)rnd.nextInt(), (long)record.getInt(1));
                        MapValue value = record.getValue();
                        value.putInt(0, value.getInt(0) * 2);
                    }
                    rnd.reset();
                    int n = list.size();
                    for (int i = 0; i < n; ++i) {
                        mapCursor.recordAt(list.getQuick(i));
                        Assert.assertEquals((long)((i + 1) * 2), (long)record.getInt(0));
                        Assert.assertEquals((long)rnd.nextInt(), (long)record.getInt(1));
                    }
                    rnd.reset();
                    MapRecord rec = (MapRecord)mapCursor.newRecord();
                    Assert.assertNotSame((Object)rec, (Object)mapCursor.getRecord());
                    int n2 = list.size();
                    for (int i = 0; i < n2; ++i) {
                        mapCursor.recordAt((Record)rec, list.getQuick(i));
                        Assert.assertEquals((long)((i + 1) * 2), (long)rec.getInt(0));
                        Assert.assertEquals((long)rnd.nextInt(), (long)rec.getInt(1));
                    }
                }
            }
        });
    }

    @Test
    public void testRowIdStore() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 10000;
            Rnd rnd = new Rnd();
            TestRecord.ArrayBinarySequence binarySequence = new TestRecord.ArrayBinarySequence();
            CairoTestUtils.createTestTable(10000, rnd, binarySequence);
            SingleColumnType types = new SingleColumnType(4);
            try (CompactMap map = new CompactMap(1024, (ColumnTypes)types, (ColumnTypes)types, 2500L, 0.5);){
                try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                    MapValue values;
                    MapKey key;
                    TableReaderRecordCursor cursor = reader.getCursor();
                    Record record = cursor.getRecord();
                    long counter = 0L;
                    while (cursor.hasNext()) {
                        key = map.withKeyAsLong(record.getRowId());
                        values = key.createValue();
                        Assert.assertTrue((boolean)values.isNew());
                        values.putLong(0, ++counter);
                    }
                    cursor.toTop();
                    counter = 0L;
                    while (cursor.hasNext()) {
                        key = map.withKeyAsLong(record.getRowId());
                        values = key.findValue();
                        Assert.assertNotNull((Object)values);
                        Assert.assertEquals((long)(++counter), (long)values.getLong(0));
                    }
                }
                Assert.assertEquals((long)10000L, (long)map.size());
            }
        });
    }

    @Test
    public void testUnableToFindFreeSlot() {
        Rnd rnd = new Rnd();
        int N = 256;
        int M = 32;
        StringSink sink = new StringSink();
        double loadFactor = 0.9999999;
        class MockHash
        implements CompactMap.HashFunction {
            MockHash() {
            }

            public long hash(VirtualMemory mem, long offset, long size) {
                char c = mem.getChar(offset + 12L);
                return c - 48;
            }
        }
        try (CompactMap map = new CompactMap(0x100000, (ColumnTypes)new SingleColumnType(7), (ColumnTypes)new SingleColumnType(4), (long)((double)N * loadFactor), loadFactor, (CompactMap.HashFunction)new MockHash());){
            Assert.assertEquals((long)N, (long)map.getActualCapacity());
            this.testUnableToFindFreeSlot0(rnd, N, M, sink, map);
            map.clear();
            rnd.reset();
            this.testUnableToFindFreeSlot0(rnd, N, M, sink, map);
        }
    }

    @Test
    public void testUnableToFindFreeSlot2() {
        Rnd rnd = new Rnd();
        int N = 256;
        int M = 32;
        StringSink sink = new StringSink();
        double loadFactor = 0.9999999;
        try (CompactMap map = new CompactMap(0x100000, (ColumnTypes)new SingleColumnType(7), (ColumnTypes)new SingleColumnType(4), (long)((double)N * loadFactor), loadFactor, (CompactMap.HashFunction)new MockHash());){
            Assert.assertEquals((long)N, (long)map.getActualCapacity());
            long target = map.getKeyCapacity();
            sink.clear();
            sink.put((CharSequence)"000");
            for (long i = 0L; i < target - 2L; ++i) {
                sink.clear(3);
                rnd.nextChars((CharSink)sink, 5);
                MapKey key = map.withKey();
                key.putStr((CharSequence)sink);
                MapValue value = key.createValue();
                Assert.assertTrue((boolean)value.isNew());
                value.putLong(0, i + 1L);
            }
            sink.clear();
            sink.put(target - 2L);
            this.populate(rnd, sink, map, target - 1L, M + N, 3);
            rnd.reset();
            sink.clear();
            sink.put((CharSequence)"000");
            this.assertMap(rnd, sink, map, 0L, target - 2L, 3);
            sink.clear();
            sink.put(target - 2L);
            this.assertMap(rnd, sink, map, target - 1L, M + N, 3);
        }
    }

    @Test
    public void testValueAccess() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "x", 3);){
                model.col("a", 1).col("b", 2).col("c", 3).col("d", 4).col("e", 10).col("f", 12).col("g", 5).col("h", 6).col("i", 7).col("j", 8).col("k", 0).col("l", 9);
                CairoTestUtils.create(model);
            }
            int N = 1000;
            Rnd rnd = new Rnd();
            TestRecord.ArrayBinarySequence binarySequence = new TestRecord.ArrayBinarySequence();
            CairoTestUtils.createTestTable(1000, rnd, binarySequence);
            BytecodeAssembler asm = new BytecodeAssembler();
            try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                EntityColumnFilter entityColumnFilter = new EntityColumnFilter();
                entityColumnFilter.of(reader.getMetadata().getColumnCount());
                try (CompactMap map = new CompactMap(0x100000, (ColumnTypes)new SymbolAsStrTypes((ColumnTypes)reader.getMetadata()), (ColumnTypes)new ArrayColumnTypes().reset().add(4).add(3).add(2).add(1).add(5).add(6).add(10).add(12).add(0), 1000L, 0.9);){
                    RecordSink sink = RecordSinkFactory.getInstance((BytecodeAssembler)asm, (ColumnTypes)reader.getMetadata(), (ColumnFilter)entityColumnFilter, (boolean)true);
                    Rnd rnd2 = new Rnd();
                    TableReaderRecordCursor cursor = reader.getCursor();
                    Record record = cursor.getRecord();
                    this.populateMap(map, rnd2, (RecordCursor)cursor, sink);
                    cursor.toTop();
                    rnd2.reset();
                    long c = 0L;
                    while (cursor.hasNext()) {
                        MapKey key = map.withKey();
                        key.put(record, sink);
                        MapValue value = key.findValue();
                        Assert.assertNotNull((Object)value);
                        Assert.assertEquals((long)(++c), (long)value.getLong(0));
                        Assert.assertEquals((long)rnd2.nextInt(), (long)value.getInt(1));
                        Assert.assertEquals((long)rnd2.nextShort(), (long)value.getShort(2));
                        Assert.assertEquals((long)rnd2.nextByte(), (long)value.getByte(3));
                        Assert.assertEquals((float)rnd2.nextFloat2(), (float)value.getFloat(4), (float)1.0E-6f);
                        Assert.assertEquals((double)rnd2.nextDouble2(), (double)value.getDouble(5), (double)1.0E-9);
                        Assert.assertEquals((long)rnd2.nextLong(), (long)value.getDate(6));
                        Assert.assertEquals((long)rnd2.nextLong(), (long)value.getTimestamp(7));
                        Assert.assertEquals((Object)rnd2.nextBoolean(), (Object)value.getBool(8));
                    }
                }
            }
        });
    }

    @Test
    public void testValueRandomWrite() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 1000;
            Rnd rnd = new Rnd();
            TestRecord.ArrayBinarySequence binarySequence = new TestRecord.ArrayBinarySequence();
            CairoTestUtils.createTestTable(1000, rnd, binarySequence);
            BytecodeAssembler asm = new BytecodeAssembler();
            try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                EntityColumnFilter entityColumnFilter = new EntityColumnFilter();
                entityColumnFilter.of(reader.getMetadata().getColumnCount());
                try (CompactMap map = new CompactMap(0x100000, (ColumnTypes)new SymbolAsIntTypes().of((ColumnTypes)reader.getMetadata()), (ColumnTypes)new ArrayColumnTypes().reset().add(4).add(3).add(2).add(1).add(5).add(6).add(10).add(12).add(0), 1000L, 0.9);){
                    RecordSink sink = RecordSinkFactory.getInstance((BytecodeAssembler)asm, (ColumnTypes)reader.getMetadata(), (ColumnFilter)entityColumnFilter, (boolean)false);
                    Rnd rnd2 = new Rnd();
                    TableReaderRecordCursor cursor = reader.getCursor();
                    Record record = cursor.getRecord();
                    long counter = 0L;
                    while (cursor.hasNext()) {
                        MapKey key = map.withKey();
                        key.put(record, sink);
                        MapValue value1 = key.createValue();
                        Assert.assertTrue((boolean)value1.isNew());
                        value1.putFloat(4, rnd2.nextFloat2());
                        value1.putDouble(5, rnd2.nextDouble2());
                        value1.putDate(6, rnd2.nextLong());
                        value1.putTimestamp(7, rnd2.nextLong());
                        value1.putBool(8, rnd2.nextBoolean());
                        value1.putLong(0, ++counter);
                        value1.putInt(1, rnd2.nextInt());
                        value1.putShort(2, rnd2.nextShort());
                        value1.putByte(3, rnd2.nextByte());
                    }
                    cursor.toTop();
                    rnd2.reset();
                    long c = 0L;
                    while (cursor.hasNext()) {
                        MapKey key = map.withKey();
                        key.put(record, sink);
                        MapValue value = key.findValue();
                        Assert.assertNotNull((Object)value);
                        Assert.assertEquals((float)rnd2.nextFloat2(), (float)value.getFloat(4), (float)1.0E-6f);
                        Assert.assertEquals((double)rnd2.nextDouble2(), (double)value.getDouble(5), (double)1.0E-9);
                        Assert.assertEquals((long)rnd2.nextLong(), (long)value.getDate(6));
                        Assert.assertEquals((long)rnd2.nextLong(), (long)value.getTimestamp(7));
                        Assert.assertEquals((Object)rnd2.nextBoolean(), (Object)value.getBool(8));
                        Assert.assertEquals((long)(++c), (long)value.getLong(0));
                        Assert.assertEquals((long)rnd2.nextInt(), (long)value.getInt(1));
                        Assert.assertEquals((long)rnd2.nextShort(), (long)value.getShort(2));
                        Assert.assertEquals((long)rnd2.nextByte(), (long)value.getByte(3));
                    }
                }
            }
        });
    }

    private void assertMap(Rnd rnd, StringSink sink, CompactMap map, long lo, long hi, int prefixLen) {
        for (long i = lo; i < hi; ++i) {
            sink.clear(prefixLen);
            rnd.nextChars((CharSink)sink, 5);
            MapKey key = map.withKey();
            key.putStr((CharSequence)sink);
            MapValue value = key.createValue();
            Assert.assertFalse((boolean)value.isNew());
            Assert.assertEquals((long)(i + 1L), (long)value.getLong(0));
        }
    }

    private void assertMap2(int n, Rnd rnd, TestRecord.ArrayBinarySequence binarySequence, int keyColumnOffset, Rnd rnd2, RecordCursor mapCursor) {
        long c = 0L;
        rnd.reset();
        rnd2.reset();
        Record record = mapCursor.getRecord();
        while (mapCursor.hasNext()) {
            Assert.assertEquals((long)(++c), (long)record.getLong(0));
            Assert.assertEquals((long)rnd2.nextInt(), (long)record.getInt(1));
            Assert.assertEquals((long)rnd2.nextShort(), (long)record.getShort(2));
            Assert.assertEquals((long)rnd2.nextByte(), (long)record.getByte(3));
            Assert.assertEquals((float)rnd2.nextFloat2(), (float)record.getFloat(4), (float)1.0E-6f);
            Assert.assertEquals((double)rnd2.nextDouble2(), (double)record.getDouble(5), (double)1.0E-9);
            Assert.assertEquals((long)rnd2.nextLong(), (long)record.getDate(6));
            Assert.assertEquals((long)rnd2.nextLong(), (long)record.getTimestamp(7));
            Assert.assertEquals((Object)rnd2.nextBoolean(), (Object)record.getBool(8));
            Assert.assertEquals((long)rnd.nextByte(), (long)record.getByte(keyColumnOffset));
            Assert.assertEquals((long)rnd.nextShort(), (long)record.getShort(keyColumnOffset + 1));
            if (rnd.nextInt() % 4 == 0) {
                Assert.assertEquals((long)Integer.MIN_VALUE, (long)record.getInt(keyColumnOffset + 2));
            } else {
                Assert.assertEquals((long)rnd.nextInt(), (long)record.getInt(keyColumnOffset + 2));
            }
            if (rnd.nextInt() % 4 == 0) {
                Assert.assertEquals((long)Long.MIN_VALUE, (long)record.getLong(keyColumnOffset + 3));
            } else {
                Assert.assertEquals((long)rnd.nextLong(), (long)record.getLong(keyColumnOffset + 3));
            }
            if (rnd.nextInt() % 4 == 0) {
                Assert.assertEquals((long)Long.MIN_VALUE, (long)record.getDate(keyColumnOffset + 4));
            } else {
                Assert.assertEquals((long)rnd.nextLong(), (long)record.getDate(keyColumnOffset + 4));
            }
            if (rnd.nextInt() % 4 == 0) {
                Assert.assertEquals((long)Long.MIN_VALUE, (long)record.getTimestamp(keyColumnOffset + 5));
            } else {
                Assert.assertEquals((long)rnd.nextLong(), (long)record.getTimestamp(keyColumnOffset + 5));
            }
            if (rnd.nextInt() % 4 == 0) {
                Assert.assertTrue((boolean)Float.isNaN(record.getFloat(keyColumnOffset + 6)));
            } else {
                Assert.assertEquals((float)rnd.nextFloat2(), (float)record.getFloat(keyColumnOffset + 6), (float)1.0E-8f);
            }
            if (rnd.nextInt() % 4 == 0) {
                Assert.assertTrue((boolean)Double.isNaN(record.getDouble(keyColumnOffset + 7)));
            } else {
                Assert.assertEquals((double)rnd.nextDouble2(), (double)record.getDouble(keyColumnOffset + 7), (double)1.0E-10);
            }
            if (rnd.nextInt() % 4 == 0) {
                Assert.assertNull((Object)record.getStr(keyColumnOffset + 8));
                Assert.assertNull((Object)record.getStrB(keyColumnOffset + 8));
                Assert.assertEquals((long)-1L, (long)record.getStrLen(keyColumnOffset + 8));
            } else {
                CharSequence tmp = rnd.nextChars(5);
                TestUtils.assertEquals(tmp, record.getStr(keyColumnOffset + 8));
                TestUtils.assertEquals(tmp, record.getStrB(keyColumnOffset + 8));
                Assert.assertEquals((long)tmp.length(), (long)record.getStrLen(keyColumnOffset + 8));
            }
            if (rnd.nextInt() % 4 == 0) {
                Assert.assertNull((Object)record.getStr(keyColumnOffset + 9));
            } else {
                TestUtils.assertEquals(rnd.nextChars(3), record.getStr(keyColumnOffset + 9));
            }
            Assert.assertEquals((Object)rnd.nextBoolean(), (Object)record.getBool(keyColumnOffset + 10));
            if (rnd.nextInt() % 4 == 0) {
                TestUtils.assertEquals(null, record.getBin(keyColumnOffset + 11), record.getBinLen(keyColumnOffset + 11));
                continue;
            }
            binarySequence.of(rnd.nextBytes(25));
            TestUtils.assertEquals(binarySequence, record.getBin(keyColumnOffset + 11), record.getBinLen(keyColumnOffset + 11));
        }
        Assert.assertEquals((long)n, (long)c);
    }

    private void populate(Rnd rnd, StringSink sink, CompactMap map, long lo, long hi, int prefixLen) {
        for (long i = lo; i < hi; ++i) {
            sink.clear(prefixLen);
            rnd.nextChars((CharSink)sink, 5);
            MapKey key = map.withKey();
            key.putStr((CharSequence)sink);
            MapValue value = key.createValue();
            Assert.assertTrue((boolean)value.isNew());
            value.putLong(0, i + 1L);
        }
    }

    private void populateMap(CompactMap map, Rnd rnd2, RecordCursor cursor, RecordSink sink) {
        long counter = 0L;
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            MapKey key = map.withKey();
            key.put(record, sink);
            MapValue value = key.createValue();
            Assert.assertTrue((boolean)value.isNew());
            value.putLong(0, ++counter);
            value.putInt(1, rnd2.nextInt());
            value.putShort(2, rnd2.nextShort());
            value.putByte(3, rnd2.nextByte());
            value.putFloat(4, rnd2.nextFloat2());
            value.putDouble(5, rnd2.nextDouble2());
            value.putDate(6, rnd2.nextLong());
            value.putTimestamp(7, rnd2.nextLong());
            value.putBool(8, rnd2.nextBoolean());
        }
    }

    private void testUnableToFindFreeSlot0(Rnd rnd, int n, int m, StringSink sink, CompactMap map) {
        long target = map.getKeyCapacity();
        sink.clear();
        sink.put('0');
        this.populate(rnd, sink, map, 0L, target - 1L, 1);
        sink.clear();
        sink.put('1');
        this.populate(rnd, sink, map, target - 1L, m + n, 1);
        rnd.reset();
        sink.clear();
        sink.put('0');
        this.assertMap(rnd, sink, map, 0L, target - 1L, 1);
        sink.clear();
        sink.put('1');
        this.assertMap(rnd, sink, map, target - 1L, m + n, 1);
    }

    private class MockHash
    implements CompactMap.HashFunction {
        private MockHash() {
        }

        public long hash(VirtualMemory mem, long offset, long size) {
            CharSequence cs = mem.getStr(offset + 8L);
            try {
                return Numbers.parseLong((CharSequence)cs, (int)0, (int)3);
            }
            catch (NumericException e) {
                throw new RuntimeException();
            }
        }
    }
}

