/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.TestRecord;
import com.questdb.cairo.VirtualMemory;
import com.questdb.std.BinarySequence;
import com.questdb.std.ByteBuffers;
import com.questdb.std.Chars;
import com.questdb.std.Rnd;
import com.questdb.std.Unsafe;
import com.questdb.test.tools.TestUtils;
import java.nio.ByteBuffer;
import org.junit.Assert;
import org.junit.Test;

public class VirtualMemoryTest {
    @Test
    public void testBinBuf() {
        this.assertBuf(ByteBuffer.allocate(0x100000), 1024);
    }

    @Test
    public void testBinBufDirect() {
        ByteBuffer buf = ByteBuffer.allocateDirect(0x100000);
        try {
            this.assertBuf(buf, 1024);
        }
        finally {
            ByteBuffers.release((ByteBuffer)buf);
        }
    }

    @Test
    public void testBinSequence() {
        this.testBinSequence0(700L, 2048L);
    }

    @Test
    public void testBinSequence2() {
        this.testBinSequence0(1024L, 600L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBinSequenceOnEdge() {
        Rnd rnd = new Rnd();
        try (VirtualMemory mem = new VirtualMemory(32L);){
            TestRecord.ArrayBinarySequence seq = new TestRecord.ArrayBinarySequence();
            int N = 33;
            int O = 10;
            seq.of(rnd.nextBytes(N));
            mem.putBin((BinarySequence)seq);
            BinarySequence actual = mem.getBin(0L);
            Assert.assertNotNull((Object)actual);
            TestUtils.assertEquals(seq, actual, N);
            long buffer = Unsafe.malloc((long)1024L);
            try {
                int i;
                Unsafe.getUnsafe().setMemory(buffer, 1024L, (byte)5);
                actual.copyTo(buffer, 0L, 1024L);
                for (i = 0; i < N; ++i) {
                    Assert.assertEquals((long)seq.byteAt(i), (long)Unsafe.getUnsafe().getByte(buffer + (long)i));
                }
                for (i = N; i < 1024; ++i) {
                    Assert.assertEquals((long)5L, (long)Unsafe.getUnsafe().getByte(buffer + (long)i));
                }
                Unsafe.getUnsafe().setMemory(buffer, 1024L, (byte)5);
                actual.copyTo(buffer, (long)O, 1024L);
                for (i = 0; i < N - O; ++i) {
                    Assert.assertEquals((long)seq.byteAt(i + O), (long)Unsafe.getUnsafe().getByte(buffer + (long)i));
                }
                for (i = N - O; i < 1024; ++i) {
                    Assert.assertEquals((long)5L, (long)Unsafe.getUnsafe().getByte(buffer + (long)i));
                }
            }
            finally {
                Unsafe.free((long)buffer, (long)1024L);
            }
        }
    }

    @Test
    public void testBool() {
        Rnd rnd = new Rnd();
        try (VirtualMemory mem = new VirtualMemory(11L);){
            int n = 120;
            for (int i = 0; i < n; ++i) {
                mem.putBool(rnd.nextBoolean());
            }
            long o = 0L;
            rnd.reset();
            for (int i = 0; i < n; ++i) {
                Assert.assertEquals((Object)rnd.nextBoolean(), (Object)mem.getBool(o++));
            }
        }
    }

    @Test
    public void testBoolRnd() {
        Rnd rnd = new Rnd();
        try (VirtualMemory mem = new VirtualMemory(11L);){
            int i;
            int n = 120;
            long o = 0L;
            for (i = 0; i < n; ++i) {
                mem.putBool(o++, rnd.nextBoolean());
            }
            o = 0L;
            rnd.reset();
            for (i = 0; i < n; ++i) {
                Assert.assertEquals((Object)rnd.nextBoolean(), (Object)mem.getBool(o++));
            }
        }
    }

    @Test
    public void testBulkCopy() {
        int N = 1000;
        try (VirtualMemory mem = new VirtualMemory(128L);){
            for (int i = 0; i < N; ++i) {
                mem.putShort((short)i);
            }
            long target = N * 2;
            long offset = 0L;
            int i = 0;
            while (target > 0L) {
                long len = mem.pageRemaining(offset);
                target -= len;
                long address = mem.addressOf(offset);
                offset += len;
                while (len > 0L & i < N) {
                    int n = i;
                    i = (short)(i + 1);
                    Assert.assertEquals((long)n, (long)Unsafe.getUnsafe().getShort(address));
                    address += 2L;
                    len -= 2L;
                }
            }
        }
    }

    @Test
    public void testByte() {
        try (VirtualMemory mem = new VirtualMemory(11L);){
            int n = 120;
            for (int i = 0; i < n; ++i) {
                mem.putByte((byte)i);
            }
            long o = 0L;
            for (int i = 0; i < n; ++i) {
                Assert.assertEquals((long)i, (long)mem.getByte(o++));
            }
        }
    }

    @Test
    public void testByteRandom() {
        try (VirtualMemory mem = new VirtualMemory(128L);){
            long offset1 = 512L;
            mem.putByte(offset1, (byte)3);
            mem.putByte(offset1 + 1L, (byte)4);
            mem.jumpTo(offset1 + 2L);
            mem.putByte((byte)5);
            Assert.assertEquals((long)3L, (long)mem.getByte(offset1));
            Assert.assertEquals((long)4L, (long)mem.getByte(offset1 + 1L));
            Assert.assertEquals((long)5L, (long)mem.getByte(offset1 + 2L));
        }
    }

    @Test
    public void testByteRnd() {
        try (VirtualMemory mem = new VirtualMemory(11L);){
            int n = 120;
            long o = 0L;
            int i = 0;
            while (i < n) {
                mem.putByte(o, (byte)i);
                ++i;
                ++o;
            }
            o = 0L;
            for (i = 0; i < n; ++i) {
                Assert.assertEquals((long)i, (long)mem.getByte(o++));
            }
        }
    }

    @Test
    public void testDouble() {
        try (VirtualMemory mem = new VirtualMemory(11L);){
            Rnd rnd = new Rnd();
            int n = 999;
            mem.putByte((byte)1);
            for (int i = 0; i < n; ++i) {
                mem.putDouble(rnd.nextDouble2());
            }
            Assert.assertEquals((long)7993L, (long)mem.getAppendOffset());
            rnd.reset();
            long o = 1L;
            Assert.assertEquals((long)1L, (long)mem.getByte(0L));
            for (int i = 0; i < n; ++i) {
                Assert.assertEquals((double)rnd.nextDouble2(), (double)mem.getDouble(o), (double)1.0E-5);
                o += 8L;
            }
        }
    }

    @Test
    public void testDoubleCompatibility() {
        long pageSize = 64L;
        try (VirtualMemory mem = new VirtualMemory(pageSize);){
            mem.putInt(10);
            mem.putDouble(8.98098028422234E9);
            mem.putDoubleBytes(8.979283749729836E9);
            Assert.assertEquals((double)8.98098028422234E9, (double)mem.getDoubleBytes(0, 4L, pageSize), (double)1.0E-5);
            Assert.assertEquals((double)8.979283749729836E9, (double)mem.getDouble(12L), (double)1.0E-5);
        }
    }

    @Test
    public void testDoubleRnd() {
        try (VirtualMemory mem = new VirtualMemory(11L);){
            int i;
            Rnd rnd = new Rnd();
            int n = 999;
            long o = 1L;
            mem.putByte((byte)1);
            for (i = 0; i < n; ++i) {
                mem.putDouble(o, rnd.nextDouble2());
                o += 8L;
            }
            rnd.reset();
            o = 1L;
            Assert.assertEquals((long)1L, (long)mem.getByte(0L));
            for (i = 0; i < n; ++i) {
                Assert.assertEquals((double)rnd.nextDouble2(), (double)mem.getDouble(o), (double)1.0E-5);
                o += 8L;
            }
        }
    }

    @Test
    public void testDoubleRndCompatibility() {
        long pageSize = 64L;
        try (VirtualMemory mem = new VirtualMemory(pageSize);){
            mem.putInt(10L, 900);
            mem.putDouble(22L, 8.98098028422234E9);
            mem.putDoubleBytes(84L, 8.979283749729836E9);
            Assert.assertEquals((double)8.98098028422234E9, (double)mem.getDoubleBytes(0, 22L, pageSize), (double)1.0E-5);
            Assert.assertEquals((double)8.979283749729836E9, (double)mem.getDouble(84L), (double)1.0E-5);
        }
    }

    @Test
    public void testEvenPageSize() {
        try (VirtualMemory mem = new VirtualMemory(32L);){
            this.assertStrings(mem, false);
        }
    }

    @Test
    public void testFloat() {
        try (VirtualMemory mem = new VirtualMemory(11L);){
            Rnd rnd = new Rnd();
            int n = 999;
            mem.putByte((byte)1);
            for (int i = 0; i < n; ++i) {
                mem.putFloat(rnd.nextFloat2());
            }
            rnd.reset();
            long o = 1L;
            Assert.assertEquals((long)1L, (long)mem.getByte(0L));
            for (int i = 0; i < n; ++i) {
                Assert.assertEquals((float)rnd.nextFloat2(), (float)mem.getFloat(o), (float)1.0E-5f);
                o += 4L;
            }
        }
    }

    @Test
    public void testFloatCompatibility() {
        long pageSize = 64L;
        try (VirtualMemory mem = new VirtualMemory(pageSize);){
            mem.putFloat(1024.0f);
            mem.putFloatBytes(2048.0f);
            Assert.assertEquals((float)1024.0f, (float)mem.getFloatBytes(0, 0L), (float)1.0E-5f);
            Assert.assertEquals((float)2048.0f, (float)mem.getFloat(4L), (float)1.0E-4f);
        }
    }

    @Test
    public void testFloatRnd() {
        try (VirtualMemory mem = new VirtualMemory(11L);){
            int i;
            Rnd rnd = new Rnd();
            int n = 999;
            long o = 1L;
            mem.putByte((byte)1);
            for (i = 0; i < n; ++i) {
                mem.putFloat(o, rnd.nextFloat2());
                o += 4L;
            }
            rnd.reset();
            o = 1L;
            Assert.assertEquals((long)1L, (long)mem.getByte(0L));
            for (i = 0; i < n; ++i) {
                Assert.assertEquals((float)rnd.nextFloat2(), (float)mem.getFloat(o), (float)1.0E-5f);
                o += 4L;
            }
        }
    }

    @Test
    public void testFloatRndCompatibility() {
        long pageSize = 64L;
        try (VirtualMemory mem = new VirtualMemory(pageSize);){
            mem.putByte(10L, (byte)5);
            mem.putFloat(61L, 1024.0f);
            mem.putFloatBytes(99L, 2048.0f);
            Assert.assertEquals((float)1024.0f, (float)mem.getFloatBytes(0, 61L), (float)1.0E-5f);
            Assert.assertEquals((float)2048.0f, (float)mem.getFloat(99L), (float)1.0E-4f);
        }
    }

    @Test
    public void testInt() {
        try (VirtualMemory mem = new VirtualMemory(7L);){
            int n;
            mem.putByte((byte)1);
            for (int i = n = 999; i > 0; --i) {
                mem.putInt(i);
            }
            long o = 1L;
            Assert.assertEquals((long)1L, (long)mem.getByte(0L));
            for (int i = n; i > 0; --i) {
                Assert.assertEquals((long)i, (long)mem.getInt(o));
                o += 4L;
            }
        }
    }

    @Test
    public void testIntCompatibility() {
        long pageSize = 64L;
        try (VirtualMemory mem = new VirtualMemory(pageSize);){
            mem.putInt(1024);
            mem.putIntBytes(2048);
            Assert.assertEquals((long)1024L, (long)mem.getIntBytes(0, 0L));
            Assert.assertEquals((long)2048L, (long)mem.getInt(4L));
        }
    }

    @Test
    public void testIntRnd() {
        try (VirtualMemory mem = new VirtualMemory(7L);){
            int n;
            int i;
            long o = 1L;
            mem.putByte(0L, (byte)1);
            for (i = n = 999; i > 0; --i) {
                mem.putInt(o, i);
                o += 4L;
            }
            o = 1L;
            Assert.assertEquals((long)1L, (long)mem.getByte(0L));
            for (i = n; i > 0; --i) {
                Assert.assertEquals((long)i, (long)mem.getInt(o));
                o += 4L;
            }
        }
    }

    @Test
    public void testIntRndCompatibility() {
        long pageSize = 64L;
        try (VirtualMemory mem = new VirtualMemory(pageSize);){
            mem.putByte(10L, (byte)22);
            mem.putInt(15L, 1024);
            mem.putIntBytes(55L, 2048);
            Assert.assertEquals((long)1024L, (long)mem.getIntBytes(0, 15L));
            Assert.assertEquals((long)2048L, (long)mem.getInt(55L));
        }
    }

    @Test
    public void testJumpTo() {
        try (VirtualMemory mem = new VirtualMemory(11L);){
            int n;
            int i;
            mem.putByte((byte)1);
            for (i = n = 999; i > 0; --i) {
                mem.putLong((long)i);
            }
            Assert.assertEquals((long)1L, (long)mem.getByte(0L));
            mem.jumpTo(1L);
            for (i = n; i > 0; --i) {
                mem.putLong((long)(n - i));
            }
            long o = 1L;
            for (int i2 = n; i2 > 0; --i2) {
                Assert.assertEquals((long)(n - i2), (long)mem.getLong(o));
                o += 8L;
            }
        }
    }

    @Test
    public void testJumpTo2() {
        try (VirtualMemory mem = new VirtualMemory(11L);){
            int n;
            mem.jumpTo(8L);
            for (int i = n = 999; i > 0; --i) {
                mem.putLong((long)i);
            }
            long o = 8L;
            for (int i = n; i > 0; --i) {
                Assert.assertEquals((long)i, (long)mem.getLong(o));
                o += 8L;
            }
        }
    }

    @Test
    public void testJumpTo3() {
        try (VirtualMemory mem = new VirtualMemory(11L);){
            int i;
            int n;
            mem.jumpTo(256L);
            for (int i2 = n = 999; i2 > 0; --i2) {
                mem.putLong((long)i2);
            }
            long o = 256L;
            for (i = n; i > 0; --i) {
                Assert.assertEquals((long)i, (long)mem.getLong(o));
                o += 8L;
            }
            mem.jumpTo(0L);
            mem.jumpTo(5L);
            mem.jumpTo(0L);
            for (i = n; i > 0; --i) {
                mem.putLong((long)i);
            }
            o = 0L;
            for (i = n; i > 0; --i) {
                Assert.assertEquals((long)i, (long)mem.getLong(o));
                o += 8L;
            }
        }
    }

    @Test
    public void testLargePageBinBuf() {
        this.assertBuf(ByteBuffer.allocate(0x100000), 0x400000);
    }

    @Test
    public void testLargePageBinBufDirect() {
        ByteBuffer buf = ByteBuffer.allocateDirect(0x100000);
        try {
            this.assertBuf(buf, 0x400000);
        }
        finally {
            ByteBuffers.release((ByteBuffer)buf);
        }
    }

    @Test
    public void testLongCompatibility() {
        long pageSize = 64L;
        try (VirtualMemory mem = new VirtualMemory(pageSize);){
            mem.putLong(8980980284302834L);
            mem.putLongBytes(897928374972983477L);
            Assert.assertEquals((long)8980980284302834L, (long)mem.getLongBytes(0, 0L, pageSize));
            Assert.assertEquals((long)897928374972983477L, (long)mem.getLong(8L));
        }
    }

    @Test
    public void testLongEven() {
        try (VirtualMemory mem = new VirtualMemory(11L);){
            int n;
            for (int i = n = 999; i > 0; --i) {
                mem.putLong((long)i);
            }
            long o = 0L;
            for (int i = n; i > 0; --i) {
                Assert.assertEquals((long)i, (long)mem.getLong(o));
                o += 8L;
            }
        }
    }

    @Test
    public void testLongOdd() {
        try (VirtualMemory mem = new VirtualMemory(11L);){
            int n;
            mem.putByte((byte)1);
            for (int i = n = 999; i > 0; --i) {
                mem.putLong((long)i);
            }
            long o = 1L;
            Assert.assertEquals((long)1L, (long)mem.getByte(0L));
            for (int i = n; i > 0; --i) {
                Assert.assertEquals((long)i, (long)mem.getLong(o));
                o += 8L;
            }
        }
    }

    @Test
    public void testLongRndCompatibility() {
        long pageSize = 64L;
        try (VirtualMemory mem = new VirtualMemory(pageSize);){
            mem.putLong(33L, 8980980284302834L);
            mem.putLongBytes(12L, 897928374972983477L);
            Assert.assertEquals((long)8980980284302834L, (long)mem.getLongBytes(0, 33L, pageSize));
            Assert.assertEquals((long)897928374972983477L, (long)mem.getLong(12L));
        }
    }

    @Test
    public void testLongRndEven() {
        try (VirtualMemory mem = new VirtualMemory(11L);){
            int i;
            int n = 999;
            long o = 0L;
            for (i = n; i > 0; --i) {
                mem.putLong(o, (long)i);
                o += 8L;
            }
            o = 0L;
            for (i = n; i > 0; --i) {
                Assert.assertEquals((long)i, (long)mem.getLong(o));
                o += 8L;
            }
        }
    }

    @Test
    public void testLongRndOdd() {
        try (VirtualMemory mem = new VirtualMemory(11L);){
            int i;
            mem.putByte(0L, (byte)1);
            int n = 999;
            long o = 1L;
            for (i = n; i > 0; --i) {
                mem.putLong(o, (long)i);
                o += 8L;
            }
            o = 1L;
            Assert.assertEquals((long)1L, (long)mem.getByte(0L));
            for (i = n; i > 0; --i) {
                Assert.assertEquals((long)i, (long)mem.getLong(o));
                o += 8L;
            }
        }
    }

    @Test
    public void testNullBin() {
        try (VirtualMemory mem = new VirtualMemory(1024L);){
            ByteBuffer buf = ByteBuffer.allocate(1024);
            mem.putBin((ByteBuffer)null);
            mem.putBin(0L, 0L);
            buf.flip();
            mem.putBin(buf);
            long o1 = mem.putNullBin();
            Assert.assertNull((Object)mem.getBin(0L));
            Assert.assertNull((Object)mem.getBin(8L));
            BinarySequence bsview = mem.getBin(16L);
            Assert.assertNotNull((Object)bsview);
            Assert.assertEquals((long)0L, (long)bsview.length());
            Assert.assertNull((Object)mem.getBin(o1));
        }
    }

    @Test
    public void testOffPageSize() {
        try (VirtualMemory mem = new VirtualMemory(12L);){
            this.assertStrings(mem, true);
        }
    }

    @Test
    public void testOkSize() {
        try (VirtualMemory mem = new VirtualMemory(1024L);){
            this.assertStrings(mem, false);
        }
    }

    @Test
    public void testShort() {
        try (VirtualMemory mem = new VirtualMemory(7L);){
            short n;
            mem.putByte((byte)1);
            for (short i = n = 999; i > 0; i = (short)(i - 1)) {
                mem.putShort(i);
            }
            long o = 1L;
            Assert.assertEquals((long)1L, (long)mem.getByte(0L));
            for (short i = n; i > 0; i = (short)(i - 1)) {
                Assert.assertEquals((long)i, (long)mem.getShort(o));
                o += 2L;
            }
        }
    }

    @Test
    public void testShortCompatibility() {
        long pageSize = 64L;
        try (VirtualMemory mem = new VirtualMemory(pageSize);){
            mem.putShort((short)1024);
            mem.putShortBytes((short)2048);
            Assert.assertEquals((long)1024L, (long)mem.getShortBytes(0, 0L, pageSize));
            Assert.assertEquals((long)2048L, (long)mem.getShort(2L));
        }
    }

    @Test
    public void testShortRnd() {
        try (VirtualMemory mem = new VirtualMemory(7L);){
            short n;
            short i;
            long o = 1L;
            mem.putByte(0L, (byte)1);
            for (i = n = 999; i > 0; i = (short)(i - 1)) {
                mem.putShort(o, i);
                o += 2L;
            }
            Assert.assertEquals((long)1L, (long)mem.getByte(0L));
            o = 1L;
            for (i = n; i > 0; i = (short)(i - 1)) {
                Assert.assertEquals((long)i, (long)mem.getShort(o));
                o += 2L;
            }
        }
    }

    @Test
    public void testShortRndCompatibility() {
        long pageSize = 64L;
        try (VirtualMemory mem = new VirtualMemory(pageSize);){
            mem.putShort(5L, (short)3);
            mem.putShort(11L, (short)1024);
            mem.putShortBytes(33L, (short)2048);
            Assert.assertEquals((long)1024L, (long)mem.getShortBytes(0, 11L, pageSize));
            Assert.assertEquals((long)2048L, (long)mem.getShort(33L));
        }
    }

    @Test
    public void testSkip() {
        try (VirtualMemory mem = new VirtualMemory(11L);){
            int n;
            mem.putByte((byte)1);
            for (int i = n = 999; i > 0; --i) {
                mem.putLong((long)i);
                mem.skip(3L);
            }
            long o = 1L;
            Assert.assertEquals((long)1L, (long)mem.getByte(0L));
            for (int i = n; i > 0; --i) {
                Assert.assertEquals((long)i, (long)mem.getLong(o));
                o += 11L;
            }
            Assert.assertEquals((long)10990L, (long)mem.getAppendOffset());
        }
    }

    @Test
    public void testSmallEven() {
        try (VirtualMemory mem = new VirtualMemory(2L);){
            this.assertStrings(mem, false);
        }
    }

    @Test
    public void testSmallOdd() {
        try (VirtualMemory mem = new VirtualMemory(2L);){
            this.assertStrings(mem, true);
        }
    }

    @Test
    public void testStrRndEven() {
        this.testStrRnd(0L, 4L);
    }

    @Test
    public void testStrRndLargePage() {
        this.testStrRnd(1L, 16L);
    }

    @Test
    public void testStrRndOdd() {
        this.testStrRnd(1L, 4L);
    }

    @Test
    public void testStringStorageDimensions() {
        Assert.assertEquals((long)10L, (long)VirtualMemory.getStorageLength((CharSequence)"xyz"));
        Assert.assertEquals((long)4L, (long)VirtualMemory.getStorageLength((CharSequence)""));
        Assert.assertEquals((long)4L, (long)VirtualMemory.getStorageLength(null));
    }

    private void assertBuf(ByteBuffer buf, int pageSize) {
        Rnd rnd = new Rnd();
        int n = 99;
        try (VirtualMemory mem = new VirtualMemory((long)pageSize);){
            for (int i = 0; i < n; ++i) {
                int sz = rnd.nextPositiveInt() % buf.capacity();
                for (int j = 0; j < sz; ++j) {
                    buf.put(rnd.nextByte());
                }
                buf.flip();
                mem.putBin(buf);
                Assert.assertEquals((long)0L, (long)buf.remaining());
                buf.clear();
            }
            rnd.reset();
            long o = 0L;
            for (int i = 0; i < n; ++i) {
                long sz = rnd.nextPositiveInt() % buf.capacity();
                BinarySequence bsview = mem.getBin(o);
                Assert.assertNotNull((Object)bsview);
                Assert.assertEquals((long)sz, (long)bsview.length());
                o += sz + 8L;
                for (long j = 0L; j < sz; ++j) {
                    Assert.assertEquals((long)rnd.nextByte(), (long)bsview.byteAt(j));
                }
            }
        }
    }

    private void assertStrings(VirtualMemory mem, boolean b) {
        if (b) {
            mem.putByte((byte)1);
        }
        long o1 = mem.putStr((CharSequence)"123");
        long o2 = mem.putStr((CharSequence)"0987654321abcd");
        long o3 = mem.putStr(null);
        long o4 = mem.putStr((CharSequence)"xyz123");
        long o5 = mem.putNullStr();
        long o6 = mem.putStr((CharSequence)"123ohh4", 3, 3);
        long o7 = mem.putStr(null, 0, 2);
        if (b) {
            Assert.assertEquals((long)1L, (long)mem.getByte(0L));
        }
        TestUtils.assertEquals((CharSequence)"123", mem.getStr(o1));
        Assert.assertEquals((long)3L, (long)mem.getStrLen(o1));
        TestUtils.assertEquals((CharSequence)"123", mem.getStr2(o1));
        String expected = "0987654321abcd";
        TestUtils.assertEquals((CharSequence)"0987654321abcd", mem.getStr(o2));
        TestUtils.assertEquals((CharSequence)"0987654321abcd", mem.getStr2(o2));
        for (int i = 0; i < expected.length(); ++i) {
            long offset = o2 + 4L + (long)(i * 2);
            int page = mem.pageIndex(offset);
            long pageOffset = mem.offsetInPage(offset);
            long pageSize = mem.getPageSize(page);
            Assert.assertEquals((long)expected.charAt(i), (long)mem.getCharBytes(page, pageOffset, pageSize));
        }
        Assert.assertNull((Object)mem.getStr(o3));
        Assert.assertNull((Object)mem.getStr2(o3));
        TestUtils.assertEquals((CharSequence)"xyz123", mem.getStr(o4));
        TestUtils.assertEquals((CharSequence)"xyz123", mem.getStr2(o4));
        Assert.assertNull((Object)mem.getStr(o5));
        Assert.assertNull((Object)mem.getStr2(o5));
        Assert.assertEquals((long)-1L, (long)mem.getStrLen(o5));
        TestUtils.assertEquals((CharSequence)"ohh", mem.getStr(o6));
        Assert.assertNull((Object)mem.getStr(o7));
        CharSequence s1 = mem.getStr(o1);
        CharSequence s2 = mem.getStr2(o2);
        Assert.assertFalse((boolean)Chars.equals((CharSequence)s1, (CharSequence)s2));
    }

    private void testBinSequence0(long mem1Size, long mem2Size) {
        Rnd rnd = new Rnd();
        int n = 999;
        ByteBuffer buf = ByteBuffer.allocate(600);
        try (VirtualMemory mem = new VirtualMemory(mem1Size);){
            for (int i = 0; i < n; ++i) {
                if (rnd.nextPositiveInt() % 16 == 0) {
                    mem.putBin((ByteBuffer)null);
                    continue;
                }
                int sz = buf.capacity();
                for (int j = 0; j < sz; ++j) {
                    buf.put(rnd.nextByte());
                }
                buf.flip();
                mem.putBin(buf);
                Assert.assertEquals((long)0L, (long)buf.remaining());
                buf.clear();
            }
            try (VirtualMemory mem2 = new VirtualMemory(mem2Size);){
                int i;
                long o = 0L;
                for (i = 0; i < n; ++i) {
                    BinarySequence sequence = mem.getBin(o);
                    o = sequence == null ? (o += 8L) : (o += sequence.length() + 8L);
                    mem2.putBin(sequence);
                }
                o = 0L;
                for (i = 0; i < n; ++i) {
                    BinarySequence sequence1 = mem.getBin(o);
                    BinarySequence sequence2 = mem2.getBin(o);
                    if (sequence1 == null) {
                        Assert.assertNull((Object)sequence2);
                        Assert.assertEquals((long)-1L, (long)mem2.getBinLen(o));
                        o += 8L;
                        continue;
                    }
                    Assert.assertNotNull((Object)sequence2);
                    Assert.assertEquals((long)mem.getBinLen(o), (long)mem2.getBinLen(o));
                    Assert.assertEquals((long)sequence1.length(), (long)sequence2.length());
                    long len = sequence1.length();
                    for (long l = 0L; l < len; ++l) {
                        Assert.assertEquals((long)sequence1.byteAt(l), (long)sequence2.byteAt(l));
                    }
                    o += sequence1.length() + 8L;
                }
            }
        }
    }

    private void testStrRnd(long offset, long pageSize) {
        Rnd rnd = new Rnd();
        int N = 1000;
        int M = 4;
        try (VirtualMemory mem = new VirtualMemory(pageSize);){
            int flag;
            int i;
            long o = offset;
            for (i = 0; i < N; ++i) {
                flag = rnd.nextInt();
                if (flag % 4 == 0) {
                    mem.putStr(o, null);
                    o += 4L;
                    continue;
                }
                if (flag % 2 == 0) {
                    mem.putStr(o, (CharSequence)"");
                    o += 4L;
                    continue;
                }
                mem.putStr(o, rnd.nextChars(4));
                o += 12L;
            }
            rnd.reset();
            o = offset;
            for (i = 0; i < N; ++i) {
                flag = rnd.nextInt();
                if (flag % 4 == 0) {
                    Assert.assertNull((Object)mem.getStr(o));
                    o += 4L;
                    continue;
                }
                if (flag % 2 == 0) {
                    TestUtils.assertEquals((CharSequence)"", mem.getStr(o));
                    o += 4L;
                    continue;
                }
                TestUtils.assertEquals(rnd.nextChars(4), mem.getStr(o));
                o += 12L;
            }
        }
    }
}

