/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.AppendMemory;
import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.CairoError;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.DefaultCairoConfiguration;
import com.questdb.cairo.TableModel;
import com.questdb.cairo.TableReader;
import com.questdb.cairo.TableReaderRecordCursor;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.TestFilesFacade;
import com.questdb.cairo.VirtualMemory;
import com.questdb.cairo.sql.Record;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.Chars;
import com.questdb.std.Files;
import com.questdb.std.FilesFacade;
import com.questdb.std.FilesFacadeImpl;
import com.questdb.std.NumericException;
import com.questdb.std.Rnd;
import com.questdb.std.Sinkable;
import com.questdb.std.Unsafe;
import com.questdb.std.microtime.DateFormat;
import com.questdb.std.microtime.DateFormatCompiler;
import com.questdb.std.microtime.DateFormatUtils;
import com.questdb.std.microtime.DateLocale;
import com.questdb.std.microtime.DateLocaleFactory;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.NativeLPSZ;
import com.questdb.std.str.Path;
import com.questdb.test.tools.TestUtils;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class TableWriterTest
extends AbstractCairoTest {
    public static final String PRODUCT = "product";
    private static final FilesFacade FF = FilesFacadeImpl.INSTANCE;
    private static final Log LOG = LogFactory.getLog(TableWriterTest.class);

    @Test
    public void tesFrequentCommit() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 100000;
            this.create(FF, 3, N);
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)PRODUCT);){
                long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
                Rnd rnd = new Rnd();
                for (int i = 0; i < N; ++i) {
                    ts = this.populateRow(writer, ts, rnd, 3600000000L);
                    writer.commit();
                }
            }
        });
    }

    @Test
    public void testAddColumnAndFailToReadTopFile() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 10000;
            this.create(FF, 0, N);
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)PRODUCT);){
                long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
                Rnd rnd = new Rnd();
                this.populateProducts(writer, rnd, ts, N, 60000000L);
                writer.addColumn((CharSequence)"xyz", 7);
                Assert.assertEquals((long)N, (long)writer.size());
            }
            class X
            extends FilesFacadeImpl {
                long fd = -1L;

                X() {
                }

                public long openRO(LPSZ name) {
                    if (Chars.endsWith((CharSequence)name, (CharSequence)"xyz.top")) {
                        this.fd = super.openRO(name);
                        return this.fd;
                    }
                    return super.openRO(name);
                }

                public long read(long fd, long buf, long len, long offset) {
                    if (fd == this.fd) {
                        this.fd = -1L;
                        return -1L;
                    }
                    return super.read(fd, buf, len, offset);
                }
            }
            final X ff = new X();
            try {
                new TableWriter((CairoConfiguration)new DefaultCairoConfiguration(root){
                    {
                        super(x0);
                    }

                    public FilesFacade getFilesFacade() {
                        return ff;
                    }
                }, (CharSequence)PRODUCT);
                Assert.fail();
            }
            catch (CairoException cairoException) {
                // empty catch block
            }
        });
    }

    @Test
    public void testAddColumnAndOpenWriterByDay() throws Exception {
        this.testAddColumnAndOpenWriter(0, 1000);
    }

    @Test
    public void testAddColumnAndOpenWriterByMonth() throws Exception {
        this.testAddColumnAndOpenWriter(1, 1000);
    }

    @Test
    public void testAddColumnAndOpenWriterByYear() throws Exception {
        this.testAddColumnAndOpenWriter(2, 1000);
    }

    @Test
    public void testAddColumnAndOpenWriterNonPartitioned() throws Exception {
        this.testAddColumnAndOpenWriter(3, 100000);
    }

    @Test
    public void testAddColumnCannotOpenTodo() throws Exception {
        this.testAddColumnRecoverableFault((FilesFacade)new TodoAppendDenyingFacade());
    }

    @Test
    public void testAddColumnCannotRemoveMeta() throws Exception {
        class X
        extends FilesFacadeImpl {
            X() {
            }

            public long openRW(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"abc.d")) {
                    return -1L;
                }
                return super.openRW(name);
            }

            public boolean remove(LPSZ name) {
                return !Chars.endsWith((CharSequence)name, (CharSequence)"_meta") && super.remove(name);
            }
        }
        this.testUnrecoverableAddColumn((FilesFacade)new X());
    }

    @Test
    public void testAddColumnCannotRenameMeta() throws Exception {
        this.testAddColumnRecoverableFault((FilesFacade)new MetaRenameDenyingFacade());
    }

    @Test
    public void testAddColumnCannotRenameMetaSwap() throws Exception {
        this.testAddColumnRecoverableFault((FilesFacade)new SwapMetaRenameDenyingFacade());
    }

    @Test
    public void testAddColumnCannotRenameMetaSwapAndUseIndexedPrevMeta() throws Exception {
        SwapMetaRenameDenyingFacade ff = new SwapMetaRenameDenyingFacade(){
            int count = 5;

            @Override
            public boolean rename(LPSZ from, LPSZ to) {
                return (!Chars.contains((CharSequence)to, (CharSequence)"_meta.prev") || --this.count <= 0) && super.rename(from, to);
            }
        };
        this.testAddColumnRecoverableFault((FilesFacade)ff);
    }

    @Test
    public void testAddColumnCannotTouchSymbolMapFile() throws Exception {
        FilesFacadeImpl ff = new FilesFacadeImpl(){

            public boolean touch(LPSZ path) {
                return !Chars.endsWith((CharSequence)path, (CharSequence)"abc.c") && super.touch(path);
            }
        };
        this.testAddColumnRecoverableFault((FilesFacade)ff);
    }

    @Test
    public void testAddColumnCommitPartitioned() throws Exception {
        int count = 10000;
        this.create(FF, 0, count);
        Rnd rnd = new Rnd();
        long interval = 60000000L;
        long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
        try (TableWriter writer = new TableWriter(configuration, (CharSequence)PRODUCT);){
            ts = this.populateProducts(writer, rnd, ts, count, interval);
            Assert.assertEquals((long)count, (long)writer.size());
            writer.addColumn((CharSequence)"abc", 7);
            ts = this.populateTable2(rnd, writer, ts, count, interval);
            Assert.assertEquals((long)(2 * count), (long)writer.size());
            writer.rollback();
        }
        writer = new TableWriter(configuration, (CharSequence)PRODUCT);
        var8_6 = null;
        try {
            this.populateTable2(rnd, writer, ts, count, interval);
            writer.commit();
            Assert.assertEquals((long)(2 * count), (long)writer.size());
        }
        catch (Throwable throwable) {
            var8_6 = throwable;
            throw throwable;
        }
        finally {
            if (writer != null) {
                if (var8_6 != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        var8_6.addSuppressed(throwable);
                    }
                } else {
                    writer.close();
                }
            }
        }
    }

    @Test
    public void testAddColumnDuplicate() throws Exception {
        long ts = this.populateTable(FF, 1);
        try (TableWriter writer = new TableWriter(configuration, (CharSequence)PRODUCT);){
            try {
                writer.addColumn((CharSequence)"supplier", 0);
                Assert.fail();
            }
            catch (CairoException cairoException) {
                // empty catch block
            }
            this.populateProducts(writer, new Rnd(), ts, 10000, 6000000L);
            writer.commit();
            Assert.assertEquals((long)20000L, (long)writer.size());
        }
    }

    @Test
    public void testAddColumnFailToRemoveSymbolMapFiles() throws Exception {
        this.testAddColumnRecoverableFault((FilesFacade)new FilesFacadeImpl(){

            public boolean exists(LPSZ path) {
                return Chars.endsWith((CharSequence)path, (CharSequence)"abc.k") || super.exists(path);
            }

            public boolean remove(LPSZ name) {
                return !Chars.endsWith((CharSequence)name, (CharSequence)"abc.k") && super.remove(name);
            }
        });
    }

    @Test
    public void testAddColumnFileOpenFail() throws Exception {
        this.testAddColumnRecoverableFault((FilesFacade)new FilesFacadeImpl(){

            public long openRW(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"abc.d")) {
                    return -1L;
                }
                return super.openRW(name);
            }
        });
    }

    @Test
    public void testAddColumnFileOpenFail2() throws Exception {
        this.testAddColumnRecoverableFault((FilesFacade)new FilesFacadeImpl(){

            public long openRW(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"abc.k")) {
                    return -1L;
                }
                return super.openRW(name);
            }
        });
    }

    @Test
    public void testAddColumnFileOpenFail3() throws Exception {
        this.testUnrecoverableAddColumn((FilesFacade)new FilesFacadeImpl(){
            int count = 1;

            public long openRW(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"abc.d")) {
                    return -1L;
                }
                return super.openRW(name);
            }

            public boolean rename(LPSZ from, LPSZ to) {
                return (!Chars.endsWith((CharSequence)from, (CharSequence)"_meta.prev") || --this.count != 0) && super.rename(from, to);
            }
        });
    }

    @Test
    public void testAddColumnFileOpenFail4() throws Exception {
        this.testAddColumnRecoverableFault((FilesFacade)new FilesFacadeImpl(){

            public long openRW(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"abc.d")) {
                    return -1L;
                }
                return super.openRW(name);
            }
        });
    }

    @Test
    public void testAddColumnFileOpenFailAndIndexedPrev() throws Exception {
        this.testUnrecoverableAddColumn((FilesFacade)new FilesFacadeImpl(){
            int count = 2;
            int toCount = 5;

            public long openRW(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"abc.d")) {
                    return -1L;
                }
                return super.openRW(name);
            }

            public boolean rename(LPSZ from, LPSZ to) {
                return !(Chars.contains((CharSequence)from, (CharSequence)"_meta.prev") && --this.count > 0 || Chars.contains((CharSequence)to, (CharSequence)"_meta.prev") && --this.toCount > 0 || !super.rename(from, to));
            }
        });
    }

    @Test
    public void testAddColumnHavingTroubleCreatingMetaSwap() throws Exception {
        int N = 10000;
        this.create(FF, 0, N);
        FilesFacadeImpl ff = new FilesFacadeImpl(){
            int count = 5;

            public boolean exists(LPSZ path) {
                return Chars.contains((CharSequence)path, (CharSequence)"_meta.swp") || super.exists(path);
            }

            public boolean remove(LPSZ name) {
                if (Chars.contains((CharSequence)name, (CharSequence)"_meta.swp")) {
                    return --this.count < 0;
                }
                return super.remove(name);
            }
        };
        try (TableWriter writer = new TableWriter((CairoConfiguration)new DefaultCairoConfiguration(root, (FilesFacade)ff){
            final /* synthetic */ FilesFacade val$ff;
            {
                this.val$ff = filesFacade;
                super(x0);
            }

            public FilesFacade getFilesFacade() {
                return this.val$ff;
            }
        }, (CharSequence)PRODUCT);){
            writer.addColumn((CharSequence)"xyz", 7);
            long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
            Rnd rnd = new Rnd();
            this.populateProducts(writer, rnd, ts, N, 360000000L);
            writer.commit();
            Assert.assertEquals((long)N, (long)writer.size());
        }
    }

    @Test
    public void testAddColumnMetaOpenFail() throws Exception {
        this.testUnrecoverableAddColumn((FilesFacade)new FilesFacadeImpl(){
            int counter = 2;

            public long openRO(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"_meta") && --this.counter == 0) {
                    return -1L;
                }
                return super.openRO(name);
            }
        });
    }

    @Test
    public void testAddColumnMetaSwapRenameFail2() throws Exception {
        this.testUnrecoverableAddColumn((FilesFacade)new FilesFacadeImpl(){
            int count = 1;

            public boolean remove(LPSZ name) {
                return (!Chars.endsWith((CharSequence)name, (CharSequence)"_todo") || --this.count != 0) && super.remove(name);
            }

            public boolean rename(LPSZ from, LPSZ to) {
                return !Chars.endsWith((CharSequence)from, (CharSequence)"_meta.swp") && super.rename(from, to);
            }
        });
    }

    @Test
    public void testAddColumnNonPartitioned() throws Exception {
        int N = 100000;
        this.create(FF, 3, N);
        try (TableWriter writer = new TableWriter(configuration, (CharSequence)PRODUCT);){
            writer.addColumn((CharSequence)"xyz", 7);
            long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
            Rnd rnd = new Rnd();
            this.populateProducts(writer, rnd, ts, N, 3600000000L);
            writer.commit();
            Assert.assertEquals((long)N, (long)writer.size());
        }
    }

    @Test
    public void testAddColumnPartitioned() throws Exception {
        int N = 10000;
        this.create(FF, 0, N);
        try (TableWriter writer = new TableWriter(configuration, (CharSequence)PRODUCT);){
            writer.addColumn((CharSequence)"xyz", 7);
            long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
            Rnd rnd = new Rnd();
            this.populateProducts(writer, rnd, ts, N, 60000000L);
            writer.commit();
            Assert.assertEquals((long)N, (long)writer.size());
        }
    }

    @Test
    public void testAddColumnRepairFail() throws Exception {
        class X
        extends FilesFacadeImpl {
            int counter = 2;

            X() {
            }

            public long openRO(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"_meta") && --this.counter == 0) {
                    return -1L;
                }
                return super.openRO(name);
            }

            public boolean remove(LPSZ name) {
                return !Chars.endsWith((CharSequence)name, (CharSequence)"_meta") && super.remove(name);
            }
        }
        this.testAddColumnErrorFollowedByRepairFail((FilesFacade)new X());
    }

    @Test
    public void testAddColumnRepairFail2() throws Exception {
        class X
        extends FilesFacadeImpl {
            int counter = 2;

            X() {
            }

            public long openRO(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"_meta") && --this.counter == 0) {
                    return -1L;
                }
                return super.openRO(name);
            }

            public boolean rename(LPSZ from, LPSZ to) {
                return !Chars.endsWith((CharSequence)from, (CharSequence)"_meta.prev") && super.rename(from, to);
            }
        }
        this.testAddColumnErrorFollowedByRepairFail((FilesFacade)new X());
    }

    @Test
    public void testAddColumnSwpFileDelete() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            this.populateTable(FF);
            class X
            extends FilesFacadeImpl {
                boolean deleteAttempted = false;

                X() {
                }

                public boolean exists(LPSZ path) {
                    return Chars.endsWith((CharSequence)path, (CharSequence)"_meta.swp") || super.exists(path);
                }

                public boolean remove(LPSZ name) {
                    if (Chars.endsWith((CharSequence)name, (CharSequence)"_meta.swp")) {
                        this.deleteAttempted = true;
                        return true;
                    }
                    return super.remove(name);
                }
            }
            final X ff = new X();
            try (TableWriter writer = new TableWriter((CairoConfiguration)new DefaultCairoConfiguration(root){
                {
                    super(x0);
                }

                public FilesFacade getFilesFacade() {
                    return ff;
                }
            }, (CharSequence)PRODUCT);){
                Assert.assertEquals((long)12L, (long)writer.columns.size());
                writer.addColumn((CharSequence)"abc", 7);
                Assert.assertEquals((long)14L, (long)writer.columns.size());
                Assert.assertTrue((boolean)ff.deleteAttempted);
            }
        });
    }

    @Test
    public void testAddColumnSwpFileDeleteFail() throws Exception {
        this.testAddColumnRecoverableFault((FilesFacade)new FilesFacadeImpl(){

            public boolean exists(LPSZ path) {
                return Chars.contains((CharSequence)path, (CharSequence)"_meta.swp") || super.exists(path);
            }

            public boolean remove(LPSZ name) {
                return !Chars.contains((CharSequence)name, (CharSequence)"_meta.swp") && super.remove(name);
            }
        });
    }

    @Test
    public void testAddColumnSwpFileMapFail() throws Exception {
        this.testAddColumnRecoverableFault((FilesFacade)new FilesFacadeImpl(){
            long fd = -1L;

            public long mmap(long fd, long len, long offset, int mode) {
                if (fd == this.fd) {
                    this.fd = -1L;
                    return -1L;
                }
                return super.mmap(fd, len, offset, mode);
            }

            public long openRW(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"_meta.swp")) {
                    this.fd = super.openRW(name);
                    return this.fd;
                }
                return super.openRW(name);
            }
        });
    }

    @Test
    public void testAddColumnToNonEmptyNonPartitioned() throws Exception {
        int n = 10000;
        this.create(FF, 3, n);
        this.populateAndColumnPopulate(n);
    }

    @Test
    public void testAddColumnToNonEmptyPartitioned() throws Exception {
        int n = 10000;
        this.create(FF, 0, n);
        this.populateAndColumnPopulate(n);
    }

    @Test
    public void testAddColumnTopFileWriteFail() throws Exception {
        this.testAddColumnRecoverableFault((FilesFacade)new FilesFacadeImpl(){
            long fd = -1L;

            public long append(long fd, long buf, int len) {
                if (fd == this.fd) {
                    this.fd = -1L;
                    return -1L;
                }
                return super.append(fd, buf, len);
            }

            public long openAppend(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"abc.top")) {
                    this.fd = super.openAppend(name);
                    return this.fd;
                }
                return super.openAppend(name);
            }
        });
    }

    @Test
    public void testAddUnsupportedIndex() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "x", 3).col("a", 8).cached(true).col("b", 7).timestamp();){
                CairoTestUtils.create(model);
            }
            int N = 1000;
            try (TableWriter w = new TableWriter(configuration, (CharSequence)"x");){
                TableWriter.Row r;
                Rnd rnd = new Rnd();
                for (int i = 0; i < 1000; ++i) {
                    r = w.newRow(0L);
                    r.putSym(0, rnd.nextChars(3));
                    r.putStr(1, rnd.nextChars(10));
                    r.append();
                }
                w.commit();
                try {
                    w.addColumn((CharSequence)"c", 7, 0, false, true, 1024);
                    Assert.fail();
                }
                catch (CairoException e) {
                    TestUtils.assertContains(e.getMessage(), "only supported");
                }
                for (int i = 0; i < 1000; ++i) {
                    r = w.newRow(0L);
                    r.putSym(0, rnd.nextChars(3));
                    r.putStr(1, rnd.nextChars(10));
                    r.append();
                }
                w.commit();
                w.addColumn((CharSequence)"c", 7, 0, false, false, 0);
            }
        });
    }

    @Test
    public void testAddUnsupportedIndexCapacity() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "x", 3).col("a", 8).cached(true).col("b", 7).timestamp();){
                CairoTestUtils.create(model);
            }
            int N = 1000;
            try (TableWriter w = new TableWriter(configuration, (CharSequence)"x");){
                TableWriter.Row r;
                Rnd rnd = new Rnd();
                for (int i = 0; i < 1000; ++i) {
                    r = w.newRow(0L);
                    r.putSym(0, rnd.nextChars(3));
                    r.putStr(1, rnd.nextChars(10));
                    r.append();
                }
                w.commit();
                try {
                    w.addColumn((CharSequence)"c", 8, 0, false, true, 0);
                    Assert.fail();
                }
                catch (CairoException e) {
                    TestUtils.assertContains(e.getMessage(), "Invalid index value block capacity");
                }
                for (int i = 0; i < 1000; ++i) {
                    r = w.newRow(0L);
                    r.putSym(0, rnd.nextChars(3));
                    r.putStr(1, rnd.nextChars(10));
                    r.append();
                }
                w.commit();
                w.addColumn((CharSequence)"c", 7, 0, false, false, 0);
            }
        });
    }

    @Test
    public void testAppendOutOfOrder() throws Exception {
        int N = 10000;
        this.create(FF, 3, N);
        this.testOutOfOrderRecords(N);
    }

    @Test
    public void testAppendOutOfOrderPartitioned() throws Exception {
        int N = 10000;
        this.create(FF, 0, N);
        this.testOutOfOrderRecords(N);
    }

    @Test
    public void testAutoCancelFirstRowNonPartitioned() throws Exception {
        int N = 10000;
        TestUtils.assertMemoryLeak(() -> {
            this.create(FF, 3, N);
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)PRODUCT);){
                long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
                TableWriter.Row r = writer.newRow(ts);
                r.putInt(0, 1234);
                this.populateProducts(writer, new Rnd(), ts, N, 3600000000L);
                Assert.assertEquals((long)N, (long)writer.size());
            }
        });
    }

    @Test
    public void testCachedSymbol() {
        this.testSymbolCacheFlag(true);
    }

    @Test
    public void testCancelFailureFollowedByTableClose() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 47;
            this.create(FF, 0, 47);
            Rnd rnd = new Rnd();
            class X
            extends FilesFacadeImpl {
                long fd = -1L;

                X() {
                }

                public long openRW(LPSZ name) {
                    if (Chars.endsWith((CharSequence)name, (CharSequence)"productName.i")) {
                        this.fd = super.openRW(name);
                        return this.fd;
                    }
                    return super.openRW(name);
                }

                public long read(long fd, long buf, long len, long offset) {
                    if (fd == this.fd) {
                        this.fd = -1L;
                        return -1L;
                    }
                    return super.read(fd, buf, len, offset);
                }
            }
            final X ff = new X();
            try (TableWriter writer = new TableWriter((CairoConfiguration)new DefaultCairoConfiguration(root){
                {
                    super(x0);
                }

                public FilesFacade getFilesFacade() {
                    return ff;
                }
            }, (CharSequence)PRODUCT);){
                long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
                ts = this.populateProducts(writer, rnd, ts, 47, 3600000000L);
                writer.commit();
                Assert.assertEquals((long)47L, (long)writer.size());
                TableWriter.Row r = writer.newRow(ts + 3600000000L);
                r.putInt(0, rnd.nextInt());
                try {
                    r.cancel();
                    Assert.fail();
                }
                catch (CairoException cairoException) {
                    // empty catch block
                }
            }
            writer = new TableWriter(configuration, (CharSequence)PRODUCT);
            var5_5 = null;
            try {
                Assert.assertEquals((long)47L, (long)writer.size());
            }
            catch (Throwable throwable) {
                var5_5 = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (var5_5 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            var5_5.addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        });
    }

    @Test
    public void testCancelFirstRowFailurePartitioned() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            class X
            extends FilesFacadeImpl {
                boolean fail = false;

                X() {
                }

                public long read(long fd, long buf, long len, long offset) {
                    if (this.fail) {
                        return -1L;
                    }
                    return super.read(fd, buf, len, offset);
                }
            }
            final X ff = new X();
            Rnd rnd = new Rnd();
            int N = 94;
            this.create((FilesFacade)ff, 0, N);
            long increment = 3600000000L;
            try (TableWriter writer = new TableWriter((CairoConfiguration)new DefaultCairoConfiguration(root){
                {
                    super(x0);
                }

                public FilesFacade getFilesFacade() {
                    return ff;
                }
            }, (CharSequence)PRODUCT);){
                long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
                ts = this.populateProducts(writer, rnd, ts, N / 2, increment);
                TableWriter.Row r = writer.newRow(ts += increment);
                r.putInt(0, rnd.nextPositiveInt());
                r.putStr(1, (CharSequence)rnd.nextString(7));
                r.putSym(2, (CharSequence)rnd.nextString(4));
                r.putSym(3, (CharSequence)rnd.nextString(11));
                r.putDouble(4, rnd.nextDouble2());
                ff.fail = true;
                try {
                    r.cancel();
                    Assert.fail();
                }
                catch (CairoException cairoException) {
                    // empty catch block
                }
                ff.fail = false;
                r.cancel();
                this.populateProducts(writer, rnd, ts, N / 2, increment);
                writer.commit();
                Assert.assertEquals((long)N, (long)writer.size());
                Assert.assertEquals((long)6L, (long)this.getDirCount());
            }
        });
    }

    @Test
    public void testCancelFirstRowNonPartitioned() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 10000;
            this.create(FF, 3, N);
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)PRODUCT);){
                long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
                TableWriter.Row r = writer.newRow(ts);
                r.putInt(0, 1234);
                r.cancel();
                this.populateProducts(writer, new Rnd(), ts, N, 3600000000L);
                Assert.assertEquals((long)N, (long)writer.size());
            }
        });
    }

    @Test
    public void testCancelFirstRowPartitioned() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            this.create(FF, 0, 4);
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)PRODUCT);){
                long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
                TableWriter.Row r = writer.newRow(ts);
                r.cancel();
                writer.commit();
                Assert.assertEquals((long)0L, (long)writer.size());
                Assert.assertEquals((long)2L, (long)this.getDirCount());
            }
        });
    }

    @Test
    public void testCancelFirstRowPartitioned2() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            long increment = 3600000000L;
            Rnd rnd = new Rnd();
            int N = 94;
            this.create(FF, 0, N);
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)PRODUCT);){
                long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
                ts = this.populateProducts(writer, rnd, ts, N / 2, 3600000000L);
                TableWriter.Row r = writer.newRow(ts += 3600000000L);
                r.putInt(0, rnd.nextPositiveInt());
                r.putStr(1, (CharSequence)rnd.nextString(7));
                r.putSym(2, (CharSequence)rnd.nextString(4));
                r.putSym(3, (CharSequence)rnd.nextString(11));
                r.putDouble(4, rnd.nextDouble2());
                for (int i = 0; i < 1000; ++i) {
                    r.cancel();
                }
                this.populateProducts(writer, rnd, ts, N / 2, 3600000000L);
                writer.commit();
                Assert.assertEquals((long)N, (long)writer.size());
                Assert.assertEquals((long)6L, (long)this.getDirCount());
            }
        });
    }

    @Test
    public void testCancelMidPartition() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            Rnd rnd = new Rnd();
            int N = 10000;
            this.create(FF, 0, 10000);
            try (VirtualMemory vmem = new VirtualMemory(FF.getPageSize());
                 TableWriter writer = new TableWriter(configuration, (CharSequence)PRODUCT);){
                long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
                int i = 0;
                int cancelCount = 0;
                while (i < 10000) {
                    TableWriter.Row r = writer.newRow(ts += 60000000L);
                    r.putInt(0, rnd.nextPositiveInt());
                    r.putStr(1, (CharSequence)rnd.nextString(7));
                    r.putSym(2, (CharSequence)rnd.nextString(4));
                    r.putSym(3, (CharSequence)rnd.nextString(11));
                    r.putDouble(4, rnd.nextDouble2());
                    if (rnd.nextPositiveInt() % 30 == 0) {
                        r.cancel();
                        ++cancelCount;
                        continue;
                    }
                    r.append();
                    r.append();
                    vmem.putLong(ts);
                    ++i;
                }
                writer.commit();
                Assert.assertEquals((long)10000L, (long)writer.size());
                Assert.assertTrue((cancelCount > 0 ? 1 : 0) != 0);
                this.verifyTimestampPartitions(vmem);
            }
        });
    }

    @Test
    public void testCancelMidRowNonPartitioned() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 10000;
            this.create(FF, 3, 10000);
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)PRODUCT);){
                TableWriter.Row r;
                long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
                int cancelCount = 0;
                Rnd rnd = new Rnd();
                int i = 0;
                while (i < 10000) {
                    r = writer.newRow(ts += 60000000L);
                    r.putInt(0, rnd.nextPositiveInt());
                    r.putStr(1, (CharSequence)rnd.nextString(7));
                    r.putSym(2, (CharSequence)rnd.nextString(4));
                    r.putSym(3, (CharSequence)rnd.nextString(11));
                    r.putDouble(4, rnd.nextDouble2());
                    if (rnd.nextBoolean()) {
                        r.append();
                        ++i;
                        continue;
                    }
                    ++cancelCount;
                }
                r = writer.newRow(ts);
                r.putSym(2, (CharSequence)"XYZ");
                writer.commit();
                Assert.assertTrue((cancelCount > 0 ? 1 : 0) != 0);
                Assert.assertEquals((long)10000L, (long)writer.size());
            }
        });
    }

    @Test
    public void testCancelRowAfterAddColumn() throws Exception {
        int N = 10000;
        this.create(FF, 0, N);
        Rnd rnd = new Rnd();
        long interval = 60000000L;
        long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
        try (TableWriter writer = new TableWriter(configuration, (CharSequence)PRODUCT);){
            ts = this.populateProducts(writer, rnd, ts, N, interval);
            Assert.assertEquals((long)N, (long)writer.size());
            writer.addColumn((CharSequence)"abc", 7);
            TableWriter.Row r = writer.newRow(ts);
            r.putInt(0, rnd.nextInt());
            r.cancel();
            Assert.assertEquals((long)0L, (long)((AppendMemory)writer.columns.getQuick(13)).getAppendOffset());
            ts = this.populateTable2(rnd, writer, ts, N, interval);
            Assert.assertEquals((long)(2 * N), (long)writer.size());
            writer.rollback();
        }
        writer = new TableWriter(configuration, (CharSequence)PRODUCT);
        var8_6 = null;
        try {
            this.populateTable2(rnd, writer, ts, N, interval);
            writer.commit();
            Assert.assertEquals((long)(2 * N), (long)writer.size());
        }
        catch (Throwable throwable) {
            var8_6 = throwable;
            throw throwable;
        }
        finally {
            if (writer != null) {
                if (var8_6 != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        var8_6.addSuppressed(throwable);
                    }
                } else {
                    writer.close();
                }
            }
        }
    }

    @Test
    public void testCancelRowRecovery() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            Rnd rnd = new Rnd();
            class X
            extends FilesFacadeImpl {
                boolean fail = false;

                X() {
                }

                public long read(long fd, long buf, long len, long offset) {
                    return this.fail ? -1L : super.read(fd, buf, len, offset);
                }

                public boolean rmdir(Path name) {
                    return !this.fail && super.rmdir(name);
                }
            }
            final X ff = new X();
            int N = 10000;
            this.create((FilesFacade)ff, 0, 10000);
            try (VirtualMemory vmem = new VirtualMemory(ff.getPageSize());
                 TableWriter writer = new TableWriter((CairoConfiguration)new DefaultCairoConfiguration(root){
                {
                    super(x0);
                }

                public FilesFacade getFilesFacade() {
                    return ff;
                }
            }, (CharSequence)PRODUCT);){
                long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
                int i = 0;
                int cancelCount = 0;
                while (i < 10000) {
                    TableWriter.Row r = writer.newRow(ts += 3600000000L);
                    r.putInt(0, rnd.nextPositiveInt());
                    r.putStr(1, (CharSequence)rnd.nextString(7));
                    r.putSym(2, (CharSequence)rnd.nextString(4));
                    r.putSym(3, (CharSequence)rnd.nextString(11));
                    r.putDouble(4, rnd.nextDouble2());
                    if (rnd.nextPositiveInt() % 50 == 0) {
                        ff.fail = true;
                        try {
                            r.cancel();
                            Assert.fail();
                        }
                        catch (CairoException cairoException) {
                            // empty catch block
                        }
                        ff.fail = false;
                        r.cancel();
                        ++cancelCount;
                        continue;
                    }
                    r.append();
                    r.append();
                    vmem.putLong(ts);
                    ++i;
                }
                writer.commit();
                Assert.assertEquals((long)10000L, (long)writer.size());
                Assert.assertTrue((cancelCount > 0 ? 1 : 0) != 0);
                this.verifyTimestampPartitions(vmem);
            }
        });
    }

    @Test
    public void testCancelRowRecoveryFromAppendPosErrors() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            Rnd rnd = new Rnd();
            class X
            extends FilesFacadeImpl {
                boolean fail = false;

                X() {
                }

                public long read(long fd, long buf, long len, long offset) {
                    if (this.fail) {
                        return -1L;
                    }
                    return super.read(fd, buf, len, offset);
                }
            }
            final X ff = new X();
            int N = 10000;
            this.create((FilesFacade)ff, 0, 10000);
            try (VirtualMemory vmem = new VirtualMemory(ff.getPageSize());
                 TableWriter writer = new TableWriter((CairoConfiguration)new DefaultCairoConfiguration(root){
                {
                    super(x0);
                }

                public FilesFacade getFilesFacade() {
                    return ff;
                }
            }, (CharSequence)PRODUCT);){
                long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
                int i = 0;
                int cancelCount = 0;
                int failCount = 0;
                while (i < 10000) {
                    TableWriter.Row r = writer.newRow(ts += 60000000L);
                    r.putInt(0, rnd.nextPositiveInt());
                    r.putStr(1, (CharSequence)rnd.nextString(7));
                    r.putSym(2, (CharSequence)rnd.nextString(4));
                    r.putSym(3, (CharSequence)rnd.nextString(11));
                    r.putDouble(4, rnd.nextDouble2());
                    if (rnd.nextPositiveInt() % 50 == 0) {
                        ff.fail = true;
                        try {
                            r.cancel();
                        }
                        catch (CairoException ignored) {
                            ++failCount;
                            ff.fail = false;
                            r.cancel();
                        }
                        ++cancelCount;
                        continue;
                    }
                    r.append();
                    r.append();
                    vmem.putLong(ts);
                    ++i;
                }
                writer.commit();
                Assert.assertEquals((long)10000L, (long)writer.size());
                Assert.assertTrue((cancelCount > 0 ? 1 : 0) != 0);
                Assert.assertTrue((failCount > 0 ? 1 : 0) != 0);
                this.verifyTimestampPartitions(vmem);
            }
        });
    }

    @Test
    public void testCannotCreatePartitionDir() throws Exception {
        this.testConstructor((FilesFacade)new FilesFacadeImpl(){

            public int mkdirs(LPSZ path, int mode) {
                if (Chars.endsWith((CharSequence)path, (CharSequence)("default" + Files.SEPARATOR))) {
                    return -1;
                }
                return super.mkdirs(path, mode);
            }
        });
    }

    @Test
    public void testCannotLock() throws Exception {
        this.create(FF, 3, 4);
        TestUtils.assertMemoryLeak(() -> {
            final TestFilesFacade ff = new TestFilesFacade(){
                boolean ran = false;

                public long openRW(LPSZ name) {
                    if (Chars.endsWith((CharSequence)name, (CharSequence)"product.lock")) {
                        this.ran = true;
                        return -1L;
                    }
                    return super.openRW(name);
                }

                @Override
                public boolean wasCalled() {
                    return this.ran;
                }
            };
            try {
                new TableWriter((CairoConfiguration)new DefaultCairoConfiguration(root){

                    public FilesFacade getFilesFacade() {
                        return ff;
                    }
                }, (CharSequence)PRODUCT);
                Assert.fail();
            }
            catch (CairoException cairoException) {
                // empty catch block
            }
            Assert.assertTrue((boolean)ff.wasCalled());
        });
    }

    @Test
    public void testCannotMapTxFile() throws Exception {
        this.testConstructor((FilesFacade)new FilesFacadeImpl(){
            int count = 2;
            long fd = -1L;

            public long mmap(long fd, long len, long offset, int mode) {
                if (fd == this.fd) {
                    this.fd = -1L;
                    return -1L;
                }
                return super.mmap(fd, len, offset, mode);
            }

            public long openRW(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"_txn") && --this.count == 0) {
                    this.fd = super.openRW(name);
                    return this.fd;
                }
                return super.openRW(name);
            }
        });
    }

    @Test
    public void testCannotOpenColumnFile() throws Exception {
        this.testConstructor((FilesFacade)new FilesFacadeImpl(){

            public long openRW(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"productName.i")) {
                    return -1L;
                }
                return super.openRW(name);
            }
        });
    }

    @Test
    public void testCannotOpenSymbolMap() throws Exception {
        int N = 100;
        this.create(FF, 3, 100);
        this.populateTable0(FF, 100);
        this.testConstructor((FilesFacade)new FilesFacadeImpl(){

            public boolean exists(LPSZ path) {
                return !Chars.endsWith((CharSequence)path, (CharSequence)"category.o") && super.exists(path);
            }
        }, false);
    }

    @Test
    public void testCannotOpenTodo() throws Exception {
        this.testConstructor((FilesFacade)new FilesFacadeImpl(){

            public boolean exists(LPSZ path) {
                return Chars.endsWith((CharSequence)path, (CharSequence)"_todo") || super.exists(path);
            }
        });
    }

    @Test
    public void testCannotOpenTxFile() throws Exception {
        this.testConstructor((FilesFacade)new FilesFacadeImpl(){
            int count = 2;

            public long openRW(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"_txn") && --this.count == 0) {
                    return -1L;
                }
                return super.openRW(name);
            }
        });
    }

    @Test
    public void testCannotSetAppendPosition() throws Exception {
        int N = 10000;
        this.create(FF, 3, 10000);
        this.populateTable0(FF, 10000);
        this.testConstructor((FilesFacade)new FilesFacadeImpl(){
            long fd;

            public long mmap(long fd, long len, long offset, int mode) {
                if (fd == this.fd) {
                    return -1L;
                }
                return super.mmap(fd, len, offset, mode);
            }

            public long openRW(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"supplier.d")) {
                    this.fd = super.openRW(name);
                    return this.fd;
                }
                return super.openRW(name);
            }
        }, false);
    }

    @Test
    public void testCannotSetAppendPositionOnDataFile() throws Exception {
        int N = 10000;
        this.create(FF, 3, 10000);
        this.populateTable0(FF, 10000);
        this.testConstructor((FilesFacade)new FilesFacadeImpl(){
            long fd;

            public long openRW(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"productName.d")) {
                    this.fd = super.openRW(name);
                    return this.fd;
                }
                return super.openRW(name);
            }

            public long read(long fd, long buf, long len, long offset) {
                if (fd == this.fd) {
                    this.fd = -1L;
                    return -1L;
                }
                return super.read(fd, buf, len, offset);
            }
        }, false);
    }

    @Test
    public void testCannotSetAppendPositionOnIndexFile() throws Exception {
        int N = 10000;
        this.create(FF, 3, 10000);
        this.populateTable0(FF, 10000);
        this.testConstructor((FilesFacade)new FilesFacadeImpl(){
            long fd;

            public long openRW(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"productName.i")) {
                    this.fd = super.openRW(name);
                    return this.fd;
                }
                return super.openRW(name);
            }

            public long read(long fd, long buf, long len, long offset) {
                if (fd == this.fd) {
                    this.fd = -1L;
                    return -1L;
                }
                return super.read(fd, buf, len, offset);
            }
        }, false);
    }

    @Test
    public void testCannotTruncateColumnOnClose() throws Exception {
        int N = 100000;
        this.create(FF, 3, N);
        this.testTruncateOnClose(new TestFilesFacade(){
            long fd = -1L;
            int count = 1;
            boolean ran = false;

            public boolean isRestrictedFileSystem() {
                return false;
            }

            public long openRW(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"price.d")) {
                    this.fd = super.openRW(name);
                    return this.fd;
                }
                return super.openRW(name);
            }

            public boolean truncate(long fd, long size) {
                if (this.fd == fd && this.count-- == 0) {
                    this.ran = true;
                    return false;
                }
                return super.truncate(fd, size);
            }

            @Override
            public boolean wasCalled() {
                return this.fd != -1L && this.ran;
            }
        }, N);
    }

    @Test
    public void testCannotTruncateColumnOnCloseAndNotSupported() throws Exception {
        int N = 100000;
        this.create(FF, 3, N);
        this.testTruncateOnClose(new TestFilesFacade(){
            long fd = -1L;
            int count = 1;
            boolean ran = false;

            public boolean isRestrictedFileSystem() {
                return true;
            }

            public long openRW(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"price.d")) {
                    this.fd = super.openRW(name);
                    return this.fd;
                }
                return super.openRW(name);
            }

            public boolean truncate(long fd, long size) {
                if (this.fd == fd && this.count-- == 0) {
                    this.ran = true;
                    return false;
                }
                return super.truncate(fd, size);
            }

            @Override
            public boolean wasCalled() {
                return this.fd != -1L && this.ran;
            }
        }, N);
    }

    @Test
    public void testCannotTruncateColumnOnCloseAndNotSupported2() throws Exception {
        int N = 100000;
        this.create(FF, 3, N);
        this.testTruncateOnClose(new TestFilesFacade(){
            long fd = -1L;
            int count = 1;
            boolean ran = false;

            public boolean isRestrictedFileSystem() {
                return true;
            }

            public long openRW(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"price.d")) {
                    this.fd = super.openRW(name);
                    return this.fd;
                }
                return super.openRW(name);
            }

            public boolean truncate(long fd, long size) {
                if (this.fd == fd && this.count-- <= 0) {
                    this.ran = true;
                    return false;
                }
                return super.truncate(fd, size);
            }

            @Override
            public boolean wasCalled() {
                return this.fd != -1L && this.ran;
            }
        }, N);
    }

    @Test
    public void testConstructorTruncatedTodo() throws Exception {
        FilesFacadeImpl ff = new FilesFacadeImpl(){
            long fd = 7686876823L;

            public boolean exists(LPSZ path) {
                return Chars.endsWith((CharSequence)path, (CharSequence)"_todo") || super.exists(path);
            }

            public long openRO(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"_todo")) {
                    return this.fd;
                }
                return super.openRO(name);
            }

            public long read(long fd, long buf, long len, long offset) {
                if (fd == this.fd) {
                    this.fd = -1L;
                    return -1L;
                }
                return super.read(fd, buf, len, offset);
            }
        };
        this.populateTable((FilesFacade)ff);
    }

    @Test
    public void testDayPartition() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 10000;
            this.create(FF, 0, N);
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)PRODUCT);){
                this.populateProducts(writer, new Rnd(), DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z"), N, 60000000L);
                writer.commit();
                Assert.assertEquals((long)N, (long)writer.size());
            }
            writer = new TableWriter(configuration, (CharSequence)PRODUCT);
            var3_3 = null;
            try {
                Assert.assertEquals((long)N, (long)writer.size());
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (var3_3 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        });
    }

    @Test
    public void testDayPartitionTruncate() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            long ts;
            int N = 10000;
            this.create(FF, 0, N);
            Rnd rnd = new Rnd();
            long increment = 60000000L;
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)PRODUCT);){
                ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
                for (int k = 0; k < 3; ++k) {
                    ts = this.populateProducts(writer, rnd, ts, N, increment);
                    writer.commit();
                    Assert.assertEquals((long)N, (long)writer.size());
                    writer.truncate();
                }
            }
            writer = new TableWriter(configuration, (CharSequence)PRODUCT);
            var6_5 = null;
            try {
                ts = DateFormatUtils.parseDateTime((CharSequence)"2014-03-04T00:00:00.000Z");
                Assert.assertEquals((long)0L, (long)writer.size());
                this.populateProducts(writer, rnd, ts, N, increment);
                writer.commit();
                Assert.assertEquals((long)N, (long)writer.size());
            }
            catch (Throwable throwable) {
                var6_5 = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (var6_5 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            var6_5.addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        });
    }

    @Test
    public void testDayPartitionTruncateDirIterateFail() throws Exception {
        this.testTruncate(new CountingFilesFacade(){

            public int findNext(long findPtr) {
                if (--this.count == 0L) {
                    throw CairoException.instance((int)0).put((CharSequence)"FindNext failed");
                }
                return super.findNext(findPtr);
            }
        }, true);
    }

    @Test
    public void testDayPartitionTruncateError() throws Exception {
        this.testTruncate(new CountingFilesFacade(){

            public boolean truncate(long fd, long size) {
                return --this.count != 0L && super.truncate(fd, size);
            }
        }, true);
    }

    @Test
    public void testDayPartitionTruncateErrorConstructorRecovery() throws Exception {
        class X
        extends CountingFilesFacade {
            X() {
            }

            public boolean truncate(long fd, long size) {
                return --this.count != 0L && super.truncate(fd, size);
            }
        }
        this.testTruncate(new X(), false);
    }

    @Test
    public void testDefaultPartition() throws Exception {
        this.populateTable(FF);
    }

    @Test
    public void testFailureToOpenArchiveFile() throws Exception {
        this.testCommitRetryAfterFailure(new CountingFilesFacade(){

            public long openAppend(LPSZ name) {
                if (--this.count < 1L) {
                    return -1L;
                }
                return super.openAppend(name);
            }
        });
    }

    @Test
    public void testFailureToWriteArchiveFile() throws Exception {
        this.testCommitRetryAfterFailure(new CountingFilesFacade(){
            long fd = -1L;

            public long openAppend(LPSZ name) {
                if (--this.count < 1L) {
                    this.fd = super.openAppend(name);
                    return this.fd;
                }
                return super.openAppend(name);
            }

            public long write(long fd, long address, long len, long offset) {
                if (fd == this.fd) {
                    this.fd = -1L;
                    return -1L;
                }
                return super.write(fd, address, len, offset);
            }
        });
    }

    @Test
    public void testGetColumnIndex() {
        CairoTestUtils.createAllTable(configuration, 3);
        try (TableWriter writer = new TableWriter(configuration, (CharSequence)"all");){
            Assert.assertEquals((long)1L, (long)writer.getColumnIndex((CharSequence)"short"));
            try {
                writer.getColumnIndex((CharSequence)"bad");
                Assert.fail();
            }
            catch (CairoException cairoException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testIncorrectTodoCode() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            Throwable throwable;
            CairoTestUtils.createAllTable(configuration, 3);
            long buf = Unsafe.malloc((long)8L);
            try {
                Unsafe.getUnsafe().putLong(buf, 89808823424L);
                throwable = null;
                try (Path path = new Path().of(root).concat((CharSequence)"all").concat((CharSequence)"_todo").$();){
                    long fd = Files.openRW((LPSZ)path);
                    Assert.assertTrue((fd != -1L ? 1 : 0) != 0);
                    Assert.assertEquals((long)8L, (long)Files.write((long)fd, (long)buf, (long)8L, (long)0L));
                    Files.close((long)fd);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            finally {
                Unsafe.free((long)buf, (long)8L);
            }
            throwable = null;
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"all");){
                Assert.assertNotNull((Object)writer);
                Assert.assertTrue((boolean)writer.isOpen());
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        });
    }

    @Test
    public void testMetaFileDoesNotExist() throws Exception {
        this.testConstructor((FilesFacade)new FilesFacadeImpl(){

            public long openRO(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"_meta")) {
                    return -1L;
                }
                return super.openRO(name);
            }
        });
    }

    @Test
    public void testNonStandardPageSize() throws Exception {
        this.populateTable((FilesFacade)new FilesFacadeImpl(){

            public long getPageSize() {
                return super.getPageSize() * super.getPageSize();
            }
        }, 1);
    }

    @Test
    public void testNonStandardPageSize2() throws Exception {
        this.populateTable((FilesFacade)new FilesFacadeImpl(){

            public long getPageSize() {
                return 0x2000000L;
            }
        }, 2);
    }

    @Test
    public void testNulls() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            CairoTestUtils.createAllTable(configuration, 3);
            Rnd rnd = new Rnd();
            long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
            ts = this.testAppendNulls(rnd, ts);
            this.testAppendNulls(rnd, ts);
        });
    }

    @Test
    public void testOpenUnsupportedIndex() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "x", 3).col("a", 8).cached(true).col("b", 7).col("c", 7).indexed(true, 1024).timestamp();){
                CairoTestUtils.create(model);
            }
            try {
                new TableWriter(configuration, (CharSequence)"x");
                Assert.fail();
            }
            catch (CairoException e) {
                TestUtils.assertContains(e.getMessage(), "only supported");
            }
        });
    }

    @Test
    public void testOpenWriterMissingTxFile() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            CairoTestUtils.createAllTable(configuration, 3);
            try (Path path = new Path();){
                Assert.assertTrue((boolean)FF.remove((LPSZ)path.of(root).concat((CharSequence)"all").concat((CharSequence)"_txn").$()));
                try {
                    new TableWriter(configuration, (CharSequence)"all");
                    Assert.fail();
                }
                catch (CairoException cairoException) {
                    // empty catch block
                }
            }
        });
    }

    @Test
    public void testOutOfOrderAfterReopen() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            CairoTestUtils.createAllTable(configuration, 3);
            Rnd rnd = new Rnd();
            long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
            this.testAppendNulls(rnd, ts);
            try {
                this.testAppendNulls(rnd, ts);
                Assert.fail();
            }
            catch (CairoException cairoException) {
                // empty catch block
            }
        });
    }

    @Test
    public void testRemoveColumnAfterTimestamp() throws Exception {
        try (TableModel model = new TableModel(configuration, "ABC", 0).col("productId", 3).col("productName", 7).timestamp().col("supplier", 8).col("category", 8).col("price", 6);){
            CairoTestUtils.create(model);
            this.testRemoveColumn(model);
        }
    }

    @Test
    public void testRemoveColumnBeforeTimestamp() throws Exception {
        try (TableModel model = new TableModel(configuration, "ABC", 0).col("productId", 3).col("productName", 7).col("supplier", 8).col("category", 8).col("price", 6).timestamp();){
            CairoTestUtils.create(model);
            this.testRemoveColumn(model);
        }
    }

    @Test
    public void testRemoveColumnCannotAppendTodo() throws Exception {
        this.testRemoveColumnRecoverableFailure(new TodoAppendDenyingFacade());
    }

    @Test
    public void testRemoveColumnCannotMMapSwap() throws Exception {
        class X
        extends TestFilesFacade {
            long fd = -1L;
            boolean hit = false;

            X() {
            }

            public long mmap(long fd, long len, long offset, int mode) {
                if (fd == this.fd) {
                    this.fd = -1L;
                    this.hit = true;
                    return -1L;
                }
                return super.mmap(fd, len, offset, mode);
            }

            public long openRW(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"_meta.swp")) {
                    this.fd = super.openRW(name);
                    return this.fd;
                }
                return super.openRW(name);
            }

            @Override
            public boolean wasCalled() {
                return this.hit;
            }
        }
        this.testRemoveColumnRecoverableFailure(new X());
    }

    @Test
    public void testRemoveColumnCannotOpenSwap() throws Exception {
        class X
        extends TestFilesFacade {
            boolean hit = false;

            X() {
            }

            public long openRW(LPSZ name) {
                if (Chars.contains((CharSequence)name, (CharSequence)"_meta.swp")) {
                    this.hit = true;
                    return -1L;
                }
                return super.openRW(name);
            }

            @Override
            public boolean wasCalled() {
                return this.hit;
            }
        }
        this.testRemoveColumnRecoverableFailure(new X());
    }

    @Test
    public void testRemoveColumnCannotOpenTodo() throws Exception {
        this.testRemoveColumnRecoverableFailure(new TodoOpenDenyingFacade());
    }

    @Test
    public void testRemoveColumnCannotRemoveAnyMetadataPrev() throws Exception {
        this.testRemoveColumnRecoverableFailure(new TestFilesFacade(){
            int exists = 0;
            int removes = 0;

            public boolean exists(LPSZ path) {
                if (Chars.contains((CharSequence)path, (CharSequence)"_meta.prev")) {
                    ++this.exists;
                    return true;
                }
                return super.exists(path);
            }

            public boolean remove(LPSZ name) {
                if (Chars.contains((CharSequence)name, (CharSequence)"_meta.prev")) {
                    ++this.removes;
                    return false;
                }
                return super.remove(name);
            }

            @Override
            public boolean wasCalled() {
                return this.exists > 0 && this.removes > 0;
            }
        });
    }

    @Test
    public void testRemoveColumnCannotRemoveFiles() throws Exception {
        this.removeColumn(new TestFilesFacade(){
            int count = 0;

            public boolean remove(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"supplier.d")) {
                    ++this.count;
                    return false;
                }
                return super.remove(name);
            }

            @Override
            public boolean wasCalled() {
                return this.count > 0;
            }
        });
    }

    @Test
    public void testRemoveColumnCannotRemoveFiles2() throws Exception {
        this.removeColumn(new TestFilesFacade(){
            int count = 0;

            public boolean remove(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"supplier.k")) {
                    ++this.count;
                    return false;
                }
                return super.remove(name);
            }

            @Override
            public boolean wasCalled() {
                return this.count > 0;
            }
        });
    }

    @Test
    public void testRemoveColumnCannotRemoveSomeMetadataPrev() throws Exception {
        this.removeColumn(new TestFilesFacade(){
            int count = 5;

            public boolean exists(LPSZ path) {
                if (Chars.contains((CharSequence)path, (CharSequence)"_meta.prev") && --this.count > 0) {
                    return true;
                }
                return super.exists(path);
            }

            public boolean remove(LPSZ name) {
                return !Chars.contains((CharSequence)name, (CharSequence)"_meta.prev") && super.remove(name);
            }

            @Override
            public boolean wasCalled() {
                return this.count <= 0;
            }
        });
    }

    @Test
    public void testRemoveColumnCannotRemoveSwap() throws Exception {
        class X
        extends TestFilesFacade {
            boolean hit = false;

            X() {
            }

            public boolean exists(LPSZ path) {
                return Chars.contains((CharSequence)path, (CharSequence)"_meta.swp") || super.exists(path);
            }

            public boolean remove(LPSZ name) {
                if (Chars.contains((CharSequence)name, (CharSequence)"_meta.swp")) {
                    this.hit = true;
                    return false;
                }
                return super.remove(name);
            }

            @Override
            public boolean wasCalled() {
                return this.hit;
            }
        }
        this.testRemoveColumnRecoverableFailure(new X());
    }

    @Test
    public void testRemoveColumnCannotRenameMeta() throws Exception {
        this.testRemoveColumnRecoverableFailure(new MetaRenameDenyingFacade());
    }

    @Test
    public void testRemoveColumnCannotRenameMetaSwap() throws Exception {
        this.testRemoveColumnRecoverableFailure(new SwapMetaRenameDenyingFacade());
    }

    @Test
    public void testRemoveColumnUnrecoverableRemoveTodoFailure() throws Exception {
        class X
        extends FilesFacadeImpl {
            int count = 1;

            X() {
            }

            public boolean remove(LPSZ name) {
                return (!Chars.endsWith((CharSequence)name, (CharSequence)"_todo") || --this.count != 0) && super.remove(name);
            }
        }
        this.testUnrecoverableRemoveColumn((FilesFacade)new X());
    }

    @Test
    public void testRemoveColumnUnrecoverableRenameFailure() throws Exception {
        class X
        extends FilesFacadeImpl {
            int count = 2;

            X() {
            }

            public boolean rename(LPSZ from, LPSZ to) {
                if (Chars.endsWith((CharSequence)to, (CharSequence)"_meta") && this.count-- > 0) {
                    return false;
                }
                return super.rename(from, to);
            }
        }
        this.testUnrecoverableRemoveColumn((FilesFacade)new X());
    }

    @Test
    public void testRemoveTimestamp() throws Exception {
        try (TableModel model = new TableModel(configuration, "ABC", 3).col("productId", 3).col("productName", 7).col("category", 8).col("price", 6).timestamp().col("supplier", 8);){
            CairoTestUtils.create(model);
            long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
            Rnd rnd = new Rnd();
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)model.getName());){
                this.append10KProducts(ts, rnd, writer);
                writer.removeColumn((CharSequence)"timestamp");
                this.append10KNoTimestamp(rnd, writer);
                writer.commit();
                Assert.assertEquals((long)20000L, (long)writer.size());
            }
            writer = new TableWriter(configuration, (CharSequence)model.getName());
            var7_8 = null;
            try {
                this.append10KNoTimestamp(rnd, writer);
                writer.commit();
                Assert.assertEquals((long)30000L, (long)writer.size());
            }
            catch (Throwable throwable) {
                var7_8 = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (var7_8 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            var7_8.addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        }
    }

    @Test
    public void testRemoveTimestampFromPartitionedTable() {
        try (TableModel model = new TableModel(configuration, "ABC", 0).col("productId", 3).col("productName", 7).col("category", 8).col("price", 6).timestamp().col("supplier", 8);){
            CairoTestUtils.create(model);
        }
        var2_2 = null;
        try (TableWriter writer = new TableWriter(configuration, (CharSequence)"ABC");){
            try {
                writer.removeColumn((CharSequence)"timestamp");
                Assert.fail();
            }
            catch (CairoException cairoException) {
                // empty catch block
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testRollbackNonPartitioned() throws Exception {
        int N = 20000;
        this.create(FF, 3, 20000);
        this.testRollback(20000);
    }

    @Test
    public void testRollbackPartitionRemoveFailure() throws Exception {
        int N = 10000;
        this.create(FF, 0, 10000);
        class X
        extends FilesFacadeImpl {
            boolean removeAttempted = false;

            X() {
            }

            public boolean rmdir(Path name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"2013-03-12")) {
                    this.removeAttempted = true;
                    return false;
                }
                return super.rmdir(name);
            }
        }
        final X ff = new X();
        long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
        long increment = 60000000L;
        Rnd rnd = new Rnd();
        try (TableWriter writer = new TableWriter((CairoConfiguration)new DefaultCairoConfiguration(root){
            {
                super(x0);
            }

            public FilesFacade getFilesFacade() {
                return ff;
            }
        }, (CharSequence)PRODUCT);){
            ts = this.populateProducts(writer, rnd, ts, 10000, 60000000L);
            writer.commit();
            long timestampAfterCommit = ts;
            this.populateProducts(writer, rnd, ts, 10000, 60000000L);
            Assert.assertEquals((long)20000L, (long)writer.size());
            writer.rollback();
            Assert.assertTrue((boolean)ff.removeAttempted);
            ts = timestampAfterCommit;
            writer.newRow(ts).cancel();
            this.populateProducts(writer, rnd, ts, 10000, 60000000L);
            writer.commit();
            Assert.assertEquals((long)20000L, (long)writer.size());
        }
    }

    @Test
    public void testRollbackPartitioned() throws Exception {
        int N = 20000;
        this.create(FF, 0, N);
        this.testRollback(N);
    }

    @Test
    public void testSetAppendPositionFailureBin1() throws Exception {
        this.testSetAppendPositionFailure("bin.d");
    }

    @Test
    public void testSetAppendPositionFailureBin2() throws Exception {
        this.testSetAppendPositionFailure("bin.i");
    }

    @Test
    public void testSinglePartitionTruncate() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            this.create(FF, 2, 4);
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)PRODUCT);){
                writer.truncate();
                Assert.assertEquals((long)0L, (long)writer.size());
            }
            writer = new TableWriter(configuration, (CharSequence)PRODUCT);
            var2_2 = null;
            try {
                Assert.assertEquals((long)0L, (long)writer.size());
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (var2_2 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        });
    }

    @Test
    public void testSkipOverSpuriousDir() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            this.create(FF, 0, 10);
            try (Path path = new Path();){
                path.of(configuration.getRoot()).concat((CharSequence)PRODUCT).concat((CharSequence)"somethingortheother").put(Files.SEPARATOR).$();
                Assert.assertEquals((long)0L, (long)configuration.getFilesFacade().mkdirs((LPSZ)path, configuration.getMkDirMode()));
                new TableWriter(configuration, (CharSequence)PRODUCT).close();
                Assert.assertFalse((boolean)configuration.getFilesFacade().exists((LPSZ)path));
            }
        });
    }

    @Test
    public void testTableDoesNotExist() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try {
                new TableWriter(configuration, (CharSequence)PRODUCT);
                Assert.fail();
            }
            catch (CairoException e) {
                LOG.info().$((Sinkable)e).$();
            }
        });
    }

    @Test
    public void testTableLock() {
        CairoTestUtils.createAllTable(configuration, 3);
        try (TableWriter ignored = new TableWriter(configuration, (CharSequence)"all");){
            try {
                new TableWriter(configuration, (CharSequence)"all");
                Assert.fail();
            }
            catch (CairoException cairoException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testToString() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            this.create(FF, 3, 4);
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)PRODUCT);){
                Assert.assertEquals((Object)"TableWriter{name=product}", (Object)writer.toString());
            }
        });
    }

    @Test
    public void testTruncateCannotAppendTodo() throws Exception {
        this.testTruncateRecoverableFailure((FilesFacade)new TodoAppendDenyingFacade());
    }

    @Test
    public void testTruncateCannotCreateTodo() throws Exception {
        this.testTruncateRecoverableFailure((FilesFacade)new TodoOpenDenyingFacade());
    }

    @Test
    public void testTruncateCannotRemoveTodo() throws Exception {
        class X
        extends FilesFacadeImpl {
            X() {
            }

            public boolean remove(LPSZ name) {
                return !Chars.endsWith((CharSequence)name, (CharSequence)"_todo") && super.remove(name);
            }
        }
        final X ff = new X();
        int N = 1000;
        this.create((FilesFacade)ff, 0, 1000);
        Rnd rnd = new Rnd();
        long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
        try (TableWriter writer = new TableWriter((CairoConfiguration)new DefaultCairoConfiguration(root){
            {
                super(x0);
            }

            public FilesFacade getFilesFacade() {
                return ff;
            }
        }, (CharSequence)PRODUCT);){
            ts = this.populateProducts(writer, rnd, ts, 1000, 3600000000L);
            writer.commit();
            try {
                writer.truncate();
                Assert.fail();
            }
            catch (CairoError cairoError) {
                // empty catch block
            }
            Assert.assertEquals((long)0L, (long)writer.size());
        }
        writer = new TableWriter(configuration, (CharSequence)PRODUCT);
        var7_6 = null;
        try {
            this.populateProducts(writer, rnd, ts, 1000, 3600000000L);
            writer.commit();
            Assert.assertEquals((long)1000L, (long)writer.size());
        }
        catch (Throwable throwable) {
            var7_6 = throwable;
            throw throwable;
        }
        finally {
            if (writer != null) {
                if (var7_6 != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        var7_6.addSuppressed(throwable);
                    }
                } else {
                    writer.close();
                }
            }
        }
    }

    @Test
    public void testTwoByteUtf8() {
        String name = "\u0441\u043e\u043e\u0442\u0435\u0447\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a";
        try (TableModel model = new TableModel(configuration, name, 3).col("\u0441\u0435\u043a\u044c\u044e\u0440\u0438\u0442\u0438", 7).timestamp();){
            CairoTestUtils.create(model);
        }
        Rnd rnd = new Rnd();
        try (TableWriter writer = new TableWriter(configuration, (CharSequence)name);){
            for (int i = 0; i < 1000000; ++i) {
                TableWriter.Row r = writer.newRow(0L);
                r.putStr(0, rnd.nextChars(5));
                r.append();
            }
            writer.commit();
            writer.addColumn((CharSequence)"\u043c\u0438\u0442\u0438\u043d\u0433", 3);
            Assert.assertEquals((long)0L, (long)writer.getColumnIndex((CharSequence)"\u0441\u0435\u043a\u044c\u044e\u0440\u0438\u0442\u0438"));
            Assert.assertEquals((long)2L, (long)writer.getColumnIndex((CharSequence)"\u043c\u0438\u0442\u0438\u043d\u0433"));
        }
        rnd.reset();
        var4_6 = null;
        try (TableReader reader = new TableReader(configuration, (CharSequence)name);){
            int col = reader.getMetadata().getColumnIndex((CharSequence)"\u0441\u0435\u043a\u044c\u044e\u0440\u0438\u0442\u0438");
            TableReaderRecordCursor cursor = reader.getCursor();
            Record r = cursor.getRecord();
            while (cursor.hasNext()) {
                TestUtils.assertEquals(rnd.nextChars(5), r.getStr(col));
            }
        }
        catch (Throwable throwable) {
            var4_6 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testTxCannotMap() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            class X
            extends CountingFilesFacade {
                X() {
                }

                public long mmap(long fd, long len, long offset, int mode) {
                    if (--this.count > 0L) {
                        return super.mmap(fd, len, offset, mode);
                    }
                    return -1L;
                }
            }
            final X ff = new X();
            this.create((FilesFacade)ff, 3, 4);
            try {
                ff.count = 0L;
                new TableWriter((CairoConfiguration)new DefaultCairoConfiguration(root){
                    {
                        super(x0);
                    }

                    public FilesFacade getFilesFacade() {
                        return ff;
                    }
                }, (CharSequence)PRODUCT);
                Assert.fail();
            }
            catch (CairoException cairoException) {
                // empty catch block
            }
        });
    }

    @Test
    public void testTxFileDoesNotExist() throws Exception {
        this.testConstructor((FilesFacade)new FilesFacadeImpl(){

            public boolean exists(LPSZ path) {
                return !Chars.endsWith((CharSequence)path, (CharSequence)"_txn") && super.exists(path);
            }
        });
    }

    @Test
    public void testUnCachedSymbol() {
        this.testSymbolCacheFlag(false);
    }

    private long append10KNoSupplier(long ts, Rnd rnd, TableWriter writer) {
        int productId = writer.getColumnIndex((CharSequence)"productId");
        int productName = writer.getColumnIndex((CharSequence)"productName");
        int category = writer.getColumnIndex((CharSequence)"category");
        int price = writer.getColumnIndex((CharSequence)"price");
        for (int i = 0; i < 10000; ++i) {
            TableWriter.Row r = writer.newRow(ts += 60000000L);
            r.putInt(productId, rnd.nextPositiveInt());
            r.putStr(productName, (CharSequence)rnd.nextString(4));
            r.putSym(category, (CharSequence)rnd.nextString(11));
            r.putDouble(price, rnd.nextDouble2());
            r.append();
        }
        return ts;
    }

    private void append10KNoTimestamp(Rnd rnd, TableWriter writer) {
        int productId = writer.getColumnIndex((CharSequence)"productId");
        int productName = writer.getColumnIndex((CharSequence)"productName");
        int supplier = writer.getColumnIndex((CharSequence)"supplier");
        int category = writer.getColumnIndex((CharSequence)"category");
        int price = writer.getColumnIndex((CharSequence)"price");
        for (int i = 0; i < 10000; ++i) {
            TableWriter.Row r = writer.newRow(0L);
            r.putInt(productId, rnd.nextPositiveInt());
            r.putStr(productName, (CharSequence)rnd.nextString(10));
            r.putSym(supplier, (CharSequence)rnd.nextString(4));
            r.putSym(category, (CharSequence)rnd.nextString(11));
            r.putDouble(price, rnd.nextDouble2());
            r.append();
        }
    }

    private long append10KProducts(long ts, Rnd rnd, TableWriter writer) {
        int productId = writer.getColumnIndex((CharSequence)"productId");
        int productName = writer.getColumnIndex((CharSequence)"productName");
        int supplier = writer.getColumnIndex((CharSequence)"supplier");
        int category = writer.getColumnIndex((CharSequence)"category");
        int price = writer.getColumnIndex((CharSequence)"price");
        for (int i = 0; i < 10000; ++i) {
            TableWriter.Row r = writer.newRow(ts += 60000000L);
            r.putInt(productId, rnd.nextPositiveInt());
            r.putStr(productName, (CharSequence)rnd.nextString(10));
            r.putSym(supplier, (CharSequence)rnd.nextString(4));
            r.putSym(category, (CharSequence)rnd.nextString(11));
            r.putDouble(price, rnd.nextDouble2());
            r.append();
        }
        return ts;
    }

    private void appendAndAssert10K(long ts, Rnd rnd) {
        try (TableWriter writer = new TableWriter(configuration, (CharSequence)PRODUCT);){
            Assert.assertEquals((long)12L, (long)writer.columns.size());
            this.populateProducts(writer, rnd, ts, 10000, 60000000L);
            writer.commit();
            Assert.assertEquals((long)30000L, (long)writer.size());
        }
    }

    private void create(final FilesFacade ff, int partitionBy, int N) {
        try (TableModel model = new TableModel((CairoConfiguration)new DefaultCairoConfiguration(root){

            public FilesFacade getFilesFacade() {
                return ff;
            }
        }, PRODUCT, partitionBy).col("productId", 3).col("productName", 7).col("supplier", 8).symbolCapacity(N).col("category", 8).symbolCapacity(N).col("price", 6).timestamp();){
            CairoTestUtils.create(model);
        }
    }

    private int getDirCount() {
        AtomicInteger count = new AtomicInteger();
        try (Path path = new Path();){
            FF.iterateDir((LPSZ)path.of(root).concat((CharSequence)PRODUCT).$(), (name, type) -> {
                if (type == 4) {
                    count.incrementAndGet();
                }
            });
        }
        return count.get();
    }

    private void populateAndColumnPopulate(int n) throws NumericException {
        Rnd rnd = new Rnd();
        long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
        long interval = 60000000L;
        try (TableWriter writer = new TableWriter(configuration, (CharSequence)PRODUCT);){
            ts = this.populateProducts(writer, rnd, ts, n, interval);
            writer.commit();
            Assert.assertEquals((long)n, (long)writer.size());
            writer.addColumn((CharSequence)"abc", 7);
            ts = this.populateTable2(rnd, writer, ts, n, interval);
            writer.commit();
            Assert.assertEquals((long)(2 * n), (long)writer.size());
        }
        writer = new TableWriter(configuration, (CharSequence)PRODUCT);
        var8_6 = null;
        try {
            this.populateTable2(rnd, writer, ts, n, interval);
            Assert.assertEquals((long)(3 * n), (long)writer.size());
            writer.commit();
            Assert.assertEquals((long)(3 * n), (long)writer.size());
        }
        catch (Throwable throwable) {
            var8_6 = throwable;
            throw throwable;
        }
        finally {
            if (writer != null) {
                if (var8_6 != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        var8_6.addSuppressed(throwable);
                    }
                } else {
                    writer.close();
                }
            }
        }
    }

    private long populateProducts(TableWriter writer, Rnd rnd, long ts, int count, long increment) {
        for (int i = 0; i < count; ++i) {
            ts = this.populateRow(writer, ts, rnd, increment);
        }
        return ts;
    }

    private long populateRow(TableWriter writer, long ts, Rnd rnd, long increment) {
        TableWriter.Row r = writer.newRow(ts += increment);
        r.putInt(0, rnd.nextPositiveInt());
        r.putStr(1, (CharSequence)rnd.nextString(7));
        r.putSym(2, (CharSequence)rnd.nextString(4));
        r.putSym(3, (CharSequence)rnd.nextString(11));
        r.putDouble(4, rnd.nextDouble2());
        r.append();
        return ts;
    }

    long populateTable(FilesFacade ff) throws NumericException {
        return this.populateTable(ff, 0);
    }

    long populateTable(FilesFacade ff, int partitionBy) throws NumericException {
        int N = 10000;
        long used = Unsafe.getMemUsed();
        long fileCount = ff.getOpenFileCount();
        this.create(ff, partitionBy, N);
        long ts = this.populateTable0(ff, N);
        Assert.assertEquals((long)used, (long)Unsafe.getMemUsed());
        Assert.assertEquals((long)fileCount, (long)ff.getOpenFileCount());
        return ts;
    }

    private long populateTable0(final FilesFacade ff, int N) throws NumericException {
        try (TableWriter writer = new TableWriter((CairoConfiguration)new DefaultCairoConfiguration(root){

            public FilesFacade getFilesFacade() {
                return ff;
            }
        }, (CharSequence)PRODUCT);){
            long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
            ts = this.populateProducts(writer, new Rnd(), ts, N, 60000000L);
            writer.commit();
            Assert.assertEquals((long)N, (long)writer.size());
            long l = ts;
            return l;
        }
    }

    private long populateTable2(Rnd rnd, TableWriter writer, long ts, int n, long interval) {
        for (int i = 0; i < n; ++i) {
            TableWriter.Row r = writer.newRow(ts += interval);
            r.putInt(0, rnd.nextPositiveInt());
            r.putStr(1, (CharSequence)rnd.nextString(7));
            r.putSym(2, (CharSequence)rnd.nextString(4));
            r.putSym(3, (CharSequence)rnd.nextString(11));
            r.putDouble(4, rnd.nextDouble2());
            r.putStr(6, (CharSequence)rnd.nextString(5));
            r.append();
        }
        return ts;
    }

    private void removeColumn(final TestFilesFacade ff) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            String name = "ABC";
            try (TableModel model = new TableModel(configuration, name, 3).col("productId", 3).col("productName", 7).col("supplier", 8).col("category", 8).col("price", 6).timestamp();){
                CairoTestUtils.create(model);
            }
            long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
            Rnd rnd = new Rnd();
            try (TableWriter writer = new TableWriter((CairoConfiguration)new DefaultCairoConfiguration(root){

                public FilesFacade getFilesFacade() {
                    return ff;
                }
            }, (CharSequence)name);){
                ts = this.append10KProducts(ts, rnd, writer);
                writer.removeColumn((CharSequence)"supplier");
                Assert.assertTrue((boolean)ff.wasCalled());
                ts = this.append10KNoSupplier(ts, rnd, writer);
                writer.commit();
                Assert.assertEquals((long)20000L, (long)writer.size());
            }
            writer = new TableWriter(configuration, (CharSequence)name);
            var7_12 = null;
            try {
                this.append10KNoSupplier(ts, rnd, writer);
                writer.commit();
                Assert.assertEquals((long)30000L, (long)writer.size());
            }
            catch (Throwable throwable) {
                var7_12 = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (var7_12 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            var7_12.addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        });
    }

    private void testAddColumnAndOpenWriter(int partitionBy, int N) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
            Rnd rnd = new Rnd();
            this.create(FF, partitionBy, N);
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)PRODUCT);){
                ts = this.populateProducts(writer, rnd, ts, N, 3600000000L);
                writer.commit();
                Assert.assertEquals((long)N, (long)writer.size());
            }
            writer = new TableWriter(configuration, (CharSequence)PRODUCT);
            var7_6 = null;
            try {
                writer.addColumn((CharSequence)"xyz", 7);
            }
            catch (Throwable throwable) {
                var7_6 = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (var7_6 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            var7_6.addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
            writer = new TableWriter(configuration, (CharSequence)PRODUCT);
            var7_6 = null;
            try {
                for (int i = 0; i < N; ++i) {
                    TableWriter.Row r = writer.newRow(ts += 3600000000L);
                    r.putInt(0, rnd.nextPositiveInt());
                    r.putStr(1, (CharSequence)rnd.nextString(7));
                    r.putSym(2, (CharSequence)rnd.nextString(4));
                    r.putSym(3, (CharSequence)rnd.nextString(11));
                    r.putDouble(4, rnd.nextDouble2());
                    r.putStr(6, (CharSequence)rnd.nextString(10));
                    r.append();
                }
                writer.commit();
                Assert.assertEquals((long)(N * 2), (long)writer.size());
            }
            catch (Throwable throwable) {
                var7_6 = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (var7_6 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            var7_6.addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        });
    }

    private void testAddColumnErrorFollowedByRepairFail(final FilesFacade ff) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

                public FilesFacade getFilesFacade() {
                    return ff;
                }
            };
            long ts = this.populateTable(FF);
            Rnd rnd = new Rnd();
            try (TableWriter writer = new TableWriter((CairoConfiguration)configuration, (CharSequence)PRODUCT);){
                ts = this.populateProducts(writer, rnd, ts, 10000, 60000000L);
                writer.commit();
                Assert.assertEquals((long)20000L, (long)writer.size());
                Assert.assertEquals((long)12L, (long)writer.columns.size());
                try {
                    writer.addColumn((CharSequence)"abc", 7);
                    Assert.fail();
                }
                catch (CairoError cairoError) {
                    // empty catch block
                }
            }
            try {
                new TableWriter((CairoConfiguration)configuration, (CharSequence)PRODUCT);
                Assert.fail();
            }
            catch (CairoException cairoException) {
                // empty catch block
            }
            this.appendAndAssert10K(ts, rnd);
        });
    }

    private void testAddColumnRecoverableFault(final FilesFacade ff) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            long ts = this.populateTable(FF);
            Rnd rnd = new Rnd();
            DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

                public FilesFacade getFilesFacade() {
                    return ff;
                }
            };
            try (TableWriter writer = new TableWriter((CairoConfiguration)configuration, (CharSequence)PRODUCT);){
                Assert.assertEquals((long)12L, (long)writer.columns.size());
                ts = this.populateProducts(writer, rnd, ts, 10000, 60000000L);
                writer.commit();
                try {
                    writer.addColumn((CharSequence)"abc", 8);
                    Assert.fail();
                }
                catch (CairoException cairoException) {
                    // empty catch block
                }
                ts = this.populateProducts(writer, rnd, ts, 10000, 60000000L);
                writer.commit();
                Assert.assertEquals((long)30000L, (long)writer.size());
            }
            writer = new TableWriter((CairoConfiguration)configuration, (CharSequence)PRODUCT);
            var7_6 = null;
            try {
                this.populateProducts(writer, rnd, ts, 10000, 60000000L);
                writer.commit();
                Assert.assertEquals((long)40000L, (long)writer.size());
            }
            catch (Throwable throwable) {
                var7_6 = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (var7_6 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            var7_6.addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long testAppendNulls(Rnd rnd, long ts) {
        int blobLen = 65536;
        long blob = Unsafe.malloc((long)65536L);
        try (TableWriter writer = new TableWriter((CairoConfiguration)new DefaultCairoConfiguration(root){

            public FilesFacade getFilesFacade() {
                return FF;
            }
        }, (CharSequence)"all");){
            long size = writer.size();
            for (int i = 0; i < 10000; ++i) {
                TableWriter.Row r = writer.newRow(ts += 3600000000L);
                if (rnd.nextBoolean()) {
                    r.putByte(2, rnd.nextByte());
                }
                if (rnd.nextBoolean()) {
                    r.putBool(8, rnd.nextBoolean());
                }
                if (rnd.nextBoolean()) {
                    r.putShort(1, rnd.nextShort());
                }
                if (rnd.nextBoolean()) {
                    r.putInt(0, rnd.nextInt());
                }
                if (rnd.nextBoolean()) {
                    r.putDouble(3, rnd.nextDouble2());
                }
                if (rnd.nextBoolean()) {
                    r.putFloat(4, rnd.nextFloat2());
                }
                if (rnd.nextBoolean()) {
                    r.putLong(5, rnd.nextLong());
                }
                if (rnd.nextBoolean()) {
                    r.putDate(10, ts);
                }
                if (rnd.nextBoolean()) {
                    rnd.nextChars(blob, 32768);
                    r.putBin(9, blob, 65536L);
                }
                r.append();
            }
            writer.commit();
            Assert.assertFalse((boolean)writer.inTransaction());
            Assert.assertEquals((long)(size + 10000L), (long)writer.size());
        }
        finally {
            Unsafe.free((long)blob, (long)65536L);
        }
        return ts;
    }

    void testCommitRetryAfterFailure(final CountingFilesFacade ff) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            long failureCount = 0L;
            int N = 10000;
            this.create((FilesFacade)ff, 0, 10000);
            boolean valid = false;
            try (TableWriter writer = new TableWriter((CairoConfiguration)new DefaultCairoConfiguration(root){

                public FilesFacade getFilesFacade() {
                    return ff;
                }
            }, (CharSequence)PRODUCT);){
                long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
                Rnd rnd = new Rnd();
                for (int i = 0; i < 10000; ++i) {
                    boolean fail;
                    ts = this.populateRow(writer, ts, rnd, 600000000L);
                    if (rnd.nextPositiveInt() % 100 != 0) continue;
                    boolean bl = fail = rnd.nextPositiveInt() % 20 == 0;
                    if (fail) {
                        try {
                            ff.count = writer.getTxPartitionCount() - 1;
                            valid = valid || writer.getTxPartitionCount() > 1;
                            writer.commit();
                            ff.count = Long.MAX_VALUE;
                        }
                        catch (CairoException ignore) {
                            ++failureCount;
                            ff.count = Long.MAX_VALUE;
                            writer.commit();
                        }
                        continue;
                    }
                    writer.commit();
                }
            }
            Assert.assertTrue((boolean)valid);
            Assert.assertTrue((failureCount > 0L ? 1 : 0) != 0);
        });
    }

    private void testConstructor(FilesFacade ff) throws Exception {
        this.testConstructor(ff, true);
    }

    private void testConstructor(final FilesFacade ff, boolean create) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            if (create) {
                this.create(ff, 3, 4);
            }
            try {
                new TableWriter((CairoConfiguration)new DefaultCairoConfiguration(root){

                    public FilesFacade getFilesFacade() {
                        return ff;
                    }
                }, (CharSequence)PRODUCT);
                Assert.fail();
            }
            catch (CairoException e) {
                LOG.info().$((Sinkable)e).$();
            }
        });
    }

    private void testOutOfOrderRecords(int N) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)PRODUCT);){
                long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
                Rnd rnd = new Rnd();
                int i = 0;
                long failureCount = 0L;
                while (i < N) {
                    boolean fail = rnd.nextBoolean();
                    if (fail) {
                        try {
                            writer.newRow(0L);
                            Assert.fail();
                        }
                        catch (CairoException ignore) {
                            ++failureCount;
                        }
                        continue;
                    }
                    TableWriter.Row r = writer.newRow(ts += 360000000L);
                    r.putInt(0, rnd.nextPositiveInt());
                    r.putStr(1, (CharSequence)rnd.nextString(7));
                    r.putSym(2, (CharSequence)rnd.nextString(4));
                    r.putSym(3, (CharSequence)rnd.nextString(11));
                    r.putDouble(4, rnd.nextDouble2());
                    r.append();
                    ++i;
                }
                writer.commit();
                Assert.assertEquals((long)N, (long)writer.size());
                Assert.assertTrue((failureCount > 0L ? 1 : 0) != 0);
            }
            writer = new TableWriter(configuration, (CharSequence)PRODUCT);
            var2_2 = null;
            try {
                Assert.assertEquals((long)N, (long)writer.size());
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (var2_2 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            var2_2.addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        });
    }

    private void testRemoveColumn(TableModel model) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            CairoTestUtils.create(model);
            long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
            Rnd rnd = new Rnd();
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)model.getName());){
                writer.warmUp();
                ts = this.append10KProducts(ts, rnd, writer);
                writer.removeColumn((CharSequence)"supplier");
                NativeLPSZ lpsz = new NativeLPSZ();
                try (Path path = new Path();){
                    path.of(root).concat((CharSequence)model.getName());
                    int plen = path.length();
                    FF.iterateDir((LPSZ)path.$(), (file, type) -> {
                        lpsz.of(file);
                        if (type == 4 && !Chars.equals((CharSequence)lpsz, (char)'.') && !Chars.equals((CharSequence)lpsz, (CharSequence)"..")) {
                            Assert.assertFalse((boolean)FF.exists((LPSZ)path.trimTo(plen).concat((CharSequence)lpsz).concat((CharSequence)"supplier.i").$()));
                            Assert.assertFalse((boolean)FF.exists((LPSZ)path.trimTo(plen).concat((CharSequence)lpsz).concat((CharSequence)"supplier.d").$()));
                            Assert.assertFalse((boolean)FF.exists((LPSZ)path.trimTo(plen).concat((CharSequence)lpsz).concat((CharSequence)"supplier.top").$()));
                        }
                    });
                }
                ts = this.append10KNoSupplier(ts, rnd, writer);
                writer.commit();
                Assert.assertEquals((long)20000L, (long)writer.size());
            }
            writer = new TableWriter(configuration, (CharSequence)model.getName());
            var6_5 = null;
            try {
                this.append10KNoSupplier(ts, rnd, writer);
                writer.commit();
                Assert.assertEquals((long)30000L, (long)writer.size());
            }
            catch (Throwable throwable) {
                var6_5 = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (var6_5 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            var6_5.addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        });
    }

    private void testRemoveColumnRecoverableFailure(final TestFilesFacade ff) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            this.create(FF, 0, 10000);
            long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
            Rnd rnd = new Rnd();
            try (TableWriter writer = new TableWriter((CairoConfiguration)new DefaultCairoConfiguration(root){

                public FilesFacade getFilesFacade() {
                    return ff;
                }
            }, (CharSequence)PRODUCT);){
                ts = this.append10KProducts(ts, rnd, writer);
                writer.commit();
                try {
                    writer.removeColumn((CharSequence)"productName");
                    Assert.fail();
                }
                catch (CairoException cairoException) {
                    // empty catch block
                }
                Assert.assertTrue((boolean)ff.wasCalled());
                ts = this.append10KProducts(ts, rnd, writer);
                writer.commit();
            }
            writer = new TableWriter(configuration, (CharSequence)PRODUCT);
            var6_5 = null;
            try {
                this.append10KProducts(ts, rnd, writer);
                writer.commit();
                Assert.assertEquals((long)30000L, (long)writer.size());
            }
            catch (Throwable throwable) {
                var6_5 = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (var6_5 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            var6_5.addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        });
    }

    private void testRollback(int N) throws NumericException {
        long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
        Rnd rnd = new Rnd();
        long increment = 60000000L;
        try (TableWriter writer = new TableWriter(configuration, (CharSequence)PRODUCT);){
            ts = this.populateProducts(writer, rnd, ts, N / 2, 60000000L);
            writer.commit();
            long timestampAfterCommit = ts;
            this.populateProducts(writer, rnd, ts, N / 2, 60000000L);
            Assert.assertEquals((long)N, (long)writer.size());
            writer.rollback();
            Assert.assertEquals((long)(N / 2), (long)writer.size());
            writer.rollback();
            Assert.assertEquals((long)(N / 2), (long)writer.size());
            ts = timestampAfterCommit;
            writer.newRow(ts).cancel();
            this.populateProducts(writer, rnd, ts, N / 2, 60000000L);
            writer.commit();
            Assert.assertEquals((long)N, (long)writer.size());
        }
    }

    private void testSetAppendPositionFailure(final String failFile) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            CairoTestUtils.createAllTable(configuration, 3);
            class X
            extends FilesFacadeImpl {
                long fd = -1L;

                X() {
                }

                public long openRW(LPSZ name) {
                    if (Chars.endsWith((CharSequence)name, (CharSequence)failFile)) {
                        this.fd = super.openRW(name);
                        return this.fd;
                    }
                    return super.openRW(name);
                }

                public long read(long fd, long buf, long len, long offset) {
                    if (fd == this.fd) {
                        this.fd = -1L;
                        return -1L;
                    }
                    return super.read(fd, buf, len, offset);
                }
            }
            final X ff = new X();
            this.testAppendNulls(new Rnd(), DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z"));
            try {
                new TableWriter((CairoConfiguration)new DefaultCairoConfiguration(root){
                    {
                        super(x0);
                    }

                    public FilesFacade getFilesFacade() {
                        return ff;
                    }
                }, (CharSequence)"all");
                Assert.fail();
            }
            catch (CairoException cairoException) {
                // empty catch block
            }
        });
    }

    private void testSymbolCacheFlag(boolean cacheFlag) {
        try (TableModel model = new TableModel(configuration, "x", 3).col("a", 8).cached(cacheFlag).col("b", 7).col("c", 8).cached(!cacheFlag).timestamp();){
            CairoTestUtils.create(model);
        }
        int N = 1000;
        Rnd rnd = new Rnd();
        try (TableWriter writer = new TableWriter(configuration, (CharSequence)"x");){
            Assert.assertEquals((Object)cacheFlag, (Object)writer.isSymbolMapWriterCached(0));
            Assert.assertNotEquals((Object)cacheFlag, (Object)writer.isSymbolMapWriterCached(2));
            for (int i = 0; i < N; ++i) {
                TableWriter.Row r = writer.newRow(0L);
                r.putSym(0, rnd.nextChars(5));
                r.putStr(1, rnd.nextChars(10));
                r.append();
            }
            writer.commit();
        }
        var5_9 = null;
        try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
            rnd.reset();
            int count = 0;
            Assert.assertEquals((Object)cacheFlag, (Object)reader.isColumnCached(0));
            Assert.assertNotEquals((Object)cacheFlag, (Object)reader.isColumnCached(2));
            TableReaderRecordCursor cursor = reader.getCursor();
            Record record = cursor.getRecord();
            while (cursor.hasNext()) {
                TestUtils.assertEquals(rnd.nextChars(5), record.getSym(0));
                TestUtils.assertEquals(rnd.nextChars(10), record.getStr(1));
                ++count;
            }
            Assert.assertEquals((long)N, (long)count);
        }
        catch (Throwable throwable) {
            var5_9 = throwable;
            throw throwable;
        }
    }

    private void testTruncate(final CountingFilesFacade ff, boolean retry) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            long ts;
            int N = 200;
            this.create((FilesFacade)ff, 0, N);
            Rnd rnd = new Rnd();
            long increment = 3600000000L;
            DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

                public FilesFacade getFilesFacade() {
                    return ff;
                }
            };
            try (TableWriter writer = new TableWriter((CairoConfiguration)configuration, (CharSequence)PRODUCT);){
                ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
                for (int k = 0; k < 3; ++k) {
                    ts = this.populateProducts(writer, rnd, ts, N, 3600000000L);
                    writer.commit();
                    Assert.assertEquals((long)N, (long)writer.size());
                    try {
                        ff.count = 3L;
                        writer.truncate();
                        Assert.fail();
                    }
                    catch (CairoException e) {
                        LOG.info().$((Sinkable)e).$();
                    }
                    if (retry) {
                        writer.truncate();
                        continue;
                    }
                    break;
                }
            }
            writer = new TableWriter((CairoConfiguration)configuration, (CharSequence)PRODUCT);
            var9_8 = null;
            try {
                ts = DateFormatUtils.parseDateTime((CharSequence)"2014-03-04T00:00:00.000Z");
                Assert.assertEquals((long)0L, (long)writer.size());
                this.populateProducts(writer, rnd, ts, 1000, 3600000000L);
                writer.commit();
                Assert.assertEquals((long)1000L, (long)writer.size());
            }
            catch (Throwable throwable) {
                var9_8 = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (var9_8 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            var9_8.addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
            writer = new TableWriter((CairoConfiguration)configuration, (CharSequence)PRODUCT);
            var9_8 = null;
            try {
                Assert.assertEquals((long)1000L, (long)writer.size());
            }
            catch (Throwable throwable) {
                var9_8 = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (var9_8 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            var9_8.addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        });
    }

    private void testTruncateOnClose(final TestFilesFacade ff, int N) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableWriter writer = new TableWriter((CairoConfiguration)new DefaultCairoConfiguration(root){

                public FilesFacade getFilesFacade() {
                    return ff;
                }
            }, (CharSequence)PRODUCT);){
                long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
                Rnd rnd = new Rnd();
                this.populateProducts(writer, rnd, ts, N, 3600000000L);
                writer.commit();
                Assert.assertEquals((long)N, (long)writer.size());
            }
            Assert.assertTrue((boolean)ff.wasCalled());
        });
    }

    private void testTruncateRecoverableFailure(final FilesFacade ff) throws NumericException {
        int N = 1000;
        this.create(ff, 0, 2000);
        Rnd rnd = new Rnd();
        DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

            public FilesFacade getFilesFacade() {
                return ff;
            }
        };
        long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
        try (TableWriter writer = new TableWriter((CairoConfiguration)configuration, (CharSequence)PRODUCT);){
            ts = this.populateProducts(writer, rnd, ts, 1000, 3600000000L);
            writer.commit();
            try {
                writer.truncate();
                Assert.fail();
            }
            catch (CairoException cairoException) {
                // empty catch block
            }
            Assert.assertEquals((long)1000L, (long)writer.size());
        }
        writer = new TableWriter((CairoConfiguration)configuration, (CharSequence)PRODUCT);
        var8_7 = null;
        try {
            this.populateProducts(writer, rnd, ts, 1000, 3600000000L);
            writer.commit();
            Assert.assertEquals((long)2000L, (long)writer.size());
        }
        catch (Throwable throwable) {
            var8_7 = throwable;
            throw throwable;
        }
        finally {
            if (writer != null) {
                if (var8_7 != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable) {
                        var8_7.addSuppressed(throwable);
                    }
                } else {
                    writer.close();
                }
            }
        }
    }

    private void testUnrecoverableAddColumn(final FilesFacade ff) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            long ts = this.populateTable(FF);
            Rnd rnd = new Rnd();
            try (TableWriter writer = new TableWriter((CairoConfiguration)new DefaultCairoConfiguration(root){

                public FilesFacade getFilesFacade() {
                    return ff;
                }
            }, (CharSequence)PRODUCT);){
                ts = this.populateProducts(writer, rnd, ts, 10000, 60000000L);
                writer.commit();
                Assert.assertEquals((long)12L, (long)writer.columns.size());
                try {
                    writer.addColumn((CharSequence)"abc", 7);
                    Assert.fail();
                }
                catch (CairoError cairoError) {
                    // empty catch block
                }
            }
            this.appendAndAssert10K(ts, rnd);
        });
    }

    private void testUnrecoverableRemoveColumn(final FilesFacade ff) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

                public FilesFacade getFilesFacade() {
                    return ff;
                }
            };
            int N = 20000;
            this.create(FF, 0, 20000);
            long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
            Rnd rnd = new Rnd();
            try (TableWriter writer = new TableWriter((CairoConfiguration)configuration, (CharSequence)PRODUCT);){
                ts = this.append10KProducts(ts, rnd, writer);
                writer.commit();
                try {
                    writer.removeColumn((CharSequence)"supplier");
                    Assert.fail();
                }
                catch (CairoError cairoError) {
                    // empty catch block
                }
            }
            writer = new TableWriter((CairoConfiguration)configuration, (CharSequence)PRODUCT);
            var8_7 = null;
            try {
                this.append10KProducts(ts, rnd, writer);
                writer.commit();
                Assert.assertEquals((long)20000L, (long)writer.size());
            }
            catch (Throwable throwable) {
                var8_7 = throwable;
                throw throwable;
            }
            finally {
                if (writer != null) {
                    if (var8_7 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable) {
                            var8_7.addSuppressed(throwable);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
        });
    }

    void verifyTimestampPartitions(VirtualMemory vmem) {
        DateFormatCompiler compiler = new DateFormatCompiler();
        DateFormat fmt = compiler.compile((CharSequence)"yyyy-MM-dd");
        DateLocale enGb = DateLocaleFactory.INSTANCE.getDateLocale((CharSequence)"en-gb");
        try (Path vp = new Path();){
            for (int i = 0; i < 10000; ++i) {
                vp.of(root).concat((CharSequence)PRODUCT).put(Files.SEPARATOR);
                fmt.format(vmem.getLong((long)(i * 8)), enGb, (CharSequence)"UTC", (CharSink)vp);
                if (FF.exists((LPSZ)vp.$())) continue;
                Assert.fail();
            }
        }
    }

    class CountingFilesFacade
    extends FilesFacadeImpl {
        long count = Long.MAX_VALUE;

        CountingFilesFacade() {
        }
    }

    private static class TodoAppendDenyingFacade
    extends TestFilesFacade {
        long fd = -1L;
        boolean hit = false;

        private TodoAppendDenyingFacade() {
        }

        public long append(long fd, long buf, int len) {
            if (fd == this.fd) {
                this.fd = -1L;
                this.hit = true;
                return -1L;
            }
            return super.append(fd, buf, len);
        }

        public long openAppend(LPSZ name) {
            if (Chars.endsWith((CharSequence)name, (CharSequence)"_todo")) {
                this.fd = super.openAppend(name);
                return this.fd;
            }
            return super.openAppend(name);
        }

        @Override
        public boolean wasCalled() {
            return this.hit;
        }
    }

    private static class TodoOpenDenyingFacade
    extends TestFilesFacade {
        boolean hit = false;

        private TodoOpenDenyingFacade() {
        }

        public long openAppend(LPSZ name) {
            if (Chars.endsWith((CharSequence)name, (CharSequence)"_todo")) {
                this.hit = true;
                return -1L;
            }
            return super.openAppend(name);
        }

        @Override
        public boolean wasCalled() {
            return this.hit;
        }
    }

    private static class MetaRenameDenyingFacade
    extends TestFilesFacade {
        boolean hit = false;

        private MetaRenameDenyingFacade() {
        }

        public boolean rename(LPSZ from, LPSZ to) {
            if (Chars.contains((CharSequence)to, (CharSequence)"_meta.prev")) {
                this.hit = true;
                return false;
            }
            return super.rename(from, to);
        }

        @Override
        public boolean wasCalled() {
            return this.hit;
        }
    }

    private static class SwapMetaRenameDenyingFacade
    extends TestFilesFacade {
        boolean hit = false;

        private SwapMetaRenameDenyingFacade() {
        }

        public boolean rename(LPSZ from, LPSZ to) {
            if (Chars.endsWith((CharSequence)from, (CharSequence)"_meta.swp")) {
                this.hit = true;
                return false;
            }
            return super.rename(from, to);
        }

        @Override
        public boolean wasCalled() {
            return this.hit;
        }
    }
}

