/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.DefaultCairoConfiguration;
import com.questdb.cairo.TableModel;
import com.questdb.cairo.TableReader;
import com.questdb.cairo.TableReaderRecordCursor;
import com.questdb.cairo.TableUtils;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.TestFilesFacade;
import com.questdb.cairo.sql.Record;
import com.questdb.cairo.sql.RecordCursor;
import com.questdb.std.BinarySequence;
import com.questdb.std.Chars;
import com.questdb.std.Files;
import com.questdb.std.FilesFacade;
import com.questdb.std.FilesFacadeImpl;
import com.questdb.std.LongList;
import com.questdb.std.NumericException;
import com.questdb.std.Rnd;
import com.questdb.std.Unsafe;
import com.questdb.std.microtime.DateFormat;
import com.questdb.std.microtime.DateFormatUtils;
import com.questdb.std.microtime.DateLocaleFactory;
import com.questdb.std.microtime.Dates;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.Path;
import com.questdb.test.tools.TestUtils;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class TableReaderTest
extends AbstractCairoTest {
    public static final int MUST_SWITCH = 1;
    public static final int MUST_NOT_SWITCH = 2;
    public static final int DONT_CARE = 0;
    private static final int blobLen = 65536;
    private static final RecordAssert BATCH1_ASSERTER = (r, exp, ts, blob) -> {
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)exp.nextByte(), (long)r.getByte(2));
        } else {
            Assert.assertEquals((long)0L, (long)r.getByte(2));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((Object)exp.nextBoolean(), (Object)r.getBool(8));
        } else {
            Assert.assertFalse((boolean)r.getBool(8));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)exp.nextShort(), (long)r.getShort(1));
        } else {
            Assert.assertEquals((long)0L, (long)r.getShort(1));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)exp.nextInt(), (long)r.getInt(0));
        } else {
            Assert.assertEquals((long)Integer.MIN_VALUE, (long)r.getInt(0));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((double)exp.nextDouble2(), (double)r.getDouble(3), (double)1.0E-8);
        } else {
            Assert.assertTrue((boolean)Double.isNaN(r.getDouble(3)));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((float)exp.nextFloat2(), (float)r.getFloat(4), (float)1.0E-6f);
        } else {
            Assert.assertTrue((boolean)Float.isNaN(r.getFloat(4)));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)exp.nextLong(), (long)r.getLong(5));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getLong(5));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)ts, (long)r.getDate(10));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getDate(10));
        }
        TableReaderTest.assertBin(r, exp, blob, 9);
        if (exp.nextBoolean()) {
            TableReaderTest.assertStrColumn(exp.nextChars(10), r, 6);
        } else {
            TableReaderTest.assertNullStr(r, 6);
        }
        if (exp.nextBoolean()) {
            TestUtils.assertEquals(exp.nextChars(7), r.getSym(7));
        } else {
            Assert.assertNull((Object)r.getSym(7));
        }
    };
    private static final RecordAssert BATCH1_ASSERTER_NULL_BIN = (r, exp, ts, blob) -> {
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)exp.nextByte(), (long)r.getByte(2));
        } else {
            Assert.assertEquals((long)0L, (long)r.getByte(2));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((Object)exp.nextBoolean(), (Object)r.getBool(8));
        } else {
            Assert.assertFalse((boolean)r.getBool(8));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)exp.nextShort(), (long)r.getShort(1));
        } else {
            Assert.assertEquals((long)0L, (long)r.getShort(1));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)exp.nextInt(), (long)r.getInt(0));
        } else {
            Assert.assertEquals((long)Integer.MIN_VALUE, (long)r.getInt(0));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((double)exp.nextDouble2(), (double)r.getDouble(3), (double)1.0E-8);
        } else {
            Assert.assertTrue((boolean)Double.isNaN(r.getDouble(3)));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((float)exp.nextFloat2(), (float)r.getFloat(4), (float)1.0E-6f);
        } else {
            Assert.assertTrue((boolean)Float.isNaN(r.getFloat(4)));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)exp.nextLong(), (long)r.getLong(5));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getLong(5));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)ts, (long)r.getDate(10));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getDate(10));
        }
        if (exp.nextBoolean()) {
            exp.nextChars(blob, 32768);
        }
        Assert.assertEquals((long)-1L, (long)r.getBinLen(9));
        Assert.assertNull((Object)r.getBin(9));
        if (exp.nextBoolean()) {
            TableReaderTest.assertStrColumn(exp.nextChars(10), r, 6);
        } else {
            TableReaderTest.assertNullStr(r, 6);
        }
        if (exp.nextBoolean()) {
            TestUtils.assertEquals(exp.nextChars(7), r.getSym(7));
        } else {
            Assert.assertNull((Object)r.getSym(7));
        }
    };
    private static final RecordAssert BATCH1_ASSERTER_NULL_SYM = (r, exp, ts, blob) -> {
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)exp.nextByte(), (long)r.getByte(2));
        } else {
            Assert.assertEquals((long)0L, (long)r.getByte(2));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((Object)exp.nextBoolean(), (Object)r.getBool(8));
        } else {
            Assert.assertFalse((boolean)r.getBool(8));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)exp.nextShort(), (long)r.getShort(1));
        } else {
            Assert.assertEquals((long)0L, (long)r.getShort(1));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)exp.nextInt(), (long)r.getInt(0));
        } else {
            Assert.assertEquals((long)Integer.MIN_VALUE, (long)r.getInt(0));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((double)exp.nextDouble2(), (double)r.getDouble(3), (double)1.0E-8);
        } else {
            Assert.assertTrue((boolean)Double.isNaN(r.getDouble(3)));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((float)exp.nextFloat2(), (float)r.getFloat(4), (float)1.0E-6f);
        } else {
            Assert.assertTrue((boolean)Float.isNaN(r.getFloat(4)));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)exp.nextLong(), (long)r.getLong(5));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getLong(5));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)ts, (long)r.getDate(10));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getDate(10));
        }
        TableReaderTest.assertBin(r, exp, blob, 9);
        if (exp.nextBoolean()) {
            TableReaderTest.assertStrColumn(exp.nextChars(10), r, 6);
        } else {
            TableReaderTest.assertNullStr(r, 6);
        }
        if (exp.nextBoolean()) {
            exp.nextChars(7);
        }
        Assert.assertNull((Object)r.getSym(7));
    };
    private static final RecordAssert BATCH1_ASSERTER_NULL_INT = (r, exp, ts, blob) -> {
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)exp.nextByte(), (long)r.getByte(2));
        } else {
            Assert.assertEquals((long)0L, (long)r.getByte(2));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((Object)exp.nextBoolean(), (Object)r.getBool(8));
        } else {
            Assert.assertFalse((boolean)r.getBool(8));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)exp.nextShort(), (long)r.getShort(1));
        } else {
            Assert.assertEquals((long)0L, (long)r.getShort(1));
        }
        if (exp.nextBoolean()) {
            exp.nextInt();
        }
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)r.getInt(0));
        if (exp.nextBoolean()) {
            Assert.assertEquals((double)exp.nextDouble2(), (double)r.getDouble(3), (double)1.0E-8);
        } else {
            Assert.assertTrue((boolean)Double.isNaN(r.getDouble(3)));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((float)exp.nextFloat2(), (float)r.getFloat(4), (float)1.0E-6f);
        } else {
            Assert.assertTrue((boolean)Float.isNaN(r.getFloat(4)));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)exp.nextLong(), (long)r.getLong(5));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getLong(5));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)ts, (long)r.getDate(10));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getDate(10));
        }
        TableReaderTest.assertBin(r, exp, blob, 9);
        if (exp.nextBoolean()) {
            TableReaderTest.assertStrColumn(exp.nextChars(10), r, 6);
        } else {
            TableReaderTest.assertNullStr(r, 6);
        }
        if (exp.nextBoolean()) {
            TestUtils.assertEquals(exp.nextChars(7), r.getSym(7));
        } else {
            Assert.assertNull((Object)r.getSym(7));
        }
    };
    private static final RecordAssert BATCH2_BEFORE_ASSERTER = (r, rnd, ts, blob) -> TableReaderTest.assertNullStr(r, 11);
    private static final RecordAssert BATCH1_7_ASSERTER = (r, exp, ts, blob) -> {
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)exp.nextByte(), (long)r.getByte(1));
        } else {
            Assert.assertEquals((long)0L, (long)r.getByte(1));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((Object)exp.nextBoolean(), (Object)r.getBool(7));
        } else {
            Assert.assertFalse((boolean)r.getBool(7));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)exp.nextShort(), (long)r.getShort(0));
        } else {
            Assert.assertEquals((long)0L, (long)r.getShort(0));
        }
        if (exp.nextBoolean()) {
            exp.nextInt();
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((double)exp.nextDouble2(), (double)r.getDouble(2), (double)1.0E-8);
        } else {
            Assert.assertTrue((boolean)Double.isNaN(r.getDouble(2)));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((float)exp.nextFloat2(), (float)r.getFloat(3), (float)1.0E-6f);
        } else {
            Assert.assertTrue((boolean)Float.isNaN(r.getFloat(3)));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)exp.nextLong(), (long)r.getLong(4));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getLong(4));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)ts, (long)r.getDate(9));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getDate(9));
        }
        TableReaderTest.assertBin(r, exp, blob, 8);
        if (exp.nextBoolean()) {
            TableReaderTest.assertStrColumn(exp.nextChars(10), r, 5);
        } else {
            TableReaderTest.assertNullStr(r, 5);
        }
        if (exp.nextBoolean()) {
            TestUtils.assertEquals(exp.nextChars(7), r.getSym(6));
        } else {
            Assert.assertNull((Object)r.getSym(6));
        }
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)r.getInt(20));
    };
    private static final RecordAssert BATCH1_9_ASSERTER = (r, exp, ts, blob) -> {
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)exp.nextByte(), (long)r.getByte(1));
        } else {
            Assert.assertEquals((long)0L, (long)r.getByte(1));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((Object)exp.nextBoolean(), (Object)r.getBool(6));
        } else {
            Assert.assertFalse((boolean)r.getBool(6));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)exp.nextShort(), (long)r.getShort(0));
        } else {
            Assert.assertEquals((long)0L, (long)r.getShort(0));
        }
        if (exp.nextBoolean()) {
            exp.nextInt();
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((double)exp.nextDouble2(), (double)r.getDouble(2), (double)1.0E-8);
        } else {
            Assert.assertTrue((boolean)Double.isNaN(r.getDouble(2)));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((float)exp.nextFloat2(), (float)r.getFloat(3), (float)1.0E-6f);
        } else {
            Assert.assertTrue((boolean)Float.isNaN(r.getFloat(3)));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)exp.nextLong(), (long)r.getLong(4));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getLong(4));
        }
        if (exp.nextBoolean()) {
            Assert.assertEquals((long)ts, (long)r.getDate(8));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getDate(8));
        }
        TableReaderTest.assertBin(r, exp, blob, 7);
        if (exp.nextBoolean()) {
            TableReaderTest.assertStrColumn(exp.nextChars(10), r, 5);
        } else {
            TableReaderTest.assertNullStr(r, 5);
        }
        if (exp.nextBoolean()) {
            exp.nextChars(7);
        }
        Assert.assertEquals((long)Integer.MIN_VALUE, (long)r.getInt(19));
    };
    private static final RecordAssert BATCH_2_7_BEFORE_ASSERTER = (r, rnd, ts, blob) -> TableReaderTest.assertNullStr(r, 10);
    private static final RecordAssert BATCH_2_9_BEFORE_ASSERTER = (r, rnd, ts, blob) -> TableReaderTest.assertNullStr(r, 9);
    private static final RecordAssert BATCH_3_7_BEFORE_ASSERTER = (r, rnd, ts, blob) -> Assert.assertEquals((long)Integer.MIN_VALUE, (long)r.getInt(11));
    private static final RecordAssert BATCH_3_9_BEFORE_ASSERTER = (r, rnd, ts, blob) -> Assert.assertEquals((long)Integer.MIN_VALUE, (long)r.getInt(10));
    private static final RecordAssert BATCH_4_7_BEFORE_ASSERTER = (r, rnd, ts, blob) -> {
        Assert.assertEquals((long)0L, (long)r.getShort(12));
        Assert.assertFalse((boolean)r.getBool(13));
        Assert.assertEquals((long)0L, (long)r.getByte(14));
        Assert.assertTrue((boolean)Float.isNaN(r.getFloat(15)));
        Assert.assertTrue((boolean)Double.isNaN(r.getDouble(16)));
        Assert.assertNull((Object)r.getSym(17));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getLong(18));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getDate(19));
    };
    private static final RecordAssert BATCH_4_9_BEFORE_ASSERTER = (r, rnd, ts, blob) -> {
        Assert.assertEquals((long)0L, (long)r.getShort(11));
        Assert.assertFalse((boolean)r.getBool(12));
        Assert.assertEquals((long)0L, (long)r.getByte(13));
        Assert.assertTrue((boolean)Float.isNaN(r.getFloat(14)));
        Assert.assertTrue((boolean)Double.isNaN(r.getDouble(15)));
        Assert.assertNull((Object)r.getSym(16));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getLong(17));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getDate(18));
    };
    private static final RecordAssert BATCH2_ASSERTER = (r, rnd, ts, blob) -> {
        BATCH1_ASSERTER.assertRecord(r, rnd, ts, blob);
        if ((rnd.nextPositiveInt() & 3) == 0) {
            TableReaderTest.assertStrColumn(rnd.nextChars(15), r, 11);
        }
    };
    private static final RecordAssert BATCH2_7_ASSERTER = (r, rnd, ts, blob) -> {
        BATCH1_7_ASSERTER.assertRecord(r, rnd, ts, blob);
        if ((rnd.nextPositiveInt() & 3) == 0) {
            TableReaderTest.assertStrColumn(rnd.nextChars(15), r, 10);
        }
    };
    private static final RecordAssert BATCH2_9_ASSERTER = (r, rnd, ts, blob) -> {
        BATCH1_9_ASSERTER.assertRecord(r, rnd, ts, blob);
        if ((rnd.nextPositiveInt() & 3) == 0) {
            TableReaderTest.assertStrColumn(rnd.nextChars(15), r, 9);
        }
    };
    private static final RecordAssert BATCH3_BEFORE_ASSERTER = (r, rnd, ts, blob) -> Assert.assertEquals((long)Integer.MIN_VALUE, (long)r.getInt(12));
    private static final RecordAssert BATCH3_ASSERTER = (r, rnd, ts, blob) -> {
        BATCH2_ASSERTER.assertRecord(r, rnd, ts, blob);
        if ((rnd.nextPositiveInt() & 3) == 0) {
            Assert.assertEquals((long)rnd.nextInt(), (long)r.getInt(12));
        }
    };
    private static final RecordAssert BATCH3_7_ASSERTER = (r, rnd, ts, blob) -> {
        BATCH2_7_ASSERTER.assertRecord(r, rnd, ts, blob);
        if ((rnd.nextPositiveInt() & 3) == 0) {
            Assert.assertEquals((long)rnd.nextInt(), (long)r.getInt(11));
        }
    };
    private static final RecordAssert BATCH3_9_ASSERTER = (r, rnd, ts, blob) -> {
        BATCH2_9_ASSERTER.assertRecord(r, rnd, ts, blob);
        if ((rnd.nextPositiveInt() & 3) == 0) {
            Assert.assertEquals((long)rnd.nextInt(), (long)r.getInt(10));
        }
    };
    private static final RecordAssert BATCH4_BEFORE_ASSERTER = (r, rnd, ts, blob) -> {
        Assert.assertEquals((long)0L, (long)r.getShort(13));
        Assert.assertFalse((boolean)r.getBool(14));
        Assert.assertEquals((long)0L, (long)r.getByte(15));
        Assert.assertTrue((boolean)Float.isNaN(r.getFloat(16)));
        Assert.assertTrue((boolean)Double.isNaN(r.getDouble(17)));
        Assert.assertNull((Object)r.getSym(18));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getLong(19));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getDate(20));
        Assert.assertNull((Object)r.getBin(21));
        Assert.assertEquals((long)-1L, (long)r.getBinLen(21));
    };
    private static final RecordAssert BATCH5_BEFORE_ASSERTER = (r, rnd, ts, blob) -> {
        Assert.assertEquals((long)0L, (long)r.getShort(13));
        Assert.assertFalse((boolean)r.getBool(14));
        Assert.assertEquals((long)0L, (long)r.getByte(15));
        Assert.assertTrue((boolean)Float.isNaN(r.getFloat(16)));
        Assert.assertTrue((boolean)Double.isNaN(r.getDouble(17)));
        Assert.assertNull((Object)r.getSym(18));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getLong(19));
        Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getDate(20));
    };
    private static final RecordAssert BATCH4_ASSERTER = (r, rnd, ts, blob) -> {
        BATCH3_ASSERTER.assertRecord(r, rnd, ts, blob);
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextShort(), (long)r.getShort(13));
        } else {
            Assert.assertEquals((long)0L, (long)r.getShort(13));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((Object)rnd.nextBoolean(), (Object)r.getBool(14));
        } else {
            Assert.assertFalse((boolean)r.getBool(14));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextByte(), (long)r.getByte(15));
        } else {
            Assert.assertEquals((long)0L, (long)r.getByte(15));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((float)rnd.nextFloat2(), (float)r.getFloat(16), (float)1.0E-8f);
        } else {
            Assert.assertTrue((boolean)Float.isNaN(r.getFloat(16)));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((double)rnd.nextDouble2(), (double)r.getDouble(17), (double)1.0E-7);
        } else {
            Assert.assertTrue((boolean)Double.isNaN(r.getDouble(17)));
        }
        if (rnd.nextBoolean()) {
            TestUtils.assertEquals(rnd.nextChars(10), r.getSym(18));
        } else {
            Assert.assertNull((Object)r.getSym(18));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextLong(), (long)r.getLong(19));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getLong(19));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextLong(), (long)r.getDate(20));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getDate(20));
        }
        TableReaderTest.assertBin(r, rnd, blob, 21);
    };
    private static final RecordAssert BATCH6_ASSERTER = (r, rnd, ts, blob) -> {
        BATCH3_ASSERTER.assertRecord(r, rnd, ts, blob);
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextShort(), (long)r.getShort(13));
        } else {
            Assert.assertEquals((long)0L, (long)r.getShort(13));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((Object)rnd.nextBoolean(), (Object)r.getBool(14));
        } else {
            Assert.assertFalse((boolean)r.getBool(14));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextByte(), (long)r.getByte(15));
        } else {
            Assert.assertEquals((long)0L, (long)r.getByte(15));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((float)rnd.nextFloat2(), (float)r.getFloat(16), (float)1.0E-8f);
        } else {
            Assert.assertTrue((boolean)Float.isNaN(r.getFloat(16)));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((double)rnd.nextDouble2(), (double)r.getDouble(17), (double)1.0E-7);
        } else {
            Assert.assertTrue((boolean)Double.isNaN(r.getDouble(17)));
        }
        if (rnd.nextBoolean()) {
            TestUtils.assertEquals(rnd.nextChars(10), r.getSym(18));
        } else {
            Assert.assertNull((Object)r.getSym(18));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextLong(), (long)r.getLong(19));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getLong(19));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextLong(), (long)r.getDate(20));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getDate(20));
        }
    };
    private static final RecordAssert BATCH6_7_ASSERTER = (r, rnd, ts, blob) -> {
        BATCH3_7_ASSERTER.assertRecord(r, rnd, ts, blob);
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextShort(), (long)r.getShort(12));
        } else {
            Assert.assertEquals((long)0L, (long)r.getShort(12));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((Object)rnd.nextBoolean(), (Object)r.getBool(13));
        } else {
            Assert.assertFalse((boolean)r.getBool(13));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextByte(), (long)r.getByte(14));
        } else {
            Assert.assertEquals((long)0L, (long)r.getByte(14));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((float)rnd.nextFloat2(), (float)r.getFloat(15), (float)1.0E-8f);
        } else {
            Assert.assertTrue((boolean)Float.isNaN(r.getFloat(15)));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((double)rnd.nextDouble2(), (double)r.getDouble(16), (double)1.0E-7);
        } else {
            Assert.assertTrue((boolean)Double.isNaN(r.getDouble(16)));
        }
        if (rnd.nextBoolean()) {
            TestUtils.assertEquals(rnd.nextChars(10), r.getSym(17));
        } else {
            Assert.assertNull((Object)r.getSym(17));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextLong(), (long)r.getLong(18));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getLong(18));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextLong(), (long)r.getDate(19));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getDate(19));
        }
    };
    private static final RecordAssert BATCH6_9_ASSERTER = (r, rnd, ts, blob) -> {
        BATCH3_9_ASSERTER.assertRecord(r, rnd, ts, blob);
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextShort(), (long)r.getShort(11));
        } else {
            Assert.assertEquals((long)0L, (long)r.getShort(11));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((Object)rnd.nextBoolean(), (Object)r.getBool(12));
        } else {
            Assert.assertFalse((boolean)r.getBool(12));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextByte(), (long)r.getByte(13));
        } else {
            Assert.assertEquals((long)0L, (long)r.getByte(13));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((float)rnd.nextFloat2(), (float)r.getFloat(14), (float)1.0E-8f);
        } else {
            Assert.assertTrue((boolean)Float.isNaN(r.getFloat(14)));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((double)rnd.nextDouble2(), (double)r.getDouble(15), (double)1.0E-7);
        } else {
            Assert.assertTrue((boolean)Double.isNaN(r.getDouble(15)));
        }
        if (rnd.nextBoolean()) {
            TestUtils.assertEquals(rnd.nextChars(10), r.getSym(16));
        } else {
            Assert.assertNull((Object)r.getSym(16));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextLong(), (long)r.getLong(17));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getLong(17));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextLong(), (long)r.getDate(18));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getDate(18));
        }
    };
    private static final RecordAssert BATCH5_7_ASSERTER = (r, rnd, ts, blob) -> {
        BATCH6_7_ASSERTER.assertRecord(r, rnd, ts, blob);
        if (rnd.nextBoolean()) {
            rnd.nextChars(blob, 32768);
        }
    };
    private static final RecordAssert BATCH5_9_ASSERTER = (r, rnd, ts, blob) -> {
        BATCH6_9_ASSERTER.assertRecord(r, rnd, ts, blob);
        if (rnd.nextBoolean()) {
            rnd.nextChars(blob, 32768);
        }
    };
    private static final RecordAssert BATCH5_ASSERTER = (r, rnd, ts, blob) -> {
        BATCH6_ASSERTER.assertRecord(r, rnd, ts, blob);
        if (rnd.nextBoolean()) {
            rnd.nextChars(blob, 32768);
        }
    };
    private static final FieldGenerator BATCH1_GENERATOR = (r1, rnd1, ts1, blob1) -> {
        if (rnd1.nextBoolean()) {
            r1.putByte(2, rnd1.nextByte());
        }
        if (rnd1.nextBoolean()) {
            r1.putBool(8, rnd1.nextBoolean());
        }
        if (rnd1.nextBoolean()) {
            r1.putShort(1, rnd1.nextShort());
        }
        if (rnd1.nextBoolean()) {
            r1.putInt(0, rnd1.nextInt());
        }
        if (rnd1.nextBoolean()) {
            r1.putDouble(3, rnd1.nextDouble2());
        }
        if (rnd1.nextBoolean()) {
            r1.putFloat(4, rnd1.nextFloat2());
        }
        if (rnd1.nextBoolean()) {
            r1.putLong(5, rnd1.nextLong());
        }
        if (rnd1.nextBoolean()) {
            r1.putDate(10, ts1);
        }
        if (rnd1.nextBoolean()) {
            rnd1.nextChars(blob1, 32768);
            r1.putBin(9, blob1, 65536L);
        }
        if (rnd1.nextBoolean()) {
            r1.putStr(6, rnd1.nextChars(10));
        }
        if (rnd1.nextBoolean()) {
            r1.putSym(7, rnd1.nextChars(7));
        }
    };
    private static final RecordAssert BATCH8_ASSERTER = (r, rnd, ts, blob) -> {
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextByte(), (long)r.getByte(1));
        } else {
            Assert.assertEquals((long)0L, (long)r.getByte(1));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((Object)rnd.nextBoolean(), (Object)r.getBool(7));
        } else {
            Assert.assertFalse((boolean)r.getBool(7));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextShort(), (long)r.getShort(0));
        } else {
            Assert.assertEquals((long)0L, (long)r.getShort(0));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((double)rnd.nextDouble2(), (double)r.getDouble(2), (double)1.0E-7);
        } else {
            Assert.assertTrue((boolean)Double.isNaN(r.getDouble(2)));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((float)rnd.nextFloat2(), (float)r.getFloat(3), (float)1.0E-6f);
        } else {
            Assert.assertTrue((boolean)Float.isNaN(r.getFloat(3)));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextLong(), (long)r.getLong(4));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getLong(4));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)ts, (long)r.getDate(9));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getDate(9));
        }
        TableReaderTest.assertBin(r, rnd, blob, 8);
        if (rnd.nextBoolean()) {
            TableReaderTest.assertStrColumn(rnd.nextChars(10), r, 5);
        } else {
            TableReaderTest.assertNullStr(r, 5);
        }
        if (rnd.nextBoolean()) {
            TestUtils.assertEquals(rnd.nextChars(7), r.getSym(6));
        } else {
            Assert.assertNull((Object)r.getSym(6));
        }
        if ((rnd.nextPositiveInt() & 3) == 0) {
            TableReaderTest.assertStrColumn(rnd.nextChars(15), r, 10);
        } else {
            TableReaderTest.assertNullStr(r, 10);
        }
        if ((rnd.nextPositiveInt() & 3) == 0) {
            Assert.assertEquals((long)rnd.nextInt(), (long)r.getInt(11));
        } else {
            Assert.assertEquals((long)Integer.MIN_VALUE, (long)r.getInt(11));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextShort(), (long)r.getShort(12));
        } else {
            Assert.assertEquals((long)0L, (long)r.getShort(12));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((Object)rnd.nextBoolean(), (Object)r.getBool(13));
        } else {
            Assert.assertFalse((boolean)r.getBool(13));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextByte(), (long)r.getByte(14));
        } else {
            Assert.assertEquals((long)0L, (long)r.getByte(14));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((float)rnd.nextFloat2(), (float)r.getFloat(15), (float)1.0E-6f);
        } else {
            Assert.assertTrue((boolean)Float.isNaN(r.getFloat(15)));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((double)rnd.nextDouble2(), (double)r.getDouble(16), (double)1.0E-7);
        } else {
            Assert.assertTrue((boolean)Double.isNaN(r.getDouble(16)));
        }
        if (rnd.nextBoolean()) {
            TestUtils.assertEquals(rnd.nextChars(10), r.getSym(17));
        } else {
            Assert.assertNull((Object)r.getSym(17));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextLong(), (long)r.getLong(18));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getLong(18));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextLong(), (long)r.getDate(19));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getDate(19));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextInt(), (long)r.getInt(20));
        } else {
            Assert.assertEquals((long)Integer.MIN_VALUE, (long)r.getInt(20));
        }
    };
    private static final RecordAssert BATCH8_9_ASSERTER = (r, rnd, ts, blob) -> {
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextByte(), (long)r.getByte(1));
        } else {
            Assert.assertEquals((long)0L, (long)r.getByte(1));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((Object)rnd.nextBoolean(), (Object)r.getBool(6));
        } else {
            Assert.assertFalse((boolean)r.getBool(6));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextShort(), (long)r.getShort(0));
        } else {
            Assert.assertEquals((long)0L, (long)r.getShort(0));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((double)rnd.nextDouble2(), (double)r.getDouble(2), (double)1.0E-7);
        } else {
            Assert.assertTrue((boolean)Double.isNaN(r.getDouble(2)));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((float)rnd.nextFloat2(), (float)r.getFloat(3), (float)1.0E-6f);
        } else {
            Assert.assertTrue((boolean)Float.isNaN(r.getFloat(3)));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextLong(), (long)r.getLong(4));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getLong(4));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)ts, (long)r.getDate(8));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getDate(8));
        }
        TableReaderTest.assertBin(r, rnd, blob, 7);
        if (rnd.nextBoolean()) {
            TableReaderTest.assertStrColumn(rnd.nextChars(10), r, 5);
        } else {
            TableReaderTest.assertNullStr(r, 5);
        }
        if (rnd.nextBoolean()) {
            rnd.nextChars(7);
        }
        if ((rnd.nextPositiveInt() & 3) == 0) {
            TableReaderTest.assertStrColumn(rnd.nextChars(15), r, 9);
        } else {
            TableReaderTest.assertNullStr(r, 9);
        }
        if ((rnd.nextPositiveInt() & 3) == 0) {
            Assert.assertEquals((long)rnd.nextInt(), (long)r.getInt(10));
        } else {
            Assert.assertEquals((long)Integer.MIN_VALUE, (long)r.getInt(10));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextShort(), (long)r.getShort(11));
        } else {
            Assert.assertEquals((long)0L, (long)r.getShort(11));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((Object)rnd.nextBoolean(), (Object)r.getBool(12));
        } else {
            Assert.assertFalse((boolean)r.getBool(12));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextByte(), (long)r.getByte(13));
        } else {
            Assert.assertEquals((long)0L, (long)r.getByte(13));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((float)rnd.nextFloat2(), (float)r.getFloat(14), (float)1.0E-6f);
        } else {
            Assert.assertTrue((boolean)Float.isNaN(r.getFloat(14)));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((double)rnd.nextDouble2(), (double)r.getDouble(15), (double)1.0E-7);
        } else {
            Assert.assertTrue((boolean)Double.isNaN(r.getDouble(15)));
        }
        if (rnd.nextBoolean()) {
            TestUtils.assertEquals(rnd.nextChars(10), r.getSym(16));
        } else {
            Assert.assertNull((Object)r.getSym(16));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextLong(), (long)r.getLong(17));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getLong(17));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextLong(), (long)r.getDate(18));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getDate(18));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextInt(), (long)r.getInt(19));
        } else {
            Assert.assertEquals((long)Integer.MIN_VALUE, (long)r.getInt(19));
        }
        Assert.assertNull((Object)r.getSym(20));
    };
    private static final RecordAssert BATCH9_ASSERTER = (r, rnd, ts, blob) -> {
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextByte(), (long)r.getByte(1));
        } else {
            Assert.assertEquals((long)0L, (long)r.getByte(1));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((Object)rnd.nextBoolean(), (Object)r.getBool(6));
        } else {
            Assert.assertFalse((boolean)r.getBool(6));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextShort(), (long)r.getShort(0));
        } else {
            Assert.assertEquals((long)0L, (long)r.getShort(0));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((double)rnd.nextDouble2(), (double)r.getDouble(2), (double)1.0E-7);
        } else {
            Assert.assertTrue((boolean)Double.isNaN(r.getDouble(2)));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((float)rnd.nextFloat2(), (float)r.getFloat(3), (float)1.0E-6f);
        } else {
            Assert.assertTrue((boolean)Float.isNaN(r.getFloat(3)));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextLong(), (long)r.getLong(4));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getLong(4));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)ts, (long)r.getDate(8));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getDate(8));
        }
        TableReaderTest.assertBin(r, rnd, blob, 7);
        if (rnd.nextBoolean()) {
            TableReaderTest.assertStrColumn(rnd.nextChars(10), r, 5);
        } else {
            TableReaderTest.assertNullStr(r, 5);
        }
        if ((rnd.nextPositiveInt() & 3) == 0) {
            TableReaderTest.assertStrColumn(rnd.nextChars(15), r, 9);
        } else {
            TableReaderTest.assertNullStr(r, 9);
        }
        if ((rnd.nextPositiveInt() & 3) == 0) {
            Assert.assertEquals((long)rnd.nextInt(), (long)r.getInt(10));
        } else {
            Assert.assertEquals((long)Integer.MIN_VALUE, (long)r.getInt(10));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextShort(), (long)r.getShort(11));
        } else {
            Assert.assertEquals((long)0L, (long)r.getShort(11));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((Object)rnd.nextBoolean(), (Object)r.getBool(12));
        } else {
            Assert.assertFalse((boolean)r.getBool(12));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextByte(), (long)r.getByte(13));
        } else {
            Assert.assertEquals((long)0L, (long)r.getByte(13));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((float)rnd.nextFloat2(), (float)r.getFloat(14), (float)1.0E-6f);
        } else {
            Assert.assertTrue((boolean)Float.isNaN(r.getFloat(14)));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((double)rnd.nextDouble2(), (double)r.getDouble(15), (double)1.0E-7);
        } else {
            Assert.assertTrue((boolean)Double.isNaN(r.getDouble(15)));
        }
        if (rnd.nextBoolean()) {
            TestUtils.assertEquals(rnd.nextChars(10), r.getSym(16));
        } else {
            Assert.assertNull((Object)r.getSym(16));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextLong(), (long)r.getLong(17));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getLong(17));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextLong(), (long)r.getDate(18));
        } else {
            Assert.assertEquals((long)Long.MIN_VALUE, (long)r.getDate(18));
        }
        if (rnd.nextBoolean()) {
            Assert.assertEquals((long)rnd.nextInt(), (long)r.getInt(19));
        } else {
            Assert.assertEquals((long)Integer.MIN_VALUE, (long)r.getInt(19));
        }
        if (rnd.nextBoolean()) {
            TestUtils.assertEquals(rnd.nextChars(8), r.getSym(20));
        } else {
            Assert.assertNull((Object)r.getSym(20));
        }
    };
    private static final FieldGenerator BATCH2_GENERATOR = (r1, rnd1, ts1, blob1) -> {
        BATCH1_GENERATOR.generate(r1, rnd1, ts1, blob1);
        if ((rnd1.nextPositiveInt() & 3) == 0) {
            r1.putStr(11, rnd1.nextChars(15));
        }
    };
    private static final FieldGenerator BATCH3_GENERATOR = (r1, rnd1, ts1, blob1) -> {
        BATCH2_GENERATOR.generate(r1, rnd1, ts1, blob1);
        if ((rnd1.nextPositiveInt() & 3) == 0) {
            r1.putInt(12, rnd1.nextInt());
        }
    };
    private static final FieldGenerator BATCH4_GENERATOR = (r, rnd, ts, blob) -> {
        BATCH3_GENERATOR.generate(r, rnd, ts, blob);
        if (rnd.nextBoolean()) {
            r.putShort(13, rnd.nextShort());
        }
        if (rnd.nextBoolean()) {
            r.putBool(14, rnd.nextBoolean());
        }
        if (rnd.nextBoolean()) {
            r.putByte(15, rnd.nextByte());
        }
        if (rnd.nextBoolean()) {
            r.putFloat(16, rnd.nextFloat2());
        }
        if (rnd.nextBoolean()) {
            r.putDouble(17, rnd.nextDouble2());
        }
        if (rnd.nextBoolean()) {
            r.putSym(18, rnd.nextChars(10));
        }
        if (rnd.nextBoolean()) {
            r.putLong(19, rnd.nextLong());
        }
        if (rnd.nextBoolean()) {
            r.putDate(20, rnd.nextLong());
        }
        if (rnd.nextBoolean()) {
            rnd.nextChars(blob, 32768);
            r.putBin(21, blob, 65536L);
        }
    };
    private static final FieldGenerator BATCH6_GENERATOR = (r, rnd, ts, blob) -> {
        BATCH3_GENERATOR.generate(r, rnd, ts, blob);
        if (rnd.nextBoolean()) {
            r.putShort(13, rnd.nextShort());
        }
        if (rnd.nextBoolean()) {
            r.putBool(14, rnd.nextBoolean());
        }
        if (rnd.nextBoolean()) {
            r.putByte(15, rnd.nextByte());
        }
        if (rnd.nextBoolean()) {
            r.putFloat(16, rnd.nextFloat2());
        }
        if (rnd.nextBoolean()) {
            r.putDouble(17, rnd.nextDouble2());
        }
        if (rnd.nextBoolean()) {
            r.putSym(18, rnd.nextChars(10));
        }
        if (rnd.nextBoolean()) {
            r.putLong(19, rnd.nextLong());
        }
        if (rnd.nextBoolean()) {
            r.putDate(20, rnd.nextLong());
        }
    };
    private static final FieldGenerator BATCH8_GENERATOR = (r, rnd, ts, blob) -> {
        if (rnd.nextBoolean()) {
            r.putByte(1, rnd.nextByte());
        }
        if (rnd.nextBoolean()) {
            r.putBool(7, rnd.nextBoolean());
        }
        if (rnd.nextBoolean()) {
            r.putShort(0, rnd.nextShort());
        }
        if (rnd.nextBoolean()) {
            r.putDouble(2, rnd.nextDouble2());
        }
        if (rnd.nextBoolean()) {
            r.putFloat(3, rnd.nextFloat2());
        }
        if (rnd.nextBoolean()) {
            r.putLong(4, rnd.nextLong());
        }
        if (rnd.nextBoolean()) {
            r.putDate(9, ts);
        }
        if (rnd.nextBoolean()) {
            rnd.nextChars(blob, 32768);
            r.putBin(8, blob, 65536L);
        }
        if (rnd.nextBoolean()) {
            r.putStr(5, rnd.nextChars(10));
        }
        if (rnd.nextBoolean()) {
            r.putSym(6, rnd.nextChars(7));
        }
        if ((rnd.nextPositiveInt() & 3) == 0) {
            r.putStr(10, rnd.nextChars(15));
        }
        if ((rnd.nextPositiveInt() & 3) == 0) {
            r.putInt(11, rnd.nextInt());
        }
        if (rnd.nextBoolean()) {
            r.putShort(12, rnd.nextShort());
        }
        if (rnd.nextBoolean()) {
            r.putBool(13, rnd.nextBoolean());
        }
        if (rnd.nextBoolean()) {
            r.putByte(14, rnd.nextByte());
        }
        if (rnd.nextBoolean()) {
            r.putFloat(15, rnd.nextFloat2());
        }
        if (rnd.nextBoolean()) {
            r.putDouble(16, rnd.nextDouble2());
        }
        if (rnd.nextBoolean()) {
            r.putSym(17, rnd.nextChars(10));
        }
        if (rnd.nextBoolean()) {
            r.putLong(18, rnd.nextLong());
        }
        if (rnd.nextBoolean()) {
            r.putDate(19, rnd.nextLong());
        }
        if (rnd.nextBoolean()) {
            r.putInt(20, rnd.nextInt());
        }
    };
    private static final FieldGenerator BATCH9_GENERATOR = (r, rnd, ts, blob) -> {
        if (rnd.nextBoolean()) {
            r.putByte(1, rnd.nextByte());
        }
        if (rnd.nextBoolean()) {
            r.putBool(6, rnd.nextBoolean());
        }
        if (rnd.nextBoolean()) {
            r.putShort(0, rnd.nextShort());
        }
        if (rnd.nextBoolean()) {
            r.putDouble(2, rnd.nextDouble2());
        }
        if (rnd.nextBoolean()) {
            r.putFloat(3, rnd.nextFloat2());
        }
        if (rnd.nextBoolean()) {
            r.putLong(4, rnd.nextLong());
        }
        if (rnd.nextBoolean()) {
            r.putDate(8, ts);
        }
        if (rnd.nextBoolean()) {
            rnd.nextChars(blob, 32768);
            r.putBin(7, blob, 65536L);
        }
        if (rnd.nextBoolean()) {
            r.putStr(5, rnd.nextChars(10));
        }
        if ((rnd.nextPositiveInt() & 3) == 0) {
            r.putStr(9, rnd.nextChars(15));
        }
        if ((rnd.nextPositiveInt() & 3) == 0) {
            r.putInt(10, rnd.nextInt());
        }
        if (rnd.nextBoolean()) {
            r.putShort(11, rnd.nextShort());
        }
        if (rnd.nextBoolean()) {
            r.putBool(12, rnd.nextBoolean());
        }
        if (rnd.nextBoolean()) {
            r.putByte(13, rnd.nextByte());
        }
        if (rnd.nextBoolean()) {
            r.putFloat(14, rnd.nextFloat2());
        }
        if (rnd.nextBoolean()) {
            r.putDouble(15, rnd.nextDouble2());
        }
        if (rnd.nextBoolean()) {
            r.putSym(16, rnd.nextChars(10));
        }
        if (rnd.nextBoolean()) {
            r.putLong(17, rnd.nextLong());
        }
        if (rnd.nextBoolean()) {
            r.putDate(18, rnd.nextLong());
        }
        if (rnd.nextBoolean()) {
            r.putInt(19, rnd.nextInt());
        }
        if (rnd.nextBoolean()) {
            r.putSym(20, rnd.nextChars(8));
        }
    };

    @Test
    public void testCloseColumnNonPartitioned1() throws Exception {
        this.testCloseColumn(3, 2000, 6000L, "bin", BATCH1_ASSERTER_NULL_BIN);
    }

    @Test
    public void testCloseColumnNonPartitioned2() throws Exception {
        this.testCloseColumn(3, 2000, 6000L, "int", BATCH1_ASSERTER_NULL_INT);
    }

    @Test
    public void testCloseColumnNonPartitioned3() throws Exception {
        this.testCloseColumn(3, 2000, 6000L, "sym", BATCH1_ASSERTER_NULL_SYM);
    }

    @Test
    public void testCloseColumnPartitioned1() throws Exception {
        this.testCloseColumn(0, 1000, 60000L, "bin", BATCH1_ASSERTER_NULL_BIN);
    }

    @Test
    public void testCloseColumnPartitioned2() throws Exception {
        this.testCloseColumn(0, 1000, 60000L, "int", BATCH1_ASSERTER_NULL_INT);
    }

    @Test
    public void testCloseColumnPartitioned3() throws Exception {
        this.testCloseColumn(0, 1000, 60000L, "sym", BATCH1_ASSERTER_NULL_SYM);
    }

    @Test
    public void testConcurrentReloadByDay() throws Exception {
        this.testConcurrentReloadSinglePartition(0);
    }

    @Test
    public void testConcurrentReloadMultipleByDay() throws Exception {
        this.testConcurrentReloadMultiplePartitions(0, 100000L);
    }

    @Test
    public void testConcurrentReloadMultipleByMonth() throws Exception {
        this.testConcurrentReloadMultiplePartitions(1, 3000000L);
    }

    @Test
    public void testConcurrentReloadMultipleByYear() throws Exception {
        this.testConcurrentReloadMultiplePartitions(1, 36000000L);
    }

    public void testConcurrentReloadMultiplePartitions(int partitionBy, long stride) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            LongList list = new LongList();
            int N = 1024;
            int scale = 10000;
            for (int i = 0; i < 1024; ++i) {
                list.add((long)i);
            }
            try (TableModel model = new TableModel(configuration, "w", partitionBy).col("l", 4).timestamp();){
                CairoTestUtils.create(model);
            }
            int threads = 2;
            CyclicBarrier startBarrier = new CyclicBarrier(2);
            CountDownLatch stopLatch = new CountDownLatch(2);
            AtomicInteger errors = new AtomicInteger(0);
            new Thread(() -> {
                try {
                    startBarrier.await();
                    long timestampUs = DateFormatUtils.parseDateTime((CharSequence)"2017-12-11T00:00:00.000Z");
                    try (TableWriter writer = new TableWriter(configuration, (CharSequence)"w");){
                        for (int i = 0; i < 10240000; ++i) {
                            TableWriter.Row row = writer.newRow(timestampUs);
                            row.putLong(0, list.getQuick(i % 1024));
                            row.append();
                            writer.commit();
                            timestampUs += stride;
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    stopLatch.countDown();
                }
            }).start();
            new Thread(() -> {
                try {
                    startBarrier.await();
                    try (TableReader reader = new TableReader(configuration, (CharSequence)"w");){
                        int count;
                        TableReaderRecordCursor cursor = reader.getCursor();
                        Record record = cursor.getRecord();
                        do {
                            reader.reload();
                            cursor.toTop();
                            count = 0;
                            while (cursor.hasNext()) {
                                Assert.assertEquals((long)list.get(count++ % 1024), (long)record.getLong(0));
                            }
                        } while (count != 10240000);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    stopLatch.countDown();
                }
            }).start();
            Assert.assertTrue((boolean)stopLatch.await(30L, TimeUnit.SECONDS));
            Assert.assertEquals((long)0L, (long)errors.get());
            try (TableReader reader = new TableReader(configuration, (CharSequence)"w");){
                Assert.assertTrue((reader.getPartitionCount() > 10 ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void testConcurrentReloadNonPartitioned() throws Exception {
        this.testConcurrentReloadSinglePartition(3);
    }

    public void testConcurrentReloadSinglePartition(int partitionBy) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            LongList list = new LongList();
            int N = 1024;
            int scale = 10000;
            for (int i = 0; i < 1024; ++i) {
                list.add((long)i);
            }
            try (TableModel model = new TableModel(configuration, "w", partitionBy).col("l", 4);){
                CairoTestUtils.create(model);
            }
            int threads = 2;
            CyclicBarrier startBarrier = new CyclicBarrier(2);
            CountDownLatch stopLatch = new CountDownLatch(2);
            AtomicInteger errors = new AtomicInteger(0);
            new Thread(() -> {
                try {
                    startBarrier.await();
                    try (TableWriter writer = new TableWriter(configuration, (CharSequence)"w");){
                        for (int i = 0; i < 10240000; ++i) {
                            TableWriter.Row row = writer.newRow(0L);
                            row.putLong(0, list.getQuick(i % 1024));
                            row.append();
                            writer.commit();
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    stopLatch.countDown();
                }
            }).start();
            new Thread(() -> {
                try {
                    startBarrier.await();
                    try (TableReader reader = new TableReader(configuration, (CharSequence)"w");){
                        int count;
                        TableReaderRecordCursor cursor = reader.getCursor();
                        Record record = cursor.getRecord();
                        do {
                            reader.reload();
                            cursor.toTop();
                            count = 0;
                            while (cursor.hasNext()) {
                                Assert.assertEquals((long)list.get(count++ % 1024), (long)record.getLong(0));
                            }
                        } while (count != 10240000);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    stopLatch.countDown();
                }
            }).start();
            Assert.assertTrue((boolean)stopLatch.await(30L, TimeUnit.SECONDS));
            Assert.assertEquals((long)0L, (long)errors.get());
        });
    }

    @Test
    public void testNullValueRecovery() throws Exception {
        String expected = "int\tshort\tbyte\tdouble\tfloat\tlong\tstr\tsym\tbool\tbin\tdate\nNaN\t0\t0\tNaN\tNaN\tNaN\t\tabc\ttrue\t\t\n";
        TestUtils.assertMemoryLeak(() -> {
            CairoTestUtils.createAllTable(configuration, 3);
            try (TableWriter w = new TableWriter(configuration, (CharSequence)"all");){
                TableWriter.Row r = w.newRow(1000000L);
                r.putInt(0, 10);
                r.putByte(1, (byte)56);
                r.putDouble(2, 4.3223);
                r.putStr(6, (CharSequence)"xyz");
                r.cancel();
                r = w.newRow(100000L);
                r.putSym(7, (CharSequence)"abc");
                r.putBool(8, true);
                r.append();
                w.commit();
            }
            var1_1 = null;
            try (TableReader r = new TableReader(configuration, (CharSequence)"all");){
                sink.clear();
                printer.print((RecordCursor)r.getCursor(), r.getMetadata(), true);
                TestUtils.assertEquals((CharSequence)"int\tshort\tbyte\tdouble\tfloat\tlong\tstr\tsym\tbool\tbin\tdate\nNaN\t0\t0\tNaN\tNaN\tNaN\t\tabc\ttrue\t\t\n", (CharSequence)sink);
            }
            catch (Throwable throwable) {
                var1_1 = throwable;
                throw throwable;
            }
        });
    }

    @Test
    public void testOver2GFile() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "x", 3).col("a", 3);){
                CairoTestUtils.create(model);
            }
            long N = 280000000L;
            Rnd rnd = new Rnd();
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"x");){
                int i = 0;
                while ((long)i < N) {
                    TableWriter.Row r = writer.newRow(0L);
                    r.putLong(0, rnd.nextLong());
                    r.append();
                    ++i;
                }
                writer.commit();
            }
            var4_9 = null;
            try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                int count = 0;
                rnd.reset();
                TableReaderRecordCursor cursor = reader.getCursor();
                Record record = cursor.getRecord();
                while (cursor.hasNext()) {
                    Assert.assertEquals((long)rnd.nextLong(), (long)record.getLong(0));
                    ++count;
                }
                Assert.assertEquals((long)N, (long)count);
            }
            catch (Throwable throwable) {
                var4_9 = throwable;
                throw throwable;
            }
        });
    }

    @Test
    public void testPartialString() {
        CairoTestUtils.createAllTable(configuration, 3);
        int N = 10000;
        Rnd rnd = new Rnd();
        try (TableWriter writer = new TableWriter(configuration, (CharSequence)"all");){
            CharSequence chars;
            TableWriter.Row r;
            int i;
            int col = writer.getMetadata().getColumnIndex((CharSequence)"str");
            for (i = 0; i < N; ++i) {
                r = writer.newRow(0L);
                chars = rnd.nextChars(15);
                r.putStr(col, chars, 2, 10);
                r.append();
            }
            writer.commit();
            for (i = 0; i < N; ++i) {
                r = writer.newRow(0L);
                chars = rnd.nextChars(15);
                r.putStr(col, chars, 2, 10);
                r.append();
            }
            writer.rollback();
            rnd.reset();
            try (TableReader reader = new TableReader(configuration, (CharSequence)"all");){
                col = reader.getMetadata().getColumnIndex((CharSequence)"str");
                int count = 0;
                TableReaderRecordCursor cursor = reader.getCursor();
                Record record = cursor.getRecord();
                while (cursor.hasNext()) {
                    CharSequence expected = rnd.nextChars(15);
                    CharSequence actual = record.getStr(col);
                    Assert.assertTrue((boolean)Chars.equals((CharSequence)expected, (int)2, (int)10, (CharSequence)actual, (int)0, (int)8));
                    ++count;
                }
                Assert.assertEquals((long)N, (long)count);
            }
        }
    }

    @Test
    public void testPartitionArchiveDoesNotExist() throws Exception {
        RecoverableTestFilesFacade ff = new RecoverableTestFilesFacade(){
            boolean called = false;

            public boolean exists(LPSZ path) {
                if (!this.recovered && Chars.endsWith((CharSequence)path, (CharSequence)"_archive")) {
                    this.called = true;
                    return false;
                }
                return super.exists(path);
            }

            @Override
            public boolean wasCalled() {
                return this.called;
            }
        };
        this.testSwitchPartitionFail(ff);
    }

    @Test
    public void testPartitionArchiveDoesNotOpen() throws Exception {
        RecoverableTestFilesFacade ff = new RecoverableTestFilesFacade(){
            boolean called = false;

            public long openRO(LPSZ name) {
                if (!this.recovered && Chars.endsWith((CharSequence)name, (CharSequence)"_archive")) {
                    this.called = true;
                    return -1L;
                }
                return super.openRO(name);
            }

            @Override
            public boolean wasCalled() {
                return this.called;
            }
        };
        this.testSwitchPartitionFail(ff);
    }

    @Test
    public void testPartitionCannotReadArchive() throws Exception {
        RecoverableTestFilesFacade ff = new RecoverableTestFilesFacade(){
            boolean called = false;
            long fd = -1L;

            public long openRO(LPSZ name) {
                if (!this.recovered && Chars.endsWith((CharSequence)name, (CharSequence)"_archive")) {
                    this.called = true;
                    this.fd = super.openRO(name);
                    return this.fd;
                }
                return super.openRO(name);
            }

            public long read(long fd, long buf, long len, long offset) {
                if (this.fd == fd && !this.recovered) {
                    return 0L;
                }
                return super.read(fd, buf, len, offset);
            }

            @Override
            public boolean wasCalled() {
                return this.called;
            }
        };
        this.testSwitchPartitionFail(ff);
    }

    @Test
    public void testReadByDay() throws Exception {
        CairoTestUtils.createAllTable(configuration, 0);
        TestUtils.assertMemoryLeak(this::testTableCursor);
    }

    @Test
    public void testReadByMonth() throws Exception {
        CairoTestUtils.createAllTable(configuration, 1);
        TestUtils.assertMemoryLeak(() -> this.testTableCursor(216000000L));
    }

    @Test
    public void testReadByYear() throws Exception {
        CairoTestUtils.createAllTable(configuration, 2);
        TestUtils.assertMemoryLeak(() -> this.testTableCursor(5184000000L));
    }

    @Test
    public void testReadEmptyTable() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            CairoTestUtils.createAllTable(configuration, 3);
            try (TableWriter ignored1 = new TableWriter(configuration, (CharSequence)"all");){
                try {
                    new TableWriter(configuration, (CharSequence)"all");
                    Assert.fail();
                }
                catch (CairoException cairoException) {
                    // empty catch block
                }
                try (TableReader reader = new TableReader(configuration, (CharSequence)"all");){
                    Assert.assertFalse((boolean)reader.getCursor().hasNext());
                }
            }
        });
    }

    @Test
    public void testReadNonPartitioned() throws Exception {
        CairoTestUtils.createAllTable(configuration, 3);
        TestUtils.assertMemoryLeak(this::testTableCursor);
    }

    @Test
    public void testReaderAndWriterRace() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "x", 3);){
                CairoTestUtils.create(model.timestamp());
            }
            CountDownLatch stopLatch = new CountDownLatch(2);
            CyclicBarrier barrier = new CyclicBarrier(2);
            int count = 1000000;
            AtomicInteger reloadCount = new AtomicInteger(0);
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"x");
                 TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                new Thread(() -> {
                    try {
                        barrier.await();
                        for (int i = 0; i < count; ++i) {
                            TableWriter.Row row = writer.newRow((long)i);
                            row.append();
                            writer.commit();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        stopLatch.countDown();
                    }
                }).start();
                new Thread(() -> {
                    try {
                        barrier.await();
                        int max = 0;
                        TableReaderRecordCursor cursor = reader.getCursor();
                        while (max < count) {
                            if (!reader.reload()) continue;
                            reloadCount.incrementAndGet();
                            cursor.toTop();
                            int localCount = 0;
                            while (cursor.hasNext()) {
                                ++localCount;
                            }
                            if (localCount <= max) continue;
                            max = localCount;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    finally {
                        stopLatch.countDown();
                    }
                }).start();
                stopLatch.await();
                Assert.assertTrue((reloadCount.get() > 0 ? 1 : 0) != 0);
            }
        });
    }

    @Test
    public void testReloadByDaySwitch() throws Exception {
        this.testReload(0, 150, 360000L, 1);
    }

    @Test
    public void testReloadByMonthSamePartition() throws Exception {
        this.testReload(1, 15, 3600000L, 2);
    }

    @Test
    public void testReloadByMonthSwitch() throws Exception {
        this.testReload(1, 15, 86400000L, 1);
    }

    @Test
    public void testReloadByYearSamePartition() throws Exception {
        this.testReload(2, 100, 86400000L, 2);
    }

    @Test
    public void testReloadByYearSwitch() throws Exception {
        this.testReload(2, 200, 86400000L, 1);
    }

    @Test
    public void testReloadDaySamePartition() throws Exception {
        this.testReload(0, 10, 3600000L, 2);
    }

    @Test
    public void testReloadNonPartitioned() throws Exception {
        this.testReload(3, 10, 3600000L, 0);
    }

    @Test
    public void testReloadWithTrailingNullString() throws NumericException {
        String tableName = "reload_test";
        try (TableModel model = new TableModel(configuration, "reload_test", 0);){
            model.col("str", 7);
            model.timestamp();
            CairoTestUtils.create(model);
        }
        var3_3 = null;
        try (TableReader reader = new TableReader(configuration, (CharSequence)"reload_test");){
            Assert.assertFalse((boolean)reader.reload());
            int N = 100;
            int M = 1000000;
            Rnd rnd = new Rnd();
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"reload_test");){
                long timestamp = DateFormatUtils.parseTimestamp((CharSequence)"2019-01-31T10:00:00.000001Z");
                long timestampStep = 500L;
                for (int i = 0; i < 100; ++i) {
                    TableWriter.Row row = writer.newRow(timestamp);
                    row.putStr(0, rnd.nextChars(7));
                    row.append();
                    timestamp += timestampStep;
                }
                writer.commit();
                Assert.assertTrue((boolean)reader.reload());
                rnd.reset();
                TableReaderRecordCursor cursor = reader.getCursor();
                Record record = cursor.getRecord();
                while (cursor.hasNext()) {
                    TestUtils.assertEquals(rnd.nextChars(7), record.getStr(0));
                }
                for (int i = 0; i < 1000000; ++i) {
                    TableWriter.Row row = writer.newRow(timestamp);
                    row.putStr(0, rnd.nextChars(7));
                    row.append();
                    timestamp += timestampStep;
                }
                TableWriter.Row row = writer.newRow(timestamp);
                row.putStr(0, null);
                row.append();
                writer.commit();
                Assert.assertTrue((boolean)reader.reload());
                int count = 0;
                cursor = reader.getCursor();
                rnd.reset();
                while (cursor.hasNext()) {
                    if (count == 1000100) {
                        Assert.assertNull((Object)record.getStr(0));
                    } else {
                        TestUtils.assertEquals(rnd.nextChars(7), record.getStr(0));
                    }
                    ++count;
                }
                Assert.assertEquals((long)1000101L, (long)count);
            }
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testReloadWithoutData() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "tab", 0).col("x", 8).col("y", 4);){
                CairoTestUtils.create(model);
            }
            var1_1 = null;
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"tab");){
                TableWriter.Row r = writer.newRow(0L);
                r.putSym(0, (CharSequence)"hello");
                r.append();
                writer.rollback();
                try (TableReader reader = new TableReader(configuration, (CharSequence)"tab");){
                    writer.addColumn((CharSequence)"z", 8);
                    Assert.assertTrue((boolean)reader.reload());
                    writer.addColumn((CharSequence)"w", 3);
                    Assert.assertTrue((boolean)reader.reload());
                }
            }
            catch (Throwable throwable) {
                var1_1 = throwable;
                throw throwable;
            }
        });
    }

    @Test
    public void testRemoveActivePartitionByDay() throws Exception {
        this.testRemoveActivePartition(0, current -> Dates.addDays((long)Dates.floorDD((long)current), (int)1), "2017-12-15");
    }

    @Test
    public void testRemoveActivePartitionByMonth() throws Exception {
        this.testRemoveActivePartition(1, current -> Dates.addMonths((long)Dates.floorMM((long)current), (int)1), "2018-04");
    }

    @Test
    public void testRemoveActivePartitionByYear() throws Exception {
        this.testRemoveActivePartition(2, current -> Dates.addYear((long)Dates.floorYYYY((long)current), (int)1), "2021");
    }

    @Test
    @Ignore
    public void testRecoverFromManualPartitionRemove() throws NumericException {
        try (TableModel model = new TableModel(configuration, "w", 0).col("l", 4).timestamp();){
            CairoTestUtils.create(model);
        }
        var2_2 = null;
        try (TableWriter writer = new TableWriter(configuration, (CharSequence)"w");){
            TableWriter.Row row = writer.newRow(DateFormatUtils.parseTimestamp((CharSequence)"2019-01-31T10:00:00.000000Z"));
            row.putLong(0, 1L);
            row.append();
            row = writer.newRow(DateFormatUtils.parseTimestamp((CharSequence)"2019-02-01T10:00:00.000000Z"));
            row.putLong(0, 2L);
            row.append();
            row = writer.newRow(DateFormatUtils.parseTimestamp((CharSequence)"2019-02-02T10:00:00.000000Z"));
            row.putLong(0, 3L);
            row.append();
            writer.commit();
            try (Path path = new Path();){
                path.of(configuration.getRoot()).concat((CharSequence)"w").concat((CharSequence)"2019-01-31").put(Files.SEPARATOR).$();
                Assert.assertTrue((boolean)Files.rmdir((Path)path));
            }
            Assert.assertTrue((boolean)writer.removePartition(DateFormatUtils.parseTimestamp((CharSequence)"2019-01-31T00:00:00.000000Z")));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testRemoveDefaultPartition() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 100;
            int N_PARTITIONS = 5;
            long timestampUs = DateFormatUtils.parseDateTime((CharSequence)"2017-12-11T00:00:00.000Z");
            long stride = 100L;
            int bandStride = 1000;
            int totalCount = 0;
            try (TableModel model = new TableModel(configuration, "w", 3).col("l", 4).timestamp();){
                CairoTestUtils.create(model);
            }
            var9_7 = null;
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"w");){
                for (int k = 0; k < N_PARTITIONS; ++k) {
                    long band = k * bandStride;
                    for (int i = 0; i < N; ++i) {
                        TableWriter.Row row = writer.newRow(timestampUs);
                        row.putLong(0, band + (long)i);
                        row.append();
                        writer.commit();
                        timestampUs += stride;
                    }
                    timestampUs = Dates.addDays((long)Dates.floorDD((long)timestampUs), (int)1);
                }
                Assert.assertEquals((long)(N * N_PARTITIONS), (long)writer.size());
                Assert.assertFalse((boolean)writer.removePartition(0L));
                Assert.assertEquals((long)(N * N_PARTITIONS), (long)writer.size());
            }
            catch (Throwable k) {
                var9_7 = k;
                throw k;
            }
            var9_7 = null;
            try (TableReader reader = new TableReader(configuration, (CharSequence)"w");){
                Assert.assertEquals((long)(N * N_PARTITIONS), (long)reader.size());
                TableReaderRecordCursor cursor = reader.getCursor();
                Record record = cursor.getRecord();
                while (cursor.hasNext()) {
                    record.getLong(0);
                    ++totalCount;
                }
            }
            catch (Throwable throwable) {
                var9_7 = throwable;
                throw throwable;
            }
            Assert.assertEquals((long)(N * N_PARTITIONS), (long)totalCount);
        });
    }

    @Test
    public void testRemoveFirstPartitionByDay() throws Exception {
        this.testRemovePartition(0, "2017-12-11", 0, current -> Dates.addDays((long)Dates.floorDD((long)current), (int)1));
    }

    @Test
    public void testRemoveFirstPartitionByDayReload() throws Exception {
        this.testRemovePartitionReload(0, "2017-12-11", 0, current -> Dates.addDays((long)Dates.floorDD((long)current), (int)1));
    }

    @Test
    public void testRemoveFirstPartitionByDayReloadTwo() throws Exception {
        this.testRemovePartitionReload(0, "2017-12-11", 0, current -> Dates.addDays((long)Dates.floorDD((long)current), (int)2));
    }

    @Test
    public void testRemoveFirstPartitionByDayTwo() throws Exception {
        this.testRemovePartition(0, "2017-12-11", 0, current -> Dates.addDays((long)Dates.floorDD((long)current), (int)2));
    }

    @Test
    public void testRemoveFirstPartitionByMonth() throws Exception {
        this.testRemovePartition(1, "2017-12", 0, current -> Dates.addMonths((long)Dates.floorMM((long)current), (int)1));
    }

    @Test
    public void testRemoveFirstPartitionByMonthReload() throws Exception {
        this.testRemovePartitionReload(1, "2017-12", 0, current -> Dates.addMonths((long)Dates.floorMM((long)current), (int)1));
    }

    @Test
    public void testRemoveFirstPartitionByMonthReloadTwo() throws Exception {
        this.testRemovePartitionReload(1, "2017-12", 0, current -> Dates.addMonths((long)Dates.floorMM((long)current), (int)2));
    }

    @Test
    public void testRemoveFirstPartitionByMonthTwo() throws Exception {
        this.testRemovePartition(1, "2017-12", 0, current -> Dates.addMonths((long)Dates.floorMM((long)current), (int)2));
    }

    @Test
    public void testRemoveFirstPartitionByYear() throws Exception {
        this.testRemovePartition(2, "2017", 0, current -> Dates.addYear((long)Dates.floorYYYY((long)current), (int)1));
    }

    @Test
    public void testRemoveFirstPartitionByYearReload() throws Exception {
        this.testRemovePartitionReload(2, "2017", 0, current -> Dates.addYear((long)Dates.floorYYYY((long)current), (int)1));
    }

    @Test
    public void testRemoveFirstPartitionByYearReloadTwo() throws Exception {
        this.testRemovePartitionReload(2, "2017", 0, current -> Dates.addYear((long)Dates.floorYYYY((long)current), (int)2));
    }

    @Test
    public void testRemoveFirstPartitionByYearTwo() throws Exception {
        this.testRemovePartition(2, "2017", 0, current -> Dates.addYear((long)Dates.floorYYYY((long)current), (int)2));
    }

    @Test
    public void testRemovePartitionByDay() throws Exception {
        this.testRemovePartition(0, "2017-12-14", 3000, current -> Dates.addDays((long)Dates.floorDD((long)current), (int)1));
    }

    @Test
    public void testRemovePartitionByDayCannotDeleteDir() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 100;
            int N_PARTITIONS = 5;
            long timestampUs = DateFormatUtils.parseDateTime((CharSequence)"2017-12-11T00:00:00.000Z");
            long stride = 100L;
            int bandStride = 1000;
            int totalCount = 0;
            FilesFacadeImpl ff = new FilesFacadeImpl(){

                public boolean rmdir(Path name) {
                    if (Chars.endsWith((CharSequence)name, (CharSequence)("2017-12-14" + Files.SEPARATOR))) {
                        return false;
                    }
                    return super.rmdir(name);
                }
            };
            DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root, (FilesFacade)ff){
                final /* synthetic */ FilesFacade val$ff;
                {
                    this.val$ff = filesFacade;
                    super(x0);
                }

                public FilesFacade getFilesFacade() {
                    return this.val$ff;
                }
            };
            try (TableModel model = new TableModel((CairoConfiguration)configuration, "w", 0).col("l", 4).timestamp();){
                CairoTestUtils.create(model);
            }
            var12_10 = null;
            try (TableWriter writer = new TableWriter((CairoConfiguration)configuration, (CharSequence)"w");){
                for (int k = 0; k < N_PARTITIONS; ++k) {
                    long band = k * bandStride;
                    for (int i = 0; i < N; ++i) {
                        TableWriter.Row row = writer.newRow(timestampUs);
                        row.putLong(0, band + (long)i);
                        row.append();
                        writer.commit();
                        timestampUs += stride;
                    }
                    timestampUs = Dates.addDays((long)Dates.floorDD((long)timestampUs), (int)1);
                }
                Assert.assertEquals((long)(N * N_PARTITIONS), (long)writer.size());
                DateFormat fmt = TableWriter.selectPartitionDirFmt((int)0);
                assert (fmt != null);
                long timestamp = fmt.parse((CharSequence)"2017-12-14", DateLocaleFactory.INSTANCE.getDefaultDateLocale());
                Assert.assertTrue((boolean)writer.removePartition(timestamp));
                Assert.assertFalse((boolean)writer.removePartition(timestamp));
                Assert.assertEquals((long)(N * (N_PARTITIONS - 1)), (long)writer.size());
            }
            catch (Throwable fmt) {
                var12_10 = fmt;
                throw fmt;
            }
            var12_10 = null;
            try (TableReader reader = new TableReader((CairoConfiguration)configuration, (CharSequence)"w");){
                Assert.assertEquals((long)(N * (N_PARTITIONS - 1)), (long)reader.size());
                int previousBand = -1;
                int bandCount = 0;
                TableReaderRecordCursor cursor = reader.getCursor();
                Record record = cursor.getRecord();
                while (cursor.hasNext()) {
                    long value = record.getLong(0);
                    int band = (int)(value / (long)bandStride * (long)bandStride);
                    if (band != previousBand) {
                        Assert.assertNotEquals((long)3000L, (long)band);
                        if (previousBand != -1) {
                            Assert.assertEquals((long)N, (long)bandCount);
                        }
                        previousBand = band;
                        bandCount = 0;
                    }
                    ++bandCount;
                    ++totalCount;
                }
                Assert.assertEquals((long)N, (long)bandCount);
            }
            catch (Throwable throwable) {
                var12_10 = throwable;
                throw throwable;
            }
            Assert.assertEquals((long)(N * (N_PARTITIONS - 1)), (long)totalCount);
        });
    }

    @Test
    public void testRemovePartitionByDayReload() throws Exception {
        this.testRemovePartitionReload(0, "2017-12-14", 3000, current -> Dates.addDays((long)Dates.floorDD((long)current), (int)1));
    }

    @Test
    public void testRemovePartitionByMonth() throws Exception {
        this.testRemovePartition(1, "2018-01", 1000, current -> Dates.addMonths((long)Dates.floorMM((long)current), (int)1));
    }

    @Test
    public void testRemovePartitionByMonthReload() throws Exception {
        this.testRemovePartitionReload(1, "2018-01", 1000, current -> Dates.addMonths((long)Dates.floorMM((long)current), (int)1));
    }

    @Test
    public void testRemovePartitionByYear() throws Exception {
        this.testRemovePartition(2, "2020", 3000, current -> Dates.addYear((long)Dates.floorYYYY((long)current), (int)1));
    }

    @Test
    public void testRemovePartitionByYearReload() throws Exception {
        this.testRemovePartitionReload(2, "2020", 3000, current -> Dates.addYear((long)Dates.floorYYYY((long)current), (int)1));
    }

    @Test
    public void testSymbolIndex() throws Exception {
        String expected = "{\"columnCount\":3,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"SYMBOL\",\"indexed\":true,\"indexValueBlockCapacity\":2},{\"index\":1,\"name\":\"b\",\"type\":\"INT\"},{\"index\":2,\"name\":\"timestamp\",\"type\":\"TIMESTAMP\"}],\"timestampIndex\":2}";
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "x", 0).col("a", 8).indexed(true, 2).col("b", 3).timestamp();){
                CairoTestUtils.create(model);
            }
            int N = 1000;
            long ts = DateFormatUtils.parseDateTime((CharSequence)"2018-01-06T10:00:00.000Z");
            Rnd rnd = new Rnd();
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"x");){
                sink.clear();
                writer.getMetadata().toJson((CharSink)sink);
                TestUtils.assertEquals((CharSequence)expected, (CharSequence)sink);
                for (int i = 0; i < N; ++i) {
                    TableWriter.Row row = writer.newRow(ts + (long)i * 2L * 360000000L);
                    row.putSym(0, rnd.nextChars(3));
                    row.putInt(1, rnd.nextInt());
                    row.append();
                    writer.commit();
                }
            }
            var6_11 = null;
            try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                sink.clear();
                reader.getMetadata().toJson((CharSink)sink);
                TestUtils.assertEquals((CharSequence)expected, (CharSequence)sink);
            }
            catch (Throwable throwable) {
                var6_11 = throwable;
                throw throwable;
            }
        });
    }

    @Test
    public void testUnsuccessfulFileRemove() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "x", 3).col("a", 7).col("b", 7);){
                CairoTestUtils.create(model);
            }
            Rnd rnd = new Rnd();
            int N = 1000;
            final TestFilesFacade ff = new TestFilesFacade(){
                int counter = 0;

                public boolean remove(LPSZ name) {
                    if (Chars.endsWith((CharSequence)name, (CharSequence)"b.i") || Chars.endsWith((CharSequence)name, (CharSequence)"b.d")) {
                        ++this.counter;
                        return false;
                    }
                    return super.remove(name);
                }

                @Override
                public boolean wasCalled() {
                    return this.counter > 0;
                }
            };
            DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

                public FilesFacade getFilesFacade() {
                    return ff;
                }
            };
            try (TableWriter writer = new TableWriter((CairoConfiguration)configuration, (CharSequence)"x");){
                for (int i = 0; i < 1000; ++i) {
                    TableWriter.Row row = writer.newRow(0L);
                    row.putStr(0, rnd.nextChars(10));
                    row.putStr(1, rnd.nextChars(15));
                    row.append();
                }
                writer.commit();
                try (TableReader reader = new TableReader((CairoConfiguration)configuration, (CharSequence)"x");){
                    long counter = 0L;
                    rnd.reset();
                    TableReaderRecordCursor cursor = reader.getCursor();
                    Record record = cursor.getRecord();
                    while (cursor.hasNext()) {
                        Assert.assertEquals((Object)rnd.nextChars(10), (Object)record.getStr(0));
                        Assert.assertEquals((Object)rnd.nextChars(15), (Object)record.getStr(1));
                        ++counter;
                    }
                    Assert.assertEquals((long)1000L, (long)counter);
                    writer.removeColumn((CharSequence)"b");
                    try {
                        writer.addColumn((CharSequence)"b", 7);
                        Assert.fail();
                    }
                    catch (CairoException e) {
                        TestUtils.assertContains(e.getMessage(), "Cannot remove");
                    }
                    Assert.assertTrue((boolean)reader.reload());
                    Assert.assertEquals((long)1000L, (long)reader.size());
                    rnd.reset();
                    cursor.toTop();
                    while (cursor.hasNext()) {
                        Assert.assertEquals((Object)rnd.nextChars(10), (Object)record.getStr(0));
                        rnd.nextChars(15);
                        ++counter;
                    }
                    Assert.assertEquals((long)2000L, (long)counter);
                }
            }
            Assert.assertTrue((boolean)ff.wasCalled());
        });
    }

    @Test
    public void testUnsuccessfulFileRemoveAndReloadStr() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "x", 3).col("a", 8).col("b", 7);){
                CairoTestUtils.create(model);
            }
            Rnd rnd = new Rnd();
            int N = 1000;
            final TestFilesFacade ff = new TestFilesFacade(){
                int counter = 2;

                public boolean remove(LPSZ name) {
                    if (this.counter > 0 && (Chars.endsWith((CharSequence)name, (CharSequence)"b.i") || Chars.endsWith((CharSequence)name, (CharSequence)"b.d") || Chars.endsWith((CharSequence)name, (CharSequence)"b.o") || Chars.endsWith((CharSequence)name, (CharSequence)"b.k") || Chars.endsWith((CharSequence)name, (CharSequence)"b.c") || Chars.endsWith((CharSequence)name, (CharSequence)"b.v"))) {
                        --this.counter;
                        return false;
                    }
                    return super.remove(name);
                }

                @Override
                public boolean wasCalled() {
                    return this.counter < 1;
                }
            };
            DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

                public FilesFacade getFilesFacade() {
                    return ff;
                }
            };
            try (TableWriter writer = new TableWriter((CairoConfiguration)configuration, (CharSequence)"x");){
                for (int i = 0; i < 1000; ++i) {
                    TableWriter.Row row = writer.newRow(0L);
                    row.putSym(0, rnd.nextChars(10));
                    row.putStr(1, rnd.nextChars(15));
                    row.append();
                }
                writer.commit();
                try (TableReader reader = new TableReader((CairoConfiguration)configuration, (CharSequence)"x");){
                    long counter = 0L;
                    rnd.reset();
                    TableReaderRecordCursor cursor = reader.getCursor();
                    Record record = cursor.getRecord();
                    while (cursor.hasNext()) {
                        Assert.assertEquals((Object)rnd.nextChars(10), (Object)record.getSym(0));
                        Assert.assertEquals((Object)rnd.nextChars(15), (Object)record.getStr(1));
                        ++counter;
                    }
                    Assert.assertEquals((long)1000L, (long)counter);
                    writer.removeColumn((CharSequence)"b");
                    if (configuration.getFilesFacade().isRestrictedFileSystem()) {
                        reader.closeColumnForRemove((CharSequence)"b");
                    }
                    writer.addColumn((CharSequence)"b", 7);
                    for (int i = 0; i < 1000; ++i) {
                        TableWriter.Row row = writer.newRow(0L);
                        row.putSym(0, rnd.nextChars(10));
                        row.putStr(1, rnd.nextChars(15));
                        row.append();
                    }
                    writer.commit();
                    Assert.assertTrue((boolean)reader.reload());
                    Assert.assertEquals((long)2000L, (long)reader.size());
                    rnd.reset();
                    cursor.toTop();
                    counter = 0L;
                    while (cursor.hasNext()) {
                        Assert.assertEquals((Object)rnd.nextChars(10), (Object)record.getSym(0));
                        if (counter < 1000L) {
                            rnd.nextChars(15);
                            Assert.assertNull((Object)record.getSym(1));
                        } else {
                            Assert.assertEquals((Object)rnd.nextChars(15), (Object)record.getStr(1));
                        }
                        ++counter;
                    }
                    Assert.assertEquals((long)2000L, (long)counter);
                }
            }
            Assert.assertTrue((boolean)ff.wasCalled());
        });
    }

    @Test
    public void testUnsuccessfulRemoveAndReloadSym() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "x", 3).col("a", 8).col("b", 8);){
                CairoTestUtils.create(model);
            }
            Rnd rnd = new Rnd();
            int N = 1000;
            final TestFilesFacade ff = new TestFilesFacade(){
                int counter = 5;

                public boolean remove(LPSZ name) {
                    if (this.counter > 0 && (Chars.endsWith((CharSequence)name, (CharSequence)"b.i") || Chars.endsWith((CharSequence)name, (CharSequence)"b.d") || Chars.endsWith((CharSequence)name, (CharSequence)"b.o") || Chars.endsWith((CharSequence)name, (CharSequence)"b.k") || Chars.endsWith((CharSequence)name, (CharSequence)"b.c") || Chars.endsWith((CharSequence)name, (CharSequence)"b.v"))) {
                        --this.counter;
                        return false;
                    }
                    return super.remove(name);
                }

                @Override
                public boolean wasCalled() {
                    return this.counter < 1;
                }
            };
            DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

                public FilesFacade getFilesFacade() {
                    return ff;
                }
            };
            try (TableWriter writer = new TableWriter((CairoConfiguration)configuration, (CharSequence)"x");){
                this.appendTwoSymbols(writer, rnd);
                writer.commit();
                try (TableReader reader = new TableReader((CairoConfiguration)configuration, (CharSequence)"x");){
                    long counter = 0L;
                    rnd.reset();
                    TableReaderRecordCursor cursor = reader.getCursor();
                    Record record = cursor.getRecord();
                    while (cursor.hasNext()) {
                        Assert.assertEquals((Object)rnd.nextChars(10), (Object)record.getSym(0));
                        Assert.assertEquals((Object)rnd.nextChars(15), (Object)record.getSym(1));
                        ++counter;
                    }
                    Assert.assertEquals((long)1000L, (long)counter);
                    writer.removeColumn((CharSequence)"b");
                    if (configuration.getFilesFacade().isRestrictedFileSystem()) {
                        reader.closeColumnForRemove((CharSequence)"b");
                    }
                    writer.addColumn((CharSequence)"b", 8);
                    this.appendTwoSymbols(writer, rnd);
                    writer.commit();
                    Assert.assertTrue((boolean)reader.reload());
                    Assert.assertEquals((long)2000L, (long)reader.size());
                    rnd.reset();
                    cursor.toTop();
                    counter = 0L;
                    while (cursor.hasNext()) {
                        Assert.assertEquals((Object)rnd.nextChars(10), (Object)record.getSym(0));
                        if (counter < 1000L) {
                            rnd.nextChars(15);
                            Assert.assertNull((Object)record.getSym(1));
                        } else {
                            Assert.assertEquals((Object)rnd.nextChars(15), (Object)record.getSym(1));
                        }
                        ++counter;
                    }
                    Assert.assertEquals((long)2000L, (long)counter);
                }
            }
            Assert.assertTrue((boolean)ff.wasCalled());
        });
    }

    @Test
    public void testUnsuccessfulRemoveAndReloadSymTwice() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "x", 3).col("a", 8).col("b", 8);){
                CairoTestUtils.create(model);
            }
            Rnd rnd = new Rnd();
            int N = 1000;
            final TestFilesFacade ff = new TestFilesFacade(){
                int counter = 5;

                public boolean remove(LPSZ name) {
                    if (this.counter > 0 && (Chars.endsWith((CharSequence)name, (CharSequence)"b.i") || Chars.endsWith((CharSequence)name, (CharSequence)"b.d") || Chars.endsWith((CharSequence)name, (CharSequence)"b.o") || Chars.endsWith((CharSequence)name, (CharSequence)"b.k") || Chars.endsWith((CharSequence)name, (CharSequence)"b.c") || Chars.endsWith((CharSequence)name, (CharSequence)"b.v"))) {
                        --this.counter;
                        return false;
                    }
                    return super.remove(name);
                }

                @Override
                public boolean wasCalled() {
                    return this.counter < 1;
                }
            };
            DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

                public FilesFacade getFilesFacade() {
                    return ff;
                }
            };
            try (TableWriter writer = new TableWriter((CairoConfiguration)configuration, (CharSequence)"x");){
                this.appendTwoSymbols(writer, rnd);
                writer.commit();
                try (TableReader reader = new TableReader((CairoConfiguration)configuration, (CharSequence)"x");){
                    long counter = 0L;
                    rnd.reset();
                    TableReaderRecordCursor cursor = reader.getCursor();
                    Record record = cursor.getRecord();
                    while (cursor.hasNext()) {
                        Assert.assertEquals((Object)rnd.nextChars(10), (Object)record.getSym(0));
                        Assert.assertEquals((Object)rnd.nextChars(15), (Object)record.getSym(1));
                        ++counter;
                    }
                    Assert.assertEquals((long)1000L, (long)counter);
                    writer.removeColumn((CharSequence)"b");
                    reader.reload();
                    writer.addColumn((CharSequence)"b", 8);
                    this.appendTwoSymbols(writer, rnd);
                    writer.commit();
                    Assert.assertTrue((boolean)reader.reload());
                    Assert.assertEquals((long)2000L, (long)reader.size());
                    rnd.reset();
                    cursor.toTop();
                    counter = 0L;
                    while (cursor.hasNext()) {
                        Assert.assertEquals((Object)rnd.nextChars(10), (Object)record.getSym(0));
                        if (counter < 1000L) {
                            rnd.nextChars(15);
                            Assert.assertNull((Object)record.getSym(1));
                        } else {
                            Assert.assertEquals((Object)rnd.nextChars(15), (Object)record.getSym(1));
                        }
                        ++counter;
                    }
                    Assert.assertEquals((long)2000L, (long)counter);
                }
            }
            Assert.assertTrue((boolean)ff.wasCalled());
        });
    }

    @Test
    public void testUnsuccessfulRemoveExplicitColCloseAndReloadSym() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "x", 3).col("a", 8).col("b", 8);){
                CairoTestUtils.create(model);
            }
            Rnd rnd = new Rnd();
            int N = 1000;
            final TestFilesFacade ff = new TestFilesFacade(){
                int counter = 5;

                public boolean remove(LPSZ name) {
                    if (this.counter > 0 && (Chars.endsWith((CharSequence)name, (CharSequence)"b.i") || Chars.endsWith((CharSequence)name, (CharSequence)"b.d") || Chars.endsWith((CharSequence)name, (CharSequence)"b.o") || Chars.endsWith((CharSequence)name, (CharSequence)"b.k") || Chars.endsWith((CharSequence)name, (CharSequence)"b.c") || Chars.endsWith((CharSequence)name, (CharSequence)"b.v"))) {
                        --this.counter;
                        return false;
                    }
                    return super.remove(name);
                }

                @Override
                public boolean wasCalled() {
                    return this.counter < 1;
                }
            };
            DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

                public FilesFacade getFilesFacade() {
                    return ff;
                }
            };
            try (TableWriter writer = new TableWriter((CairoConfiguration)configuration, (CharSequence)"x");){
                this.appendTwoSymbols(writer, rnd);
                writer.commit();
                try (TableReader reader = new TableReader((CairoConfiguration)configuration, (CharSequence)"x");){
                    long counter = 0L;
                    rnd.reset();
                    TableReaderRecordCursor cursor = reader.getCursor();
                    Record record = cursor.getRecord();
                    while (cursor.hasNext()) {
                        Assert.assertEquals((Object)rnd.nextChars(10), (Object)record.getSym(0));
                        Assert.assertEquals((Object)rnd.nextChars(15), (Object)record.getSym(1));
                        ++counter;
                    }
                    Assert.assertEquals((long)1000L, (long)counter);
                    writer.removeColumn((CharSequence)"b");
                    reader.closeColumnForRemove((CharSequence)"b");
                    writer.addColumn((CharSequence)"b", 8);
                    this.appendTwoSymbols(writer, rnd);
                    writer.commit();
                    Assert.assertTrue((boolean)reader.reload());
                    Assert.assertEquals((long)2000L, (long)reader.size());
                    rnd.reset();
                    cursor.toTop();
                    counter = 0L;
                    while (cursor.hasNext()) {
                        Assert.assertEquals((Object)rnd.nextChars(10), (Object)record.getSym(0));
                        if (counter < 1000L) {
                            rnd.nextChars(15);
                            Assert.assertNull((Object)record.getSym(1));
                        } else {
                            Assert.assertEquals((Object)rnd.nextChars(15), (Object)record.getSym(1));
                        }
                        ++counter;
                    }
                    Assert.assertEquals((long)2000L, (long)counter);
                }
            }
            Assert.assertTrue((boolean)ff.wasCalled());
        });
    }

    @Test
    public void testUnsuccessfulRemoveLastSym() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "x", 3).col("a", 8).col("b", 8);){
                CairoTestUtils.create(model);
            }
            Rnd rnd = new Rnd();
            int N = 1000;
            final TestFilesFacade ff = new TestFilesFacade(){
                int counter = 5;

                public boolean remove(LPSZ name) {
                    if (this.counter > 0 && (Chars.endsWith((CharSequence)name, (CharSequence)"b.i") || Chars.endsWith((CharSequence)name, (CharSequence)"b.d") || Chars.endsWith((CharSequence)name, (CharSequence)"b.o") || Chars.endsWith((CharSequence)name, (CharSequence)"b.k") || Chars.endsWith((CharSequence)name, (CharSequence)"b.c") || Chars.endsWith((CharSequence)name, (CharSequence)"b.v"))) {
                        --this.counter;
                        return false;
                    }
                    return super.remove(name);
                }

                @Override
                public boolean wasCalled() {
                    return this.counter < 1;
                }
            };
            DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

                public FilesFacade getFilesFacade() {
                    return ff;
                }
            };
            try (TableWriter writer = new TableWriter((CairoConfiguration)configuration, (CharSequence)"x");){
                this.appendTwoSymbols(writer, rnd);
                writer.commit();
                try (TableReader reader = new TableReader((CairoConfiguration)configuration, (CharSequence)"x");){
                    long counter = 0L;
                    rnd.reset();
                    TableReaderRecordCursor cursor = reader.getCursor();
                    Record record = cursor.getRecord();
                    while (cursor.hasNext()) {
                        Assert.assertEquals((Object)rnd.nextChars(10), (Object)record.getSym(0));
                        Assert.assertEquals((Object)rnd.nextChars(15), (Object)record.getSym(1));
                        ++counter;
                    }
                    Assert.assertEquals((long)1000L, (long)counter);
                    writer.removeColumn((CharSequence)"b");
                    Assert.assertTrue((boolean)reader.reload());
                    Assert.assertEquals((long)1000L, (long)reader.size());
                    rnd.reset();
                    cursor.toTop();
                    counter = 0L;
                    while (cursor.hasNext()) {
                        Assert.assertEquals((Object)rnd.nextChars(10), (Object)record.getSym(0));
                        rnd.nextChars(15);
                        ++counter;
                    }
                    Assert.assertEquals((long)1000L, (long)counter);
                }
            }
            Assert.assertTrue((boolean)ff.wasCalled());
        });
    }

    private static long allocBlob() {
        return Unsafe.malloc((long)65536L);
    }

    private static void freeBlob(long blob) {
        Unsafe.free((long)blob, (long)65536L);
    }

    private static void assertBin(Record r, Rnd exp, long blob, int index) {
        if (exp.nextBoolean()) {
            exp.nextChars(blob, 32768);
            Assert.assertEquals((long)65536L, (long)r.getBinLen(index));
            BinarySequence sq = r.getBin(index);
            for (int l = 0; l < 65536; ++l) {
                boolean result;
                byte b = sq.byteAt((long)l);
                boolean bl = result = Unsafe.getUnsafe().getByte(blob + (long)l) != b;
                if (!result) continue;
                Assert.fail((String)("Error at [" + l + "]: expected=" + Unsafe.getUnsafe().getByte(blob + (long)l) + ", actual=" + b));
            }
        } else {
            Assert.assertEquals((long)-1L, (long)r.getBinLen(index));
        }
    }

    private static void assertStrColumn(CharSequence expected, Record r, int index) {
        TestUtils.assertEquals(expected, r.getStr(index));
        TestUtils.assertEquals(expected, r.getStrB(index));
        Assert.assertNotSame((Object)r.getStr(index), (Object)r.getStrB(index));
        Assert.assertEquals((long)expected.length(), (long)r.getStrLen(index));
    }

    private static void assertNullStr(Record r, int index) {
        Assert.assertNull((Object)r.getStr(index));
        Assert.assertNull((Object)r.getStrB(index));
        Assert.assertEquals((long)-1L, (long)r.getStrLen(index));
    }

    private void appendTwoSymbols(TableWriter writer, Rnd rnd) {
        for (int i = 0; i < 1000; ++i) {
            TableWriter.Row row = writer.newRow(0L);
            row.putSym(0, rnd.nextChars(10));
            row.putSym(1, rnd.nextChars(15));
            row.append();
        }
    }

    private void assertBatch2(int count, long increment, long ts, long blob, TableReader reader) {
        TableReaderRecordCursor cursor = reader.getCursor();
        Rnd exp = new Rnd();
        long ts2 = this.assertPartialCursor((RecordCursor)cursor, exp, ts, increment, blob, 3 * count, (r, rnd13, ts13, blob13) -> {
            BATCH1_ASSERTER.assertRecord(r, rnd13, ts13, blob13);
            BATCH2_BEFORE_ASSERTER.assertRecord(r, rnd13, ts13, blob13);
        });
        this.assertPartialCursor((RecordCursor)cursor, exp, ts2, increment, blob, count, BATCH2_ASSERTER);
    }

    private void assertBatch3(int count, long increment, long ts, long blob, TableReader reader) {
        Rnd exp = new Rnd();
        TableReaderRecordCursor cursor = reader.getCursor();
        long ts2 = this.assertPartialCursor((RecordCursor)cursor, exp, ts, increment, blob, 3 * count, (r, rnd1, ts1, blob1) -> {
            BATCH1_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH2_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH3_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
        });
        ts2 = this.assertPartialCursor((RecordCursor)cursor, exp, ts2, increment, blob, count, (r, rnd12, ts12, blob12) -> {
            BATCH2_ASSERTER.assertRecord(r, rnd12, ts12, blob12);
            BATCH3_BEFORE_ASSERTER.assertRecord(r, rnd12, ts12, blob12);
        });
        this.assertPartialCursor((RecordCursor)cursor, exp, ts2, increment, blob, count, BATCH3_ASSERTER);
    }

    private void assertBatch4(int count, long increment, long ts, long blob, TableReader reader) {
        Rnd exp = new Rnd();
        TableReaderRecordCursor cursor = reader.getCursor();
        long ts2 = this.assertPartialCursor((RecordCursor)cursor, exp, ts, increment, blob, 3 * count, (r, rnd1, ts1, blob1) -> {
            BATCH1_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH2_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH3_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH4_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
        });
        ts2 = this.assertPartialCursor((RecordCursor)cursor, exp, ts2, increment, blob, count, (r, rnd12, ts12, blob12) -> {
            BATCH2_ASSERTER.assertRecord(r, rnd12, ts12, blob12);
            BATCH3_BEFORE_ASSERTER.assertRecord(r, rnd12, ts12, blob12);
            BATCH4_BEFORE_ASSERTER.assertRecord(r, rnd12, ts12, blob12);
        });
        ts2 = this.assertPartialCursor((RecordCursor)cursor, exp, ts2, increment, blob, count, (r, rnd14, ts14, blob14) -> {
            BATCH4_BEFORE_ASSERTER.assertRecord(r, rnd14, ts14, blob14);
            BATCH3_ASSERTER.assertRecord(r, rnd14, ts14, blob14);
        });
        this.assertPartialCursor((RecordCursor)cursor, exp, ts2, increment, blob, count, BATCH4_ASSERTER);
    }

    private long assertBatch5(int count, long increment, long ts, long blob, RecordCursor cursor, Rnd exp) {
        cursor.toTop();
        long ts2 = this.assertPartialCursor(cursor, exp, ts, increment, blob, 3 * count, (r, rnd1, ts1, blob1) -> {
            BATCH1_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH2_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH3_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH5_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
        });
        ts2 = this.assertPartialCursor(cursor, exp, ts2, increment, blob, count, (r, rnd1, ts1, blob1) -> {
            BATCH2_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH3_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH5_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
        });
        ts2 = this.assertPartialCursor(cursor, exp, ts2, increment, blob, count, (r, rnd1, ts1, blob1) -> {
            BATCH5_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH3_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
        });
        return this.assertPartialCursor(cursor, exp, ts2, increment, blob, count, BATCH5_ASSERTER);
    }

    private void assertBatch6(int count, long increment, long ts, long blob, RecordCursor cursor) {
        Rnd exp = new Rnd();
        cursor.toTop();
        long ts2 = this.assertBatch5(count, increment, ts, blob, cursor, exp);
        this.assertPartialCursor(cursor, exp, ts2, increment, blob, count, BATCH6_ASSERTER);
    }

    private void assertBatch7(int count, long increment, long ts, long blob, RecordCursor cursor) {
        cursor.toTop();
        Rnd exp = new Rnd();
        long ts2 = this.assertPartialCursor(cursor, exp, ts, increment, blob, 3 * count, (r, rnd1, ts1, blob1) -> {
            BATCH1_7_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH_2_7_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH_3_7_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH_4_7_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
        });
        ts2 = this.assertPartialCursor(cursor, exp, ts2, increment, blob, count, (r, rnd1, ts1, blob1) -> {
            BATCH2_7_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH_3_7_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH_4_7_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
        });
        ts2 = this.assertPartialCursor(cursor, exp, ts2, increment, blob, count, (r, rnd1, ts1, blob1) -> {
            BATCH3_7_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH_4_7_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
        });
        ts2 = this.assertPartialCursor(cursor, exp, ts2, increment, blob, count, BATCH5_7_ASSERTER);
        this.assertPartialCursor(cursor, exp, ts2, increment, blob, count, BATCH6_7_ASSERTER);
    }

    private void assertBatch8(int count, long increment, long ts, long blob, RecordCursor cursor) {
        cursor.toTop();
        Rnd exp = new Rnd();
        long ts2 = this.assertPartialCursor(cursor, exp, ts, increment, blob, 3 * count, (r, rnd1, ts1, blob1) -> {
            BATCH1_7_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH_2_7_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH_3_7_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH_4_7_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
        });
        ts2 = this.assertPartialCursor(cursor, exp, ts2, increment, blob, count, (r, rnd1, ts1, blob1) -> {
            BATCH2_7_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH_3_7_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH_4_7_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
        });
        ts2 = this.assertPartialCursor(cursor, exp, ts2, increment, blob, count, (r, rnd1, ts1, blob1) -> {
            BATCH3_7_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH_4_7_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
        });
        ts2 = this.assertPartialCursor(cursor, exp, ts2, increment, blob, count, BATCH5_7_ASSERTER);
        ts2 = this.assertPartialCursor(cursor, exp, ts2, increment, blob, count, BATCH6_7_ASSERTER);
        this.assertPartialCursor(cursor, exp, ts2, increment, blob, count, BATCH8_ASSERTER);
    }

    private void assertBatch9(int count, long increment, long ts, long blob, RecordCursor cursor) {
        cursor.toTop();
        Rnd exp = new Rnd();
        long ts2 = this.assertPartialCursor(cursor, exp, ts, increment, blob, 3 * count, (r, rnd1, ts1, blob1) -> {
            BATCH1_9_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH_2_9_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH_3_9_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH_4_9_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
        });
        ts2 = this.assertPartialCursor(cursor, exp, ts2, increment, blob, count, (r, rnd1, ts1, blob1) -> {
            BATCH2_9_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH_3_9_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH_4_9_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
        });
        ts2 = this.assertPartialCursor(cursor, exp, ts2, increment, blob, count, (r, rnd1, ts1, blob1) -> {
            BATCH3_9_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
            BATCH_4_9_BEFORE_ASSERTER.assertRecord(r, rnd1, ts1, blob1);
        });
        ts2 = this.assertPartialCursor(cursor, exp, ts2, increment, blob, count, BATCH5_9_ASSERTER);
        ts2 = this.assertPartialCursor(cursor, exp, ts2, increment, blob, count, BATCH6_9_ASSERTER);
        ts2 = this.assertPartialCursor(cursor, exp, ts2, increment, blob, count, BATCH8_9_ASSERTER);
        this.assertPartialCursor(cursor, exp, ts2, increment, blob, count, BATCH9_ASSERTER);
    }

    private void assertCursor(RecordCursor cursor, long ts, long increment, long blob, long expectedSize, RecordAssert asserter) {
        int i;
        Rnd rnd = new Rnd();
        Record record = cursor.getRecord();
        cursor.toTop();
        int count = 0;
        long timestamp = ts;
        LongList rows = new LongList((int)expectedSize);
        while ((long)count < expectedSize && cursor.hasNext()) {
            ++count;
            asserter.assertRecord(record, rnd, timestamp += increment, blob);
            rows.add(record.getRowId());
        }
        Assert.assertEquals((long)expectedSize, (long)count);
        rnd.reset();
        timestamp = ts;
        for (int i2 = 0; i2 < count; ++i2) {
            cursor.recordAt(rows.getQuick(i2));
            asserter.assertRecord(record, rnd, timestamp += increment, blob);
        }
        rnd.reset();
        timestamp = ts;
        Record rec = cursor.getRecord();
        for (i = 0; i < count; ++i) {
            cursor.recordAt(rec, rows.getQuick(i));
            asserter.assertRecord(rec, rnd, timestamp += increment, blob);
        }
        rnd.reset();
        timestamp = ts;
        rec = cursor.newRecord();
        for (i = 0; i < count; ++i) {
            cursor.recordAt(rec, rows.getQuick(i));
            asserter.assertRecord(rec, rnd, timestamp += increment, blob);
        }
    }

    private long assertPartialCursor(RecordCursor cursor, Rnd rnd, long ts, long increment, long blob, long expectedSize, RecordAssert asserter) {
        int count = 0;
        Record record = cursor.getRecord();
        while ((long)count < expectedSize && cursor.hasNext()) {
            ++count;
            asserter.assertRecord(record, rnd, ts += increment, blob);
        }
        Assert.assertEquals((long)expectedSize, (long)count);
        return ts;
    }

    private long testAppend(TableWriter writer, Rnd rnd, long ts, int count, long inc, long blob, int testPartitionSwitch, FieldGenerator generator) {
        long size = writer.size();
        long timestamp = writer.getMaxTimestamp();
        for (int i = 0; i < count; ++i) {
            TableWriter.Row r = writer.newRow(ts += inc);
            generator.generate(r, rnd, ts, blob);
            r.append();
        }
        writer.commit();
        if (testPartitionSwitch == 1) {
            Assert.assertFalse((boolean)TableUtils.isSamePartition((long)timestamp, (long)writer.getMaxTimestamp(), (int)writer.getPartitionBy()));
        } else if (testPartitionSwitch == 2) {
            Assert.assertTrue((boolean)TableUtils.isSamePartition((long)timestamp, (long)writer.getMaxTimestamp(), (int)writer.getPartitionBy()));
        }
        Assert.assertEquals((long)(size + (long)count), (long)writer.size());
        return ts;
    }

    private long testAppend(Rnd rnd, CairoConfiguration configuration, long ts, int count, long inc, long blob, int testPartitionSwitch) {
        try (TableWriter writer = new TableWriter(configuration, (CharSequence)"all");){
            long l = this.testAppend(writer, rnd, ts, count, inc, blob, testPartitionSwitch, BATCH1_GENERATOR);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCloseColumn(int partitionBy, int count, long increment, String column, RecordAssert assertAfter) throws Exception {
        Rnd rnd = new Rnd();
        final LongList fds = new LongList();
        final String dcol = column + ".d";
        final String icol = column + ".i";
        final TestFilesFacade ff = new TestFilesFacade(){
            boolean called = false;

            public boolean close(long fd) {
                fds.remove(fd);
                return super.close(fd);
            }

            public long openRO(LPSZ name) {
                long fd = super.openRO(name);
                if (Chars.endsWith((CharSequence)name, (CharSequence)dcol) || Chars.endsWith((CharSequence)name, (CharSequence)icol)) {
                    fds.add(fd);
                    this.called = true;
                }
                return fd;
            }

            @Override
            public boolean wasCalled() {
                return this.called;
            }
        };
        long blob = TableReaderTest.allocBlob();
        try {
            TestUtils.assertMemoryLeak(() -> {
                CairoTestUtils.createAllTable(configuration, partitionBy);
                long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
                DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

                    public FilesFacade getFilesFacade() {
                        return ff;
                    }
                };
                this.testAppend(rnd, (CairoConfiguration)configuration, ts, count, increment, blob, 0);
                try (TableReader reader = new TableReader((CairoConfiguration)configuration, (CharSequence)"all");){
                    TableReaderRecordCursor cursor = reader.getCursor();
                    this.assertCursor((RecordCursor)cursor, ts, increment, blob, count, BATCH1_ASSERTER);
                    reader.closeColumnForRemove((CharSequence)column);
                    this.assertCursor((RecordCursor)cursor, ts, increment, blob, count, assertAfter);
                }
                Assert.assertTrue((boolean)ff.wasCalled());
                Assert.assertEquals((long)0L, (long)fds.size());
            });
        }
        finally {
            TableReaderTest.freeBlob(blob);
        }
    }

    private void testReload(int partitionBy, int count, long inct, int testPartitionSwitch) throws Exception {
        long increment = inct * 1000L;
        CairoTestUtils.createAllTable(configuration, partitionBy);
        TestUtils.assertMemoryLeak(() -> {
            Rnd rnd = new Rnd();
            long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
            long blob = TableReaderTest.allocBlob();
            try {
                try (TableReader reader = new TableReader(configuration, (CharSequence)"all");){
                    Assert.assertFalse((boolean)reader.reload());
                    this.assertCursor((RecordCursor)reader.getCursor(), ts, increment, blob, 0L, null);
                }
                reader = new TableReader(configuration, (CharSequence)"all");
                var11_8 = null;
                try {
                    TableReaderRecordCursor cursor = reader.getCursor();
                    Assert.assertFalse((boolean)reader.reload());
                    this.assertCursor((RecordCursor)cursor, ts, increment, blob, 0L, null);
                    Assert.assertFalse((boolean)reader.reload());
                    long nextTs = this.testAppend(rnd, configuration, ts, count, increment, blob, 0);
                    Assert.assertTrue((boolean)reader.reload());
                    this.assertCursor((RecordCursor)cursor, ts, increment, blob, count, BATCH1_ASSERTER);
                    try (TableReader reader2 = new TableReader(configuration, (CharSequence)"all");){
                        this.assertCursor((RecordCursor)reader2.getCursor(), ts, increment, blob, count, BATCH1_ASSERTER);
                    }
                    Assert.assertFalse((boolean)reader.reload());
                    nextTs = this.testAppend(rnd, configuration, nextTs, count, increment, blob, testPartitionSwitch);
                    cursor.toTop();
                    this.assertPartialCursor((RecordCursor)cursor, new Rnd(), ts, increment, blob, count / 4, BATCH1_ASSERTER);
                    Assert.assertTrue((boolean)reader.reload());
                    this.assertCursor((RecordCursor)cursor, ts, increment, blob, 2 * count, BATCH1_ASSERTER);
                    var16_18 = null;
                    try (TableWriter writer = new TableWriter(configuration, (CharSequence)"all");){
                        this.assertCursor((RecordCursor)cursor, ts, increment, blob, 2 * count, BATCH1_ASSERTER);
                        Assert.assertFalse((boolean)reader.reload());
                        this.assertCursor((RecordCursor)cursor, ts, increment, blob, 2 * count, BATCH1_ASSERTER);
                        nextTs = this.testAppend(writer, rnd, nextTs, count, increment, blob, 0, BATCH1_GENERATOR);
                        Assert.assertTrue((boolean)reader.reload());
                        this.assertCursor((RecordCursor)cursor, ts, increment, blob, 3 * count, BATCH1_ASSERTER);
                        writer.addColumn((CharSequence)"str2", 7);
                        nextTs = this.testAppend(writer, rnd, nextTs, count, increment, blob, 0, BATCH2_GENERATOR);
                        Assert.assertTrue((boolean)reader.reload());
                        this.assertBatch2(count, increment, ts, blob, reader);
                        writer.addColumn((CharSequence)"int2", 3);
                        nextTs = this.testAppend(writer, rnd, nextTs, count, increment, blob, 0, BATCH3_GENERATOR);
                        Assert.assertTrue((boolean)reader.reload());
                        this.assertBatch3(count, increment, ts, blob, reader);
                        writer.addColumn((CharSequence)"short2", 2);
                        writer.addColumn((CharSequence)"bool2", 0);
                        writer.addColumn((CharSequence)"byte2", 1);
                        writer.addColumn((CharSequence)"float2", 5);
                        writer.addColumn((CharSequence)"double2", 6);
                        writer.addColumn((CharSequence)"sym2", 8);
                        writer.addColumn((CharSequence)"long2", 4);
                        writer.addColumn((CharSequence)"date2", 10);
                        writer.addColumn((CharSequence)"bin2", 9);
                        nextTs = this.testAppend(writer, rnd, nextTs, count, increment, blob, 0, BATCH4_GENERATOR);
                        Assert.assertTrue((boolean)reader.reload());
                        this.assertBatch4(count, increment, ts, blob, reader);
                        if (configuration.getFilesFacade().isRestrictedFileSystem()) {
                            reader.closeColumnForRemove((CharSequence)"bin2");
                        }
                        writer.removeColumn((CharSequence)"bin2");
                        Assert.assertTrue((boolean)reader.reload());
                        this.assertBatch5(count, increment, ts, blob, (RecordCursor)cursor, new Rnd());
                        nextTs = this.testAppend(writer, rnd, nextTs, count, increment, blob, 0, BATCH6_GENERATOR);
                        Assert.assertTrue((boolean)reader.reload());
                        this.assertBatch6(count, increment, ts, blob, (RecordCursor)cursor);
                        if (configuration.getFilesFacade().isRestrictedFileSystem()) {
                            reader.closeColumnForRemove((CharSequence)"int");
                        }
                        writer.removeColumn((CharSequence)"int");
                        writer.addColumn((CharSequence)"int", 3);
                        Assert.assertTrue((boolean)reader.reload());
                        this.assertBatch7(count, increment, ts, blob, (RecordCursor)cursor);
                        Assert.assertFalse((boolean)reader.reload());
                        nextTs = this.testAppend(writer, rnd, nextTs, count, increment, blob, 0, BATCH8_GENERATOR);
                        Assert.assertTrue((boolean)reader.reload());
                        this.assertBatch8(count, increment, ts, blob, (RecordCursor)cursor);
                        if (configuration.getFilesFacade().isRestrictedFileSystem()) {
                            reader.closeColumnForRemove((CharSequence)"sym");
                        }
                        writer.removeColumn((CharSequence)"sym");
                        writer.addColumn((CharSequence)"sym", 8);
                        Assert.assertTrue((boolean)reader.reload());
                        this.testAppend(writer, rnd, nextTs, count, increment, blob, 0, BATCH9_GENERATOR);
                        Assert.assertTrue((boolean)reader.reload());
                        this.assertBatch9(count, increment, ts, blob, (RecordCursor)cursor);
                    }
                    catch (Throwable throwable) {
                        var16_18 = throwable;
                        throw throwable;
                    }
                }
                catch (Throwable throwable) {
                    var11_8 = throwable;
                    throw throwable;
                }
                finally {
                    if (reader != null) {
                        if (var11_8 != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable) {
                                var11_8.addSuppressed(throwable);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            finally {
                TableReaderTest.freeBlob(blob);
            }
        });
    }

    private void testRemoveActivePartition(int partitionBy, NextPartitionTimestampProvider provider, CharSequence partitionNameToDelete) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 100;
            int N_PARTITIONS = 5;
            long timestampUs = DateFormatUtils.parseDateTime((CharSequence)"2017-12-11T00:00:00.000Z");
            long stride = 100L;
            int bandStride = 1000;
            int totalCount = 0;
            try (TableModel model = new TableModel(configuration, "w", partitionBy).col("l", 4).timestamp();){
                CairoTestUtils.create(model);
            }
            var12_10 = null;
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"w");){
                for (int k = 0; k < N_PARTITIONS; ++k) {
                    long band = k * bandStride;
                    for (int i = 0; i < N; ++i) {
                        TableWriter.Row row = writer.newRow(timestampUs);
                        row.putLong(0, band + (long)i);
                        row.append();
                        writer.commit();
                        timestampUs += stride;
                    }
                    timestampUs = provider.getNext(timestampUs);
                }
                Assert.assertEquals((long)500L, (long)writer.size());
                try (TableReader reader = new TableReader(configuration, (CharSequence)"w");){
                    Assert.assertEquals((long)500L, (long)reader.size());
                    TableReaderRecordCursor cursor = reader.getCursor();
                    Record record = cursor.getRecord();
                    while (cursor.hasNext()) {
                        record.getLong(0);
                        ++totalCount;
                    }
                    Assert.assertEquals((long)500L, (long)totalCount);
                    DateFormat fmt = TableWriter.selectPartitionDirFmt((int)partitionBy);
                    assert (fmt != null);
                    Assert.assertFalse((boolean)writer.removePartition(fmt.parse(partitionNameToDelete, DateLocaleFactory.INSTANCE.getDefaultDateLocale())));
                    Assert.assertEquals((long)500L, (long)writer.size());
                    reader.reload();
                    totalCount = 0;
                    Assert.assertEquals((long)(N * N_PARTITIONS), (long)reader.size());
                    cursor = reader.getCursor();
                    record = cursor.getRecord();
                    while (cursor.hasNext()) {
                        record.getLong(0);
                        ++totalCount;
                    }
                    Assert.assertEquals((long)(N * N_PARTITIONS), (long)totalCount);
                }
            }
            catch (Throwable throwable) {
                var12_10 = throwable;
                throw throwable;
            }
        });
    }

    private void testRemovePartition(int partitionBy, CharSequence partitionNameToDelete, int affectedBand, NextPartitionTimestampProvider provider) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 100;
            int N_PARTITIONS = 5;
            long timestampUs = DateFormatUtils.parseDateTime((CharSequence)"2017-12-11T10:00:00.000Z");
            long stride = 100L;
            int bandStride = 1000;
            int totalCount = 0;
            try (TableModel model = new TableModel(configuration, "w", partitionBy).col("l", 4).timestamp();){
                CairoTestUtils.create(model);
            }
            var13_11 = null;
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"w");){
                for (int k = 0; k < N_PARTITIONS; ++k) {
                    long band = k * bandStride;
                    for (int i = 0; i < N; ++i) {
                        TableWriter.Row row = writer.newRow(timestampUs);
                        row.putLong(0, band + (long)i);
                        row.append();
                        writer.commit();
                        timestampUs += stride;
                    }
                    timestampUs = provider.getNext(timestampUs);
                }
                Assert.assertEquals((long)(N * N_PARTITIONS), (long)writer.size());
                DateFormat fmt = TableWriter.selectPartitionDirFmt((int)partitionBy);
                assert (fmt != null);
                long timestamp = fmt.parse(partitionNameToDelete, DateLocaleFactory.INSTANCE.getDefaultDateLocale());
                Assert.assertTrue((boolean)writer.removePartition(timestamp));
                Assert.assertFalse((boolean)writer.removePartition(timestamp));
                Assert.assertEquals((long)(N * (N_PARTITIONS - 1)), (long)writer.size());
            }
            catch (Throwable fmt) {
                var13_11 = fmt;
                throw fmt;
            }
            var13_11 = null;
            try (TableReader reader = new TableReader(configuration, (CharSequence)"w");){
                Assert.assertEquals((long)(N * (N_PARTITIONS - 1)), (long)reader.size());
                int previousBand = -1;
                int bandCount = 0;
                TableReaderRecordCursor cursor = reader.getCursor();
                Record record = cursor.getRecord();
                while (cursor.hasNext()) {
                    long value = record.getLong(0);
                    int band = (int)(value / (long)bandStride * (long)bandStride);
                    if (band != previousBand) {
                        Assert.assertNotEquals((long)affectedBand, (long)band);
                        if (previousBand != -1) {
                            Assert.assertEquals((long)N, (long)bandCount);
                        }
                        previousBand = band;
                        bandCount = 0;
                    }
                    ++bandCount;
                    ++totalCount;
                }
                Assert.assertEquals((long)N, (long)bandCount);
            }
            catch (Throwable throwable) {
                var13_11 = throwable;
                throw throwable;
            }
            Assert.assertEquals((long)(N * (N_PARTITIONS - 1)), (long)totalCount);
        });
    }

    private void testRemovePartitionReload(int partitionBy, CharSequence partitionNameToDelete, int affectedBand, NextPartitionTimestampProvider provider) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 100;
            int N_PARTITIONS = 5;
            long timestampUs = DateFormatUtils.parseDateTime((CharSequence)"2017-12-11T00:00:00.000Z");
            long stride = 100L;
            int bandStride = 1000;
            int totalCount = 0;
            try (TableModel model = new TableModel(configuration, "w", partitionBy).col("l", 4).timestamp();){
                CairoTestUtils.create(model);
            }
            var13_11 = null;
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"w");){
                for (int k = 0; k < N_PARTITIONS; ++k) {
                    long band = k * bandStride;
                    for (int i = 0; i < N; ++i) {
                        TableWriter.Row row = writer.newRow(timestampUs);
                        row.putLong(0, band + (long)i);
                        row.append();
                        writer.commit();
                        timestampUs += stride;
                    }
                    timestampUs = provider.getNext(timestampUs);
                }
                Assert.assertEquals((long)(N * N_PARTITIONS), (long)writer.size());
                try (TableReader reader = new TableReader(configuration, (CharSequence)"w");){
                    Assert.assertEquals((long)(N * N_PARTITIONS), (long)reader.size());
                    TableReaderRecordCursor cursor = reader.getCursor();
                    Record record = cursor.getRecord();
                    while (cursor.hasNext()) {
                        record.getLong(0);
                        ++totalCount;
                    }
                    Assert.assertEquals((long)(N * N_PARTITIONS), (long)totalCount);
                    DateFormat fmt = TableWriter.selectPartitionDirFmt((int)partitionBy);
                    assert (fmt != null);
                    Assert.assertTrue((boolean)writer.removePartition(fmt.parse(partitionNameToDelete, DateLocaleFactory.INSTANCE.getDefaultDateLocale())));
                    Assert.assertEquals((long)(N * (N_PARTITIONS - 1)), (long)writer.size());
                    reader.reload();
                    totalCount = 0;
                    Assert.assertEquals((long)(N * (N_PARTITIONS - 1)), (long)reader.size());
                    int previousBand = -1;
                    int bandCount = 0;
                    cursor = reader.getCursor();
                    record = cursor.getRecord();
                    while (cursor.hasNext()) {
                        long value = record.getLong(0);
                        int band = (int)(value / (long)bandStride * (long)bandStride);
                        if (band != previousBand) {
                            Assert.assertNotEquals((long)affectedBand, (long)band);
                            if (previousBand != -1) {
                                Assert.assertEquals((long)N, (long)bandCount);
                            }
                            previousBand = band;
                            bandCount = 0;
                        }
                        ++bandCount;
                        ++totalCount;
                    }
                    Assert.assertEquals((long)N, (long)bandCount);
                }
            }
            catch (Throwable throwable) {
                var13_11 = throwable;
                throw throwable;
            }
            Assert.assertEquals((long)(N * (N_PARTITIONS - 1)), (long)totalCount);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testSwitchPartitionFail(final RecoverableTestFilesFacade ff) throws Exception {
        Rnd rnd = new Rnd();
        int count = 1000;
        long increment = 3600000000L;
        long blob = TableReaderTest.allocBlob();
        try {
            TestUtils.assertMemoryLeak(() -> {
                CairoTestUtils.createAllTable(configuration, 0);
                long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z");
                DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

                    public FilesFacade getFilesFacade() {
                        return ff;
                    }
                };
                this.testAppend(rnd, (CairoConfiguration)configuration, ts, count, increment, blob, 0);
                try (TableReader reader = new TableReader((CairoConfiguration)configuration, (CharSequence)"all");){
                    TableReaderRecordCursor cursor = reader.getCursor();
                    try {
                        this.assertCursor((RecordCursor)cursor, ts, increment, blob, count, BATCH1_ASSERTER);
                        Assert.fail();
                    }
                    catch (CairoException cairoException) {
                        // empty catch block
                    }
                    ff.setRecovered(true);
                    this.assertCursor((RecordCursor)cursor, ts, increment, blob, count, BATCH1_ASSERTER);
                }
                Assert.assertTrue((boolean)ff.wasCalled());
            });
        }
        finally {
            TableReaderTest.freeBlob(blob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testTableCursor(long inc) throws NumericException {
        Rnd rnd = new Rnd();
        int N = 100;
        long ts = DateFormatUtils.parseDateTime((CharSequence)"2013-03-04T00:00:00.000Z") / 1000L;
        long blob = TableReaderTest.allocBlob();
        try {
            this.testAppend(rnd, configuration, ts, N, inc, blob, 0);
            LongList rows = new LongList();
            try (TableReader reader = new TableReader(configuration, (CharSequence)"all");){
                Assert.assertEquals((long)N, (long)reader.size());
                TableReaderRecordCursor cursor = reader.getCursor();
                Record record = cursor.getRecord();
                this.assertCursor((RecordCursor)cursor, ts, inc, blob, N, BATCH1_ASSERTER);
                cursor.toTop();
                while (cursor.hasNext()) {
                    rows.add(record.getRowId());
                }
                Rnd exp = new Rnd();
                int n = rows.size();
                for (int i = 0; i < n; ++i) {
                    cursor.recordAt(rows.getQuick(i));
                    BATCH1_ASSERTER.assertRecord(record, exp, ts += inc, blob);
                }
            }
        }
        finally {
            TableReaderTest.freeBlob(blob);
        }
    }

    private void testTableCursor() throws NumericException {
        this.testTableCursor(3600000L);
    }

    private abstract class RecoverableTestFilesFacade
    extends TestFilesFacade {
        protected boolean recovered = false;

        private RecoverableTestFilesFacade() {
        }

        public void setRecovered(boolean recovered) {
            this.recovered = recovered;
        }
    }

    @FunctionalInterface
    private static interface FieldGenerator {
        public void generate(TableWriter.Row var1, Rnd var2, long var3, long var5);
    }

    private static interface RecordAssert {
        public void assertRecord(Record var1, Rnd var2, long var3, long var5);
    }

    @FunctionalInterface
    private static interface NextPartitionTimestampProvider {
        public long getNext(long var1);
    }
}

