/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.TableModel;
import com.questdb.cairo.TableReader;
import com.questdb.cairo.TableReaderRecordCursor;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.sql.Record;
import com.questdb.cairo.sql.RecordCursor;
import com.questdb.std.Os;
import com.questdb.std.Rnd;
import com.questdb.std.Unsafe;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TableReaderReloadTest
extends AbstractCairoTest {
    @Test
    public void testReloadTruncateByDay() {
        this.testReloadAfterTruncate(0, 3000000000L);
    }

    @Test
    public void testReloadTruncateByMonth() {
        this.testReloadAfterTruncate(1, 50000000000L);
    }

    @Test
    public void testReloadTruncateByNone() {
        this.testReloadAfterTruncate(3, 1000000L);
    }

    @Test
    public void testReloadTruncateByYear() {
        this.testReloadAfterTruncate(2, 18250000000000L);
    }

    private void assertTable(Rnd rnd, long buffer, RecordCursor cursor, Record record) {
        while (cursor.hasNext()) {
            Assert.assertEquals((long)rnd.nextInt(), (long)record.getInt(0));
            Assert.assertEquals((long)rnd.nextShort(), (long)record.getShort(1));
            Assert.assertEquals((long)rnd.nextByte(), (long)record.getByte(2));
            Assert.assertEquals((double)rnd.nextDouble2(), (double)record.getDouble(3), (double)1.0E-5);
            Assert.assertEquals((double)rnd.nextFloat2(), (double)record.getFloat(4), (double)1.0E-5);
            Assert.assertEquals((long)rnd.nextLong(), (long)record.getLong(5));
            TestUtils.assertEquals(rnd.nextChars(3), record.getStr(6));
            TestUtils.assertEquals(rnd.nextChars(2), record.getSym(7));
            Assert.assertEquals((Object)rnd.nextBoolean(), (Object)record.getBool(8));
            rnd.nextChars(buffer, 512);
            Assert.assertEquals((long)rnd.nextLong(), (long)record.getDate(10));
        }
    }

    private void populateTable(Rnd rnd, long buffer, long timestamp, long increment, TableWriter writer) {
        for (int i = 0; i < 100; ++i) {
            TableWriter.Row row = writer.newRow(timestamp);
            row.putInt(0, rnd.nextInt());
            row.putShort(1, rnd.nextShort());
            row.putByte(2, rnd.nextByte());
            row.putDouble(3, rnd.nextDouble2());
            row.putFloat(4, rnd.nextFloat2());
            row.putLong(5, rnd.nextLong());
            row.putStr(6, rnd.nextChars(3));
            row.putSym(7, rnd.nextChars(2));
            row.putBool(8, rnd.nextBoolean());
            rnd.nextChars(buffer, 512);
            row.putBin(9, buffer, 1024L);
            row.putDate(10, rnd.nextLong());
            row.append();
            timestamp += increment;
        }
        writer.commit();
    }

    private void testReloadAfterTruncate(int partitionBy, long increment) {
        if (Os.type == 3) {
            return;
        }
        Rnd rnd = new Rnd();
        int bufferSize = 1024;
        long buffer = Unsafe.malloc((long)1024L);
        try (TableModel model = CairoTestUtils.getAllTypesModel(configuration, partitionBy);){
            model.timestamp();
            CairoTestUtils.create(model);
        }
        long timestamp = 0L;
        try (TableWriter writer = new TableWriter(configuration, (CharSequence)"all");){
            try (TableReader reader = new TableReader(configuration, (CharSequence)"all");){
                Assert.assertFalse((boolean)reader.reload());
            }
            this.populateTable(rnd, buffer, timestamp, increment, writer);
            rnd.reset();
            reader = new TableReader(configuration, (CharSequence)"all");
            var13_18 = null;
            try {
                TableReaderRecordCursor cursor = reader.getCursor();
                Record record = cursor.getRecord();
                this.assertTable(rnd, buffer, (RecordCursor)cursor, record);
                writer.truncate();
                Assert.assertTrue((boolean)reader.reload());
                cursor = reader.getCursor();
                Assert.assertFalse((boolean)cursor.hasNext());
                rnd.reset();
                this.populateTable(rnd, buffer, timestamp, increment, writer);
                Assert.assertTrue((boolean)reader.reload());
                rnd.reset();
                cursor = reader.getCursor();
                this.assertTable(rnd, buffer, (RecordCursor)cursor, record);
            }
            catch (Throwable throwable) {
                var13_18 = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (var13_18 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            var13_18.addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        }
    }
}

