/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.Engine;
import com.questdb.cairo.GenericRecordMetadata;
import com.questdb.cairo.TableModel;
import com.questdb.cairo.TableReader;
import com.questdb.cairo.TableReaderRecordCursorFactory;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.sql.CairoEngine;
import com.questdb.cairo.sql.Record;
import com.questdb.cairo.sql.RecordCursor;
import com.questdb.cairo.sql.RecordMetadata;
import com.questdb.griffin.engine.functions.bind.BindVariableService;
import com.questdb.std.Rnd;
import com.questdb.std.str.CharSink;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TableReaderRecordCursorFactoryTest
extends AbstractCairoTest {
    @Test
    public void testFactory() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 100;
            try (TableModel model = new TableModel(configuration, "x", 0).col("a", 7).col("b", 8).indexed(true, 25).col("i", 3).col("c", 8).indexed(true, 25).timestamp();){
                CairoTestUtils.create(model);
            }
            String expectedMetadata = "{\"columnCount\":5,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"STRING\"},{\"index\":1,\"name\":\"b\",\"type\":\"SYMBOL\",\"indexed\":true,\"indexValueBlockCapacity\":32},{\"index\":2,\"name\":\"i\",\"type\":\"INT\"},{\"index\":3,\"name\":\"c\",\"type\":\"SYMBOL\",\"indexed\":true,\"indexValueBlockCapacity\":32},{\"index\":4,\"name\":\"timestamp\",\"type\":\"TIMESTAMP\"}],\"timestampIndex\":4}";
            Rnd rnd = new Rnd();
            String[] symbols = new String[100];
            int M = 1000;
            long increment = 600000000L;
            for (int i = 0; i < 100; ++i) {
                symbols[i] = rnd.nextChars(8).toString();
            }
            rnd.reset();
            long timestamp = 0L;
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"x");){
                for (int i = 0; i < 1000; ++i) {
                    TableWriter.Row row = writer.newRow(timestamp += 600000000L);
                    row.putStr(0, rnd.nextChars(20));
                    row.putSym(1, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                    row.putInt(2, rnd.nextInt());
                    row.putSym(3, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                    row.append();
                }
                writer.commit();
            }
            var10_13 = null;
            try (Engine engine = new Engine(configuration);){
                GenericRecordMetadata metadata;
                try (TableReader reader = engine.getReader((CharSequence)"x", -1L);){
                    metadata = GenericRecordMetadata.copyOf((RecordMetadata)reader.getMetadata());
                }
                var13_22 = null;
                try (TableReaderRecordCursorFactory factory = new TableReaderRecordCursorFactory((RecordMetadata)metadata, (CairoEngine)engine, "x", -1L);){
                    long count = 0L;
                    BindVariableService bindVariableService = new BindVariableService();
                    try (RecordCursor cursor = factory.getCursor(bindVariableService);){
                        Record record = cursor.getRecord();
                        rnd.reset();
                        while (cursor.hasNext()) {
                            TestUtils.assertEquals(rnd.nextChars(20), record.getStr(0));
                            TestUtils.assertEquals((CharSequence)symbols[rnd.nextPositiveInt() % 100], record.getSym(1));
                            Assert.assertEquals((long)rnd.nextInt(), (long)record.getInt(2));
                            TestUtils.assertEquals((CharSequence)symbols[rnd.nextPositiveInt() % 100], record.getSym(3));
                            ++count;
                        }
                        sink.clear();
                        factory.getMetadata().toJson((CharSink)sink);
                        TestUtils.assertEquals((CharSequence)"{\"columnCount\":5,\"columns\":[{\"index\":0,\"name\":\"a\",\"type\":\"STRING\"},{\"index\":1,\"name\":\"b\",\"type\":\"SYMBOL\",\"indexed\":true,\"indexValueBlockCapacity\":32},{\"index\":2,\"name\":\"i\",\"type\":\"INT\"},{\"index\":3,\"name\":\"c\",\"type\":\"SYMBOL\",\"indexed\":true,\"indexValueBlockCapacity\":32},{\"index\":4,\"name\":\"timestamp\",\"type\":\"TIMESTAMP\"}],\"timestampIndex\":4}", (CharSequence)sink);
                    }
                    Assert.assertEquals((long)0L, (long)engine.getBusyReaderCount());
                    Assert.assertEquals((long)1000L, (long)count);
                    Assert.assertTrue((boolean)factory.isRandomAccessCursor());
                }
                catch (Throwable throwable) {
                    var13_22 = throwable;
                    throw throwable;
                }
            }
            catch (Throwable throwable) {
                var10_13 = throwable;
                throw throwable;
            }
        });
    }
}

