/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.ColumnType;
import com.questdb.cairo.TableModel;
import com.questdb.cairo.TableReaderMetadata;
import com.questdb.cairo.TableReaderMetadataTest;
import com.questdb.cairo.TableWriter;
import com.questdb.std.FilesFacadeImpl;
import com.questdb.std.str.Path;
import com.questdb.std.str.StringSink;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TableReaderMetadataTimestampTest
extends AbstractCairoTest {
    @Test
    public void testReAddColumn() throws Exception {
        try (TableModel model = CairoTestUtils.getAllTypesModel(configuration, 3);){
            model.timestamp();
            CairoTestUtils.create(model);
        }
        String expected = "int:INT\nshort:SHORT\nbyte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\nlong:LONG\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\ntimestamp:TIMESTAMP\nstr:STRING\n";
        this.assertThatTimestampRemains(w -> {
            w.removeColumn((CharSequence)"str");
            w.addColumn((CharSequence)"str", 7);
        }, "int:INT\nshort:SHORT\nbyte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\nlong:LONG\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\ntimestamp:TIMESTAMP\nstr:STRING\n", 11, 10, 12);
    }

    @Test
    public void testRemoveColumnAfterTimestamp() throws Exception {
        try (TableModel model = new TableModel(configuration, "all", 3).col("int", 3).col("short", 2).col("byte", 1).col("double", 6).col("float", 5).timestamp().col("long", 4).col("str", 7).col("sym", 8).col("bool", 0).col("bin", 9).col("date", 10);){
            CairoTestUtils.create(model);
        }
        String expected = "int:INT\nshort:SHORT\nbyte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\ntimestamp:TIMESTAMP\nlong:LONG\nstr:STRING\nsym:SYMBOL\nbool:BOOLEAN\ndate:DATE\n";
        this.assertThatTimestampRemains(w -> w.removeColumn((CharSequence)"bin"), "int:INT\nshort:SHORT\nbyte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\ntimestamp:TIMESTAMP\nlong:LONG\nstr:STRING\nsym:SYMBOL\nbool:BOOLEAN\ndate:DATE\n", 5, 5, 11);
    }

    @Test
    public void testRemoveColumnBeforeTimestamp() throws Exception {
        try (TableModel model = CairoTestUtils.getAllTypesModel(configuration, 3);){
            model.timestamp();
            CairoTestUtils.create(model);
        }
        String expected = "int:INT\nshort:SHORT\nbyte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\nlong:LONG\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\ntimestamp:TIMESTAMP\n";
        this.assertThatTimestampRemains(w -> w.removeColumn((CharSequence)"str"), "int:INT\nshort:SHORT\nbyte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\nlong:LONG\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\ntimestamp:TIMESTAMP\n", 11, 10, 11);
    }

    @Test
    public void testRemoveFirstTimestamp() throws Exception {
        try (TableModel model = new TableModel(configuration, "all", 3).timestamp().col("int", 3).col("short", 2).col("byte", 1).col("double", 6).col("float", 5).col("long", 4).col("str", 7).col("sym", 8).col("bool", 0).col("bin", 9).col("date", 10);){
            CairoTestUtils.create(model);
        }
        String expected = "int:INT\nshort:SHORT\nbyte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\nlong:LONG\nstr:STRING\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\n";
        this.assertThat("int:INT\nshort:SHORT\nbyte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\nlong:LONG\nstr:STRING\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\n", 0);
    }

    @Test
    public void testRemoveMiddleTimestamp() throws Exception {
        try (TableModel model = new TableModel(configuration, "all", 3).col("int", 3).col("short", 2).col("byte", 1).col("double", 6).col("float", 5).timestamp().col("long", 4).col("str", 7).col("sym", 8).col("bool", 0).col("bin", 9).col("date", 10);){
            CairoTestUtils.create(model);
        }
        String expected = "int:INT\nshort:SHORT\nbyte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\nlong:LONG\nstr:STRING\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\n";
        this.assertThat("int:INT\nshort:SHORT\nbyte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\nlong:LONG\nstr:STRING\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\n", 5);
    }

    @Test
    public void testRemoveTailTimestamp() throws Exception {
        try (TableModel model = CairoTestUtils.getAllTypesModel(configuration, 3).timestamp();){
            CairoTestUtils.create(model);
        }
        String expected = "int:INT\nshort:SHORT\nbyte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\nlong:LONG\nstr:STRING\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\n";
        this.assertThat("int:INT\nshort:SHORT\nbyte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\nlong:LONG\nstr:STRING\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\n", 11);
    }

    private void assertThat(String expected, int expectedInitialTimestampIndex) throws Exception {
        int columnCount = 11;
        TestUtils.assertMemoryLeak(() -> {
            try (Path path = new Path().of(root).concat((CharSequence)"all");
                 TableReaderMetadata metadata = new TableReaderMetadata(FilesFacadeImpl.INSTANCE, path.concat((CharSequence)"_meta").$());){
                Assert.assertEquals((long)12L, (long)metadata.getColumnCount());
                Assert.assertEquals((long)expectedInitialTimestampIndex, (long)metadata.getTimestampIndex());
                try (TableWriter writer = new TableWriter(configuration, (CharSequence)"all");){
                    writer.removeColumn((CharSequence)"timestamp");
                }
                long pTransitionIndex = metadata.createTransitionIndex();
                StringSink sink = new StringSink();
                try {
                    metadata.applyTransitionIndex(pTransitionIndex);
                    Assert.assertEquals((long)columnCount, (long)metadata.getColumnCount());
                    for (int i = 0; i < columnCount; ++i) {
                        sink.put(metadata.getColumnName(i)).put(':').put((CharSequence)ColumnType.nameOf((int)metadata.getColumnType(i))).put('\n');
                    }
                    TestUtils.assertEquals((CharSequence)expected, (CharSequence)sink);
                    Assert.assertEquals((long)-1L, (long)metadata.getTimestampIndex());
                }
                finally {
                    TableReaderMetadata.freeTransitionIndex((long)pTransitionIndex);
                }
            }
        });
    }

    private void assertThatTimestampRemains(TableReaderMetadataTest.ColumnManipulator manipulator, String expected, int expectedInitialTimestampIndex, int expectedFinalTimestampIndex, int expectedColumnCount) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (Path path = new Path().of(root).concat((CharSequence)"all");
                 TableReaderMetadata metadata = new TableReaderMetadata(FilesFacadeImpl.INSTANCE, path.concat((CharSequence)"_meta").$());){
                Assert.assertEquals((long)12L, (long)metadata.getColumnCount());
                Assert.assertEquals((long)expectedInitialTimestampIndex, (long)metadata.getTimestampIndex());
                try (TableWriter writer = new TableWriter(configuration, (CharSequence)"all");){
                    manipulator.restructure(writer);
                }
                long address = metadata.createTransitionIndex();
                StringSink sink = new StringSink();
                try {
                    metadata.applyTransitionIndex(address);
                    Assert.assertEquals((long)expectedColumnCount, (long)metadata.getColumnCount());
                    for (int i = 0; i < expectedColumnCount; ++i) {
                        sink.put(metadata.getColumnName(i)).put(':').put((CharSequence)ColumnType.nameOf((int)metadata.getColumnType(i))).put('\n');
                    }
                    TestUtils.assertEquals((CharSequence)expected, (CharSequence)sink);
                    Assert.assertEquals((long)expectedFinalTimestampIndex, (long)metadata.getTimestampIndex());
                }
                finally {
                    TableReaderMetadata.freeTransitionIndex((long)address);
                }
            }
        });
    }
}

