/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.ColumnType;
import com.questdb.cairo.TableReaderMetadata;
import com.questdb.cairo.TableWriter;
import com.questdb.std.FilesFacadeImpl;
import com.questdb.std.ObjIntHashMap;
import com.questdb.std.str.Path;
import com.questdb.std.str.StringSink;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TableReaderMetadataTest
extends AbstractCairoTest {
    @Before
    public void setUp2() {
        CairoTestUtils.createAllTable(configuration, 0);
    }

    @Test
    public void testAddColumn() throws Exception {
        String expected = "int:INT\nshort:SHORT\nbyte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\nlong:LONG\nstr:STRING\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\nxyz:STRING\n";
        this.assertThat("int:INT\nshort:SHORT\nbyte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\nlong:LONG\nstr:STRING\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\nxyz:STRING\n", w -> w.addColumn((CharSequence)"xyz", 7), 12);
    }

    @Test
    public void testColumnIndex() {
        ObjIntHashMap expected = new ObjIntHashMap();
        expected.put((Object)"int", 0);
        expected.put((Object)"byte", 2);
        expected.put((Object)"bin", 9);
        expected.put((Object)"short", 1);
        expected.put((Object)"float", 4);
        expected.put((Object)"long", 5);
        expected.put((Object)"xyz", -1);
        expected.put((Object)"str", 6);
        expected.put((Object)"double", 3);
        expected.put((Object)"sym", 7);
        expected.put((Object)"bool", 8);
        expected.put((Object)"zall.sym", -1);
        try (Path path = new Path().of(root).concat((CharSequence)"all").concat((CharSequence)"_meta").$();
             TableReaderMetadata metadata = new TableReaderMetadata(FilesFacadeImpl.INSTANCE, path);){
            for (ObjIntHashMap.Entry e : expected) {
                Assert.assertEquals((long)e.value, (long)metadata.getColumnIndexQuiet((CharSequence)e.key));
            }
        }
    }

    @Test
    public void testDeleteTwoAddOneColumn() throws Exception {
        String expected = "int:INT\nshort:SHORT\nbyte:BYTE\nfloat:FLOAT\nlong:LONG\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\nxyz:STRING\n";
        this.assertThat("int:INT\nshort:SHORT\nbyte:BYTE\nfloat:FLOAT\nlong:LONG\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\nxyz:STRING\n", w -> {
            w.removeColumn((CharSequence)"double");
            w.removeColumn((CharSequence)"str");
            w.addColumn((CharSequence)"xyz", 7);
        }, 10);
    }

    @Test
    public void testFreeNullAddressAsIndex() {
        TableReaderMetadata.freeTransitionIndex((long)0L);
    }

    @Test
    public void testRemoveAllColumns() throws Exception {
        String expected = "";
        this.assertThat("", w -> {
            w.removeColumn((CharSequence)"int");
            w.removeColumn((CharSequence)"short");
            w.removeColumn((CharSequence)"byte");
            w.removeColumn((CharSequence)"float");
            w.removeColumn((CharSequence)"long");
            w.removeColumn((CharSequence)"str");
            w.removeColumn((CharSequence)"sym");
            w.removeColumn((CharSequence)"bool");
            w.removeColumn((CharSequence)"bin");
            w.removeColumn((CharSequence)"date");
            w.removeColumn((CharSequence)"double");
        }, 0);
    }

    @Test
    public void testRemoveAndAddSameColumn() throws Exception {
        String expected = "int:INT\nshort:SHORT\nbyte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\nlong:LONG\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\nstr:STRING\n";
        this.assertThat("int:INT\nshort:SHORT\nbyte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\nlong:LONG\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\nstr:STRING\n", w -> {
            w.removeColumn((CharSequence)"str");
            w.addColumn((CharSequence)"str", 7);
        }, 11);
    }

    @Test
    public void testRemoveColumnAndReAdd() throws Exception {
        String expected = "byte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\nlong:LONG\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\nstr:STRING\nshort:INT\n";
        this.assertThat("byte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\nlong:LONG\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\nstr:STRING\nshort:INT\n", w -> {
            w.removeColumn((CharSequence)"short");
            w.removeColumn((CharSequence)"str");
            w.removeColumn((CharSequence)"int");
            w.addColumn((CharSequence)"str", 7);
            w.addColumn((CharSequence)"short", 3);
        }, 10);
    }

    @Test
    public void testRemoveDenseColumns() throws Exception {
        String expected = "int:INT\nshort:SHORT\nbyte:BYTE\nlong:LONG\nstr:STRING\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\n";
        this.assertThat("int:INT\nshort:SHORT\nbyte:BYTE\nlong:LONG\nstr:STRING\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\n", w -> {
            w.removeColumn((CharSequence)"double");
            w.removeColumn((CharSequence)"float");
        }, 9);
    }

    @Test
    public void testRemoveFirstAndLastColumns() throws Exception {
        String expected = "short:SHORT\nbyte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\nlong:LONG\nstr:STRING\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\n";
        this.assertThat("short:SHORT\nbyte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\nlong:LONG\nstr:STRING\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\n", w -> {
            w.removeColumn((CharSequence)"date");
            w.removeColumn((CharSequence)"int");
        }, 9);
    }

    @Test
    public void testRemoveFirstColumn() throws Exception {
        String expected = "short:SHORT\nbyte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\nlong:LONG\nstr:STRING\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\n";
        this.assertThat("short:SHORT\nbyte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\nlong:LONG\nstr:STRING\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\n", w -> w.removeColumn((CharSequence)"int"), 10);
    }

    @Test
    public void testRemoveLastColumn() throws Exception {
        String expected = "int:INT\nshort:SHORT\nbyte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\nlong:LONG\nstr:STRING\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\n";
        this.assertThat("int:INT\nshort:SHORT\nbyte:BYTE\ndouble:DOUBLE\nfloat:FLOAT\nlong:LONG\nstr:STRING\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\n", w -> w.removeColumn((CharSequence)"date"), 10);
    }

    @Test
    public void testRemoveSparseColumns() throws Exception {
        String expected = "int:INT\nshort:SHORT\nbyte:BYTE\nfloat:FLOAT\nlong:LONG\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\n";
        this.assertThat("int:INT\nshort:SHORT\nbyte:BYTE\nfloat:FLOAT\nlong:LONG\nsym:SYMBOL\nbool:BOOLEAN\nbin:BINARY\ndate:DATE\n", w -> {
            w.removeColumn((CharSequence)"double");
            w.removeColumn((CharSequence)"str");
        }, 9);
    }

    private void assertThat(String expected, ColumnManipulator manipulator, int columnCount) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (Path path = new Path().of(root).concat((CharSequence)"all");
                 TableReaderMetadata metadata = new TableReaderMetadata(FilesFacadeImpl.INSTANCE, path.concat((CharSequence)"_meta").$());){
                try (TableWriter writer = new TableWriter(configuration, (CharSequence)"all");){
                    manipulator.restructure(writer);
                }
                long pTransitionIndex = metadata.createTransitionIndex();
                StringSink sink = new StringSink();
                try {
                    metadata.applyTransitionIndex(pTransitionIndex);
                    Assert.assertEquals((long)columnCount, (long)metadata.getColumnCount());
                    for (int i = 0; i < columnCount; ++i) {
                        sink.put(metadata.getColumnName(i)).put(':').put((CharSequence)ColumnType.nameOf((int)metadata.getColumnType(i))).put('\n');
                    }
                    TestUtils.assertEquals((CharSequence)expected, (CharSequence)sink);
                    if (expected.length() > 0) {
                        String[] lines = expected.split("\n");
                        Assert.assertEquals((long)columnCount, (long)lines.length);
                        for (int i = 0; i < columnCount; ++i) {
                            int p = lines[i].indexOf(58);
                            Assert.assertEquals((long)i, (long)metadata.getColumnIndexQuiet((CharSequence)lines[i].substring(0, p)));
                        }
                    }
                }
                finally {
                    TableReaderMetadata.freeTransitionIndex((long)pTransitionIndex);
                }
            }
        });
    }

    @FunctionalInterface
    public static interface ColumnManipulator {
        public void restructure(TableWriter var1);
    }
}

