/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.AppendMemory;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.TableReaderMetadata;
import com.questdb.std.Files;
import com.questdb.std.FilesFacadeImpl;
import com.questdb.std.Os;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.Path;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TableReaderMetadataCorruptionTest
extends AbstractCairoTest {
    @Test
    public void testColumnCountIsBeyondFileSize() throws Exception {
        String[] names = new String[]{"a", "b", "c", "d", "b", "f"};
        int[] types = new int[]{3, 3, 7, 4, 10, 12};
        this.assertMetaConstructorFailure(names, types, names.length + 1, 3, 5, "page outside of file boundary");
    }

    @Test
    public void testDuplicateColumnName() throws Exception {
        String[] names = new String[]{"a", "b", "c", "d", "b", "f"};
        int[] types = new int[]{3, 3, 7, 4, 10, 12};
        this.assertMetaConstructorFailure(names, types, names.length, 3, 5, "Duplicate");
    }

    @Test
    public void testIncorrectTimestampIndex1() throws Exception {
        String[] names = new String[]{"a", "b", "c", "d", "e", "f"};
        int[] types = new int[]{3, 3, 7, 4, 10, 10};
        this.assertMetaConstructorFailure(names, types, names.length, 3, 23, "Timestamp");
    }

    @Test
    public void testIncorrectTimestampIndex2() throws Exception {
        String[] names = new String[]{"a", "b", "c", "d", "e", "f"};
        int[] types = new int[]{3, 3, 7, 4, 10, 10};
        this.assertMetaConstructorFailure(names, types, names.length, 3, -2, "Timestamp");
    }

    @Test
    public void testIncorrectTimestampIndex3() throws Exception {
        String[] names = new String[]{"a", "b", "c", "d", "e", "f"};
        int[] types = new int[]{3, 3, 7, 4, 10, 10};
        int timestampIndex = 2;
        Assert.assertEquals((long)7L, (long)types[timestampIndex]);
        this.assertMetaConstructorFailure(names, types, names.length, 3, timestampIndex, "STRING");
    }

    @Test
    public void testInvalidColumnType() throws Exception {
        String[] names = new String[]{"a", "b", "c", "d", "e", "f"};
        int[] types = new int[]{3, 3, 566, 4, 10, 12};
        this.assertMetaConstructorFailure(names, types, names.length, 3, 5, "Invalid column type");
    }

    @Test
    public void testNullColumnName() throws Exception {
        String[] names = new String[]{"a", "b", "c", null, "e", "f"};
        int[] types = new int[]{3, 3, 7, 4, 10, 12};
        this.assertMetaConstructorFailure(names, types, names.length, 3, 5, "NULL column");
    }

    @Test
    public void testTransitionIndexWhenColumnCountIsBeyondFileSize() throws Exception {
        if (Os.type != 3) {
            this.assertTransitionIndexValidation(99);
        }
    }

    @Test
    public void testTransitionIndexWhenColumnCountOverflows() throws Exception {
        this.assertTransitionIndexValidation(0x7FFFFFFE);
    }

    private void assertMetaConstructorFailure(String[] names, int[] types, int columnCount, int partitionType, int timestampIndex, String contains) throws Exception {
        this.assertMetaConstructorFailure(names, types, columnCount, partitionType, timestampIndex, contains, FilesFacadeImpl.INSTANCE.getPageSize());
        this.assertMetaConstructorFailure(names, types, columnCount, partitionType, timestampIndex, contains, 65536L);
    }

    private void assertMetaConstructorFailure(String[] names, int[] types, int columnCount, int partitionType, int timestampIndex, String contains, long pageSize) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (Path path = new Path();){
                path.of(root).concat((CharSequence)"x");
                int rootLen = path.length();
                if (FilesFacadeImpl.INSTANCE.mkdirs((LPSZ)path.put(Files.SEPARATOR).$(), configuration.getMkDirMode()) == -1) {
                    throw CairoException.instance((int)FilesFacadeImpl.INSTANCE.errno()).put((CharSequence)"Cannot create dir: ").put((CharSequence)path);
                }
                try (AppendMemory mem = new AppendMemory();){
                    int i;
                    mem.of(FilesFacadeImpl.INSTANCE, (LPSZ)path.trimTo(rootLen).concat((CharSequence)"_meta").$(), pageSize);
                    mem.putInt(columnCount);
                    mem.putInt(partitionType);
                    mem.putInt(timestampIndex);
                    mem.jumpTo(128L);
                    for (i = 0; i < names.length; ++i) {
                        mem.putByte((byte)types[i]);
                        mem.putBool(false);
                        mem.skip(14L);
                    }
                    for (i = 0; i < names.length; ++i) {
                        mem.putStr((CharSequence)names[i]);
                    }
                }
                try {
                    new TableReaderMetadata(FilesFacadeImpl.INSTANCE, path);
                    Assert.fail();
                }
                catch (CairoException e) {
                    TestUtils.assertContains(e.getMessage(), contains);
                }
            }
        });
    }

    private void assertTransitionIndexValidation(int columnCount) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (Path path = new Path();){
                CairoTestUtils.createAllTable(configuration, 3);
                path.of(root).concat((CharSequence)"all").concat((CharSequence)"_meta").$();
                long len = FilesFacadeImpl.INSTANCE.length((LPSZ)path);
                try (TableReaderMetadata metadata = new TableReaderMetadata(FilesFacadeImpl.INSTANCE, path);){
                    try (AppendMemory mem = new AppendMemory();){
                        mem.of(FilesFacadeImpl.INSTANCE, (LPSZ)path, FilesFacadeImpl.INSTANCE.getPageSize());
                        mem.putInt(columnCount);
                        mem.skip(len - 4L);
                    }
                    try {
                        metadata.createTransitionIndex();
                    }
                    catch (CairoException e) {
                        TestUtils.assertContains(e.getMessage(), "Incorrect columnCount");
                    }
                }
            }
        });
    }
}

