/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.DefaultCairoConfiguration;
import com.questdb.cairo.ReadWriteMemory;
import com.questdb.cairo.TableModel;
import com.questdb.cairo.TableReader;
import com.questdb.cairo.TableReaderRecordCursor;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.sql.Record;
import com.questdb.std.Chars;
import com.questdb.std.FilesFacade;
import com.questdb.std.FilesFacadeImpl;
import com.questdb.std.Rnd;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.Path;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class TableReadFailTest
extends AbstractCairoTest {
    @Test
    public void testMetaFileCannotOpenConstructor() throws Exception {
        FilesFacadeImpl ff = new FilesFacadeImpl(){

            public long openRO(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"_meta")) {
                    return -1L;
                }
                return super.openRO(name);
            }
        };
        this.assertConstructorFail((FilesFacade)ff);
    }

    @Test
    public void testMetaFileMissingConstructor() throws Exception {
        FilesFacadeImpl ff = new FilesFacadeImpl(){

            public boolean exists(LPSZ path) {
                return !Chars.endsWith((CharSequence)path, (CharSequence)"_meta") && super.exists(path);
            }
        };
        this.assertConstructorFail((FilesFacade)ff);
    }

    @Test
    public void testReloadTimeout() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "x", 3).col("a", 3).col("b", 4).timestamp();){
                CairoTestUtils.create(model);
            }
            var1_1 = null;
            try (Path path = new Path();
                 TableReader reader = new TableReader(configuration, (CharSequence)"x");
                 ReadWriteMemory mem = new ReadWriteMemory();){
                Rnd rnd = new Rnd();
                int N = 1000;
                path.of(configuration.getRoot()).concat((CharSequence)"x").concat((CharSequence)"_txn").$();
                try (TableWriter w = new TableWriter(configuration, (CharSequence)"x");){
                    for (int i = 0; i < 1000; ++i) {
                        TableWriter.Row r = w.newRow(0L);
                        r.putInt(0, rnd.nextInt());
                        r.putLong(1, rnd.nextLong());
                        r.append();
                    }
                    w.commit();
                }
                Assert.assertTrue((boolean)reader.reload());
                TableReaderRecordCursor cursor = reader.getCursor();
                Record record = cursor.getRecord();
                rnd.reset();
                int count = 0;
                while (cursor.hasNext()) {
                    Assert.assertEquals((long)rnd.nextInt(), (long)record.getInt(0));
                    Assert.assertEquals((long)rnd.nextLong(), (long)record.getLong(1));
                    ++count;
                }
                Assert.assertEquals((long)1000L, (long)count);
                mem.of(configuration.getFilesFacade(), (LPSZ)path, configuration.getFilesFacade().getPageSize());
                long offset = configuration.getFilesFacade().length(mem.getFd());
                long txn = mem.getLong(0L);
                mem.jumpTo(0L);
                mem.putLong(123L);
                mem.jumpTo(offset);
                mem.close();
                try {
                    reader.reload();
                    Assert.fail();
                }
                catch (CairoException e) {
                    TestUtils.assertContains(e.getMessage(), "timeout");
                }
                mem.of(configuration.getFilesFacade(), (LPSZ)path, configuration.getFilesFacade().getPageSize());
                mem.jumpTo(0L);
                mem.putLong(txn);
                mem.jumpTo(offset);
                mem.close();
                mem.close();
                Assert.assertFalse((boolean)reader.reload());
                try (TableWriter w = new TableWriter(configuration, (CharSequence)"x");){
                    for (int i = 0; i < 1000; ++i) {
                        TableWriter.Row r = w.newRow(0L);
                        r.putInt(0, rnd.nextInt());
                        r.putLong(1, rnd.nextLong());
                        r.append();
                    }
                    w.commit();
                }
                Assert.assertTrue((boolean)reader.reload());
                cursor = reader.getCursor();
                rnd.reset();
                count = 0;
                while (cursor.hasNext()) {
                    Assert.assertEquals((long)rnd.nextInt(), (long)record.getInt(0));
                    Assert.assertEquals((long)rnd.nextLong(), (long)record.getLong(1));
                    ++count;
                }
                Assert.assertEquals((long)2000L, (long)count);
            }
            catch (Throwable throwable) {
                var1_1 = throwable;
                throw throwable;
            }
        });
    }

    @Test
    public void testTodoPresentConstructor() throws Exception {
        FilesFacadeImpl ff = new FilesFacadeImpl(){

            public boolean exists(LPSZ path) {
                return Chars.endsWith((CharSequence)path, (CharSequence)"_todo") || super.exists(path);
            }
        };
        this.assertConstructorFail((FilesFacade)ff);
    }

    @Test
    public void testTxnFileCannotOpenConstructor() throws Exception {
        FilesFacadeImpl ff = new FilesFacadeImpl(){

            public long openRO(LPSZ name) {
                if (Chars.endsWith((CharSequence)name, (CharSequence)"_txn")) {
                    return -1L;
                }
                return super.openRO(name);
            }
        };
        this.assertConstructorFail((FilesFacade)ff);
    }

    @Test
    public void testTxnFileMissingConstructor() throws Exception {
        FilesFacadeImpl ff = new FilesFacadeImpl(){

            public boolean exists(LPSZ path) {
                return !Chars.endsWith((CharSequence)path, (CharSequence)"_txn") && super.exists(path);
            }
        };
        this.assertConstructorFail((FilesFacade)ff);
    }

    private void assertConstructorFail(final FilesFacade ff) throws Exception {
        CairoTestUtils.createAllTable(configuration, 0);
        TestUtils.assertMemoryLeak(() -> {
            try {
                new TableReader((CairoConfiguration)new DefaultCairoConfiguration(root){

                    public FilesFacade getFilesFacade() {
                        return ff;
                    }
                }, (CharSequence)"all");
                Assert.fail();
            }
            catch (CairoException cairoException) {
                // empty catch block
            }
        });
    }
}

