/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.AppendMemory;
import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.TableStructure;
import com.questdb.std.Chars;
import com.questdb.std.LongList;
import com.questdb.std.Misc;
import com.questdb.std.Numbers;
import com.questdb.std.ObjList;
import com.questdb.std.str.Path;
import java.io.Closeable;

public class TableModel
implements TableStructure,
Closeable {
    private static final long COLUMN_FLAG_CACHED = 1L;
    private static final long COLUMN_FLAG_INDEXED = 2L;
    private final String name;
    private final int partitionBy;
    private final AppendMemory mem = new AppendMemory();
    private final ObjList<CharSequence> columnNames = new ObjList();
    private final LongList columnBits = new LongList();
    private final Path path = new Path();
    private final CairoConfiguration cairoCfg;
    private int timestampIndex = -1;

    public TableModel(CairoConfiguration cairoCfg, String name, int partitionBy) {
        this.cairoCfg = cairoCfg;
        this.name = name;
        this.partitionBy = partitionBy;
    }

    public TableModel cached(boolean cached) {
        int last = this.columnBits.size() - 1;
        assert (last > 0);
        assert ((int)this.columnBits.getQuick(last - 1) == 8);
        long bits = this.columnBits.getQuick(last);
        if (cached) {
            this.columnBits.setQuick(last, bits | 1L);
        } else {
            this.columnBits.setQuick(last, bits & 0xFFFFFFFFFFFFFFFEL);
        }
        return this;
    }

    @Override
    public void close() {
        Misc.free((Object)this.mem);
        Misc.free((Object)this.path);
    }

    public TableModel col(CharSequence name, int type) {
        this.columnNames.add((Object)Chars.stringOf((CharSequence)name));
        this.columnBits.add(0x8000000000L | (long)type);
        this.columnBits.add(1L);
        return this;
    }

    public boolean getSymbolCacheFlag(int index) {
        return (this.columnBits.getQuick(index * 2 + 1) & 1L) == 1L;
    }

    public CairoConfiguration getCairoCfg() {
        return this.cairoCfg;
    }

    public int getColumnCount() {
        return this.columnNames.size();
    }

    public CharSequence getColumnName(int index) {
        return (CharSequence)this.columnNames.getQuick(index);
    }

    public int getColumnType(int index) {
        return (int)this.columnBits.getQuick(index * 2);
    }

    public int getIndexBlockCapacity(int index) {
        return (int)(this.columnBits.getQuick(index * 2 + 1) >> 32);
    }

    public boolean getIndexedFlag(int index) {
        return (this.columnBits.getQuick(index * 2 + 1) & 2L) == 2L;
    }

    public AppendMemory getMem() {
        return this.mem;
    }

    public String getName() {
        return this.name;
    }

    public int getPartitionBy() {
        return this.partitionBy;
    }

    public Path getPath() {
        return this.path;
    }

    public CharSequence getTableName() {
        return this.name;
    }

    public int getSymbolCapacity(int index) {
        return (int)(this.columnBits.getQuick(index * 2) >> 32);
    }

    public int getTimestampIndex() {
        return this.timestampIndex;
    }

    public TableModel indexed(boolean indexFlag, int indexBlockCapacity) {
        int pos = this.columnBits.size() - 1;
        assert (pos > 0);
        long bits = this.columnBits.getQuick(pos);
        if (indexFlag) {
            assert (indexBlockCapacity > 1);
            this.columnBits.setQuick(pos, bits | (long)Numbers.ceilPow2((int)indexBlockCapacity) << 32 | 2L);
        } else {
            this.columnBits.setQuick(pos, bits & 0xFFFFFFFFFFFFFFFDL);
        }
        return this;
    }

    public TableModel symbolCapacity(int capacity) {
        int pos = this.columnBits.size() - 2;
        assert (pos > -1);
        long bits = this.columnBits.getQuick(pos);
        assert ((int)bits == 8);
        bits = (long)capacity << 32 | (long)((int)bits);
        this.columnBits.setQuick(pos, bits);
        return this;
    }

    public TableModel timestamp() {
        assert (this.timestampIndex == -1);
        this.timestampIndex = this.columnNames.size();
        this.col("timestamp", 12);
        return this;
    }
}

