/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.BitmapIndexTest;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.ReadWriteMemory;
import com.questdb.cairo.SymbolMapReaderImpl;
import com.questdb.cairo.SymbolMapWriter;
import com.questdb.std.Chars;
import com.questdb.std.ObjList;
import com.questdb.std.Rnd;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.Path;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class SymbolMapTest
extends AbstractCairoTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(Path path, CharSequence name, int symbolCapacity, boolean useCache) {
        int plen = path.length();
        try {
            try (ReadWriteMemory mem = new ReadWriteMemory(configuration.getFilesFacade(), (LPSZ)path.concat(name).put((CharSequence)".o").$(), configuration.getFilesFacade().getMapPageSize());){
                mem.putInt(symbolCapacity);
                mem.putBool(useCache);
                mem.jumpTo(64L);
            }
            configuration.getFilesFacade().touch((LPSZ)path.trimTo(plen).concat(name).put((CharSequence)".c").$());
            BitmapIndexTest.create(configuration, path.trimTo(plen), name, 4);
        }
        finally {
            path.trimTo(plen);
        }
    }

    @Test
    public void testAppend() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 1000;
            try (Path path = new Path().of(configuration.getRoot());){
                long key;
                CharSequence cs;
                int i;
                long prev;
                SymbolMapTest.create(path, "x", N, true);
                Rnd rnd = new Rnd();
                try (SymbolMapWriter writer = new SymbolMapWriter(configuration, path, (CharSequence)"x", 0);){
                    prev = -1L;
                    for (i = 0; i < N; ++i) {
                        cs = rnd.nextChars(10);
                        key = writer.put(cs);
                        Assert.assertEquals((long)(prev + 1L), (long)key);
                        Assert.assertEquals((long)key, (long)writer.put(cs));
                        prev = key;
                    }
                }
                writer = new SymbolMapWriter(configuration, path, (CharSequence)"x", N);
                var5_7 = null;
                try {
                    prev = N - 1;
                    for (i = 0; i < N; ++i) {
                        cs = rnd.nextChars(10);
                        key = writer.put(cs);
                        Assert.assertEquals((long)(prev + 1L), (long)key);
                        Assert.assertEquals((long)key, (long)writer.put(cs));
                        prev = key;
                    }
                    rnd.reset();
                    prev = -1L;
                    for (i = 0; i < N; ++i) {
                        cs = rnd.nextChars(10);
                        key = writer.put(cs);
                        Assert.assertEquals((long)(prev + 1L), (long)key);
                        prev = key;
                    }
                    Assert.assertEquals((long)Integer.MIN_VALUE, (long)writer.put(null));
                }
                catch (Throwable throwable) {
                    var5_7 = throwable;
                    throw throwable;
                }
                finally {
                    if (writer != null) {
                        if (var5_7 != null) {
                            try {
                                writer.close();
                            }
                            catch (Throwable throwable) {
                                var5_7.addSuppressed(throwable);
                            }
                        } else {
                            writer.close();
                        }
                    }
                }
            }
        });
    }

    @Test
    public void testLookupPerformance() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 10000000;
            int symbolCount = 1024;
            ObjList symbols = new ObjList();
            try (Path path = new Path().of(configuration.getRoot());){
                SymbolMapTest.create(path, "x", symbolCount, true);
                try (SymbolMapWriter writer = new SymbolMapWriter(configuration, path, (CharSequence)"x", 0);){
                    Rnd rnd = new Rnd();
                    long prev = -1L;
                    for (int i = 0; i < symbolCount; ++i) {
                        CharSequence cs = rnd.nextChars(10);
                        long key = writer.put(cs);
                        symbols.add((Object)cs.toString());
                        Assert.assertEquals((long)(prev + 1L), (long)key);
                        prev = key;
                    }
                    long t = System.nanoTime();
                    for (int i = 0; i < N; ++i) {
                        int key = rnd.nextPositiveInt() % symbolCount;
                        Assert.assertEquals((long)key, (long)writer.put((CharSequence)symbols.getQuick(key)));
                    }
                    System.out.println("SymbolMapWriter lookup performance [10M <500ms]: " + (System.nanoTime() - t) / 1000000L);
                }
            }
        });
    }

    @Test
    public void testMapDoesNotExist() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (Path path = new Path().of(configuration.getRoot());){
                try {
                    new SymbolMapWriter(configuration, path, (CharSequence)"x", 0);
                    Assert.fail();
                }
                catch (CairoException e) {
                    Assert.assertTrue((boolean)Chars.contains((CharSequence)e.getMessage(), (CharSequence)"does not exist"));
                }
            }
        });
    }

    @Test
    public void testReadEmptySymbolMap() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 10000;
            try (Path path = new Path().of(configuration.getRoot());){
                SymbolMapTest.create(path, "x", N, true);
                try (SymbolMapReaderImpl reader = new SymbolMapReaderImpl(configuration, path, (CharSequence)"x", 0);){
                    Assert.assertEquals((long)N, (long)reader.getSymbolCapacity());
                    Assert.assertNull((Object)reader.value(-1));
                    Assert.assertEquals((long)Integer.MIN_VALUE, (long)reader.getQuick(null));
                }
            }
        });
    }

    @Test
    public void testReaderWhenMapDoesNotExist() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (Path path = new Path().of(configuration.getRoot());){
                try {
                    new SymbolMapReaderImpl(configuration, path, (CharSequence)"x", 0);
                    Assert.fail();
                }
                catch (CairoException e) {
                    Assert.assertTrue((boolean)Chars.contains((CharSequence)e.getMessage(), (CharSequence)"does not exist"));
                }
            }
        });
    }

    @Test
    public void testReaderWithShortHeader() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (Path path = new Path().of(configuration.getRoot());){
                int plen = path.length();
                Assert.assertTrue((boolean)configuration.getFilesFacade().touch((LPSZ)path.concat((CharSequence)"x").put((CharSequence)".o").$()));
                try {
                    new SymbolMapReaderImpl(configuration, path.trimTo(plen), (CharSequence)"x", 0);
                    Assert.fail();
                }
                catch (CairoException e) {
                    Assert.assertTrue((boolean)Chars.contains((CharSequence)e.getMessage(), (CharSequence)"too short"));
                }
            }
        });
    }

    @Test
    public void testRollback() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 1024;
            try (Path path = new Path().of(configuration.getRoot());){
                SymbolMapTest.create(path, "x", N, true);
                try (SymbolMapWriter writer = new SymbolMapWriter(configuration, path, (CharSequence)"x", 0);){
                    long key;
                    CharSequence cs;
                    int i;
                    Rnd rnd = new Rnd();
                    long prev = -1L;
                    for (i = 0; i < N; ++i) {
                        cs = rnd.nextChars(10);
                        key = writer.put(cs);
                        Assert.assertEquals((long)(prev + 1L), (long)key);
                        Assert.assertEquals((long)key, (long)writer.put(cs));
                        prev = key;
                    }
                    writer.rollback(N / 2);
                    prev = N / 2 - 1;
                    for (i = 0; i < N; ++i) {
                        cs = rnd.nextChars(10);
                        key = writer.put(cs);
                        Assert.assertEquals((long)(prev + 1L), (long)key);
                        Assert.assertEquals((long)key, (long)writer.put(cs));
                        prev = key;
                    }
                }
            }
        });
    }

    @Test
    public void testShortHeader() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (Path path = new Path().of(configuration.getRoot());){
                int plen = path.length();
                Assert.assertTrue((boolean)configuration.getFilesFacade().touch((LPSZ)path.concat((CharSequence)"x").put((CharSequence)".o").$()));
                try {
                    new SymbolMapWriter(configuration, path.trimTo(plen), (CharSequence)"x", 0);
                    Assert.fail();
                }
                catch (CairoException e) {
                    Assert.assertTrue((boolean)Chars.contains((CharSequence)e.getMessage(), (CharSequence)"too short"));
                }
            }
        });
    }

    @Test
    public void testSimpleAdd() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 1000000;
            try (Path path = new Path().of(configuration.getRoot());){
                SymbolMapTest.create(path, "x", N, false);
                try (SymbolMapWriter writer = new SymbolMapWriter(configuration, path, (CharSequence)"x", 0);){
                    Rnd rnd = new Rnd();
                    long prev = -1L;
                    for (int i = 0; i < N; ++i) {
                        CharSequence cs = rnd.nextChars(10);
                        long key = writer.put(cs);
                        Assert.assertEquals((long)(prev + 1L), (long)key);
                        Assert.assertEquals((long)key, (long)writer.put(cs));
                        prev = key;
                    }
                }
            }
        });
    }

    @Test
    public void testSimpleRead() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 1000000;
            Rnd rnd = new Rnd();
            try (Path path = new Path().of(configuration.getRoot());){
                SymbolMapTest.create(path, "x", N, false);
                try (SymbolMapWriter writer = new SymbolMapWriter(configuration, path, (CharSequence)"x", 0);){
                    long prev = -1L;
                    for (int i = 0; i < N; ++i) {
                        CharSequence cs = rnd.nextChars(10);
                        long key = writer.put(cs);
                        Assert.assertEquals((long)(prev + 1L), (long)key);
                        prev = key;
                    }
                }
                rnd.reset();
                var5_7 = null;
                try (SymbolMapReaderImpl reader = new SymbolMapReaderImpl(configuration, path, (CharSequence)"x", N);){
                    for (int i = 0; i < N; ++i) {
                        CharSequence cs = rnd.nextChars(10);
                        TestUtils.assertEquals(cs, reader.value(i));
                        Assert.assertEquals((long)i, (long)reader.getQuick(cs));
                    }
                    Assert.assertEquals((long)N, (long)reader.size());
                    Assert.assertNull((Object)reader.value(-1));
                    Assert.assertNull((Object)reader.value(N));
                    Assert.assertEquals((long)-2L, (long)reader.getQuick((CharSequence)"hola"));
                }
                catch (Throwable throwable) {
                    var5_7 = throwable;
                    throw throwable;
                }
            }
        });
    }

    @Test
    public void testTransactionalRead() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 1000000;
            Rnd rnd = new Rnd();
            try (Path path = new Path().of(configuration.getRoot());){
                SymbolMapTest.create(path, "x", N, false);
                try (SymbolMapWriter writer = new SymbolMapWriter(configuration, path, (CharSequence)"x", 0);){
                    long prev = -1L;
                    for (int i = 0; i < N; ++i) {
                        CharSequence cs = rnd.nextChars(10);
                        long key = writer.put(cs);
                        Assert.assertEquals((long)(prev + 1L), (long)key);
                        prev = key;
                    }
                    rnd.reset();
                    try (SymbolMapReaderImpl reader = new SymbolMapReaderImpl(configuration, path, (CharSequence)"x", N);){
                        for (int i = 0; i < N; ++i) {
                            CharSequence cs = rnd.nextChars(10);
                            TestUtils.assertEquals(cs, reader.value(i));
                            Assert.assertEquals((long)i, (long)reader.getQuick(cs));
                        }
                        Assert.assertNull((Object)reader.value(N));
                        Assert.assertEquals((long)-2L, (long)reader.getQuick((CharSequence)"hola"));
                        Assert.assertEquals((long)N, (long)writer.put((CharSequence)"XYZ"));
                        Assert.assertNull((Object)reader.value(N));
                        Assert.assertEquals((long)-2L, (long)reader.getQuick((CharSequence)"XYZ"));
                        reader.updateSymbolCount(N + 1);
                        TestUtils.assertEquals((CharSequence)"XYZ", reader.value(N));
                        Assert.assertEquals((long)N, (long)reader.getQuick((CharSequence)"XYZ"));
                    }
                }
            }
        });
    }
}

