/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.sql.Record;
import com.questdb.cairo.sql.RecordCursor;
import com.questdb.cairo.sql.RecordMetadata;
import com.questdb.std.BinarySequence;
import com.questdb.std.Chars;
import com.questdb.std.Numbers;
import com.questdb.std.str.CharSink;
import com.questdb.std.time.DateFormatUtils;
import java.io.IOException;

public class RecordCursorPrinter {
    private final CharSink sink;
    private final char delimiter;

    public RecordCursorPrinter(CharSink sink) {
        this.sink = sink;
        this.delimiter = (char)9;
    }

    public void print(RecordCursor cursor, RecordMetadata metadata, boolean header) throws IOException {
        if (header) {
            this.printHeader(metadata);
        }
        Record record = cursor.getRecord();
        while (cursor.hasNext()) {
            this.print(record, metadata);
        }
    }

    public void print(Record r, RecordMetadata m) throws IOException {
        int sz = m.getColumnCount();
        for (int i = 0; i < sz; ++i) {
            if (i > 0) {
                this.sink.put(this.delimiter);
            }
            this.printColumn(r, m, i);
        }
        this.sink.put((CharSequence)"\n");
        this.sink.flush();
    }

    public void printHeader(RecordMetadata metadata) {
        int n = metadata.getColumnCount();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                this.sink.put(this.delimiter);
            }
            this.sink.put(metadata.getColumnName(i));
        }
        this.sink.put('\n');
    }

    private void printColumn(Record r, RecordMetadata m, int i) {
        switch (m.getColumnType(i)) {
            case 10: {
                DateFormatUtils.appendDateTime((CharSink)this.sink, (long)r.getDate(i));
                break;
            }
            case 12: {
                com.questdb.std.microtime.DateFormatUtils.appendDateTimeUSec((CharSink)this.sink, (long)r.getTimestamp(i));
                break;
            }
            case 6: {
                Numbers.append((CharSink)this.sink, (double)r.getDouble(i), (int)12);
                break;
            }
            case 5: {
                Numbers.append((CharSink)this.sink, (float)r.getFloat(i), (int)4);
                break;
            }
            case 3: {
                Numbers.append((CharSink)this.sink, (int)r.getInt(i));
                break;
            }
            case 7: {
                r.getStr(i, this.sink);
                break;
            }
            case 8: {
                this.sink.put(r.getSym(i));
                break;
            }
            case 2: {
                Numbers.append((CharSink)this.sink, (int)r.getShort(i));
                break;
            }
            case 4: {
                Numbers.append((CharSink)this.sink, (long)r.getLong(i));
                break;
            }
            case 1: {
                Numbers.append((CharSink)this.sink, (int)r.getByte(i));
                break;
            }
            case 0: {
                this.sink.put((CharSequence)(r.getBool(i) ? "true" : "false"));
                break;
            }
            case 9: {
                Chars.toSink((BinarySequence)r.getBin(i), (CharSink)this.sink);
                break;
            }
        }
    }
}

