/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.ColumnFilter;
import com.questdb.cairo.ColumnType;
import com.questdb.cairo.ColumnTypes;
import com.questdb.cairo.EntityColumnFilter;
import com.questdb.cairo.RecordChain;
import com.questdb.cairo.RecordSink;
import com.questdb.cairo.RecordSinkFactory;
import com.questdb.cairo.TableReader;
import com.questdb.cairo.TableReaderRecordCursor;
import com.questdb.cairo.TestRecord;
import com.questdb.cairo.sql.Record;
import com.questdb.cairo.sql.RecordCursor;
import com.questdb.cairo.sql.RecordMetadata;
import com.questdb.std.BytecodeAssembler;
import com.questdb.std.LongList;
import com.questdb.std.Rnd;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class RecordChainTest
extends AbstractCairoTest {
    public static final long SIZE_4M = 0x400000L;
    private static final BytecodeAssembler asm = new BytecodeAssembler();
    private static final EntityColumnFilter entityColumnFilter = new EntityColumnFilter();

    @Test
    public void testClear() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            CairoTestUtils.createTestTable(10000, new Rnd(), new TestRecord.ArrayBinarySequence());
            try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                entityColumnFilter.of(reader.getColumnCount());
                RecordSink recordSink = RecordSinkFactory.getInstance((BytecodeAssembler)asm, (ColumnTypes)reader.getMetadata(), (ColumnFilter)entityColumnFilter, (boolean)false);
                try (RecordChain chain = new RecordChain((ColumnTypes)reader.getMetadata(), recordSink, 0x400000L);){
                    Assert.assertFalse((boolean)chain.hasNext());
                    RecordChainTest.populateChain(chain, reader);
                    chain.toTop();
                    Assert.assertTrue((boolean)chain.hasNext());
                    chain.clear();
                    chain.toTop();
                    Assert.assertFalse((boolean)chain.hasNext());
                }
            }
        });
    }

    @Test
    public void testPseudoRandomAccess() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 10000;
            CairoTestUtils.createTestTable(N, new Rnd(), new TestRecord.ArrayBinarySequence());
            try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                entityColumnFilter.of(reader.getMetadata().getColumnCount());
                RecordSink recordSink = RecordSinkFactory.getInstance((BytecodeAssembler)asm, (ColumnTypes)reader.getMetadata(), (ColumnFilter)entityColumnFilter, (boolean)false);
                try (RecordChain chain = new RecordChain((ColumnTypes)reader.getMetadata(), recordSink, 0x400000L);){
                    LongList rows = new LongList();
                    Record chainRecord = chain.getRecord();
                    TableReaderRecordCursor cursor = reader.getCursor();
                    Record cursorRecord = cursor.getRecord();
                    chain.setSymbolTableResolver((RecordCursor)cursor);
                    long o = -1L;
                    while (cursor.hasNext()) {
                        o = chain.put(cursorRecord, o);
                        rows.add(o);
                    }
                    Assert.assertEquals((long)N, (long)rows.size());
                    cursor.toTop();
                    int n = rows.size();
                    for (int i = 0; i < n; ++i) {
                        long row = rows.getQuick(i);
                        Assert.assertTrue((boolean)cursor.hasNext());
                        chain.recordAt(row);
                        Assert.assertEquals((long)row, (long)chainRecord.getRowId());
                        this.assertSame(cursorRecord, chainRecord, reader.getMetadata());
                    }
                    Record rec2 = chain.newRecord();
                    cursor.toTop();
                    int n2 = rows.size();
                    for (int i = 0; i < n2; ++i) {
                        long row = rows.getQuick(i);
                        Assert.assertTrue((boolean)cursor.hasNext());
                        chain.recordAt(rec2, row);
                        Assert.assertEquals((long)row, (long)rec2.getRowId());
                        this.assertSame(cursorRecord, rec2, reader.getMetadata());
                    }
                }
            }
        });
    }

    @Test
    public void testReuseWithClear() throws Exception {
        this.testChainReuseWithClearFunction(RecordChain::clear);
    }

    @Test
    public void testReuseWithClose() throws Exception {
        this.testChainReuseWithClearFunction(RecordChain::close);
    }

    @Test
    public void testReuseWithReleaseCursor() throws Exception {
        this.testChainReuseWithClearFunction(RecordChain::close);
    }

    @Test
    public void testWriteAndRead() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 20000;
            CairoTestUtils.createTestTable(20000, new Rnd(), new TestRecord.ArrayBinarySequence());
            try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                entityColumnFilter.of(reader.getMetadata().getColumnCount());
                RecordSink recordSink = RecordSinkFactory.getInstance((BytecodeAssembler)asm, (ColumnTypes)reader.getMetadata(), (ColumnFilter)entityColumnFilter, (boolean)false);
                try (RecordChain chain = new RecordChain((ColumnTypes)reader.getMetadata(), recordSink, 0x400000L);){
                    RecordChainTest.populateChain(chain, reader);
                    this.assertChain(chain, 20000L, reader);
                    this.assertChain(chain, 20000L, reader);
                }
            }
        });
    }

    private static void populateChain(RecordChain chain, TableReader reader) {
        TableReaderRecordCursor cursor = reader.getCursor();
        Record record = cursor.getRecord();
        chain.setSymbolTableResolver((RecordCursor)cursor);
        long o = -1L;
        while (cursor.hasNext()) {
            o = chain.put(record, o);
        }
    }

    private void assertChain(RecordChain chain, long expectedCount, TableReader reader) {
        long count = 0L;
        chain.toTop();
        Record chainRecord = chain.getRecord();
        TableReaderRecordCursor cursor = reader.getCursor();
        Record readerRecord = cursor.getRecord();
        chain.setSymbolTableResolver((RecordCursor)cursor);
        while (chain.hasNext()) {
            Assert.assertTrue((boolean)cursor.hasNext());
            this.assertSame(readerRecord, chainRecord, reader.getMetadata());
            ++count;
        }
        Assert.assertEquals((long)expectedCount, (long)count);
    }

    private void assertSame(Record expected, Record actual, RecordMetadata metadata) {
        block14: for (int i = 0; i < metadata.getColumnCount(); ++i) {
            switch (metadata.getColumnType(i)) {
                case 3: {
                    Assert.assertEquals((long)expected.getInt(i), (long)actual.getInt(i));
                    continue block14;
                }
                case 6: {
                    Assert.assertEquals((double)expected.getDouble(i), (double)actual.getDouble(i), (double)1.0E-9);
                    continue block14;
                }
                case 4: {
                    Assert.assertEquals((long)expected.getLong(i), (long)actual.getLong(i));
                    continue block14;
                }
                case 10: {
                    Assert.assertEquals((long)expected.getDate(i), (long)actual.getDate(i));
                    continue block14;
                }
                case 12: {
                    Assert.assertEquals((long)expected.getTimestamp(i), (long)actual.getTimestamp(i));
                    continue block14;
                }
                case 0: {
                    Assert.assertEquals((Object)expected.getBool(i), (Object)actual.getBool(i));
                    continue block14;
                }
                case 1: {
                    Assert.assertEquals((long)expected.getByte(i), (long)actual.getByte(i));
                    continue block14;
                }
                case 2: {
                    Assert.assertEquals((long)expected.getShort(i), (long)actual.getShort(i));
                    continue block14;
                }
                case 8: {
                    TestUtils.assertEquals(expected.getSym(i), actual.getSym(i));
                    continue block14;
                }
                case 5: {
                    Assert.assertEquals((float)expected.getFloat(i), (float)actual.getFloat(i), (float)1.0E-8f);
                    continue block14;
                }
                case 7: {
                    CharSequence e = expected.getStr(i);
                    CharSequence cs1 = actual.getStr(i);
                    CharSequence cs2 = actual.getStrB(i);
                    TestUtils.assertEquals(e, cs1);
                    Assert.assertFalse((cs1 != null && cs1 == cs2 ? 1 : 0) != 0);
                    TestUtils.assertEquals(e, cs2);
                    if (cs1 == null) {
                        Assert.assertEquals((long)-1L, (long)actual.getStrLen(i));
                        continue block14;
                    }
                    Assert.assertEquals((long)cs1.length(), (long)actual.getStrLen(i));
                    continue block14;
                }
                case 9: {
                    TestUtils.assertEquals(expected.getBin(i), actual.getBin(i), actual.getBinLen(i));
                    continue block14;
                }
                default: {
                    throw CairoException.instance((int)0).put((CharSequence)"Record chain does not support: ").put((CharSequence)ColumnType.nameOf((int)metadata.getColumnType(i)));
                }
            }
        }
    }

    private void testChainReuseWithClearFunction(ClearFunc clear) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 10000;
            Rnd rnd = new Rnd();
            CairoTestUtils.createTestTable(10000, rnd, new TestRecord.ArrayBinarySequence());
            try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                entityColumnFilter.of(reader.getMetadata().getColumnCount());
                RecordSink recordSink = RecordSinkFactory.getInstance((BytecodeAssembler)asm, (ColumnTypes)reader.getMetadata(), (ColumnFilter)entityColumnFilter, (boolean)false);
                try (RecordChain chain = new RecordChain((ColumnTypes)reader.getMetadata(), recordSink, 0x400000L);){
                    RecordChainTest.populateChain(chain, reader);
                    this.assertChain(chain, 10000L, reader);
                    clear.clear(chain);
                    RecordChainTest.populateChain(chain, reader);
                    this.assertChain(chain, 10000L, reader);
                }
            }
        });
    }

    @FunctionalInterface
    private static interface ClearFunc {
        public void clear(RecordChain var1);
    }
}

