/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.BitmapIndexReader;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.Engine;
import com.questdb.cairo.IntervalBwdDataFrameCursor;
import com.questdb.cairo.IntervalBwdDataFrameCursorFactory;
import com.questdb.cairo.ReaderOutOfDateException;
import com.questdb.cairo.TableModel;
import com.questdb.cairo.TableReader;
import com.questdb.cairo.TableReaderRecord;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.sql.CairoEngine;
import com.questdb.cairo.sql.DataFrame;
import com.questdb.cairo.sql.DataFrameCursor;
import com.questdb.cairo.sql.RowCursor;
import com.questdb.cairo.sql.SymbolTable;
import com.questdb.std.LongList;
import com.questdb.std.Rnd;
import com.questdb.std.microtime.DateFormatUtils;
import com.questdb.std.microtime.Dates;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class IntervalBwdDataFrameCursorTest
extends AbstractCairoTest {
    private static final LongList intervals = new LongList();

    @Test
    public void testAllIntervalsAfterTableByDay() throws Exception {
        long increment = 7200000000L;
        int N = 36;
        intervals.clear();
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-01T00:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-06T00:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-06T00:00:01.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-06T14:00:01.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-08T00:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-09T00:00:00.000Z"));
        this.testIntervals(0, increment, N, "", 0L);
    }

    @Test
    public void testAllIntervalsAfterTableByNone() throws Exception {
        long increment = 7200000000L;
        int N = 36;
        intervals.clear();
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-01T00:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-06T00:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-06T00:00:01.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-06T14:00:01.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-08T00:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-09T00:00:00.000Z"));
        this.testIntervals(3, increment, N, "", 0L);
    }

    @Test
    public void testAllIntervalsBeforeTableByDay() throws Exception {
        long increment = 7200000000L;
        int N = 36;
        intervals.clear();
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-01T00:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-06T00:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-06T00:00:01.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-06T14:00:01.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-08T00:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-09T00:00:00.000Z"));
        this.testIntervals(0, increment, N, "", 0L);
    }

    @Test
    public void testAllIntervalsBeforeTableByNone() throws Exception {
        long increment = 7200000000L;
        int N = 36;
        intervals.clear();
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-01T00:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-06T00:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-06T00:00:01.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-06T14:00:01.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-08T00:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1979-01-09T00:00:00.000Z"));
        this.testIntervals(3, increment, N, "", 0L);
    }

    @Test
    public void testByNone() throws Exception {
        long increment = 7200000000L;
        int N = 36;
        intervals.clear();
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T18:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T20:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T22:30:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T22:35:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1983-01-05T12:30:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1983-01-05T14:35:00.000Z"));
        String expected = "1983-01-05T14:00:00.000000Z\n1980-01-02T20:00:00.000000Z\n1980-01-02T18:00:00.000000Z\n";
        this.testIntervals(3, increment, N, "1983-01-05T14:00:00.000000Z\n1980-01-02T20:00:00.000000Z\n1980-01-02T18:00:00.000000Z\n", 3L);
    }

    @Test
    public void testClose() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "x", 3).col("a", 3).col("b", 3).timestamp();){
                CairoTestUtils.create(model);
            }
            TableReader reader = new TableReader(configuration, (CharSequence)"x");
            IntervalBwdDataFrameCursor cursor = new IntervalBwdDataFrameCursor(intervals);
            cursor.of(reader);
            cursor.close();
            Assert.assertFalse((boolean)reader.isOpen());
            cursor.close();
            Assert.assertFalse((boolean)reader.isOpen());
        });
    }

    @Test
    public void testExactMatch() throws Exception {
        long increment = 7200000000L;
        int N = 36;
        intervals.clear();
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T22:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T22:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T22:30:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T22:35:00.000Z"));
        String expected = "1980-01-02T22:00:00.000000Z\n";
        this.testIntervals(0, increment, N, "1980-01-02T22:00:00.000000Z\n", 1L);
    }

    @Test
    public void testFallsBelow() throws Exception {
        long increment = 7200000000L;
        int N = 36;
        intervals.clear();
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T18:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T20:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T22:30:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T22:35:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1983-01-05T12:30:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1983-01-05T14:35:00.000Z"));
        String expected = "1983-01-05T14:00:00.000000Z\n1980-01-02T20:00:00.000000Z\n1980-01-02T18:00:00.000000Z\n";
        this.testIntervals(0, increment, N, "1983-01-05T14:00:00.000000Z\n1980-01-02T20:00:00.000000Z\n1980-01-02T18:00:00.000000Z\n", 3L);
    }

    @Test
    public void testIntervalCursorNoTimestamp() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "x", 0).col("a", 8).indexed(true, 4).col("b", 8).indexed(true, 4);){
                CairoTestUtils.create(model);
            }
            var1_1 = null;
            try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                IntervalBwdDataFrameCursor cursor = new IntervalBwdDataFrameCursor(new LongList());
                try {
                    cursor.of(reader);
                    Assert.fail();
                }
                catch (CairoException e) {
                    TestUtils.assertContains(e.getMessage(), "table 'x' has no timestamp");
                }
            }
            catch (Throwable throwable) {
                var1_1 = throwable;
                throw throwable;
            }
        });
    }

    @Test
    public void testNegativeReloadByDay() throws Exception {
        long increment = 7200000000L;
        int N = 36;
        intervals.clear();
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T01:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T16:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T21:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T22:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-03T11:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-03T14:00:00.000Z"));
        String expected = "1980-01-03T14:00:00.000000Z\n1980-01-03T12:00:00.000000Z\n1980-01-02T22:00:00.000000Z\n1980-01-02T16:00:00.000000Z\n1980-01-02T14:00:00.000000Z\n1980-01-02T12:00:00.000000Z\n1980-01-02T10:00:00.000000Z\n1980-01-02T08:00:00.000000Z\n1980-01-02T06:00:00.000000Z\n1980-01-02T04:00:00.000000Z\n1980-01-02T02:00:00.000000Z\n";
        this.testReload(0, increment, intervals, N, "1980-01-03T14:00:00.000000Z\n1980-01-03T12:00:00.000000Z\n1980-01-02T22:00:00.000000Z\n1980-01-02T16:00:00.000000Z\n1980-01-02T14:00:00.000000Z\n1980-01-02T12:00:00.000000Z\n1980-01-02T10:00:00.000000Z\n1980-01-02T08:00:00.000000Z\n1980-01-02T06:00:00.000000Z\n1980-01-02T04:00:00.000000Z\n1980-01-02T02:00:00.000000Z\n", null);
    }

    @Test
    public void testPartitionCull() throws Exception {
        long increment = 7200000000L;
        int N = 36;
        intervals.clear();
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T01:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T16:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T21:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T22:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-03T11:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-03T14:00:00.000Z"));
        String expected = "1980-01-03T14:00:00.000000Z\n1980-01-03T12:00:00.000000Z\n1980-01-02T22:00:00.000000Z\n1980-01-02T16:00:00.000000Z\n1980-01-02T14:00:00.000000Z\n1980-01-02T12:00:00.000000Z\n1980-01-02T10:00:00.000000Z\n1980-01-02T08:00:00.000000Z\n1980-01-02T06:00:00.000000Z\n1980-01-02T04:00:00.000000Z\n1980-01-02T02:00:00.000000Z\n";
        this.testIntervals(0, increment, N, "1980-01-03T14:00:00.000000Z\n1980-01-03T12:00:00.000000Z\n1980-01-02T22:00:00.000000Z\n1980-01-02T16:00:00.000000Z\n1980-01-02T14:00:00.000000Z\n1980-01-02T12:00:00.000000Z\n1980-01-02T10:00:00.000000Z\n1980-01-02T08:00:00.000000Z\n1980-01-02T06:00:00.000000Z\n1980-01-02T04:00:00.000000Z\n1980-01-02T02:00:00.000000Z\n", 11L);
    }

    @Test
    public void testPositiveReloadByDay() throws Exception {
        long increment = 7200000000L;
        int N = 36;
        intervals.clear();
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T01:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T16:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T21:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-02T22:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1983-01-05T11:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1983-01-05T14:00:00.000Z"));
        String expected1 = "1980-01-02T22:00:00.000000Z\n1980-01-02T16:00:00.000000Z\n1980-01-02T14:00:00.000000Z\n1980-01-02T12:00:00.000000Z\n1980-01-02T10:00:00.000000Z\n1980-01-02T08:00:00.000000Z\n1980-01-02T06:00:00.000000Z\n1980-01-02T04:00:00.000000Z\n1980-01-02T02:00:00.000000Z\n";
        String expected2 = "1983-01-05T14:00:00.000000Z\n1983-01-05T12:00:00.000000Z\n1980-01-02T22:00:00.000000Z\n1980-01-02T16:00:00.000000Z\n1980-01-02T14:00:00.000000Z\n1980-01-02T12:00:00.000000Z\n1980-01-02T10:00:00.000000Z\n1980-01-02T08:00:00.000000Z\n1980-01-02T06:00:00.000000Z\n1980-01-02T04:00:00.000000Z\n1980-01-02T02:00:00.000000Z\n";
        this.testReload(0, increment, intervals, N, "1980-01-02T22:00:00.000000Z\n1980-01-02T16:00:00.000000Z\n1980-01-02T14:00:00.000000Z\n1980-01-02T12:00:00.000000Z\n1980-01-02T10:00:00.000000Z\n1980-01-02T08:00:00.000000Z\n1980-01-02T06:00:00.000000Z\n1980-01-02T04:00:00.000000Z\n1980-01-02T02:00:00.000000Z\n", "1983-01-05T14:00:00.000000Z\n1983-01-05T12:00:00.000000Z\n1980-01-02T22:00:00.000000Z\n1980-01-02T16:00:00.000000Z\n1980-01-02T14:00:00.000000Z\n1980-01-02T12:00:00.000000Z\n1980-01-02T10:00:00.000000Z\n1980-01-02T08:00:00.000000Z\n1980-01-02T06:00:00.000000Z\n1980-01-02T04:00:00.000000Z\n1980-01-02T02:00:00.000000Z\n");
    }

    public void testReload(int partitionBy, long increment, LongList intervals, int rowCount, CharSequence expected1, CharSequence expected2) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "x", partitionBy).col("a", 8).indexed(true, 4).col("b", 8).indexed(true, 4).timestamp();){
                CairoTestUtils.create(model);
            }
            Rnd rnd = new Rnd();
            long timestamp = DateFormatUtils.parseDateTime((CharSequence)"1980-01-01T00:00:00.000Z");
            try (Engine engine = new Engine(configuration);){
                TableReaderRecord record = new TableReaderRecord();
                IntervalBwdDataFrameCursorFactory factory = new IntervalBwdDataFrameCursorFactory((CairoEngine)engine, "x", 0L, intervals);
                try (DataFrameCursor cursor = factory.getCursor();){
                    record.of(cursor.getTableReader());
                    this.assertEquals("", record, cursor);
                    try (TableWriter writer = new TableWriter(configuration, (CharSequence)"x");){
                        TableWriter.Row row;
                        int i;
                        for (i = 0; i < rowCount; ++i) {
                            row = writer.newRow(timestamp);
                            row.putSym(0, rnd.nextChars(4));
                            row.putSym(1, rnd.nextChars(4));
                            row.append();
                            timestamp += increment;
                        }
                        writer.commit();
                        Assert.assertTrue((boolean)cursor.reload());
                        this.assertEquals(expected1, record, cursor);
                        timestamp = Dates.addYear((long)timestamp, (int)3);
                        for (i = 0; i < rowCount; ++i) {
                            row = writer.newRow(timestamp);
                            row.putSym(0, rnd.nextChars(4));
                            row.putSym(1, rnd.nextChars(4));
                            row.append();
                            timestamp += increment;
                        }
                        writer.commit();
                        Assert.assertTrue((boolean)cursor.reload());
                        if (expected2 != null) {
                            this.assertEquals(expected2, record, cursor);
                        } else {
                            this.assertEquals(expected1, record, cursor);
                        }
                        Assert.assertFalse((boolean)cursor.reload());
                    }
                }
                var16_22 = null;
                try (TableWriter writer = engine.getWriter((CharSequence)"x");){
                    writer.removeColumn((CharSequence)"b");
                }
                catch (Throwable throwable) {
                    var16_22 = throwable;
                    throw throwable;
                }
                try {
                    factory.getCursor();
                    Assert.fail();
                }
                catch (ReaderOutOfDateException readerOutOfDateException) {
                    // empty catch block
                }
            }
        });
    }

    @Test
    public void testSingleIntervalWholeTable() throws Exception {
        long increment = 7200000000L;
        int N = 36;
        intervals.clear();
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1980-01-01T00:00:00.000Z"));
        intervals.add(DateFormatUtils.parseDateTime((CharSequence)"1984-01-06T00:00:00.000Z"));
        String expected = "1983-01-06T22:00:00.000000Z\n1983-01-06T20:00:00.000000Z\n1983-01-06T18:00:00.000000Z\n1983-01-06T16:00:00.000000Z\n1983-01-06T14:00:00.000000Z\n1983-01-06T12:00:00.000000Z\n1983-01-06T10:00:00.000000Z\n1983-01-06T08:00:00.000000Z\n1983-01-06T06:00:00.000000Z\n1983-01-06T04:00:00.000000Z\n1983-01-06T02:00:00.000000Z\n1983-01-06T00:00:00.000000Z\n1983-01-05T22:00:00.000000Z\n1983-01-05T20:00:00.000000Z\n1983-01-05T18:00:00.000000Z\n1983-01-05T16:00:00.000000Z\n1983-01-05T14:00:00.000000Z\n1983-01-05T12:00:00.000000Z\n1983-01-05T10:00:00.000000Z\n1983-01-05T08:00:00.000000Z\n1983-01-05T06:00:00.000000Z\n1983-01-05T04:00:00.000000Z\n1983-01-05T02:00:00.000000Z\n1983-01-05T00:00:00.000000Z\n1983-01-04T22:00:00.000000Z\n1983-01-04T20:00:00.000000Z\n1983-01-04T18:00:00.000000Z\n1983-01-04T16:00:00.000000Z\n1983-01-04T14:00:00.000000Z\n1983-01-04T12:00:00.000000Z\n1983-01-04T10:00:00.000000Z\n1983-01-04T08:00:00.000000Z\n1983-01-04T06:00:00.000000Z\n1983-01-04T04:00:00.000000Z\n1983-01-04T02:00:00.000000Z\n1983-01-04T00:00:00.000000Z\n1980-01-03T22:00:00.000000Z\n1980-01-03T20:00:00.000000Z\n1980-01-03T18:00:00.000000Z\n1980-01-03T16:00:00.000000Z\n1980-01-03T14:00:00.000000Z\n1980-01-03T12:00:00.000000Z\n1980-01-03T10:00:00.000000Z\n1980-01-03T08:00:00.000000Z\n1980-01-03T06:00:00.000000Z\n1980-01-03T04:00:00.000000Z\n1980-01-03T02:00:00.000000Z\n1980-01-03T00:00:00.000000Z\n1980-01-02T22:00:00.000000Z\n1980-01-02T20:00:00.000000Z\n1980-01-02T18:00:00.000000Z\n1980-01-02T16:00:00.000000Z\n1980-01-02T14:00:00.000000Z\n1980-01-02T12:00:00.000000Z\n1980-01-02T10:00:00.000000Z\n1980-01-02T08:00:00.000000Z\n1980-01-02T06:00:00.000000Z\n1980-01-02T04:00:00.000000Z\n1980-01-02T02:00:00.000000Z\n1980-01-02T00:00:00.000000Z\n1980-01-01T22:00:00.000000Z\n1980-01-01T20:00:00.000000Z\n1980-01-01T18:00:00.000000Z\n1980-01-01T16:00:00.000000Z\n1980-01-01T14:00:00.000000Z\n1980-01-01T12:00:00.000000Z\n1980-01-01T10:00:00.000000Z\n1980-01-01T08:00:00.000000Z\n1980-01-01T06:00:00.000000Z\n1980-01-01T04:00:00.000000Z\n1980-01-01T02:00:00.000000Z\n1980-01-01T00:00:00.000000Z\n";
        this.testIntervals(0, increment, N, "1983-01-06T22:00:00.000000Z\n1983-01-06T20:00:00.000000Z\n1983-01-06T18:00:00.000000Z\n1983-01-06T16:00:00.000000Z\n1983-01-06T14:00:00.000000Z\n1983-01-06T12:00:00.000000Z\n1983-01-06T10:00:00.000000Z\n1983-01-06T08:00:00.000000Z\n1983-01-06T06:00:00.000000Z\n1983-01-06T04:00:00.000000Z\n1983-01-06T02:00:00.000000Z\n1983-01-06T00:00:00.000000Z\n1983-01-05T22:00:00.000000Z\n1983-01-05T20:00:00.000000Z\n1983-01-05T18:00:00.000000Z\n1983-01-05T16:00:00.000000Z\n1983-01-05T14:00:00.000000Z\n1983-01-05T12:00:00.000000Z\n1983-01-05T10:00:00.000000Z\n1983-01-05T08:00:00.000000Z\n1983-01-05T06:00:00.000000Z\n1983-01-05T04:00:00.000000Z\n1983-01-05T02:00:00.000000Z\n1983-01-05T00:00:00.000000Z\n1983-01-04T22:00:00.000000Z\n1983-01-04T20:00:00.000000Z\n1983-01-04T18:00:00.000000Z\n1983-01-04T16:00:00.000000Z\n1983-01-04T14:00:00.000000Z\n1983-01-04T12:00:00.000000Z\n1983-01-04T10:00:00.000000Z\n1983-01-04T08:00:00.000000Z\n1983-01-04T06:00:00.000000Z\n1983-01-04T04:00:00.000000Z\n1983-01-04T02:00:00.000000Z\n1983-01-04T00:00:00.000000Z\n1980-01-03T22:00:00.000000Z\n1980-01-03T20:00:00.000000Z\n1980-01-03T18:00:00.000000Z\n1980-01-03T16:00:00.000000Z\n1980-01-03T14:00:00.000000Z\n1980-01-03T12:00:00.000000Z\n1980-01-03T10:00:00.000000Z\n1980-01-03T08:00:00.000000Z\n1980-01-03T06:00:00.000000Z\n1980-01-03T04:00:00.000000Z\n1980-01-03T02:00:00.000000Z\n1980-01-03T00:00:00.000000Z\n1980-01-02T22:00:00.000000Z\n1980-01-02T20:00:00.000000Z\n1980-01-02T18:00:00.000000Z\n1980-01-02T16:00:00.000000Z\n1980-01-02T14:00:00.000000Z\n1980-01-02T12:00:00.000000Z\n1980-01-02T10:00:00.000000Z\n1980-01-02T08:00:00.000000Z\n1980-01-02T06:00:00.000000Z\n1980-01-02T04:00:00.000000Z\n1980-01-02T02:00:00.000000Z\n1980-01-02T00:00:00.000000Z\n1980-01-01T22:00:00.000000Z\n1980-01-01T20:00:00.000000Z\n1980-01-01T18:00:00.000000Z\n1980-01-01T16:00:00.000000Z\n1980-01-01T14:00:00.000000Z\n1980-01-01T12:00:00.000000Z\n1980-01-01T10:00:00.000000Z\n1980-01-01T08:00:00.000000Z\n1980-01-01T06:00:00.000000Z\n1980-01-01T04:00:00.000000Z\n1980-01-01T02:00:00.000000Z\n1980-01-01T00:00:00.000000Z\n", 72L);
    }

    private static void assertIndexRowsMatchSymbol(DataFrameCursor cursor, TableReaderRecord record, int columnIndex, long expectedCount) {
        SymbolTable symbolTable = cursor.getSymbolTable(columnIndex);
        long rowCount = 0L;
        while (cursor.hasNext()) {
            DataFrame frame = (DataFrame)cursor.next();
            record.jumpTo(frame.getPartitionIndex(), frame.getRowLo());
            long limit = frame.getRowHi();
            long low = frame.getRowLo();
            BitmapIndexReader indexReader = frame.getBitmapIndexReader(columnIndex, 2);
            Assert.assertNotNull((Object)indexReader);
            int keyCount = indexReader.getKeyCount();
            for (int i = 0; i < keyCount; ++i) {
                RowCursor ic = indexReader.getCursor(true, i, low, limit - 1L);
                CharSequence expected = symbolTable.value(i - 1);
                while (ic.hasNext()) {
                    long row = ic.next();
                    record.setRecordIndex(row);
                    TestUtils.assertEquals(expected, record.getSym(columnIndex));
                    ++rowCount;
                }
            }
        }
        Assert.assertEquals((long)expectedCount, (long)rowCount);
    }

    private void assertEquals(CharSequence expected, TableReaderRecord record, DataFrameCursor cursor) {
        sink.clear();
        this.collectTimestamps(cursor, record);
        TestUtils.assertEquals(expected, (CharSequence)sink);
    }

    private void collectTimestamps(DataFrameCursor cursor, TableReaderRecord record) {
        int timestampIndex = cursor.getTableReader().getMetadata().getTimestampIndex();
        while (cursor.hasNext()) {
            long recordIndex;
            DataFrame frame = (DataFrame)cursor.next();
            record.jumpTo(frame.getPartitionIndex(), frame.getRowHi() - 1L);
            long limit = frame.getRowLo() - 1L;
            while ((recordIndex = record.getRecordIndex()) > limit) {
                AbstractCairoTest.sink.putISODate(record.getDate(timestampIndex)).put('\n');
                record.setRecordIndex(recordIndex - 1L);
            }
        }
    }

    private void testIntervals(int partitionBy, long increment, int rowCount, CharSequence expected, long expectedCount) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "x", partitionBy).col("a", 8).indexed(true, 4).col("b", 8).indexed(true, 4).timestamp();){
                CairoTestUtils.create(model);
            }
            Rnd rnd = new Rnd();
            long timestamp = DateFormatUtils.parseDateTime((CharSequence)"1980-01-01T00:00:00.000Z");
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"x");){
                TableWriter.Row row;
                int i;
                for (i = 0; i < rowCount; ++i) {
                    row = writer.newRow(timestamp);
                    row.putSym(0, rnd.nextChars(4));
                    row.putSym(1, rnd.nextChars(4));
                    row.append();
                    timestamp += increment;
                }
                writer.commit();
                timestamp = Dates.addYear((long)timestamp, (int)3);
                for (i = 0; i < rowCount; ++i) {
                    row = writer.newRow(timestamp);
                    row.putSym(0, rnd.nextChars(4));
                    row.putSym(1, rnd.nextChars(4));
                    row.append();
                    timestamp += increment;
                }
                writer.commit();
            }
            var12_14 = null;
            try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                TableReaderRecord record = new TableReaderRecord();
                IntervalBwdDataFrameCursor cursor = new IntervalBwdDataFrameCursor(intervals);
                cursor.of(reader);
                record.of(reader);
                this.assertEquals(expected, record, (DataFrameCursor)cursor);
                if (expected.length() > 0) {
                    cursor.toTop();
                    IntervalBwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 0, expectedCount);
                    cursor.toTop();
                    IntervalBwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 1, expectedCount);
                }
                cursor.toTop();
                this.assertEquals(expected, record, (DataFrameCursor)cursor);
            }
            catch (Throwable throwable) {
                var12_14 = throwable;
                throw throwable;
            }
        });
    }
}

