/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.CairoException;
import com.questdb.cairo.GenericRecordMetadata;
import com.questdb.cairo.TableColumnMetadata;
import com.questdb.cairo.sql.InvalidColumnException;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.StringSink;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class GenericRecordMetadataTest {
    private static final StringSink sink = new StringSink();

    @Test
    public void testBaseInterfaceDefaults() {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("abc", 3));
        metadata.add(new TableColumnMetadata("cde", 8, true, 1024));
        metadata.add(new TableColumnMetadata("timestamp", 12));
        metadata.setTimestampIndex(2);
        Assert.assertEquals((long)12L, (long)metadata.getColumnType((CharSequence)"timestamp"));
        try {
            metadata.getColumnIndex((CharSequence)"xyz");
            Assert.fail();
        }
        catch (InvalidColumnException invalidColumnException) {
            // empty catch block
        }
        Assert.assertEquals((long)1024L, (long)metadata.getIndexValueBlockCapacity((CharSequence)"cde"));
    }

    @Test
    public void testDuplicateColumn() {
        String expected = "{\"columnCount\":2,\"columns\":[{\"index\":0,\"name\":\"abc\",\"type\":\"INT\"},{\"index\":1,\"name\":\"cde\",\"type\":\"INT\"}],\"timestampIndex\":-1}";
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("abc", 3));
        metadata.add(new TableColumnMetadata("cde", 3));
        sink.clear();
        metadata.toJson((CharSink)sink);
        TestUtils.assertEquals((CharSequence)"{\"columnCount\":2,\"columns\":[{\"index\":0,\"name\":\"abc\",\"type\":\"INT\"},{\"index\":1,\"name\":\"cde\",\"type\":\"INT\"}],\"timestampIndex\":-1}", (CharSequence)sink);
        try {
            metadata.add(new TableColumnMetadata("abc", 5));
            Assert.fail();
        }
        catch (CairoException e) {
            TestUtils.assertContains(e.getMessage(), "Duplicate column");
        }
        sink.clear();
        metadata.toJson((CharSink)sink);
        TestUtils.assertEquals((CharSequence)"{\"columnCount\":2,\"columns\":[{\"index\":0,\"name\":\"abc\",\"type\":\"INT\"},{\"index\":1,\"name\":\"cde\",\"type\":\"INT\"}],\"timestampIndex\":-1}", (CharSequence)sink);
    }

    @Test
    public void testReuse() {
        String expected1 = "{\"columnCount\":3,\"columns\":[{\"index\":0,\"name\":\"abc\",\"type\":\"INT\"},{\"index\":1,\"name\":\"cde\",\"type\":\"INT\"},{\"index\":2,\"name\":\"timestamp\",\"type\":\"TIMESTAMP\"}],\"timestampIndex\":2}";
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("abc", 3));
        metadata.add(new TableColumnMetadata("cde", 3));
        metadata.add(new TableColumnMetadata("timestamp", 12));
        metadata.setTimestampIndex(2);
        sink.clear();
        metadata.toJson((CharSink)sink);
        TestUtils.assertEquals((CharSequence)expected1, (CharSequence)sink);
        String expected2 = "{\"columnCount\":2,\"columns\":[{\"index\":0,\"name\":\"x\",\"type\":\"SYMBOL\"},{\"index\":1,\"name\":\"z\",\"type\":\"DATE\"}],\"timestampIndex\":-1}";
        metadata.clear();
        metadata.add(new TableColumnMetadata("x", 8));
        metadata.add(new TableColumnMetadata("z", 10));
        sink.clear();
        metadata.toJson((CharSink)sink);
        TestUtils.assertEquals((CharSequence)expected2, (CharSequence)sink);
    }
}

