/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.BitmapIndexReader;
import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.CairoError;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.CairoWorkScheduler;
import com.questdb.cairo.ColumnIndexerEntry;
import com.questdb.cairo.ColumnIndexerJob;
import com.questdb.cairo.DefaultCairoConfiguration;
import com.questdb.cairo.FullFwdDataFrameCursor;
import com.questdb.cairo.TableModel;
import com.questdb.cairo.TableReader;
import com.questdb.cairo.TableReaderRecord;
import com.questdb.cairo.TableUtils;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.TestFilesFacade;
import com.questdb.cairo.sql.DataFrame;
import com.questdb.cairo.sql.DataFrameCursor;
import com.questdb.cairo.sql.RecordMetadata;
import com.questdb.cairo.sql.RowCursor;
import com.questdb.cairo.sql.SymbolTable;
import com.questdb.mp.Barrier;
import com.questdb.mp.Job;
import com.questdb.mp.MCSequence;
import com.questdb.mp.MPSequence;
import com.questdb.mp.RingQueue;
import com.questdb.mp.Sequence;
import com.questdb.mp.Worker;
import com.questdb.std.Chars;
import com.questdb.std.Files;
import com.questdb.std.FilesFacade;
import com.questdb.std.FilesFacadeImpl;
import com.questdb.std.Numbers;
import com.questdb.std.ObjHashSet;
import com.questdb.std.Rnd;
import com.questdb.std.microtime.DateFormatUtils;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.StringSink;
import com.questdb.test.tools.TestUtils;
import java.util.concurrent.CountDownLatch;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class FullFwdDataFrameCursorTest
extends AbstractCairoTest {
    private static final int WORK_STEALING_DONT_TEST = 0;
    private static final int WORK_STEALING_NO_PICKUP = 1;
    private static final int WORK_STEALING_BUSY_QUEUE = 2;
    private static final int WORK_STEALING_HIGH_CONTENTION = 3;
    private static final int WORK_STEALING_CAS_FLAP = 4;

    @Test
    public void testClose() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "x", 3).col("a", 3).col("b", 3).timestamp();){
                CairoTestUtils.create(model);
            }
            TableReader reader = new TableReader(configuration, (CharSequence)"x");
            FullFwdDataFrameCursor cursor = new FullFwdDataFrameCursor();
            cursor.of(reader);
            cursor.close();
            Assert.assertFalse((boolean)reader.isOpen());
            cursor.close();
            Assert.assertFalse((boolean)reader.isOpen());
        });
    }

    @Test
    public void testEmptyPartitionSkip() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "x", 3).col("a", 3).col("b", 3).timestamp();){
                CairoTestUtils.create(model);
            }
            Rnd rnd = new Rnd();
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"x");){
                long timestamp = DateFormatUtils.parseDateTime((CharSequence)"1970-01-03T08:00:00.000Z");
                TableWriter.Row row = writer.newRow(timestamp);
                row.putInt(0, rnd.nextInt());
                row.putInt(1, rnd.nextInt());
                try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                    FullFwdDataFrameCursor cursor = new FullFwdDataFrameCursor();
                    int frameCount = 0;
                    cursor.of(reader);
                    while (cursor.hasNext()) {
                        cursor.next();
                        ++frameCount;
                    }
                    Assert.assertEquals((long)0L, (long)frameCount);
                }
            }
        });
    }

    @Test
    public void testFailToRemoveDistressFileByDay() throws Exception {
        this.testFailToRemoveDistressFile(0, 10000000L);
    }

    @Test
    public void testFailToRemoveDistressFileByMonth() throws Exception {
        this.testFailToRemoveDistressFile(1, 320000000L);
    }

    @Test
    public void testFailToRemoveDistressFileByNone() throws Exception {
        this.testFailToRemoveDistressFile(3, 10L);
    }

    @Test
    public void testFailToRemoveDistressFileByYear() throws Exception {
        this.testFailToRemoveDistressFile(2, 3840000000L);
    }

    @Test
    @Ignore
    public void testIndexFailAtRuntimeByDay1k() throws Exception {
        this.testIndexFailureAtRuntime(0, 10L, false, "1970-01-01" + Files.SEPARATOR + "a.k", 1);
    }

    @Test
    public void testIndexFailAtRuntimeByDay1v() throws Exception {
        this.testIndexFailureAtRuntime(0, 10000000L, false, "1970-01-02" + Files.SEPARATOR + "a.v", 2);
    }

    @Test
    public void testIndexFailAtRuntimeByDay2v() throws Exception {
        this.testIndexFailureAtRuntime(0, 10000000L, false, "1970-01-02" + Files.SEPARATOR + "b.v", 2);
    }

    @Test
    public void testIndexFailAtRuntimeByDay3v() throws Exception {
        this.testIndexFailureAtRuntime(0, 10000000L, false, "1970-01-02" + Files.SEPARATOR + "c.v", 2);
    }

    @Test
    public void testIndexFailAtRuntimeByMonth1v() throws Exception {
        this.testIndexFailureAtRuntime(1, 320000000L, false, "1970-02" + Files.SEPARATOR + "a.v", 2);
    }

    @Test
    public void testIndexFailAtRuntimeByMonth2v() throws Exception {
        this.testIndexFailureAtRuntime(1, 300000000L, false, "1970-02" + Files.SEPARATOR + "b.v", 2);
    }

    @Test
    public void testIndexFailAtRuntimeByMonth3v() throws Exception {
        this.testIndexFailureAtRuntime(1, 300000000L, false, "1970-02" + Files.SEPARATOR + "c.v", 2);
    }

    @Test
    public void testIndexFailAtRuntimeByNone1v() throws Exception {
        this.testIndexFailureAtRuntime(3, 10L, false, "default" + Files.SEPARATOR + "a.v", 1);
    }

    @Test
    public void testIndexFailAtRuntimeByNone2v() throws Exception {
        this.testIndexFailureAtRuntime(3, 10L, false, "default" + Files.SEPARATOR + "b.v", 1);
    }

    @Test
    public void testIndexFailAtRuntimeByNone3v() throws Exception {
        this.testIndexFailureAtRuntime(3, 10L, false, "default" + Files.SEPARATOR + "c.v", 1);
    }

    @Test
    public void testIndexFailAtRuntimeByNoneEmpty1v() throws Exception {
        this.testIndexFailureAtRuntime(3, 10L, true, "default" + Files.SEPARATOR + "a.v", 0);
    }

    @Test
    public void testIndexFailAtRuntimeByNoneEmpty2v() throws Exception {
        this.testIndexFailureAtRuntime(3, 10L, true, "default" + Files.SEPARATOR + "b.v", 0);
    }

    @Test
    public void testIndexFailAtRuntimeByNoneEmpty3v() throws Exception {
        this.testIndexFailureAtRuntime(3, 10L, true, "default" + Files.SEPARATOR + "c.v", 0);
    }

    @Test
    public void testIndexFailAtRuntimeByYear1v() throws Exception {
        this.testIndexFailureAtRuntime(2, 3600000000L, false, "1972" + Files.SEPARATOR + "a.v", 2);
    }

    @Test
    public void testIndexFailAtRuntimeByYear2v() throws Exception {
        this.testIndexFailureAtRuntime(2, 3600000000L, false, "1972" + Files.SEPARATOR + "b.v", 2);
    }

    @Test
    public void testIndexFailAtRuntimeByYear3v() throws Exception {
        this.testIndexFailureAtRuntime(2, 3600000000L, false, "1972" + Files.SEPARATOR + "c.v", 2);
    }

    @Test
    public void testIndexFailAtRuntimeByYearEmpty1v() throws Exception {
        this.testIndexFailureAtRuntime(2, 3600000000L, true, "1970" + Files.SEPARATOR + "a.v", 0);
    }

    @Test
    public void testIndexFailAtRuntimeByYearEmpty2v() throws Exception {
        this.testIndexFailureAtRuntime(2, 3600000000L, true, "1970" + Files.SEPARATOR + "b.v", 0);
    }

    @Test
    public void testIndexFailAtRuntimeByYearEmpty3v() throws Exception {
        this.testIndexFailureAtRuntime(2, 3600000000L, true, "1970" + Files.SEPARATOR + "c.v", 0);
    }

    @Test
    public void testIndexFailInConstructorByDay1k() throws Exception {
        this.testIndexFailureInConstructor(0, 1000000L, false, "1970-01-01" + Files.SEPARATOR + "a.k");
    }

    @Test
    public void testIndexFailInConstructorByDay1v() throws Exception {
        this.testIndexFailureInConstructor(0, 1000000L, false, "1970-01-01" + Files.SEPARATOR + "a.v");
    }

    @Test
    public void testIndexFailInConstructorByDay2k() throws Exception {
        this.testIndexFailureInConstructor(0, 1000000L, false, "1970-01-01" + Files.SEPARATOR + "b.k");
    }

    @Test
    public void testIndexFailInConstructorByDay2v() throws Exception {
        this.testIndexFailureInConstructor(0, 1000000L, false, "1970-01-01" + Files.SEPARATOR + "b.v");
    }

    @Test
    public void testIndexFailInConstructorByNoneEmpty1k() throws Exception {
        this.testIndexFailureInConstructor(3, 1000L, true, "default" + Files.SEPARATOR + "a.k");
    }

    @Test
    public void testIndexFailInConstructorByNoneEmpty1v() throws Exception {
        this.testIndexFailureInConstructor(3, 1000L, true, "default" + Files.SEPARATOR + "a.v");
    }

    @Test
    public void testIndexFailInConstructorByNoneEmpty2k() throws Exception {
        this.testIndexFailureInConstructor(3, 1000L, true, "default" + Files.SEPARATOR + "b.k");
    }

    @Test
    public void testIndexFailInConstructorByNoneEmpty2v() throws Exception {
        this.testIndexFailureInConstructor(3, 1000L, true, "default" + Files.SEPARATOR + "b.v");
    }

    @Test
    public void testIndexFailInConstructorByNoneEmpty3k() throws Exception {
        this.testIndexFailureInConstructor(3, 1000L, true, "default" + Files.SEPARATOR + "c.k");
    }

    @Test
    public void testIndexFailInConstructorByNoneEmpty3v() throws Exception {
        this.testIndexFailureInConstructor(3, 1000L, true, "default" + Files.SEPARATOR + "c.v");
    }

    @Test
    public void testIndexFailInConstructorByNoneFull() throws Exception {
        this.testIndexFailureInConstructor(3, 1000L, false, "default" + Files.SEPARATOR + "a.v");
    }

    @Test
    public void testParallelIndexByDay() throws Exception {
        this.testParallelIndex(0, 1000000L, 5, 0);
    }

    @Test
    public void testParallelIndexByDayBusy() throws Exception {
        this.testParallelIndex(0, 1000000L, 5, 2);
    }

    @Test
    public void testParallelIndexByDayCasFlap() throws Exception {
        this.testParallelIndex(0, 1000000L, 5, 4);
    }

    @Test
    public void testParallelIndexByDayContention() throws Exception {
        this.testParallelIndex(0, 1000000L, 5, 3);
    }

    @Test
    public void testParallelIndexByDayNoPickup() throws Exception {
        this.testParallelIndex(0, 1000000L, 5, 1);
    }

    @Test
    public void testParallelIndexByMonth() throws Exception {
        this.testParallelIndex(1, 10000000L, 3, 0);
    }

    @Test
    public void testParallelIndexByMonthBusy() throws Exception {
        this.testParallelIndex(1, 10000000L, 3, 2);
    }

    @Test
    public void testParallelIndexByMonthContention() throws Exception {
        this.testParallelIndex(1, 10000000L, 3, 3);
    }

    @Test
    public void testParallelIndexByMonthNoPickup() throws Exception {
        this.testParallelIndex(1, 10000000L, 3, 1);
    }

    @Test
    public void testParallelIndexByNone() throws Exception {
        this.testParallelIndex(3, 0L, 0, 0);
    }

    @Test
    public void testParallelIndexByNoneBusy() throws Exception {
        this.testParallelIndex(3, 0L, 0, 2);
    }

    @Test
    public void testParallelIndexByNoneContention() throws Exception {
        this.testParallelIndex(3, 0L, 0, 3);
    }

    @Test
    public void testParallelIndexByNoneNoPickup() throws Exception {
        this.testParallelIndex(3, 0L, 0, 1);
    }

    @Test
    public void testParallelIndexByYear() throws Exception {
        this.testParallelIndex(2, 120000000L, 3, 0);
    }

    @Test
    public void testParallelIndexByYearBusy() throws Exception {
        this.testParallelIndex(2, 120000000L, 3, 2);
    }

    @Test
    public void testParallelIndexByYearContention() throws Exception {
        this.testParallelIndex(2, 120000000L, 3, 3);
    }

    @Test
    public void testParallelIndexByYearNoPickup() throws Exception {
        this.testParallelIndex(2, 120000000L, 3, 1);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByDay1v() throws Exception {
        this.testParallelIndexFailureAtRuntime(0, 10000000L, false, "1970-01-02" + Files.SEPARATOR + "a.v", 2);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByDay2v() throws Exception {
        this.testParallelIndexFailureAtRuntime(0, 10000000L, false, "1970-01-02" + Files.SEPARATOR + "b.v", 2);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByDay3v() throws Exception {
        this.testParallelIndexFailureAtRuntime(0, 10000000L, false, "1970-01-02" + Files.SEPARATOR + "c.v", 2);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByDayEmpty1v() throws Exception {
        this.testParallelIndexFailureAtRuntime(0, 10000000L, true, "1970-01-02" + Files.SEPARATOR + "a.v", 0);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByDayEmpty2v() throws Exception {
        this.testParallelIndexFailureAtRuntime(0, 10000000L, true, "1970-01-02" + Files.SEPARATOR + "b.v", 0);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByDayEmpty3v() throws Exception {
        this.testParallelIndexFailureAtRuntime(0, 10000000L, true, "1970-01-02" + Files.SEPARATOR + "c.v", 0);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByMonth1v() throws Exception {
        this.testParallelIndexFailureAtRuntime(1, 320000000L, false, "1970-02" + Files.SEPARATOR + "a.v", 2);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByMonth2v() throws Exception {
        this.testParallelIndexFailureAtRuntime(1, 300000000L, false, "1970-02" + Files.SEPARATOR + "b.v", 2);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByMonth3v() throws Exception {
        this.testParallelIndexFailureAtRuntime(1, 300000000L, false, "1970-02" + Files.SEPARATOR + "c.v", 2);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByMonthEmpty1v() throws Exception {
        this.testParallelIndexFailureAtRuntime(1, 320000000L, true, "1970-02" + Files.SEPARATOR + "a.v", 0);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByMonthEmpty2v() throws Exception {
        this.testParallelIndexFailureAtRuntime(1, 300000000L, true, "1970-02" + Files.SEPARATOR + "b.v", 0);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByMonthEmpty3v() throws Exception {
        this.testParallelIndexFailureAtRuntime(1, 300000000L, true, "1970-02" + Files.SEPARATOR + "c.v", 0);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByNone1v() throws Exception {
        this.testParallelIndexFailureAtRuntime(3, 10L, false, "default" + Files.SEPARATOR + "a.v", 1);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByNone2v() throws Exception {
        this.testParallelIndexFailureAtRuntime(3, 10L, false, "default" + Files.SEPARATOR + "b.v", 1);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByNone3v() throws Exception {
        this.testParallelIndexFailureAtRuntime(3, 10L, false, "default" + Files.SEPARATOR + "c.v", 1);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByNoneEmpty1v() throws Exception {
        this.testParallelIndexFailureAtRuntime(3, 10L, true, "default" + Files.SEPARATOR + "a.v", 0);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByNoneEmpty2v() throws Exception {
        this.testParallelIndexFailureAtRuntime(3, 10L, true, "default" + Files.SEPARATOR + "b.v", 0);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByNoneEmpty3v() throws Exception {
        this.testParallelIndexFailureAtRuntime(3, 10L, true, "default" + Files.SEPARATOR + "c.v", 0);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByYear1v() throws Exception {
        this.testParallelIndexFailureAtRuntime(2, 3600000000L, false, "1972" + Files.SEPARATOR + "a.v", 2);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByYear2v() throws Exception {
        this.testParallelIndexFailureAtRuntime(2, 3600000000L, false, "1972" + Files.SEPARATOR + "b.v", 2);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByYear3v() throws Exception {
        this.testParallelIndexFailureAtRuntime(2, 3600000000L, false, "1972" + Files.SEPARATOR + "c.v", 2);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByYearEmpty1v() throws Exception {
        this.testParallelIndexFailureAtRuntime(2, 3600000000L, true, "1970" + Files.SEPARATOR + "a.v", 0);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByYearEmpty2v() throws Exception {
        this.testParallelIndexFailureAtRuntime(2, 3600000000L, true, "1970" + Files.SEPARATOR + "b.v", 0);
    }

    @Test
    public void testParallelIndexFailAtRuntimeByYearEmpty3v() throws Exception {
        this.testParallelIndexFailureAtRuntime(2, 3600000000L, true, "1970" + Files.SEPARATOR + "c.v", 0);
    }

    @Test
    public void testRemoveFirstColByDay() throws Exception {
        this.testRemoveFirstColumn(0, 300000000L, 3);
    }

    @Test
    public void testRemoveFirstColByMonth() throws Exception {
        this.testRemoveFirstColumn(1, 7200000000L, 2);
    }

    @Test
    public void testRemoveFirstColByNone() throws Exception {
        this.testRemoveFirstColumn(3, 300000000L, 0);
    }

    @Test
    public void testRemoveFirstColByYear() throws Exception {
        this.testRemoveFirstColumn(2, 72000000000L, 2);
    }

    @Test
    public void testRemoveLastColByDay() throws Exception {
        this.testRemoveLastColumn(0, 300000000L, 3);
    }

    @Test
    public void testRemoveLastColByMonth() throws Exception {
        this.testRemoveLastColumn(1, 7200000000L, 2);
    }

    @Test
    public void testRemoveLastColByNone() throws Exception {
        this.testRemoveFirstColumn(3, 300000000L, 0);
    }

    @Test
    public void testRemoveLastColByYear() throws Exception {
        this.testRemoveLastColumn(2, 72000000000L, 2);
    }

    @Test
    public void testRemoveMidColByDay() throws Exception {
        this.testRemoveMidColumn(0, 300000000L, 3);
    }

    @Test
    public void testRemoveMidColByMonth() throws Exception {
        this.testRemoveMidColumn(1, 7200000000L, 2);
    }

    @Test
    public void testRemoveMidColByNone() throws Exception {
        this.testRemoveMidColumn(3, 300000000L, 0);
    }

    @Test
    public void testRemoveMidColByYear() throws Exception {
        this.testRemoveMidColumn(2, 72000000000L, 2);
    }

    @Test
    public void testReplaceIndexedWithIndexedByByNone() throws Exception {
        this.testReplaceIndexedColWithIndexed(3, 300000000L, 0, false);
    }

    @Test
    public void testReplaceIndexedWithIndexedByByNoneRTrunc() throws Exception {
        this.testReplaceIndexedColWithIndexedWithTruncate(3, 300000000L, 0, true);
    }

    @Test
    public void testReplaceIndexedWithIndexedByByNoneTrunc() throws Exception {
        this.testReplaceIndexedColWithIndexedWithTruncate(3, 300000000L, 0, false);
    }

    @Test
    public void testReplaceIndexedWithIndexedByByNoneR() throws Exception {
        this.testReplaceIndexedColWithIndexed(3, 300000000L, 0, true);
    }

    @Test
    public void testReplaceIndexedWithIndexedByByYearRTrunc() throws Exception {
        this.testReplaceIndexedColWithIndexedWithTruncate(2, 72000000000L, 2, true);
    }

    @Test
    public void testReplaceIndexedWithIndexedByByYear() throws Exception {
        this.testReplaceIndexedColWithIndexed(2, 72000000000L, 2, false);
    }

    @Test
    public void testReplaceIndexedWithIndexedByByYearTrunc() throws Exception {
        this.testReplaceIndexedColWithIndexedWithTruncate(2, 72000000000L, 2, false);
    }

    @Test
    public void testReplaceIndexedWithIndexedByByYearR() throws Exception {
        this.testReplaceIndexedColWithIndexed(2, 72000000000L, 2, true);
    }

    @Test
    public void testReplaceIndexedWithIndexedByDayRTrunc() throws Exception {
        this.testReplaceIndexedColWithIndexedWithTruncate(0, 300000000L, 3, true);
    }

    @Test
    public void testReplaceIndexedWithIndexedByDay() throws Exception {
        this.testReplaceIndexedColWithIndexed(0, 300000000L, 3, false);
    }

    @Test
    public void testReplaceIndexedWithIndexedByDayTrunc() throws Exception {
        this.testReplaceIndexedColWithIndexedWithTruncate(0, 300000000L, 3, false);
    }

    @Test
    public void testReplaceIndexedWithIndexedByDayR() throws Exception {
        this.testReplaceIndexedColWithIndexed(0, 300000000L, 3, true);
    }

    @Test
    public void testReplaceIndexedWithIndexedByMonthRTrunc() throws Exception {
        this.testReplaceIndexedColWithIndexedWithTruncate(1, 7200000000L, 2, true);
    }

    @Test
    public void testReplaceIndexedWithIndexedByMonth() throws Exception {
        this.testReplaceIndexedColWithIndexed(1, 7200000000L, 2, false);
    }

    @Test
    public void testReplaceIndexedWithIndexedByMonthTrunc() throws Exception {
        this.testReplaceIndexedColWithIndexedWithTruncate(1, 7200000000L, 2, false);
    }

    @Test
    public void testReplaceIndexedWithIndexedByMonthR() throws Exception {
        this.testReplaceIndexedColWithIndexed(1, 7200000000L, 2, true);
    }

    @Test
    public void testSimpleSymbolIndex() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 1000000;
            int S = 128;
            Rnd rnd = new Rnd();
            SymbolGroup sg = new SymbolGroup(rnd, S, N, 3, true);
            MyWorkScheduler workScheduler = new MyWorkScheduler((Sequence)new MPSequence(1024){
                private boolean flap;
                {
                    this.flap = false;
                }

                public long next() {
                    boolean flap = this.flap;
                    this.flap = !this.flap;
                    return flap ? -1L : -2L;
                }
            }, null);
            long timestamp = 0L;
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"ABC", (CairoWorkScheduler)workScheduler);){
                for (int i = 0; i < N; ++i) {
                    TableWriter.Row r = writer.newRow(timestamp);
                    r.putSym(0, (CharSequence)sg.symA[rnd.nextPositiveInt() % S]);
                    r.putSym(1, (CharSequence)sg.symB[rnd.nextPositiveInt() % S]);
                    r.putSym(2, (CharSequence)sg.symC[rnd.nextPositiveInt() % S]);
                    r.putDouble(3, rnd.nextDouble2());
                    r.append();
                }
                writer.commit();
            }
            var9_8 = null;
            try (TableReader reader = new TableReader(configuration, (CharSequence)"ABC");){
                Assert.assertTrue((reader.getPartitionCount() > 0 ? 1 : 0) != 0);
                FullFwdDataFrameCursor cursor = new FullFwdDataFrameCursor();
                TableReaderRecord record = new TableReaderRecord();
                cursor.of(reader);
                record.of(reader);
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 0, N);
                cursor.toTop();
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 1, N);
                cursor.toTop();
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 2, N);
            }
            catch (Throwable throwable) {
                var9_8 = throwable;
                throw throwable;
            }
        });
    }

    @Test
    public void testReplaceIndexedWithUnindexedByByDay() throws Exception {
        this.testReplaceIndexedColWithUnindexed(0, 300000000L, 3, false);
    }

    @Test
    public void testReplaceIndexedWithUnindexedByByDayR() throws Exception {
        this.testReplaceIndexedColWithUnindexed(0, 300000000L, 3, true);
    }

    @Test
    public void testReplaceIndexedWithUnindexedByByNone() throws Exception {
        this.testReplaceIndexedColWithUnindexed(3, 300000000L, 0, false);
    }

    @Test
    public void testReplaceIndexedWithUnindexedByByNoneR() throws Exception {
        this.testReplaceIndexedColWithUnindexed(3, 300000000L, 0, true);
    }

    @Test
    public void testReplaceIndexedWithUnindexedByByYear() throws Exception {
        this.testReplaceIndexedColWithUnindexed(2, 72000000000L, 2, false);
    }

    @Test
    public void testReplaceIndexedWithUnindexedByByYearR() throws Exception {
        this.testReplaceIndexedColWithUnindexed(2, 72000000000L, 2, true);
    }

    @Test
    public void testReplaceIndexedWithUnindexedByMonth() throws Exception {
        this.testReplaceIndexedColWithUnindexed(1, 7200000000L, 2, false);
    }

    @Test
    public void testReplaceIndexedWithUnindexedByMonthR() throws Exception {
        this.testReplaceIndexedColWithUnindexed(1, 7200000000L, 2, true);
    }

    @Test
    public void testReplaceUnindexedWithIndexedByDay() throws Exception {
        this.testReplaceUnindexedColWithIndexed(0, 300000000L, 3, false);
    }

    @Test
    public void testReplaceUnindexedWithIndexedByDayR() throws Exception {
        this.testReplaceUnindexedColWithIndexed(0, 300000000L, 3, true);
    }

    @Test
    public void testReplaceUnindexedWithIndexedByMonth() throws Exception {
        this.testReplaceUnindexedColWithIndexed(1, 7200000000L, 2, false);
    }

    @Test
    public void testReplaceUnindexedWithIndexedByMonthR() throws Exception {
        this.testReplaceUnindexedColWithIndexed(1, 7200000000L, 2, true);
    }

    @Test
    public void testReplaceUnindexedWithIndexedByNone() throws Exception {
        this.testReplaceUnindexedColWithIndexed(3, 300000000L, 0, false);
    }

    @Test
    public void testReplaceUnindexedWithIndexedByNoneR() throws Exception {
        this.testReplaceUnindexedColWithIndexed(3, 300000000L, 0, true);
    }

    @Test
    public void testReplaceUnindexedWithIndexedByYear() throws Exception {
        this.testReplaceUnindexedColWithIndexed(2, 72000000000L, 2, false);
    }

    @Test
    public void testReplaceUnindexedWithIndexedByYearR() throws Exception {
        this.testReplaceUnindexedColWithIndexed(2, 72000000000L, 2, true);
    }

    @Test
    public void testRollbackSymbolIndexByDay() throws Exception {
        this.testSymbolIndexReadAfterRollback(0, 300000000L, 3);
    }

    @Test
    public void testRollbackSymbolIndexByMonth() throws Exception {
        this.testSymbolIndexReadAfterRollback(1, 7200000000L, 2);
    }

    @Test
    public void testRollbackSymbolIndexByNone() throws Exception {
        this.testSymbolIndexReadAfterRollback(3, 300000000L, 0);
    }

    @Test
    public void testRollbackSymbolIndexByYear() throws Exception {
        this.testSymbolIndexReadAfterRollback(2, 72000000000L, 2);
    }

    private void testRemoveFirstColumn(int partitionBy, long increment, int expectedPartitionMin) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 100;
            try (TableModel model = new TableModel(configuration, "x", partitionBy).col("a", 7).col("b", 8).indexed(true, 25).col("i", 3).col("c", 8).indexed(true, 25).timestamp();){
                CairoTestUtils.create(model);
            }
            Rnd rnd = new Rnd();
            String[] symbols = new String[100];
            int M = 1000;
            for (int i = 0; i < 100; ++i) {
                symbols[i] = rnd.nextChars(8).toString();
            }
            long timestamp = 0L;
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"x");){
                for (int i = 0; i < 1000; ++i) {
                    TableWriter.Row row = writer.newRow(timestamp += increment);
                    row.putStr(0, rnd.nextChars(20));
                    row.putSym(1, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                    row.putInt(2, rnd.nextInt());
                    row.putSym(3, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                    row.append();
                }
                writer.commit();
                try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                    TableReaderRecord record = new TableReaderRecord();
                    Assert.assertTrue((reader.getPartitionCount() > expectedPartitionMin ? 1 : 0) != 0);
                    FullFwdDataFrameCursor cursor = new FullFwdDataFrameCursor();
                    cursor.of(reader);
                    record.of(reader);
                    this.assertSymbolFoundInIndex(cursor, record, 1, 1000);
                    cursor.toTop();
                    this.assertSymbolFoundInIndex(cursor, record, 3, 1000);
                    writer.removeColumn((CharSequence)"a");
                    for (int i = 0; i < 1000; ++i) {
                        TableWriter.Row row = writer.newRow(timestamp += increment);
                        row.putSym(0, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                        row.putInt(1, rnd.nextInt());
                        row.putSym(2, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                        row.append();
                    }
                    writer.commit();
                    cursor.reload();
                    this.assertSymbolFoundInIndex(cursor, record, 0, 2000);
                    cursor.toTop();
                    this.assertSymbolFoundInIndex(cursor, record, 2, 2000);
                    cursor.toTop();
                    FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 0, 2000L);
                    cursor.toTop();
                    FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 2, 2000L);
                }
            }
        });
    }

    @Test
    public void testSymbolIndexReadByDay() throws Exception {
        this.testSymbolIndexRead(0, 300000000L, 3);
    }

    @Test
    public void testSymbolIndexReadByMonth() throws Exception {
        this.testSymbolIndexRead(1, 7200000000L, 2);
    }

    @Test
    public void testSymbolIndexReadByNone() throws Exception {
        this.testSymbolIndexRead(3, 300000000L, 0);
    }

    @Test
    public void testSymbolIndexReadByYear() throws Exception {
        this.testSymbolIndexRead(2, 72000000000L, 2);
    }

    static void assertIndexRowsMatchSymbol(DataFrameCursor cursor, TableReaderRecord record, int columnIndex, long expectedRowCount) {
        SymbolTable symbolTable = cursor.getSymbolTable(columnIndex);
        long rowCount = 0L;
        while (cursor.hasNext()) {
            DataFrame frame = (DataFrame)cursor.next();
            record.jumpTo(frame.getPartitionIndex(), frame.getRowLo());
            long limit = frame.getRowHi();
            BitmapIndexReader indexReader = frame.getBitmapIndexReader(columnIndex, 2);
            Assert.assertNotNull((Object)indexReader);
            int keyCount = indexReader.getKeyCount();
            for (int i = 0; i < keyCount; ++i) {
                RowCursor ic = indexReader.getCursor(true, i, 0L, limit - 1L);
                CharSequence expected = symbolTable.value(i - 1);
                while (ic.hasNext()) {
                    record.setRecordIndex(ic.next());
                    TestUtils.assertEquals(expected, record.getSym(columnIndex));
                    ++rowCount;
                }
            }
        }
        Assert.assertEquals((long)expectedRowCount, (long)rowCount);
    }

    private void assertData(FullFwdDataFrameCursor cursor, TableReaderRecord record, Rnd rnd, SymbolGroup sg, long expecteRowCount) {
        long rowCount = 0L;
        while (cursor.hasNext()) {
            long recordIndex;
            DataFrame frame = cursor.next();
            record.jumpTo(frame.getPartitionIndex(), frame.getRowLo());
            long limit = frame.getRowHi();
            while ((recordIndex = record.getRecordIndex()) < limit) {
                TestUtils.assertEquals((CharSequence)sg.symA[rnd.nextPositiveInt() % sg.S], record.getSym(0));
                TestUtils.assertEquals((CharSequence)sg.symB[rnd.nextPositiveInt() % sg.S], record.getSym(1));
                TestUtils.assertEquals((CharSequence)sg.symC[rnd.nextPositiveInt() % sg.S], record.getSym(2));
                Assert.assertEquals((double)rnd.nextDouble2(), (double)record.getDouble(3), (double)1.0E-7);
                record.setRecordIndex(recordIndex + 1L);
                ++rowCount;
            }
        }
        Assert.assertEquals((long)expecteRowCount, (long)rowCount);
    }

    private long assertIndex(TableReaderRecord record, int columnIndex, SymbolTable symbolTable, long count, DataFrame frame, int direction) {
        long recordIndex;
        BitmapIndexReader indexReader = frame.getBitmapIndexReader(columnIndex, direction);
        Assert.assertNotNull((Object)indexReader);
        long hi = frame.getRowHi();
        record.jumpTo(frame.getPartitionIndex(), frame.getRowLo());
        while ((recordIndex = record.getRecordIndex()) < hi) {
            CharSequence sym = record.getSym(columnIndex);
            boolean offsetFound = false;
            long target = record.getRecordIndex();
            RowCursor ic = indexReader.getCursor(true, TableUtils.toIndexKey((int)symbolTable.getQuick(sym)), frame.getRowLo(), hi - 1L);
            while (ic.hasNext()) {
                if (ic.next() != target) continue;
                offsetFound = true;
                break;
            }
            if (!offsetFound) {
                Assert.fail((String)("not found, target=" + target + ", sym=" + sym));
            }
            record.setRecordIndex(recordIndex + 1L);
            ++count;
        }
        return count;
    }

    private void assertMetadataEquals(RecordMetadata a, RecordMetadata b) {
        StringSink sinkA = new StringSink();
        StringSink sinkB = new StringSink();
        a.toJson((CharSink)sinkA);
        b.toJson((CharSink)sinkB);
        TestUtils.assertEquals((CharSequence)sinkA, (CharSequence)sinkB);
    }

    private void assertNoIndex(FullFwdDataFrameCursor cursor) {
        while (cursor.hasNext()) {
            DataFrame frame = cursor.next();
            try {
                frame.getBitmapIndexReader(4, 2);
                Assert.fail();
            }
            catch (CairoException e) {
                Assert.assertTrue((boolean)Chars.contains((CharSequence)e.getMessage(), (CharSequence)"Not indexed"));
            }
        }
    }

    private void assertSymbolFoundInIndex(FullFwdDataFrameCursor cursor, TableReaderRecord record, int columnIndex, int M) {
        SymbolTable symbolTable = cursor.getSymbolTable(columnIndex);
        long count = 0L;
        while (cursor.hasNext()) {
            DataFrame frame = cursor.next();
            count = this.assertIndex(record, columnIndex, symbolTable, count, frame, 2);
            count = this.assertIndex(record, columnIndex, symbolTable, count, frame, 1);
        }
        Assert.assertEquals((long)(M * 2), (long)count);
    }

    private long populateTable(TableWriter writer, String[] symbols, Rnd rnd, long ts, long increment) {
        long timestamp = ts;
        for (int i = 0; i < 1000; ++i) {
            TableWriter.Row row = writer.newRow(timestamp += increment);
            row.putSym(0, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
            row.append();
        }
        return timestamp;
    }

    private void testFailToRemoveDistressFile(int partitionBy, long increment) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            Throwable throwable;
            int N = 10000;
            int S = 512;
            Rnd rnd = new Rnd();
            Rnd eRnd = new Rnd();
            final TestFilesFacade ff = new TestFilesFacade(){
                boolean invoked = false;

                @Override
                public boolean wasCalled() {
                    return this.invoked;
                }

                public boolean remove(LPSZ name) {
                    if (Chars.endsWith((CharSequence)name, (CharSequence)".lock")) {
                        this.invoked = true;
                        return false;
                    }
                    return super.remove(name);
                }
            };
            DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

                public FilesFacade getFilesFacade() {
                    return ff;
                }
            };
            SymbolGroup sg = new SymbolGroup(rnd, S, N, partitionBy, false);
            eRnd.syncWith(rnd);
            long timestamp = 0L;
            try {
                throwable = null;
                try (TableWriter writer = new TableWriter((CairoConfiguration)configuration, (CharSequence)"ABC");){
                    int i = 0;
                    while ((long)i < (long)N) {
                        TableWriter.Row r = writer.newRow(timestamp += increment);
                        r.putSym(0, (CharSequence)sg.symA[rnd.nextPositiveInt() % sg.S]);
                        r.putSym(1, (CharSequence)sg.symB[rnd.nextPositiveInt() % sg.S]);
                        r.putSym(2, (CharSequence)sg.symC[rnd.nextPositiveInt() % sg.S]);
                        r.putDouble(3, rnd.nextDouble2());
                        r.append();
                        ++i;
                    }
                    writer.commit();
                }
                catch (Throwable i) {
                    throwable = i;
                    throw i;
                }
            }
            catch (CairoException e) {
                TestUtils.assertContains(e.getMessage(), "remove");
            }
            new TableWriter(AbstractCairoTest.configuration, (CharSequence)"ABC").close();
            Assert.assertTrue((boolean)ff.wasCalled());
            throwable = null;
            try (TableReader reader = new TableReader(AbstractCairoTest.configuration, (CharSequence)"ABC");){
                FullFwdDataFrameCursor cursor = new FullFwdDataFrameCursor();
                TableReaderRecord record = new TableReaderRecord();
                cursor.of(reader);
                record.of(reader);
                this.assertSymbolFoundInIndex(cursor, record, 0, N);
                cursor.toTop();
                this.assertSymbolFoundInIndex(cursor, record, 1, N);
                cursor.toTop();
                this.assertSymbolFoundInIndex(cursor, record, 2, N);
                cursor.toTop();
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 0, N);
                cursor.toTop();
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 1, N);
                cursor.toTop();
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 2, N);
                cursor.toTop();
                this.assertData(cursor, record, eRnd, sg, N);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        });
    }

    private void testIndexFailureAtRuntime(int partitionBy, long increment, boolean empty, final String fileUnderAttack, int expectedPartitionCount) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 10000;
            int S = 512;
            Rnd rnd = new Rnd();
            Rnd eRnd = new Rnd();
            FilesFacadeImpl ff = new FilesFacadeImpl(){
                private long fd = -1L;
                private int mapCount = 0;

                public long getMapPageSize() {
                    return 65535L;
                }

                public long mmap(long fd, long len, long offset, int mode) {
                    if (fd == this.fd) {
                        if (this.mapCount == 1) {
                            return -1L;
                        }
                        ++this.mapCount;
                    }
                    return super.mmap(fd, len, offset, mode);
                }

                public long openRW(LPSZ name) {
                    if (Chars.endsWith((CharSequence)name, (CharSequence)fileUnderAttack)) {
                        this.fd = super.openRW(name);
                        return this.fd;
                    }
                    return super.openRW(name);
                }
            };
            DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root, (FilesFacade)ff){
                final /* synthetic */ FilesFacade val$ff;
                {
                    this.val$ff = filesFacade;
                    super(x0);
                }

                public FilesFacade getFilesFacade() {
                    return this.val$ff;
                }
            };
            SymbolGroup sg = new SymbolGroup(rnd, S, N, partitionBy, false);
            eRnd.syncWith(rnd);
            long timestamp = 0L;
            if (!empty) {
                timestamp = sg.appendABC(AbstractCairoTest.configuration, rnd, N, timestamp, increment);
            }
            try (TableWriter writer = new TableWriter((CairoConfiguration)configuration, (CharSequence)"ABC");){
                try {
                    int i = 0;
                    while ((long)i < (long)N) {
                        TableWriter.Row r = writer.newRow(timestamp += increment);
                        r.putSym(0, (CharSequence)sg.symA[rnd.nextPositiveInt() % sg.S]);
                        r.putSym(1, (CharSequence)sg.symB[rnd.nextPositiveInt() % sg.S]);
                        r.putSym(2, (CharSequence)sg.symC[rnd.nextPositiveInt() % sg.S]);
                        r.putDouble(3, rnd.nextDouble2());
                        r.append();
                        ++i;
                    }
                    writer.commit();
                    Assert.fail();
                }
                catch (CairoError i) {
                    // empty catch block
                }
                try {
                    writer.commit();
                    Assert.fail();
                }
                catch (CairoError e) {
                    TestUtils.assertContains(e.getMessage(), "distressed");
                }
                try {
                    writer.rollback();
                    Assert.fail();
                }
                catch (CairoError e) {
                    TestUtils.assertContains(e.getMessage(), "distressed");
                }
            }
            if (empty && partitionBy == 3) {
                try {
                    new TableWriter((CairoConfiguration)configuration, (CharSequence)"ABC");
                    Assert.fail();
                }
                catch (CairoException writer) {
                    // empty catch block
                }
            }
            var17_16 = null;
            try (TableReader reader = new TableReader(AbstractCairoTest.configuration, (CharSequence)"ABC");){
                FullFwdDataFrameCursor cursor = new FullFwdDataFrameCursor();
                TableReaderRecord record = new TableReaderRecord();
                Assert.assertEquals((long)expectedPartitionCount, (long)reader.getPartitionCount());
                cursor.of(reader);
                record.of(reader);
                this.assertSymbolFoundInIndex(cursor, record, 0, empty ? 0 : N);
                cursor.toTop();
                this.assertSymbolFoundInIndex(cursor, record, 1, empty ? 0 : N);
                cursor.toTop();
                this.assertSymbolFoundInIndex(cursor, record, 2, empty ? 0 : N);
                cursor.toTop();
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 0, empty ? 0L : (long)N);
                cursor.toTop();
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 1, empty ? 0L : (long)N);
                cursor.toTop();
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 2, empty ? 0L : (long)N);
                cursor.toTop();
                this.assertData(cursor, record, eRnd, sg, empty ? 0L : (long)N);
                sg.appendABC(AbstractCairoTest.configuration, rnd, N, timestamp, increment);
                Assert.assertTrue((boolean)cursor.reload());
                this.assertSymbolFoundInIndex(cursor, record, 0, empty ? N : N * 2);
                cursor.toTop();
                this.assertSymbolFoundInIndex(cursor, record, 1, empty ? N : N * 2);
                cursor.toTop();
                this.assertSymbolFoundInIndex(cursor, record, 2, empty ? N : N * 2);
                cursor.toTop();
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 0, empty ? (long)N : (long)(N * 2));
                cursor.toTop();
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 1, empty ? (long)N : (long)(N * 2));
                cursor.toTop();
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 2, empty ? (long)N : (long)(N * 2));
            }
            catch (Throwable throwable) {
                var17_16 = throwable;
                throw throwable;
            }
        });
    }

    private void testIndexFailureInConstructor(int partitionBy, long increment, boolean empty, final String fileUnderAttack) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 10000;
            int S = 512;
            Rnd rnd = new Rnd();
            FilesFacadeImpl ff = new FilesFacadeImpl(){
                private long fd = -1L;

                public long getMapPageSize() {
                    return 65535L;
                }

                public long mmap(long fd, long len, long offset, int mode) {
                    if (fd == this.fd) {
                        return -1L;
                    }
                    return super.mmap(fd, len, offset, mode);
                }

                public long openRW(LPSZ name) {
                    if (Chars.endsWith((CharSequence)name, (CharSequence)fileUnderAttack)) {
                        this.fd = super.openRW(name);
                        return this.fd;
                    }
                    return super.openRW(name);
                }

                public boolean remove(LPSZ name) {
                    return !Chars.endsWith((CharSequence)name, (CharSequence)fileUnderAttack) && super.remove(name);
                }
            };
            DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root, (FilesFacade)ff){
                final /* synthetic */ FilesFacade val$ff;
                {
                    this.val$ff = filesFacade;
                    super(x0);
                }

                public FilesFacade getFilesFacade() {
                    return this.val$ff;
                }
            };
            SymbolGroup sg = new SymbolGroup(rnd, S, N, partitionBy, false);
            long timestamp = 0L;
            if (!empty) {
                timestamp = sg.appendABC(AbstractCairoTest.configuration, rnd, N, timestamp, increment);
            }
            try {
                new TableWriter((CairoConfiguration)configuration, (CharSequence)"ABC");
                Assert.fail();
            }
            catch (CairoException cairoException) {
                // empty catch block
            }
            sg.appendABC(AbstractCairoTest.configuration, rnd, N, timestamp, increment);
        });
    }

    private void testParallelIndex(int partitionBy, long increment, int expectedPartitionMin, int testWorkStealing) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            MPSequence pubSeq;
            int N = 1000000;
            int S = 128;
            Rnd rnd = new Rnd();
            SymbolGroup sg = new SymbolGroup(rnd, S, N, partitionBy, false);
            MCSequence subSeq = null;
            switch (testWorkStealing) {
                case 2: {
                    pubSeq = new MPSequence(1024){

                        public long next() {
                            return -1L;
                        }
                    };
                    break;
                }
                case 3: {
                    pubSeq = new MPSequence(1024){
                        private boolean flap;
                        {
                            this.flap = false;
                        }

                        public long next() {
                            boolean flap = this.flap;
                            this.flap = !this.flap;
                            return flap ? -1L : -2L;
                        }
                    };
                    break;
                }
                case 0: {
                    pubSeq = new MPSequence(1024);
                    subSeq = new MCSequence(1024);
                    break;
                }
                case 4: {
                    pubSeq = new MPSequence(1024){
                        private boolean flap;
                        {
                            this.flap = true;
                        }

                        public long next() {
                            boolean flap = this.flap;
                            this.flap = !this.flap;
                            return flap ? -2L : super.next();
                        }
                    };
                    subSeq = new MCSequence(1024);
                    break;
                }
                case 1: {
                    pubSeq = new MPSequence(1024);
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported test");
                }
            }
            DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

                public int getParallelIndexThreshold() {
                    return 1;
                }
            };
            MyWorkScheduler workScheduler = new MyWorkScheduler((Sequence)pubSeq, (Sequence)subSeq);
            if (subSeq != null) {
                workScheduler.addJob((Job)new ColumnIndexerJob((CairoWorkScheduler)workScheduler));
                workScheduler.start();
            }
            long timestamp = 0L;
            try (TableWriter writer = new TableWriter((CairoConfiguration)configuration, (CharSequence)"ABC", (CairoWorkScheduler)workScheduler);){
                for (int i = 0; i < N; ++i) {
                    TableWriter.Row r = writer.newRow(timestamp += increment);
                    r.putSym(0, (CharSequence)sg.symA[rnd.nextPositiveInt() % S]);
                    r.putSym(1, (CharSequence)sg.symB[rnd.nextPositiveInt() % S]);
                    r.putSym(2, (CharSequence)sg.symC[rnd.nextPositiveInt() % S]);
                    r.putDouble(3, rnd.nextDouble2());
                    r.append();
                }
                writer.commit();
            }
            workScheduler.halt();
            var17_15 = null;
            try (TableReader reader = new TableReader((CairoConfiguration)configuration, (CharSequence)"ABC");){
                Assert.assertTrue((reader.getPartitionCount() > expectedPartitionMin ? 1 : 0) != 0);
                FullFwdDataFrameCursor cursor = new FullFwdDataFrameCursor();
                TableReaderRecord record = new TableReaderRecord();
                cursor.of(reader);
                record.of(reader);
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 0, N);
                cursor.toTop();
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 1, N);
                cursor.toTop();
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 2, N);
            }
            catch (Throwable throwable) {
                var17_15 = throwable;
                throw throwable;
            }
        });
    }

    private void testParallelIndexFailureAtRuntime(int partitionBy, long increment, boolean empty, final String fileUnderAttack, int expectedPartitionCount) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 10000;
            int S = 512;
            Rnd rnd = new Rnd();
            Rnd eRnd = new Rnd();
            FilesFacadeImpl ff = new FilesFacadeImpl(){
                private long fd = -1L;
                private int mapCount = 0;

                public long getMapPageSize() {
                    return 65535L;
                }

                public long mmap(long fd, long len, long offset, int mode) {
                    if (fd == this.fd) {
                        if (this.mapCount == 1) {
                            return -1L;
                        }
                        ++this.mapCount;
                    }
                    return super.mmap(fd, len, offset, mode);
                }

                public long openRW(LPSZ name) {
                    if (Chars.endsWith((CharSequence)name, (CharSequence)fileUnderAttack)) {
                        this.fd = super.openRW(name);
                        return this.fd;
                    }
                    return super.openRW(name);
                }
            };
            DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root, (FilesFacade)ff){
                final /* synthetic */ FilesFacade val$ff;
                {
                    this.val$ff = filesFacade;
                    super(x0);
                }

                public FilesFacade getFilesFacade() {
                    return this.val$ff;
                }

                public int getParallelIndexThreshold() {
                    return 1;
                }
            };
            SymbolGroup sg = new SymbolGroup(rnd, S, N, partitionBy, false);
            eRnd.syncWith(rnd);
            long timestamp = 0L;
            if (!empty) {
                timestamp = sg.appendABC(AbstractCairoTest.configuration, rnd, N, timestamp, increment);
            }
            MyWorkScheduler workScheduler = new MyWorkScheduler();
            workScheduler.addJob((Job)new ColumnIndexerJob((CairoWorkScheduler)workScheduler));
            workScheduler.start();
            try (TableWriter writer = new TableWriter((CairoConfiguration)configuration, (CharSequence)"ABC", (CairoWorkScheduler)workScheduler);){
                try {
                    int i = 0;
                    while ((long)i < (long)N) {
                        TableWriter.Row r = writer.newRow(timestamp += increment);
                        r.putSym(0, (CharSequence)sg.symA[rnd.nextPositiveInt() % sg.S]);
                        r.putSym(1, (CharSequence)sg.symB[rnd.nextPositiveInt() % sg.S]);
                        r.putSym(2, (CharSequence)sg.symC[rnd.nextPositiveInt() % sg.S]);
                        r.putDouble(3, rnd.nextDouble2());
                        r.append();
                        ++i;
                    }
                    writer.commit();
                    Assert.fail();
                }
                catch (CairoError i) {
                    // empty catch block
                }
                try {
                    writer.commit();
                    Assert.fail();
                }
                catch (CairoError e) {
                    TestUtils.assertContains(e.getMessage(), "distressed");
                }
                try {
                    writer.rollback();
                    Assert.fail();
                }
                catch (CairoError e) {
                    TestUtils.assertContains(e.getMessage(), "distressed");
                }
            }
            if (empty && partitionBy == 3) {
                try {
                    new TableWriter((CairoConfiguration)configuration, (CharSequence)"ABC");
                    Assert.fail();
                }
                catch (CairoException writer) {
                    // empty catch block
                }
            }
            workScheduler.halt();
            var18_17 = null;
            try (TableReader reader = new TableReader(AbstractCairoTest.configuration, (CharSequence)"ABC");){
                FullFwdDataFrameCursor cursor = new FullFwdDataFrameCursor();
                TableReaderRecord record = new TableReaderRecord();
                Assert.assertEquals((long)expectedPartitionCount, (long)reader.getPartitionCount());
                cursor.of(reader);
                record.of(reader);
                this.assertSymbolFoundInIndex(cursor, record, 0, empty ? 0 : N);
                cursor.toTop();
                this.assertSymbolFoundInIndex(cursor, record, 1, empty ? 0 : N);
                cursor.toTop();
                this.assertSymbolFoundInIndex(cursor, record, 2, empty ? 0 : N);
                cursor.toTop();
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 0, empty ? 0L : (long)N);
                cursor.toTop();
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 1, empty ? 0L : (long)N);
                cursor.toTop();
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 2, empty ? 0L : (long)N);
                cursor.toTop();
                this.assertData(cursor, record, eRnd, sg, empty ? 0L : (long)N);
                this.assertMetadataEquals(reader.getMetadata(), cursor.getTableReader().getMetadata());
                sg.appendABC(AbstractCairoTest.configuration, rnd, N, timestamp, increment);
                Assert.assertTrue((boolean)cursor.reload());
                this.assertSymbolFoundInIndex(cursor, record, 0, empty ? N : N * 2);
                cursor.toTop();
                this.assertSymbolFoundInIndex(cursor, record, 1, empty ? N : N * 2);
                cursor.toTop();
                this.assertSymbolFoundInIndex(cursor, record, 2, empty ? N : N * 2);
                cursor.toTop();
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 0, empty ? (long)N : (long)(N * 2));
                cursor.toTop();
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 1, empty ? (long)N : (long)(N * 2));
                cursor.toTop();
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 2, empty ? (long)N : (long)(N * 2));
            }
            catch (Throwable throwable) {
                var18_17 = throwable;
                throw throwable;
            }
        });
    }

    private void testRemoveLastColumn(int partitionBy, long increment, int expectedPartitionMin) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 100;
            try (TableModel model = new TableModel(configuration, "x", partitionBy).col("a", 7).col("b", 8).indexed(true, 25).col("i", 3).indexed(false, 0).col("c", 8).indexed(true, 25).timestamp();){
                CairoTestUtils.create(model);
            }
            Rnd rnd = new Rnd();
            String[] symbols = new String[100];
            int M = 1000;
            for (int i = 0; i < 100; ++i) {
                symbols[i] = rnd.nextChars(8).toString();
            }
            long timestamp = 0L;
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"x");){
                for (int i = 0; i < 1000; ++i) {
                    TableWriter.Row row = writer.newRow(timestamp += increment);
                    row.putStr(0, rnd.nextChars(20));
                    row.putSym(1, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                    row.putInt(2, rnd.nextInt());
                    row.putSym(3, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                    row.append();
                }
                writer.commit();
                try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                    FullFwdDataFrameCursor cursor = new FullFwdDataFrameCursor();
                    TableReaderRecord record = new TableReaderRecord();
                    Assert.assertTrue((reader.getPartitionCount() > expectedPartitionMin ? 1 : 0) != 0);
                    cursor.of(reader);
                    record.of(reader);
                    this.assertSymbolFoundInIndex(cursor, record, 1, 1000);
                    cursor.toTop();
                    this.assertSymbolFoundInIndex(cursor, record, 3, 1000);
                    writer.removeColumn((CharSequence)"c");
                    for (int i = 0; i < 1000; ++i) {
                        TableWriter.Row row = writer.newRow(timestamp += increment);
                        row.putStr(0, rnd.nextChars(20));
                        row.putSym(1, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                        row.putInt(2, rnd.nextInt());
                        row.append();
                    }
                    writer.commit();
                    cursor.reload();
                    this.assertSymbolFoundInIndex(cursor, record, 1, 2000);
                    cursor.toTop();
                    FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 1, 2000L);
                }
            }
        });
    }

    private void testRemoveMidColumn(int partitionBy, long increment, int expectedPartitionMin) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 100;
            try (TableModel model = new TableModel(configuration, "x", partitionBy).col("a", 7).col("b", 8).indexed(true, 25).col("i", 3).col("c", 8).indexed(true, 25).timestamp();){
                CairoTestUtils.create(model);
            }
            Rnd rnd = new Rnd();
            String[] symbols = new String[100];
            int M = 1000;
            for (int i = 0; i < 100; ++i) {
                symbols[i] = rnd.nextChars(8).toString();
            }
            long timestamp = 0L;
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"x");){
                for (int i = 0; i < 1000; ++i) {
                    TableWriter.Row row = writer.newRow(timestamp += increment);
                    row.putStr(0, rnd.nextChars(20));
                    row.putSym(1, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                    row.putInt(2, rnd.nextInt());
                    row.putSym(3, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                    row.append();
                }
                writer.commit();
                try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                    FullFwdDataFrameCursor cursor = new FullFwdDataFrameCursor();
                    TableReaderRecord record = new TableReaderRecord();
                    Assert.assertTrue((reader.getPartitionCount() > expectedPartitionMin ? 1 : 0) != 0);
                    cursor.of(reader);
                    record.of(reader);
                    this.assertSymbolFoundInIndex(cursor, record, 1, 1000);
                    cursor.toTop();
                    this.assertSymbolFoundInIndex(cursor, record, 3, 1000);
                    writer.removeColumn((CharSequence)"i");
                    for (int i = 0; i < 1000; ++i) {
                        TableWriter.Row row = writer.newRow(timestamp += increment);
                        row.putStr(0, rnd.nextChars(20));
                        row.putSym(1, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                        row.putSym(2, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                        row.append();
                    }
                    writer.commit();
                    cursor.reload();
                    this.assertSymbolFoundInIndex(cursor, record, 1, 2000);
                    cursor.toTop();
                    this.assertSymbolFoundInIndex(cursor, record, 2, 2000);
                    cursor.toTop();
                    FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 1, 2000L);
                    cursor.toTop();
                    FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 2, 2000L);
                }
            }
        });
    }

    private void testReplaceIndexedColWithIndexed(int partitionBy, long increment, int expectedPartitionMin, boolean testRestricted) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int M = 1000;
            int N = 100;
            try (TableModel model = new TableModel(configuration, "x", partitionBy).col("a", 7).col("b", 8).indexed(true, 25).col("i", 3).timestamp().col("c", 8).indexed(true, 25);){
                CairoTestUtils.create(model);
            }
            Rnd rnd = new Rnd();
            String[] symbols = new String[100];
            for (int i = 0; i < 100; ++i) {
                symbols[i] = rnd.nextChars(8).toString();
            }
            long timestamp = 0L;
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"x");){
                for (int i = 0; i < 1000; ++i) {
                    TableWriter.Row row = writer.newRow(timestamp += increment);
                    row.putStr(0, rnd.nextChars(20));
                    row.putSym(1, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                    row.putInt(2, rnd.nextInt());
                    row.putSym(4, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                    row.append();
                }
                writer.commit();
                try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                    FullFwdDataFrameCursor cursor = new FullFwdDataFrameCursor();
                    TableReaderRecord record = new TableReaderRecord();
                    Assert.assertTrue((reader.getPartitionCount() > expectedPartitionMin ? 1 : 0) != 0);
                    cursor.of(reader);
                    record.of(reader);
                    this.assertSymbolFoundInIndex(cursor, record, 1, 1000);
                    cursor.toTop();
                    this.assertSymbolFoundInIndex(cursor, record, 4, 1000);
                    if (testRestricted || configuration.getFilesFacade().isRestrictedFileSystem()) {
                        reader.closeColumnForRemove((CharSequence)"c");
                    }
                    writer.removeColumn((CharSequence)"c");
                    writer.addColumn((CharSequence)"c", 8, Numbers.ceilPow2((int)100), true, true, 8);
                    for (int i = 0; i < 1000; ++i) {
                        TableWriter.Row row = writer.newRow(timestamp += increment);
                        row.putStr(0, rnd.nextChars(20));
                        row.putSym(1, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                        row.putInt(2, rnd.nextInt());
                        row.putSym(4, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                        row.append();
                    }
                    writer.commit();
                    Assert.assertTrue((boolean)reader.reload());
                    cursor.reload();
                    this.assertSymbolFoundInIndex(cursor, record, 1, 2000);
                    cursor.toTop();
                    this.assertSymbolFoundInIndex(cursor, record, 4, 2000);
                }
            }
        });
    }

    private void testReplaceIndexedColWithIndexedWithTruncate(int partitionBy, long increment, int expectedPartitionMin, boolean testRestricted) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int M = 1000;
            int N = 100;
            try (TableModel model = new TableModel(configuration, "x", partitionBy).col("a", 7).col("b", 8).indexed(true, 25).col("i", 3).timestamp();){
                CairoTestUtils.create(model);
            }
            Rnd rnd = new Rnd();
            String[] symbols = new String[100];
            for (int i = 0; i < 100; ++i) {
                symbols[i] = rnd.nextChars(8).toString();
            }
            long timestamp = 0L;
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"x");){
                for (int i = 0; i < 1000; ++i) {
                    TableWriter.Row row = writer.newRow(timestamp += increment);
                    row.putStr(0, rnd.nextChars(20));
                    row.putSym(1, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                    row.putInt(2, rnd.nextInt());
                    row.append();
                }
                writer.commit();
                try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                    writer.truncate();
                    writer.addColumn((CharSequence)"c", 8, Numbers.ceilPow2((int)100), true, true, Numbers.ceilPow2((int)25));
                    Assert.assertTrue((boolean)reader.reload());
                    rnd.reset();
                    for (int i = 0; i < 1000; ++i) {
                        TableWriter.Row row = writer.newRow(timestamp += increment);
                        row.putStr(0, rnd.nextChars(20));
                        row.putSym(1, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                        row.putInt(2, rnd.nextInt());
                        row.putSym(4, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                        row.append();
                    }
                    writer.commit();
                    Assert.assertTrue((boolean)reader.reload());
                    FullFwdDataFrameCursor cursor = new FullFwdDataFrameCursor();
                    TableReaderRecord record = new TableReaderRecord();
                    Assert.assertTrue((reader.getPartitionCount() > expectedPartitionMin ? 1 : 0) != 0);
                    cursor.of(reader);
                    record.of(reader);
                    this.assertSymbolFoundInIndex(cursor, record, 1, 1000);
                    cursor.toTop();
                    this.assertSymbolFoundInIndex(cursor, record, 4, 1000);
                    if (testRestricted || configuration.getFilesFacade().isRestrictedFileSystem()) {
                        reader.closeColumnForRemove((CharSequence)"c");
                    }
                    writer.removeColumn((CharSequence)"c");
                    writer.addColumn((CharSequence)"c", 8, Numbers.ceilPow2((int)100), true, true, 8);
                    for (int i = 0; i < 1000; ++i) {
                        TableWriter.Row row = writer.newRow(timestamp += increment);
                        row.putStr(0, rnd.nextChars(20));
                        row.putSym(1, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                        row.putInt(2, rnd.nextInt());
                        row.putSym(4, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                        row.append();
                    }
                    writer.commit();
                    Assert.assertTrue((boolean)reader.reload());
                    cursor.reload();
                    this.assertSymbolFoundInIndex(cursor, record, 1, 2000);
                    cursor.toTop();
                    this.assertSymbolFoundInIndex(cursor, record, 4, 2000);
                }
            }
        });
    }

    private void testReplaceIndexedColWithUnindexed(int partitionBy, long increment, int expectedPartitionMin, boolean testRestricted) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int M = 1000;
            int N = 100;
            try (TableModel model = new TableModel(configuration, "x", partitionBy).col("a", 7).col("b", 8).indexed(true, 25).col("i", 3).timestamp().col("c", 8).indexed(true, 25);){
                CairoTestUtils.create(model);
            }
            Rnd rnd = new Rnd();
            String[] symbols = new String[100];
            for (int i = 0; i < 100; ++i) {
                symbols[i] = rnd.nextChars(8).toString();
            }
            long timestamp = 0L;
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"x");){
                for (int i = 0; i < 1000; ++i) {
                    TableWriter.Row row = writer.newRow(timestamp += increment);
                    row.putStr(0, rnd.nextChars(20));
                    row.putSym(1, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                    row.putInt(2, rnd.nextInt());
                    row.putSym(4, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                    row.append();
                }
                writer.commit();
                try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                    FullFwdDataFrameCursor cursor = new FullFwdDataFrameCursor();
                    TableReaderRecord record = new TableReaderRecord();
                    Assert.assertTrue((reader.getPartitionCount() > expectedPartitionMin ? 1 : 0) != 0);
                    cursor.of(reader);
                    record.of(reader);
                    this.assertSymbolFoundInIndex(cursor, record, 1, 1000);
                    cursor.toTop();
                    this.assertSymbolFoundInIndex(cursor, record, 4, 1000);
                    if (testRestricted || configuration.getFilesFacade().isRestrictedFileSystem()) {
                        reader.closeColumnForRemove((CharSequence)"c");
                    }
                    writer.removeColumn((CharSequence)"c");
                    writer.addColumn((CharSequence)"c", 8);
                    for (int i = 0; i < 1000; ++i) {
                        TableWriter.Row row = writer.newRow(timestamp += increment);
                        row.putStr(0, rnd.nextChars(20));
                        row.putSym(1, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                        row.putInt(2, rnd.nextInt());
                        row.putSym(4, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                        row.append();
                    }
                    writer.commit();
                    Assert.assertTrue((boolean)reader.reload());
                    cursor.reload();
                    this.assertSymbolFoundInIndex(cursor, record, 1, 2000);
                    cursor.toTop();
                    this.assertNoIndex(cursor);
                }
            }
        });
    }

    private void testReplaceUnindexedColWithIndexed(int partitionBy, long increment, int expectedPartitionMin, boolean testRestricted) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int M = 1000;
            int N = 100;
            try (TableModel model = new TableModel(configuration, "x", partitionBy).col("a", 7).col("b", 8).indexed(true, 25).col("i", 3).timestamp().col("c", 8);){
                CairoTestUtils.create(model);
            }
            Rnd rnd = new Rnd();
            String[] symbols = new String[100];
            for (int i = 0; i < 100; ++i) {
                symbols[i] = rnd.nextChars(8).toString();
            }
            long timestamp = 0L;
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"x");){
                for (int i = 0; i < 1000; ++i) {
                    TableWriter.Row row = writer.newRow(timestamp += increment);
                    row.putStr(0, rnd.nextChars(20));
                    row.putSym(1, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                    row.putInt(2, rnd.nextInt());
                    row.putSym(4, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                    row.append();
                }
                writer.commit();
                try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                    FullFwdDataFrameCursor cursor = new FullFwdDataFrameCursor();
                    TableReaderRecord record = new TableReaderRecord();
                    Assert.assertTrue((reader.getPartitionCount() > expectedPartitionMin ? 1 : 0) != 0);
                    cursor.of(reader);
                    record.of(reader);
                    this.assertSymbolFoundInIndex(cursor, record, 1, 1000);
                    cursor.toTop();
                    this.assertNoIndex(cursor);
                    if (testRestricted || configuration.getFilesFacade().isRestrictedFileSystem()) {
                        reader.closeColumnForRemove((CharSequence)"c");
                    }
                    writer.removeColumn((CharSequence)"c");
                    writer.addColumn((CharSequence)"c", 8, Numbers.ceilPow2((int)100), true, true, 8);
                    for (int i = 0; i < 1000; ++i) {
                        TableWriter.Row row = writer.newRow(timestamp += increment);
                        row.putStr(0, rnd.nextChars(20));
                        row.putSym(1, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                        row.putInt(2, rnd.nextInt());
                        row.putSym(4, rnd.nextPositiveInt() % 16 == 0 ? null : symbols[rnd.nextPositiveInt() % 100]);
                        row.append();
                    }
                    writer.commit();
                    Assert.assertTrue((boolean)reader.reload());
                    cursor.reload();
                    this.assertSymbolFoundInIndex(cursor, record, 1, 2000);
                    cursor.toTop();
                    this.assertSymbolFoundInIndex(cursor, record, 4, 2000);
                    cursor.toTop();
                    FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 4, 2000L);
                }
            }
        });
    }

    private void testSymbolIndexRead(int partitionBy, long increment, int expectedPartitionMin) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 100;
            try (TableModel model = new TableModel(configuration, "x", partitionBy).col("a", 8).indexed(true, 25).timestamp();){
                CairoTestUtils.create(model);
            }
            Rnd rnd = new Rnd();
            String[] symbols = new String[100];
            int M = 1000;
            for (int i = 0; i < 100; ++i) {
                symbols[i] = rnd.nextChars(8).toString();
            }
            long timestamp = 0L;
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"x");){
                this.populateTable(writer, symbols, rnd, timestamp, increment);
                writer.commit();
            }
            var12_15 = null;
            try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                FullFwdDataFrameCursor cursor = new FullFwdDataFrameCursor();
                TableReaderRecord record = new TableReaderRecord();
                Assert.assertTrue((reader.getPartitionCount() > expectedPartitionMin ? 1 : 0) != 0);
                cursor.of(reader);
                record.of(reader);
                this.assertSymbolFoundInIndex(cursor, record, 0, 1000);
                cursor.toTop();
                this.assertSymbolFoundInIndex(cursor, record, 0, 1000);
                cursor.toTop();
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 0, 1000L);
            }
            catch (Throwable throwable) {
                var12_15 = throwable;
                throw throwable;
            }
        });
    }

    private void testSymbolIndexReadAfterRollback(int partitionBy, long increment, int expectedPartitionMin) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 100;
            try (TableModel model = new TableModel(configuration, "x", partitionBy).col("a", 8).indexed(true, 25).timestamp();){
                CairoTestUtils.create(model);
            }
            Rnd rnd = new Rnd();
            String[] symbols = new String[100];
            int M = 1000;
            for (int i = 0; i < 100; ++i) {
                symbols[i] = rnd.nextChars(8).toString();
            }
            long timestamp = 0L;
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"x");){
                timestamp = this.populateTable(writer, symbols, rnd, timestamp, increment);
                writer.commit();
                timestamp = this.populateTable(writer, symbols, rnd, timestamp, increment);
                writer.rollback();
                this.populateTable(writer, symbols, rnd, timestamp, increment);
                writer.commit();
            }
            var12_15 = null;
            try (TableReader reader = new TableReader(configuration, (CharSequence)"x");){
                FullFwdDataFrameCursor cursor = new FullFwdDataFrameCursor();
                TableReaderRecord record = new TableReaderRecord();
                Assert.assertTrue((reader.getPartitionCount() > expectedPartitionMin ? 1 : 0) != 0);
                cursor.of(reader);
                record.of(reader);
                this.assertSymbolFoundInIndex(cursor, record, 0, 2000);
                cursor.toTop();
                this.assertSymbolFoundInIndex(cursor, record, 0, 2000);
                cursor.toTop();
                FullFwdDataFrameCursorTest.assertIndexRowsMatchSymbol((DataFrameCursor)cursor, record, 0, 2000L);
            }
            catch (Throwable throwable) {
                var12_15 = throwable;
                throw throwable;
            }
        });
    }

    static final class MyWorkScheduler
    implements CairoWorkScheduler {
        private final int nWorkers = 2;
        private final CountDownLatch workerHaltLatch = new CountDownLatch(2);
        private final Worker[] workers = new Worker[2];
        private final RingQueue<ColumnIndexerEntry> queue = new RingQueue(ColumnIndexerEntry::new, 1024);
        private final Sequence pubSeq;
        private final Sequence subSeq;
        private final ObjHashSet<Job> jobs = new ObjHashSet();
        private boolean active = false;

        public MyWorkScheduler(Sequence pubSequence, Sequence subSequence) {
            this.pubSeq = pubSequence;
            this.subSeq = subSequence;
        }

        public MyWorkScheduler() {
            this((Sequence)new MPSequence(1024), (Sequence)new MCSequence(1024));
        }

        public void addJob(Job job) {
            this.jobs.add((Object)job);
        }

        public Sequence getIndexerPubSequence() {
            return this.pubSeq;
        }

        public RingQueue<ColumnIndexerEntry> getIndexerQueue() {
            return this.queue;
        }

        public Sequence getIndexerSubSequence() {
            return this.subSeq;
        }

        void halt() throws InterruptedException {
            if (this.active) {
                for (int i = 0; i < 2; ++i) {
                    this.workers[i].halt();
                }
                this.workerHaltLatch.await();
            }
        }

        void start() {
            this.pubSeq.then((Barrier)this.subSeq).then((Barrier)this.pubSeq);
            for (int i = 0; i < 2; ++i) {
                this.workers[i] = new Worker(this.jobs, this.workerHaltLatch);
                this.workers[i].start();
            }
            this.active = true;
        }
    }

    private static class SymbolGroup {
        final String[] symA;
        final String[] symB;
        final String[] symC;
        final int S;

        public SymbolGroup(Rnd rnd, int S, int N, int partitionBy, boolean useDefaultBlockSize) {
            this.S = S;
            this.symA = new String[S];
            this.symB = new String[S];
            this.symC = new String[S];
            for (int i = 0; i < S; ++i) {
                this.symA[i] = rnd.nextChars(10).toString();
                this.symB[i] = rnd.nextChars(8).toString();
                this.symC[i] = rnd.nextChars(10).toString();
            }
            int indexBlockSize = useDefaultBlockSize ? AbstractCairoTest.configuration.getIndexValueBlockSize() : N / S;
            try (TableModel model = new TableModel(AbstractCairoTest.configuration, "ABC", partitionBy).col("a", 8).indexed(true, indexBlockSize).col("b", 8).indexed(true, indexBlockSize).col("c", 8).indexed(true, indexBlockSize).col("d", 6).timestamp();){
                CairoTestUtils.create(model);
            }
        }

        long appendABC(CairoConfiguration configuration, Rnd rnd, long N, long timestamp, long increment) {
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"ABC");){
                int i = 0;
                while ((long)i < N) {
                    TableWriter.Row r = writer.newRow(timestamp += increment);
                    r.putSym(0, (CharSequence)this.symA[rnd.nextPositiveInt() % this.S]);
                    r.putSym(1, (CharSequence)this.symB[rnd.nextPositiveInt() % this.S]);
                    r.putSym(2, (CharSequence)this.symC[rnd.nextPositiveInt() % this.S]);
                    r.putDouble(3, rnd.nextDouble2());
                    r.append();
                    ++i;
                }
                writer.commit();
            }
            return timestamp;
        }
    }
}

