/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.Engine;
import com.questdb.cairo.FullFwdDataFrameCursorFactory;
import com.questdb.cairo.ReaderOutOfDateException;
import com.questdb.cairo.TableModel;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.sql.CairoEngine;
import com.questdb.cairo.sql.DataFrame;
import com.questdb.cairo.sql.DataFrameCursor;
import com.questdb.std.Rnd;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class FullFwdDataFrameCursorFactoryTest
extends AbstractCairoTest {
    @Test
    public void testFactory() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int N = 100;
            try (TableModel model = new TableModel(configuration, "x", 0).col("a", 7).col("b", 8).indexed(true, 25).col("i", 3).col("c", 8).indexed(true, 25).timestamp();){
                CairoTestUtils.create(model);
            }
            Rnd rnd = new Rnd();
            String[] symbols = new String[100];
            int M = 1000;
            long increment = 600000000L;
            for (int i = 0; i < 100; ++i) {
                symbols[i] = rnd.nextChars(8).toString();
            }
            long timestamp = 0L;
            try (TableWriter writer = new TableWriter(configuration, (CharSequence)"x");){
                for (int i = 0; i < 1000; ++i) {
                    TableWriter.Row row = writer.newRow(timestamp += 600000000L);
                    row.putStr(0, rnd.nextChars(20));
                    row.putSym(1, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                    row.putInt(2, rnd.nextInt());
                    row.putSym(3, (CharSequence)symbols[rnd.nextPositiveInt() % 100]);
                    row.append();
                }
                writer.commit();
            }
            var9_12 = null;
            try (Engine engine = new Engine(configuration);){
                FullFwdDataFrameCursorFactory factory = new FullFwdDataFrameCursorFactory((CairoEngine)engine, "x", 0L);
                long count = 0L;
                try (DataFrameCursor cursor = factory.getCursor();){
                    while (cursor.hasNext()) {
                        DataFrame frame = (DataFrame)cursor.next();
                        count += frame.getRowHi() - frame.getRowLo();
                    }
                }
                Assert.assertEquals((long)0L, (long)engine.getBusyReaderCount());
                Assert.assertEquals((long)1000L, (long)count);
                var14_25 = null;
                try (TableWriter writer = engine.getWriter((CharSequence)"x");){
                    writer.removeColumn((CharSequence)"b");
                }
                catch (Throwable throwable) {
                    var14_25 = throwable;
                    throw throwable;
                }
                try {
                    factory.getCursor();
                    Assert.fail();
                }
                catch (ReaderOutOfDateException readerOutOfDateException) {
                    // empty catch block
                }
            }
            catch (Throwable throwable) {
                var9_12 = throwable;
                throw throwable;
            }
        });
    }
}

