/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.Engine;
import com.questdb.cairo.FullBwdDataFrameCursorFactory;
import com.questdb.cairo.ReaderOutOfDateException;
import com.questdb.cairo.TableModel;
import com.questdb.cairo.TableReaderRecord;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.sql.CairoEngine;
import com.questdb.cairo.sql.DataFrame;
import com.questdb.cairo.sql.DataFrameCursor;
import com.questdb.cairo.sql.Record;
import com.questdb.std.Rnd;
import com.questdb.std.microtime.DateFormatUtils;
import com.questdb.test.tools.TestUtils;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;

public class FullBwdDataFrameCursorTest
extends AbstractCairoTest {
    @Test
    public void testReload() throws Exception {
        String expected = "-409854405\t339631474\t1970-01-04T00:00:00.000000Z\n1569490116\t1573662097\t1970-01-03T16:00:00.000000Z\n806715481\t1545253512\t1970-01-03T08:00:00.000000Z\n-1436881714\t-1575378703\t1970-01-03T00:00:00.000000Z\n-1191262516\t-2041844972\t1970-01-02T16:00:00.000000Z\n1868723706\t-847531048\t1970-01-02T08:00:00.000000Z\n1326447242\t592859671\t1970-01-02T00:00:00.000000Z\n73575701\t-948263339\t1970-01-01T16:00:00.000000Z\n1548800833\t-727724771\t1970-01-01T08:00:00.000000Z\n-1148479920\t315515118\t1970-01-01T00:00:00.000000Z\n";
        String expectedNext = "-1975183723\t-1252906348\t1975-01-04T00:00:00.000000Z\n-1125169127\t1631244228\t1975-01-03T16:00:00.000000Z\n1404198\t-1715058769\t1975-01-03T08:00:00.000000Z\n-1101822104\t-1153445279\t1975-01-03T00:00:00.000000Z\n-1844391305\t-1520872171\t1975-01-02T16:00:00.000000Z\n-85170055\t-1792928964\t1975-01-02T08:00:00.000000Z\n-1432278050\t426455968\t1975-01-02T00:00:00.000000Z\n1125579207\t-1849627000\t1975-01-01T16:00:00.000000Z\n-1532328444\t-1458132197\t1975-01-01T08:00:00.000000Z\n1530831067\t1904508147\t1975-01-01T00:00:00.000000Z\n";
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "x", 0).col("a", 3).col("b", 3).timestamp();){
                CairoTestUtils.create(model);
            }
            Rnd rnd = new Rnd();
            long timestamp = 0L;
            long increment = 28800000000L;
            int N = 10;
            try (TableWriter w = new TableWriter(configuration, (CharSequence)"x");){
                for (int i = 0; i < N; ++i) {
                    TableWriter.Row row = w.newRow(timestamp);
                    row.putInt(0, rnd.nextInt());
                    row.putInt(1, rnd.nextInt());
                    row.append();
                    timestamp += increment;
                }
                w.commit();
                try (Engine engine = new Engine(configuration);){
                    FullBwdDataFrameCursorFactory factory = new FullBwdDataFrameCursorFactory((CairoEngine)engine, "x", 0L);
                    TableReaderRecord record = new TableReaderRecord();
                    try (DataFrameCursor cursor = factory.getCursor();){
                        this.printCursor(record, cursor);
                        TestUtils.assertEquals((CharSequence)"-409854405\t339631474\t1970-01-04T00:00:00.000000Z\n1569490116\t1573662097\t1970-01-03T16:00:00.000000Z\n806715481\t1545253512\t1970-01-03T08:00:00.000000Z\n-1436881714\t-1575378703\t1970-01-03T00:00:00.000000Z\n-1191262516\t-2041844972\t1970-01-02T16:00:00.000000Z\n1868723706\t-847531048\t1970-01-02T08:00:00.000000Z\n1326447242\t592859671\t1970-01-02T00:00:00.000000Z\n73575701\t-948263339\t1970-01-01T16:00:00.000000Z\n1548800833\t-727724771\t1970-01-01T08:00:00.000000Z\n-1148479920\t315515118\t1970-01-01T00:00:00.000000Z\n", (CharSequence)sink);
                        timestamp = DateFormatUtils.parseDateTime((CharSequence)"1975-01-01T00:00:00.000Z");
                        for (int i = 0; i < N; ++i) {
                            TableWriter.Row row = w.newRow(timestamp);
                            row.putInt(0, rnd.nextInt());
                            row.putInt(1, rnd.nextInt());
                            row.append();
                            timestamp += increment;
                        }
                        w.commit();
                        Assert.assertTrue((boolean)cursor.reload());
                        this.printCursor(record, cursor);
                        TestUtils.assertEquals((CharSequence)"-1975183723\t-1252906348\t1975-01-04T00:00:00.000000Z\n-1125169127\t1631244228\t1975-01-03T16:00:00.000000Z\n1404198\t-1715058769\t1975-01-03T08:00:00.000000Z\n-1101822104\t-1153445279\t1975-01-03T00:00:00.000000Z\n-1844391305\t-1520872171\t1975-01-02T16:00:00.000000Z\n-85170055\t-1792928964\t1975-01-02T08:00:00.000000Z\n-1432278050\t426455968\t1975-01-02T00:00:00.000000Z\n1125579207\t-1849627000\t1975-01-01T16:00:00.000000Z\n-1532328444\t-1458132197\t1975-01-01T08:00:00.000000Z\n1530831067\t1904508147\t1975-01-01T00:00:00.000000Z\n-409854405\t339631474\t1970-01-04T00:00:00.000000Z\n1569490116\t1573662097\t1970-01-03T16:00:00.000000Z\n806715481\t1545253512\t1970-01-03T08:00:00.000000Z\n-1436881714\t-1575378703\t1970-01-03T00:00:00.000000Z\n-1191262516\t-2041844972\t1970-01-02T16:00:00.000000Z\n1868723706\t-847531048\t1970-01-02T08:00:00.000000Z\n1326447242\t592859671\t1970-01-02T00:00:00.000000Z\n73575701\t-948263339\t1970-01-01T16:00:00.000000Z\n1548800833\t-727724771\t1970-01-01T08:00:00.000000Z\n-1148479920\t315515118\t1970-01-01T00:00:00.000000Z\n", (CharSequence)sink);
                    }
                    w.removeColumn((CharSequence)"a");
                    try {
                        factory.getCursor();
                        Assert.fail();
                    }
                    catch (ReaderOutOfDateException readerOutOfDateException) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void printCursor(TableReaderRecord record, DataFrameCursor cursor) throws IOException {
        sink.clear();
        record.of(cursor.getTableReader());
        while (cursor.hasNext()) {
            DataFrame frame = (DataFrame)cursor.next();
            record.jumpTo(frame.getPartitionIndex(), 0L);
            long lo = frame.getRowLo() - 1L;
            for (long index = frame.getRowHi() - 1L; index > lo; --index) {
                record.setRecordIndex(index);
                printer.print((Record)record, cursor.getTableReader().getMetadata());
            }
        }
    }
}

