/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.CairoWorkScheduler;
import com.questdb.cairo.ColumnIndexerEntry;
import com.questdb.cairo.DefaultCairoConfiguration;
import com.questdb.cairo.Engine;
import com.questdb.cairo.ReaderOutOfDateException;
import com.questdb.cairo.TableModel;
import com.questdb.cairo.TableReader;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.TestFilesFacade;
import com.questdb.cairo.pool.PoolListener;
import com.questdb.mp.Job;
import com.questdb.mp.RingQueue;
import com.questdb.mp.Sequence;
import com.questdb.std.FilesFacade;
import com.questdb.std.ObjHashSet;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.Path;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.Test;

public class EngineTest
extends AbstractCairoTest {
    private static final Path path = new Path();
    private static final Path otherPath = new Path();

    @Test
    public void testAncillaries() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            this.createX();
            class MyListener
            implements PoolListener {
                int count = 0;

                MyListener() {
                }

                public void onEvent(byte factoryType, long thread, CharSequence name, short event, short segment, short position) {
                    ++this.count;
                }
            }
            MyListener listener = new MyListener();
            try (Engine engine = new Engine(configuration);){
                engine.setPoolListener((PoolListener)listener);
                Assert.assertEquals((Object)listener, (Object)engine.getPoolListener());
                TableReader reader = engine.getReader((CharSequence)"x", -1L);
                TableWriter writer = engine.getWriter((CharSequence)"x");
                Assert.assertEquals((long)1L, (long)engine.getBusyReaderCount());
                Assert.assertEquals((long)1L, (long)engine.getBusyWriterCount());
                reader.close();
                writer.close();
                Assert.assertEquals((long)4L, (long)listener.count);
                Assert.assertEquals((Object)configuration, (Object)engine.getConfiguration());
            }
        });
    }

    @Test
    public void testExpiry() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            this.createX();
            class MyListener
            implements PoolListener {
                int count = 0;

                MyListener() {
                }

                public void onEvent(byte factoryType, long thread, CharSequence name, short event, short segment, short position) {
                    if (event == 17) {
                        ++this.count;
                    }
                }
            }
            MyListener listener = new MyListener();
            class MyWorkScheduler
            implements CairoWorkScheduler {
                final ObjHashSet jobs = new ObjHashSet();

                MyWorkScheduler() {
                }

                public void addJob(Job job) {
                    this.jobs.add((Object)job);
                }

                public Sequence getIndexerPubSequence() {
                    return null;
                }

                public RingQueue<ColumnIndexerEntry> getIndexerQueue() {
                    return null;
                }

                public Sequence getIndexerSubSequence() {
                    return null;
                }
            }
            MyWorkScheduler workScheduler = new MyWorkScheduler();
            try (Engine engine = new Engine(configuration, (CairoWorkScheduler)workScheduler);){
                engine.setPoolListener((PoolListener)listener);
                this.assertWriter(engine, "x");
                this.assertReader(engine, "x");
                Assert.assertEquals((long)2L, (long)workScheduler.jobs.size());
                Job job = (Job)workScheduler.jobs.get(0);
                Assert.assertNotNull((Object)job);
                Assert.assertTrue((boolean)job.run());
                Assert.assertFalse((boolean)job.run());
                Assert.assertEquals((long)2L, (long)listener.count);
            }
        });
    }

    @Test
    public void testLockBusyReader() throws Exception {
        this.createX();
        TestUtils.assertMemoryLeak(() -> {
            try (Engine engine = new Engine(configuration);
                 TableReader reader = engine.getReader((CharSequence)"x", -1L);){
                Assert.assertNotNull((Object)reader);
                Assert.assertFalse((boolean)engine.lock((CharSequence)"x"));
                this.assertReader(engine, "x");
                this.assertWriter(engine, "x");
            }
        });
    }

    @Test
    public void testNewTableRename() throws Exception {
        this.createX();
        TestUtils.assertMemoryLeak(() -> {
            try (Engine engine = new Engine(configuration);){
                engine.rename(path, (CharSequence)"x", otherPath, "y");
                this.assertWriter(engine, "y");
                this.assertReader(engine, "y");
            }
        });
    }

    @Test
    public void testRemoveExisting() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            this.createX();
            try (Engine engine = new Engine(configuration);){
                this.assertReader(engine, "x");
                this.assertWriter(engine, "x");
                engine.remove(path, (CharSequence)"x");
                Assert.assertEquals((long)1L, (long)engine.getStatus(path, (CharSequence)"x"));
                try {
                    engine.getReader((CharSequence)"x", -1L);
                    Assert.fail();
                }
                catch (CairoException cairoException) {
                    // empty catch block
                }
                try {
                    engine.getWriter((CharSequence)"x");
                    Assert.fail();
                }
                catch (CairoException cairoException) {
                    // empty catch block
                }
            }
        });
    }

    @Test
    public void testRemoveNewTable() {
        this.createX();
        try (Engine engine = new Engine(configuration);){
            engine.remove(path, (CharSequence)"x");
            Assert.assertEquals((long)1L, (long)engine.getStatus(path, (CharSequence)"x"));
        }
    }

    @Test
    public void testRemoveNonExisting() throws Exception {
        this.createY();
        TestUtils.assertMemoryLeak(() -> {
            try (Engine engine = new Engine(configuration);){
                try {
                    engine.remove(path, (CharSequence)"x");
                    Assert.fail();
                }
                catch (CairoException e) {
                    TestUtils.assertContains(e.getMessage(), "remove failed");
                }
            }
        });
    }

    @Test
    public void testRemoveWhenReaderBusy() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            this.createX();
            try (Engine engine = new Engine(configuration);
                 TableReader reader = engine.getReader((CharSequence)"x", -1L);){
                Assert.assertNotNull((Object)reader);
                try {
                    engine.remove(path, (CharSequence)"x");
                    Assert.fail();
                }
                catch (CairoException cairoException) {
                    // empty catch block
                }
            }
        });
    }

    @Test
    public void testRemoveWhenWriterBusy() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            this.createX();
            try (Engine engine = new Engine(configuration);
                 TableWriter writer = engine.getWriter((CharSequence)"x");){
                Assert.assertNotNull((Object)writer);
                try {
                    engine.remove(path, (CharSequence)"x");
                    Assert.fail();
                }
                catch (CairoException cairoException) {
                    // empty catch block
                }
            }
        });
    }

    @Test
    public void testRenameExisting() throws Exception {
        this.createX();
        TestUtils.assertMemoryLeak(() -> {
            try (Engine engine = new Engine(configuration);){
                this.assertWriter(engine, "x");
                this.assertReader(engine, "x");
                engine.rename(path, (CharSequence)"x", otherPath, "y");
                this.assertWriter(engine, "y");
                this.assertReader(engine, "y");
                Assert.assertTrue((boolean)engine.releaseAllReaders());
                Assert.assertTrue((boolean)engine.releaseAllWriters());
            }
        });
    }

    @Test
    public void testRenameExternallyLockedTable() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            this.createX();
            try (TableWriter ignored1 = new TableWriter(configuration, (CharSequence)"x");
                 Engine engine = new Engine(configuration);){
                try {
                    engine.getWriter((CharSequence)"x");
                    Assert.fail();
                }
                catch (CairoException cairoException) {
                    // empty catch block
                }
                try {
                    engine.rename(path, (CharSequence)"x", otherPath, "y");
                    Assert.fail();
                }
                catch (CairoException e) {
                    TestUtils.assertContains(e.getMessage(), "Cannot lock");
                }
            }
        });
    }

    @Test
    public void testRenameFail() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            this.createX();
            final TestFilesFacade ff = new TestFilesFacade(){
                int counter = 1;

                public boolean rename(LPSZ from, LPSZ to) {
                    return this.counter-- <= 0 && super.rename(from, to);
                }

                @Override
                public boolean wasCalled() {
                    return this.counter < 1;
                }
            };
            DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){

                public FilesFacade getFilesFacade() {
                    return ff;
                }
            };
            try (Engine engine = new Engine((CairoConfiguration)configuration);){
                this.assertReader(engine, "x");
                this.assertWriter(engine, "x");
                try {
                    engine.rename(path, (CharSequence)"x", otherPath, "y");
                    Assert.fail();
                }
                catch (CairoException e) {
                    TestUtils.assertContains(e.getMessage(), "Rename failed");
                }
                this.assertReader(engine, "x");
                this.assertWriter(engine, "x");
                engine.rename(path, (CharSequence)"x", otherPath, "y");
                this.assertReader(engine, "y");
                this.assertWriter(engine, "y");
            }
            Assert.assertTrue((boolean)ff.wasCalled());
        });
    }

    @Test
    public void testRenameNonExisting() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (TableModel model = new TableModel(configuration, "z", 3).col("a", 3);){
                CairoTestUtils.create(model);
            }
            try {
                var1_2 = null;
                try (Engine engine = new Engine(configuration);){
                    engine.rename(path, (CharSequence)"x", otherPath, "y");
                    Assert.fail();
                }
                catch (Throwable throwable) {
                    var1_2 = throwable;
                    throw throwable;
                }
            }
            catch (CairoException e) {
                TestUtils.assertContains(e.getMessage(), "does not exist");
            }
        });
    }

    @Test
    public void testRenameToExistingTarget() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            this.createX();
            this.createY();
            try (Engine engine = new Engine(configuration);){
                this.assertWriter(engine, "x");
                this.assertReader(engine, "x");
                try {
                    engine.rename(path, (CharSequence)"x", otherPath, "y");
                    Assert.fail();
                }
                catch (CairoException e) {
                    TestUtils.assertContains(e.getMessage(), "exists");
                }
                this.assertWriter(engine, "x");
                this.assertReader(engine, "x");
                this.assertReader(engine, "y");
                this.assertWriter(engine, "y");
            }
        });
    }

    @Test
    public void testWrongReaderVersion() throws Exception {
        this.createX();
        TestUtils.assertMemoryLeak(() -> {
            try (Engine engine = new Engine(configuration);){
                this.assertWriter(engine, "x");
                try {
                    engine.getReader((CharSequence)"x", 2L);
                    Assert.fail();
                }
                catch (ReaderOutOfDateException readerOutOfDateException) {
                    // empty catch block
                }
                Assert.assertTrue((boolean)engine.releaseAllReaders());
                Assert.assertTrue((boolean)engine.releaseAllWriters());
            }
        });
    }

    private void assertReader(Engine engine, String name) {
        try (TableReader reader = engine.getReader((CharSequence)name, -1L);){
            Assert.assertNotNull((Object)reader);
        }
    }

    private void assertWriter(Engine engine, String name) {
        try (TableWriter w = engine.getWriter((CharSequence)name);){
            Assert.assertNotNull((Object)w);
        }
    }

    private void createX() {
        try (TableModel model = new TableModel(configuration, "x", 3).col("a", 3);){
            CairoTestUtils.create(model);
        }
    }

    private void createY() {
        try (TableModel model = new TableModel(configuration, "y", 3).col("b", 3);){
            CairoTestUtils.create(model);
        }
    }
}

