/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.AppendMemory;
import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.TableModel;
import com.questdb.cairo.TableStructure;
import com.questdb.cairo.TableUtils;
import com.questdb.cairo.TableWriter;
import com.questdb.cairo.TestRecord;
import com.questdb.std.BinarySequence;
import com.questdb.std.FilesFacade;
import com.questdb.std.Rnd;
import com.questdb.std.str.Path;

public class CairoTestUtils {
    public static void create(TableModel model) {
        TableUtils.createTable((FilesFacade)model.getCairoCfg().getFilesFacade(), (AppendMemory)model.getMem(), (Path)model.getPath(), (CharSequence)model.getCairoCfg().getRoot(), (TableStructure)model, (int)model.getCairoCfg().getMkDirMode());
    }

    public static void createAllTable(CairoConfiguration configuration, int partitionBy) {
        try (TableModel model = CairoTestUtils.getAllTypesModel(configuration, partitionBy);){
            CairoTestUtils.create(model);
        }
    }

    public static void createTestTable(int n, Rnd rnd, TestRecord.ArrayBinarySequence binarySequence) {
        try (TableModel model = new TableModel(AbstractCairoTest.configuration, "x", 3);){
            model.col("a", 1).col("b", 2).col("c", 3).col("d", 4).col("e", 10).col("f", 12).col("g", 5).col("h", 6).col("i", 7).col("j", 8).col("k", 0).col("l", 9);
            CairoTestUtils.create(model);
        }
        var4_4 = null;
        try (TableWriter writer = new TableWriter(AbstractCairoTest.configuration, (CharSequence)"x");){
            for (int i = 0; i < n; ++i) {
                TableWriter.Row row = writer.newRow(0L);
                row.putByte(0, rnd.nextByte());
                row.putShort(1, rnd.nextShort());
                if (rnd.nextInt() % 4 == 0) {
                    row.putInt(2, Integer.MIN_VALUE);
                } else {
                    row.putInt(2, rnd.nextInt());
                }
                if (rnd.nextInt() % 4 == 0) {
                    row.putLong(3, Long.MIN_VALUE);
                } else {
                    row.putLong(3, rnd.nextLong());
                }
                if (rnd.nextInt() % 4 == 0) {
                    row.putLong(4, Long.MIN_VALUE);
                } else {
                    row.putDate(4, rnd.nextLong());
                }
                if (rnd.nextInt() % 4 == 0) {
                    row.putLong(5, Long.MIN_VALUE);
                } else {
                    row.putTimestamp(5, rnd.nextLong());
                }
                if (rnd.nextInt() % 4 == 0) {
                    row.putFloat(6, Float.NaN);
                } else {
                    row.putFloat(6, rnd.nextFloat2());
                }
                if (rnd.nextInt() % 4 == 0) {
                    row.putDouble(7, Double.NaN);
                } else {
                    row.putDouble(7, rnd.nextDouble2());
                }
                if (rnd.nextInt() % 4 == 0) {
                    row.putStr(8, null);
                } else {
                    row.putStr(8, rnd.nextChars(5));
                }
                if (rnd.nextInt() % 4 == 0) {
                    row.putSym(9, null);
                } else {
                    row.putSym(9, rnd.nextChars(3));
                }
                row.putBool(10, rnd.nextBoolean());
                if (rnd.nextInt() % 4 == 0) {
                    row.putBin(11, null);
                } else {
                    binarySequence.of(rnd.nextBytes(25));
                    row.putBin(11, (BinarySequence)binarySequence);
                }
                row.append();
            }
            writer.commit();
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
    }

    public static TableModel getAllTypesModel(CairoConfiguration configuration, int partitionBy) {
        return new TableModel(configuration, "all", partitionBy).col("int", 3).col("short", 2).col("byte", 1).col("double", 6).col("float", 5).col("long", 4).col("str", 7).col("sym", 8).symbolCapacity(64).col("bool", 0).col("bin", 9).col("date", 10);
    }
}

