/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.AppendMemory;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.ReadOnlyMemory;
import com.questdb.cairo.ReadWriteMemory;
import com.questdb.cairo.SlidingWindowMemory;
import com.questdb.cairo.TestFilesFacade;
import com.questdb.cairo.VirtualMemory;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.Chars;
import com.questdb.std.FilesFacade;
import com.questdb.std.FilesFacadeImpl;
import com.questdb.std.Rnd;
import com.questdb.std.Unsafe;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.Path;
import com.questdb.test.tools.TestUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CairoMemoryTest {
    private static final int N = 1000000;
    private static final Log LOG = LogFactory.getLog(CairoMemoryTest.class);
    private static final FilesFacade FF = FilesFacadeImpl.INSTANCE;
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    @BeforeClass
    public static void setUp() {
        LOG.info().$((CharSequence)"Begin test").$();
    }

    @Test
    public void testAppendAfterMMapFailure() throws Exception {
        long used = Unsafe.getMemUsed();
        final Rnd rnd = new Rnd();
        class X
        extends FilesFacadeImpl {
            boolean force = true;

            X() {
            }

            public long mmap(long fd, long len, long offset, int mode) {
                if (this.force || rnd.nextBoolean()) {
                    this.force = false;
                    return super.mmap(fd, len, offset, mode);
                }
                return -1L;
            }
        }
        X ff = new X();
        long openFileCount = ff.getOpenFileCount();
        int failureCount = 0;
        try (Path path = new Path();){
            path.of((CharSequence)this.temp.newFile().getAbsolutePath());
            try (AppendMemory mem = new AppendMemory();){
                mem.of((FilesFacade)ff, (LPSZ)path.$(), ff.getPageSize() * 2L);
                int i = 0;
                while (i < 1000000) {
                    try {
                        mem.putLong((long)i);
                        ++i;
                    }
                    catch (CairoException ignore) {
                        ++failureCount;
                    }
                }
                Assert.assertEquals((long)8000000L, (long)mem.getAppendOffset());
            }
        }
        Assert.assertTrue((failureCount > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)used, (long)Unsafe.getMemUsed());
        Assert.assertEquals((long)openFileCount, (long)ff.getOpenFileCount());
    }

    @Test
    public void testAppendAndCannotMap() throws Exception {
        long used = Unsafe.getMemUsed();
        final Rnd rnd = new Rnd();
        class X
        extends FilesFacadeImpl {
            X() {
            }

            public long mmap(long fd, long len, long offset, int mode) {
                if (rnd.nextBoolean()) {
                    return -1L;
                }
                return super.mmap(fd, len, offset, mode);
            }
        }
        X ff = new X();
        try (Path path = new Path().of((CharSequence)this.temp.newFile().getAbsolutePath()).$();){
            try (AppendMemory mem = new AppendMemory(FF, (LPSZ)path, 2L * FF.getPageSize());){
                for (int i = 0; i < 1000000; ++i) {
                    mem.putLong((long)i);
                }
                Assert.assertEquals((long)8000000L, (long)mem.getAppendOffset());
            }
            int failureCount = 0;
            try (ReadOnlyMemory mem = new ReadOnlyMemory();){
                mem.of((FilesFacade)ff, (LPSZ)path, ff.getPageSize(), 8000000L);
                int i = 0;
                while (i < 1000000) {
                    try {
                        Assert.assertEquals((long)i, (long)mem.getLong((long)(i * 8)));
                        ++i;
                    }
                    catch (CairoException ignore) {
                        ++failureCount;
                    }
                }
                Assert.assertTrue((failureCount > 0 ? 1 : 0) != 0);
            }
        }
        Assert.assertEquals((long)used, (long)Unsafe.getMemUsed());
    }

    @Test
    public void testAppendAndCannotRead() throws Exception {
        long used = Unsafe.getMemUsed();
        class X
        extends FilesFacadeImpl {
            int count = 2;

            X() {
            }

            public long openRO(LPSZ name) {
                return --this.count > 0 ? -1L : super.openRO(name);
            }
        }
        X ff = new X();
        try (Path path = new Path().of((CharSequence)this.temp.newFile().getAbsolutePath()).$();){
            try (AppendMemory mem = new AppendMemory(FF, (LPSZ)path, 2L * FF.getPageSize());){
                for (int i = 0; i < 1000000; ++i) {
                    mem.putLong((long)i);
                }
                Assert.assertEquals((long)8000000L, (long)mem.getAppendOffset());
            }
            mem = new ReadOnlyMemory();
            var7_8 = null;
            try {
                try {
                    mem.of((FilesFacade)ff, (LPSZ)path, ff.getPageSize(), 8000000L);
                    Assert.fail();
                }
                catch (CairoException i) {
                    // empty catch block
                }
                mem.of((FilesFacade)ff, (LPSZ)path, ff.getPageSize(), 8000000L);
                for (int i = 0; i < 1000000; ++i) {
                    Assert.assertEquals((long)i, (long)mem.getLong((long)(i * 8)));
                }
            }
            catch (Throwable throwable) {
                var7_8 = throwable;
                throw throwable;
            }
            finally {
                if (mem != null) {
                    if (var7_8 != null) {
                        try {
                            mem.close();
                        }
                        catch (Throwable throwable) {
                            var7_8.addSuppressed(throwable);
                        }
                    } else {
                        mem.close();
                    }
                }
            }
        }
        Assert.assertEquals((long)used, (long)Unsafe.getMemUsed());
    }

    @Test
    public void testAppendAndReadWithReadOnlyMem() throws Exception {
        long used = Unsafe.getMemUsed();
        try (Path path = new Path().of((CharSequence)this.temp.newFile().getAbsolutePath()).$();){
            try (AppendMemory mem = new AppendMemory(FF, (LPSZ)path, 2L * FF.getPageSize());){
                for (int i = 0; i < 1000000; ++i) {
                    mem.putLong((long)i);
                }
                Assert.assertEquals((long)8000000L, (long)mem.getAppendOffset());
            }
            mem = new ReadOnlyMemory();
            var6_7 = null;
            try {
                try {
                    mem.of(FF, null, FF.getPageSize(), 8000000L);
                    Assert.fail();
                }
                catch (CairoException i) {
                    // empty catch block
                }
                mem.of(FF, (LPSZ)path, FF.getPageSize(), 8000000L);
                for (int i = 0; i < 1000000; ++i) {
                    Assert.assertEquals((long)i, (long)mem.getLong((long)(i * 8)));
                }
            }
            catch (Throwable throwable) {
                var6_7 = throwable;
                throw throwable;
            }
            finally {
                if (mem != null) {
                    if (var6_7 != null) {
                        try {
                            mem.close();
                        }
                        catch (Throwable throwable) {
                            var6_7.addSuppressed(throwable);
                        }
                    } else {
                        mem.close();
                    }
                }
            }
        }
        Assert.assertEquals((long)used, (long)Unsafe.getMemUsed());
    }

    @Test
    public void testAppendCannotOpenFile() {
        long used = Unsafe.getMemUsed();
        class X
        extends FilesFacadeImpl {
            X() {
            }

            public long openRW(LPSZ name) {
                int n = name.length();
                if (n > 5 && Chars.equals((CharSequence)".fail", (CharSequence)name, (int)(n - 5), (int)n)) {
                    return -1L;
                }
                return super.openRW(name);
            }
        }
        X ff = new X();
        long openFileCount = ff.getOpenFileCount();
        int successCount = 0;
        int failCount = 0;
        try (Path path = new Path();){
            path.of((CharSequence)this.temp.getRoot().getAbsolutePath());
            int prefixLen = path.length();
            try (AppendMemory mem = new AppendMemory();){
                Rnd rnd = new Rnd();
                for (int k = 0; k < 10; ++k) {
                    path.trimTo(prefixLen).concat((CharSequence)rnd.nextString(10));
                    boolean fail = rnd.nextBoolean();
                    if (fail) {
                        path.put((CharSequence)".fail").$();
                        ++failCount;
                    } else {
                        path.put((CharSequence)".data").$();
                        ++successCount;
                    }
                    if (fail) {
                        try {
                            mem.of((FilesFacade)ff, (LPSZ)path, 2L * ff.getPageSize());
                            Assert.fail();
                        }
                        catch (CairoException cairoException) {}
                        continue;
                    }
                    mem.of((FilesFacade)ff, (LPSZ)path, 2L * ff.getPageSize());
                    for (int i = 0; i < 1000000; ++i) {
                        mem.putLong((long)i);
                    }
                    Assert.assertEquals((long)8000000L, (long)mem.getAppendOffset());
                }
            }
        }
        Assert.assertEquals((long)used, (long)Unsafe.getMemUsed());
        Assert.assertEquals((long)openFileCount, (long)ff.getOpenFileCount());
        Assert.assertTrue((failCount > 0 ? 1 : 0) != 0);
        Assert.assertTrue((successCount > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testAppendMemoryJump() throws Exception {
        this.testVirtualMemoryJump(path -> new AppendMemory(FF, (LPSZ)path, FF.getPageSize()));
    }

    @Test
    public void testAppendMemoryReuse() throws Exception {
        long used = Unsafe.getMemUsed();
        try (AppendMemory mem = new AppendMemory();){
            for (int j = 0; j < 10; ++j) {
                try (Path path = new Path().of((CharSequence)this.temp.newFile().getAbsolutePath()).$();){
                    mem.of(FF, (LPSZ)path, 2L * FF.getPageSize());
                    for (int i = 0; i < 1000000; ++i) {
                        mem.putLong((long)i);
                    }
                    Assert.assertEquals((long)8000000L, (long)mem.getAppendOffset());
                    try (ReadOnlyMemory ro = new ReadOnlyMemory(FF, (LPSZ)path, FF.getPageSize(), 8000000L);){
                        for (int i = 0; i < 1000000; ++i) {
                            Assert.assertEquals((long)i, (long)ro.getLong((long)(i * 8)));
                        }
                        continue;
                    }
                }
            }
        }
        Assert.assertEquals((long)used, (long)Unsafe.getMemUsed());
    }

    @Test
    public void testAppendTruncateError() throws Exception {
        long used = Unsafe.getMemUsed();
        class X
        extends FilesFacadeImpl {
            int count = 2;
            boolean allClear = false;

            X() {
            }

            public boolean truncate(long fd, long size) {
                if (this.allClear || --this.count > 0) {
                    return super.truncate(fd, size);
                }
                this.allClear = true;
                return false;
            }
        }
        X ff = new X();
        long openFileCount = ff.getOpenFileCount();
        try (Path path = new Path().of((CharSequence)this.temp.newFile().getAbsolutePath()).$();
             AppendMemory mem = new AppendMemory((FilesFacade)ff, (LPSZ)path, 2L * ff.getPageSize());){
            try {
                for (int i = 0; i < 10000000; ++i) {
                    mem.putLong((long)i);
                }
                Assert.fail();
            }
            catch (CairoException cairoException) {
                // empty catch block
            }
            Assert.assertTrue((mem.getAppendOffset() > 0L ? 1 : 0) != 0);
        }
        Assert.assertEquals((long)used, (long)Unsafe.getMemUsed());
        Assert.assertEquals((long)openFileCount, (long)ff.getOpenFileCount());
    }

    @Test
    public void testReadOnlyMemoryJump() {
        try (ReadOnlyMemory mem = new ReadOnlyMemory();){
            try {
                mem.jumpTo(100L);
                Assert.fail();
            }
            catch (UnsupportedOperationException e) {
                Assert.assertTrue((boolean)Chars.contains((CharSequence)e.getMessage(), (CharSequence)"Use grow"));
            }
        }
    }

    @Test
    public void testReadWriteCannotOpenFile() {
        long used = Unsafe.getMemUsed();
        class X
        extends FilesFacadeImpl {
            X() {
            }

            public long openRW(LPSZ name) {
                int n = name.length();
                if (n > 5 && Chars.equals((CharSequence)".fail", (CharSequence)name, (int)(n - 5), (int)n)) {
                    return -1L;
                }
                return super.openRW(name);
            }
        }
        X ff = new X();
        long openFileCount = ff.getOpenFileCount();
        int successCount = 0;
        int failCount = 0;
        try (Path path = new Path();){
            path.of((CharSequence)this.temp.getRoot().getAbsolutePath());
            int prefixLen = path.length();
            try (ReadWriteMemory mem = new ReadWriteMemory();){
                Rnd rnd = new Rnd();
                for (int k = 0; k < 10; ++k) {
                    path.trimTo(prefixLen).concat((CharSequence)rnd.nextString(10));
                    boolean fail = rnd.nextBoolean();
                    if (fail) {
                        path.put((CharSequence)".fail").$();
                        ++failCount;
                    } else {
                        path.put((CharSequence)".data").$();
                        ++successCount;
                    }
                    if (fail) {
                        try {
                            mem.of((FilesFacade)ff, (LPSZ)path, 2L * ff.getPageSize());
                            Assert.fail();
                        }
                        catch (CairoException cairoException) {}
                        continue;
                    }
                    mem.of((FilesFacade)ff, (LPSZ)path, 2L * ff.getPageSize());
                    for (int i = 0; i < 1000000; ++i) {
                        mem.putLong((long)i);
                    }
                    Assert.assertEquals((long)8000000L, (long)mem.getAppendOffset());
                }
            }
        }
        Assert.assertEquals((long)used, (long)Unsafe.getMemUsed());
        Assert.assertEquals((long)openFileCount, (long)ff.getOpenFileCount());
        Assert.assertTrue((failCount > 0 ? 1 : 0) != 0);
        Assert.assertTrue((successCount > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testReadWriteMemoryJump() throws Exception {
        this.testVirtualMemoryJump(path -> new ReadWriteMemory(FF, (LPSZ)path, FF.getPageSize()));
    }

    @Test
    public void testSlidingWindowMemory() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (Path path = new Path();){
                path.of((CharSequence)this.temp.getRoot().getAbsolutePath());
                int N = 100000;
                Rnd rnd = new Rnd();
                try (AppendMemory mem = new AppendMemory();){
                    mem.of(FF, (LPSZ)path.concat((CharSequence)"x.dat").$(), FF.getPageSize());
                    for (int i = 0; i < 100000; ++i) {
                        mem.putLong(rnd.nextLong());
                    }
                    try (SlidingWindowMemory mem2 = new SlidingWindowMemory();){
                        mem2.of(mem);
                        try {
                            mem2.getLong(1600000L);
                            Assert.fail();
                        }
                        catch (CairoException e) {
                            TestUtils.assertContains(e.getMessage(), "Trying to map read-only page outside");
                        }
                        try {
                            mem2.jumpTo(1024L);
                            Assert.fail();
                        }
                        catch (UnsupportedOperationException e) {
                            TestUtils.assertContains(e.getMessage(), "Cannot jump() read-only memory");
                        }
                        rnd.reset();
                        for (int i = 0; i < 100000; ++i) {
                            Assert.assertEquals((long)rnd.nextLong(), (long)mem2.getLong((long)(i * 8)));
                        }
                    }
                }
            }
        });
    }

    @Test
    public void testSlidingWindowMemoryCannotMap() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (Path path = new Path();){
                path.of((CharSequence)this.temp.getRoot().getAbsolutePath());
                int N = 100000;
                Rnd rnd = new Rnd();
                FilesFacadeImpl ff = new FilesFacadeImpl(){
                    int counter = 2;

                    public long mmap(long fd, long len, long offset, int mode) {
                        if (mode == 1 && --this.counter == 0) {
                            return -1L;
                        }
                        return super.mmap(fd, len, offset, mode);
                    }
                };
                try (AppendMemory mem = new AppendMemory();){
                    mem.of((FilesFacade)ff, (LPSZ)path.concat((CharSequence)"x.dat").$(), ff.getPageSize());
                    for (int i = 0; i < 100000; ++i) {
                        mem.putLong(rnd.nextLong());
                    }
                    try (SlidingWindowMemory mem2 = new SlidingWindowMemory();){
                        int i;
                        mem2.of(mem);
                        try {
                            rnd.reset();
                            for (i = 0; i < 100000; ++i) {
                                Assert.assertEquals((long)rnd.nextLong(), (long)mem2.getLong((long)(i * 8)));
                            }
                            Assert.fail();
                        }
                        catch (CairoException e) {
                            TestUtils.assertContains(e.getMessage(), "Cannot map read-only page");
                        }
                        rnd.reset();
                        for (i = 0; i < 100000; ++i) {
                            Assert.assertEquals((long)rnd.nextLong(), (long)mem2.getLong((long)(i * 8)));
                        }
                    }
                }
            }
        });
    }

    @Test
    public void testWindowsTruncateRaceCondition() throws Exception {
        TestUtils.assertMemoryLeak(new TestUtils.LeakProneCode(){

            @Override
            public void run() throws Exception {
                try (Path path = new Path().of((CharSequence)CairoMemoryTest.this.temp.newFile().getAbsolutePath()).$();
                     AppendMemory mem = new AppendMemory(FF, (LPSZ)path, FF.getMapPageSize());){
                    mem.putLong(1L);
                    mem.putDouble(0.123456);
                    final long size = mem.getAppendOffset();
                    TestFilesFacade ff = new TestFilesFacade(){
                        int errno = 0;
                        boolean wasCalled = false;

                        public int errno() {
                            return this.errno;
                        }

                        @Override
                        public boolean wasCalled() {
                            return this.wasCalled;
                        }

                        public long mmap(long fd, long len, long offset, int mode) {
                            if (len > size) {
                                this.errno = 8;
                                this.wasCalled = true;
                                return -1L;
                            }
                            return super.mmap(fd, len, offset, mode);
                        }

                        public boolean isRestrictedFileSystem() {
                            return true;
                        }
                    };
                    try (ReadOnlyMemory roMem = new ReadOnlyMemory((FilesFacade)ff, (LPSZ)path, ff.getMapPageSize(), size);){
                        Assert.assertEquals((long)1L, (long)roMem.getLong(0L));
                        Assert.assertEquals((double)0.123456, (double)roMem.getDouble(8L), (double)1.0E-6);
                    }
                    Assert.assertTrue((boolean)ff.wasCalled());
                }
            }
        });
    }

    @Test
    public void testWriteAndRead() throws Exception {
        long used = Unsafe.getMemUsed();
        try (Path path = new Path().of((CharSequence)this.temp.newFile().getAbsolutePath()).$();){
            try (ReadWriteMemory mem = new ReadWriteMemory(FF, (LPSZ)path, 2L * FF.getPageSize());){
                int i;
                for (i = 0; i < 1000000; ++i) {
                    mem.putLong((long)i);
                }
                for (i = 0; i < 1000000; ++i) {
                    Assert.assertEquals((long)i, (long)mem.getLong((long)(i * 8)));
                }
                Assert.assertEquals((long)8000000L, (long)mem.getAppendOffset());
            }
            mem = new ReadWriteMemory(FF, (LPSZ)path, FF.getPageSize());
            var6_7 = null;
            try {
                for (int i = 0; i < 1000000; ++i) {
                    Assert.assertEquals((long)i, (long)mem.getLong((long)(i * 8)));
                }
            }
            catch (Throwable throwable) {
                var6_7 = throwable;
                throw throwable;
            }
            finally {
                if (mem != null) {
                    if (var6_7 != null) {
                        try {
                            mem.close();
                        }
                        catch (Throwable throwable) {
                            var6_7.addSuppressed(throwable);
                        }
                    } else {
                        mem.close();
                    }
                }
            }
        }
        Assert.assertEquals((long)used, (long)Unsafe.getMemUsed());
    }

    @Test
    public void testWriteAndReadWithReadOnlyMem() throws Exception {
        long used = Unsafe.getMemUsed();
        try (Path path = new Path().of((CharSequence)this.temp.newFile().getAbsolutePath()).$();){
            int i;
            try (ReadWriteMemory mem = new ReadWriteMemory(FF, (LPSZ)path, 2L * FF.getPageSize());){
                for (i = 0; i < 1000000; ++i) {
                    mem.putLong((long)i);
                }
                Assert.assertEquals((long)8000000L, (long)mem.getAppendOffset());
            }
            mem = new ReadOnlyMemory(FF, (LPSZ)path, FF.getPageSize(), 8000000L);
            var6_7 = null;
            try {
                for (i = 0; i < 1000000; ++i) {
                    Assert.assertEquals((long)i, (long)mem.getLong((long)(i * 8)));
                }
            }
            catch (Throwable throwable) {
                var6_7 = throwable;
                throw throwable;
            }
            finally {
                if (mem != null) {
                    if (var6_7 != null) {
                        try {
                            mem.close();
                        }
                        catch (Throwable throwable) {
                            var6_7.addSuppressed(throwable);
                        }
                    } else {
                        mem.close();
                    }
                }
            }
        }
        Assert.assertEquals((long)used, (long)Unsafe.getMemUsed());
    }

    @Test
    public void testWriteOverMapFailuresAndRead() throws Exception {
        long used = Unsafe.getMemUsed();
        final Rnd rnd = new Rnd();
        int writeFailureCount = 0;
        class X
        extends FilesFacadeImpl {
            X() {
            }

            public long mmap(long fd, long len, long offset, int mode) {
                if (rnd.nextBoolean()) {
                    return -1L;
                }
                return super.mmap(fd, len, offset, mode);
            }
        }
        X ff = new X();
        try (Path path = new Path().of((CharSequence)this.temp.newFile().getAbsolutePath()).$();
             ReadWriteMemory mem = new ReadWriteMemory((FilesFacade)ff, (LPSZ)path, 2L * ff.getPageSize());){
            int i = 0;
            while (i < 1000000) {
                try {
                    mem.putLong((long)i);
                    ++i;
                }
                catch (CairoException ignore) {
                    ++writeFailureCount;
                }
            }
            for (i = 0; i < 1000000; ++i) {
                Assert.assertEquals((long)i, (long)mem.getLong((long)(i * 8)));
            }
            Assert.assertEquals((long)8000000L, (long)mem.getAppendOffset());
        }
        Assert.assertTrue((writeFailureCount > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)used, (long)Unsafe.getMemUsed());
    }

    private void testVirtualMemoryJump(VirtualMemoryFactory factory) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (Path path = new Path().of((CharSequence)this.temp.newFile().getAbsolutePath()).$();){
                try (VirtualMemory mem = factory.newInstance(path);){
                    int i;
                    for (i = 0; i < 100; ++i) {
                        mem.putLong((long)i);
                    }
                    mem.jumpTo(0L);
                    for (i = 0; i < 50; ++i) {
                        mem.putLong((long)(50 - i));
                    }
                    mem.jumpTo(800L);
                }
                var5_7 = null;
                try (ReadOnlyMemory roMem = new ReadOnlyMemory(FF, (LPSZ)path, FF.getPageSize(), 800L);){
                    int i;
                    for (i = 0; i < 50; ++i) {
                        Assert.assertEquals((long)(50 - i), (long)roMem.getLong((long)(i * 8)));
                    }
                    for (i = 50; i < 100; ++i) {
                        Assert.assertEquals((long)i, (long)roMem.getLong((long)(i * 8)));
                    }
                }
                catch (Throwable throwable) {
                    var5_7 = throwable;
                    throw throwable;
                }
            }
        });
    }

    @FunctionalInterface
    private static interface VirtualMemoryFactory {
        public VirtualMemory newInstance(Path var1);
    }
}

