/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.AbstractCairoTest;
import com.questdb.cairo.AppendMemory;
import com.questdb.cairo.BitmapIndexBwdReader;
import com.questdb.cairo.BitmapIndexFwdReader;
import com.questdb.cairo.BitmapIndexUtils;
import com.questdb.cairo.BitmapIndexWriter;
import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.CairoException;
import com.questdb.cairo.DefaultCairoConfiguration;
import com.questdb.cairo.EmptyRowCursor;
import com.questdb.cairo.ReadWriteMemory;
import com.questdb.cairo.SlidingWindowMemory;
import com.questdb.cairo.VirtualMemory;
import com.questdb.cairo.sql.RowCursor;
import com.questdb.std.Chars;
import com.questdb.std.FilesFacade;
import com.questdb.std.FilesFacadeImpl;
import com.questdb.std.IntList;
import com.questdb.std.IntObjHashMap;
import com.questdb.std.LongList;
import com.questdb.std.Misc;
import com.questdb.std.Numbers;
import com.questdb.std.Rnd;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.Path;
import com.questdb.test.tools.TestUtils;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BitmapIndexTest
extends AbstractCairoTest {
    private Path path;
    private int plen;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(CairoConfiguration configuration, Path path, CharSequence name, int valueBlockCapacity) {
        int plen = path.length();
        try {
            FilesFacade ff = configuration.getFilesFacade();
            try (AppendMemory mem = new AppendMemory(ff, (LPSZ)BitmapIndexUtils.keyFileName((Path)path, (CharSequence)name), ff.getPageSize());){
                BitmapIndexWriter.initKeyMemory((VirtualMemory)mem, (int)Numbers.ceilPow2((int)valueBlockCapacity));
            }
            ff.touch((LPSZ)BitmapIndexUtils.valueFileName((Path)path.trimTo(plen), (CharSequence)name));
        }
        finally {
            path.trimTo(plen);
        }
    }

    @Override
    @Before
    public void setUp0() {
        this.path = new Path().of(configuration.getRoot());
        this.plen = this.path.length();
        super.setUp0();
    }

    @Override
    @After
    public void tearDown0() {
        Misc.free((Object)this.path);
        super.tearDown0();
    }

    @Test
    public void testAdd() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            LongList list = new LongList();
            BitmapIndexTest.create(configuration, this.path.trimTo(this.plen), "x", 4);
            try (BitmapIndexWriter writer = new BitmapIndexWriter(configuration, this.path, (CharSequence)"x");){
                writer.add(0, 1000L);
                writer.add(256, 1234L);
                writer.add(64, 10L);
                writer.add(64, 987L);
                writer.add(256, 5567L);
                writer.add(64, 91L);
                writer.add(64, 92L);
                writer.add(64, 93L);
                this.assertThat("[5567,1234]", writer.getCursor(256), list);
                this.assertThat("[93,92,91,987,10]", writer.getCursor(64), list);
                this.assertThat("[1000]", writer.getCursor(0), list);
                this.assertThat("[]", writer.getCursor(1000), list);
            }
            var3_3 = null;
            try (BitmapIndexBwdReader reader = new BitmapIndexBwdReader(configuration, this.path.trimTo(this.plen), (CharSequence)"x", 0L);){
                this.assertThat("[5567,1234]", reader.getCursor(true, 256, 0L, Long.MAX_VALUE), list);
                this.assertThat("[93,92,91,987,10]", reader.getCursor(true, 64, 0L, Long.MAX_VALUE), list);
                this.assertThat("[1000]", reader.getCursor(true, 0, 0L, Long.MAX_VALUE), list);
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            reader = new BitmapIndexFwdReader(configuration, this.path.trimTo(this.plen), (CharSequence)"x", 0L);
            var3_3 = null;
            try {
                this.assertThat("[1234,5567]", reader.getCursor(true, 256, 0L, Long.MAX_VALUE), list);
                this.assertThat("[10,987,91,92,93]", reader.getCursor(true, 64, 0L, Long.MAX_VALUE), list);
                this.assertThat("[1000]", reader.getCursor(true, 0, 0L, Long.MAX_VALUE), list);
            }
            catch (Throwable throwable) {
                var3_3 = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (var3_3 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            var3_3.addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        });
    }

    @Test
    public void testAdd1MValues() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            RowCursor cursor;
            int n;
            int i;
            Rnd rnd = new Rnd();
            int maxKeys = 1024;
            int N = 1000000;
            IntList keys = new IntList();
            IntObjHashMap lists = new IntObjHashMap();
            BitmapIndexTest.create(configuration, this.path.trimTo(this.plen), "x", 128);
            try (BitmapIndexWriter writer = new BitmapIndexWriter(configuration, this.path, (CharSequence)"x");){
                for (i = 0; i < N; ++i) {
                    int key = i % maxKeys;
                    long value = rnd.nextLong();
                    writer.add(key, value);
                    LongList list = (LongList)lists.get(key);
                    if (list == null) {
                        list = new LongList();
                        lists.put(key, (Object)list);
                        keys.add(key);
                    }
                    list.add(value);
                }
            }
            var7_7 = null;
            try (BitmapIndexBwdReader reader = new BitmapIndexBwdReader(configuration, this.path.trimTo(this.plen), (CharSequence)"x", 0L);){
                n = keys.size();
                for (i = 0; i < n; ++i) {
                    LongList list = (LongList)lists.get(keys.getQuick(i));
                    Assert.assertNotNull((Object)list);
                    cursor = reader.getCursor(true, keys.getQuick(i), Long.MIN_VALUE, Long.MAX_VALUE);
                    int z = list.size();
                    while (cursor.hasNext()) {
                        Assert.assertTrue((z > -1 ? 1 : 0) != 0);
                        Assert.assertEquals((long)list.getQuick(z - 1), (long)cursor.next());
                        --z;
                    }
                    Assert.assertEquals((long)0L, (long)z);
                }
            }
            catch (Throwable i2) {
                var7_7 = i2;
                throw i2;
            }
            reader = new BitmapIndexFwdReader(configuration, this.path.trimTo(this.plen), (CharSequence)"x", 0L);
            var7_7 = null;
            try {
                n = keys.size();
                for (int i3 = 0; i3 < n; ++i3) {
                    LongList list = (LongList)lists.get(keys.getQuick(i3));
                    Assert.assertNotNull((Object)list);
                    cursor = reader.getCursor(true, keys.getQuick(i3), Long.MIN_VALUE, Long.MAX_VALUE);
                    int z = 0;
                    int sz = list.size();
                    while (cursor.hasNext()) {
                        Assert.assertTrue((z < sz ? 1 : 0) != 0);
                        Assert.assertEquals((long)list.getQuick(z), (long)cursor.next());
                        ++z;
                    }
                    Assert.assertEquals((long)sz, (long)z);
                }
            }
            catch (Throwable throwable) {
                var7_7 = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (var7_7 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable) {
                            var7_7.addSuppressed(throwable);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        });
    }

    @Test
    public void testBackwardCursorTimeout() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            BitmapIndexTest.create(configuration, this.path.trimTo(this.plen), "x", 1024);
            try (BitmapIndexWriter w = new BitmapIndexWriter(configuration, this.path.trimTo(this.plen), (CharSequence)"x");){
                w.add(0, 10L);
            }
            var2_2 = null;
            try (BitmapIndexBwdReader reader = new BitmapIndexBwdReader(configuration, this.path.trimTo(this.plen), (CharSequence)"x", 0L);
                 ReadWriteMemory mem = new ReadWriteMemory();){
                try (Path path = new Path();){
                    path.of(configuration.getRoot()).concat((CharSequence)"x").put((CharSequence)".k").$();
                    mem.of(configuration.getFilesFacade(), (LPSZ)path, configuration.getFilesFacade().getPageSize());
                }
                long offset = BitmapIndexUtils.getKeyEntryOffset((int)0);
                mem.jumpTo(offset + 0L);
                mem.putLong(10L);
                try {
                    reader.getCursor(true, 0, 0L, Long.MAX_VALUE);
                    Assert.fail();
                }
                catch (CairoException e) {
                    Assert.assertTrue((boolean)Chars.contains((CharSequence)e.getMessage(), (CharSequence)"cursor failed"));
                }
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
        });
    }

    @Test
    public void testBackwardReaderConstructorBadSequence() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            this.setupIndexHeader();
            this.assertBackwardReaderConstructorFail("failed to read index header");
            this.assertForwardReaderConstructorFail("failed to read index header");
        });
    }

    @Test
    public void testBackwardReaderConstructorBadSig() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (AppendMemory mem = this.openKey();){
                mem.skip(64L);
            }
            this.assertBackwardReaderConstructorFail("Unknown format");
            this.assertForwardReaderConstructorFail("Unknown format");
        });
    }

    @Test
    public void testBackwardReaderConstructorFileTooSmall() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            this.openKey().close();
            this.assertBackwardReaderConstructorFail("Index file too short");
            this.assertForwardReaderConstructorFail("Index file too short");
        });
    }

    @Test
    public void testBackwardReaderDoesNotUnmapPages() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            Rnd rnd = new Rnd();
            BitmapIndexTest.create(configuration, this.path.trimTo(this.plen), "x", 1024);
            class CountingFacade
            extends FilesFacadeImpl {
                private int count = 0;

                CountingFacade() {
                }

                public long getMapPageSize() {
                    return 0x100000L;
                }

                public void munmap(long address, long size) {
                    super.munmap(address, size);
                    ++this.count;
                }
            }
            final CountingFacade facade = new CountingFacade();
            DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){
                {
                    super(x0);
                }

                public FilesFacade getFilesFacade() {
                    return facade;
                }
            };
            try (BitmapIndexWriter writer = new BitmapIndexWriter((CairoConfiguration)configuration, this.path.trimTo(this.plen), (CharSequence)"x");
                 BitmapIndexBwdReader reader = new BitmapIndexBwdReader((CairoConfiguration)configuration, this.path.trimTo(this.plen), (CharSequence)"x", 0L);){
                for (int i = 0; i < 100000; ++i) {
                    int key = rnd.nextPositiveInt() % 1024;
                    long value = rnd.nextPositiveLong();
                    writer.add(key, value);
                    RowCursor cursor = reader.getCursor(true, key, 0L, Long.MAX_VALUE);
                    boolean found = false;
                    while (cursor.hasNext()) {
                        if (value != cursor.next()) continue;
                        found = true;
                        break;
                    }
                    Assert.assertTrue((boolean)found);
                }
                Assert.assertEquals((long)0L, (long)facade.count);
            }
        });
    }

    @Test
    public void testBackwardReaderKeyUpdateFail() {
        BitmapIndexTest.create(configuration, this.path.trimTo(this.plen), "x", 1024);
        try (BitmapIndexWriter writer = new BitmapIndexWriter(configuration, this.path, (CharSequence)"x");){
            writer.add(0, 1000L);
        }
        var2_2 = null;
        try (BitmapIndexBwdReader reader = new BitmapIndexBwdReader(configuration, this.path.trimTo(this.plen), (CharSequence)"x", 0L);){
            RowCursor cursor = reader.getCursor(true, 0, 0L, Long.MAX_VALUE);
            Assert.assertTrue((boolean)cursor.hasNext());
            Assert.assertEquals((long)1000L, (long)cursor.next());
            Assert.assertFalse((boolean)cursor.hasNext());
            try (Path path = new Path();
                 ReadWriteMemory mem = new ReadWriteMemory(configuration.getFilesFacade(), (LPSZ)path.of(root).concat((CharSequence)"x").put((CharSequence)".k").$(), configuration.getFilesFacade().getPageSize());){
                long seq = mem.getLong(1L);
                mem.jumpTo(1L);
                mem.putLong(22L);
                try {
                    reader.getCursor(true, 10, 0L, Long.MAX_VALUE);
                }
                catch (CairoException e) {
                    Assert.assertTrue((boolean)Chars.contains((CharSequence)e.getMessage(), (CharSequence)"failed to consistently"));
                }
                try {
                    reader.getCursor(true, 0, 0L, Long.MAX_VALUE);
                }
                catch (CairoException e) {
                    Assert.assertTrue((boolean)Chars.contains((CharSequence)e.getMessage(), (CharSequence)"failed to consistently"));
                }
                mem.jumpTo(1L);
                mem.putLong(seq);
                cursor = reader.getCursor(true, 0, 0L, Long.MAX_VALUE);
                Assert.assertTrue((boolean)cursor.hasNext());
                Assert.assertEquals((long)1000L, (long)cursor.next());
                Assert.assertFalse((boolean)cursor.hasNext());
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testConcurrentWriterAndBackwardReadBreadth() throws Exception {
        this.testConcurrentBackwardRW(10000000, 1024);
    }

    @Test
    public void testConcurrentWriterAndBackwardReadHeight() throws Exception {
        this.testConcurrentBackwardRW(1000000, 100000);
    }

    @Test
    public void testConcurrentWriterAndForwardReadBreadth() throws Exception {
        this.testConcurrentForwardRW(10000000, 1024);
    }

    @Test
    public void testConcurrentWriterAndForwardReadHeight() throws Exception {
        this.testConcurrentForwardRW(1000000, 100000);
    }

    @Test
    public void testEmptyCursor() {
        EmptyRowCursor cursor = new EmptyRowCursor();
        Assert.assertFalse((boolean)cursor.hasNext());
        Assert.assertEquals((long)0L, (long)cursor.next());
    }

    @Test
    public void testForwardCursorTimeout() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            BitmapIndexTest.create(configuration, this.path.trimTo(this.plen), "x", 1024);
            try (BitmapIndexWriter w = new BitmapIndexWriter(configuration, this.path.trimTo(this.plen), (CharSequence)"x");){
                w.add(0, 10L);
            }
            var2_2 = null;
            try (BitmapIndexFwdReader reader = new BitmapIndexFwdReader(configuration, this.path.trimTo(this.plen), (CharSequence)"x", 0L);
                 ReadWriteMemory mem = new ReadWriteMemory();){
                try (Path path = new Path();){
                    path.of(configuration.getRoot()).concat((CharSequence)"x").put((CharSequence)".k").$();
                    mem.of(configuration.getFilesFacade(), (LPSZ)path, configuration.getFilesFacade().getPageSize());
                }
                long offset = BitmapIndexUtils.getKeyEntryOffset((int)0);
                mem.jumpTo(offset + 0L);
                mem.putLong(10L);
                try {
                    reader.getCursor(true, 0, 0L, Long.MAX_VALUE);
                    Assert.fail();
                }
                catch (CairoException e) {
                    Assert.assertTrue((boolean)Chars.contains((CharSequence)e.getMessage(), (CharSequence)"cursor failed"));
                }
            }
            catch (Throwable throwable) {
                var2_2 = throwable;
                throw throwable;
            }
        });
    }

    @Test
    public void testForwardReaderDoesNotUnmapPages() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            Rnd rnd = new Rnd();
            BitmapIndexTest.create(configuration, this.path.trimTo(this.plen), "x", 1024);
            class CountingFacade
            extends FilesFacadeImpl {
                private int count = 0;

                CountingFacade() {
                }

                public long getMapPageSize() {
                    return 0x100000L;
                }

                public void munmap(long address, long size) {
                    super.munmap(address, size);
                    ++this.count;
                }
            }
            final CountingFacade facade = new CountingFacade();
            DefaultCairoConfiguration configuration = new DefaultCairoConfiguration(root){
                {
                    super(x0);
                }

                public FilesFacade getFilesFacade() {
                    return facade;
                }
            };
            try (BitmapIndexWriter writer = new BitmapIndexWriter((CairoConfiguration)configuration, this.path.trimTo(this.plen), (CharSequence)"x");
                 BitmapIndexFwdReader reader = new BitmapIndexFwdReader((CairoConfiguration)configuration, this.path.trimTo(this.plen), (CharSequence)"x", 0L);){
                for (int i = 0; i < 100000; ++i) {
                    int key = rnd.nextPositiveInt() % 1024;
                    long value = rnd.nextPositiveLong();
                    writer.add(key, value);
                    RowCursor cursor = reader.getCursor(true, key, 0L, Long.MAX_VALUE);
                    boolean found = false;
                    while (cursor.hasNext()) {
                        if (value != cursor.next()) continue;
                        found = true;
                        break;
                    }
                    Assert.assertTrue((boolean)found);
                }
                Assert.assertEquals((long)0L, (long)facade.count);
            }
        });
    }

    @Test
    public void testForwardReaderKeyUpdateFail() {
        BitmapIndexTest.create(configuration, this.path.trimTo(this.plen), "x", 1024);
        try (BitmapIndexWriter writer = new BitmapIndexWriter(configuration, this.path, (CharSequence)"x");){
            writer.add(0, 1000L);
        }
        var2_2 = null;
        try (BitmapIndexFwdReader reader = new BitmapIndexFwdReader(configuration, this.path.trimTo(this.plen), (CharSequence)"x", 0L);){
            RowCursor cursor = reader.getCursor(true, 0, 0L, Long.MAX_VALUE);
            Assert.assertTrue((boolean)cursor.hasNext());
            Assert.assertEquals((long)1000L, (long)cursor.next());
            Assert.assertFalse((boolean)cursor.hasNext());
            try (Path path = new Path();
                 ReadWriteMemory mem = new ReadWriteMemory(configuration.getFilesFacade(), (LPSZ)path.of(root).concat((CharSequence)"x").put((CharSequence)".k").$(), configuration.getFilesFacade().getPageSize());){
                long seq = mem.getLong(1L);
                mem.jumpTo(1L);
                mem.putLong(22L);
                try {
                    reader.getCursor(true, 10, 0L, Long.MAX_VALUE);
                    Assert.fail();
                }
                catch (CairoException e) {
                    Assert.assertTrue((boolean)Chars.contains((CharSequence)e.getMessage(), (CharSequence)"failed to consistently"));
                }
                try {
                    reader.getCursor(true, 0, 0L, Long.MAX_VALUE);
                    Assert.fail();
                }
                catch (CairoException e) {
                    Assert.assertTrue((boolean)Chars.contains((CharSequence)e.getMessage(), (CharSequence)"failed to consistently"));
                }
                mem.jumpTo(1L);
                mem.putLong(seq);
                cursor = reader.getCursor(true, 0, 0L, Long.MAX_VALUE);
                Assert.assertTrue((boolean)cursor.hasNext());
                Assert.assertEquals((long)1000L, (long)cursor.next());
                Assert.assertFalse((boolean)cursor.hasNext());
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testIndexDoesNotExist() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try {
                new BitmapIndexWriter(configuration, this.path, (CharSequence)"x");
                Assert.fail();
            }
            catch (CairoException e) {
                Assert.assertTrue((boolean)Chars.contains((CharSequence)e.getMessage(), (CharSequence)"does not exist"));
            }
        });
    }

    @Test
    public void testIntIndex() throws Exception {
        int plen = this.path.length();
        Rnd rnd = new Rnd();
        int N = 100000000;
        int MOD = 1024;
        TestUtils.assertMemoryLeak(() -> {
            try (AppendMemory mem = new AppendMemory();){
                mem.of(configuration.getFilesFacade(), (LPSZ)this.path.concat((CharSequence)"x.dat").$(), configuration.getFilesFacade().getMapPageSize());
                for (int i = 0; i < N; ++i) {
                    mem.putInt(rnd.nextPositiveInt() & 0x3FF);
                }
                try (SlidingWindowMemory rwin = new SlidingWindowMemory();){
                    rwin.of(mem);
                    BitmapIndexTest.create(configuration, this.path.trimTo(plen), "x", N / 1024 / 128);
                    try (BitmapIndexWriter writer = new BitmapIndexWriter();){
                        writer.of(configuration, this.path.trimTo(plen), (CharSequence)"x");
                        BitmapIndexTest.indexInts(rwin, writer, N);
                    }
                }
            }
        });
    }

    @Test
    public void testLimitBackwardCursor() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            BitmapIndexTest.create(configuration, this.path.trimTo(this.plen), "x", 128);
            try (BitmapIndexWriter writer = new BitmapIndexWriter(configuration, this.path.trimTo(this.plen), (CharSequence)"x");){
                for (int i = 0; i < 265; ++i) {
                    if (i % 3 == 0) continue;
                    writer.add(0, (long)i);
                    writer.add(0, (long)i);
                    writer.add(0, (long)i);
                }
            }
            LongList tmp = new LongList();
            try (BitmapIndexBwdReader reader = new BitmapIndexBwdReader(configuration, this.path.trimTo(this.plen), (CharSequence)"x", 0L);){
                this.assertBackwardCursorLimit(reader, 260L, tmp);
                this.assertBackwardCursorLimit(reader, 16L, tmp);
                this.assertBackwardCursorLimit(reader, 9L, tmp);
                Assert.assertFalse((boolean)reader.getCursor(true, 0, -1L, -1L).hasNext());
            }
        });
    }

    @Test
    public void testLimitForwardCursor() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            BitmapIndexTest.create(configuration, this.path.trimTo(this.plen), "x", 128);
            int N = 265;
            try (BitmapIndexWriter writer = new BitmapIndexWriter(configuration, this.path.trimTo(this.plen), (CharSequence)"x");){
                for (int i = 0; i < N; ++i) {
                    if (i % 3 == 0) continue;
                    writer.add(0, (long)i);
                    writer.add(0, (long)i);
                    writer.add(0, (long)i);
                }
            }
            LongList tmp = new LongList();
            try (BitmapIndexFwdReader reader = new BitmapIndexFwdReader(configuration, this.path.trimTo(this.plen), (CharSequence)"x", 0L);){
                this.assertForwardCursorLimit(reader, 260, N - 2, tmp);
                this.assertForwardCursorLimit(reader, 16, N, tmp);
                this.assertForwardCursorLimit(reader, 9, N, tmp);
                Assert.assertFalse((boolean)reader.getCursor(true, 0, 266L, Long.MAX_VALUE).hasNext());
                Assert.assertFalse((boolean)reader.getCursor(true, 0, Long.MAX_VALUE, Long.MAX_VALUE).hasNext());
            }
        });
    }

    @Test
    public void testSimpleRollback() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            int v;
            LongList list;
            RowCursor cursor;
            int key;
            int n;
            int i3;
            Object list2;
            Rnd modelRnd = new Rnd();
            int maxKeys = 1024;
            int N = 1000000;
            int CUTOFF = 60000;
            IntList keys = new IntList();
            IntObjHashMap lists = new IntObjHashMap();
            for (int i2 = 0; i2 < 1000000; ++i2) {
                int key2 = modelRnd.nextPositiveInt() % 1024;
                list2 = (LongList)lists.get(key2);
                if (list2 == null) {
                    list2 = new LongList();
                    lists.put(key2, list2);
                    keys.add(key2);
                }
                if (i2 > 60000) continue;
                list2.add((long)i2);
            }
            Rnd rnd = new Rnd();
            BitmapIndexTest.create(configuration, this.path.trimTo(this.plen), "x", 1024);
            BitmapIndexWriter writer = new BitmapIndexWriter(configuration, this.path.trimTo(this.plen), (CharSequence)"x");
            list2 = null;
            try {
                for (i3 = 0; i3 < 1000000; ++i3) {
                    writer.add(rnd.nextPositiveInt() % 1024, (long)i3);
                }
                writer.rollbackValues(60000L);
            }
            catch (Throwable i3) {
                list2 = i3;
                throw i3;
            }
            finally {
                if (writer != null) {
                    if (list2 != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable i3) {
                            ((Throwable)list2).addSuppressed(i3);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
            BitmapIndexBwdReader reader = new BitmapIndexBwdReader(configuration, this.path.trimTo(this.plen), (CharSequence)"x", 0L);
            list2 = null;
            try {
                n = keys.size();
                for (i3 = 0; i3 < n; ++i3) {
                    key = keys.getQuick(i3);
                    cursor = reader.getCursor(true, key, 0L, Long.MAX_VALUE);
                    list = (LongList)lists.get(key);
                    v = list.size();
                    while (cursor.hasNext()) {
                        Assert.assertEquals((long)list.getQuick(--v), (long)cursor.next());
                    }
                    Assert.assertEquals((long)0L, (long)v);
                }
            }
            catch (Throwable i4) {
                list2 = i4;
                throw i4;
            }
            finally {
                if (reader != null) {
                    if (list2 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable i4) {
                            ((Throwable)list2).addSuppressed(i4);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
            reader = new BitmapIndexFwdReader(configuration, this.path.trimTo(this.plen), (CharSequence)"x", 0L);
            list2 = null;
            try {
                n = keys.size();
                for (int i5 = 0; i5 < n; ++i5) {
                    key = keys.getQuick(i5);
                    cursor = reader.getCursor(true, key, 0L, Long.MAX_VALUE);
                    list = (LongList)lists.get(key);
                    v = 0;
                    while (cursor.hasNext()) {
                        Assert.assertEquals((long)list.getQuick(v++), (long)cursor.next());
                    }
                    Assert.assertEquals((long)list.size(), (long)v);
                }
            }
            catch (Throwable i5) {
                list2 = i5;
                throw i5;
            }
            finally {
                if (reader != null) {
                    if (list2 != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable i5) {
                            ((Throwable)list2).addSuppressed(i5);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
            for (int i6 = 0; i6 < 1000000; ++i6) {
                int key3 = modelRnd.nextPositiveInt() % 1024;
                LongList list3 = (LongList)lists.get(key3);
                if (list3 == null) {
                    list3 = new LongList();
                    lists.put(key3, (Object)list3);
                    keys.add(key3);
                }
                list3.add((long)(i6 + 1000000));
            }
            writer = new BitmapIndexWriter(configuration, this.path.trimTo(this.plen), (CharSequence)"x");
            Throwable throwable = null;
            try {
                for (int i7 = 0; i7 < 1000000; ++i7) {
                    writer.add(rnd.nextPositiveInt() % 1024, (long)(i7 + 1000000));
                }
            }
            catch (Throwable i7) {
                throwable = i7;
                throw i7;
            }
            finally {
                if (writer != null) {
                    if (throwable != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable i7) {
                            throwable.addSuppressed(i7);
                        }
                    } else {
                        writer.close();
                    }
                }
            }
            reader = new BitmapIndexBwdReader(configuration, this.path.trimTo(this.plen), (CharSequence)"x", 0L);
            throwable = null;
            try {
                n = keys.size();
                for (int i8 = 0; i8 < n; ++i8) {
                    key = keys.getQuick(i8);
                    cursor = reader.getCursor(true, key, 0L, Long.MAX_VALUE);
                    list = (LongList)lists.get(key);
                    v = list.size();
                    while (cursor.hasNext()) {
                        Assert.assertEquals((long)list.getQuick(--v), (long)cursor.next());
                    }
                    Assert.assertEquals((long)0L, (long)v);
                }
            }
            catch (Throwable i8) {
                throwable = i8;
                throw i8;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable i8) {
                            throwable.addSuppressed(i8);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
            reader = new BitmapIndexFwdReader(configuration, this.path.trimTo(this.plen), (CharSequence)"x", 0L);
            throwable = null;
            try {
                n = keys.size();
                for (int i9 = 0; i9 < n; ++i9) {
                    key = keys.getQuick(i9);
                    cursor = reader.getCursor(true, key, 0L, Long.MAX_VALUE);
                    list = (LongList)lists.get(key);
                    v = 0;
                    while (cursor.hasNext()) {
                        Assert.assertEquals((long)list.getQuick(v++), (long)cursor.next());
                    }
                    Assert.assertEquals((long)list.size(), (long)v);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader != null) {
                    if (throwable != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        reader.close();
                    }
                }
            }
        });
    }

    @Test
    public void testWriterConstructorBadSequence() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            this.setupIndexHeader();
            this.assertWriterConstructorFail("Sequence mismatch");
        });
    }

    @Test
    public void testWriterConstructorBadSig() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (AppendMemory mem = this.openKey();){
                mem.skip(64L);
            }
            this.assertWriterConstructorFail("Unknown format");
        });
    }

    @Test
    public void testWriterConstructorFileTooSmall() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            this.openKey().close();
            this.assertWriterConstructorFail("Index file too short");
        });
    }

    @Test
    public void testWriterConstructorIncorrectValueCount() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (AppendMemory mem = this.openKey();){
                mem.putByte((byte)-6);
                mem.skip(9L);
                mem.putLong(1000L);
                mem.skip(4L);
                mem.putLong(0L);
                mem.skip(64L - mem.getAppendOffset());
            }
            this.assertWriterConstructorFail("Incorrect file size");
        });
    }

    @Test
    public void testWriterConstructorKeyMismatch() throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            try (AppendMemory mem = this.openKey();){
                mem.putByte((byte)-6);
                mem.skip(20L);
                mem.putLong(300L);
                mem.skip(64L - mem.getAppendOffset());
            }
            this.assertWriterConstructorFail("Key count");
        });
    }

    private static void indexInts(SlidingWindowMemory srcMem, BitmapIndexWriter writer, long hi) {
        srcMem.updateSize();
        for (long r = 0L; r < hi; ++r) {
            long offset = r * 4L;
            writer.add(srcMem.getInt(offset), offset);
        }
    }

    private void assertBackwardCursorLimit(BitmapIndexBwdReader reader, long max, LongList tmp) {
        tmp.clear();
        RowCursor cursor = reader.getCursor(true, 0, 0L, max);
        while (cursor.hasNext()) {
            tmp.add(cursor.next());
        }
        int len = tmp.size();
        int i = 0;
        while ((long)i < max) {
            if (i % 3 != 0) {
                Assert.assertEquals((long)i, (long)tmp.getQuick(--len));
                Assert.assertEquals((long)i, (long)tmp.getQuick(--len));
                Assert.assertEquals((long)i, (long)tmp.getQuick(--len));
            }
            ++i;
        }
    }

    private void assertBackwardReaderConstructorFail(CharSequence contains) {
        try {
            new BitmapIndexBwdReader(configuration, this.path.trimTo(this.plen), (CharSequence)"x", 0L);
            Assert.fail();
        }
        catch (CairoException e) {
            Assert.assertTrue((boolean)Chars.contains((CharSequence)e.getMessage(), (CharSequence)contains));
        }
    }

    private void assertForwardCursorLimit(BitmapIndexFwdReader reader, int min, int N, LongList tmp) {
        tmp.clear();
        RowCursor cursor = reader.getCursor(true, 0, (long)min, (long)(N - 1));
        while (cursor.hasNext()) {
            tmp.add(cursor.next());
        }
        int len = 0;
        for (int i = min; i < N; ++i) {
            if (i % 3 == 0) continue;
            Assert.assertEquals((long)i, (long)tmp.getQuick(len++));
            Assert.assertEquals((long)i, (long)tmp.getQuick(len++));
            Assert.assertEquals((long)i, (long)tmp.getQuick(len++));
        }
    }

    private void assertForwardReaderConstructorFail(CharSequence contains) {
        try {
            new BitmapIndexFwdReader(configuration, this.path.trimTo(this.plen), (CharSequence)"x", 0L);
            Assert.fail();
        }
        catch (CairoException e) {
            Assert.assertTrue((boolean)Chars.contains((CharSequence)e.getMessage(), (CharSequence)contains));
        }
    }

    private void assertThat(String expected, RowCursor cursor, LongList temp) {
        temp.clear();
        while (cursor.hasNext()) {
            temp.add(cursor.next());
        }
        Assert.assertEquals((Object)expected, (Object)temp.toString());
    }

    private void assertWriterConstructorFail(CharSequence contains) {
        try {
            new BitmapIndexWriter(configuration, this.path.trimTo(this.plen), (CharSequence)"x");
            Assert.fail();
        }
        catch (CairoException e) {
            Assert.assertTrue((boolean)Chars.contains((CharSequence)e.getMessage(), (CharSequence)contains));
        }
    }

    private AppendMemory openKey() {
        try (Path path = new Path();){
            AppendMemory appendMemory = new AppendMemory(configuration.getFilesFacade(), (LPSZ)path.of(configuration.getRoot()).concat((CharSequence)"x").put((CharSequence)".k").$(), configuration.getFilesFacade().getPageSize());
            return appendMemory;
        }
    }

    private void setupIndexHeader() {
        try (AppendMemory mem = this.openKey();){
            mem.putByte((byte)-6);
            mem.putLong(10L);
            mem.putLong(0L);
            mem.putInt(64);
            mem.putLong(0L);
            mem.putLong(9L);
            mem.skip(64L - mem.getAppendOffset());
        }
    }

    private void testConcurrentBackwardRW(int N, int maxKeys) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            Rnd rnd = new Rnd();
            final IntList keys = new IntList();
            final IntObjHashMap lists = new IntObjHashMap();
            for (int i = 0; i < N; ++i) {
                int key = rnd.nextPositiveInt() % maxKeys;
                LongList list = (LongList)lists.get(key);
                if (list == null) {
                    list = new LongList();
                    lists.put(key, (Object)list);
                    keys.add(key);
                }
                list.add((long)i);
            }
            int threadCount = 3;
            final CountDownLatch stopLatch = new CountDownLatch(3);
            final CyclicBarrier startBarrier = new CyclicBarrier(3);
            final AtomicInteger errors = new AtomicInteger();
            BitmapIndexTest.create(configuration, this.path.trimTo(this.plen), "x", 1024);
            new Thread(() -> {
                try {
                    startBarrier.await();
                    try (Path path = new Path().of(configuration.getRoot());
                         BitmapIndexWriter writer = new BitmapIndexWriter(configuration, path, (CharSequence)"x");){
                        boolean added;
                        int pass = 0;
                        do {
                            added = false;
                            int n = keys.size();
                            for (int i = 0; i < n; ++i) {
                                int key = keys.getQuick(i);
                                LongList values = (LongList)lists.get(key);
                                if (pass >= values.size()) continue;
                                writer.add(key, values.getQuick(pass));
                                added = true;
                            }
                            ++pass;
                        } while (added);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    stopLatch.countDown();
                }
            }).start();
            class MyReader
            implements Runnable {
                MyReader() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        startBarrier.await();
                        try (Path path = new Path().of(AbstractCairoTest.configuration.getRoot());
                             BitmapIndexBwdReader reader1 = new BitmapIndexBwdReader(AbstractCairoTest.configuration, path, (CharSequence)"x", 0L);){
                            boolean keepGoing;
                            LongList tmp = new LongList();
                            do {
                                keepGoing = false;
                                for (int i = keys.size() - 1; i > -1; --i) {
                                    int key = keys.getQuick(i);
                                    LongList values = (LongList)lists.get(key);
                                    RowCursor cursor = reader1.getCursor(true, key, 0L, Long.MAX_VALUE);
                                    tmp.clear();
                                    while (cursor.hasNext()) {
                                        tmp.add(cursor.next());
                                    }
                                    int sz = tmp.size();
                                    for (int k = 0; k < sz; ++k) {
                                        Assert.assertEquals((long)values.getQuick(sz - k - 1), (long)tmp.getQuick(k));
                                    }
                                    if (sz >= values.size()) continue;
                                    keepGoing = true;
                                }
                            } while (keepGoing);
                        }
                    }
                    catch (Throwable e) {
                        errors.incrementAndGet();
                        e.printStackTrace();
                    }
                    finally {
                        stopLatch.countDown();
                    }
                }
            }
            new Thread(new MyReader()).start();
            new Thread(new MyReader()).start();
            Assert.assertTrue((boolean)stopLatch.await(20000L, TimeUnit.SECONDS));
            Assert.assertEquals((long)0L, (long)errors.get());
        });
    }

    private void testConcurrentForwardRW(int N, int maxKeys) throws Exception {
        TestUtils.assertMemoryLeak(() -> {
            Rnd rnd = new Rnd();
            final IntList keys = new IntList();
            final IntObjHashMap lists = new IntObjHashMap();
            for (int i = 0; i < N; ++i) {
                int key = rnd.nextPositiveInt() % maxKeys;
                LongList list = (LongList)lists.get(key);
                if (list == null) {
                    list = new LongList();
                    lists.put(key, (Object)list);
                    keys.add(key);
                }
                list.add((long)i);
            }
            int threadCount = 3;
            final CountDownLatch stopLatch = new CountDownLatch(3);
            final CyclicBarrier startBarrier = new CyclicBarrier(3);
            final AtomicInteger errors = new AtomicInteger();
            BitmapIndexTest.create(configuration, this.path.trimTo(this.plen), "x", 1024);
            new Thread(() -> {
                try {
                    startBarrier.await();
                    try (Path path = new Path().of(configuration.getRoot());
                         BitmapIndexWriter writer = new BitmapIndexWriter(configuration, path, (CharSequence)"x");){
                        boolean added;
                        int pass = 0;
                        do {
                            added = false;
                            int n = keys.size();
                            for (int i = 0; i < n; ++i) {
                                int key = keys.getQuick(i);
                                LongList values = (LongList)lists.get(key);
                                if (pass >= values.size()) continue;
                                writer.add(key, values.getQuick(pass));
                                added = true;
                            }
                            ++pass;
                        } while (added);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    errors.incrementAndGet();
                }
                finally {
                    stopLatch.countDown();
                }
            }).start();
            class MyReader
            implements Runnable {
                MyReader() {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        startBarrier.await();
                        try (Path path = new Path().of(AbstractCairoTest.configuration.getRoot());
                             BitmapIndexFwdReader reader1 = new BitmapIndexFwdReader(AbstractCairoTest.configuration, path, (CharSequence)"x", 0L);){
                            boolean keepGoing;
                            LongList tmp = new LongList();
                            do {
                                keepGoing = false;
                                for (int i = keys.size() - 1; i > -1; --i) {
                                    int key = keys.getQuick(i);
                                    LongList values = (LongList)lists.get(key);
                                    RowCursor cursor = reader1.getCursor(true, key, 0L, Long.MAX_VALUE);
                                    tmp.clear();
                                    while (cursor.hasNext()) {
                                        tmp.add(cursor.next());
                                    }
                                    int sz = tmp.size();
                                    for (int k = 0; k < sz; ++k) {
                                        Assert.assertEquals((long)values.getQuick(k), (long)tmp.getQuick(k));
                                    }
                                    if (sz >= values.size()) continue;
                                    keepGoing = true;
                                }
                            } while (keepGoing);
                        }
                    }
                    catch (Throwable e) {
                        errors.incrementAndGet();
                        e.printStackTrace();
                    }
                    finally {
                        stopLatch.countDown();
                    }
                }
            }
            new Thread(new MyReader()).start();
            new Thread(new MyReader()).start();
            Assert.assertTrue((boolean)stopLatch.await(20000L, TimeUnit.SECONDS));
            Assert.assertEquals((long)0L, (long)errors.get());
        });
    }
}

