/*
 * Decompiled with CFR 0.152.
 */
package com.questdb.cairo;

import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.DefaultCairoConfiguration;
import com.questdb.cairo.RecordCursorPrinter;
import com.questdb.cairo.sql.RecordCursor;
import com.questdb.cairo.sql.RecordMetadata;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.Files;
import com.questdb.std.str.CharSink;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.Path;
import com.questdb.std.str.StringSink;
import com.questdb.test.tools.TestUtils;
import java.io.IOException;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.rules.TemporaryFolder;

public class AbstractCairoTest {
    protected static final StringSink sink = new StringSink();
    protected static final RecordCursorPrinter printer = new RecordCursorPrinter((CharSink)sink);
    private static final Log LOG = LogFactory.getLog(AbstractCairoTest.class);
    @ClassRule
    public static TemporaryFolder temp = new TemporaryFolder();
    protected static CharSequence root;
    protected static CairoConfiguration configuration;

    @BeforeClass
    public static void setUp() {
        LOG.info().$((CharSequence)"begin").$();
        root = temp.getRoot().getAbsolutePath();
        configuration = new DefaultCairoConfiguration(root);
    }

    @Before
    public void setUp0() {
        try (Path path = new Path().of(root).$();){
            if (Files.exists((LPSZ)path)) {
                return;
            }
            Files.mkdirs((LPSZ)path.of(root).put(Files.SEPARATOR).$(), (int)configuration.getMkDirMode());
        }
    }

    @After
    public void tearDown0() {
        try (Path path = new Path().of(root);){
            Files.rmdir((Path)path.$());
        }
    }

    protected void assertOnce(CharSequence expected, RecordCursor cursor, RecordMetadata metadata, boolean header) throws IOException {
        sink.clear();
        printer.print(cursor, metadata, header);
        TestUtils.assertEquals(expected, (CharSequence)sink);
    }

    protected void assertThat(CharSequence expected, RecordCursor cursor, RecordMetadata metadata, boolean header) throws IOException {
        this.assertOnce(expected, cursor, metadata, header);
        cursor.toTop();
        this.assertOnce(expected, cursor, metadata, header);
    }
}

