/*
 * Decompiled with CFR 0.152.
 */
package com.questdb;

import com.questdb.cairo.CairoConfiguration;
import com.questdb.cairo.CairoTestUtils;
import com.questdb.cairo.DefaultCairoConfiguration;
import com.questdb.cairo.TableModel;
import com.questdb.cairo.TableReader;
import com.questdb.cairo.TableReaderRecordCursor;
import com.questdb.cairo.TableWriter;
import com.questdb.ex.ParserException;
import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.model.Quote;
import com.questdb.parser.sql.QueryCompiler;
import com.questdb.ql.RecordSource;
import com.questdb.std.LongList;
import com.questdb.std.NumericException;
import com.questdb.std.Rnd;
import com.questdb.std.ex.JournalException;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.store.Interval;
import com.questdb.store.Journal;
import com.questdb.store.JournalIterators;
import com.questdb.store.JournalWriter;
import com.questdb.store.KVIndex;
import com.questdb.store.Record;
import com.questdb.store.RecordCursor;
import com.questdb.store.factory.Factory;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.query.api.QueryAllBuilder;
import com.questdb.store.query.api.QueryHeadBuilder;
import com.questdb.store.query.iter.JournalPeekingIterator;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class PerformanceTest
extends AbstractTest {
    private static final int TEST_DATA_SIZE = 1000000;
    private static final Log LOG = LogFactory.getLog(PerformanceTest.class);
    private static boolean enabled = false;

    @BeforeClass
    public static void setUp() {
        enabled = System.getProperty("questdb.enable.perf.tests") != null;
    }

    @Test
    public void testAllBySymbolValueOverInterval() throws JournalException, NumericException {
        try (JournalWriter w = this.getFactory().writer(Quote.class, null, 1000000);){
            TestUtils.generateQuoteData((JournalWriter<Quote>)w, 1000000, DateFormatUtils.parseDateTime((CharSequence)"2013-10-05T10:00:00.000Z"), 1000L);
            w.commit();
        }
        var2_2 = null;
        try (Journal journal = this.getFactory().reader(Quote.class);){
            int count = 1000;
            Interval interval = new Interval(DateFormatUtils.parseDateTime((CharSequence)"2013-10-15T10:00:00.000Z"), DateFormatUtils.parseDateTime((CharSequence)"2013-10-05T10:00:00.000Z"));
            long t = 0L;
            QueryAllBuilder builder = journal.query().all().withKeys(new String[]{"LLOY.L"}).slice(interval);
            for (int i = -1000; i < count; ++i) {
                if (i == 0) {
                    t = System.nanoTime();
                }
                builder.asResultSet();
            }
            LOG.info().$((CharSequence)"journal.query().all().withKeys(\"LLOY.L\").slice(interval) (query only) latency: ").$((System.nanoTime() - t) / (long)count / 1000L).$((CharSequence)"\u03bcs").$();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllBySymbolValueOverIntervalNew() throws JournalException, ParserException, NumericException {
        try (JournalWriter w = this.getFactory().writer(Quote.class, "quote", 1000000);){
            TestUtils.generateQuoteData((JournalWriter<Quote>)w, 1000000, DateFormatUtils.parseDateTime((CharSequence)"2013-10-05T10:00:00.000Z"), 1000L);
            w.commit();
        }
        QueryCompiler compiler = new QueryCompiler();
        Factory factory = this.getFactory();
        try (RecordSource src = compiler.compile(factory, (CharSequence)"quote where timestamp = '2013-10-05T10:00:00.000Z;10d' and sym = 'LLOY.L'");){
            int count = 1000;
            long t = 0L;
            for (int i = -count; i < count; ++i) {
                if (i == 0) {
                    t = System.nanoTime();
                }
                RecordCursor c = src.prepareCursor((ReaderFactory)factory);
                try {
                    while (c.hasNext()) {
                        c.next();
                    }
                    continue;
                }
                finally {
                    c.releaseCursor();
                }
            }
            LOG.info().$((CharSequence)"NEW journal.query().all().withKeys(\"LLOY.L\").slice(interval) (query only) latency: ").$((System.nanoTime() - t) / (long)count / 1000L).$((CharSequence)"\u03bcs").$();
        }
    }

    @Test
    public void testCairoPerformance() throws NumericException {
        long result;
        int count = 10;
        long t = 0L;
        DefaultCairoConfiguration configuration = new DefaultCairoConfiguration((CharSequence)this.getFactory().getConfiguration().getJournalBase().getAbsolutePath());
        String[] symbols = new String[]{"AGK.L", "BP.L", "TLW.L", "ABF.L", "LLOY.L", "BT-A.L", "WTB.L", "RRS.L", "ADM.L", "GKN.L", "HSBA.L"};
        try (TableModel model = new TableModel((CairoConfiguration)configuration, "quote", 3).timestamp().col("sym", 8).col("bid", 6).col("ask", 6).col("bidSize", 3).col("askSize", 3).col("mode", 8).symbolCapacity(2).col("ex", 8).symbolCapacity(2);){
            CairoTestUtils.create(model);
        }
        var9_6 = null;
        try (TableWriter w = new TableWriter((CairoConfiguration)configuration, (CharSequence)"quote");){
            for (int i = -count; i < count; ++i) {
                if (i == 0) {
                    t = System.nanoTime();
                }
                w.truncate();
                long timestamp = DateFormatUtils.parseDateTime((CharSequence)"2013-10-05T10:00:00.000Z");
                Rnd r = new Rnd();
                int n = symbols.length - 1;
                for (int i1 = 0; i1 < 1000000; ++i1) {
                    TableWriter.Row row = w.newRow(timestamp);
                    row.putSym(1, (CharSequence)symbols[Math.abs(r.nextInt() % n)]);
                    row.putDouble(2, Math.abs(r.nextDouble2()));
                    row.putDouble(3, Math.abs(r.nextDouble2()));
                    row.putInt(4, Math.abs(r.nextInt()));
                    row.putInt(5, Math.abs(r.nextInt()));
                    row.putSym(6, (CharSequence)"LXE");
                    row.putSym(7, (CharSequence)"Fast trading");
                    row.append();
                    timestamp += 1000L;
                }
                w.commit();
            }
            result = System.nanoTime() - t;
        }
        catch (Throwable i) {
            var9_6 = i;
            throw i;
        }
        LOG.info().$((CharSequence)"Cairo append (1M): ").$(TimeUnit.NANOSECONDS.toMillis(result / (long)count)).$((CharSequence)"ms").$();
        var9_6 = null;
        try (TableReader reader = new TableReader((CairoConfiguration)configuration, (CharSequence)"quote");){
            for (int i = -count; i < count; ++i) {
                if (i == 0) {
                    t = System.nanoTime();
                }
                TableReaderRecordCursor cursor = reader.getCursor();
                com.questdb.cairo.sql.Record record = cursor.getRecord();
                while (cursor.hasNext()) {
                    record.getDate(0);
                    record.getSym(1);
                    record.getDouble(2);
                    record.getDouble(3);
                    record.getInt(4);
                    record.getInt(5);
                    record.getSym(6);
                    record.getSym(7);
                }
            }
            result = (System.nanoTime() - t) / (long)count;
        }
        catch (Throwable throwable) {
            var9_6 = throwable;
            throw throwable;
        }
        LOG.info().$((CharSequence)"Cairo read (1M): ").$(TimeUnit.NANOSECONDS.toMillis(result)).$((CharSequence)"ms").$();
    }

    @Test
    public void testIndexAppendAndReadSpeed() throws JournalException {
        File indexFile = new File(this.getFactory().getConfiguration().getJournalBase(), "index-test");
        int totalKeys = 30000;
        int totalValues = 20000000;
        try (KVIndex index = new KVIndex(indexFile, (long)totalKeys, (long)totalValues, 1, 2, 0L, false);){
            long valuesPerKey = totalValues / totalKeys;
            long t = System.nanoTime();
            long count = 0L;
            for (int k = 0; k < totalKeys; ++k) {
                int v = 0;
                while ((long)v < valuesPerKey) {
                    index.add(k, (long)k * valuesPerKey + (long)v);
                    ++count;
                    ++v;
                }
            }
            Assert.assertEquals((long)count, (long)index.size());
            t = System.nanoTime() - t;
            LOG.info().$((CharSequence)"index append latency: ").$(t / (long)totalValues).$((CharSequence)"ns").$();
            if (enabled) {
                Assert.assertTrue((String)("~20M items must be appended under 1s: " + TimeUnit.NANOSECONDS.toMillis(t)), (TimeUnit.NANOSECONDS.toMillis(t) < 1000L ? 1 : 0) != 0);
            }
            for (int i = -10; i < 10; ++i) {
                if (i == 0) {
                    t = System.nanoTime();
                }
                index.getValueCount(1025);
            }
            t = System.nanoTime() - t;
            LOG.info().$((CharSequence)"index value count lookup latency: ").$(t / 10L).$((CharSequence)"ns").$();
            if (enabled) {
                Assert.assertTrue((String)("Count lookup must be under 150ns: " + t), (t / 10L < 150L ? 1 : 0) != 0);
            }
            LongList list = new LongList();
            for (int i = -10; i < 10; ++i) {
                if (i == 0) {
                    t = System.nanoTime();
                }
                index.getValues(13567 + i, list);
            }
            t = System.nanoTime() - t;
            LOG.info().$((CharSequence)"index values lookup latency: ").$(t / 10L).$((CharSequence)"ns").$();
            if (enabled) {
                Assert.assertTrue((String)("Values lookup must be under 1.5\u03bcs: " + t / 10L), (t / 10L < 1500L ? 1 : 0) != 0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJournalAppendAndReadSpeed() throws JournalException, ParserException, NumericException {
        long result;
        int count = 10;
        long t = 0L;
        try (JournalWriter w = this.getFactory().writer(Quote.class, "quote", 1000000);){
            int i;
            for (i = -count; i < count; ++i) {
                w.truncate();
                if (i == 0) {
                    t = System.nanoTime();
                }
                TestUtils.generateQuoteData((JournalWriter<Quote>)w, 1000000, DateFormatUtils.parseDateTime((CharSequence)"2013-10-05T10:00:00.000Z"), 1000L);
                w.commit();
            }
            result = System.nanoTime() - t;
            LOG.info().$((CharSequence)"append (1M): ").$(TimeUnit.NANOSECONDS.toMillis(result / (long)count)).$((CharSequence)"ms").$();
            if (enabled) {
                Assert.assertTrue((String)("Append speed must be under 400ms (" + TimeUnit.NANOSECONDS.toMillis(result) + ")"), (TimeUnit.NANOSECONDS.toMillis(result) < 400L ? 1 : 0) != 0);
            }
            for (i = -count; i < count; ++i) {
                if (i == 0) {
                    t = System.nanoTime();
                }
                JournalPeekingIterator iterator = JournalIterators.bufferedIterator((Journal)w);
                int cnt = 0;
                while (iterator.hasNext()) {
                    iterator.next();
                    ++cnt;
                }
                Assert.assertEquals((long)1000000L, (long)cnt);
            }
            result = System.nanoTime() - t;
            LOG.info().$((CharSequence)"read (1M): ").$(TimeUnit.NANOSECONDS.toMillis(result / (long)count)).$((CharSequence)"ms").$();
            if (enabled) {
                Assert.assertTrue((String)("Read speed must be under 120ms (" + TimeUnit.NANOSECONDS.toMillis(result) + ")"), (TimeUnit.NANOSECONDS.toMillis(result) < 120L ? 1 : 0) != 0);
            }
        }
        Factory readerFactory = this.getFactory();
        try (RecordSource rs = this.compile("quote");){
            for (int i = -count; i < count; ++i) {
                if (i == 0) {
                    t = System.nanoTime();
                }
                RecordCursor s = rs.prepareCursor((ReaderFactory)readerFactory);
                try {
                    int cnt = 0;
                    for (Record r : s) {
                        r.getLong(0);
                        r.getSym(1);
                        r.getDouble(2);
                        r.getDouble(3);
                        r.getInt(4);
                        r.getInt(5);
                        r.getSym(6);
                        r.getSym(7);
                        ++cnt;
                    }
                    Assert.assertEquals((long)1000000L, (long)cnt);
                    continue;
                }
                finally {
                    s.releaseCursor();
                }
            }
        }
        result = System.nanoTime() - t;
        LOG.info().$((CharSequence)"generic read (1M): ").$(TimeUnit.NANOSECONDS.toMillis(result / (long)count)).$((CharSequence)"ms").$();
        if (enabled) {
            Assert.assertTrue((String)("Read speed must be under 60ms (" + TimeUnit.NANOSECONDS.toMillis(result) + ")"), (TimeUnit.NANOSECONDS.toMillis(result) < 60L ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLatestBySymbol() throws JournalException, NumericException {
        try (JournalWriter w = this.getFactory().writer(Quote.class, null, 1000000);){
            TestUtils.generateQuoteData((JournalWriter<Quote>)w, 1000000, DateFormatUtils.parseDateTime((CharSequence)"2013-10-05T10:00:00.000Z"), 1000L);
            w.commit();
        }
        var2_2 = null;
        try (Journal journal = this.getFactory().reader(Quote.class);){
            int count = 1000000;
            long t = 0L;
            QueryHeadBuilder qhb = journal.query().head().withKeys(new String[0]);
            for (int i = -100000; i < count; ++i) {
                if (i == 0) {
                    t = System.nanoTime();
                }
                qhb.asResultSet().read();
            }
            LOG.info().$((CharSequence)"journal.query().head().withKeys() (query+read) latency: ").$((System.nanoTime() - t) / (long)count).$((CharSequence)"ns").$();
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testRawAppendPerformance() throws JournalException, NumericException {
        try (JournalWriter w = this.getFactory().writer(Quote.class, "quote", 1000000);){
            long t = 0L;
            int count = 10;
            for (int i = -count; i < count; ++i) {
                w.truncate();
                if (i == 0) {
                    t = System.nanoTime();
                }
                TestUtils.generateQuoteData2((JournalWriter<Quote>)w, 1000000, DateFormatUtils.parseDateTime((CharSequence)"2013-10-05T10:00:00.000Z"), 1000L);
                w.commit();
            }
            long result = System.nanoTime() - t;
            LOG.info().$((CharSequence)"raw append (1M): ").$(TimeUnit.NANOSECONDS.toMillis(result / (long)count)).$((CharSequence)"ms").$();
        }
    }
}

