/*
 * Decompiled with CFR 0.152.
 */
package com.questdb;

import com.questdb.std.IntLongPriorityQueue;
import com.questdb.std.Rnd;
import com.questdb.store.IndexCursor;
import com.questdb.store.KVIndex;
import com.questdb.test.tools.AbstractTest;
import java.io.File;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class IntLongPriorityQueueTest
extends AbstractTest {
    private static final int totalKeys = 10;
    private static final int totalValues = 100;
    private File indexFile;

    @Before
    public void setUp() {
        this.indexFile = new File(this.factoryContainer.getConfiguration().getJournalBase(), "index-test");
    }

    @Test
    public void testIndexSort() throws Exception {
        int nStreams = 16;
        Rnd rnd = new Rnd();
        int totalLen = 0;
        try (KVIndex index = new KVIndex(this.indexFile, 10L, 100L, 1, 2, 0L, false);){
            for (int i = 0; i < 16; ++i) {
                int j;
                long[] values = new long[rnd.nextPositiveInt() % 1000];
                totalLen += values.length;
                for (j = 0; j < values.length; ++j) {
                    values[j] = rnd.nextPositiveLong() % 100L;
                }
                Arrays.sort(values);
                for (j = 0; j < values.length; ++j) {
                    index.add(i, values[j]);
                }
                index.commit();
            }
            long[] expected = new long[totalLen];
            int p = 0;
            for (int i = 0; i < 16; ++i) {
                KVIndex.FwdIndexCursor c = index.fwdCursor(i);
                while (c.hasNext()) {
                    expected[p++] = c.next();
                }
            }
            Arrays.sort(expected);
            IntLongPriorityQueue heap = new IntLongPriorityQueue();
            IndexCursor[] cursors = new IndexCursor[16];
            for (int i = 0; i < 16; ++i) {
                cursors[i] = index.newFwdCursor(i);
                if (!cursors[i].hasNext()) continue;
                heap.add(i, cursors[i].next());
            }
            p = 0;
            while (heap.hasNext()) {
                int idx = heap.popIndex();
                long v = cursors[idx].hasNext() ? heap.popAndReplace(idx, cursors[idx].next()) : heap.popValue();
                Assert.assertEquals((long)expected[p++], (long)v);
            }
        }
    }
}

