/*
 * Decompiled with CFR 0.152.
 */
package com.questdb;

import com.questdb.ex.JournalMetadataException;
import com.questdb.ql.RecordSource;
import com.questdb.std.ex.JournalException;
import com.questdb.store.Files;
import com.questdb.store.Journal;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalIterators;
import com.questdb.store.JournalWriter;
import com.questdb.store.Record;
import com.questdb.store.RecordCursor;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalMetadataBuilder;
import com.questdb.store.factory.configuration.JournalStructure;
import com.questdb.store.factory.configuration.MetadataBuilder;
import com.questdb.store.query.iter.JournalPeekingIterator;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import java.io.File;
import org.junit.Assert;
import org.junit.Test;

public class GenericInteropTest
extends AbstractTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGenericAll() throws Exception {
        try (JournalWriter writer = this.makeGenericWriter();){
            JournalEntryWriter w = writer.entryWriter();
            w.putSym(0, (CharSequence)"EURUSD");
            w.putDate(1, 19999L);
            w.putDouble(2, 1.24);
            w.putDouble(3, 1.25);
            w.putInt(4, 10000);
            w.putInt(5, 12000);
            w.putInt(6, 1);
            w.putStr(7, (CharSequence)"OK");
            w.putStr(8, (CharSequence)"system");
            w.putStr(9, (CharSequence)"EURUSD:GLOBAL");
            w.putBool(10, true);
            w.putNull(11);
            w.putLong(12, 13141516L);
            w.putShort(13, (short)25000);
            w.append();
            w = writer.entryWriter();
            w.putSym(0, (CharSequence)"EURUSD");
            w.putDate(1, 20000L);
            w.putDouble(2, 1.23);
            w.putDouble(3, 1.26);
            w.putInt(4, 11000);
            w.putInt(5, 13000);
            w.putInt(6, 2);
            w.putStr(7, (CharSequence)"STALE");
            w.putStr(8, (CharSequence)"system");
            w.putStr(9, (CharSequence)"EURUSD:GLOBAL");
            w.putBool(10, false);
            w.putNull(11);
            w.putLong(12, 23242526L);
            w.putShort(13, (short)30000);
            w.append();
            writer.commit();
        }
        var2_2 = null;
        try (RecordSource rs = this.compile("test");){
            RecordCursor cursor = rs.prepareCursor((ReaderFactory)this.getFactory());
            try {
                Assert.assertTrue((boolean)cursor.hasNext());
                Record e = (Record)cursor.next();
                Assert.assertNotNull((Object)e);
                Assert.assertEquals((Object)"EURUSD", (Object)e.getSym(0));
                Assert.assertEquals((long)19999L, (long)e.getDate(1));
                Assert.assertEquals((double)1.24, (double)e.getDouble(2), (double)1.0E-6);
                Assert.assertEquals((double)1.25, (double)e.getDouble(3), (double)1.0E-6);
                Assert.assertEquals((long)10000L, (long)e.getInt(4));
                Assert.assertEquals((long)12000L, (long)e.getInt(5));
                Assert.assertEquals((long)1L, (long)e.getByte(6));
                TestUtils.assertEquals((CharSequence)"OK", e.getFlyweightStr(7));
                TestUtils.assertEquals((CharSequence)"system", e.getFlyweightStr(8));
                TestUtils.assertEquals((CharSequence)"EURUSD:GLOBAL", e.getFlyweightStr(9));
                Assert.assertTrue((boolean)e.getBool(10));
                Assert.assertNull((Object)e.getFlyweightStr(11));
                Assert.assertEquals((long)13141516L, (long)e.getLong(12));
                Assert.assertEquals((long)25000L, (long)e.getShort(13));
                Assert.assertTrue((boolean)cursor.hasNext());
                e = (Record)cursor.next();
                Assert.assertNotNull((Object)e);
                Assert.assertEquals((Object)"EURUSD", (Object)e.getSym(0));
                Assert.assertEquals((long)20000L, (long)e.getDate(1));
                Assert.assertEquals((double)1.23, (double)e.getDouble(2), (double)1.0E-6);
                Assert.assertEquals((double)1.26, (double)e.getDouble(3), (double)1.0E-6);
                Assert.assertEquals((long)11000L, (long)e.getInt(4));
                Assert.assertEquals((long)13000L, (long)e.getInt(5));
                Assert.assertEquals((long)2L, (long)e.getByte(6));
                TestUtils.assertEquals((CharSequence)"STALE", e.getFlyweightStr(7));
                TestUtils.assertEquals((CharSequence)"system", e.getFlyweightStr(8));
                TestUtils.assertEquals((CharSequence)"EURUSD:GLOBAL", e.getFlyweightStr(9));
                Assert.assertFalse((boolean)e.getBool(10));
                Assert.assertNull((Object)e.getFlyweightStr(11));
                Assert.assertEquals((long)23242526L, (long)e.getLong(12));
                Assert.assertEquals((long)30000L, (long)e.getShort(13));
                Assert.assertFalse((boolean)cursor.hasNext());
            }
            finally {
                cursor.releaseCursor();
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testGenericStructureMismatch() throws Exception {
        try (JournalWriter writer = this.makeGenericWriter();){
            JournalEntryWriter w = writer.entryWriter();
            w.putSym(0, (CharSequence)"EURUSD");
            w.putDate(1, 19999L);
            w.putDouble(2, 1.24);
            w.putDouble(3, 1.25);
            w.putInt(4, 10000);
            w.putInt(5, 12000);
            w.putInt(6, 1);
            w.putStr(7, (CharSequence)"OK");
            w.putStr(8, (CharSequence)"system");
            w.putStr(9, (CharSequence)"EURUSD:GLOBAL");
            w.putBool(10, true);
            w.putNull(11);
            w.putLong(12, 13141516L);
            w.putShort(13, (short)25000);
            w.append();
            writer.commit();
        }
        try {
            this.getFactory().writer((MetadataBuilder)new JournalStructure("test"){
                {
                    this.$str("sym");
                    this.$date("created");
                }
            });
            Assert.fail((String)"Expected exception");
        }
        catch (JournalMetadataException journalMetadataException) {
            // empty catch block
        }
    }

    @Test
    public void testGenericWriteObjectRead() throws Exception {
        try (JournalWriter writer = this.makeGenericWriter();){
            JournalEntryWriter w = writer.entryWriter();
            w.putSym(0, (CharSequence)"EURUSD");
            w.putDate(1, 19999L);
            w.putDouble(2, 1.24);
            w.putDouble(3, 1.25);
            w.putInt(4, 10000);
            w.putInt(5, 12000);
            w.putInt(6, 1);
            w.putStr(7, (CharSequence)"OK");
            w.putStr(8, (CharSequence)"system");
            w.putStr(9, (CharSequence)"EURUSD:GLOBAL");
            w.putBool(10, true);
            w.putNull(11);
            w.putLong(12, 1234567L);
            w.putShort(13, (short)11000);
            w.append();
            writer.commit();
        }
        var2_2 = null;
        try (Journal reader = this.getFactory().reader(Data.class, "test");){
            JournalPeekingIterator src = JournalIterators.bufferedIterator((Journal)reader);
            Assert.assertTrue((boolean)src.hasNext());
            Data d = (Data)src.next();
            Assert.assertNotNull((Object)d);
            Assert.assertEquals((Object)"EURUSD", (Object)d.sym);
            Assert.assertEquals((long)19999L, (long)d.created);
            Assert.assertEquals((double)1.24, (double)d.bid, (double)1.0E-6);
            Assert.assertEquals((double)1.25, (double)d.ask, (double)1.0E-6);
            Assert.assertEquals((long)10000L, (long)d.bidSize);
            Assert.assertEquals((long)12000L, (long)d.askSize);
            Assert.assertEquals((long)1L, (long)d.id);
            Assert.assertEquals((Object)"OK", (Object)d.status);
            Assert.assertEquals((Object)"system", (Object)d.user);
            Assert.assertEquals((Object)"EURUSD:GLOBAL", (Object)d.rateId);
            Assert.assertTrue((boolean)d.active);
            Assert.assertNull((Object)d.nullable);
            Assert.assertEquals((long)1234567L, (long)d.ticks);
            Assert.assertEquals((long)11000L, (long)d.modulo);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testInvalidColumnName() throws Exception {
        Throwable throwable;
        JournalWriter w2;
        File location = null;
        try {
            w2 = this.getFactory().writer((MetadataBuilder)new JournalStructure("test"){
                {
                    this.$int("id").index();
                    this.$str("status?\u0000x");
                }
            });
            throwable = null;
            try {
                location = w2.getLocation();
                w2.entryWriter();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (w2 != null) {
                    if (throwable != null) {
                        try {
                            w2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        w2.close();
                    }
                }
            }
        }
        catch (JournalException w2) {
            // empty catch block
        }
        Assert.assertNotNull(location);
        Files.deleteOrException(location);
        w2 = this.getFactory().writer((MetadataBuilder)new JournalStructure("test"){
            {
                this.$int("id").index();
                this.$str("status");
            }
        });
        throwable = null;
        try {
            w2.entryWriter();
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            if (w2 != null) {
                if (throwable != null) {
                    try {
                        w2.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    w2.close();
                }
            }
        }
    }

    @Test
    public void testObjectGenericObjectWriteSequence() throws Exception {
        JournalWriter writer = this.getFactory().writer((MetadataBuilder)new JournalMetadataBuilder<Data>(Data.class, "test"){
            {
                this.$date("created");
                this.$sym("sym").index();
                this.$int("id").index();
                this.$str("rateId").index();
            }
        });
        Data d = new Data();
        d.sym = "GBPUSD";
        d.created = 30000L;
        d.bid = 0.65;
        d.ask = 0.66;
        d.bidSize = 1000;
        d.askSize = 1100;
        d.id = 1;
        d.status = "OK";
        d.user = "system";
        d.rateId = "GBPUSD:GLOBAL";
        d.active = true;
        d.nullable = null;
        d.ticks = 12345678L;
        d.modulo = (short)425;
        writer.append((Object)d);
        writer.commit();
        writer.close();
        try (JournalWriter writer2 = this.makeGenericWriter();){
            JournalEntryWriter w = writer2.entryWriter();
            w.putSym(0, (CharSequence)"EURUSD");
            w.putDate(1, 19999L);
            w.putDouble(2, 1.24);
            w.putDouble(3, 1.25);
            w.putInt(4, 10000);
            w.putInt(5, 12000);
            w.putInt(6, 2);
            w.putStr(7, (CharSequence)"OK");
            w.putStr(8, (CharSequence)"system");
            w.putStr(9, (CharSequence)"EURUSD:GLOBAL");
            w.putBool(10, true);
            w.putNull(11);
            w.putLong(12, 1234567L);
            w.putShort(13, (short)11000);
            w.append();
            writer2.commit();
        }
        writer = this.getFactory().writer(Data.class, "test");
        d.sym = "HKDUSD";
        d.created = 40000L;
        d.bid = 2.88;
        d.ask = 2.89;
        d.bidSize = 1000;
        d.askSize = 1100;
        d.id = 3;
        d.status = "OK";
        d.user = "system";
        d.rateId = "HKDUSD:GLOBAL";
        d.active = true;
        d.nullable = null;
        d.ticks = 989931L;
        d.modulo = (short)398;
        writer.append((Object)d);
        writer.commit();
        var4_4 = null;
        try (Journal reader = this.getFactory().reader(Data.class, "test");){
            String expected = "Data{sym='GBPUSD', created=30000, bid=0.65, ask=0.66, bidSize=1000, askSize=1100, id=1, status='OK', user='system', rateId='GBPUSD:GLOBAL', active=true, nullable='null', ticks=12345678, modulo=425}\nData{sym='EURUSD', created=19999, bid=1.24, ask=1.25, bidSize=10000, askSize=12000, id=2, status='OK', user='system', rateId='EURUSD:GLOBAL', active=true, nullable='null', ticks=1234567, modulo=11000}\nData{sym='HKDUSD', created=40000, bid=2.88, ask=2.89, bidSize=1000, askSize=1100, id=3, status='OK', user='system', rateId='HKDUSD:GLOBAL', active=true, nullable='null', ticks=989931, modulo=398}\n";
            StringBuilder builder = new StringBuilder();
            for (Data data : JournalIterators.bufferedIterator((Journal)reader)) {
                builder.append(data).append('\n');
            }
            TestUtils.assertEquals((CharSequence)expected, builder);
        }
        catch (Throwable throwable) {
            var4_4 = throwable;
            throw throwable;
        }
        writer.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testObjectWriteGenericRead() throws Exception {
        try (JournalWriter writer = this.getFactory().writer((MetadataBuilder)new JournalMetadataBuilder<Data>(Data.class, "test"){
            {
                this.$sym("sym").index();
                this.$int("id").index();
                this.$str("rateId").index();
            }
        });){
            Data d = new Data();
            d.sym = "GBPUSD";
            d.created = 30000L;
            d.bid = 0.65;
            d.ask = 0.66;
            d.bidSize = 1000;
            d.askSize = 1100;
            d.id = 1;
            d.status = "OK";
            d.user = "system";
            d.rateId = "GBPUSD:GLOBAL";
            d.active = true;
            d.nullable = null;
            d.ticks = 12345678L;
            d.modulo = (short)425;
            writer.append((Object)d);
            writer.commit();
        }
        var2_2 = null;
        try (RecordSource rs = this.compile("test");){
            RecordCursor cursor = rs.prepareCursor((ReaderFactory)this.getFactory());
            try {
                Assert.assertTrue((boolean)cursor.hasNext());
                Record e = (Record)cursor.next();
                Assert.assertNotNull((Object)e);
                Assert.assertEquals((Object)"GBPUSD", (Object)e.getSym(0));
                Assert.assertEquals((long)30000L, (long)e.getDate(1));
                Assert.assertEquals((double)0.65, (double)e.getDouble(2), (double)1.0E-6);
                Assert.assertEquals((double)0.66, (double)e.getDouble(3), (double)1.0E-6);
                Assert.assertEquals((long)1000L, (long)e.getInt(4));
                Assert.assertEquals((long)1100L, (long)e.getInt(5));
                Assert.assertEquals((long)1L, (long)e.getByte(6));
                TestUtils.assertEquals((CharSequence)"OK", e.getFlyweightStr(7));
                TestUtils.assertEquals((CharSequence)"system", e.getFlyweightStr(8));
                TestUtils.assertEquals((CharSequence)"GBPUSD:GLOBAL", e.getFlyweightStr(9));
                Assert.assertTrue((boolean)e.getBool(10));
                Assert.assertNull((Object)e.getFlyweightStr(11));
                Assert.assertEquals((long)12345678L, (long)e.getLong(12));
                Assert.assertEquals((long)425L, (long)e.getShort(13));
                Assert.assertFalse((boolean)cursor.hasNext());
            }
            finally {
                cursor.releaseCursor();
            }
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testPartialObjectReader() throws Exception {
        try (JournalWriter writer = this.makeGenericWriter();){
            JournalEntryWriter w = writer.entryWriter();
            w.putSym(0, (CharSequence)"EURUSD");
            w.putDate(1, 19999L);
            w.putDouble(2, 1.24);
            w.putDouble(3, 1.25);
            w.putInt(4, 10000);
            w.putInt(5, 12000);
            w.putInt(6, 1);
            w.putStr(7, (CharSequence)"OK");
            w.putStr(8, (CharSequence)"system");
            w.putStr(9, (CharSequence)"EURUSD:GLOBAL");
            w.putBool(10, true);
            w.putNull(11);
            w.putLong(12, 13141516L);
            w.putShort(13, (short)25000);
            w.append();
            writer.commit();
        }
        var2_2 = null;
        try (Journal reader = this.getFactory().reader(Partial.class, "test");){
            String expected = "Partial{sym='EURUSD', created=19999, bid=1.24, ask=1.25, bidSize=10000, askSize=12000}";
            StringBuilder builder = new StringBuilder();
            for (Partial p : JournalIterators.bufferedIterator((Journal)reader)) {
                builder.append(p);
            }
            TestUtils.assertEquals((CharSequence)expected, builder);
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testPartialObjectWriter() throws Exception {
        this.makeGenericWriter().close();
        try {
            this.getFactory().writer(Partial.class, "test");
            Assert.fail((String)"Expected exception");
        }
        catch (JournalException journalException) {
            // empty catch block
        }
    }

    private JournalWriter makeGenericWriter() throws JournalException {
        return this.getFactory().writer((MetadataBuilder)new JournalStructure("test"){
            {
                this.$sym("sym").index();
                this.$date("created");
                this.$double("bid");
                this.$double("ask");
                this.$int("bidSize");
                this.$int("askSize");
                this.$int("id").index();
                this.$str("status");
                this.$str("user");
                this.$str("rateId").index();
                this.$bool("active");
                this.$str("nullable");
                this.$long("ticks");
                this.$short("modulo");
            }
        });
    }

    public static class Partial {
        private String sym;
        private long created;
        private double bid;
        private double ask;
        private int bidSize;
        private int askSize;

        public String toString() {
            return "Partial{sym='" + this.sym + '\'' + ", created=" + this.created + ", bid=" + this.bid + ", ask=" + this.ask + ", bidSize=" + this.bidSize + ", askSize=" + this.askSize + '}';
        }
    }

    public static class Data {
        private String sym;
        private long created;
        private double bid;
        private double ask;
        private int bidSize;
        private int askSize;
        private int id;
        private String status;
        private String user;
        private String rateId;
        private boolean active;
        private String nullable;
        private long ticks;
        private short modulo;

        public String toString() {
            return "Data{sym='" + this.sym + '\'' + ", created=" + this.created + ", bid=" + this.bid + ", ask=" + this.ask + ", bidSize=" + this.bidSize + ", askSize=" + this.askSize + ", id=" + this.id + ", status='" + this.status + '\'' + ", user='" + this.user + '\'' + ", rateId='" + this.rateId + '\'' + ", active=" + this.active + ", nullable='" + this.nullable + '\'' + ", ticks=" + this.ticks + ", modulo=" + this.modulo + '}';
        }
    }
}

