/*
 * Decompiled with CFR 0.152.
 */
package com.questdb;

import com.questdb.ex.ParserException;
import com.questdb.ql.RecordSource;
import com.questdb.std.DirectInputStream;
import com.questdb.std.Rnd;
import com.questdb.std.ex.JournalException;
import com.questdb.store.Journal;
import com.questdb.store.JournalEntryWriter;
import com.questdb.store.JournalWriter;
import com.questdb.store.Record;
import com.questdb.store.RecordCursor;
import com.questdb.store.factory.ReaderFactory;
import com.questdb.store.factory.configuration.JournalStructure;
import com.questdb.store.factory.configuration.MetadataBuilder;
import com.questdb.test.tools.AbstractTest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class GenericBinaryTest
extends AbstractTest {
    @Test
    public void testInputObject() throws Exception {
        List<byte[]> bytes = this.getBytes();
        try (JournalWriter generic = this.getGenericWriter();){
            this.writeInputStream(generic, bytes);
        }
        var3_3 = null;
        try (JournalWriter<BinContainer> w = this.getWriter();){
            this.assertEquals(bytes, this.readObject((Journal<BinContainer>)w));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testInputOutput() throws Exception {
        try (JournalWriter writer = this.getGenericWriter();){
            List<byte[]> expected = this.getBytes();
            this.writeInputStream(writer, expected);
            this.assertEquals(expected, this.readOutputStream());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testOutputInput() throws Exception {
        try (JournalWriter writer = this.getGenericWriter();){
            List<byte[]> expected = this.getBytes();
            this.writeOutputStream(writer, expected);
            ArrayList<byte[]> actual = new ArrayList<byte[]>();
            try (RecordSource rs = this.compile("bintest");){
                RecordCursor cursor = rs.prepareCursor((ReaderFactory)this.getFactory());
                try {
                    for (Record e : cursor) {
                        int b;
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        DirectInputStream in = e.getBin(0);
                        while ((b = in.read()) != -1) {
                            out.write(b);
                        }
                        actual.add(out.toByteArray());
                    }
                    this.assertEquals(expected, actual);
                }
                finally {
                    cursor.releaseCursor();
                }
            }
        }
    }

    @Test
    public void testOutputOutput() throws Exception {
        try (JournalWriter writer = this.getGenericWriter();){
            List<byte[]> expected = this.getBytes();
            this.writeOutputStream(writer, expected);
            this.assertEquals(expected, this.readOutputStream());
        }
    }

    @Test
    public void testUnclosedOutputOutput() throws Exception {
        try (JournalWriter writer = this.getGenericWriter();){
            List<byte[]> expected = this.getBytes();
            for (int i = 0; i < expected.size(); ++i) {
                JournalEntryWriter w = writer.entryWriter();
                w.putBin(0).write(expected.get(i));
                w.append();
            }
            writer.commit();
            this.assertEquals(expected, this.readOutputStream());
        }
    }

    private void assertEquals(List<byte[]> expected, List<byte[]> actual) {
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertArrayEquals((byte[])expected.get(i), (byte[])actual.get(i));
        }
    }

    private List<byte[]> getBytes() {
        Rnd r = new Rnd();
        ArrayList<byte[]> bytes = new ArrayList<byte[]>();
        for (int i = 0; i < 3; ++i) {
            bytes.add(r.nextBytes((3 - i) * 1024));
        }
        return bytes;
    }

    private JournalWriter getGenericWriter() throws JournalException {
        return this.getFactory().writer((MetadataBuilder)new JournalStructure("bintest"){
            {
                this.$bin("image");
            }
        });
    }

    private JournalWriter<BinContainer> getWriter() throws JournalException {
        return this.getFactory().writer(BinContainer.class, "bintest");
    }

    private List<byte[]> readObject(Journal<BinContainer> reader) {
        ArrayList<byte[]> actual = new ArrayList<byte[]>();
        for (BinContainer c : reader) {
            actual.add(c.image.array());
        }
        return actual;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<byte[]> readOutputStream() throws ParserException {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        try (RecordSource rs = this.compile("bintest");){
            RecordCursor cursor = rs.prepareCursor((ReaderFactory)this.getFactory());
            try {
                for (Record e : cursor) {
                    ByteArrayOutputStream o = new ByteArrayOutputStream();
                    e.getBin(0, (OutputStream)o);
                    result.add(o.toByteArray());
                }
            }
            finally {
                cursor.releaseCursor();
            }
            ArrayList<byte[]> arrayList = result;
            return arrayList;
        }
    }

    private void writeInputStream(JournalWriter writer, List<byte[]> bytes) throws JournalException {
        for (int i = 0; i < bytes.size(); ++i) {
            JournalEntryWriter w = writer.entryWriter();
            w.putBin(0, (InputStream)new ByteArrayInputStream(bytes.get(i)));
            w.append();
        }
        writer.commit();
    }

    private void writeOutputStream(JournalWriter writer, List<byte[]> expected) throws JournalException, IOException {
        for (int i = 0; i < expected.size(); ++i) {
            JournalEntryWriter w = writer.entryWriter();
            try (OutputStream out = w.putBin(0);){
                out.write(expected.get(i));
            }
            w.append();
        }
        writer.commit();
    }

    public static class BinContainer {
        private ByteBuffer image;
    }
}

