/*
 * Decompiled with CFR 0.152.
 */
package com.questdb;

import com.questdb.log.Log;
import com.questdb.log.LogFactory;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.store.JournalWriter;
import com.questdb.store.factory.configuration.JournalStructure;
import com.questdb.store.factory.configuration.MetadataBuilder;
import com.questdb.test.tools.AbstractTest;
import com.questdb.test.tools.TestUtils;
import java.util.concurrent.TimeUnit;
import org.junit.Test;

public class GenericAppendPerfTest
extends AbstractTest {
    private static final int TEST_DATA_SIZE = 2000000;
    private static final Log LOG = LogFactory.getLog(GenericAppendPerfTest.class);

    @Test
    public void testAppend() throws Exception {
        try (JournalWriter wg = this.getFactory().writer((MetadataBuilder)new JournalStructure("qq"){
            {
                this.$sym("sym").index().buckets(20);
                this.$double("bid");
                this.$double("ask");
                this.$int("bidSize");
                this.$int("askSize");
                this.$sym("ex").buckets(1);
                this.$sym("mode").buckets(1);
                this.recordCountHint(2000000);
            }
        });){
            long t = System.nanoTime();
            TestUtils.generateQuoteDataGeneric(wg, 2000000, DateFormatUtils.parseDateTime((CharSequence)"2013-10-05T10:00:00.000Z"), 1000L);
            wg.commit();
            long result = System.nanoTime() - t;
            LOG.info().$((CharSequence)"generic append (1M): ").$(TimeUnit.NANOSECONDS.toMillis(result) / 2L).$((CharSequence)"ms").$();
        }
    }
}

