/*
 * Decompiled with CFR 0.152.
 */
package com.questdb;

import com.questdb.std.ByteBuffers;
import com.questdb.std.Chars;
import com.questdb.std.Files;
import com.questdb.std.NumericException;
import com.questdb.std.ObjList;
import com.questdb.std.ex.JournalException;
import com.questdb.std.str.DirectCharSequence;
import com.questdb.std.str.LPSZ;
import com.questdb.std.str.NativeLPSZ;
import com.questdb.std.str.Path;
import com.questdb.std.time.DateFormatUtils;
import com.questdb.test.tools.TestUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FilesTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAppendAndSeqRead() throws Exception {
        try (Path path = new Path();){
            ByteBuffer buf;
            File f = this.temporaryFolder.newFile();
            long fd = Files.openRW((LPSZ)path.of((CharSequence)f.getAbsolutePath()).$());
            try {
                Assert.assertTrue((fd > 0L ? 1 : 0) != 0);
                buf = ByteBuffer.allocateDirect(1024).order(ByteOrder.LITTLE_ENDIAN);
                try {
                    ByteBuffers.putStr((ByteBuffer)buf, (CharSequence)"hello from java");
                    Files.append((long)fd, (long)ByteBuffers.getAddress((ByteBuffer)buf), (long)buf.position());
                    buf.clear();
                    ByteBuffers.putStr((ByteBuffer)buf, (CharSequence)", awesome");
                    Files.append((long)fd, (long)ByteBuffers.getAddress((ByteBuffer)buf), (long)buf.position());
                }
                finally {
                    ByteBuffers.release((ByteBuffer)buf);
                }
            }
            finally {
                Files.close((long)fd);
            }
            fd = Files.openRO((LPSZ)path);
            try {
                Assert.assertTrue((fd > 0L ? 1 : 0) != 0);
                buf = ByteBuffer.allocateDirect(1024).order(ByteOrder.LITTLE_ENDIAN);
                try {
                    int len = (int)Files.length((LPSZ)path);
                    long ptr = ByteBuffers.getAddress((ByteBuffer)buf);
                    Assert.assertEquals((long)48L, (long)Files.sequentialRead((long)fd, (long)ptr, (int)len));
                    DirectCharSequence cs = new DirectCharSequence().of(ptr, ptr + (long)len);
                    TestUtils.assertEquals((CharSequence)"hello from java, awesome", (CharSequence)cs);
                }
                finally {
                    ByteBuffers.release((ByteBuffer)buf);
                }
            }
            finally {
                Files.close((long)fd);
            }
            Assert.assertTrue((boolean)Files.exists((LPSZ)path));
            Assert.assertFalse((boolean)Files.exists((LPSZ)path.of((CharSequence)"/x/yz/1/2/3").$()));
        }
    }

    @Test
    public void testDeleteDir() throws Exception {
        File r = this.temporaryFolder.newFolder("to_delete");
        Assert.assertTrue((boolean)new File(r, "a/b/c").mkdirs());
        Assert.assertTrue((boolean)new File(r, "d/e/f").mkdirs());
        FilesTest.touch(new File(r, "d/1.txt"));
        FilesTest.touch(new File(r, "a/b/2.txt"));
        Assert.assertTrue((boolean)com.questdb.store.Files.delete((File)r));
        Assert.assertFalse((boolean)r.exists());
    }

    @Test
    public void testDeleteDir2() throws Exception {
        File r = this.temporaryFolder.newFolder("to_delete");
        Assert.assertTrue((boolean)new File(r, "a/b/c").mkdirs());
        Assert.assertTrue((boolean)new File(r, "d/e/f").mkdirs());
        FilesTest.touch(new File(r, "d/1.txt"));
        FilesTest.touch(new File(r, "a/b/2.txt"));
        try (Path path = new Path().of((CharSequence)r.getAbsolutePath()).$();){
            Assert.assertTrue((boolean)Files.rmdir((Path)path));
            Assert.assertFalse((boolean)r.exists());
        }
    }

    @Test
    public void testDeleteOpenFile() throws Exception {
        try (Path path = new Path();){
            File f = this.temporaryFolder.newFile();
            long fd = Files.openRW((LPSZ)path.of((CharSequence)f.getAbsolutePath()).$());
            Assert.assertTrue((boolean)Files.exists((long)fd));
            Assert.assertTrue((boolean)Files.remove((LPSZ)path));
            Assert.assertFalse((boolean)Files.exists((long)fd));
            Files.close((long)fd);
        }
    }

    @Test
    public void testLastModified() throws IOException, NumericException {
        try (Path path = new Path();){
            File f = this.temporaryFolder.newFile();
            Assert.assertTrue((boolean)Files.touch((LPSZ)path.of((CharSequence)f.getAbsolutePath()).$()));
            long t = DateFormatUtils.parseDateTime((CharSequence)"2015-10-17T10:00:00.000Z");
            Assert.assertTrue((boolean)Files.setLastModified((LPSZ)path, (long)t));
            Assert.assertEquals((long)t, (long)Files.getLastModified((LPSZ)path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testListDir() {
        String temp = this.temporaryFolder.getRoot().getAbsolutePath();
        ObjList names = new ObjList();
        try (Path path = new Path().of((CharSequence)temp).$();
             Path cp = new Path();){
            Assert.assertTrue((boolean)Files.touch((LPSZ)cp.of((CharSequence)temp).concat((CharSequence)"a.txt").$()));
            NativeLPSZ name = new NativeLPSZ();
            long pFind = Files.findFirst((LPSZ)path);
            Assert.assertTrue((pFind != 0L ? 1 : 0) != 0);
            try {
                do {
                    names.add((Object)name.of(Files.findName((long)pFind)).toString());
                } while (Files.findNext((long)pFind) > 0);
            }
            finally {
                Files.findClose((long)pFind);
            }
        }
        names.sort(Chars::compare);
        Assert.assertEquals((Object)"[.,..,a.txt]", (Object)names.toString());
    }

    @Test
    public void testListNonExistingDir() {
        String temp = this.temporaryFolder.getRoot().getAbsolutePath();
        try (Path path = new Path().of((CharSequence)temp).concat((CharSequence)"xyz");){
            long pFind = Files.findFirst((LPSZ)path);
            Assert.assertEquals((long)0L, (long)pFind);
        }
    }

    @Test
    public void testMkdirs() throws Exception {
        File r = this.temporaryFolder.newFolder("to_delete");
        try (Path path = new Path().of((CharSequence)r.getAbsolutePath());){
            path.concat((CharSequence)"a").concat((CharSequence)"b").concat((CharSequence)"c").concat((CharSequence)"f.text").$();
            Assert.assertEquals((long)0L, (long)Files.mkdirs((LPSZ)path, (int)509));
        }
        path = new Path().of((CharSequence)r.getAbsolutePath());
        var3_3 = null;
        try {
            path.concat((CharSequence)"a").concat((CharSequence)"b").concat((CharSequence)"c").$();
            Assert.assertTrue((boolean)Files.exists((LPSZ)path));
        }
        catch (Throwable throwable) {
            var3_3 = throwable;
            throw throwable;
        }
        finally {
            if (path != null) {
                if (var3_3 != null) {
                    try {
                        path.close();
                    }
                    catch (Throwable throwable) {
                        var3_3.addSuppressed(throwable);
                    }
                } else {
                    path.close();
                }
            }
        }
    }

    @Test
    public void testRemove() throws Exception {
        try (Path path = new Path().of((CharSequence)this.temporaryFolder.newFile().getAbsolutePath()).$();){
            Assert.assertTrue((boolean)Files.touch((LPSZ)path));
            Assert.assertTrue((boolean)Files.exists((LPSZ)path));
            Assert.assertTrue((boolean)Files.remove((LPSZ)path));
            Assert.assertFalse((boolean)Files.exists((LPSZ)path));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTruncate() throws Exception {
        File temp = this.temporaryFolder.newFile();
        com.questdb.store.Files.writeStringToFile((File)temp, (String)"abcde");
        try (Path path = new Path().of((CharSequence)temp.getAbsolutePath()).$();){
            Assert.assertTrue((boolean)Files.exists((LPSZ)path));
            Assert.assertEquals((long)5L, (long)Files.length((LPSZ)path));
            long fd = Files.openRW((LPSZ)path);
            try {
                Files.truncate((long)fd, (long)3L);
                Assert.assertEquals((long)3L, (long)Files.length((LPSZ)path));
                Files.truncate((long)fd, (long)0L);
                Assert.assertEquals((long)0L, (long)Files.length((LPSZ)path));
            }
            finally {
                Files.close((long)fd);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWrite() throws Exception {
        try (Path path = new Path();){
            int len;
            ByteBuffer buf;
            File f = this.temporaryFolder.newFile();
            long fd = Files.openRW((LPSZ)path.of((CharSequence)f.getAbsolutePath()).$());
            try {
                Assert.assertTrue((fd > 0L ? 1 : 0) != 0);
                buf = ByteBuffer.allocateDirect(1024).order(ByteOrder.LITTLE_ENDIAN);
                try {
                    ByteBuffers.putStr((ByteBuffer)buf, (CharSequence)"hello from java");
                    len = buf.position();
                    Assert.assertEquals((long)len, (long)Files.write((long)fd, (long)ByteBuffers.getAddress((ByteBuffer)buf), (long)len, (long)0L));
                    buf.clear();
                    ByteBuffers.putStr((ByteBuffer)buf, (CharSequence)", awesome");
                    Files.write((long)fd, (long)ByteBuffers.getAddress((ByteBuffer)buf), (long)buf.position(), (long)len);
                }
                finally {
                    ByteBuffers.release((ByteBuffer)buf);
                }
            }
            finally {
                Files.close((long)fd);
            }
            fd = Files.openRO((LPSZ)path);
            try {
                Assert.assertTrue((fd > 0L ? 1 : 0) != 0);
                buf = ByteBuffer.allocateDirect(1024).order(ByteOrder.LITTLE_ENDIAN);
                try {
                    len = (int)Files.length((LPSZ)path);
                    long ptr = ByteBuffers.getAddress((ByteBuffer)buf);
                    Assert.assertEquals((long)48L, (long)Files.read((long)fd, (long)ptr, (long)len, (long)0L));
                    DirectCharSequence cs = new DirectCharSequence().of(ptr, ptr + (long)len);
                    TestUtils.assertEquals((CharSequence)"hello from java, awesome", (CharSequence)cs);
                }
                finally {
                    ByteBuffers.release((ByteBuffer)buf);
                }
            }
            finally {
                Files.close((long)fd);
            }
            Assert.assertTrue((boolean)Files.exists((LPSZ)path));
            Assert.assertFalse((boolean)Files.exists((LPSZ)path.of((CharSequence)"/x/yz/1/2/3")));
        }
    }

    @Test
    public void testWriteStringToFile() throws IOException, JournalException {
        File f = this.temporaryFolder.newFile();
        com.questdb.store.Files.writeStringToFile((File)f, (String)"TEST123");
        Assert.assertEquals((Object)"TEST123", (Object)com.questdb.store.Files.readStringFromFile((File)f));
    }

    private static void touch(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        fos.close();
    }
}

