/*
 * Decompiled with CFR 0.152.
 */
package com.questdb;

import com.questdb.BootstrapEnv;
import com.questdb.ServerConfiguration;
import com.questdb.parser.plaintext.PlainTextLexer;
import com.questdb.parser.plaintext.PlainTextParser;
import com.questdb.parser.typeprobe.TypeProbeCollection;
import com.questdb.std.ObjList;
import com.questdb.std.str.DirectByteCharSequence;
import com.questdb.std.str.StringSink;
import com.questdb.store.util.ImportManager;
import com.questdb.test.tools.TestUtils;
import java.io.File;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class CsvTest {
    private final BootstrapEnv env = new BootstrapEnv();

    public CsvTest() {
        this.env.typeProbeCollection = new TypeProbeCollection();
        this.env.configuration = new ServerConfiguration();
    }

    @Test
    public void testHeaders() throws Exception {
        final ArrayList names = new ArrayList();
        ArrayList<String> expected = new ArrayList<String>(){
            {
                this.add("type");
                this.add("value");
                this.add("active");
                this.add("desc");
                this.add("grp");
            }
        };
        ImportManager.parse((File)new File(this.getClass().getResource("/csv/test-headers.csv").getFile()), (PlainTextLexer)new PlainTextLexer(this.env).of(','), (long)0x100000L, (boolean)true, (PlainTextParser)new PlainTextParser(){

            public void onError(int line) {
            }

            public void onFieldCount(int count) {
            }

            public void onFields(int line, ObjList<DirectByteCharSequence> values, int hi) {
            }

            public void onHeader(ObjList<DirectByteCharSequence> values, int hi) {
                for (int i = 0; i < hi; ++i) {
                    names.add(((DirectByteCharSequence)values.getQuick(i)).toString());
                }
            }

            public void onLineCount(int count) {
            }
        });
        TestUtils.assertEquals(expected.iterator(), names.iterator());
    }

    @Test
    public void testParseDosCsvSmallBuf() throws Exception {
        this.assertFile("/csv/test-dos.csv", 10L, new PlainTextLexer(this.env).of(','));
    }

    @Test
    public void testParseTab() throws Exception {
        this.assertFile("/csv/test.txt", 0x100000L, new PlainTextLexer(this.env).of('\t'));
    }

    @Test
    public void testParseTabSmallBuf() throws Exception {
        this.assertFile("/csv/test.txt", 10L, new PlainTextLexer(this.env).of('\t'));
    }

    @Test
    public void testParseUnixCsvSmallBuf() throws Exception {
        this.assertFile("/csv/test-unix.csv", 10L, new PlainTextLexer(this.env).of(','));
    }

    private void assertFile(String file, long bufSize, PlainTextLexer parser) throws Exception {
        String expected = "123,abc,2015-01-20T21:00:00.000Z,3.1415,TRUE,Lorem ipsum dolor sit amet.,122\n124,abc,2015-01-20T21:00:00.000Z,7.342,FALSE,Lorem ipsum \n\ndolor \"\"sit\"\" amet.,546756\n125,abc,2015-01-20T21:00:00.000Z,9.334,,Lorem ipsum \"\"dolor\"\" sit amet.,23\n126,abc,2015-01-20T21:00:00.000Z,1.345,TRUE,Lorem, ipsum, dolor sit amet.,434\n127,abc,2015-01-20T21:00:00.000Z,1.53321,TRUE,Lorem ipsum dolor sit amet.,112\n128,abc,2015-01-20T21:00:00.000Z,2.456,TRUE,Lorem ipsum dolor sit amet.,122\n";
        TestCsvListener listener = new TestCsvListener();
        ImportManager.parse((File)new File(this.getClass().getResource(file).getFile()), (PlainTextLexer)parser, (long)bufSize, (boolean)false, (PlainTextParser)listener);
        Assert.assertEquals((Object)expected, (Object)listener.toString());
        Assert.assertEquals((long)1L, (long)listener.getErrorCounter());
        Assert.assertEquals((long)4L, (long)listener.getErrorLine());
        Assert.assertEquals((long)7L, (long)parser.getLineCount());
    }

    private static class TestCsvListener
    implements PlainTextParser {
        private final StringSink sink = new StringSink();
        private int errorCounter = 0;
        private int errorLine = -1;

        private TestCsvListener() {
        }

        public int getErrorCounter() {
            return this.errorCounter;
        }

        public int getErrorLine() {
            return this.errorLine;
        }

        public String toString() {
            return this.sink.toString();
        }

        public void onError(int line) {
            ++this.errorCounter;
            this.errorLine = line;
        }

        public void onFieldCount(int count) {
        }

        public void onFields(int line, ObjList<DirectByteCharSequence> values, int hi) {
            for (int i = 0; i < hi; ++i) {
                if (i > 0) {
                    this.sink.put(',');
                }
                this.sink.put((CharSequence)values.getQuick(i));
            }
            this.sink.put('\n');
        }

        public void onHeader(ObjList<DirectByteCharSequence> values, int hi) {
        }

        public void onLineCount(int count) {
        }
    }
}

