/*
 * Decompiled with CFR 0.152.
 */
package com.questdb;

import com.questdb.std.IntHashSet;
import com.questdb.std.IntList;
import com.questdb.std.IntObjHashMap;
import com.questdb.std.LongList;
import com.questdb.std.ObjIntHashMap;
import com.questdb.std.Rnd;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class CollectionsTest {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void testIntHash() {
        int i;
        IntHashSet set = new IntHashSet(10);
        for (i = 0; i < 1000; ++i) {
            Assert.assertTrue((boolean)set.add(i));
        }
        for (i = 0; i < 1000; ++i) {
            Assert.assertFalse((boolean)set.add(i));
        }
    }

    @Test
    public void testIntList() {
        int i;
        IntList list = new IntList();
        int N = 1000;
        for (i = 0; i < 1000; ++i) {
            list.add(1000 - i);
        }
        Assert.assertEquals((long)1000L, (long)list.size());
        for (i = 0; i < 1000; ++i) {
            Assert.assertEquals((long)(1000 - i), (long)list.get(i));
        }
        IntList list2 = new IntList();
        list2.add(1001);
        list2.add(2001);
        list.addAll(list2);
        Assert.assertEquals((long)1002L, (long)list.size());
        Assert.assertEquals((long)1001L, (long)list.get(1000));
        Assert.assertEquals((long)2001L, (long)list.get(1001));
        IntList list3 = new IntList();
        for (int i2 = 0; i2 < 1000; ++i2) {
            list3.add(i2 + 5000);
        }
        list.addAll(list3);
        Assert.assertEquals((long)2002L, (long)list.size());
    }

    @Test
    public void testIntObjHashMap() {
        int i;
        IntObjHashMap map = new IntObjHashMap();
        Rnd rnd = new Rnd();
        for (i = 0; i < 1000; ++i) {
            map.put(i, (Object)rnd.nextString(25));
        }
        Assert.assertEquals((long)1000L, (long)map.size());
        rnd.reset();
        for (i = 0; i < 1000; ++i) {
            Assert.assertEquals((Object)rnd.nextString(25), (Object)map.get(i));
        }
    }

    @Test
    public void testLongSearch2() {
        LongList list = new LongList();
        Rnd rnd = new Rnd();
        for (int i = 7; i < 2000; i += 10) {
            list.add((long)(i + (rnd.nextPositiveInt() & 9)));
        }
        Assert.assertEquals((long)18L, (long)list.binarySearch(188L));
        Assert.assertEquals((long)-1L, (long)list.binarySearch(6L));
        Assert.assertEquals((long)-25L, (long)list.binarySearch(240L));
        Assert.assertEquals((long)-201L, (long)list.binarySearch(2010L));
    }

    @Test
    public void testObjIntHashMap() {
        int i;
        ObjIntHashMap map = new ObjIntHashMap();
        Rnd rnd = new Rnd();
        for (i = 0; i < 1000; ++i) {
            map.put((Object)rnd.nextString(25), i);
        }
        rnd.reset();
        for (i = 0; i < 1000; ++i) {
            Assert.assertEquals((long)i, (long)map.get((Object)rnd.nextString(25)));
        }
        Assert.assertEquals((long)1000L, (long)map.size());
        Assert.assertTrue((boolean)map.putIfAbsent((Object)"ABC", 100));
        Assert.assertFalse((boolean)map.putIfAbsent((Object)"ABC", 100));
    }
}

