/**
 * Copyright 2016 Google Inc. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

// DO NOT EDIT THIS GENERATED OUTPUT DIRECTLY!
// This file should be overwritten as part of your build process.
// If you need to extend the behavior of the generated service worker, the best approach is to write
// additional code and include it using the importScripts option:
//   https://github.com/GoogleChrome/sw-precache#importscripts-arraystring
//
// Alternatively, it's possible to make changes to the underlying template file and then use that as the
// new base for generating output, via the templateFilePath option:
//   https://github.com/GoogleChrome/sw-precache#templatefilepath-string
//
// If you go that route, make sure that whenever you update your sw-precache dependency, you reconcile any
// changes made to this original template file with your modified copy.

// This generated service worker JavaScript will precache your site's resources.
// The code needs to be saved in a .js file at the top-level of your site, and registered
// from your pages in order to be used. See
// https://github.com/googlechrome/sw-precache/blob/master/demo/app/js/service-worker-registration.js
// for an example of how you can register this script and handle various service worker events.

/* eslint-env worker, serviceworker */
/* eslint-disable indent, no-unused-vars, no-multiple-empty-lines, max-nested-callbacks, space-before-function-paren, quotes, comma-spacing */
'use strict';

var precacheConfig = [["allclasses-frame.html","c47c09bddcc8ce64d02c03f0b6848b28"],["allclasses-noframe.html","b9fde81a86bf26439468bed5878cd0c9"],["constant-values.html","811d1e72ddc95ff6abcb81f765f72648"],["deprecated-list.html","0333ac5fd5dbc6cd69519066877471c6"],["favicon.ico","05e61206186c2eee9054011bcf15b864"],["help-doc.html","39afb7f5870e0ac1eb47767829926e04"],["index-files/index-1.html","fd70721f416966e43188933d8e8f759c"],["index-files/index-10.html","36514f8081e3eb8f774792813a1118c0"],["index-files/index-11.html","d16ab76154c7f155660da87d1d9dafa9"],["index-files/index-12.html","f8d5317264540b1dbe6b438123578a8e"],["index-files/index-13.html","be1388088d2c5e543688a551c9767f36"],["index-files/index-14.html","5e97e74ae02d81945498e8e8fc0046a1"],["index-files/index-15.html","4ec6fb87449729016d14a5d09ee1d2fe"],["index-files/index-16.html","0beedc2b7b2f0de2add77dfa59f4c0c8"],["index-files/index-17.html","f10386b1525848ce3e573fd149675a1a"],["index-files/index-18.html","ad736174311be1c29a2a79ee9da378c5"],["index-files/index-19.html","d88c7790d1a55c906b61024b8730091e"],["index-files/index-2.html","fbd7b5ba8a16f0f041ec05ab808f4b8d"],["index-files/index-20.html","5622324da6a159654a894666288c9162"],["index-files/index-3.html","fa40cde18bf819a85918be82b9dd0e5d"],["index-files/index-4.html","35ef8e7beb5bfd40fd1815433fc59d51"],["index-files/index-5.html","dc350355e2b7ebdf44f094fd7eb7c3e6"],["index-files/index-6.html","8bdc5f0f4d374bb3a011cb90ba406c3c"],["index-files/index-7.html","276e92b0a11e8b4f8a25610be55f04b9"],["index-files/index-8.html","40c3da33fb8a3b9db40ca22161c50c4c"],["index-files/index-9.html","3446c489015f196ca0cb2afcc0256ce7"],["index.html","d168395f7d60d2ebd985516662edab5d"],["js/highlight-8.6-java/highlight.pack.js","deec56e4bb489b0ce943987284aac274"],["js/highlight-8.6-java/styles/obsidian.css","d60cd29c66c835762c95d2ce6da21142"],["js/index.js","dfc78156c8712ef6c546ea1037a604ef"],["js/jdk6-project-version-insert.js","ddee726b95840e7606e132d95c65ef27"],["js/jdk6-project-version-insert.min.js","a6a8d425f512ba0a8e2340504f134553"],["js/jquery-1.7.min.js","25721ced154b3a99e818431446d7506d"],["org/mockito/AdditionalAnswers.html","2067999f7ece8d652095a64c66a6e4b4"],["org/mockito/AdditionalMatchers.html","d7379d4725ea9b3568f9c26bbafb5975"],["org/mockito/Answers.html","809e75b80857f44cf019dc8d17f56e11"],["org/mockito/ArgumentCaptor.html","284a35552044a5e703fc76018cceb38a"],["org/mockito/ArgumentMatcher.html","04b626d6d6594f624d6bf26b2a5060ee"],["org/mockito/ArgumentMatchers.html","78133923aa684bdae254475e26cc2f47"],["org/mockito/BDDMockito.BDDMyOngoingStubbing.html","6f62ad02c3836135fae1ddbfa50b978c"],["org/mockito/BDDMockito.BDDStubber.html","e4a9ff85d5079071d650a3a50bf69c8f"],["org/mockito/BDDMockito.Then.html","89ee4f2ae05ddc0e1e3209acd9ec7643"],["org/mockito/BDDMockito.html","7c8ae78a76050eebb46cbd47d3fcdf2d"],["org/mockito/Captor.html","49e98f9db3a2b986a29f3e270e8db1f2"],["org/mockito/InOrder.html","820abecfae3fd6e3b98a2bc1ccb585a3"],["org/mockito/Incubating.html","915f5d667e7429dc0aba587b865908a1"],["org/mockito/InjectMocks.html","9e604a3900fe7dffad2f87c3b260ded7"],["org/mockito/Matchers.html","08d954fd10cd507d3f7f581ff0aa17e4"],["org/mockito/Mock.html","ab257616fe7006c96187c798fb16cd01"],["org/mockito/MockSettings.html","121f3954467bf50312f5188525ac7668"],["org/mockito/MockingDetails.html","b93361a61043478808e24a78da70c9ef"],["org/mockito/Mockito.html","816830bbad165a232297ed52f827b334"],["org/mockito/MockitoAnnotations.html","aedb1ab3eb4a0b42e6983334cbccb8d6"],["org/mockito/MockitoDebugger.html","416ec85ccd39ce2fe721e84426d75b45"],["org/mockito/MockitoFramework.html","8e19468e2522e0ff0b05b31e10b84e1c"],["org/mockito/Spy.html","19857bfc05f684bdefb4f03efd5064fd"],["org/mockito/class-use/AdditionalAnswers.html","655162036a9172e31b0c06f17afa61ac"],["org/mockito/class-use/AdditionalMatchers.html","80054b7c929bc9fc821f2e0ceecce097"],["org/mockito/class-use/Answers.html","ee66af8c620712b6d8070c8ea2b75c88"],["org/mockito/class-use/ArgumentCaptor.html","ce2ee949972afe588caad640ec39517b"],["org/mockito/class-use/ArgumentMatcher.html","fffdbece603db4bcc947d726b996eff7"],["org/mockito/class-use/ArgumentMatchers.html","6317a60646a9e9e44edf0385d2543e5f"],["org/mockito/class-use/BDDMockito.BDDMyOngoingStubbing.html","be2a66e5325a9315c1c09713909b7571"],["org/mockito/class-use/BDDMockito.BDDStubber.html","453dd8d6f0b5ed171033efbfe33f3a3a"],["org/mockito/class-use/BDDMockito.Then.html","e1a4de17c2ab7e50d0cefb763ff70233"],["org/mockito/class-use/BDDMockito.html","408637fcbf90765393b557598a54288f"],["org/mockito/class-use/Captor.html","8e2fb5b7b96da58c19f1aad1868050e5"],["org/mockito/class-use/InOrder.html","4f2670b8d5a4f1f637637fd02eff0d09"],["org/mockito/class-use/Incubating.html","3a3d34bc5058e8713572c745a511653f"],["org/mockito/class-use/InjectMocks.html","524a6ceedb6f3ae42eb0a9a34072af2d"],["org/mockito/class-use/Matchers.html","065b2142e933bdcdc9b903c246d3f53d"],["org/mockito/class-use/Mock.html","ffc57b628494845a7c1a75687cbe8878"],["org/mockito/class-use/MockSettings.html","bf503ac8b6f46bcd613eaad9052afc1e"],["org/mockito/class-use/MockingDetails.html","d2157368c1b7886eaee12b4c61a3472f"],["org/mockito/class-use/Mockito.html","66def1c9f4de1ac702f95a23ab7aed34"],["org/mockito/class-use/MockitoAnnotations.html","408e4972f9f5493a57f1ad9c89255206"],["org/mockito/class-use/MockitoDebugger.html","1e2a7ce1dd66bff76e95444f22d04da5"],["org/mockito/class-use/MockitoFramework.html","06664a489a366a6fa4d26aa9f515bb03"],["org/mockito/class-use/Spy.html","92f58dc35f163c17e3dc1dc5acc848ab"],["org/mockito/configuration/AnnotationEngine.html","4fdf5b6453bfcad58ec0db0495478268"],["org/mockito/configuration/DefaultMockitoConfiguration.html","9d4bbb799dab96dfc5e6c7d7ad533239"],["org/mockito/configuration/IMockitoConfiguration.html","c6b9a25222bf26986627be9f25882865"],["org/mockito/configuration/class-use/AnnotationEngine.html","b2f82a0a8970fb85666862098137ad76"],["org/mockito/configuration/class-use/DefaultMockitoConfiguration.html","82a724f7a0b081524f41493b387d2f29"],["org/mockito/configuration/class-use/IMockitoConfiguration.html","b51c276b4db4220cc0299dafbfbe82f7"],["org/mockito/configuration/package-frame.html","d946393e7447d2ef5312901fd3d0e021"],["org/mockito/configuration/package-summary.html","cad767b998c6679692b93ee664ea6b07"],["org/mockito/configuration/package-tree.html","aafe181536c3d9057d5c31e692c42511"],["org/mockito/configuration/package-use.html","704f90deb275db640e94af5a1fc5e11e"],["org/mockito/exceptions/base/MockitoAssertionError.html","c6607273a19a90d3d63fca1518cba068"],["org/mockito/exceptions/base/MockitoException.html","2e20936ace198634562ba3a46b80684e"],["org/mockito/exceptions/base/MockitoInitializationException.html","3b1074de1dbc1b5b73ae7acec0f1a59d"],["org/mockito/exceptions/base/MockitoSerializationIssue.html","da89cec98ad63013dd7a64b139efb7b8"],["org/mockito/exceptions/base/class-use/MockitoAssertionError.html","eb60056433e67e68b8b01bab494107c7"],["org/mockito/exceptions/base/class-use/MockitoException.html","ed5fc90af15277957fd95a29d62a71d2"],["org/mockito/exceptions/base/class-use/MockitoInitializationException.html","146e71b30f5c4351a8c7b1b3d0229380"],["org/mockito/exceptions/base/class-use/MockitoSerializationIssue.html","7071e53c24bc522b26afe450a8a7be2e"],["org/mockito/exceptions/base/package-frame.html","cc084962747673724fe427e554f5c27a"],["org/mockito/exceptions/base/package-summary.html","ec238b782a2f6b55e828e5412c354fc0"],["org/mockito/exceptions/base/package-tree.html","230f6b84aa8253b5c37fe22fdc0faea5"],["org/mockito/exceptions/base/package-use.html","eea2a44105fe337150c53a74bf5da50d"],["org/mockito/exceptions/misusing/CannotStubVoidMethodWithReturnValue.html","603215426973ce1012f4e95ebc991443"],["org/mockito/exceptions/misusing/CannotVerifyStubOnlyMock.html","e8616e252cc420d76e254c9b978a5477"],["org/mockito/exceptions/misusing/FriendlyReminderException.html","94f0160f16f40307c7116f05e122403e"],["org/mockito/exceptions/misusing/InvalidUseOfMatchersException.html","d9c01b8e77662dba84d64a7b11651174"],["org/mockito/exceptions/misusing/MissingMethodInvocationException.html","282888355b712757ed208d8bc77ce8be"],["org/mockito/exceptions/misusing/MockitoConfigurationException.html","226edfd4b89ae173a8df325846af128d"],["org/mockito/exceptions/misusing/NotAMockException.html","54cd4fb413ba0a7939ab774efaaa0338"],["org/mockito/exceptions/misusing/NullInsteadOfMockException.html","2f533632cb95e9da12a4286b2933fc13"],["org/mockito/exceptions/misusing/PotentialStubbingProblem.html","553f9f8fed40622e8e48cfda48ee6e2c"],["org/mockito/exceptions/misusing/RedundantListenerException.html","9d4970cac940200bc6f17c3379ba2f7e"],["org/mockito/exceptions/misusing/UnfinishedStubbingException.html","3faf309376e4ff086727b63625002c31"],["org/mockito/exceptions/misusing/UnfinishedVerificationException.html","61ac12e2271b252fa86c21861ee9b2b6"],["org/mockito/exceptions/misusing/UnnecessaryStubbingException.html","a98b85dc1e40d2e476ee04a05d12e72c"],["org/mockito/exceptions/misusing/WrongTypeOfReturnValue.html","fbb5c652ea7c09a2c6cdf1a89dd6b184"],["org/mockito/exceptions/misusing/class-use/CannotStubVoidMethodWithReturnValue.html","3ee6b1b4ac09a1701daef2a40c4af1c8"],["org/mockito/exceptions/misusing/class-use/CannotVerifyStubOnlyMock.html","4015737d40be553363e85b494d74b367"],["org/mockito/exceptions/misusing/class-use/FriendlyReminderException.html","2b2e8e4bc57ef87aabeff899657cb107"],["org/mockito/exceptions/misusing/class-use/InvalidUseOfMatchersException.html","60f9421c027530f65d839829fce92fae"],["org/mockito/exceptions/misusing/class-use/MissingMethodInvocationException.html","887f942ea937c33e5f441c23eb46d100"],["org/mockito/exceptions/misusing/class-use/MockitoConfigurationException.html","92462e8250780076c419e4909169911e"],["org/mockito/exceptions/misusing/class-use/NotAMockException.html","a5c4141520c8d60e6a0795f22a6a20b5"],["org/mockito/exceptions/misusing/class-use/NullInsteadOfMockException.html","e03c20975c9878262ef4c8987ec5db0c"],["org/mockito/exceptions/misusing/class-use/PotentialStubbingProblem.html","6bf0c6ffce1de2ad82977beb22aefdad"],["org/mockito/exceptions/misusing/class-use/RedundantListenerException.html","d193109f9034fc2837fb61ac7b33594c"],["org/mockito/exceptions/misusing/class-use/UnfinishedStubbingException.html","99b415e51df886022114f6310adbc6ee"],["org/mockito/exceptions/misusing/class-use/UnfinishedVerificationException.html","694557a5786eb41509deb755df82728b"],["org/mockito/exceptions/misusing/class-use/UnnecessaryStubbingException.html","2d1d1eb964a982fd45c648c15ae5295f"],["org/mockito/exceptions/misusing/class-use/WrongTypeOfReturnValue.html","4999a5befa34487250a3271047219765"],["org/mockito/exceptions/misusing/package-frame.html","c7415676bbfc3ce86c2278be0c029168"],["org/mockito/exceptions/misusing/package-summary.html","88bcace4be12003eae5722130d4ab95d"],["org/mockito/exceptions/misusing/package-tree.html","39311ba27f52c52583615e3a9472d1a3"],["org/mockito/exceptions/misusing/package-use.html","922a05b837f9140b50b06f88c01e5234"],["org/mockito/exceptions/stacktrace/StackTraceCleaner.html","850611801393accf56b572b31b29957c"],["org/mockito/exceptions/stacktrace/class-use/StackTraceCleaner.html","01d80c4b0df30325e792af02212d983e"],["org/mockito/exceptions/stacktrace/package-frame.html","df6db7d765015a9f7c4fc15a2fffbe76"],["org/mockito/exceptions/stacktrace/package-summary.html","aaf808f8559f4c822052843ee59815f3"],["org/mockito/exceptions/stacktrace/package-tree.html","e990fec5fc99d88414b9555b0734868d"],["org/mockito/exceptions/stacktrace/package-use.html","10412dab6eac54923bc68b1300398608"],["org/mockito/exceptions/verification/ArgumentsAreDifferent.html","6f72e10e6649ef17430b33d023a7c25a"],["org/mockito/exceptions/verification/NeverWantedButInvoked.html","c01815cd652e4d97e04e33615b79176b"],["org/mockito/exceptions/verification/NoInteractionsWanted.html","bee3f07ac08fa10b7d5038935821a50f"],["org/mockito/exceptions/verification/SmartNullPointerException.html","25965e4033f367f959a4aa6d58f0f578"],["org/mockito/exceptions/verification/TooLittleActualInvocations.html","1064e990c2c96b5d2ee1856fe32f32ee"],["org/mockito/exceptions/verification/TooManyActualInvocations.html","96e52ffdfa7aaf7f5cb3b3af7cc2569d"],["org/mockito/exceptions/verification/VerificationInOrderFailure.html","cc1e3598b8c63c57813839144ed6ea1c"],["org/mockito/exceptions/verification/WantedButNotInvoked.html","828afe7b35ce9b5597385bd3b5311395"],["org/mockito/exceptions/verification/class-use/ArgumentsAreDifferent.html","16e850b463676435e6b97883c0db362a"],["org/mockito/exceptions/verification/class-use/NeverWantedButInvoked.html","a657b19ba202358f3e8657422f3d8af7"],["org/mockito/exceptions/verification/class-use/NoInteractionsWanted.html","e576903d0260b1595ef1c7de7fda7fbc"],["org/mockito/exceptions/verification/class-use/SmartNullPointerException.html","7cea6916184f304cb096e1ff9fea0cf0"],["org/mockito/exceptions/verification/class-use/TooLittleActualInvocations.html","ec59bd81e54dab6166cdd92e1a4d282b"],["org/mockito/exceptions/verification/class-use/TooManyActualInvocations.html","d7527d5c870da3646ac81ad8a4defe7a"],["org/mockito/exceptions/verification/class-use/VerificationInOrderFailure.html","a6bf80d7f200dc9d06d281a436806a12"],["org/mockito/exceptions/verification/class-use/WantedButNotInvoked.html","a337a6ed584062303295c430f3b09891"],["org/mockito/exceptions/verification/junit/ArgumentsAreDifferent.html","5d6c469eae51fa5818eb8de36ebcb7f9"],["org/mockito/exceptions/verification/junit/class-use/ArgumentsAreDifferent.html","d9a122757a7c7c10ca72e1afe5f2e084"],["org/mockito/exceptions/verification/junit/package-frame.html","037d97a0a2ba6e944e9a55530a56082a"],["org/mockito/exceptions/verification/junit/package-summary.html","d9825f3f70681b2470dce865ddf8e31f"],["org/mockito/exceptions/verification/junit/package-tree.html","1e537949d0bf74872f170710c8d41415"],["org/mockito/exceptions/verification/junit/package-use.html","12478eddabd6de4525a3cc702a98e144"],["org/mockito/exceptions/verification/package-frame.html","5cb88ddd2ac8c047069f5780885e726b"],["org/mockito/exceptions/verification/package-summary.html","465fb5d2d57d69040792e5878ecff266"],["org/mockito/exceptions/verification/package-tree.html","4bfd1b10dedbbcdd5ccc5474f25c9918"],["org/mockito/exceptions/verification/package-use.html","e7d38e01d2389fa7d71b018fd54094b6"],["org/mockito/hamcrest/MockitoHamcrest.html","91cc57f1dcd61ce6356fdbd0209ad17f"],["org/mockito/hamcrest/class-use/MockitoHamcrest.html","2ab73c8eae7a6c8d0fcaa94c64723fac"],["org/mockito/hamcrest/package-frame.html","6e86eac808fa3ef73e79e9911ee7b793"],["org/mockito/hamcrest/package-summary.html","e4785e326918fad6f0e88a50c2df5c7c"],["org/mockito/hamcrest/package-tree.html","bb4c0f0ba7697850f78829f70018943b"],["org/mockito/hamcrest/package-use.html","68626fd0a0c1c115752e59f17e62372e"],["org/mockito/invocation/DescribedInvocation.html","6c145947c8a58ac475b0fd33730f06f9"],["org/mockito/invocation/Invocation.html","25c5b0f157bc3ea2d7dae4a34c295da5"],["org/mockito/invocation/InvocationOnMock.html","6d7df8068dfa8c3393b2b864fa0773b3"],["org/mockito/invocation/Location.html","af4197cd03c00935e967481d1bfa20fe"],["org/mockito/invocation/MatchableInvocation.html","c7802fc8f5e7ca5f1fbf596fbc6e4d76"],["org/mockito/invocation/MockHandler.html","8c1e2e7d459f59ae21c9f72171a9a9cb"],["org/mockito/invocation/StubInfo.html","84b3aa831318314bf82b502bee8fda70"],["org/mockito/invocation/class-use/DescribedInvocation.html","64084805bd38f9123cea863fcc7bd98c"],["org/mockito/invocation/class-use/Invocation.html","9458e304478a21fc2c9444d19668894e"],["org/mockito/invocation/class-use/InvocationOnMock.html","d27b52bd69b6796ea6e42f1f2b93908d"],["org/mockito/invocation/class-use/Location.html","4aa98c0f8885dc33539b405bf01147da"],["org/mockito/invocation/class-use/MatchableInvocation.html","f9f708dff88fa2219b7179dfb36b0a4b"],["org/mockito/invocation/class-use/MockHandler.html","bcd24d149ecf0c21b78fde9af5916237"],["org/mockito/invocation/class-use/StubInfo.html","76484aa3533828a85a8980d8026515b1"],["org/mockito/invocation/package-frame.html","6174fedc4b2c852bfbb16f6a57139f15"],["org/mockito/invocation/package-summary.html","1067b81039de46cb24b751263de1440c"],["org/mockito/invocation/package-tree.html","418b610d0f784c6e9a804cc0f66f3a80"],["org/mockito/invocation/package-use.html","b5d18cb31c77a62b813fac6a277bea10"],["org/mockito/junit/MockitoJUnit.html","a2c07ef19bb35802f9d360f7948e0907"],["org/mockito/junit/MockitoJUnitRunner.Silent.html","fa45bdc5c3cd9241050bd18a337fb78d"],["org/mockito/junit/MockitoJUnitRunner.Strict.html","92237c18e99ba466c20398f8c76e3e5e"],["org/mockito/junit/MockitoJUnitRunner.StrictStubs.html","0f103ff6866de1628318a0acfd038f3f"],["org/mockito/junit/MockitoJUnitRunner.html","96e792e80b9fdf92331407981172c26e"],["org/mockito/junit/MockitoRule.html","bfce154acf3c1e713d3319910fe1468b"],["org/mockito/junit/VerificationCollector.html","cf13ab3a8aeb546b145283a2f0a9e72a"],["org/mockito/junit/class-use/MockitoJUnit.html","de1a67a9b5019f4ed9a797abf2311509"],["org/mockito/junit/class-use/MockitoJUnitRunner.Silent.html","fa195ac14fcbce27cfaa55c44e275f65"],["org/mockito/junit/class-use/MockitoJUnitRunner.Strict.html","1a18df02bc74c1277dcae54f4adcb902"],["org/mockito/junit/class-use/MockitoJUnitRunner.StrictStubs.html","57827e6b3b58f40d43fb8a81a4e84106"],["org/mockito/junit/class-use/MockitoJUnitRunner.html","f1b500a878150b24f1c44f05fbcddab3"],["org/mockito/junit/class-use/MockitoRule.html","726e41691a320064df657192a5d7e9ce"],["org/mockito/junit/class-use/VerificationCollector.html","81b5e438b323cc6a5f2516fd708076c4"],["org/mockito/junit/package-frame.html","8ca28c57c129b50a376c770e96e7352d"],["org/mockito/junit/package-summary.html","778478b671f4db0337fbaec2e28cb568"],["org/mockito/junit/package-tree.html","a1d08259b92f810315783ed26db8e61d"],["org/mockito/junit/package-use.html","163ad35aee3ab6b273f4e9bfab774c9c"],["org/mockito/listeners/InvocationListener.html","5bf25cb6b6a0defb49c62938597ba8fc"],["org/mockito/listeners/MethodInvocationReport.html","5eb5df4ffb3bdb683e9de6eff2078d6b"],["org/mockito/listeners/MockCreationListener.html","8de14b27f373e44e4cc279d46ce109fc"],["org/mockito/listeners/MockitoListener.html","cfd95590574d54b79e3e18f2b143bc45"],["org/mockito/listeners/VerificationListener.html","0a106982da797a5d083e9fc79f61f1ed"],["org/mockito/listeners/class-use/InvocationListener.html","a5718637f26e8090aac082ae18d5ee8b"],["org/mockito/listeners/class-use/MethodInvocationReport.html","4f277fec0c50b48fed6ef0a00337c73d"],["org/mockito/listeners/class-use/MockCreationListener.html","a2ccbdd44bfa02c1a2c149baa5f7fad6"],["org/mockito/listeners/class-use/MockitoListener.html","cc6739b6c86a03cd27f5509bc6dd2f46"],["org/mockito/listeners/class-use/VerificationListener.html","cfc68cdc5c5941edbe42d8d0f6394c11"],["org/mockito/listeners/package-frame.html","ac40def5724eee1325a6e2506c4f864d"],["org/mockito/listeners/package-summary.html","9ac5e7269a218388ec87ef44e5a0778c"],["org/mockito/listeners/package-tree.html","ecd5378e4e503c6f92a2d70fe76483ae"],["org/mockito/listeners/package-use.html","b55abdc05a9e50799194fe8335df16b0"],["org/mockito/mock/MockCreationSettings.html","fe9635fea7862e5b3f7e3b75bbe327b2"],["org/mockito/mock/MockName.html","d92dcb1a05d920fc3273315346a682d1"],["org/mockito/mock/SerializableMode.html","0e458dec190d5922e7cf3d647d25f10c"],["org/mockito/mock/class-use/MockCreationSettings.html","f18f29326444b0ca0c3ba07e2674571e"],["org/mockito/mock/class-use/MockName.html","3959770d47a3f6bc1b732285544832ea"],["org/mockito/mock/class-use/SerializableMode.html","e0fed1d413133805ee3353225da4f511"],["org/mockito/mock/package-frame.html","9c8709da6e3c326fe5924424fbe78a27"],["org/mockito/mock/package-summary.html","3cdb00a459244ccdd52e238537f64495"],["org/mockito/mock/package-tree.html","c4fa3990b9688a1a78ce706b946c76ab"],["org/mockito/mock/package-use.html","cd2e90f9637670db3274eb7875b6f30e"],["org/mockito/package-frame.html","741803d6d226e7df8b02e7cf2f810244"],["org/mockito/package-summary.html","9e7e8a9dc724cc8d199e73e928eb0c60"],["org/mockito/package-tree.html","78c963b27a3cfd6e015fac54a9e92309"],["org/mockito/package-use.html","323f5bfb0f845393a97e5c0d4abab50a"],["org/mockito/plugins/AnnotationEngine.html","4f8b83cae1e76c5bed154098e8708c2f"],["org/mockito/plugins/InstantiatorProvider.html","f267223b4cdfccde93679cdade10577d"],["org/mockito/plugins/MockMaker.TypeMockability.html","08b8b763054202e0eb40ec8c4fb1f079"],["org/mockito/plugins/MockMaker.html","0b91f3578c5aa40a4a0dcdb70423c641"],["org/mockito/plugins/PluginSwitch.html","b464b7f6db7f82291757a51a9555173c"],["org/mockito/plugins/StackTraceCleanerProvider.html","73cda34ff89a81b093e9526bedca5e70"],["org/mockito/plugins/class-use/AnnotationEngine.html","00f722b5fb26ebea3b372672b5e2531b"],["org/mockito/plugins/class-use/InstantiatorProvider.html","d2c198baca9df375a65d102354974b03"],["org/mockito/plugins/class-use/MockMaker.TypeMockability.html","2115cd5b4300be7912457708d7e87229"],["org/mockito/plugins/class-use/MockMaker.html","13dc9fc6b7d653be6082d067e3a2bdaa"],["org/mockito/plugins/class-use/PluginSwitch.html","50137d04ad34ae9c5eb333f5d037b54e"],["org/mockito/plugins/class-use/StackTraceCleanerProvider.html","d3affeedda8f4972be952734523c923a"],["org/mockito/plugins/package-frame.html","6aedb60ad1d86817737d97aa74421e00"],["org/mockito/plugins/package-summary.html","12f1080c9358f7b6ea1f83e1bdd3c20f"],["org/mockito/plugins/package-tree.html","b33efd7a98088f7e41152c6ae6941fe1"],["org/mockito/plugins/package-use.html","b643c7a1f0928b7abb2e0630ec6d0f69"],["org/mockito/quality/MockitoHint.html","e8120cd6a6d3bcbcf2f41958bf8891e1"],["org/mockito/quality/Strictness.html","18272efdb9b3792e8445668d3524035a"],["org/mockito/quality/class-use/MockitoHint.html","5863b35f6ffb07c9978950660609039d"],["org/mockito/quality/class-use/Strictness.html","38e4ad49b0a642599e2d229ef917c544"],["org/mockito/quality/package-frame.html","5e88cc16bd86ee38fdde1b2c57dc0dde"],["org/mockito/quality/package-summary.html","f852141ebd360ad95afd136dddfbceaa"],["org/mockito/quality/package-tree.html","c12d63566c957678ab310218c0b571d1"],["org/mockito/quality/package-use.html","965eb42b730f71a3fb3a7419bfe2ce40"],["org/mockito/runners/ConsoleSpammingMockitoJUnitRunner.html","dc08a85bbcab1ef5f91d60d68fdbdf74"],["org/mockito/runners/MockitoJUnitRunner.Silent.html","dd938f5c4c0481df1111140fd4892e2b"],["org/mockito/runners/MockitoJUnitRunner.Strict.html","dbdcc7c7b9f04f5e170fb290e34902cb"],["org/mockito/runners/MockitoJUnitRunner.html","6fce5ed23ef9fa1260aeefd7bbf969c0"],["org/mockito/runners/VerboseMockitoJUnitRunner.html","260015dab45edb5014200118d8b5d2c8"],["org/mockito/runners/class-use/ConsoleSpammingMockitoJUnitRunner.html","585bf8e5458ef95477f5f80c8ddc4216"],["org/mockito/runners/class-use/MockitoJUnitRunner.Silent.html","b4fc2a74bb1750ef3fd66e74e718f56d"],["org/mockito/runners/class-use/MockitoJUnitRunner.Strict.html","4357d6e67d899e779eb934a833bdfbce"],["org/mockito/runners/class-use/MockitoJUnitRunner.html","c49dcf3638f68469fa75e8e69607af65"],["org/mockito/runners/class-use/VerboseMockitoJUnitRunner.html","67a04e9784c5407b997cfe411eb9fc77"],["org/mockito/runners/package-frame.html","ffdfa06c41742891e4d51d66f6d2034f"],["org/mockito/runners/package-summary.html","5f89c0ae6eba8279cc5026fbba7313b7"],["org/mockito/runners/package-tree.html","745cf9143d6a6cc7d5bf6961dd952bbc"],["org/mockito/runners/package-use.html","e887f6153a50a5af66efc90fbddf94bd"],["org/mockito/stubbing/Answer.html","66fa90aaecc57e1b08ba4f6d04bf9162"],["org/mockito/stubbing/Answer1.html","46996e0c9c4d47203c68552afb700cc0"],["org/mockito/stubbing/Answer2.html","38233e2e6da4512e60e75c42804d9165"],["org/mockito/stubbing/Answer3.html","9762afa93ff5e551e2a36abf4a54a2a4"],["org/mockito/stubbing/Answer4.html","67b655f8fc3e7d15ab6a5dfaa03dbc8d"],["org/mockito/stubbing/Answer5.html","bb2d9670d0d46b2160240c5f8f6fe064"],["org/mockito/stubbing/OngoingStubbing.html","3a7f528f7431aea606587e753fb8f5be"],["org/mockito/stubbing/Stubber.html","b3306d667c5e6f451aaa30e1f77364b0"],["org/mockito/stubbing/Stubbing.html","3982946da0bd03ae204865e0a7522af1"],["org/mockito/stubbing/ValidableAnswer.html","04c1ec037bdd1f28a922f600b3e6e6b0"],["org/mockito/stubbing/VoidAnswer1.html","a8b050a854f12da8dbce61282cefd225"],["org/mockito/stubbing/VoidAnswer2.html","9729fdf2fd3bcd0e45623df6b044a44a"],["org/mockito/stubbing/VoidAnswer3.html","49abb889d635c0384d66cfbf720be21e"],["org/mockito/stubbing/VoidAnswer4.html","75afcc9838f97426284719f52c92a58b"],["org/mockito/stubbing/VoidAnswer5.html","6c9fb124f7df125306b60c1fd7eba77b"],["org/mockito/stubbing/class-use/Answer.html","4d5f1c54e5c84e8c8a30bc38ff02c983"],["org/mockito/stubbing/class-use/Answer1.html","c4e2415cd017ea7d2857dd8de42ac4d9"],["org/mockito/stubbing/class-use/Answer2.html","c3cd8c934927e609ed39c2d04610d52c"],["org/mockito/stubbing/class-use/Answer3.html","0f45754824ce6d85b0c7cc60a69f32cd"],["org/mockito/stubbing/class-use/Answer4.html","cb2f4dfac54250cdeb31ea0a906a6ecb"],["org/mockito/stubbing/class-use/Answer5.html","7c931df523cdb9da11c724204c0ae598"],["org/mockito/stubbing/class-use/OngoingStubbing.html","c971e5b3b6963dafab4a6db1f6513506"],["org/mockito/stubbing/class-use/Stubber.html","3e989692cf637edf03980feccf4ebb10"],["org/mockito/stubbing/class-use/Stubbing.html","6d670d27822a9ddb86f5b030a2fc63a9"],["org/mockito/stubbing/class-use/ValidableAnswer.html","a8c958b44acc099ff2ca04e6771c3294"],["org/mockito/stubbing/class-use/VoidAnswer1.html","7ca013792b4785e6da562469350d05b2"],["org/mockito/stubbing/class-use/VoidAnswer2.html","51bdd49bbee015e4aee3c226e09e9caa"],["org/mockito/stubbing/class-use/VoidAnswer3.html","c5c4f65f87d3803448809279150ea7f8"],["org/mockito/stubbing/class-use/VoidAnswer4.html","b4af31e995657bb3e094644fd464ef9c"],["org/mockito/stubbing/class-use/VoidAnswer5.html","fb4ef6f2a834ceebb453b0dd41d1a714"],["org/mockito/stubbing/package-frame.html","6ae10ca7352f15b95d6a7220f22a7957"],["org/mockito/stubbing/package-summary.html","c2b6bc9e34a9f526f662cb319eb5787a"],["org/mockito/stubbing/package-tree.html","577c787d062d2dac47298837dfb83488"],["org/mockito/stubbing/package-use.html","550bb289225dff559dc0023257868b69"],["org/mockito/verification/After.html","169c15f5d39faf493c174dac1528d3bb"],["org/mockito/verification/Timeout.html","a7cdbba56d7866c5d7c3734cf18ed662"],["org/mockito/verification/VerificationAfterDelay.html","238414155036443100192b68c48ae228"],["org/mockito/verification/VerificationEvent.html","41dd8f160a22a6fc71007887b1b65939"],["org/mockito/verification/VerificationMode.html","d4cea83b89714ceb61a42bd917a820e8"],["org/mockito/verification/VerificationStrategy.html","994d9591d76e2278bf721215fef892dc"],["org/mockito/verification/VerificationWithTimeout.html","66ec8b6885d8df622dde44644f713579"],["org/mockito/verification/class-use/After.html","5747ae99ed90fb63e824c0dc49bc6df6"],["org/mockito/verification/class-use/Timeout.html","fcce6a800a389e1deadf2337f000fdc8"],["org/mockito/verification/class-use/VerificationAfterDelay.html","cfcff9b26e0f40e28a3363d4ce8dc6d0"],["org/mockito/verification/class-use/VerificationEvent.html","d9439c6a13bf8050491054dac731337c"],["org/mockito/verification/class-use/VerificationMode.html","c81b2f38078d9b273368c0578ca1c91f"],["org/mockito/verification/class-use/VerificationStrategy.html","fb4c21b6325e3aeb43cc31274acfe6de"],["org/mockito/verification/class-use/VerificationWithTimeout.html","aa5d589415dbf035b6dc488dd91c2f11"],["org/mockito/verification/package-frame.html","1fdd42dcca76530ccad451361b73383a"],["org/mockito/verification/package-summary.html","40e85f3877259139447856276771031b"],["org/mockito/verification/package-tree.html","fe7e2e4a54b1b3dcc66966a2042e6d41"],["org/mockito/verification/package-use.html","a2221592fc967481297ea6336dd97dce"],["overview-frame.html","1d3177e7933779ebd96935f6395e1a9e"],["overview-summary.html","6f994c6c997044d988aa468b9f31d17d"],["overview-tree.html","df22ead08ba7b06bde7dbf797e14024f"],["serialized-form.html","b4d5a495f30fd0949001af8cb079731f"],["stylesheet.css","3dd9013d4309436be79cba586b6e5454"]];
var cacheName = 'sw-precache-v2-sw-precache-' + (self.registration ? self.registration.scope : '');


var ignoreUrlParametersMatching = [/^utm_/];



var addDirectoryIndex = function (originalUrl, index) {
    var url = new URL(originalUrl);
    if (url.pathname.slice(-1) === '/') {
      url.pathname += index;
    }
    return url.toString();
  };

var createCacheKey = function (originalUrl, paramName, paramValue,
                           dontCacheBustUrlsMatching) {
    // Create a new URL object to avoid modifying originalUrl.
    var url = new URL(originalUrl);

    // If dontCacheBustUrlsMatching is not set, or if we don't have a match,
    // then add in the extra cache-busting URL parameter.
    if (!dontCacheBustUrlsMatching ||
        !(url.toString().match(dontCacheBustUrlsMatching))) {
      url.search += (url.search ? '&' : '') +
        encodeURIComponent(paramName) + '=' + encodeURIComponent(paramValue);
    }

    return url.toString();
  };

var isPathWhitelisted = function (whitelist, absoluteUrlString) {
    // If the whitelist is empty, then consider all URLs to be whitelisted.
    if (whitelist.length === 0) {
      return true;
    }

    // Otherwise compare each path regex to the path of the URL passed in.
    var path = (new URL(absoluteUrlString)).pathname;
    return whitelist.some(function(whitelistedPathRegex) {
      return path.match(whitelistedPathRegex);
    });
  };

var stripIgnoredUrlParameters = function (originalUrl,
    ignoreUrlParametersMatching) {
    var url = new URL(originalUrl);

    url.search = url.search.slice(1) // Exclude initial '?'
      .split('&') // Split into an array of 'key=value' strings
      .map(function(kv) {
        return kv.split('='); // Split each 'key=value' string into a [key, value] array
      })
      .filter(function(kv) {
        return ignoreUrlParametersMatching.every(function(ignoredRegex) {
          return !ignoredRegex.test(kv[0]); // Return true iff the key doesn't match any of the regexes.
        });
      })
      .map(function(kv) {
        return kv.join('='); // Join each [key, value] array into a 'key=value' string
      })
      .join('&'); // Join the array of 'key=value' strings into a string with '&' in between each

    return url.toString();
  };


var hashParamName = '_sw-precache';
var urlsToCacheKeys = new Map(
  precacheConfig.map(function(item) {
    var relativeUrl = item[0];
    var hash = item[1];
    var absoluteUrl = new URL(relativeUrl, self.location);
    var cacheKey = createCacheKey(absoluteUrl, hashParamName, hash, false);
    return [absoluteUrl.toString(), cacheKey];
  })
);

function setOfCachedUrls(cache) {
  return cache.keys().then(function(requests) {
    return requests.map(function(request) {
      return request.url;
    });
  }).then(function(urls) {
    return new Set(urls);
  });
}

self.addEventListener('install', function(event) {
  event.waitUntil(
    caches.open(cacheName).then(function(cache) {
      return setOfCachedUrls(cache).then(function(cachedUrls) {
        return Promise.all(
          Array.from(urlsToCacheKeys.values()).map(function(cacheKey) {
            // If we don't have a key matching url in the cache already, add it.
            if (!cachedUrls.has(cacheKey)) {
              return cache.add(new Request(cacheKey, {credentials: 'same-origin'}));
            }
          })
        );
      });
    }).then(function() {
      
      // Force the SW to transition from installing -> active state
      return self.skipWaiting();
      
    })
  );
});

self.addEventListener('activate', function(event) {
  var setOfExpectedUrls = new Set(urlsToCacheKeys.values());

  event.waitUntil(
    caches.open(cacheName).then(function(cache) {
      return cache.keys().then(function(existingRequests) {
        return Promise.all(
          existingRequests.map(function(existingRequest) {
            if (!setOfExpectedUrls.has(existingRequest.url)) {
              return cache.delete(existingRequest);
            }
          })
        );
      });
    }).then(function() {
      
      return self.clients.claim();
      
    })
  );
});


self.addEventListener('fetch', function(event) {
  if (event.request.method === 'GET') {
    // Should we call event.respondWith() inside this fetch event handler?
    // This needs to be determined synchronously, which will give other fetch
    // handlers a chance to handle the request if need be.
    var shouldRespond;

    // First, remove all the ignored parameter and see if we have that URL
    // in our cache. If so, great! shouldRespond will be true.
    var url = stripIgnoredUrlParameters(event.request.url, ignoreUrlParametersMatching);
    shouldRespond = urlsToCacheKeys.has(url);

    // If shouldRespond is false, check again, this time with 'index.html'
    // (or whatever the directoryIndex option is set to) at the end.
    var directoryIndex = 'index.html';
    if (!shouldRespond && directoryIndex) {
      url = addDirectoryIndex(url, directoryIndex);
      shouldRespond = urlsToCacheKeys.has(url);
    }

    // If shouldRespond is still false, check to see if this is a navigation
    // request, and if so, whether the URL matches navigateFallbackWhitelist.
    var navigateFallback = '';
    if (!shouldRespond &&
        navigateFallback &&
        (event.request.mode === 'navigate') &&
        isPathWhitelisted([], event.request.url)) {
      url = new URL(navigateFallback, self.location).toString();
      shouldRespond = urlsToCacheKeys.has(url);
    }

    // If shouldRespond was set to true at any point, then call
    // event.respondWith(), using the appropriate cache key.
    if (shouldRespond) {
      event.respondWith(
        caches.open(cacheName).then(function(cache) {
          return cache.match(urlsToCacheKeys.get(url)).then(function(response) {
            if (response) {
              return response;
            }
            throw Error('The cached response that was expected is missing.');
          });
        }).catch(function(e) {
          // Fall back to just fetch()ing the request if some unexpected error
          // prevented the cached response from being valid.
          console.warn('Couldn\'t serve response for "%s" from cache: %O', event.request.url, e);
          return fetch(event.request);
        })
      );
    }
  }
});







